/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "panelBoxAxes.h"

#include <string.h>

#include <visu_object.h>
#include <openGLFunctions/view.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>
#include <coreTools/toolColor.h>
#include <extensions/scale.h>

/* Local callbacks. */
static void onBoxAxesEnter(ToolPanel *toolPanel, gpointer data);
static void scaleCheckChanged(GtkToggleButton *toggle, gpointer data);/*scale affiche legende*/
static void scaleDistanceChanged(GtkSpinButton *spin,gpointer data);/*pour paramatré la distance*/
static void scaleOriginChanged(GtkSpinButton *spin,gpointer data);/*pour parametré le point x de l'origine */
static void scaleOrientationChanged(GtkSpinButton *spin,gpointer data);/*pour paramatré le point x de l'orientation*/


static GtkWidget *panelBoxAxes;
static int disableCallbacksBoxAxes;
static GtkWidget *spindistance;
static GtkWidget *checkScaleIsOn;
static GtkWidget *originespinx;
static GtkWidget *originespiny;
static GtkWidget *originespinz;
static GtkWidget *orientationspinx;
static GtkWidget *orientationspiny;
static GtkWidget *orientationspinz;

ToolPanel* initPanelBoxAxes()
{
  /* Long description */
  char *cl = _("Box and axes");
  /* Short description */
  char *tl = _("Box & axes");

  panelBoxAxes = toolPanelNew("Panel_box_and_axes", cl, tl);
  if (!panelBoxAxes)
    return (ToolPanel*)0;
  gtk_container_add(GTK_CONTAINER(panelBoxAxes), createInteriorBoxAxes());
  toolPanelSet_dockable(TOOL_PANEL(panelBoxAxes), TRUE);

  /* Create the callbacks of all the sensitive widgets. */
  createCallBacksBoxAxes();
  g_signal_connect(G_OBJECT(panelBoxAxes), "page-entered",
		   G_CALLBACK(onBoxAxesEnter), (gpointer)0);

  /* Private parameters. */
  disableCallbacksBoxAxes = 0;

  return TOOL_PANEL(panelBoxAxes);
}

GtkWidget *createInteriorBoxAxes()
{
  GtkWidget *vbox, *hbox;
  GtkWidget *label;
  GtkWidget *table;
  GtkObject *adj;
  GtkObject *aju;


#define RED_LABEL   _("R:")
#define GREEN_LABEL _("G:")
#define BLUE_LABEL  _("B:")
  char *rgb[3];
  char *rgbName[3] = {"scroll_r", "scroll_g", "scroll_b"};
  int i;
  float xyz[3];

  rgb[0] = RED_LABEL;
  rgb[1] = GREEN_LABEL;
  rgb[2] = BLUE_LABEL;

  vbox = gtk_vbox_new(FALSE, 0);

  hbox = gtk_hbox_new(FALSE, 0);
  label = gtk_label_new(_("Draw a box :"));
  gtk_widget_set_name(label, "label_head");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  checkBoxIsOn = gtk_check_button_new();
  gtk_box_pack_start(GTK_BOX(hbox), checkBoxIsOn, FALSE, FALSE, 2);
  gtk_widget_show(checkBoxIsOn);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
  gtk_widget_show(hbox);

  hbox = gtk_hbox_new(FALSE, 0);
  label = gtk_label_new(_("Draw the axes :"));
  gtk_widget_set_name(label, "label_head");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  checkAxesAreOn = gtk_check_button_new();
  gtk_box_pack_start(GTK_BOX(hbox), checkAxesAreOn, FALSE, FALSE, 2);
  gtk_widget_show(checkAxesAreOn);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
  gtk_widget_show(hbox);

  table = gtk_table_new(3, 2, FALSE);
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 2);
  gtk_widget_show(table);
  for (i = 0; i < 3; i++)
    {
      label = gtk_label_new(rgb[i]);
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, i, i + 1,
		       GTK_SHRINK, GTK_SHRINK, 5, 0);
      gtk_widget_show(label);
      rgbBoxAndAxes[i] = gtk_hscale_new_with_range(0., 1., 0.001);
      gtk_scale_set_value_pos(GTK_SCALE(rgbBoxAndAxes[i]),
			      GTK_POS_RIGHT);
      gtk_widget_set_name(rgbBoxAndAxes[i], rgbName[i]);
      gtk_table_attach(GTK_TABLE(table), rgbBoxAndAxes[i],
		       1, 2, i, i + 1,
		       GTK_EXPAND | GTK_FILL, GTK_SHRINK, 5, 0);
      gtk_widget_show(rgbBoxAndAxes[i]);
    }


  hbox = gtk_hbox_new(FALSE, 0);
  label = gtk_label_new(_("Line width (1 to 10) : "));
  gtk_widget_set_name(label, "label_head");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  adj = gtk_adjustment_new(1., 1., 10., 1., 2.0, 2.0);
  spinLineWidth = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
  gtk_box_pack_start(GTK_BOX(hbox), spinLineWidth, FALSE, FALSE, 2);
  gtk_widget_show(spinLineWidth);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
  gtk_widget_show(hbox);

  /* Adding scale widgets. */
  hbox = gtk_hbox_new(FALSE, 0);
  label = gtk_label_new(_("Draw a scale:"));
  gtk_widget_set_name(label, "label_head");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  checkScaleIsOn = gtk_check_button_new();
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkScaleIsOn), scaleGet_isOn());
  gtk_box_pack_start(GTK_BOX(hbox), checkScaleIsOn, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);

  /* code yoann*/
  hbox = gtk_hbox_new(FALSE,0); /* je declare une nouvelle ligne*/
  label = gtk_label_new(_("Length:"));/*je conçois sont label*/
  gtk_widget_set_name(label,"label_head"); /*declare le nom du widget, label head pour avoire le meme type que les autre label*/
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 5); /*j'ouvre m'a nouvelle ligne et je commence a inseré mon objet*/
 
  aju = gtk_adjustment_new(scaleGet_length(), 1., 1000., 1., 5., 5.);/*je donne les valeur de la boite*/
  spindistance = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 0);/*je crée la boite*/
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(spindistance), 2);
  gtk_box_pack_start(GTK_BOX(hbox),spindistance, FALSE, FALSE, 0); 
  gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,5);

  table = gtk_table_new(3, 4, FALSE); /* je declare une nouvelle table*/
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 5); 

  label = gtk_label_new(_("Origin")); /* je cree le premier labelle*/
  gtk_widget_set_name(label,"label_head");
  gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);/*fonction pour placer le labelle a droite*/
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, /*je positionne le label */
                   GTK_FILL | GTK_EXPAND, (GtkAttachOptions)0, 5, 0);/*j'indique qu il peut prendre toute la place qu'il a besoins*/
  label = gtk_label_new(_("Orientation")); /* je crée le second label*/
  gtk_widget_set_name(label,"label_head");
  gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,/* je le positionne*/
                   GTK_FILL | GTK_EXPAND, (GtkAttachOptions)0, 5, 0);/* j'indique qui peut s etendre */
  label = gtk_label_new("X");
  gtk_widget_set_name(label,"label_head");
  gtk_table_attach(GTK_TABLE(table), label, 1, 2, 0, 1,
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 0, 0);
  label = gtk_label_new("Y");
  gtk_widget_set_name(label,"label_head");
  gtk_table_attach(GTK_TABLE(table), label, 2, 3, 0, 1,
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 0, 0);
  label = gtk_label_new("Z");
  gtk_widget_set_name(label,"label_head");
  gtk_table_attach(GTK_TABLE(table), label, 3, 4, 0, 1,
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 0, 0);

  scaleGet_origin(xyz);
  aju = gtk_adjustment_new(xyz[0], -10., 999.,1.,5.,5.); /*je donne une nouvelle valeur a l'objet aju*/
  originespinx = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 2);/*je crée un nouveau spin de type aju*/
  gtk_table_attach(GTK_TABLE(table), originespinx, 1, 2, 1, 2, /*je le positionnel dans le tableu*/
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 2, 0);
  aju = gtk_adjustment_new(xyz[1], -10., 999.,1.,5.,5.);
  originespiny = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 2);
  gtk_table_attach(GTK_TABLE(table), originespiny, 2, 3, 1, 2,
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 2, 0);
  aju = gtk_adjustment_new(xyz[2], -10., 999.,1.,5.,5.);
  originespinz = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 2);
  gtk_table_attach(GTK_TABLE(table), originespinz, 3, 4, 1, 2,
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 2, 0);

  scaleGet_orientation(xyz);
  aju = gtk_adjustment_new(xyz[0], -10., 999.,1.,5.,5.);
  orientationspinx = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 2);
  gtk_table_attach(GTK_TABLE(table), orientationspinx, 1, 2, 2, 3,
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 2, 0);
  aju = gtk_adjustment_new(xyz[1], -10., 999.,1.,5.,5.);
  orientationspiny = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 2);
  gtk_table_attach(GTK_TABLE(table), orientationspiny, 2, 3, 2, 3,
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 2, 0);
  aju = gtk_adjustment_new(xyz[2], -10., 999.,1.,5.,5.);
  orientationspinz = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 2);
  gtk_table_attach(GTK_TABLE(table), orientationspinz, 3, 4, 2, 3,
                   (GtkAttachOptions)0, (GtkAttachOptions)0, 2, 0);


  gtk_widget_show_all(vbox); /* fonctions qui permet de tous dessiner */

  return vbox;





}


void createCallBacksBoxAxes()
{
  int i;

  g_signal_connect((gpointer)spinLineWidth, "value-changed",
		   G_CALLBACK(lineWidthChanged), (gpointer)0);
  g_signal_connect((gpointer)checkBoxIsOn, "toggled",
		   G_CALLBACK(boxCheckChanged), (gpointer)0);
  g_signal_connect((gpointer)checkAxesAreOn, "toggled",
		   G_CALLBACK(axesCheckChanged), (gpointer)0);
 g_signal_connect((gpointer)spindistance, "value-changed",
                   G_CALLBACK(scaleDistanceChanged), (gpointer)0); /*pour la disantce*/

  g_signal_connect((gpointer) originespinx, "value-changed",
                   G_CALLBACK(scaleOriginChanged), GINT_TO_POINTER(0)); /*pour saisaire le point x de l origine*/

 g_signal_connect((gpointer) originespiny, "value-changed",
                   G_CALLBACK(scaleOriginChanged), GINT_TO_POINTER(1)); /*pour saisaire le point y de l origine*/

 g_signal_connect((gpointer) originespinz, "value-changed",
                   G_CALLBACK(scaleOriginChanged), GINT_TO_POINTER(2)); /*pour saisaire le point z de l origine*/

g_signal_connect((gpointer) orientationspinx, "value-changed", /* pour saisire le point x de l'orientation*/
                   G_CALLBACK(scaleOrientationChanged), GINT_TO_POINTER(0));

g_signal_connect((gpointer) orientationspiny, "value-changed", /* pour saisire le point y de l'orientation*/
                   G_CALLBACK(scaleOrientationChanged), GINT_TO_POINTER(1));

g_signal_connect((gpointer) orientationspinz, "value-changed", /* pour saisire le point z de l'orientation*/
                   G_CALLBACK(scaleOrientationChanged), GINT_TO_POINTER(2));

  for (i = 0; i < 3; i++)
    g_signal_connect((gpointer)rgbBoxAndAxes[i], "value-changed",
		     G_CALLBACK(changedRGBBoxAxes), GINT_TO_POINTER(i));
  g_signal_connect(G_OBJECT(checkScaleIsOn), "toggled",
                   G_CALLBACK(scaleCheckChanged), (gpointer)0);
 
}

/*************/
/* Callbacks */
/*************/
void boxCheckChanged(GtkToggleButton *button, gpointer data)
{
  VisuData *dataObj;

  if (disableCallbacksBoxAxes)
    return;

  if (boxSet_isOn(gtk_toggle_button_get_active(button)))
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelBoxAxes));
      if (!dataObj) 
	return;
      boxDraw(dataObj);
    }

  g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		 0 , NULL); 
}
void axesCheckChanged(GtkToggleButton *button, gpointer data)
{
  VisuData *dataObj;

  if (disableCallbacksBoxAxes)
    return;

  if (axesSet_areOn(gtk_toggle_button_get_active(button)))
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelBoxAxes));
      if (!dataObj) 
	return;
      axesDraw(dataObj);
    }

  g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		 0 , NULL); 
}
void lineWidthChanged(GtkSpinButton *spin, gpointer user_data)
{
  int res;
  VisuData *dataObj;

  if (disableCallbacksBoxAxes)
    return;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelBoxAxes));

  res = 0;
  if (boxSet_lineWidth((float)gtk_spin_button_get_value(spin)))
    {
      if (dataObj)
	{
	  boxDraw(dataObj);
	  res = 1;
	}
    }
  if (axesSet_lineWidth((float)gtk_spin_button_get_value(spin)))
    {
      if (dataObj)
	{
	  axesDraw(dataObj);
	  res = 1;
	}
    }
  if (res)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL); 
}
void changedRGBBoxAxes(GtkRange *rg, gpointer data)
{
  GtkAdjustment *adj;
  int rgbMask[3] = {MASK_RGB_R, MASK_RGB_G, MASK_RGB_B};
  float rgb[3];
  int res;
  VisuData *dataObj;

  if (disableCallbacksBoxAxes)
    return;

  adj = gtk_range_get_adjustment(rg);
  if (GPOINTER_TO_INT(data) < 0 || GPOINTER_TO_INT(data) > 2)
    {
      fprintf(stderr, "INTERNAL ERROR! The numbering of color"
	      " (%d) is inconsistent. It must be in[|0;2|].\n", GPOINTER_TO_INT(data));
      return;
    }
  rgb[GPOINTER_TO_INT(data)] = (float)gtk_adjustment_get_value(adj);
  
  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelBoxAxes));
  res = 0;
  if (boxSet_RGBValues(rgb, rgbMask[GPOINTER_TO_INT(data)]))
    {
      if (dataObj)
	{
	  boxDraw(dataObj);
	  res = 1;
	}
    }
  if (axesSet_RGBValues(rgb, rgbMask[GPOINTER_TO_INT(data)]))
    {
      if (dataObj)
	{
	  axesDraw(dataObj);
	  res = 1;
	}
    }
  if (res)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL); 
}
static void onBoxAxesEnter(ToolPanel *toolPanel, gpointer data)
{
  int i;
  float rgb[3];
  float xyz[3];

  disableCallbacksBoxAxes = 1;
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinLineWidth),
			    boxGet_lineWidth());
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkBoxIsOn),
			       (gboolean)boxGet_isOn());
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkAxesAreOn),
			       (gboolean)axesGet_areOn());
  rgb[0] = boxGet_redValue();
  rgb[1] = boxGet_greenValue();
  rgb[2] = boxGet_blueValue();
  for (i = 0; i < 3; i++)
    gtk_range_set_value(GTK_RANGE(rgbBoxAndAxes[i]), (gdouble)rgb[i]);
  disableCallbacksBoxAxes = 0;

  /* Set the scale values. */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkScaleIsOn), scaleGet_isOn());

  scaleGet_origin(xyz);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(originespinx), xyz[0]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(originespiny), xyz[1]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(originespinz), xyz[2]);

  scaleGet_orientation(xyz);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(orientationspinx), xyz[0]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(orientationspiny), xyz[1]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(orientationspinz), xyz[2]);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spindistance), scaleGet_length());
}
static void scaleCheckChanged(GtkToggleButton *toggle, gpointer data)
{
  int res;
  VisuData *dataObj;

  if (gtk_toggle_button_get_active(toggle))
    res = scaleSet_isOn(1);
  else
    res = scaleSet_isOn(0);

  if (res)
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelBoxAxes));
      if (!dataObj) 
	return;
      scaleDraw(dataObj);
    }
  g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
                 0 , NULL);
}

static void scaleDistanceChanged(GtkSpinButton *spin, gpointer data)
{
  int res;
  VisuData *dataObj;

  DBG_fprintf(stderr, "Panel Box&axes: scale distance changed.\n");
  res = scaleSet_length((float)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin)));

  if (res)
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelBoxAxes));
      if (!dataObj) 
	return;
      scaleDraw(dataObj);
      g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		     0 , NULL);
    }
}

static void scaleOriginChanged(GtkSpinButton *spin, gpointer data)
{
  int res;
  VisuData *dataObj;
  int xyzMask[3] = {MASK_XYZ_X, MASK_XYZ_Y, MASK_XYZ_Z};
  float xyz[3];
  int val;

  val = GPOINTER_TO_INT(data);
  g_return_if_fail(val >= 0 && val < 3);

  DBG_fprintf(stderr, "Panel Box&axes: scale origine %d change.\n", val);
  xyz[val] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin));
  res = scaleSet_origin(xyz, xyzMask[val]);

  if (res)
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelBoxAxes));
      if (!dataObj)
	return;
      scaleDraw(dataObj);
      g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		     0 , NULL);
    }
}

static void scaleOrientationChanged(GtkSpinButton *spin, gpointer data)
{
  int res;
  VisuData *dataObj;
  int xyzMask[3] = {MASK_XYZ_X, MASK_XYZ_Y, MASK_XYZ_Z};
  float xyz[3];
  int val;

  val = GPOINTER_TO_INT(data);
  g_return_if_fail(val >= 0 && val < 3);

  DBG_fprintf(stderr, "Panel Box&axes: scale orientation %d changed.\n", val);
  xyz[val] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin));
  res = scaleSet_orientation(xyz, xyzMask[val]);

  if (res)
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelBoxAxes));
      if (!dataObj) 
	return;
      scaleDraw(dataObj);
      g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		     0 , NULL);
    }
}
