/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "panelFogBgColor.h"

#include <visu_tools.h>
#include <visu_object.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>
#include <coreTools/toolColor.h>

/* Local callbacks. */
static void onFogBgEnter(ToolPanel *toolPanel, gpointer data);


static GtkWidget *panelFogBgColor;
static int disableCallbacksFogBgColor;

ToolPanel* initPanelFogBgColor()
{
  char *cl = _("Fog and background color");
  char *tl = _("Fog & bg");

  panelFogBgColor = toolPanelNew("Panel_fog_and_bg_color", cl, tl);
  if (!panelFogBgColor)
    return (ToolPanel*)0;
  gtk_container_add(GTK_CONTAINER(panelFogBgColor), createInteriorFogBgColor());
  toolPanelSet_dockable(TOOL_PANEL(panelFogBgColor), TRUE);

  /* Create the callbacks of all the sensitive widgets. */
  createCallBacksFogBgColor();
  g_signal_connect(G_OBJECT(panelFogBgColor), "page-entered",
		   G_CALLBACK(onFogBgEnter), (gpointer)0);

  /* Private parameters. */
  disableCallbacksFogBgColor = 0;

  return TOOL_PANEL(panelFogBgColor);
}

GtkWidget *createInteriorFogBgColor()
{
  GtkWidget *vbox, *hbox;
  GtkWidget *label;
  GtkWidget *table;
#define RED_LABEL   _("R:")
#define GREEN_LABEL _("G:")
#define BLUE_LABEL  _("B:")
  char *rgb[3];
  char *rgbName[3] = {"scroll_r", "scroll_g", "scroll_b"};
  int i;

  rgb[0] = RED_LABEL;
  rgb[1] = GREEN_LABEL;
  rgb[2] = BLUE_LABEL;

  vbox = gtk_vbox_new(FALSE, 0);

  table = gtk_table_new(4, 2, FALSE);
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 5);
  gtk_widget_show(table);
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_table_attach(GTK_TABLE(table), hbox, 0, 2, 0, 1,
		   GTK_EXPAND | GTK_FILL, GTK_SHRINK, 0, 2);
  gtk_widget_show(hbox);
  label = gtk_label_new(_("Background color :"));
  gtk_widget_set_name(label, "label_head");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  for (i = 0; i < 3; i++)
    {
      label = gtk_label_new(rgb[i]);
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, i + 1, i + 2,
		       GTK_SHRINK, GTK_SHRINK, 5, 0);
      gtk_widget_show(label);
      rgbBgColor[i] = gtk_hscale_new_with_range(0., 1., 0.001);
      gtk_scale_set_value_pos(GTK_SCALE(rgbBgColor[i]),
			      GTK_POS_RIGHT);
      gtk_widget_set_name(rgbBgColor[i], rgbName[i]);
      gtk_table_attach(GTK_TABLE(table), rgbBgColor[i],
		       1, 2, i + 1, i + 2,
		       GTK_EXPAND | GTK_FILL, GTK_SHRINK, 5, 0);
      gtk_widget_show(rgbBgColor[i]);
    }


  hbox = gtk_hbox_new(FALSE, 0);
  label = gtk_label_new(_("Use fog :"));
  gtk_widget_set_name(label, "label_head");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  checkFogIsOn = gtk_check_button_new();
  gtk_box_pack_start(GTK_BOX(hbox), checkFogIsOn, FALSE, FALSE, 2);
  gtk_widget_show(checkFogIsOn);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
  gtk_widget_show(hbox);

  
  table = gtk_table_new(2, 2, FALSE);
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 5);
  gtk_widget_show(table);
  label = gtk_label_new(_("Start :"));
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
		   GTK_SHRINK, GTK_SHRINK, 5, 0);
  gtk_widget_show(label);
  rangeFogStart = gtk_hscale_new_with_range(0., 100., 0.1);
  gtk_scale_set_value_pos(GTK_SCALE(rangeFogStart),
			  GTK_POS_RIGHT);
  gtk_table_attach(GTK_TABLE(table), rangeFogStart,
		   1, 2, 0, 1,
		   GTK_EXPAND | GTK_FILL, GTK_SHRINK, 5, 0);
  gtk_widget_show(rangeFogStart);
  label = gtk_label_new(_("End :"));
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
		   GTK_SHRINK, GTK_SHRINK, 5, 0);
  gtk_widget_show(label);
  rangeFogEnd = gtk_hscale_new_with_range(0., 100., 0.1);
  gtk_scale_set_value_pos(GTK_SCALE(rangeFogEnd),
			  GTK_POS_RIGHT);
  gtk_table_attach(GTK_TABLE(table), rangeFogEnd,
		   1, 2, 1, 2,
		   GTK_EXPAND | GTK_FILL, GTK_SHRINK, 5, 0);
  gtk_widget_show(rangeFogEnd);


  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
  gtk_widget_show(hbox);
  label = gtk_label_new(_("Color :"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  radioBgFog = gtk_radio_button_new_with_label(NULL, _("background color"));
  gtk_box_pack_start(GTK_BOX(hbox), radioBgFog, FALSE, FALSE, 2);
  gtk_widget_show(radioBgFog);
  radioOtherFog =
    gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radioBgFog),
						_("specific color"));
  gtk_box_pack_start(GTK_BOX(hbox), radioOtherFog, FALSE, FALSE, 2);
  gtk_widget_show(radioOtherFog);

  table = gtk_table_new(4, 2, FALSE);
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 5);
  gtk_widget_show(table);
  for (i = 0; i < 3; i++)
    {
      label = gtk_label_new(rgb[i]);
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, i + 1, i + 2,
		       GTK_SHRINK, GTK_SHRINK, 5, 0);
      gtk_widget_show(label);
      rgbFogColor[i] = gtk_hscale_new_with_range(0., 1., 0.001);
      gtk_scale_set_value_pos(GTK_SCALE(rgbFogColor[i]),
			      GTK_POS_RIGHT);
      gtk_widget_set_sensitive(rgbFogColor[i], FALSE);
      gtk_widget_set_name(rgbFogColor[i], rgbName[i]);
      gtk_table_attach(GTK_TABLE(table), rgbFogColor[i],
		       1, 2, i + 1, i + 2,
		       GTK_EXPAND | GTK_FILL, GTK_SHRINK, 5, 0);
      gtk_widget_show(rgbFogColor[i]);
    }


  gtk_widget_show(vbox);

  return vbox;
}

void createCallBacksFogBgColor()
{
  int i;

  g_signal_connect((gpointer)checkFogIsOn, "toggled",
		   G_CALLBACK(fogCheckChanged), (gpointer)0);
  for (i = 0; i < 3; i++)
    g_signal_connect((gpointer)rgbBgColor[i], "value-changed",
		     G_CALLBACK(changedRGBBgColor), GINT_TO_POINTER(i));
  g_signal_connect((gpointer)radioBgFog, "toggled",
		   G_CALLBACK(radioBgChanged), (gpointer)0);
  for (i = 0; i < 3; i++)
    g_signal_connect((gpointer)rgbFogColor[i], "value-changed",
		     G_CALLBACK(changedRGBFogColor), GINT_TO_POINTER(i));
  g_signal_connect((gpointer)rangeFogStart, "value-changed",
		   G_CALLBACK(changedFogStart), (gpointer)0);
  g_signal_connect((gpointer)rangeFogEnd, "value-changed",
		   G_CALLBACK(changedFogEnd), (gpointer)0);
}

/*************/
/* Callbacks */
/*************/
void fogCheckChanged(GtkToggleButton *button, gpointer data)
{
  VisuData *dataObj;

  if (disableCallbacksFogBgColor)
    return;

  if (setFogIsOn(gtk_toggle_button_get_active(button)))
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelFogBgColor));
      if (!dataObj) 
	return;
      createFog(dataObj);
    }

  g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		 0 , NULL); 
}
void changedRGBBgColor(GtkRange *rg, gpointer data)
{
  GtkAdjustment *adj;
  int rgbMask[3] = {MASK_RGB_R, MASK_RGB_G, MASK_RGB_B};
  float rgb[3];

  if (disableCallbacksFogBgColor)
    return;

  adj = gtk_range_get_adjustment(rg);
  if (GPOINTER_TO_INT(data) < 0 || GPOINTER_TO_INT(data) > 2)
    {
      fprintf(stderr,"INTERNAL ERROR! The numbering of color"
	      " (%d) is inconsistent. It must be in[|0;2|].\n", GPOINTER_TO_INT(data));
      return;
    }
  rgb[GPOINTER_TO_INT(data)] = (float)gtk_adjustment_get_value(adj);
  
  if (setBgRGBValues(rgb, rgbMask[GPOINTER_TO_INT(data)]))
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL); 
}
void changedFogStart(GtkRange *rg, gpointer data)
{
  GtkAdjustment *adj;
  float val[2];
  VisuData *dataObj;

  if (disableCallbacksFogBgColor)
    return;

  adj = gtk_range_get_adjustment(rg);
  val[0] = (float)gtk_adjustment_get_value(adj);
  if (val[0] / 100. >= getFogEnd() - 0.001)
    {
      gtk_adjustment_set_value(adj, (gdouble)getFogEnd() * 100. - 0.1);
      val[0] = getFogEnd() - 0.001;
    }
  else
    val[0]= val[0] / 100.;
  
  if (setFogStartEndValues(val, MASK_FOG_START))
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelFogBgColor));
      if (!dataObj) 
	return;
      createFog(dataObj);
      g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		     0 , NULL); 
    }
}
void changedFogEnd(GtkRange *rg, gpointer data)
{
  GtkAdjustment *adj;
  float val[2];
  VisuData *dataObj;

  if (disableCallbacksFogBgColor)
    return;

  adj = gtk_range_get_adjustment(rg);
  val[1] = (float)gtk_adjustment_get_value(adj);
  if (val[1] / 100. <= getFogStart() + 0.001)
    {
      gtk_adjustment_set_value(adj, (gdouble)getFogStart() * 100. + 0.1);
      val[1] = getFogStart() + 0.001;
    }
  else
    val[1]= val[1] / 100.;
  
  if (setFogStartEndValues(val, MASK_FOG_END))
    {
      dataObj = toolPanelGet_visuData(TOOL_PANEL(panelFogBgColor));
      if (!dataObj) 
	return;
      createFog(dataObj);
      g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		     0 , NULL); 
    }
}
void radioBgChanged(GtkToggleButton *button, gpointer data)
{
  int fogBg;
  int i;
  int res;

  if (disableCallbacksFogBgColor)
    return;

  fogBg = gtk_toggle_button_get_active(button);
  if (fogBg)
    {
      res = setFogColorSpecific(0);
      for (i = 0; i < 3; i++)
	gtk_widget_set_sensitive(rgbFogColor[i], FALSE);
    }
  else
    {
      res = setFogColorSpecific(1);
      for (i = 0; i < 3; i++)
	gtk_widget_set_sensitive(rgbFogColor[i], TRUE);
    }
  if (res)
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL); 
}
void changedRGBFogColor(GtkRange *rg, gpointer data)
{
  GtkAdjustment *adj;
  int rgbMask[3] = {MASK_RGB_R, MASK_RGB_G, MASK_RGB_B};
  float rgb[3];

  if (disableCallbacksFogBgColor)
    return;

  adj = gtk_range_get_adjustment(rg);
  if (GPOINTER_TO_INT(data) < 0 || GPOINTER_TO_INT(data) > 2)
    {
      fprintf(stderr,"INTERNAL ERROR! The numbering of color"
	      " (%d) is inconsistent. It must be in[|0;2|].\n", GPOINTER_TO_INT(data));
      return;
    }
  rgb[GPOINTER_TO_INT(data)] = (float)gtk_adjustment_get_value(adj);
  
  if (setFogRGBValues(rgb, rgbMask[GPOINTER_TO_INT(data)]))
    g_signal_emit (visu, VISU_GET_CLASS (visu)->OpenGLAskForReDraw_signal_id,
		   0 , NULL); 
}
static void onFogBgEnter(ToolPanel *toolPanel, gpointer data)
{
  int i;
  float rgb[3];

  disableCallbacksFogBgColor = 1;
  DBG_fprintf(stderr, "Panel Fog & bg : refresh data on enter.\n");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkFogIsOn),
			       (gboolean)isFogOn());
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioOtherFog),
			       (gboolean)getFogColorSpecific());
  rgb[0] = getBgRedValue();
  rgb[1] = getBgGreenValue();
  rgb[2] = getBgBlueValue();
  for (i = 0; i < 3; i++)
    gtk_range_set_value(GTK_RANGE(rgbBgColor[i]), (gdouble)rgb[i]);
  rgb[0] = getFogRedValue();
  rgb[1] = getFogGreenValue();
  rgb[2] = getFogBlueValue();
  for (i = 0; i < 3; i++)
    gtk_range_set_value(GTK_RANGE(rgbFogColor[i]), (gdouble)rgb[i]);
  gtk_range_set_value(GTK_RANGE(rangeFogStart), (gdouble)getFogStart() * 100.);
  gtk_range_set_value(GTK_RANGE(rangeFogEnd), (gdouble)getFogEnd() * 100.);
  disableCallbacksFogBgColor = 0;
}
