/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef PANELPLANES_H
#define PANELPLANES_H

#include <glib.h>
#include <gtk/gtk.h>
#include <visu_data.h>

/**
 * PanelPlanesColumnId:
 * @COLUMN_PLANE_DRAWN: a boolean, code if the plane is drawn or not.
 * @COLUMN_PLANE_LABEL: a string, the description of the plane (normal vector
 *                      and distance to origin).
 * @COLUMN_PLANE_HIDE_IS_ON: a boolean, code if the plane hide elements on one side.
 * @COLUMN_PLANE_HIDDEN_SIDE: a boolean, code for the side.
 * @COLUMN_PLANE_COLOR_PIXBUF: a pixbuf, a small colored square.
 * @COLUMN_PLANE_POINTER: the pointer to the #Plane object.
 * @N_COLUMN_PLANE: the number of columns.
 *
 * Thesse are the description of the columns stored in the #GtkListStore
 * of this panel. See panelPlanesGet_listStore() to access this liststore.
 */
typedef enum
  {
    COLUMN_PLANE_DRAWN,
    COLUMN_PLANE_LABEL,
    COLUMN_PLANE_HIDE_IS_ON,
    COLUMN_PLANE_HIDDEN_SIDE,
    COLUMN_PLANE_COLOR_PIXBUF,
    COLUMN_PLANE_POINTER,
    N_COLUMN_PLANE
  } PanelPlanesColumnId;

/**
 * panelPlanesLoad_file:
 * @dataObj: a #VisuData object to associate the planes to (required
 *           to compute the intersection with the bounding box) ;
 * @filename: the path to the file to load ;
 * @error: a pointer to a GError handler to reccord possible failure.
 *
 * This method is used to parse and load an XML file containing
 * planes informations. The panel must have been initialised before
 * calling this method. The @error argument is required (can't be NULL),
 * since it is set if something went wrong.
 *
 * Returns: TRUE if panelPlanesApply_hidingScheme().
 */
gboolean panelPlanesLoad_file(VisuData *dataObj, gchar *filename, GError **error);
/**
 * panelPlanesSet_use:
 * @dataObj: a #VisuData object to associate the planes to (required
 *           to compute the intersection with the bounding box) ;
 * @value: a boolean.
 *
 * When @value is TRUE, the planes are used and drawn. If the panel
 *  has not been created yet, a call to this function will do it.
 *
 * Returns: TRUE if the status of the planes has been changed by this method.
 */
gboolean panelPlanesSet_use(VisuData *dataObj, gboolean value);
/**
 * panelPlanesApply_hidingScheme:
 * @data: a #VisuData object to associate the planes to (required
 *        to compute the intersection with the bounding box) ;
 *
 * Use this method to hide nodes according to current list of planes
 * and hiding policy.
 *
 * Returns: TRUE if visuData_createAllNodes() should be called and the
 * redraw signal emitted.
 */
gboolean panelPlanesApply_hidingScheme(VisuData *data);
/**
 * panelPlanesGet_listStore:
 * 
 * This method gives read access to the #GtkListStore used to store
 * the planes.
 *
 * Returns: the #GtkListStore used by this panel to store its planes.
 *          It should be considered read-only.
 */
GtkListStore* panelPlanesGet_listStore();

#endif
