/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_PICKMESURE_H
#define VISU_PICKMESURE_H

#include "openGLFunctions/interactive.h"

/* Pick methods to mesure distance and angles. */

/**
 * PickMesure_struct:
 *
 * Opaque structure that store the pick informations.
 */
struct PickMesure_struct;
/**
 * PickMesure:
 *
 *Short way to address #PickMesure_struct objects.
 */
typedef struct PickMesure_struct PickMesure;


/**
 * marksAndMesures:
 * @info: some #VisuPick informations ;
 * @data: a location on an allocated #PickMesure structure.
 *
 * The @info argument contains which element has been picked and static values
 * are adapted accordingly. Strings ae created to represent the return of the mesure.
 * These strings are available with a call to getPickMesureInfos() and getPickMesureErrors().
 * When this method is given as argument to initPickObserve(), for instance, the associated
 * user data must be an allocated #PickMesure object.
 */
void marksAndMesures(const VisuPick *info, gpointer data);
/**
 * getPickMesureInfos:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about picked nodes.
 *
 * When a pick session is running with the format flag (see initPickMesure() for deatils),
 * calls to marksAndMesures() create strings that represnt the values of the mesure.
 * These values are retrievable with this method.
 *
 * Returns: a string (own by V_Sim, should not be freed).
 */
gchar* getPickMesureInfos(PickMesure *mesureData);
/**
 * getPickMesureErrors:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about picked nodes.
 *
 * When a pick session is running with the format flag (see initPickMesure() for deatils),
 * calls to marksAndMesures() create strings that represnt the values of the mesure.
 * If error occurs, they are retrievable with this method.
 *
 * Returns: a string (own by V_Sim, should not be freed).
 */
gchar* getPickMesureErrors(PickMesure *mesureData);
/**
 * pickMesureGet_newsAvailable:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about picked nodes.
 * 
 * When a pick is done, maybe nothing interesting happen, get informed with this method.
 *
 * Returns: TRUE if values stored in the given @mesureData have changed.
 */
gboolean pickMesureGet_newsAvailable(PickMesure *mesureData);
/**
 * pickMesureRemove_allMarks:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about Nodes with marks that need to be erased.
 *
 * Erase all marks corresponding to given object.
 *
 * Returns: TRUE if the "OpenGLAskForReDraw" signal show be emitted.
 */
gboolean pickMesureRemove_allMarks(PickMesure *mesureData);
/**
 * pickMesureGet_selectedNode:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about picked nodes.
 * 
 * The selected node is a node selected by a normal pick, i.e. neither
 * a first nor a second reference.
 *
 * Returns: the last selected node, or NULL if none.
 */
VisuNode* pickMesureGet_selectedNode(PickMesure *mesureData);
/**
 * pickMesureGet_firstReference:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about picked nodes.
 * 
 * The first reference is a store node.
 *
 * Returns: the node that has been picked as first reference, or NULL if none.
 */
VisuNode* pickMesureGet_firstReference(PickMesure *mesureData);
/**
 * pickMesureRemove_allDistanceMarks:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about picked nodes.
 * 
 * Call this method to erase all previously marked distances.
 *
 * Returns: TRUE if the "OpenGLAskForReDraw" signal show be emitted.
 */
gboolean pickMesureRemove_allDistanceMarks(PickMesure *mesureData);
/**
 * pickMesureSet_storeDistance:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about picked nodes ;
 * @storeDistance: a boolean.
 *
 * If this flag is TRUE, distance marks are used. If FALSE, only future distance
 * marks are disable. Previously stored distance marks are kept, use
 * pickMesureRemove_allDistanceMarks() to remove them all.
 */
void pickMesureSet_storeDistance(PickMesure *mesureData, gboolean storeDistance);
/**
 * pickMesureSet_formatedOutput:
 * @mesureData: a #PickMesure structure that contains the informations
 *              about picked nodes ;
 * @formatedOutput: a boolean.
 *
 * If this flag is TRUE, one can retrieve some formatted output using the getPickMesureInfos()
 * and getPickMesureErrors() methods.
 */
void pickMesureSet_formatedOutput(PickMesure *mesureData, gboolean formatedOutput);
/**
 * pickMesureUpdate:
 * @newData: a #VisuData object (can be NULL) ;
 * @oldData: a #VisuData object (can be NULL).
 *
 * This method try to retrieve a #PickMesure object associated to each 
 * given #VisuData object and to update the marks and distances on
 * the new from the values of the old.
 */
void pickMesureUpdate(VisuData *newData, VisuData *oldData);

/**
 * initPick_module:
 *
 * Call by V_Sim on startup, don't use it.
 */
void initPick_module();


#endif
