/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "support.h"
#include "interface.h"
#include "gtk_interactive.h"
#include "gtk_main.h"
#include "visu_object.h"
#include "visu_pickMesure.h"

#include "gtk_pick.h"
#include "gtk_move.h"
#include "gtk_renderingWindowWidget.h"
#include "renderingBackend/visu_windowInterface.h"
#include "openGLFunctions/interactive.h"
#include "extraGtkFunctions/gtk_numericalEntryWidget.h"
#include "extraGtkFunctions/gtk_orientationChooser.h"

static GtkInteractiveActionId currentAction;

/* Callbacks. */
static void onNewData(GObject *obj, VisuData *dataObj, gpointer data);
static void onVisuData(GObject *obj, VisuData *dataObj, gpointer data);
static void observeMethodChanged(GtkToggleButton* button, gpointer data);
static void radioObserveToggled(GtkToggleButton *togglebutton, gpointer user_data);
static void radioPickToggled(GtkToggleButton *togglebutton, gpointer user_data);
static void radioMoveToggled(GtkToggleButton *togglebutton, gpointer user_data);
static void radioMarkToggled(GtkToggleButton *togglebutton, gpointer user_data);
static void onCloseButtonClicked(GtkButton *button, gpointer user_data);
static void refreshCameraSpinValues(VisuData *obj, OpenGLView *view, gpointer data);
static void onTabActionChanged(GtkNotebook *book, GtkNotebookPage *page,
			       guint num, gpointer data);
static void onEraseMarksClicked(GtkButton *button, gpointer user_data);
static void onOrientationChooser(GtkButton *button, gpointer data);
static void onAngleChanged(GtkSpinButton *spin, gpointer data);
static void onTranslationChanged(GtkSpinButton *spin, gpointer data);
static void onZoomChanged(GtkSpinButton *spin, gpointer data);
static void onPerspChanged(GtkSpinButton *spin, gpointer data);
static void gtkObservePick_marks(PickMesure *pickMesure, gpointer data);

/* Local methods. */
static void setSensitiveActionSensitive(GtkInteractiveActionId id);
static void connectSignalsObservePick();
static void setNamesGtkWidgetObservePick(GtkMain *main);


/* Widgets */
static GtkWidget *observeWindow;
static GtkWidget *orientationChooser;
static GtkWidget *spinTheta, *spinPhi, *spinOmega;
static GtkWidget *spinXs, *spinYs;
static GtkWidget *spinGross;
static GtkWidget *spinPersp;


/* Help message used in the help area. */
#define GTK_PICKOBSERVE_OBSERVE_INFO \
  _("left-[Control]-button\t\t\t: rotations "				\
    "(\316\270, \317\206, [Control]\317\211)\n"				\
    "shift-left-button\t\t\t\t: translations (dx, dy)\n"		\
    "middle-[Shift]-button or wheel\t: zoom or [Shift]perspective\n"	\
    "key 's' / 'r'\t\t\t\t\t: save/restore camera position\n"		\
    "right-button\t\t\t\t\t: switch to current tabbed action")
#define GTK_PICKOBSERVE_PICK_INFO				\
  _("left-button\t\t\t: standard pick\n"			\
    "middle-button\t\t: pick 1st reference\n"			\
    "shift-middle-button\t: pick 2nd reference\n"		\
    "drag-left-button\t\t: make a rectangular selection\n"	\
    "right-button\t\t\t: switch to observe")
#define GTK_PICKOBSERVE_MOVE_INFO				\
  _("left-button\t\t: drag node(s) in the screen plane\n"	\
    "shift-left-button\t: drag node(s) along x or y axis\n"	\
    "control-left-button\t: drag node(s) along z axis\n"	\
    "right-button\t\t: switch to observe")
#define GTK_PICKOBSERVE_MARK_INFO		\
  _("left-button\t: select (unselect) a node\n"	\
    "right-button\t: switch to observe")
static char *markupObserveHelp, *markupPickHelp, *markupMoveHelp, *markupMarkHelp;

/* Flag used to block callbacks when changing are done. */
static gboolean flagDisableChangePickObserve;


/* Initialise the observe/pick window, connect the
   signals, give names to widgets... */
void gtkInteractiveInit()
{
  orientationChooser = (GtkWidget*)0;
}

void gtkInteractiveBuild_window(GtkMain *main)
{
  GtkWidget *labelHelp;
  RenderingWindow *window;
  VisuData *data;
 
  window = visuRenderingWindowGet_current();
  g_return_if_fail(window);
  data = renderingWindowGet_visuData(window);
  g_return_if_fail(data);

  DBG_fprintf(stderr, "Gtk observePick : creating the window.\n");
  main->interactiveDialog = create_observeDialog();
  observeWindow = main->interactiveDialog;
  gtk_window_set_type_hint(GTK_WINDOW(main->interactiveDialog),
			   GDK_WINDOW_TYPE_HINT_NORMAL);
  setNamesGtkWidgetObservePick(main);
  /* Create and Set the help text. */
  markupObserveHelp = g_markup_printf_escaped("<span size=\"smaller\">%s</span>",
					      GTK_PICKOBSERVE_OBSERVE_INFO);
  markupPickHelp = g_markup_printf_escaped("<span size=\"smaller\">%s</span>",
					    GTK_PICKOBSERVE_PICK_INFO);
  markupMoveHelp = g_markup_printf_escaped("<span size=\"smaller\">%s</span>",
					    GTK_PICKOBSERVE_MOVE_INFO);
  markupMarkHelp = g_markup_printf_escaped("<span size=\"smaller\">%s</span>",
					    GTK_PICKOBSERVE_MARK_INFO);
  labelHelp = lookup_widget(main->interactiveDialog, "labelInfoObservePick");
  gtk_label_set_markup(GTK_LABEL(labelHelp), markupObserveHelp);
  currentAction = action_observe;

  /* Create the pick/move parts. */
  gtkPickBuild_interface(main);
  gtkMoveBuild_interface(main);

  /* connect the signals to the spins. */
  connectSignalsObservePick(main);
  onNewData((GObject*)0, data, (gpointer)0);
  /* set the initial values for the spins. */
  refreshCameraSpinValues((VisuData*)0, visuDataGet_openGLView(data), (gpointer)0);
}

/* Methods dealing with observe & pick session. */
void stopPickObserveGtk()
{
  GtkWidget *wd;
  gint id;

  if (flagDisableChangePickObserve)
    return;

  wd = (GtkWidget*)0;
  if (currentAction == action_observe)
    {
      wd = lookup_widget(observeWindow, "notebookAction");
      id = gtk_notebook_get_current_page(GTK_NOTEBOOK(wd));
      switch (id + 1)
	{
	case action_pick:
	  wd = lookup_widget(observeWindow, "radioPick");
	  break;
	case action_move:
	  wd = lookup_widget(observeWindow, "radioMove");
	  break;
	case action_mark:
	  wd = lookup_widget(observeWindow, "radioSelect");
	  break;
	default:
	  wd = (GtkWidget*)0;
	};
    }
  else
    wd = lookup_widget(observeWindow, "radioObserve");

  if (wd)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wd), TRUE);
}

static void gtkObservePick_marks(PickMesure *pickMesure, gpointer data _U_)
{
  if (currentAction == action_pick)
    gtkPickUpdate_informations(pickMesure);
  else if (currentAction == action_move)
    gtkMoveUpdate_informations(pickMesure);
  else if (currentAction == action_mark)
    g_idle_add(visuObjectRedraw, GINT_TO_POINTER(1));
}

void gtkInteractiveInit_session()
{
  VisuInteractive *inter;
  VisuData *data;

  DBG_fprintf(stderr, "Gtk Interactive: initialise session.\n");
  renderingWindowBlock_defaultIneractiveMode(RENDERING_WINDOW(currentRenderingWindow));
  renderingWindowPush_message(RENDERING_WINDOW(currentRenderingWindow), "");

  data = renderingWindowGet_visuData(RENDERING_WINDOW(currentRenderingWindow));
  g_return_if_fail(data);

  inter = openGLInteractiveInit_session((GenericRenderingWindow)currentRenderingWindow,
					gtkObservePick_marks, (gpointer)data,
					stopPickObserveGtk);
  pickMesureSet_formatedOutput(openGLInteractiveGet_pickMesure(inter), TRUE);
  g_object_set_data(G_OBJECT(observeWindow), "visuInteractive_data", (gpointer)inter);

  setSensitiveActionSensitive(currentAction);
  switch (currentAction)
    {
    case action_observe:
      openGLInteractiveBegin_observe(inter);
      break;
    case action_pick:
      openGLInteractiveBegin_pick(inter);
      break;
    case action_move:
      openGLInteractiveBegin_move(inter);
      break;
    case action_mark:
      openGLInteractiveBegin_mark(inter);
      break;
    }
  flagDisableChangePickObserve = FALSE;
}

static void onCloseButtonClicked(GtkButton *button _U_, gpointer user_data _U_)
{
  if (!GTK_WIDGET_VISIBLE(observeWindow))
    return;

  DBG_fprintf(stderr, "Gtk interactive: click on close button.\n");

  gtkPick_onClose();

  flagDisableChangePickObserve = TRUE;
  openGLInteractiveEnd_session((VisuInteractive*)g_object_get_data
			       (G_OBJECT(observeWindow), "visuInteractive_data"));

  renderingWindowPop_message(RENDERING_WINDOW(currentRenderingWindow));
  renderingWindowUnblock_defaultIneractiveMode(RENDERING_WINDOW(currentRenderingWindow));
}

static void setSensitiveObserve(gboolean value)
{
  GtkWidget *wd;

  wd = lookup_widget(observeWindow, "hboxObserve");
  gtk_widget_set_sensitive(wd, value);
  wd = lookup_widget(observeWindow, "tableObserve");
  gtk_widget_set_sensitive(wd, value);
  if (openGLInteractiveGet_preferedObserveMethod() == OPENGL_OBSERVE_CONSTRAINED)
    gtk_widget_set_sensitive(spinOmega, FALSE);
  else
    gtk_widget_set_sensitive(spinOmega, value);
}
static void setSensitiveMove(gboolean value)
{
  GtkWidget *wd;

  wd = lookup_widget(observeWindow, "alignment27");
  gtk_widget_set_sensitive(wd, value);
  wd = lookup_widget(observeWindow, "hboxAddNode");
  gtk_widget_set_sensitive(wd, value);
}
static void setSensitiveMark(gboolean value _U_)
{
/*   wd = lookup_widget(observeWindow, "tableMovePick"); */
/*   gtk_widget_set_sensitive(wd, value); */
}

static void setSensitiveActionSensitive(GtkInteractiveActionId id)
{
  currentAction = id;
  setSensitiveObserve((id == action_observe));
  setSensitiveMove((id == action_move));
  setSensitiveMark((id == action_mark));
}


/****************/
/* Private part */
/****************/

/* Connect the listeners on the signal emitted by the OpenGL server. */
static void connectSignalsObservePick()
{
  GtkWidget *wd;

  g_signal_connect(VISU_INSTANCE, "dataNew",
		   G_CALLBACK(onNewData), (gpointer)0);

  wd = lookup_widget(observeWindow, "buttonBackToCommandPanel");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onCloseButtonClicked), (gpointer)0);
  g_signal_connect(VISU_INSTANCE, "dataReadyForRendering",
		   G_CALLBACK(onVisuData), (gpointer)wd);
  wd = lookup_widget(observeWindow, "radioObserve");
  g_signal_connect(G_OBJECT(wd), "toggled",
		   G_CALLBACK(radioObserveToggled), (gpointer)0);
  wd = lookup_widget(observeWindow, "radioPick");
  g_signal_connect(G_OBJECT(wd), "toggled",
		   G_CALLBACK(radioPickToggled), (gpointer)0);
  wd = lookup_widget(observeWindow, "radioMove");
  g_signal_connect(G_OBJECT(wd), "toggled",
		   G_CALLBACK(radioMoveToggled), (gpointer)0);
  wd = lookup_widget(observeWindow, "radioSelect");
  g_signal_connect(G_OBJECT(wd), "toggled",
		   G_CALLBACK(radioMarkToggled), (gpointer)0);

  wd = lookup_widget(observeWindow, "buttonOrientationChooser");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onOrientationChooser), (gpointer)0);

  /* The observe widgets. */
  wd = lookup_widget(observeWindow, "spinTheta");
  g_signal_connect(G_OBJECT(wd), "value_changed",
		   G_CALLBACK(onAngleChanged), GINT_TO_POINTER(MASK_THETA));
  wd = lookup_widget(observeWindow, "spinPhi");
  g_signal_connect(G_OBJECT(wd), "value_changed",
		   G_CALLBACK(onAngleChanged), GINT_TO_POINTER(MASK_PHI));
  wd = lookup_widget(observeWindow, "spinOmega");
  g_signal_connect(G_OBJECT(wd), "value_changed",
		   G_CALLBACK(onAngleChanged), GINT_TO_POINTER(MASK_OMEGA));
  wd = lookup_widget(observeWindow, "spinDx");
  g_signal_connect(G_OBJECT(wd), "value_changed",
		   G_CALLBACK(onTranslationChanged), GINT_TO_POINTER(MASK_XS));
  wd = lookup_widget(observeWindow, "spinDy");
  g_signal_connect(G_OBJECT(wd), "value_changed",
		   G_CALLBACK(onTranslationChanged), GINT_TO_POINTER(MASK_YS));
  wd = lookup_widget(observeWindow, "spinGross");
  g_signal_connect(G_OBJECT(wd), "value_changed",
		   G_CALLBACK(onZoomChanged), (gpointer)0);
  wd = lookup_widget(observeWindow, "spinPersp");
  g_signal_connect(G_OBJECT(wd), "value_changed",
		   G_CALLBACK(onPerspChanged), (gpointer)0);
  wd = lookup_widget(observeWindow, "radioObserveConstrained");
  g_signal_connect(G_OBJECT(wd), "toggled", G_CALLBACK(observeMethodChanged),
		   GINT_TO_POINTER(OPENGL_OBSERVE_CONSTRAINED));
  wd = lookup_widget(observeWindow, "radioObserveWalker");
  g_signal_connect(G_OBJECT(wd), "toggled",
		   G_CALLBACK(observeMethodChanged), GINT_TO_POINTER(OPENGL_OBSERVE_WALKER));

  wd = lookup_widget(observeWindow, "notebookAction");
  g_signal_connect(G_OBJECT(wd), "switch-page",
		   G_CALLBACK(onTabActionChanged), (gpointer)0);

  wd = lookup_widget(observeWindow, "buttonEraseMarks");
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onEraseMarksClicked), (gpointer)0);
}

static void onNewData(GObject *obj _U_, VisuData *dataObj, gpointer data _U_)
{
  g_signal_connect(G_OBJECT(dataObj), "OpenGLThetaPhiOmega",
		   G_CALLBACK(refreshCameraSpinValues), (gpointer)0);
  g_signal_connect(G_OBJECT(dataObj), "OpenGLXsYs",
		   G_CALLBACK(refreshCameraSpinValues), (gpointer)0);
  g_signal_connect(G_OBJECT(dataObj), "OpenGLGross",
		   G_CALLBACK(refreshCameraSpinValues), (gpointer)0);
  g_signal_connect(G_OBJECT(dataObj), "OpenGLPersp",
		   G_CALLBACK(refreshCameraSpinValues), (gpointer)0);
}
static void onVisuData(GObject *obj _U_, VisuData *dataObj, gpointer data)
{
  if (!dataObj)
    gtk_button_clicked(GTK_BUTTON(data));
}

static void observeMethodChanged(GtkToggleButton* button, gpointer data)
{
  int method;
  RenderingWindow *window;

  if (!gtk_toggle_button_get_active(button))
    return;

  method = GPOINTER_TO_INT(data);
  openGLInteractiveSet_preferedObserveMethod(method);
  if (method == OPENGL_OBSERVE_CONSTRAINED)
    {
      window = RENDERING_WINDOW(visuRenderingWindowGet_current());
      g_return_if_fail(window);

      gtk_widget_set_sensitive(spinOmega, FALSE);
      if (visuDataSet_angleOfView(renderingWindowGet_visuData(window),
				  0., 0., 0., MASK_OMEGA))
	g_idle_add(visuObjectRedraw, (gpointer)0);
    }
  else
    gtk_widget_set_sensitive(spinOmega, TRUE);
}


/* Ask the OpenGL server to refresh the values of the spins
   controlling the position of the camera. */
static void refreshCameraSpinValues(VisuData *obj _U_, OpenGLView *view,
				    gpointer data _U_)
{
  g_return_if_fail(view && view->camera);

  DBG_fprintf(stderr, "Gtk Observe/pick : set values of spins.\n");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinTheta), (gdouble)view->camera->theta);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinPhi),   (gdouble)view->camera->phi);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinOmega), (gdouble)view->camera->omega);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinXs),    (gdouble)view->camera->xs);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinYs),    (gdouble)view->camera->ys);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinGross), (gdouble)view->camera->gross);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinPersp), (gdouble)view->camera->d_red);
}

/* Give a name to the widgets present in this window
   to be able to affect them with a theme. */
static void setNamesGtkWidgetObservePick(GtkMain *main)
{
  GtkWidget *wd;
  int method;

  gtk_widget_set_name(main->interactiveDialog, "message");
/*   wd = lookup_widget(main->interactiveDialog, "titreObserve"); */
/*   gtk_widget_set_name(wd, "message_title"); */
  wd = lookup_widget(main->interactiveDialog, "labelInfoObservePick");
  gtk_widget_set_name(wd, "label_info");

  wd = lookup_widget(main->interactiveDialog, "labelTranslation");
  gtk_widget_set_name(wd, "label_head_2");
  wd = lookup_widget(main->interactiveDialog, "labelZoom");
  gtk_widget_set_name(wd, "label_head_2");

  wd = lookup_widget(main->interactiveDialog, "radioObserve");
  gtk_widget_set_name(wd, "message_radio");
  wd = lookup_widget(main->interactiveDialog, "radioPick");
  gtk_widget_set_name(wd, "message_radio");
  wd = lookup_widget(main->interactiveDialog, "radioMove");
  gtk_widget_set_name(wd, "message_radio");
  wd = lookup_widget(main->interactiveDialog, "radioSelect");
  gtk_widget_set_name(wd, "message_radio");

  spinTheta = lookup_widget(main->interactiveDialog, "spinTheta");
  spinPhi = lookup_widget(main->interactiveDialog, "spinPhi");
  spinOmega = lookup_widget(main->interactiveDialog, "spinOmega");
  spinXs = lookup_widget(main->interactiveDialog, "spinDx");
  spinYs = lookup_widget(main->interactiveDialog, "spinDy");
  spinGross = lookup_widget(main->interactiveDialog, "spinGross");
  spinPersp = lookup_widget(main->interactiveDialog, "spinPersp");

  if (openGLInteractiveGet_preferedObserveMethod() == OPENGL_OBSERVE_CONSTRAINED)
    gtk_widget_set_sensitive(spinOmega, FALSE);

  wd = lookup_widget(main->interactiveDialog, "notebookAction");
  gtk_widget_set_name(wd, "message_notebook");

  method = openGLInteractiveGet_preferedObserveMethod();
  wd = lookup_widget(main->interactiveDialog, "radioObserveConstrained");
  gtk_widget_set_name(wd, "message_radio");
  if (method == OPENGL_OBSERVE_CONSTRAINED)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wd), TRUE);
  wd = lookup_widget(main->interactiveDialog, "radioObserveWalker");
  gtk_widget_set_name(wd, "message_radio");
  if (method == OPENGL_OBSERVE_WALKER)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wd), TRUE);
}

static void onAngleChanged(GtkSpinButton *spin, gpointer data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_angleOfView(renderingWindowGet_visuData(window),
					 (float)gtk_spin_button_get_value(spin),
					 (float)gtk_spin_button_get_value(spin),
					 (float)gtk_spin_button_get_value(spin),
					 GPOINTER_TO_INT(data));
  if (reDrawNeeded)
    g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onTranslationChanged(GtkSpinButton *spin, gpointer data)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_positionOfView(renderingWindowGet_visuData(window),
					    (float)gtk_spin_button_get_value(spin),
					    (float)gtk_spin_button_get_value(spin),
					    GPOINTER_TO_INT(data));
  if (reDrawNeeded)
    g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onZoomChanged(GtkSpinButton *spin, gpointer data _U_)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_zoomOfView(renderingWindowGet_visuData(window),
					(float)gtk_spin_button_get_value(spin));
  if (reDrawNeeded)
    g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onPerspChanged(GtkSpinButton *spin, gpointer data _U_)
{
  int reDrawNeeded;
  RenderingWindow *window;

  if (!gtk_window_is_active(GTK_WINDOW(observeWindow)))
    return;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);

  reDrawNeeded = visuDataSet_perspectiveOfView(renderingWindowGet_visuData(window),
					       (float)gtk_spin_button_get_value(spin));
  if (reDrawNeeded)
    g_idle_add(visuObjectRedraw, (gpointer)0);
}

static void radioObserveToggled(GtkToggleButton *togglebutton, gpointer user_data _U_)
{
  GtkWidget *labelHelp;

  if (!gtk_toggle_button_get_active(togglebutton))
    return;

  DBG_fprintf(stderr, "Gtk observePick : Toggle of the radio button in observe window.\n");

  labelHelp = lookup_widget(observeWindow, "labelInfoObservePick");
  gtk_label_set_markup(GTK_LABEL(labelHelp), markupObserveHelp);

  flagDisableChangePickObserve = TRUE;
  setSensitiveActionSensitive(action_observe);
  openGLInteractiveBegin_observe((VisuInteractive*)g_object_get_data
				 (G_OBJECT(observeWindow), "visuInteractive_data"));

  flagDisableChangePickObserve = FALSE;
}
static void radioPickToggled(GtkToggleButton *togglebutton, gpointer user_data _U_)
{
  GtkWidget *labelHelp;

  if (!gtk_toggle_button_get_active(togglebutton))
    return;

  DBG_fprintf(stderr, "Gtk observePick : Toggle of the radio button in observe window.\n");

  labelHelp = lookup_widget(observeWindow, "labelInfoObservePick");
  gtk_label_set_markup(GTK_LABEL(labelHelp), markupPickHelp);

  setSensitiveActionSensitive(action_pick);
  openGLInteractiveBegin_pick((VisuInteractive*)g_object_get_data
			      (G_OBJECT(observeWindow), "visuInteractive_data"));

  flagDisableChangePickObserve = FALSE;
}
static void radioMoveToggled(GtkToggleButton *togglebutton, gpointer user_data _U_)
{
  GtkWidget *labelHelp;

  if (!gtk_toggle_button_get_active(togglebutton))
    return;

  labelHelp = lookup_widget(observeWindow, "labelInfoObservePick");
  gtk_label_set_markup(GTK_LABEL(labelHelp), markupMoveHelp);

  setSensitiveActionSensitive(action_move);

  openGLInteractiveBegin_move((VisuInteractive*)g_object_get_data
			      (G_OBJECT(observeWindow), "visuInteractive_data"));

  flagDisableChangePickObserve = FALSE;
}
static void radioMarkToggled(GtkToggleButton *togglebutton, gpointer user_data _U_)
{
  GtkWidget *labelHelp;
  RenderingWindow *window;

  if (!gtk_toggle_button_get_active(togglebutton))
    return;

  labelHelp = lookup_widget(observeWindow, "labelInfoObservePick");
  gtk_label_set_markup(GTK_LABEL(labelHelp), markupMarkHelp);

  setSensitiveActionSensitive(action_mark);

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);
  openGLInteractiveBegin_mark((VisuInteractive*)g_object_get_data
			      (G_OBJECT(observeWindow), "visuInteractive_data"));

  flagDisableChangePickObserve = FALSE;
}

static void onTabActionChanged(GtkNotebook *book _U_, GtkNotebookPage *page _U_,
			       guint num, gpointer data _U_)
{
  GtkWidget *wd;

  DBG_fprintf(stderr, "Gtk Observe/Pick : change the action tab to %d.\n", num);
  switch (num + 1)
    {
    case action_pick:
      wd = lookup_widget(observeWindow, "radioPick");
      break;
    case action_move:
      gtkPick_onClose();
      wd = lookup_widget(observeWindow, "radioMove");
      break;
    case action_mark:
      gtkPick_onClose();
      wd = lookup_widget(observeWindow, "radioSelect");
      break;
    default:
      wd = (GtkWidget*)0;
    };

  if (wd)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wd), TRUE);
}
static void onEraseMarksClicked(GtkButton *button _U_, gpointer user_data _U_)
{
  RenderingWindow *window;
  PickMesure *pickMesure;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  pickMesure = (PickMesure*)visuDataGet_property(renderingWindowGet_visuData(window),
						 "pickMesure_data");
  g_return_if_fail(pickMesure);

  DBG_fprintf(stderr, "Gtk RenderingWindow: remove all highlights.\n");
  if (pickMesureRemove_allHighlights(pickMesure))
    g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onOrientationChanged(OrientationChooser *orientationChooser,
				 gpointer data _U_)
{
  float values[2];
  gboolean reDrawNeeded;

  DBG_fprintf(stderr, "Gtk Observe: orientation changed.\n");
  orientationChooserGet_anglesValues(orientationChooser, values);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinTheta), values[0]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinPhi), values[1]);

  reDrawNeeded = visuDataSet_angleOfView
    (renderingWindowGet_visuData(RENDERING_WINDOW(visuRenderingWindowGet_current())),
     values[0], values[1], 0., MASK_THETA | MASK_PHI);
  if (reDrawNeeded)
    g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onOrientationChooser(GtkButton *button _U_, gpointer data _U_)
{
  float values[2];
  gboolean reDrawNeeded;
  VisuData *dataObj;

  dataObj = renderingWindowGet_visuData
    (RENDERING_WINDOW(visuRenderingWindowGet_current()));
  if (!orientationChooser)
    {
      orientationChooser = orientationChooserNew
	(orientationChooser_direction, TRUE, dataObj, GTK_WINDOW(observeWindow));
/*       gtk_window_set_modal(GTK_WINDOW(orientationChooser), TRUE); */
      values[0] = (float)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinTheta));
      values[1] = (float)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinPhi));
      orientationChooserSet_anglesValues(ORIENTATION_CHOOSER(orientationChooser),
					 values);
      g_signal_connect(G_OBJECT(orientationChooser), "values-changed",
		       G_CALLBACK(onOrientationChanged), (gpointer)0);
    }
  else
    gdk_window_raise(GDK_WINDOW(orientationChooser->window));
  
  gtk_widget_show(orientationChooser);
  switch (gtk_dialog_run(GTK_DIALOG(orientationChooser)))
    {
    case GTK_RESPONSE_ACCEPT:
      DBG_fprintf(stderr, "Gtk Observe: accept changings on orientation.\n");
      break;
    default:
      DBG_fprintf(stderr, "Gtk Observe: reset values on orientation.\n");
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinTheta), values[0]);
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinPhi), values[1]);
      reDrawNeeded = visuDataSet_angleOfView
	(dataObj, values[0], values[1], 0., MASK_THETA | MASK_PHI);
      if (reDrawNeeded)
	g_idle_add(visuObjectRedraw, (gpointer)0);
    }
  DBG_fprintf(stderr, "Gtk Observe: orientation object destroy.\n");
  gtk_widget_destroy(orientationChooser);
  orientationChooser = (GtkWidget*)0;
}
