/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_OPENGLWIDGET_H
#define GTK_OPENGLWIDGET_H

#include "visu_data.h"

/**
 * OpenGLWidget:
 *
 * Short name to address OpenGLWidget_struct objects.
 */
typedef struct _OpenGLWidget OpenGLWidget;
/**
 * OpenGLWidgetClass:
 *
 * Short name to address OpenGLWidgetClass_struct objects.
 */
typedef struct _OpenGLWidgetClass OpenGLWidgetClass;

/**
 * RedrawMethod:
 * @lists: a string array, NULL terminated.
 * @data: the #VisuData to draw.
 *
 * Methods of this prototype are called when the redraw of the OpenGL zone
 * should be done.
 */
typedef void (*RedrawMethod)(const char** lists, VisuData *data);

/**
 * TYPE_OPENGL_WIDGET:
 * 
 * The type of OpenGLWidget objects.
 */
#define TYPE_OPENGL_WIDGET           (openGLWidget_get_type())
/**
 * OPENGL_WIDGET:
 * @obj: a pointer.
 *
 * Cast @obj to OpenGLWidget if possible.
 */
#define OPENGL_WIDGET(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),	\
								 TYPE_OPENGL_WIDGET, \
								 OpenGLWidget))
/**
 * OPENGL_WIDGET_CLASS:
 * @obj: a pointer.
 *
 * Cast @obj to OpenGLWidgetClass if possible.
 */
#define OPENGL_WIDGET_CLASS(obj)     (G_TYPE_CHECK_CLASS_CAST((obj),	\
							      TYPE_OPENGL_WIDGET, \
							      OpenGLWidgetClass))
/**
 * IS_OPENGL_WIDGET:
 * @obj: a pointer.
 *
 * Return TRUE is @obj is an OpenGLWidget object (or inherit from).
 */ 
#define IS_OPENGL_WIDGET(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),	\
								 TYPE_OPENGL_WIDGET))
/**
 * IS_OPENGL_WIDGET_CLASS:
 * @obj: a pointer.
 *
 * Return TRUE is @obj is an OpenGLWidgetClass object (or inherit from).
 */ 
#define IS_OPENGL_WIDGET_CLASS(obj)  (G_TYPE_CHECK_CLASS_TYPE((obj),	\
							      TYPE_OPENGL_WIDGET))
/**
 * OPENGL_WIDGET_GET_CLASS:
 * @obj: a pointer.
 *
 * Return the class of the given OpenGLWidget object.
 */
#define OPENGL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj),	\
								TYPE_OPENGL_WIDGET, \
								OpenGLWidgetClass))

/**
 * openGLWidget_get_type:
 *
 * Retrive the type of OpenGLWidget objects.
 *
 * Returns: the id used by OBjects for OpenGLWidget objects.
 */
GType openGLWidget_get_type(void);

/**
 * openGLWidgetNew:
 * @contextIsDirect: a boolean.
 *
 * Create a new OpenGL area inside a GTK widget. If @contextIsDirect then
 * it tries to initialise the OpenGL context to a direct one.
 *
 * Returns: a newly created widget.
 */
GtkWidget* openGLWidgetNew(gboolean contextIsDirect);
/**
 * openGLWidgetSet_current:
 * @render: a #OpenGLWidget object ;
 * @force: a boolean.
 *
 * Make this object current. This means that all future OpenGL primitive will be
 * rendered on this surface. If @force is TRUE, the GL routine is
 * actually called whereas in other cases, if @render believe being
 * already current, nothing is done.
 *
 * Returns: TRUE if succeed.
 */
gboolean openGLWidgetSet_current(OpenGLWidget *render, gboolean force);
/**
 * openGLWidgetSet_redraw:
 * @render: a #OpenGLWidget object ;
 * @method: a redraw method ;
 * @data: the #VisuData to draw.
 *
 * This method is used to defined a redraw method for the OpenGL area. By doing this
 * the area will automatically redraw itself when necessary. Before doing it
 * it calls openGLWidgetSet_current() ; and after it calls openGLWidgetSwap_buffers().
 */
void openGLWidgetSet_redraw(OpenGLWidget *render, RedrawMethod method, VisuData *data);
/**
 * openGLWidgetRedraw:
 * @render: a #OpenGLWidget object.
 *
 * Force redraw on the given surface, if a redraw method have been given (see
 * openGLWidgetSet_redraw()).
 */
void openGLWidgetRedraw(OpenGLWidget *render);
/**
 * openGLWidgetSwap_buffers:
 * @render: a #OpenGLWidget object.
 *
 * Swap the buffers of the OpenGL area.
 */
void openGLWidgetSwap_buffers(OpenGLWidget *render);
/**
 * openGLWidgetGet_pixmapData:
 * @render: a #OpenGLWidget object ;
 * @width: a pointer to the desired width or -1 ;
 * @height: a pointer to the desired height or -1 ;
 * @offScreen: a boolean ;
 * @hasAlpha: if TRUE, the returned data is RGBA, else only RGB.
 *
 * Create an image from the OpenGL area. The size can  be changed, using @width and
 * @height. If these pointers contains positive values, then they are used to set the
 * size for the image. If not, the current size is used and stored in these pointers.
 * The boolean offScreen is used to tell if the image is taken from current context
 * or if an offscreen pixmap is created for the rendering.
 *
 * Returns: image data, row by row.
 */
guchar* openGLWidgetGet_pixmapData(OpenGLWidget *render, int *width,
				   int *height, gboolean offScreen,
				   gboolean hasAlpha);
/**
 * openGLWidgetClassGet_currentContext:
 *
 * Class routine that returns the OpenGL widget which has the current context.
 *
 * Returns: the #OpenGLWidget with the current OpenGL context.
 */
OpenGLWidget* openGLWidgetClassGet_currentContext();

#endif
