/* valaccodeformalparameter.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODEFORMALPARAMETER_H__
#define __VALACCODEFORMALPARAMETER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_FORMAL_PARAMETER (vala_ccode_formal_parameter_get_type ())
#define VALA_CCODE_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FORMAL_PARAMETER, ValaCCodeFormalParameter))
#define VALA_CCODE_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FORMAL_PARAMETER, ValaCCodeFormalParameterClass))
#define VALA_IS_CCODE_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FORMAL_PARAMETER))
#define VALA_IS_CCODE_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FORMAL_PARAMETER))
#define VALA_CCODE_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FORMAL_PARAMETER, ValaCCodeFormalParameterClass))

typedef struct _ValaCCodeFormalParameter ValaCCodeFormalParameter;
typedef struct _ValaCCodeFormalParameterClass ValaCCodeFormalParameterClass;
typedef struct _ValaCCodeFormalParameterPrivate ValaCCodeFormalParameterPrivate;

/**
 * Represents a formal parameter in a C method signature.
 */
struct _ValaCCodeFormalParameter {
	ValaCCodeNode parent;
	ValaCCodeFormalParameterPrivate * priv;
};
struct _ValaCCodeFormalParameterClass {
	ValaCCodeNodeClass parent;
};

ValaCCodeFormalParameter* vala_ccode_formal_parameter_new (const char* n, const char* type);
char* vala_ccode_formal_parameter_get_name (ValaCCodeFormalParameter* self);
void vala_ccode_formal_parameter_set_name (ValaCCodeFormalParameter* self, const char* value);
char* vala_ccode_formal_parameter_get_type_name (ValaCCodeFormalParameter* self);
void vala_ccode_formal_parameter_set_type_name (ValaCCodeFormalParameter* self, const char* value);
GType vala_ccode_formal_parameter_get_type (void);

G_END_DECLS

#endif
