/* valaccodegotostatement.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODEGOTOSTATEMENT_H__
#define __VALACCODEGOTOSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_GOTO_STATEMENT (vala_ccode_goto_statement_get_type ())
#define VALA_CCODE_GOTO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GOTO_STATEMENT, ValaCCodeGotoStatement))
#define VALA_CCODE_GOTO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GOTO_STATEMENT, ValaCCodeGotoStatementClass))
#define VALA_IS_CCODE_GOTO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GOTO_STATEMENT))
#define VALA_IS_CCODE_GOTO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GOTO_STATEMENT))
#define VALA_CCODE_GOTO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GOTO_STATEMENT, ValaCCodeGotoStatementClass))

typedef struct _ValaCCodeGotoStatement ValaCCodeGotoStatement;
typedef struct _ValaCCodeGotoStatementClass ValaCCodeGotoStatementClass;
typedef struct _ValaCCodeGotoStatementPrivate ValaCCodeGotoStatementPrivate;

/**
 * Represents a goto statement in the C code.
 */
struct _ValaCCodeGotoStatement {
	ValaCCodeStatement parent;
	ValaCCodeGotoStatementPrivate * priv;
};
struct _ValaCCodeGotoStatementClass {
	ValaCCodeStatementClass parent;
};

ValaCCodeGotoStatement* vala_ccode_goto_statement_new (const char* name);
char* vala_ccode_goto_statement_get_name (ValaCCodeGotoStatement* self);
void vala_ccode_goto_statement_set_name (ValaCCodeGotoStatement* self, const char* value);
GType vala_ccode_goto_statement_get_type (void);

G_END_DECLS

#endif
