/* list.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __LIST_H__
#define __LIST_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>

G_BEGIN_DECLS


#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

/**
 * Represents a collection of items in a well-defined order.
 */
struct _GeeListIface {
	GTypeInterface parent;
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gpointer item);
	gint (*index_of) (GeeList* self, gpointer item);
	void (*insert) (GeeList* self, gint index, gpointer item);
	void (*remove_at) (GeeList* self, gint index);
};

gpointer gee_list_get (GeeList* self, gint index);
void gee_list_set (GeeList* self, gint index, gpointer item);
gint gee_list_index_of (GeeList* self, gpointer item);
void gee_list_insert (GeeList* self, gint index, gpointer item);
void gee_list_remove_at (GeeList* self, gint index);
GType gee_list_get_type (void);

G_END_DECLS

#endif
