/* valacreationmethod.vala
 *
 * Copyright (C) 2007  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <j@bitron.ch>
 */

#include "valacreationmethod.h"
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valacodevisitor.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valablock.h>
#include <vala/valadatatype.h>

struct _ValaCreationMethodPrivate {
	gint _n_construction_params;
};
#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
enum  {
	VALA_CREATION_METHOD_DUMMY_PROPERTY,
	VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS
};
static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_creation_method_real_get_default_cname (ValaMethod* base);
static gpointer vala_creation_method_parent_class = NULL;
static void vala_creation_method_dispose (GObject * obj);


/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod* vala_creation_method_new (const char* name, ValaSourceReference* source_reference)
{
	ValaCreationMethod * self;
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_CREATION_METHOD, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = ((ValaCreationMethod*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_creation_method (visitor, self);
}


static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = ((ValaCreationMethod*) base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_invokable_get_parameters (VALA_INVOKABLE (self));
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				vala_code_node_accept (VALA_CODE_NODE (param), visitor);
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	if (vala_method_get_body (((ValaMethod*) self)) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_method_get_body (((ValaMethod*) self))), visitor);
	}
}


static char* vala_creation_method_real_get_default_cname (ValaMethod* base)
{
	ValaCreationMethod * self;
	ValaSymbol* __temp0;
	ValaSymbol* parent;
	self = ((ValaCreationMethod*) base);
	__temp0 = NULL;
	parent = (__temp0 = vala_symbol_get_parent_symbol (((ValaSymbol*) self)), (__temp0 == NULL ? NULL : g_object_ref (__temp0)));
	g_assert (VALA_IS_DATA_TYPE (parent));
	if (vala_symbol_get_name (((ValaSymbol*) self)) == NULL) {
		char* __temp1;
		char* __temp2;
		char* __temp3;
		__temp1 = NULL;
		__temp2 = NULL;
		__temp3 = NULL;
		return (__temp3 = (__temp2 = g_strdup_printf ("%snew", (__temp1 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL ((VALA_DATA_TYPE (parent)))))), (__temp1 = (g_free (__temp1), NULL)), __temp2), (parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL))), __temp3);
	} else {
		char* __temp4;
		char* __temp5;
		char* __temp6;
		__temp4 = NULL;
		__temp5 = NULL;
		__temp6 = NULL;
		return (__temp6 = (__temp5 = g_strdup_printf ("%snew_%s", (__temp4 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL ((VALA_DATA_TYPE (parent))))), vala_symbol_get_name (((ValaSymbol*) self))), (__temp4 = (g_free (__temp4), NULL)), __temp5), (parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL))), __temp6);
	}
	(parent == NULL ? NULL : (parent = (g_object_unref (parent), NULL)));
}


gint vala_creation_method_get_n_construction_params (ValaCreationMethod* self)
{
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), 0);
	return self->priv->_n_construction_params;
}


void vala_creation_method_set_n_construction_params (ValaCreationMethod* self, gint value)
{
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	self->priv->_n_construction_params = value;
}


static void vala_creation_method_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (object);
	switch (property_id) {
		case VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS:
		g_value_set_int (value, vala_creation_method_get_n_construction_params (self));
		break;
	}
}


static void vala_creation_method_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (object);
	switch (property_id) {
		case VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS:
		vala_creation_method_set_n_construction_params (self, g_value_get_int (value));
		break;
	}
}


static void vala_creation_method_class_init (ValaCreationMethodClass * klass)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_creation_method_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_creation_method_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_creation_method_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_creation_method_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_creation_method_real_accept_children;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_creation_method_real_get_default_cname;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CREATION_METHOD_N_CONSTRUCTION_PARAMS, g_param_spec_int ("n-construction-params", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_creation_method_init (ValaCreationMethod * self)
{
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void vala_creation_method_dispose (GObject * obj)
{
	ValaCreationMethod * self;
	ValaCreationMethodClass * klass;
	GObjectClass * parent_class;
	self = VALA_CREATION_METHOD (obj);
	klass = VALA_CREATION_METHOD_CLASS (g_type_class_peek (VALA_TYPE_CREATION_METHOD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_creation_method_get_type (void)
{
	static GType vala_creation_method_type_id = 0;
	if (G_UNLIKELY (vala_creation_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_init };
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	}
	return vala_creation_method_type_id;
}




