/* FIXME check whether the corresponding data type of one of the
       parameters is a base type of the corresponding data
       type of the other parameter and check along the path
       whether one parameter maps to the other
 valatypereference.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALATYPEREFERENCE_H__
#define __VALATYPEREFERENCE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_TYPE_REFERENCE (vala_type_reference_get_type ())
#define VALA_TYPE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPE_REFERENCE, ValaTypeReference))
#define VALA_TYPE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPE_REFERENCE, ValaTypeReferenceClass))
#define VALA_IS_TYPE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPE_REFERENCE))
#define VALA_IS_TYPE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPE_REFERENCE))
#define VALA_TYPE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPE_REFERENCE, ValaTypeReferenceClass))

typedef struct _ValaTypeReferencePrivate ValaTypeReferencePrivate;

/**
 * A reference to a data type. This is used to specify static types of
 * expressions.
 */
struct _ValaTypeReference {
	ValaCodeNode parent;
	ValaTypeReferencePrivate * priv;
};
struct _ValaTypeReferenceClass {
	ValaCodeNodeClass parent;
};

ValaTypeReference* vala_type_reference_new (void);
ValaTypeReference* vala_type_reference_new_from_name (const char* ns, const char* type, ValaSourceReference* source);
ValaTypeReference* vala_type_reference_new_from_expression (ValaExpression* expr);
void vala_type_reference_add_type_argument (ValaTypeReference* self, ValaTypeReference* arg);
GeeList* vala_type_reference_get_type_arguments (ValaTypeReference* self);
void vala_type_reference_remove_all_type_arguments (ValaTypeReference* self);
char* vala_type_reference_get_cname (ValaTypeReference* self, gboolean var_type, gboolean const_type);
char* vala_type_reference_get_const_cname (ValaTypeReference* self);
char* vala_type_reference_to_string (ValaTypeReference* self);
ValaTypeReference* vala_type_reference_copy (ValaTypeReference* self);
gboolean vala_type_reference_equals (ValaTypeReference* self, ValaTypeReference* type2);
gboolean vala_type_reference_stricter (ValaTypeReference* self, ValaTypeReference* type2);
gboolean vala_type_reference_get_transfers_ownership (ValaTypeReference* self);
void vala_type_reference_set_transfers_ownership (ValaTypeReference* self, gboolean value);
gboolean vala_type_reference_get_takes_ownership (ValaTypeReference* self);
void vala_type_reference_set_takes_ownership (ValaTypeReference* self, gboolean value);
gboolean vala_type_reference_get_is_out (ValaTypeReference* self);
void vala_type_reference_set_is_out (ValaTypeReference* self, gboolean value);
gboolean vala_type_reference_get_non_null (ValaTypeReference* self);
void vala_type_reference_set_non_null (ValaTypeReference* self, gboolean value);
gboolean vala_type_reference_get_is_null (ValaTypeReference* self);
void vala_type_reference_set_is_null (ValaTypeReference* self, gboolean value);
ValaDataType* vala_type_reference_get_data_type (ValaTypeReference* self);
void vala_type_reference_set_data_type (ValaTypeReference* self, ValaDataType* value);
ValaTypeParameter* vala_type_reference_get_type_parameter (ValaTypeReference* self);
void vala_type_reference_set_type_parameter (ValaTypeReference* self, ValaTypeParameter* value);
gboolean vala_type_reference_get_floating_reference (ValaTypeReference* self);
void vala_type_reference_set_floating_reference (ValaTypeReference* self, gboolean value);
char* vala_type_reference_get_namespace_name (ValaTypeReference* self);
void vala_type_reference_set_namespace_name (ValaTypeReference* self, const char* value);
char* vala_type_reference_get_type_name (ValaTypeReference* self);
void vala_type_reference_set_type_name (ValaTypeReference* self, const char* value);
gint vala_type_reference_get_array_rank (ValaTypeReference* self);
void vala_type_reference_set_array_rank (ValaTypeReference* self, gint value);
gint vala_type_reference_get_pointer_level (ValaTypeReference* self);
void vala_type_reference_set_pointer_level (ValaTypeReference* self, gint value);
gboolean vala_type_reference_get_is_ref (ValaTypeReference* self);
void vala_type_reference_set_is_ref (ValaTypeReference* self, gboolean value);
gboolean vala_type_reference_get_is_weak (ValaTypeReference* self);
void vala_type_reference_set_is_weak (ValaTypeReference* self, gboolean value);
GType vala_type_reference_get_type (void);

G_END_DECLS

#endif
