/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valatyperegisterfunction.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>

struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
};
#define VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPEREGISTER_FUNCTION_DUMMY_PROPERTY
};
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static gpointer vala_typeregister_function_parent_class = NULL;
static void vala_typeregister_function_dispose (GObject * obj);


/**
 * Constructs the C function from the specified type.
 */
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin) {
	gboolean fundamental;
	ValaTypesymbol* _tmp0;
	ValaClass* cl;
	char* _tmp2;
	ValaTypesymbol* _tmp1;
	char* _tmp3;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp5;
	ValaCCodeConstant* _tmp4;
	ValaCCodeFunction* fun;
	ValaCCodeBlock* type_init;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp30;
	ValaCCodeConstant* _tmp29;
	char* _tmp28;
	char* _tmp27;
	char* _tmp26;
	char* _tmp25;
	char* _tmp24;
	char* _tmp23;
	ValaCCodeFragment* _tmp33;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp48;
	char* _tmp47;
	char* _tmp46;
	ValaTypesymbol* _tmp45;
	ValaCCodeIdentifier* _tmp49;
	ValaCCodeConstant* _tmp52;
	char* _tmp51;
	ValaCCodeExpressionStatement* _tmp55;
	ValaCCodeAssignment* _tmp54;
	ValaCCodeIdentifier* _tmp53;
	ValaCCodeFragment* _tmp56;
	ValaCCodeReturnStatement* _tmp65;
	ValaCCodeIdentifier* _tmp64;
	ValaCCodeFunction* _tmp66;
	g_return_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self));
	fundamental = FALSE;
	_tmp0 = NULL;
	cl = (_tmp0 = vala_typeregister_function_get_type_declaration (self), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL));
	if (cl != NULL && vala_class_get_base_class (cl) != NULL && g_utf8_collate (vala_symbol_get_name (VALA_SYMBOL (vala_class_get_base_class (cl))), "TypeInstance") == 0 && g_utf8_collate (vala_symbol_get_name (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_class_get_base_class (cl)))), "GLib") == 0) {
		fundamental = TRUE;
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	type_id_name = (_tmp3 = g_strdup_printf ("%s_type_id", (_tmp2 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp1 = vala_typeregister_function_get_type_declaration (self))), NULL))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp3);
	type_block = vala_ccode_block_new ();
	cdecl_ = vala_ccode_declaration_new ("GType");
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp5 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("0")))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cdecl_));
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (cdecl_));
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* _tmp9;
		char* _tmp8;
		char* _tmp7;
		ValaTypesymbol* _tmp6;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp6 = NULL;
		fun = (_tmp9 = vala_ccode_function_new ((_tmp8 = g_strdup_printf ("%s_get_type", (_tmp7 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp6 = vala_typeregister_function_get_type_declaration (self))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), _tmp9);
		(_tmp8 = (g_free (_tmp8), NULL));
		(_tmp7 = (g_free (_tmp7), NULL));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		/* Function will not be prototyped anyway */
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
	} else {
		ValaCCodeFunction* _tmp13;
		char* _tmp12;
		char* _tmp11;
		ValaTypesymbol* _tmp10;
		ValaCCodeFormalParameter* _tmp14;
		char* _tmp17;
		char* _tmp16;
		ValaTypesymbol* _tmp15;
		ValaCCodeFunction* _tmp18;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* _tmp19;
		ValaCCodeBlock* _tmp20;
		ValaCCodeReturnStatement* _tmp22;
		ValaCCodeIdentifier* _tmp21;
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		fun = (_tmp13 = vala_ccode_function_new ((_tmp12 = g_strdup_printf ("%s_register_type", (_tmp11 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp10 = vala_typeregister_function_get_type_declaration (self))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), _tmp13);
		(_tmp12 = (g_free (_tmp12), NULL));
		(_tmp11 = (g_free (_tmp11), NULL));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		_tmp14 = NULL;
		vala_ccode_function_add_parameter (fun, (_tmp14 = vala_ccode_formal_parameter_new ("module", "GTypeModule *")));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp18 = NULL;
		get_fun = (_tmp18 = vala_ccode_function_new ((_tmp17 = g_strdup_printf ("%s_get_type", (_tmp16 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp15 = vala_typeregister_function_get_type_declaration (self))), NULL)))), "GType"), (_tmp17 = (g_free (_tmp17), NULL)), (_tmp16 = (g_free (_tmp16), NULL)), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp18);
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp19 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((_tmp19 = vala_ccode_function_copy (get_fun))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		_tmp20 = NULL;
		vala_ccode_function_set_block (get_fun, (_tmp20 = vala_ccode_block_new ()));
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		_tmp22 = NULL;
		_tmp21 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), VALA_CCODE_NODE ((_tmp22 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new (type_id_name)))))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (get_fun));
		(get_fun == NULL ? NULL : (get_fun = (g_object_unref (get_fun), NULL)));
	}
	type_init = vala_ccode_block_new ();
	ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
	vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((_tmp30 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ((_tmp28 = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) NULL, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s }", (_tmp23 = vala_typeregister_function_get_type_struct_name (self)), (_tmp24 = vala_typeregister_function_get_base_init_func_name (self)), (_tmp25 = vala_typeregister_function_get_class_init_func_name (self)), (_tmp26 = vala_typeregister_function_get_instance_struct_size (self)), (_tmp27 = vala_typeregister_function_get_instance_init_func_name (self)))))))))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	(_tmp28 = (g_free (_tmp28), NULL));
	(_tmp27 = (g_free (_tmp27), NULL));
	(_tmp26 = (g_free (_tmp26), NULL));
	(_tmp25 = (g_free (_tmp25), NULL));
	(_tmp24 = (g_free (_tmp24), NULL));
	(_tmp23 = (g_free (_tmp23), NULL));
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (ctypedecl));
	if (fundamental) {
		ValaCCodeDeclaration* ctypefundamentaldecl;
		ValaCCodeVariableDeclarator* _tmp32;
		ValaCCodeConstant* _tmp31;
		ctypefundamentaldecl = vala_ccode_declaration_new ("const GTypeFundamentalInfo");
		vala_ccode_declaration_set_modifiers (ctypefundamentaldecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_declaration_add_declarator (ctypefundamentaldecl, VALA_CCODE_DECLARATOR ((_tmp32 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_fundamental_info", VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_constant_new ("{ (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) }")))))));
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
		vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (ctypefundamentaldecl));
		(ctypefundamentaldecl == NULL ? NULL : (ctypefundamentaldecl = (g_object_unref (ctypefundamentaldecl), NULL)));
	}
	_tmp33 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp33 = vala_typeregister_function_get_type_interface_init_declaration (self))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	reg_call = NULL;
	if (fundamental) {
		ValaCCodeFunctionCall* _tmp35;
		ValaCCodeIdentifier* _tmp34;
		_tmp35 = NULL;
		_tmp34 = NULL;
		reg_call = (_tmp35 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("g_type_register_fundamental")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp35);
		(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	} else {
		if (!plugin) {
			ValaCCodeFunctionCall* _tmp37;
			ValaCCodeIdentifier* _tmp36;
			_tmp37 = NULL;
			_tmp36 = NULL;
			reg_call = (_tmp37 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("g_type_register_static")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp37);
			(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		} else {
			ValaCCodeFunctionCall* _tmp39;
			ValaCCodeIdentifier* _tmp38;
			ValaCCodeIdentifier* _tmp40;
			_tmp39 = NULL;
			_tmp38 = NULL;
			reg_call = (_tmp39 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("g_type_module_register_type")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp39);
			(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
			_tmp40 = NULL;
			vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("module"))));
			(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
		}
	}
	if (fundamental) {
		ValaCCodeFunctionCall* _tmp42;
		ValaCCodeIdentifier* _tmp41;
		_tmp42 = NULL;
		_tmp41 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("g_type_fundamental_next")))))));
		(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
		(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp44;
		char* _tmp43;
		_tmp44 = NULL;
		_tmp43 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new ((_tmp43 = vala_typeregister_function_get_parent_type_name (self))))));
		(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
		(_tmp43 = (g_free (_tmp43), NULL));
	}
	_tmp48 = NULL;
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_constant_new ((_tmp47 = g_strdup_printf ("\"%s\"", (_tmp46 = vala_typesymbol_get_cname ((_tmp45 = vala_typeregister_function_get_type_declaration (self)), FALSE))))))));
	(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
	(_tmp47 = (g_free (_tmp47), NULL));
	(_tmp46 = (g_free (_tmp46), NULL));
	(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
	_tmp49 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("&g_define_type_info"))));
	(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
	if (fundamental) {
		ValaCCodeIdentifier* _tmp50;
		_tmp50 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_identifier_new ("&g_define_type_fundamental_info"))));
		(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
	}
	_tmp52 = NULL;
	_tmp51 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_constant_new ((_tmp51 = vala_typeregister_function_get_type_flags (self))))));
	(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
	(_tmp51 = (g_free (_tmp51), NULL));
	_tmp55 = NULL;
	_tmp54 = NULL;
	_tmp53 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp55 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION (reg_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
	(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
	(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
	_tmp56 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp56 = vala_typeregister_function_get_type_interface_init_statements (self))));
	(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
	if (!plugin) {
		ValaCCodeIdentifier* _tmp57;
		ValaCCodeFunctionCall* _tmp58;
		ValaCCodeFunctionCall* cond;
		ValaCCodeBinaryExpression* _tmp61;
		ValaCCodeConstant* _tmp60;
		ValaCCodeIdentifier* _tmp59;
		ValaCCodeIfStatement* cif;
		_tmp57 = NULL;
		_tmp58 = NULL;
		cond = (_tmp58 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("G_UNLIKELY")))), (_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL))), _tmp58);
		_tmp61 = NULL;
		_tmp60 = NULL;
		_tmp59 = NULL;
		vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_constant_new ("0")))))));
		(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
		(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
		(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
		cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (type_init), NULL);
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cif));
		(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
		(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	} else {
		ValaCCodeBlock* _tmp63;
		ValaCCodeBlock* _tmp62;
		_tmp63 = NULL;
		_tmp62 = NULL;
		type_block = (_tmp63 = (_tmp62 = type_init, (_tmp62 == NULL ? NULL : g_object_ref (_tmp62))), (type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL))), _tmp63);
	}
	_tmp65 = NULL;
	_tmp64 = NULL;
	vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE ((_tmp65 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_identifier_new (type_id_name)))))));
	(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
	(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
	_tmp66 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((_tmp66 = vala_ccode_function_copy (fun))));
	(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (fun));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(type_id_name = (g_free (type_id_name), NULL));
	(type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(type_init == NULL ? NULL : (type_init = (g_object_unref (type_init), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (g_object_unref (ctypedecl), NULL)));
	(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
}


/**
 * Returns the data type to be registered.
 *
 * @return type to be registered
 */
ValaTypesymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self) {
	ValaTypesymbol* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
	return result;
}


/**
 * Returns the name of the type struct in C code.
 *
 * @return C struct name
 */
char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self) {
	char* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
	return result;
}


/**
 * Returns the name of the base_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	char* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
	return result;
}


/**
 * Returns the name of the class_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	char* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
	return result;
}


/**
 * Returns the size of the instance struct in C code.
 *
 * @return C instance struct size
 */
char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	char* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
	return result;
}


/**
 * Returns the name of the instance_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	char* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
	return result;
}


/**
 * Returns the name of the parent type in C code.
 *
 * @return C parent type name
 */
char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self) {
	char* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
	return result;
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	return g_strdup ("0");
}


char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self) {
	char* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
	return result;
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	return vala_ccode_fragment_new ();
}


ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
	return result;
}


/**
 * Returns additional C initialization statements to setup interfaces.
 *
 * @return C statements
 */
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
	return result;
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->declaration_fragment, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->definition_fragment, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


/**
 * Returns the accessibility for this type.
 */
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self) {
	ValaSymbolAccessibility result;
	result = VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_accessibility (self);
	return result;
}


static void vala_typeregister_function_class_init (ValaTypeRegisterFunctionClass * klass) {
	vala_typeregister_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_typeregister_function_dispose;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_typeregister_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_typeregister_function_real_get_type_interface_init_declaration;
}


static void vala_typeregister_function_init (ValaTypeRegisterFunction * self) {
	self->priv = VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = vala_ccode_fragment_new ();
	self->priv->definition_fragment = vala_ccode_fragment_new ();
}


static void vala_typeregister_function_dispose (GObject * obj) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL ? NULL : (self->priv->declaration_fragment = (g_object_unref (self->priv->declaration_fragment), NULL)));
	(self->priv->definition_fragment == NULL ? NULL : (self->priv->definition_fragment = (g_object_unref (self->priv->definition_fragment), NULL)));
	G_OBJECT_CLASS (vala_typeregister_function_parent_class)->dispose (obj);
}


GType vala_typeregister_function_get_type (void) {
	static GType vala_typeregister_function_type_id = 0;
	if (G_UNLIKELY (vala_typeregister_function_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeregister_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_typeregister_function_init };
		vala_typeregister_function_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaTypeRegisterFunction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_typeregister_function_type_id;
}




