/* valaccodetypesymbolbinding.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __GOBJECT_VALACCODETYPESYMBOLBINDING_H__
#define __GOBJECT_VALACCODETYPESYMBOLBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valaproperty.h>
#include <vala/valasignal.h>
#include <vala/valatypesymbol.h>
#include <gobject/valaccodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_TYPE_SYMBOL_BINDING (vala_ccode_type_symbol_binding_get_type ())
#define VALA_CCODE_TYPE_SYMBOL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_TYPE_SYMBOL_BINDING, ValaCCodeTypeSymbolBinding))
#define VALA_CCODE_TYPE_SYMBOL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_TYPE_SYMBOL_BINDING, ValaCCodeTypeSymbolBindingClass))
#define VALA_IS_CCODE_TYPE_SYMBOL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_TYPE_SYMBOL_BINDING))
#define VALA_IS_CCODE_TYPE_SYMBOL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_TYPE_SYMBOL_BINDING))
#define VALA_CCODE_TYPE_SYMBOL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_TYPE_SYMBOL_BINDING, ValaCCodeTypeSymbolBindingClass))

typedef struct _ValaCCodeTypeSymbolBinding ValaCCodeTypeSymbolBinding;
typedef struct _ValaCCodeTypeSymbolBindingClass ValaCCodeTypeSymbolBindingClass;
typedef struct _ValaCCodeTypeSymbolBindingPrivate ValaCCodeTypeSymbolBindingPrivate;

struct _ValaCCodeTypeSymbolBinding {
	ValaCCodeBinding parent_instance;
	ValaCCodeTypeSymbolBindingPrivate * priv;
};

struct _ValaCCodeTypeSymbolBindingClass {
	ValaCCodeBindingClass parent_class;
};


ValaCCodeFunctionCall* vala_ccode_type_symbol_binding_get_param_spec (ValaCCodeTypeSymbolBinding* self, ValaProperty* prop);
ValaCCodeFunctionCall* vala_ccode_type_symbol_binding_get_signal_creation (ValaCCodeTypeSymbolBinding* self, ValaSignal* sig, ValaTypeSymbol* type);
GType vala_ccode_type_symbol_binding_get_type (void);


G_END_DECLS

#endif
