/* valadelegatetype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALADELEGATETYPE_H__
#define __VALA_VALADELEGATETYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valadelegate.h>
#include <vala/valascope.h>

G_BEGIN_DECLS


#define VALA_TYPE_DELEGATE_TYPE (vala_delegate_type_get_type ())
#define VALA_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateType))
#define VALA_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))
#define VALA_IS_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE_TYPE))
#define VALA_IS_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE_TYPE))
#define VALA_DELEGATE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))

typedef struct _ValaDelegateType ValaDelegateType;
typedef struct _ValaDelegateTypeClass ValaDelegateTypeClass;
typedef struct _ValaDelegateTypePrivate ValaDelegateTypePrivate;

/**
 * The type of an instance of a delegate.
 */
struct _ValaDelegateType {
	ValaDataType parent_instance;
	ValaDelegateTypePrivate * priv;
};

struct _ValaDelegateTypeClass {
	ValaDataTypeClass parent_class;
};


ValaDelegateType* vala_delegate_type_new (ValaDelegate* delegate_symbol);
ValaDelegate* vala_delegate_type_get_delegate_symbol (ValaDelegateType* self);
void vala_delegate_type_set_delegate_symbol (ValaDelegateType* self, ValaDelegate* value);
GType vala_delegate_type_get_type (void);


G_END_DECLS

#endif
