/* valasourcefilecycle.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valasourcefilecycle.h>
#include <gee/arraylist.h>
#include <vala/valasourcefile.h>




enum  {
	VALA_SOURCE_FILE_CYCLE_DUMMY_PROPERTY
};
static gpointer vala_source_file_cycle_parent_class = NULL;
static void vala_source_file_cycle_finalize (GObject * obj);



/**
 * Represents a dependency cycle of source files.
 */
ValaSourceFileCycle* vala_source_file_cycle_new (void) {
	ValaSourceFileCycle * self;
	self = g_object_newv (VALA_TYPE_SOURCE_FILE_CYCLE, 0, NULL);
	return self;
}


static void vala_source_file_cycle_class_init (ValaSourceFileCycleClass * klass) {
	vala_source_file_cycle_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vala_source_file_cycle_finalize;
}


static void vala_source_file_cycle_instance_init (ValaSourceFileCycle * self) {
	self->files = GEE_LIST (gee_array_list_new (VALA_TYPE_SOURCE_FILE, NULL, NULL, g_direct_equal));
}


static void vala_source_file_cycle_finalize (GObject * obj) {
	ValaSourceFileCycle * self;
	self = VALA_SOURCE_FILE_CYCLE (obj);
	(self->files == NULL ? NULL : (self->files = (g_object_unref (self->files), NULL)));
	G_OBJECT_CLASS (vala_source_file_cycle_parent_class)->finalize (obj);
}


GType vala_source_file_cycle_get_type (void) {
	static GType vala_source_file_cycle_type_id = 0;
	if (vala_source_file_cycle_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSourceFileCycleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_source_file_cycle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSourceFileCycle), 0, (GInstanceInitFunc) vala_source_file_cycle_instance_init };
		vala_source_file_cycle_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaSourceFileCycle", &g_define_type_info, 0);
	}
	return vala_source_file_cycle_type_id;
}




