/* valatokentype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALATOKENTYPE_H__
#define __VALA_VALATOKENTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define VALA_TYPE_TOKEN_TYPE (vala_token_type_get_type ())

typedef enum  {
	VALA_TOKEN_TYPE_NONE,
	VALA_TOKEN_TYPE_ABSTRACT,
	VALA_TOKEN_TYPE_AS,
	VALA_TOKEN_TYPE_ASSIGN,
	VALA_TOKEN_TYPE_ASSIGN_ADD,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_TOKEN_TYPE_ASSIGN_DIV,
	VALA_TOKEN_TYPE_ASSIGN_MUL,
	VALA_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_TOKEN_TYPE_ASSIGN_SUB,
	VALA_TOKEN_TYPE_BASE,
	VALA_TOKEN_TYPE_BITWISE_AND,
	VALA_TOKEN_TYPE_BITWISE_OR,
	VALA_TOKEN_TYPE_BREAK,
	VALA_TOKEN_TYPE_CARRET,
	VALA_TOKEN_TYPE_CASE,
	VALA_TOKEN_TYPE_CATCH,
	VALA_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_TOKEN_TYPE_CLASS,
	VALA_TOKEN_TYPE_CLOSE_BRACE,
	VALA_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_TOKEN_TYPE_CLOSE_PARENS,
	VALA_TOKEN_TYPE_COLON,
	VALA_TOKEN_TYPE_COMMA,
	VALA_TOKEN_TYPE_CONST,
	VALA_TOKEN_TYPE_CONSTRUCT,
	VALA_TOKEN_TYPE_CONTINUE,
	VALA_TOKEN_TYPE_DEFAULT,
	VALA_TOKEN_TYPE_DELEGATE,
	VALA_TOKEN_TYPE_DELETE,
	VALA_TOKEN_TYPE_DIV,
	VALA_TOKEN_TYPE_DO,
	VALA_TOKEN_TYPE_DOUBLE_COLON,
	VALA_TOKEN_TYPE_DOT,
	VALA_TOKEN_TYPE_DYNAMIC,
	VALA_TOKEN_TYPE_ELLIPSIS,
	VALA_TOKEN_TYPE_ELSE,
	VALA_TOKEN_TYPE_ENUM,
	VALA_TOKEN_TYPE_ENSURES,
	VALA_TOKEN_TYPE_ERRORDOMAIN,
	VALA_TOKEN_TYPE_EOF,
	VALA_TOKEN_TYPE_EXTERN,
	VALA_TOKEN_TYPE_FALSE,
	VALA_TOKEN_TYPE_FINALLY,
	VALA_TOKEN_TYPE_FOR,
	VALA_TOKEN_TYPE_FOREACH,
	VALA_TOKEN_TYPE_GET,
	VALA_TOKEN_TYPE_HASH,
	VALA_TOKEN_TYPE_IDENTIFIER,
	VALA_TOKEN_TYPE_IF,
	VALA_TOKEN_TYPE_IN,
	VALA_TOKEN_TYPE_INLINE,
	VALA_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_TOKEN_TYPE_INTERFACE,
	VALA_TOKEN_TYPE_INTERNAL,
	VALA_TOKEN_TYPE_INTERR,
	VALA_TOKEN_TYPE_IS,
	VALA_TOKEN_TYPE_LAMBDA,
	VALA_TOKEN_TYPE_LOCK,
	VALA_TOKEN_TYPE_MINUS,
	VALA_TOKEN_TYPE_NAMESPACE,
	VALA_TOKEN_TYPE_NEW,
	VALA_TOKEN_TYPE_NULL,
	VALA_TOKEN_TYPE_OUT,
	VALA_TOKEN_TYPE_OP_AND,
	VALA_TOKEN_TYPE_OP_DEC,
	VALA_TOKEN_TYPE_OP_EQ,
	VALA_TOKEN_TYPE_OP_GE,
	VALA_TOKEN_TYPE_OP_GT,
	VALA_TOKEN_TYPE_OP_INC,
	VALA_TOKEN_TYPE_OP_LE,
	VALA_TOKEN_TYPE_OP_LT,
	VALA_TOKEN_TYPE_OP_NE,
	VALA_TOKEN_TYPE_OP_NEG,
	VALA_TOKEN_TYPE_OP_OR,
	VALA_TOKEN_TYPE_OP_PTR,
	VALA_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_TOKEN_TYPE_OPEN_BRACE,
	VALA_TOKEN_TYPE_OPEN_BRACKET,
	VALA_TOKEN_TYPE_OPEN_PARENS,
	VALA_TOKEN_TYPE_OVERRIDE,
	VALA_TOKEN_TYPE_PERCENT,
	VALA_TOKEN_TYPE_PLUS,
	VALA_TOKEN_TYPE_PRIVATE,
	VALA_TOKEN_TYPE_PROTECTED,
	VALA_TOKEN_TYPE_PUBLIC,
	VALA_TOKEN_TYPE_REAL_LITERAL,
	VALA_TOKEN_TYPE_REF,
	VALA_TOKEN_TYPE_REQUIRES,
	VALA_TOKEN_TYPE_RETURN,
	VALA_TOKEN_TYPE_SEMICOLON,
	VALA_TOKEN_TYPE_SET,
	VALA_TOKEN_TYPE_SIGNAL,
	VALA_TOKEN_TYPE_SIZEOF,
	VALA_TOKEN_TYPE_STAR,
	VALA_TOKEN_TYPE_STATIC,
	VALA_TOKEN_TYPE_STRING_LITERAL,
	VALA_TOKEN_TYPE_STRUCT,
	VALA_TOKEN_TYPE_SWITCH,
	VALA_TOKEN_TYPE_THIS,
	VALA_TOKEN_TYPE_THROW,
	VALA_TOKEN_TYPE_THROWS,
	VALA_TOKEN_TYPE_TILDE,
	VALA_TOKEN_TYPE_TRUE,
	VALA_TOKEN_TYPE_TRY,
	VALA_TOKEN_TYPE_TYPEOF,
	VALA_TOKEN_TYPE_USING,
	VALA_TOKEN_TYPE_VAR,
	VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_TOKEN_TYPE_VIRTUAL,
	VALA_TOKEN_TYPE_VOID,
	VALA_TOKEN_TYPE_VOLATILE,
	VALA_TOKEN_TYPE_WEAK,
	VALA_TOKEN_TYPE_WHILE
} ValaTokenType;


const char* vala_token_type_to_string (ValaTokenType self);
GType vala_token_type_get_type (void);


G_END_DECLS

#endif
