/* valaunresolvedtype.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valaunresolvedtype.h>
#include <gee/list.h>
#include <vala/valacodenode.h>
#include <vala/valamemberaccess.h>
#include <vala/valareport.h>




struct _ValaUnresolvedTypePrivate {
	ValaUnresolvedSymbol* _unresolved_symbol;
};

#define VALA_UNRESOLVED_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedTypePrivate))
enum  {
	VALA_UNRESOLVED_TYPE_DUMMY_PROPERTY,
	VALA_UNRESOLVED_TYPE_UNRESOLVED_SYMBOL
};
static ValaDataType* vala_unresolved_type_real_copy (ValaDataType* base);
static char* vala_unresolved_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static gpointer vala_unresolved_type_parent_class = NULL;
static void vala_unresolved_type_finalize (GObject * obj);



ValaUnresolvedType* vala_unresolved_type_new (void) {
	ValaUnresolvedType * self;
	self = g_object_newv (VALA_TYPE_UNRESOLVED_TYPE, 0, NULL);
	return self;
}


/**
 * Creates a new type reference.
 *
 * @param symbol    unresolved type symbol
 * @param source    reference to source code
 * @return          newly created type reference
 */
ValaUnresolvedType* vala_unresolved_type_new_from_symbol (ValaUnresolvedSymbol* symbol, ValaSourceReference* source) {
	ValaUnresolvedType * self;
	g_return_val_if_fail (VALA_IS_UNRESOLVED_SYMBOL (symbol), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_UNRESOLVED_TYPE, 0, NULL);
	vala_unresolved_type_set_unresolved_symbol (self, symbol);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


/**
 * Creates a new type reference from a code expression.
 *
 * @param expr   member access expression
 * @param source reference to source code
 * @return       newly created type reference
 */
ValaUnresolvedType* vala_unresolved_type_new_from_expression (ValaExpression* expr) {
	char* ns;
	char* type_name;
	ValaUnresolvedType* _tmp8;
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	ns = NULL;
	type_name = NULL;
	if (VALA_IS_MEMBER_ACCESS (expr)) {
		ValaUnresolvedType* type_ref;
		ValaMemberAccess* _tmp0;
		ValaMemberAccess* ma;
		type_ref = NULL;
		_tmp0 = NULL;
		ma = (_tmp0 = VALA_MEMBER_ACCESS (expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (vala_member_access_get_inner (ma) != NULL) {
			if (VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (ma))) {
				ValaMemberAccess* _tmp1;
				ValaMemberAccess* simple;
				ValaUnresolvedType* _tmp4;
				ValaUnresolvedSymbol* _tmp3;
				ValaUnresolvedSymbol* _tmp2;
				_tmp1 = NULL;
				simple = (_tmp1 = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				type_ref = (_tmp4 = vala_unresolved_type_new_from_symbol ((_tmp3 = vala_unresolved_symbol_new ((_tmp2 = vala_unresolved_symbol_new (NULL, vala_member_access_get_member_name (simple), vala_code_node_get_source_reference (VALA_CODE_NODE (ma)))), vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (VALA_CODE_NODE (ma)))), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL))), _tmp4);
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(simple == NULL ? NULL : (simple = (g_object_unref (simple), NULL)));
			}
		} else {
			ValaUnresolvedType* _tmp6;
			ValaUnresolvedSymbol* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			type_ref = (_tmp6 = vala_unresolved_type_new_from_symbol ((_tmp5 = vala_unresolved_symbol_new (NULL, vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (VALA_CODE_NODE (ma)))), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL))), _tmp6);
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		}
		if (type_ref != NULL) {
			GeeList* type_args;
			ValaUnresolvedType* _tmp7;
			vala_data_type_set_value_owned (VALA_DATA_TYPE (type_ref), TRUE);
			type_args = vala_member_access_get_type_arguments (ma);
			{
				GeeList* arg_collection;
				int arg_it;
				arg_collection = type_args;
				for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
					ValaDataType* arg;
					arg = ((ValaDataType*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
					{
						vala_data_type_add_type_argument (VALA_DATA_TYPE (type_ref), arg);
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
					}
				}
			}
			_tmp7 = NULL;
			return (_tmp7 = type_ref, (type_args == NULL ? NULL : (type_args = (g_object_unref (type_args), NULL))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (ns = (g_free (ns), NULL)), (type_name = (g_free (type_name), NULL)), _tmp7);
		}
		(type_ref == NULL ? NULL : (type_ref = (g_object_unref (type_ref), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	}
	vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Type reference must be simple name or member access expression");
	_tmp8 = NULL;
	return (_tmp8 = NULL, (ns = (g_free (ns), NULL)), (type_name = (g_free (type_name), NULL)), _tmp8);
}


static ValaDataType* vala_unresolved_type_real_copy (ValaDataType* base) {
	ValaUnresolvedType * self;
	ValaUnresolvedType* result;
	ValaUnresolvedSymbol* _tmp0;
	self = VALA_UNRESOLVED_TYPE (base);
	result = vala_unresolved_type_new ();
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_value_owned (VALA_DATA_TYPE (result), vala_data_type_get_value_owned (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_is_dynamic (VALA_DATA_TYPE (result), vala_data_type_get_is_dynamic (VALA_DATA_TYPE (self)));
	_tmp0 = NULL;
	vala_unresolved_type_set_unresolved_symbol (result, (_tmp0 = vala_unresolved_symbol_copy (self->priv->_unresolved_symbol)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaDataType* arg;
			arg = ((ValaDataType*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaDataType* _tmp1;
				_tmp1 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp1 = vala_data_type_copy (arg)));
				(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


static char* vala_unresolved_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (base);
	g_return_val_if_fail (scope == NULL || VALA_IS_SCOPE (scope), NULL);
	return vala_code_node_to_string (VALA_CODE_NODE (self->priv->_unresolved_symbol));
}


ValaUnresolvedSymbol* vala_unresolved_type_get_unresolved_symbol (ValaUnresolvedType* self) {
	g_return_val_if_fail (VALA_IS_UNRESOLVED_TYPE (self), NULL);
	return self->priv->_unresolved_symbol;
}


void vala_unresolved_type_set_unresolved_symbol (ValaUnresolvedType* self, ValaUnresolvedSymbol* value) {
	ValaUnresolvedSymbol* _tmp2;
	ValaUnresolvedSymbol* _tmp1;
	g_return_if_fail (VALA_IS_UNRESOLVED_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_unresolved_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_unresolved_symbol == NULL ? NULL : (self->priv->_unresolved_symbol = (g_object_unref (self->priv->_unresolved_symbol), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "unresolved-symbol");
}


static void vala_unresolved_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (object);
	switch (property_id) {
		case VALA_UNRESOLVED_TYPE_UNRESOLVED_SYMBOL:
		g_value_set_object (value, vala_unresolved_type_get_unresolved_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_unresolved_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (object);
	switch (property_id) {
		case VALA_UNRESOLVED_TYPE_UNRESOLVED_SYMBOL:
		vala_unresolved_type_set_unresolved_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_unresolved_type_class_init (ValaUnresolvedTypeClass * klass) {
	vala_unresolved_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaUnresolvedTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_unresolved_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_unresolved_type_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_unresolved_type_finalize;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_unresolved_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_unresolved_type_real_to_qualified_string;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_UNRESOLVED_TYPE_UNRESOLVED_SYMBOL, g_param_spec_object ("unresolved-symbol", "unresolved-symbol", "unresolved-symbol", VALA_TYPE_UNRESOLVED_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_unresolved_type_instance_init (ValaUnresolvedType * self) {
	self->priv = VALA_UNRESOLVED_TYPE_GET_PRIVATE (self);
}


static void vala_unresolved_type_finalize (GObject * obj) {
	ValaUnresolvedType * self;
	self = VALA_UNRESOLVED_TYPE (obj);
	(self->priv->_unresolved_symbol == NULL ? NULL : (self->priv->_unresolved_symbol = (g_object_unref (self->priv->_unresolved_symbol), NULL)));
	G_OBJECT_CLASS (vala_unresolved_type_parent_class)->finalize (obj);
}


GType vala_unresolved_type_get_type (void) {
	static GType vala_unresolved_type_type_id = 0;
	if (vala_unresolved_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnresolvedTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unresolved_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnresolvedType), 0, (GInstanceInitFunc) vala_unresolved_type_instance_init };
		vala_unresolved_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaUnresolvedType", &g_define_type_info, 0);
	}
	return vala_unresolved_type_type_id;
}




