/* libgda-4.0.vapi generated by vapigen, do not modify. */

[Version (deprecated_since = "4.2.13", replacement = "bindings distributed with libgda-4.0")]
namespace Gda {
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_attributes_manager_copy")]
	[Compact]
	public class AttributesManager {
		[CCode (has_construct_function = false)]
		public AttributesManager (bool for_objects, Gda.AttributesManagerSignal signal_func, void* signal_data);
		public void clear (void* ptr);
		public void copy (void* from, Gda.AttributesManager to_mgr, void* to);
		public void @foreach (void* ptr, Gda.AttributesManagerFunc func, void* data);
		public GLib.Value @get (void* ptr, string att_name);
		public void @set (void* ptr, string att_name, GLib.Value value);
		public void set_full (void* ptr, string att_name, GLib.Value value, GLib.DestroyNotify destroy);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Batch : GLib.Object {
		[CCode (has_construct_function = false)]
		public Batch ();
		public void add_statement (Gda.Statement stmt);
		public unowned Gda.Batch copy ();
		public static GLib.Quark error_quark ();
		public bool get_parameters (out unowned Gda.Set out_params) throws GLib.Error;
		public unowned GLib.SList<Gda.Statement> get_statements ();
		public void remove_statement (Gda.Statement stmt);
		public unowned string serialize ();
		public virtual signal void changed (GLib.Object changed_stmt);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_binary_copy", type_id = "gda_binary_get_type ()")]
	[Compact]
	public class Binary {
		public long binary_length;
		[CCode (array_length = false)]
		public weak uchar[] data;
		public static void* copy (void* boxed);
		public unowned string to_string (uint maxlen);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_blob_copy", type_id = "gda_blob_get_type ()")]
	[Compact]
	public class Blob {
		public weak Gda.Binary data;
		public weak Gda.BlobOp op;
		public static void* copy (void* boxed);
		public void set_op (Gda.BlobOp op);
		public unowned string to_string (uint maxlen);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class BlobOp : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BlobOp ();
		public virtual long get_length ();
		public virtual long read (Gda.Blob blob, long offset, long size);
		public bool read_all (Gda.Blob blob);
		public virtual long write (Gda.Blob blob, long offset);
		public virtual bool write_all (Gda.Blob blob);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Column : GLib.Object {
		[CCode (has_construct_function = false)]
		public Column ();
		public unowned Gda.Column copy ();
		public bool get_allow_null ();
		public GLib.Value get_attribute (string attribute);
		public bool get_auto_increment ();
		public unowned string get_dbms_type ();
		public GLib.Value get_default_value ();
		public unowned string get_description ();
		public GLib.Type get_g_type ();
		public unowned string get_name ();
		public int get_position ();
		public void set_allow_null (bool allow);
		public void set_attribute (string attribute, GLib.Value value, GLib.DestroyNotify destroy);
		public void set_auto_increment (bool is_auto);
		public void set_dbms_type (string dbms_type);
		public void set_default_value (GLib.Value default_value);
		public void set_description (string title);
		public void set_g_type (GLib.Type type);
		public void set_name (string name);
		public void set_position (int position);
		[NoAccessorMethod]
		public string id { owned get; set; }
		public virtual signal void g_type_changed (GLib.Type old_type, GLib.Type new_type);
		public virtual signal void name_changed (string old_name);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Config : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Config ();
		public static bool can_modify_system_config ();
		public static bool define_dsn (Gda.DsnInfo info) throws GLib.Error;
		public static bool dsn_needs_authentication (string dsn_name);
		public static GLib.Quark error_quark ();
		public static unowned Gda.Config @get ();
		public static Gda.DsnInfo get_dsn_info (string dsn_name);
		public static Gda.DsnInfo get_dsn_info_at_index (int index);
		public static int get_dsn_info_index (string dsn_name);
		public static int get_nb_dsn ();
		public static unowned Gda.ServerProvider get_provider (string provider_name) throws GLib.Error;
		public static unowned Gda.ProviderInfo get_provider_info (string provider_name);
		public static unowned Gda.DataModel list_dsn ();
		public static unowned Gda.DataModel list_providers ();
		public static bool remove_dsn (string dsn_name) throws GLib.Error;
		[NoAccessorMethod]
		public string system_filename { owned get; set; }
		[NoAccessorMethod]
		public string user_filename { owned get; set; }
		public virtual signal void dsn_added (void* new_dsn);
		public virtual signal void dsn_changed (void* dsn);
		public virtual signal void dsn_removed (void* old_dsn);
		public virtual signal void dsn_to_be_removed (void* old_dsn);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Connection : GLib.Object, Gda.Lockable {
		[CCode (has_construct_function = false)]
		protected Connection ();
		public bool add_savepoint (string name) throws GLib.Error;
		public bool async_cancel (uint task_id) throws GLib.Error;
		public unowned GLib.Object async_fetch_result (uint task_id, out unowned Gda.Set last_insert_row) throws GLib.Error;
		public uint async_statement_execute (Gda.Statement stmt, Gda.Set @params, Gda.StatementModelUsage model_usage, GLib.Type[] col_types, bool need_last_insert_row) throws GLib.Error;
		public unowned GLib.SList<GLib.Object> batch_execute (Gda.Batch batch, Gda.Set @params, Gda.StatementModelUsage model_usage) throws GLib.Error;
		public bool begin_transaction (string name, Gda.TransactionIsolation level) throws GLib.Error;
		public void close ();
		public void close_no_warning ();
		public bool commit_transaction (string name) throws GLib.Error;
		public unowned Gda.ServerOperation create_operation (Gda.ServerOperationType type, Gda.Set options) throws GLib.Error;
		public unowned Gda.SqlParser create_parser ();
		public bool delete_row_from_table (string table, string condition_column_name, GLib.Value condition_value) throws GLib.Error;
		public bool delete_savepoint (string name) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public int execute_non_select_command (string sql) throws GLib.Error;
		public unowned Gda.DataModel execute_select_command (string sql) throws GLib.Error;
		public unowned string get_authentication ();
		public unowned string get_cnc_string ();
		public unowned string get_dsn ();
		public unowned GLib.List<Gda.ConnectionEvent> get_events ();
		public unowned Gda.MetaStore get_meta_store ();
		public unowned Gda.DataModel get_meta_store_data (Gda.ConnectionMetaType meta_type, int nb_filters) throws GLib.Error;
		public Gda.DataModel get_meta_store_data_v (Gda.ConnectionMetaType meta_type, GLib.List<Gda.Holder> filters) throws GLib.Error;
		public Gda.ConnectionOptions get_options ();
		public unowned Gda.ServerProvider get_provider ();
		public unowned string get_provider_name ();
		public unowned Gda.TransactionStatus get_transaction_status ();
		public bool insert_row_into_table (string table) throws GLib.Error;
		public bool insert_row_into_table_v (string table, GLib.SList col_names, GLib.SList values) throws GLib.Error;
		public bool is_opened ();
		public bool open () throws GLib.Error;
		public static unowned Gda.Connection open_from_dsn (string dsn, string? auth_string, Gda.ConnectionOptions options) throws GLib.Error;
		public static unowned Gda.Connection open_from_string (string provider_name, string? cnc_string, string? auth_string, Gda.ConnectionOptions options) throws GLib.Error;
		public unowned Gda.Statement parse_sql_string (string sql, out unowned Gda.Set @params) throws GLib.Error;
		public bool perform_operation (Gda.ServerOperation op) throws GLib.Error;
		public unowned string quote_sql_identifier (string id);
		public unowned GLib.SList repetitive_statement_execute (Gda.RepetitiveStatement rstmt, Gda.StatementModelUsage model_usage, GLib.Type[] col_types, bool stop_on_error) throws GLib.Error;
		public bool rollback_savepoint (string name) throws GLib.Error;
		public bool rollback_transaction (string name) throws GLib.Error;
		public unowned GLib.Object statement_execute (Gda.Statement stmt, Gda.Set @params, Gda.StatementModelUsage model_usage, out unowned Gda.Set last_insert_row) throws GLib.Error;
		public int statement_execute_non_select (Gda.Statement stmt, Gda.Set? @params, out unowned Gda.Set? last_insert_row) throws GLib.Error;
		public unowned Gda.DataModel statement_execute_select (Gda.Statement stmt, Gda.Set @params) throws GLib.Error;
		public unowned Gda.DataModel statement_execute_select_full (Gda.Statement stmt, Gda.Set @params, Gda.StatementModelUsage model_usage, GLib.Type[] col_types) throws GLib.Error;
		public unowned Gda.DataModel statement_execute_select_fullv (Gda.Statement stmt, Gda.Set @params, Gda.StatementModelUsage model_usage) throws GLib.Error;
		public bool statement_prepare (Gda.Statement stmt) throws GLib.Error;
		public unowned string statement_to_sql (Gda.Statement stmt, Gda.Set @params, Gda.StatementSqlFlag flags, GLib.SList<Gda.Holder> params_used) throws GLib.Error;
		public static void string_split (string str, string out_cnc_params, string out_provider, string out_username, string out_password);
		public bool supports_feature (Gda.ConnectionFeature feature);
		public bool update_meta_store (Gda.MetaContext context) throws GLib.Error;
		public bool update_row_in_table (string table, string condition_column_name, GLib.Value condition_value) throws GLib.Error;
		public bool update_row_in_table_v (string table, string condition_column_name, GLib.Value condition_value, GLib.SList col_names, GLib.SList values) throws GLib.Error;
		public unowned string value_to_sql_string (GLib.Value from);
		[NoAccessorMethod]
		public string auth_string { owned get; set; }
		[NoAccessorMethod]
		public string cnc_string { owned get; set; }
		[NoAccessorMethod]
		public string dsn { owned get; set; }
		[NoAccessorMethod]
		public int events_history_size { get; set; }
		[NoAccessorMethod]
		public bool is_wrapper { get; construct; }
		[NoAccessorMethod]
		public Gda.MetaStore meta_store { owned get; set; }
		[NoAccessorMethod]
		public bool monitor_wrapped_in_mainloop { get; set; }
		[NoAccessorMethod]
		public Gda.ConnectionOptions options { get; set; }
		[NoAccessorMethod]
		public Gda.ServerProvider provider { owned get; set; }
		[NoAccessorMethod]
		public void* thread_owner { get; set; }
		public virtual signal void conn_closed ();
		public virtual signal void conn_opened ();
		public virtual signal void conn_to_close ();
		public virtual signal void dsn_changed ();
		public virtual signal void error (Gda.ConnectionEvent error);
		public virtual signal void transaction_status_changed ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class ConnectionEvent : GLib.Object {
		[CCode (has_construct_function = false)]
		public ConnectionEvent (Gda.ConnectionEventType type);
		public long get_code ();
		public unowned string get_description ();
		public Gda.ConnectionEventType get_event_type ();
		public Gda.ConnectionEventCode get_gda_code ();
		public unowned string get_source ();
		public unowned string get_sqlstate ();
		public void set_code (long code);
		public void set_description (string description);
		public void set_event_type (Gda.ConnectionEventType type);
		public void set_gda_code (Gda.ConnectionEventCode code);
		public void set_source (string source);
		public void set_sqlstate (string sqlstate);
		[NoAccessorMethod]
		public int type { get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class DataAccessWrapper : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false, type = "GdaDataModel*")]
		public DataAccessWrapper (Gda.DataModel model);
		[NoAccessorMethod]
		public Gda.DataModel model { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class DataComparator : GLib.Object {
		[CCode (has_construct_function = false, type = "GObject*")]
		public DataComparator (Gda.DataModel old_model, Gda.DataModel new_model);
		public bool compute_diff () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public unowned Gda.Diff get_diff (int pos);
		public int get_n_diffs ();
		public void set_key_columns (int col_numbers, int nb_cols);
		[NoAccessorMethod]
		public Gda.DataModel new_model { owned get; set; }
		[NoAccessorMethod]
		public Gda.DataModel old_model { owned get; set; }
		public virtual signal bool diff_computed (void* diff);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class DataModelArray : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false, type = "GdaDataModel*")]
		public DataModelArray (int cols);
		public void clear ();
		public static unowned Gda.DataModelArray copy_model (Gda.DataModel src) throws GLib.Error;
		public unowned Gda.Row get_row (int row) throws GLib.Error;
		public void set_n_columns (int cols);
		[CCode (has_construct_function = false, sentinel = "", type = "GdaDataModel*")]
		public DataModelArray.with_g_types (int cols, ...);
		[NoAccessorMethod]
		public uint n_columns { get; set; }
		[NoAccessorMethod]
		public bool read_only { get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class DataModelDir : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false, type = "GdaDataModel*")]
		public DataModelDir (string basedir);
		public void clean_errors ();
		public unowned GLib.SList<GLib.Error> get_errors ();
		[NoAccessorMethod]
		public string basedir { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class DataModelImport : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false)]
		protected DataModelImport ();
		public void clean_errors ();
		[CCode (has_construct_function = false, type = "GdaDataModel*")]
		public DataModelImport.file (string filename, bool random_access, Gda.Set options);
		public static bool from_file (Gda.DataModel model, string file, GLib.HashTable cols_trans, Gda.Set options) throws GLib.Error;
		public static bool from_model (Gda.DataModel to, Gda.DataModel from, bool overwrite, GLib.HashTable cols_trans) throws GLib.Error;
		public static bool from_string (Gda.DataModel model, string str, GLib.HashTable cols_trans, Gda.Set options) throws GLib.Error;
		[CCode (cname = "gda_data_model_import_new_xml_node", has_construct_function = false, type = "GdaDataModel*")]
		public DataModelImport.from_xml_node (Xml.Node node);
		public unowned GLib.SList<GLib.Error> get_errors ();
		[CCode (has_construct_function = false, type = "GdaDataModel*")]
		public DataModelImport.mem (string data, bool random_access, Gda.Set options);
		[NoAccessorMethod]
		public string data_string { owned get; construct; }
		[NoAccessorMethod]
		public string filename { owned get; construct; }
		[NoAccessorMethod]
		public Gda.Set options { owned get; construct; }
		[NoAccessorMethod]
		public bool random_access { get; construct; }
		[NoAccessorMethod]
		public bool strict { get; set construct; }
		[NoAccessorMethod]
		public void* xml_node { get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class DataModelIter : Gda.Set {
		[CCode (has_construct_function = false)]
		protected DataModelIter ();
		public static GLib.Quark error_quark ();
		public unowned Gda.Holder get_holder_for_field (int col);
		public int get_row ();
		public unowned GLib.Value? get_value_at (int col);
		public unowned GLib.Value? get_value_for_field (string field_name);
		public void invalidate_contents ();
		public bool is_valid ();
		public bool move_next ();
		public static bool move_next_default (Gda.DataModel model, Gda.DataModelIter iter);
		public bool move_prev ();
		public static bool move_prev_default (Gda.DataModel model, Gda.DataModelIter iter);
		public bool move_to_row (int row);
		public static bool move_to_row_default (Gda.DataModel model, Gda.DataModelIter iter, int row);
		public bool set_value_at (int col, GLib.Value value) throws GLib.Error;
		[NoAccessorMethod]
		public int current_row { get; set; }
		[NoAccessorMethod]
		public Gda.DataModel data_model { owned get; construct; }
		[NoAccessorMethod]
		public Gda.DataModel forced_model { owned get; set; }
		[NoAccessorMethod]
		public bool update_model { get; set; }
		public virtual signal void end_of_data ();
		public virtual signal void row_changed (int row);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class DataProxy : GLib.Object, Gda.DataModel {
		[CCode (has_construct_function = false, type = "GObject*")]
		public DataProxy (Gda.DataModel model);
		public void alter_value_attributes (int proxy_row, int col, Gda.ValueAttribute alter_flags);
		public bool apply_all_changes () throws GLib.Error;
		public bool apply_row_changes (int proxy_row) throws GLib.Error;
		public bool cancel_all_changes ();
		public void cancel_row_changes (int proxy_row, int col);
		public void @delete (int proxy_row);
		public static GLib.Quark error_quark ();
		public unowned string get_filter_expr ();
		public int get_filtered_n_rows ();
		public int get_n_modified_rows ();
		public int get_n_new_rows ();
		public unowned Gda.DataModel get_proxied_model ();
		public int get_proxied_model_n_cols ();
		public int get_proxied_model_n_rows ();
		public int get_proxied_model_row (int proxy_row);
		public int get_sample_end ();
		public int get_sample_size ();
		public int get_sample_start ();
		public Gda.ValueAttribute get_value_attributes (int proxy_row, int col);
		public unowned GLib.SList<GLib.Value> get_values (int proxy_row, int cols_index, int n_cols);
		public bool has_changed ();
		public bool is_read_only ();
		public bool row_has_changed (int proxy_row);
		public bool row_is_deleted (int proxy_row);
		public bool row_is_inserted (int proxy_row);
		public bool set_filter_expr (string filter_expr) throws GLib.Error;
		public bool set_ordering_column (int col) throws GLib.Error;
		public void set_sample_size (int sample_size);
		public void set_sample_start (int sample_start);
		public void undelete (int proxy_row);
		[NoAccessorMethod]
		public bool defer_sync { get; set; }
		[NoAccessorMethod]
		public Gda.DataModel model { owned get; set construct; }
		[NoAccessorMethod]
		public bool prepend_null_entry { get; set; }
		public int sample_size { get; set construct; }
		public virtual signal void filter_changed ();
		public virtual signal void row_changes_applied (int row, int proxied_row);
		public virtual signal void row_delete_changed (int row, bool to_be_deleted);
		public virtual signal void sample_changed (int sample_start, int sample_end);
		public virtual signal void sample_size_changed (int sample_size);
		public virtual signal unowned GLib.Error validate_row_changes (int row, int proxied_row);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class DataSelect : GLib.Object, Gda.DataModel {
		public int advertized_nrows;
		public int nb_stored_rows;
		public weak Gda.PStmt prep_stmt;
		[CCode (has_construct_function = false)]
		protected DataSelect ();
		public bool compute_columns_attributes () throws GLib.Error;
		public bool compute_modification_statements () throws GLib.Error;
		public bool compute_row_selection_condition () throws GLib.Error;
		public static GLib.Quark error_quark ();
		[NoWrapper]
		public virtual bool fetch_at (out unowned Gda.Row prow, int rownum) throws GLib.Error;
		[NoWrapper]
		public virtual int fetch_nb_rows ();
		[NoWrapper]
		public virtual bool fetch_next (out unowned Gda.Row prow, int rownum) throws GLib.Error;
		[NoWrapper]
		public virtual bool fetch_prev (out unowned Gda.Row prow, int rownum) throws GLib.Error;
		[NoWrapper]
		public virtual bool fetch_random (out unowned Gda.Row prow, int rownum) throws GLib.Error;
		public unowned Gda.Connection get_connection ();
		public unowned Gda.Row get_stored_row (int rownum);
		public bool rerun () throws GLib.Error;
		public void set_columns (GLib.SList columns);
		public bool set_modification_statement (Gda.Statement mod_stmt) throws GLib.Error;
		public bool set_modification_statement_sql (string sql) throws GLib.Error;
		public bool set_row_selection_condition (Gda.SqlExpr expr) throws GLib.Error;
		public bool set_row_selection_condition_sql (string sql_where) throws GLib.Error;
		[NoWrapper]
		public virtual bool store_all () throws GLib.Error;
		public void take_row (Gda.Row row, int rownum);
		[NoAccessorMethod]
		public bool auto_reset { get; set; }
		public Gda.Connection connection { get; construct; }
		[NoAccessorMethod]
		public Gda.Statement delete_stmt { owned get; set; }
		[NoAccessorMethod]
		public Gda.Set exec_params { owned get; construct; }
		[NoAccessorMethod]
		public Gda.Statement insert_stmt { owned get; set; }
		[NoAccessorMethod]
		public uint model_usage { get; construct; }
		[NoAccessorMethod]
		public Gda.PStmt prepared_stmt { owned get; set; }
		[NoAccessorMethod]
		public Gda.Statement select_stmt { owned get; }
		[NoAccessorMethod]
		public bool store_all_rows { get; set; }
		[NoAccessorMethod]
		public Gda.Statement update_stmt { owned get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class Diff {
		public int new_row;
		public int old_row;
		public Gda.DiffType type;
		public weak GLib.HashTable values;
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_geometricpoint_copy", free_function = "gda_geometricpoint_free", type_id = "gda_geometricpoint_get_type ()")]
	[Compact]
	public class GeometricPoint {
		public double x;
		public double y;
		[CCode (cname = "gda_geometricpoint_copy")]
		public static void* copy (void* boxed);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class HandlerBin : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerBin ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class HandlerBinPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class HandlerBoolean : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerBoolean ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class HandlerBooleanPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class HandlerNumerical : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerNumerical ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class HandlerNumericalPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class HandlerString : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerString ();
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerString.with_provider (Gda.ServerProvider prov, Gda.Connection cnc);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class HandlerStringPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class HandlerTime : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerTime ();
		public unowned string get_format (GLib.Type type);
		public unowned string get_no_locale_str_from_value (GLib.Value value);
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerTime.no_locale ();
		public void set_sql_spec (GLib.DateDMY first, GLib.DateDMY sec, GLib.DateDMY third, char separator, bool twodigits_years);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class HandlerTimePriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class HandlerType : GLib.Object, Gda.DataHandler {
		[CCode (has_construct_function = false, type = "GdaDataHandler*")]
		public HandlerType ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class HandlerTypePriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Holder : GLib.Object {
		[CCode (has_construct_function = false)]
		public Holder (GLib.Type type);
		[NoWrapper]
		public virtual void att_changed (string att_name, GLib.Value att_value);
		public unowned Gda.Holder copy ();
		public static GLib.Quark error_quark ();
		public void force_invalid ();
		public GLib.Value get_attribute (string attribute);
		public unowned Gda.Holder get_bind ();
		public GLib.Value get_default_value ();
		public GLib.Type get_g_type ();
		public unowned string get_id ();
		public bool get_not_null ();
		public unowned Gda.DataModel get_source_model (int col);
		public GLib.Value get_value ();
		public unowned string get_value_str (Gda.DataHandler dh);
		[CCode (has_construct_function = false)]
		public Holder.@inline (GLib.Type type, string id);
		public bool is_valid ();
		public void set_attribute (string attribute, GLib.Value value, GLib.DestroyNotify destroy);
		public bool set_bind (Gda.Holder bind_to) throws GLib.Error;
		public void set_default_value (GLib.Value value);
		public void set_not_null (bool not_null);
		public bool set_source_model (Gda.DataModel model, int col) throws GLib.Error;
		public bool set_value (GLib.Value value) throws GLib.Error;
		public bool set_value_str (Gda.DataHandler dh, string value) throws GLib.Error;
		public bool set_value_to_default ();
		public GLib.Value take_static_value (GLib.Value value, bool value_changed) throws GLib.Error;
		public bool take_value (GLib.Value value) throws GLib.Error;
		public bool value_is_default ();
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public Gda.Holder full_bind { owned get; set; }
		[NoAccessorMethod]
		public GLib.Type g_type { get; set construct; }
		[NoAccessorMethod]
		public string id { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		public bool not_null { get; set; }
		[NoAccessorMethod]
		public Gda.Holder simple_bind { owned get; set; }
		[NoAccessorMethod]
		public int source_column { get; set; }
		public Gda.DataModel source_model { get; set; }
		public virtual signal void attribute_changed (string p0, GLib.Value p1);
		public virtual signal void changed ();
		public virtual signal void source_changed ();
		public virtual signal unowned GLib.Error validate_change (GLib.Value new_value);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class MetaContext {
		public weak string column_names;
		public GLib.Value column_values;
		public int size;
		public weak string table_name;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class MetaDbObject {
		public weak GLib.SList depend_list;
		public void* extra;
		public weak string obj_catalog;
		public weak string obj_full_name;
		public weak string obj_name;
		public weak string obj_owner;
		public weak string obj_schema;
		public weak string obj_short_name;
		public Gda.MetaDbObjectType obj_type;
		public bool outdated;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class MetaStore : GLib.Object {
		[CCode (has_construct_function = false)]
		public MetaStore (string cnc_string);
		public unowned Gda.DataModel create_modify_data_model (string table_name);
		public bool declare_foreign_key (Gda.MetaStruct mstruct, string fk_name, string catalog, string schema, string table, string ref_catalog, string ref_schema, string ref_table, uint nb_cols, string colnames, string ref_colnames) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public unowned Gda.DataModel extract (string select_sql) throws GLib.Error;
		public bool get_attribute_value (string att_name, string att_value) throws GLib.Error;
		public unowned Gda.Connection get_internal_connection ();
		public int get_version ();
		public bool modify (string table_name, Gda.DataModel new_data, string condition) throws GLib.Error;
		public bool modify_with_context (Gda.MetaContext context, Gda.DataModel new_data) throws GLib.Error;
		public bool schema_add_custom_object (string xml_description) throws GLib.Error;
		public unowned GLib.SList schema_get_all_tables ();
		public unowned GLib.SList schema_get_depend_tables (string table_name);
		public unowned Gda.MetaStruct schema_get_structure () throws GLib.Error;
		public bool schema_remove_custom_object (string obj_name) throws GLib.Error;
		public bool set_attribute_value (string att_name, string att_value) throws GLib.Error;
		public void set_identifiers_style (Gda.SqlIdentifierStyle style);
		public void set_reserved_keywords_func (Gda.SqlReservedKeywordsFunc func);
		public static unowned string sql_identifier_quote (string id, Gda.Connection cnc);
		public bool undeclare_foreign_key (Gda.MetaStruct mstruct, string fk_name, string catalog, string schema, string table, string ref_catalog, string ref_schema, string ref_table) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public MetaStore.with_file (string file_name);
		public string catalog { construct; }
		[NoAccessorMethod]
		public Gda.Connection cnc { owned get; construct; }
		public string cnc_string { construct; }
		public string schema { construct; }
		public virtual signal void meta_changed (GLib.SList<Gda.MetaStoreChange> changes);
		public virtual signal void meta_reset ();
		public virtual signal unowned GLib.Error suggest_update (Gda.MetaContext suggest);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class MetaStoreChange {
		public Gda.MetaStoreChangeType c_type;
		public weak GLib.HashTable keys;
		public weak string table_name;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class MetaStruct : GLib.Object {
		[CCode (has_construct_function = false)]
		public MetaStruct (Gda.MetaStore store, Gda.MetaStructFeature features);
		public unowned Gda.MetaDbObject complement (Gda.MetaDbObjectType type, GLib.Value catalog, GLib.Value schema, GLib.Value name) throws GLib.Error;
		public bool complement_all () throws GLib.Error;
		public bool complement_default () throws GLib.Error;
		public bool complement_depend (Gda.MetaDbObject dbo) throws GLib.Error;
		public bool complement_schema (GLib.Value catalog, GLib.Value schema) throws GLib.Error;
		public unowned string dump_as_graph (Gda.MetaGraphInfo info) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public GLib.SList<Gda.MetaDbObject> get_all_db_objects ();
		public unowned Gda.MetaDbObject get_db_object (GLib.Value catalog, GLib.Value schema, GLib.Value name);
		public unowned Gda.MetaTableColumn get_table_column (Gda.MetaTable table, GLib.Value col_name);
		public bool sort_db_objects (Gda.MetaSortType sort_type) throws GLib.Error;
		[NoAccessorMethod]
		public uint features { get; construct; }
		[NoAccessorMethod]
		public Gda.MetaStore meta_store { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class MetaTable {
		public weak GLib.SList columns;
		public weak GLib.SList fk_list;
		public int pk_cols_array;
		public int pk_cols_nb;
		public weak GLib.SList reverse_fk_list;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class MetaTableColumn {
		public weak string column_name;
		public weak string column_type;
		public weak string default_value;
		public GLib.Type gtype;
		public bool nullok;
		public bool pkey;
		public void foreach_attribute (Gda.AttributesManagerFunc func, void* data);
		public GLib.Value get_attribute (string attribute);
		public void set_attribute (string attribute, GLib.Value value, GLib.DestroyNotify destroy);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class MetaTableForeignKey {
		public int cols_nb;
		public void* declared;
		public weak Gda.MetaDbObject depend_on;
		public int fk_cols_array;
		public weak string fk_name;
		public weak string fk_names_array;
		public weak Gda.MetaDbObject meta_table;
		public void* on_delete_policy;
		public void* on_update_policy;
		public int ref_pk_cols_array;
		public weak string ref_pk_names_array;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class MetaView {
		public bool is_updatable;
		public weak Gda.MetaTable table;
		public weak string view_def;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class Mutex {
		[CCode (has_construct_function = false)]
		public Mutex ();
		public void @lock ();
		public bool trylock ();
		public void unlock ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_numeric_copy", type_id = "gda_numeric_get_type ()")]
	[Compact]
	public class Numeric {
		public weak string number;
		public long precision;
		public void* reserved;
		public long width;
		public static void* copy (void* boxed);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class PStmt : GLib.Object {
		public int ncols;
		public weak GLib.SList param_ids;
		public weak string sql;
		public weak GLib.SList tmpl_columns;
		[CCode (array_length = false)]
		public weak GLib.Type[] types;
		[CCode (has_construct_function = false)]
		protected PStmt ();
		public void copy_contents (Gda.PStmt dest);
		public unowned Gda.Statement get_gda_statement ();
		public void set_gda_statement (Gda.Statement stmt);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class ProviderInfo {
		public weak Gda.Set auth_params;
		public weak string description;
		public weak Gda.Set dsn_params;
		public weak string id;
		public weak string location;
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_quark_list_copy", type_id = "gda_quark_list_get_type ()")]
	[Compact]
	public class QuarkList {
		[CCode (has_construct_function = false)]
		public QuarkList ();
		public void add_from_string (string str, bool cleanup);
		public void clear ();
		public unowned Gda.QuarkList copy ();
		public unowned string find (string name);
		public void @foreach (GLib.HFunc func);
		[CCode (has_construct_function = false)]
		public QuarkList.from_string (string str);
		public void remove (string name);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class RepetitiveStatement : GLib.Object {
		[CCode (has_construct_function = false)]
		public RepetitiveStatement (Gda.Statement stmt);
		public bool append_set (Gda.Set values, bool make_copy);
		public unowned GLib.SList get_all_sets ();
		public bool get_template_set (out unowned Gda.Set @set) throws GLib.Error;
		[NoAccessorMethod]
		public Gda.Statement statement { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Row : GLib.Object {
		[CCode (has_construct_function = false)]
		public Row (int count);
		public int get_length ();
		public GLib.Value get_value (int num);
		public void invalidate_value (GLib.Value value);
		public bool value_is_valid (GLib.Value value);
		[NoAccessorMethod]
		public int nb_values { set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class ServerOperation : GLib.Object {
		[CCode (has_construct_function = false)]
		public ServerOperation (Gda.ServerOperationType op_type, string xml_file);
		public uint add_item_to_sequence (string seq_path);
		public bool del_item_from_sequence (string item_path);
		public static GLib.Quark error_quark ();
		public unowned Gda.ServerOperationNode get_node_info (string path_format);
		public unowned string get_node_parent (string path);
		public unowned string get_node_path_portion (string path);
		public Gda.ServerOperationNodeType get_node_type (string path, Gda.ServerOperationNodeStatus status);
		public Gda.ServerOperationType get_op_type ();
		public unowned string get_root_nodes ();
		public unowned string get_sequence_item_names (string path);
		public uint get_sequence_max_size (string path);
		public uint get_sequence_min_size (string path);
		public unowned string get_sequence_name (string path);
		public uint get_sequence_size (string path);
		public unowned string get_sql_identifier_at (Gda.Connection cnc, Gda.ServerProvider prov, string path_format);
		public GLib.Value get_value_at (string path_format);
		public bool is_valid (string xml_file) throws GLib.Error;
		public bool load_data_from_xml (Xml.Node node) throws GLib.Error;
		public static unowned string op_type_to_string (Gda.ServerOperationType type);
		public bool perform_create_database (string provider) throws GLib.Error;
		public bool perform_create_table () throws GLib.Error;
		public bool perform_drop_database (string provider) throws GLib.Error;
		public bool perform_drop_table () throws GLib.Error;
		public static unowned Gda.ServerOperation prepare_create_database (string provider, string db_name) throws GLib.Error;
		public static unowned Gda.ServerOperation prepare_create_table (Gda.Connection cnc, string table_name) throws GLib.Error;
		public static unowned Gda.ServerOperation prepare_drop_database (string provider, string db_name) throws GLib.Error;
		public static unowned Gda.ServerOperation prepare_drop_table (Gda.Connection cnc, string table_name) throws GLib.Error;
		public unowned Xml.Node save_data_to_xml () throws GLib.Error;
		[NoWrapper]
		public virtual void seq_item_added (string seq_path, int item_index);
		[NoWrapper]
		public virtual void seq_item_remove (string seq_path, int item_index);
		public bool set_value_at (string value, string path_format) throws GLib.Error;
		public static Gda.ServerOperationType string_to_op_type (string str);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		public int op_type { get; construct; }
		[NoAccessorMethod]
		public Gda.ServerProvider provider { owned get; construct; }
		public string spec_filename { construct; }
		public virtual signal void sequence_item_added (string p0, int p1);
		public virtual signal void sequence_item_remove (string p0, int p1);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class ServerOperationNode {
		public weak Gda.Column column;
		public weak Gda.DataModel model;
		public weak Gda.Holder param;
		public weak Gda.Set plist;
		public void* priv;
		public Gda.ServerOperationNodeStatus status;
		public Gda.ServerOperationNodeType type;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class ServerProvider : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ServerProvider ();
		[NoWrapper]
		public virtual bool add_savepoint (Gda.Connection cnc, string name) throws GLib.Error;
		[NoWrapper]
		public virtual bool begin_transaction (Gda.Connection cnc, string name, Gda.TransactionIsolation level) throws GLib.Error;
		[NoWrapper]
		public virtual bool cancel (Gda.Connection cnc, uint task_id) throws GLib.Error;
		[NoWrapper]
		public virtual bool close_connection (Gda.Connection cnc);
		[NoWrapper]
		public virtual bool commit_transaction (Gda.Connection cnc, string name) throws GLib.Error;
		[NoWrapper]
		public virtual unowned Gda.Connection create_connection ();
		public virtual unowned Gda.ServerOperation create_operation (Gda.Connection cnc, Gda.ServerOperationType type, Gda.Set options) throws GLib.Error;
		public virtual unowned Gda.SqlParser create_parser (Gda.Connection cnc);
		[NoWrapper]
		public virtual bool delete_savepoint (Gda.Connection cnc, string name) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public virtual unowned string escape_string (Gda.Connection cnc, string str);
		public unowned string find_file (string inst_dir, string filename);
		[NoWrapper]
		public virtual unowned Gda.DataHandler get_data_handler (Gda.Connection cnc, GLib.Type g_type, string dbms_type);
		public unowned Gda.DataHandler get_data_handler_dbms (Gda.Connection cnc, string for_type);
		public unowned Gda.DataHandler get_data_handler_default (Gda.Connection cnc, GLib.Type type, string dbms_type);
		public unowned Gda.DataHandler get_data_handler_g_type (Gda.Connection cnc, GLib.Type for_type);
		[NoWrapper]
		public virtual unowned string get_database (Gda.Connection cnc);
		[NoWrapper]
		public virtual unowned string get_def_dbms_type (Gda.Connection cnc, GLib.Type g_type);
		public unowned string get_default_dbms_type (Gda.Connection cnc, GLib.Type type);
		public virtual unowned string get_name ();
		public static int get_schema_nb_columns (Gda.ConnectionSchema schema);
		public virtual unowned string get_server_version (Gda.Connection cnc);
		public virtual unowned string get_version ();
		[NoWrapper]
		public virtual bool handle_async (Gda.Connection cnc) throws GLib.Error;
		public void handler_declare (Gda.DataHandler dh, Gda.Connection cnc, GLib.Type g_type, string dbms_type);
		public unowned Gda.DataHandler handler_find (Gda.Connection cnc, GLib.Type g_type, string dbms_type);
		[NoWrapper]
		public virtual unowned string identifier_quote (Gda.Connection cnc, string id, bool for_meta_store, bool force_quotes);
		public static bool init_schema_model (Gda.DataModel model, Gda.ConnectionSchema schema);
		public unowned Gda.SqlParser internal_get_parser ();
		[NoWrapper]
		public virtual bool is_busy (Gda.Connection cnc) throws GLib.Error;
		public static unowned string load_file_contents (string inst_dir, string data_dir, string filename);
		[NoWrapper]
		public virtual bool open_connection (Gda.Connection cnc, Gda.QuarkList @params, Gda.QuarkList auth, uint task_id, Gda.ServerProviderAsyncCallback async_cb, void* cb_data);
		public virtual bool perform_operation (Gda.Connection cnc, Gda.ServerOperation op) throws GLib.Error;
		public bool perform_operation_default (Gda.Connection cnc, Gda.ServerOperation op) throws GLib.Error;
		public virtual unowned string render_operation (Gda.Connection cnc, Gda.ServerOperation op) throws GLib.Error;
		[NoWrapper]
		public virtual bool rollback_savepoint (Gda.Connection cnc, string name) throws GLib.Error;
		[NoWrapper]
		public virtual bool rollback_transaction (Gda.Connection cnc, string name) throws GLib.Error;
		[NoWrapper]
		public virtual unowned GLib.Object statement_execute (Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params, Gda.StatementModelUsage model_usage, GLib.Type[] col_types, out unowned Gda.Set last_inserted_row, uint task_id, Gda.ServerProviderExecCallback exec_cb, void* cb_data) throws GLib.Error;
		[NoWrapper]
		public virtual bool statement_prepare (Gda.Connection cnc, Gda.Statement stmt) throws GLib.Error;
		[NoWrapper]
		public virtual unowned Gda.SqlStatement statement_rewrite (Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params) throws GLib.Error;
		[NoWrapper]
		public virtual unowned string statement_to_sql (Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params, Gda.StatementSqlFlag flags, GLib.SList params_used) throws GLib.Error;
		public GLib.Value string_to_value (Gda.Connection cnc, string str, GLib.Type preferred_type, string dbms_type);
		public virtual bool supports_feature (Gda.Connection cnc, Gda.ConnectionFeature feature);
		public virtual bool supports_operation (Gda.Connection cnc, Gda.ServerOperationType type, Gda.Set options);
		public static bool test_schema_model (Gda.DataModel model, Gda.ConnectionSchema schema) throws GLib.Error;
		public virtual unowned string unescape_string (Gda.Connection cnc, string str);
		public unowned string value_to_sql_string (Gda.Connection cnc, GLib.Value from);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class ServerProviderHandlerInfo {
		public weak Gda.Connection cnc;
		public weak string dbms_type;
		public GLib.Type g_type;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class ServerProviderInfo {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class ServerProviderMeta {
		public weak GLib.Callback character_sets;
		public weak GLib.Callback check_columns;
		public weak GLib.Callback collations;
		public weak GLib.Callback columns;
		public weak GLib.Callback constraints_dom;
		public weak GLib.Callback constraints_ref;
		public weak GLib.Callback constraints_tab;
		public weak GLib.Callback domains;
		public weak GLib.Callback el_types;
		public weak GLib.Callback enums;
		public weak GLib.Callback index_cols;
		public weak GLib.Callback indexes_tab;
		public weak GLib.Callback key_columns;
		public weak GLib.Callback routine_col;
		public weak GLib.Callback routine_par;
		public weak GLib.Callback routines;
		public weak GLib.Callback schemata;
		public weak GLib.Callback tables_views;
		public weak GLib.Callback triggers;
		public weak GLib.Callback udt;
		public weak GLib.Callback udt_cols;
		public weak GLib.Callback view_cols;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class ServerProviderXa {
		public weak GLib.Callback xa_commit;
		public weak GLib.Callback xa_end;
		public weak GLib.Callback xa_prepare;
		public weak GLib.Callback xa_recover;
		public weak GLib.Callback xa_rollback;
		public weak GLib.Callback xa_start;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Set : GLib.Object {
		public weak GLib.SList groups_list;
		public weak GLib.SList nodes_list;
		public weak GLib.SList sources_list;
		[CCode (has_construct_function = false)]
		public Set (GLib.SList<Gda.Holder> holders);
		public bool add_holder (Gda.Holder holder);
		public unowned Gda.Set copy ();
		public static GLib.Quark error_quark ();
		[CCode (has_construct_function = false)]
		public Set.from_spec_node (Xml.Node xml_spec) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Set.from_spec_string (string xml_spec) throws GLib.Error;
		public unowned Gda.SetGroup get_group (Gda.Holder holder);
		public unowned Gda.Holder get_holder (string holder_id);
		public GLib.Value get_holder_value (string holder_id);
		public unowned Gda.SetNode get_node (Gda.Holder holder);
		public unowned Gda.Holder get_nth_holder (int pos);
		public unowned Gda.SetSource get_source (Gda.Holder holder);
		public unowned Gda.SetSource get_source_for_model (Gda.DataModel model);
		[CCode (has_construct_function = false)]
		public Set.@inline (int nb);
		public bool is_valid () throws GLib.Error;
		public void merge_with_set (Gda.Set set_to_merge);
		[CCode (has_construct_function = false)]
		public Set.read_only (GLib.SList holders);
		public void remove_holder (Gda.Holder holder);
		public void replace_source_model (Gda.SetSource source, Gda.DataModel model);
		public bool set_holder_value (string holder_id) throws GLib.Error;
		[NoAccessorMethod]
		public string description { owned get; set; }
		public void* holders { construct; }
		[NoAccessorMethod]
		public string id { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		public virtual signal void holder_attr_changed (Gda.Holder holder, string attr_name, GLib.Value attr_value);
		public virtual signal void holder_changed (Gda.Holder holder);
		public virtual signal void holder_type_set (Gda.Holder holder);
		public virtual signal void public_data_changed ();
		public virtual signal void source_model_changed (void* source);
		public virtual signal unowned GLib.Error validate_holder_change (Gda.Holder holder, GLib.Value new_value);
		public virtual signal unowned GLib.Error validate_set ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SetGroup {
		public weak GLib.SList nodes;
		public weak Gda.SetSource nodes_source;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SetNode {
		public weak Gda.Holder holder;
		public int source_column;
		public weak Gda.DataModel source_model;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SetSource {
		public weak Gda.DataModel data_model;
		public weak GLib.SList nodes;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlAnyPart {
		public weak Gda.SqlAnyPart parent;
		public Gda.SqlAnyPartType type;
		public bool check_structure () throws GLib.Error;
		public bool @foreach (Gda.SqlForeachFunc func, void* data) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class SqlBuilder : GLib.Object {
		[CCode (has_construct_function = false)]
		public SqlBuilder (Gda.SqlStatementType stmt_type);
		[CCode (sentinel = "")]
		public Gda.SqlBuilderId add_case (Gda.SqlBuilderId test_expr, Gda.SqlBuilderId else_expr, ...);
		public Gda.SqlBuilderId add_case_v (Gda.SqlBuilderId test_expr, Gda.SqlBuilderId else_expr, Gda.SqlBuilderId when_array, Gda.SqlBuilderId then_array, int args_size);
		public Gda.SqlBuilderId add_cond (Gda.SqlOperatorType op, Gda.SqlBuilderId op1, Gda.SqlBuilderId op2, Gda.SqlBuilderId op3);
		public Gda.SqlBuilderId add_cond_v (Gda.SqlOperatorType op, Gda.SqlBuilderId op_ids, int op_ids_size);
		[CCode (sentinel = "")]
		public Gda.SqlBuilderId add_expr (Gda.DataHandler dh, GLib.Type type, ...);
		public Gda.SqlBuilderId add_expr_value (Gda.DataHandler dh, GLib.Value value);
		public Gda.SqlBuilderId add_field_id (string field_name, string table_name);
		[CCode (sentinel = "")]
		public void add_field_value (string field_name, GLib.Type type, ...);
		public void add_field_value_as_gvalue (string field_name, GLib.Value value);
		public void add_field_value_id (Gda.SqlBuilderId field_id, Gda.SqlBuilderId value_id);
		[CCode (sentinel = "")]
		public Gda.SqlBuilderId add_function (string func_name, ...);
		public Gda.SqlBuilderId add_function_v (string func_name, Gda.SqlBuilderId args, int args_size);
		public Gda.SqlBuilderId add_id (string str);
		public Gda.SqlBuilderId add_param (string param_name, GLib.Type type, bool nullok);
		public Gda.SqlBuilderId add_sub_select (Gda.SqlStatement sqlst);
		public void compound_add_sub_select (Gda.SqlStatement sqlst);
		public void compound_set_type (Gda.SqlStatementCompoundType compound_type);
		public static GLib.Quark error_quark ();
		public unowned Gda.SqlExpr export_expression (Gda.SqlBuilderId id);
		public unowned Gda.SqlStatement get_sql_statement ();
		public unowned Gda.Statement get_statement () throws GLib.Error;
		public Gda.SqlBuilderId import_expression (Gda.SqlExpr expr);
		public void join_add_field (Gda.SqlBuilderId join_id, string field_name);
		public Gda.SqlBuilderId select_add_field (string field_name, string table_name, string alias);
		public Gda.SqlBuilderId select_add_target (string table_name, string alias);
		public Gda.SqlBuilderId select_add_target_id (Gda.SqlBuilderId table_id, string alias);
		public void select_group_by (Gda.SqlBuilderId expr_id);
		public Gda.SqlBuilderId select_join_targets (Gda.SqlBuilderId left_target_id, Gda.SqlBuilderId right_target_id, Gda.SqlSelectJoinType join_type, Gda.SqlBuilderId join_expr);
		public void select_order_by (Gda.SqlBuilderId expr_id, bool asc, string collation_name);
		public void select_set_distinct (bool distinct, Gda.SqlBuilderId expr_id);
		public void select_set_having (Gda.SqlBuilderId cond_id);
		public void select_set_limit (Gda.SqlBuilderId limit_count_expr_id, Gda.SqlBuilderId limit_offset_expr_id);
		public void set_table (string table_name);
		public void set_where (Gda.SqlBuilderId cond_id);
		public Gda.SqlStatementType stmt_type { construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_case_copy")]
	[Compact]
	public class SqlCase {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlExpr base_expr;
		public weak Gda.SqlExpr else_expr;
		public weak GLib.SList then_expr_list;
		public weak GLib.SList when_expr_list;
		[CCode (has_construct_function = false)]
		public SqlCase (Gda.SqlAnyPart parent);
		public unowned Gda.SqlCase copy ();
		public unowned string serialize ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlErrorType {
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_expr_copy", type_id = "gda_sql_expr_get_type ()")]
	[Compact]
	public class SqlExpr {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlCase case_s;
		public weak string cast_as;
		public weak Gda.SqlOperation cond;
		public weak Gda.SqlFunction func;
		public weak Gda.SqlParamSpec param_spec;
		public weak Gda.SqlAnyPart select;
		public GLib.Value value;
		public void* value_is_ident;
		[CCode (has_construct_function = false)]
		public SqlExpr (Gda.SqlAnyPart parent);
		public unowned Gda.SqlExpr copy ();
		public unowned string serialize ();
		public void take_select (Gda.SqlStatement stmt);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_field_copy")]
	[Compact]
	public class SqlField {
		public weak Gda.SqlAnyPart any;
		public weak string field_name;
		public weak Gda.MetaTableColumn validity_meta_table_column;
		[CCode (has_construct_function = false)]
		public SqlField (Gda.SqlAnyPart parent);
		public unowned Gda.SqlField copy ();
		public unowned string serialize ();
		public void take_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_function_copy")]
	[Compact]
	public class SqlFunction {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList args_list;
		public weak string function_name;
		[CCode (has_construct_function = false)]
		public SqlFunction (Gda.SqlAnyPart parent);
		public void check_clean ();
		public unowned Gda.SqlFunction copy ();
		public unowned string serialize ();
		public void take_args_list (owned GLib.SList args);
		public void take_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_operation_copy")]
	[Compact]
	public class SqlOperation {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList operands;
		public Gda.SqlOperatorType operator_type;
		[CCode (has_construct_function = false)]
		public SqlOperation (Gda.SqlAnyPart parent);
		public unowned Gda.SqlOperation copy ();
		public static Gda.SqlOperatorType operator_from_string (string op);
		public static unowned string operator_to_string (Gda.SqlOperatorType op);
		public unowned string serialize ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_param_spec_copy")]
	[Compact]
	public class SqlParamSpec {
		public weak string descr;
		public GLib.Type g_type;
		public bool is_param;
		public weak string name;
		public bool nullok;
		public void* validity_meta_dict;
		[CCode (has_construct_function = false)]
		public SqlParamSpec (GLib.Value simple_spec);
		public unowned Gda.SqlParamSpec copy ();
		public unowned string serialize ();
		public void take_descr (GLib.Value value);
		public void take_name (GLib.Value value);
		public void take_nullok (GLib.Value value);
		public void take_type (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class SqlParser : GLib.Object, Gda.Lockable {
		[CCode (has_construct_function = false)]
		public SqlParser ();
		[NoWrapper]
		public virtual void* delim_alloc (GLib.Callback p1);
		[NoWrapper]
		public virtual void delim_free (void* p1, GLib.Callback p2);
		[NoWrapper]
		public virtual void delim_parse (void* p1, int p2, GLib.Value p3, Gda.SqlParserIface p4);
		[NoWrapper]
		public virtual void delim_trace (void* p1, string p2);
		public static GLib.Quark error_quark ();
		public unowned Gda.Batch parse_file_as_batch (string filename) throws GLib.Error;
		public unowned Gda.Statement parse_string (string sql, out unowned string remain) throws GLib.Error;
		public unowned Gda.Batch parse_string_as_batch (string sql, string remain) throws GLib.Error;
		[NoWrapper]
		public virtual void* parser_alloc (GLib.Callback p1);
		[NoWrapper]
		public virtual void parser_free (void* p1, GLib.Callback p2);
		[NoWrapper]
		public virtual void parser_parse (void* p1, int p2, GLib.Value p3, Gda.SqlParserIface p4);
		[NoWrapper]
		public virtual void parser_trace (void* p1, string p2);
		public void set_overflow_error ();
		public void set_syntax_error ();
		[NoAccessorMethod]
		public int column_error { get; }
		[NoAccessorMethod]
		public int line_error { get; }
		[NoAccessorMethod]
		public int mode { get; set; }
		[NoAccessorMethod]
		public int tokenizer_flavour { get; set; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlRenderingContext {
		public weak Gda.Connection cnc;
		public Gda.StatementSqlFlag flags;
		public weak Gda.Set @params;
		public weak GLib.SList params_used;
		public weak Gda.ServerProvider provider;
		public weak Gda.SqlRenderingFunc render_begin;
		public weak Gda.SqlRenderingFunc render_case;
		public weak Gda.SqlRenderingFunc render_commit;
		public weak Gda.SqlRenderingFunc render_compound;
		public weak Gda.SqlRenderingFunc render_delete;
		public weak Gda.SqlRenderingFunc render_delete_savepoint;
		public weak Gda.SqlRenderingExpr render_expr;
		public weak Gda.SqlRenderingFunc render_field;
		public weak Gda.SqlRenderingFunc render_function;
		public weak Gda.SqlRenderingFunc render_insert;
		public weak Gda.SqlRenderingFunc render_operation;
		public weak Gda.SqlRenderingPSpecFunc render_param_spec;
		public weak Gda.SqlRenderingFunc render_rollback;
		public weak Gda.SqlRenderingFunc render_rollback_savepoint;
		public weak Gda.SqlRenderingFunc render_savepoint;
		public weak Gda.SqlRenderingFunc render_select;
		public weak Gda.SqlRenderingFunc render_select_field;
		public weak Gda.SqlRenderingFunc render_select_from;
		public weak Gda.SqlRenderingFunc render_select_join;
		public weak Gda.SqlRenderingFunc render_select_order;
		public weak Gda.SqlRenderingFunc render_select_target;
		public weak Gda.SqlRenderingFunc render_table;
		public weak Gda.SqlRenderingFunc render_unknown;
		public weak Gda.SqlRenderingFunc render_update;
		public weak Gda.SqlRenderingValue render_value;
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_select_field_copy")]
	[Compact]
	public class SqlSelectField {
		public weak Gda.SqlAnyPart any;
		public weak string @as;
		public weak Gda.SqlExpr expr;
		public weak string field_name;
		public weak string table_name;
		public weak Gda.MetaDbObject validity_meta_object;
		public weak Gda.MetaTableColumn validity_meta_table_column;
		[CCode (has_construct_function = false)]
		public SqlSelectField (Gda.SqlAnyPart parent);
		public unowned Gda.SqlSelectField copy ();
		public unowned string serialize ();
		public void take_alias (GLib.Value alias);
		public void take_expr (Gda.SqlExpr expr);
		public void take_star_value (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_select_from_copy")]
	[Compact]
	public class SqlSelectFrom {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList joins;
		public weak GLib.SList targets;
		[CCode (has_construct_function = false)]
		public SqlSelectFrom (Gda.SqlAnyPart parent);
		public unowned Gda.SqlSelectFrom copy ();
		public unowned string serialize ();
		public void take_new_join (Gda.SqlSelectJoin join);
		public void take_new_target (Gda.SqlSelectTarget target);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_select_join_copy")]
	[Compact]
	public class SqlSelectJoin {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlExpr expr;
		public int position;
		public Gda.SqlSelectJoinType type;
		public weak GLib.SList use;
		[CCode (has_construct_function = false)]
		public SqlSelectJoin (Gda.SqlAnyPart parent);
		public unowned Gda.SqlSelectJoin copy ();
		public unowned string serialize ();
		public static unowned string type_to_string (Gda.SqlSelectJoinType type);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_select_order_copy")]
	[Compact]
	public class SqlSelectOrder {
		public weak Gda.SqlAnyPart any;
		public bool asc;
		public weak string collation_name;
		public weak Gda.SqlExpr expr;
		[CCode (has_construct_function = false)]
		public SqlSelectOrder (Gda.SqlAnyPart parent);
		public unowned Gda.SqlSelectOrder copy ();
		public unowned string serialize ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_select_target_copy")]
	[Compact]
	public class SqlSelectTarget {
		public weak Gda.SqlAnyPart any;
		public weak string @as;
		public weak Gda.SqlExpr expr;
		public weak string table_name;
		public weak Gda.MetaDbObject validity_meta_object;
		[CCode (has_construct_function = false)]
		public SqlSelectTarget (Gda.SqlAnyPart parent);
		public unowned Gda.SqlSelectTarget copy ();
		public unowned string serialize ();
		public void take_alias (GLib.Value alias);
		public void take_select (Gda.SqlStatement stmt);
		public void take_table_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_statement_copy", type_id = "gda_sql_statement_get_type ()")]
	[Compact]
	public class SqlStatement {
		public void* contents;
		public weak string sql;
		public Gda.SqlStatementType stmt_type;
		public weak Gda.MetaStruct validity_meta_struct;
		[CCode (has_construct_function = false)]
		public SqlStatement (Gda.SqlStatementType type);
		public void check_clean ();
		public bool check_structure () throws GLib.Error;
		public bool check_validity (Gda.Connection cnc) throws GLib.Error;
		public bool check_validity_m (Gda.MetaStruct mstruct) throws GLib.Error;
		public unowned Gda.SqlStatement copy ();
		public static unowned Gda.SqlStatementContentsInfo get_contents_infos (Gda.SqlStatementType type);
		public bool normalize (Gda.Connection cnc) throws GLib.Error;
		public unowned string serialize ();
		public static Gda.SqlStatementType string_to_type (string type);
		public void trans_set_isol_level (Gda.TransactionIsolation level);
		public void trans_take_mode (GLib.Value value);
		public void trans_take_name (GLib.Value value);
		public static unowned string type_to_string (Gda.SqlStatementType type);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementCheckValidityData {
		public weak Gda.Connection cnc;
		public weak Gda.MetaStruct mstruct;
		public weak Gda.MetaStore store;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementCompound {
		public weak Gda.SqlAnyPart any;
		public Gda.SqlStatementCompoundType compound_type;
		public weak GLib.SList stmt_list;
		public static void set_type (Gda.SqlStatement stmt, Gda.SqlStatementCompoundType type);
		public static void take_stmt (Gda.SqlStatement stmt, Gda.SqlStatement s);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementContentsInfo {
		public weak Gda.SqlForeachFunc check_structure_func;
		public weak Gda.SqlForeachFunc check_validity_func;
		public weak GLib.Callback @construct;
		public weak GLib.Callback copy;
		public weak GLib.Callback free;
		public weak string name;
		public weak GLib.Callback serialize;
		public Gda.SqlStatementType type;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementDelete {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlExpr cond;
		public weak Gda.SqlTable table;
		public static void take_condition (Gda.SqlStatement stmt, Gda.SqlExpr cond);
		public static void take_table_name (Gda.SqlStatement stmt, GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementInsert {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList fields_list;
		public weak string on_conflict;
		public weak Gda.SqlAnyPart select;
		public weak Gda.SqlTable table;
		public weak GLib.SList values_list;
		public static void take_1_values_list (Gda.SqlStatement stmt, owned GLib.SList<Gda.SqlExpr> list);
		public static void take_extra_values_list (Gda.SqlStatement stmt, GLib.SList list);
		public static void take_fields_list (Gda.SqlStatement stmt, owned GLib.SList<Gda.SqlField> list);
		public static void take_on_conflict (Gda.SqlStatement stmt, GLib.Value value);
		public static void take_select (Gda.SqlStatement stmt, Gda.SqlStatement select);
		public static void take_table_name (Gda.SqlStatement stmt, GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementSelect {
		public weak Gda.SqlAnyPart any;
		public bool distinct;
		public weak Gda.SqlExpr distinct_expr;
		public weak GLib.SList expr_list;
		public weak Gda.SqlSelectFrom from;
		public weak GLib.SList group_by;
		public weak Gda.SqlExpr having_cond;
		public weak Gda.SqlExpr limit_count;
		public weak Gda.SqlExpr limit_offset;
		public weak GLib.SList order_by;
		public weak Gda.SqlExpr where_cond;
		public static void take_distinct (Gda.SqlStatement stmt, bool distinct, Gda.SqlExpr distinct_expr);
		public static void take_expr_list (Gda.SqlStatement stmt, owned GLib.SList<Gda.SqlSelectField> expr_list);
		public static void take_from (Gda.SqlStatement stmt, Gda.SqlSelectFrom from);
		public static void take_group_by (Gda.SqlStatement stmt, owned GLib.SList<Gda.SqlExpr> group_by);
		public static void take_having_cond (Gda.SqlStatement stmt, Gda.SqlExpr expr);
		public static void take_limits (Gda.SqlStatement stmt, Gda.SqlExpr count, Gda.SqlExpr offset);
		public static void take_order_by (Gda.SqlStatement stmt, owned GLib.SList<Gda.SqlSelectOrder> order_by);
		public static void take_where_cond (Gda.SqlStatement stmt, owned Gda.SqlExpr expr);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementTransaction {
		public weak Gda.SqlAnyPart any;
		public Gda.TransactionIsolation isolation_level;
		public weak string trans_mode;
		public weak string trans_name;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementUnknown {
		public weak Gda.SqlAnyPart any;
		public weak GLib.SList expressions;
		public static void take_expressions (Gda.SqlStatement stmt, owned GLib.SList<Gda.SqlExpr> expressions);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class SqlStatementUpdate {
		public weak Gda.SqlAnyPart any;
		public weak Gda.SqlExpr cond;
		public weak GLib.SList expr_list;
		public weak GLib.SList fields_list;
		public weak string on_conflict;
		public weak Gda.SqlTable table;
		public static void take_condition (Gda.SqlStatement stmt, Gda.SqlExpr cond);
		public static void take_on_conflict (Gda.SqlStatement stmt, GLib.Value value);
		public static void take_set_value (Gda.SqlStatement stmt, GLib.Value fname, Gda.SqlExpr expr);
		public static void take_table_name (Gda.SqlStatement stmt, GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_sql_table_copy")]
	[Compact]
	public class SqlTable {
		public weak Gda.SqlAnyPart any;
		public weak string table_name;
		public weak Gda.MetaDbObject validity_meta_object;
		[CCode (has_construct_function = false)]
		public SqlTable (Gda.SqlAnyPart parent);
		public unowned Gda.SqlTable copy ();
		public unowned string serialize ();
		public void take_name (GLib.Value value);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class SqliteProvider : Gda.ServerProvider {
		[CCode (has_construct_function = false)]
		protected SqliteProvider ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Statement : GLib.Object {
		[CCode (has_construct_function = false)]
		public Statement ();
		public bool check_structure () throws GLib.Error;
		public bool check_validity (Gda.Connection cnc) throws GLib.Error;
		public unowned Gda.Statement copy ();
		public static GLib.Quark error_quark ();
		public bool get_parameters (out unowned Gda.Set out_params) throws GLib.Error;
		public Gda.SqlStatementType get_statement_type ();
		public bool is_useless ();
		public bool normalize (Gda.Connection cnc) throws GLib.Error;
		public unowned Gda.SqlStatement rewrite_for_default_values (Gda.Set @params, bool remove) throws GLib.Error;
		public unowned string serialize ();
		public string to_sql_extended (Gda.Connection? cnc, Gda.Set? @params, Gda.StatementSqlFlag flags, GLib.SList<Gda.Holder>? params_used) throws GLib.Error;
		public unowned string to_sql_real (Gda.SqlRenderingContext context) throws GLib.Error;
		[NoAccessorMethod]
		public void* structure { get; set; }
		public virtual signal void checked (Gda.Connection cnc, bool checked);
		public virtual signal void reset ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class ThreadWrapper : GLib.Object {
		[CCode (has_construct_function = false)]
		public ThreadWrapper ();
		public bool cancel (uint id);
		public ulong connect_raw (void* instance, string sig_name, bool private_thread, bool private_job, Gda.ThreadWrapperCallback callback, void* data);
		public void disconnect (ulong id);
		public static GLib.Quark error_quark ();
		public uint execute (Gda.ThreadWrapperFunc func, void* arg, GLib.DestroyNotify arg_destroy_func) throws GLib.Error;
		public uint execute_void (Gda.ThreadWrapperVoidFunc func, void* arg, GLib.DestroyNotify arg_destroy_func) throws GLib.Error;
		public void* fetch_result (bool may_lock, uint exp_id) throws GLib.Error;
		public int get_waiting_size ();
		public void iterate (bool may_block);
		public void steal_signal (ulong id);
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_time_copy", type_id = "gda_time_get_type ()")]
	[Compact]
	public class Time {
		public ulong fraction;
		public ushort hour;
		public ushort minute;
		public ushort second;
		public long timezone;
		public static void* copy (void* boxed);
		public bool valid ();
	}
	[CCode (cheader_filename = "libgda/libgda.h", copy_function = "gda_timestamp_copy", type_id = "gda_timestamp_get_type ()")]
	[Compact]
	public class Timestamp {
		public ushort day;
		public ulong fraction;
		public ushort hour;
		public ushort minute;
		public ushort month;
		public ushort second;
		public long timezone;
		public short year;
		public static void* copy (void* boxed);
		public bool valid ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class TransactionStatus : GLib.Object {
		public weak GLib.List events;
		public Gda.TransactionIsolation isolation_level;
		public weak string name;
		public Gda.TransactionStatusState state;
		[CCode (has_construct_function = false)]
		public TransactionStatus (string name);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class TransactionStatusEvent {
		public weak Gda.ConnectionEvent conn_event;
		public void* pl;
		public weak Gda.TransactionStatus trans;
		public Gda.TransactionStatusEventType type;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class Tree : GLib.Object {
		[CCode (has_construct_function = false)]
		public Tree ();
		public void add_manager (Gda.TreeManager manager);
		public void clean ();
		public void dump (Gda.TreeNode node, GLib.FileStream stream);
		public static GLib.Quark error_quark ();
		public unowned Gda.TreeNode get_node (string tree_path, bool use_names);
		public unowned Gda.TreeManager get_node_manager (Gda.TreeNode node);
		public unowned string get_node_path (Gda.TreeNode node);
		public unowned GLib.SList get_nodes_in_path (string tree_path, bool use_names);
		public void set_attribute (string attribute, GLib.Value value, GLib.DestroyNotify destroy);
		public bool update_all () throws GLib.Error;
		public bool update_part (Gda.TreeNode node) throws GLib.Error;
		[NoAccessorMethod]
		public bool is_list { get; }
		public virtual signal void node_changed (Gda.TreeNode node);
		public virtual signal void node_deleted (string node_path);
		public virtual signal void node_has_child_toggled (Gda.TreeNode node);
		public virtual signal void node_inserted (Gda.TreeNode node);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class TreeManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TreeManager ();
		public void add_manager (Gda.TreeManager sub);
		public void add_new_node_attribute (string attribute, GLib.Value value);
		public unowned Gda.TreeNode create_node (Gda.TreeNode parent, string name);
		public static GLib.Quark error_quark ();
		public unowned GLib.SList get_managers ();
		public unowned Gda.TreeManagerNodeFunc get_node_create_func ();
		public void set_node_create_func (Gda.TreeManagerNodeFunc func);
		[NoWrapper]
		public virtual unowned GLib.SList update_children (Gda.TreeNode node, GLib.SList children_nodes, bool out_error) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public TreeManager.with_func (Gda.TreeManagerNodesFunc update_func);
		[NoAccessorMethod]
		public void* func { get; set construct; }
		[NoAccessorMethod]
		public bool recursive { get; set construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class TreeMgrColumns : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		public TreeMgrColumns (Gda.Connection cnc, string schema, string table_name);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		[NoAccessorMethod]
		public Gda.MetaStore meta_store { owned get; construct; }
		public string schema { construct; }
		public string table_name { construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class TreeMgrColumnsPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class TreeMgrLabel : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		public TreeMgrLabel (string label);
		public string label { construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class TreeMgrLabelPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class TreeMgrSchemas : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		public TreeMgrSchemas (Gda.Connection cnc);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		[NoAccessorMethod]
		public Gda.MetaStore meta_store { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class TreeMgrSchemasPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class TreeMgrSelect : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		public TreeMgrSelect (Gda.Connection cnc, Gda.Statement stmt, Gda.Set @params);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		[NoAccessorMethod]
		public Gda.Set @params { owned get; construct; }
		[NoAccessorMethod]
		public Gda.Statement statement { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class TreeMgrSelectPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class TreeMgrTables : Gda.TreeManager {
		[CCode (has_construct_function = false, type = "GdaTreeManager*")]
		public TreeMgrTables (Gda.Connection cnc, string schema);
		[NoAccessorMethod]
		public Gda.Connection connection { owned get; construct; }
		[NoAccessorMethod]
		public Gda.MetaStore meta_store { owned get; construct; }
		public string schema { construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class TreeMgrTablesPriv {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class TreeNode : GLib.Object {
		[CCode (has_construct_function = false)]
		public TreeNode (string name);
		[NoWrapper]
		public virtual void dump_children (string prefix, GLib.StringBuilder in_string);
		[NoWrapper]
		public virtual unowned string dump_header ();
		public static GLib.Quark error_quark ();
		public GLib.Value fetch_attribute (string attribute);
		public unowned Gda.TreeNode get_child_index (int index);
		public unowned Gda.TreeNode get_child_name (string name);
		public unowned GLib.SList get_children ();
		public GLib.Value get_node_attribute (string attribute);
		public unowned Gda.TreeNode get_parent ();
		public void set_node_attribute (string attribute, GLib.Value value, GLib.DestroyNotify destroy);
		[NoAccessorMethod]
		public string name { owned get; set; }
		public virtual signal void node_changed (Gda.TreeNode node);
		public virtual signal void node_deleted (string relative_path);
		public virtual signal void node_has_child_toggled (Gda.TreeNode node);
		public virtual signal void node_inserted (Gda.TreeNode node);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class ValueList {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class VconnectionDataModel : Gda.VirtualConnection, Gda.Lockable {
		[CCode (has_construct_function = false)]
		protected VconnectionDataModel ();
		public bool add (Gda.VconnectionDataModelSpec spec, GLib.DestroyNotify spec_free_func, string table_name) throws GLib.Error;
		public bool add_model (Gda.DataModel model, string table_name) throws GLib.Error;
		public void @foreach (Gda.VconnectionDataModelFunc func, void* data);
		public unowned Gda.DataModel get_model (string table_name);
		public unowned string get_table_name (Gda.DataModel model);
		public bool remove (string table_name) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class VconnectionDataModelFilter {
		public void* aConstraint;
		public void* aConstraintUsage;
		public void* aOrderBy;
		public double estimatedCost;
		public int idxNum;
		public void* idxPointer;
		public int nConstraint;
		public int nOrderBy;
		public bool orderByConsumed;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class VconnectionDataModelSpec {
		public weak Gda.VconnectionDataModelCreateColumnsFunc create_columns_func;
		public weak Gda.VconnectionDataModelParseFilterFunc create_filter_func;
		public weak Gda.VconnectionDataModelCreateFModelFunc create_filtered_model_func;
		public weak Gda.VconnectionDataModelCreateModelFunc create_model_func;
		public weak Gda.DataModel data_model;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class VconnectionHub : Gda.VconnectionDataModel, Gda.Lockable {
		[CCode (has_construct_function = false)]
		protected VconnectionHub ();
		public bool add (Gda.Connection cnc, string ns) throws GLib.Error;
		public void @foreach (Gda.VConnectionHubFunc func, void* data);
		public unowned Gda.Connection get_connection (string ns);
		public bool remove (Gda.Connection cnc) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class VirtualConnection : Gda.Connection, Gda.Lockable {
		[CCode (has_construct_function = false)]
		protected VirtualConnection ();
		public void* internal_get_provider_data ();
		public void internal_set_provider_data (void* data, GLib.DestroyNotify destroy_func);
		public static unowned Gda.Connection open (Gda.VirtualProvider virtual_provider) throws GLib.Error;
		public static unowned Gda.Connection open_extended (Gda.VirtualProvider virtual_provider, Gda.ConnectionOptions options) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class VirtualProvider : Gda.SqliteProvider {
		[CCode (has_construct_function = false)]
		protected VirtualProvider ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class VproviderDataModel : Gda.VirtualProvider {
		[CCode (has_construct_function = false, type = "GdaVirtualProvider*")]
		public VproviderDataModel ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class VproviderHub : Gda.VproviderDataModel {
		[CCode (has_construct_function = false, type = "GdaVirtualProvider*")]
		public VproviderHub ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public class XaTransaction : GLib.Object {
		[CCode (has_construct_function = false)]
		public XaTransaction (uint32 format, string global_transaction_id);
		public bool begin () throws GLib.Error;
		public bool commit (out GLib.SList<Gda.Connection> cnc_to_recover) throws GLib.Error;
		public bool commit_recovered (out GLib.SList<Gda.Connection> cnc_to_recover) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public bool register_connection (Gda.Connection cnc, string branch) throws GLib.Error;
		public bool rollback () throws GLib.Error;
		public static unowned Gda.XaTransactionId string_to_id (string str);
		public void unregister_connection (Gda.Connection cnc);
		[NoAccessorMethod]
		public uint format_id { get; construct; }
		[NoAccessorMethod]
		public string transaction_id { owned get; construct; }
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[Compact]
	public class XaTransactionId {
		public ushort bqual_length;
		[CCode (array_length = false)]
		public uint8[] data;
		public uint32 format;
		public ushort gtrid_length;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public interface DataHandler : GLib.Object {
		public abstract bool accepts_g_type (GLib.Type type);
		public static unowned Gda.DataHandler get_default (GLib.Type for_type);
		public abstract unowned string get_descr ();
		public abstract GLib.Value get_sane_init_value (GLib.Type type);
		public abstract unowned string get_sql_from_value (GLib.Value value);
		public abstract unowned string get_str_from_value (GLib.Value value);
		public abstract GLib.Value get_value_from_sql (string sql, GLib.Type type);
		public abstract GLib.Value get_value_from_str (string str, GLib.Type type);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public interface DataModel : GLib.Object {
		[CCode (vfunc_name = "i_append_row")]
		public virtual int append_row () throws GLib.Error;
		[CCode (vfunc_name = "i_append_values")]
		public virtual int append_values (GLib.List<GLib.Value> values) throws GLib.Error;
		[CCode (vfunc_name = "i_create_iter")]
		public virtual unowned Gda.DataModelIter create_iter ();
		[CCode (vfunc_name = "i_describe_column")]
		public virtual unowned Gda.Column describe_column (int col);
		public void dump (GLib.FileStream to_stream);
		public unowned string dump_as_string ();
		public static GLib.Quark error_quark ();
		public bool export_to_file (Gda.DataModelIOFormat format, string file, int cols, int nb_cols, int rows, int nb_rows, Gda.Set options) throws GLib.Error;
		public unowned string export_to_string (Gda.DataModelIOFormat format, int cols, int nb_cols, int rows, int nb_rows, Gda.Set options);
		public void freeze ();
		[CCode (vfunc_name = "i_get_access_flags")]
		public virtual Gda.DataModelAccessFlags get_access_flags ();
		[CCode (vfunc_name = "i_get_attributes_at")]
		public virtual Gda.ValueAttribute get_attributes_at (int col, int row);
		public int get_column_index (string name);
		public unowned string get_column_name (int col);
		public unowned string get_column_title (int col);
		[CCode (vfunc_name = "i_get_n_columns")]
		public virtual int get_n_columns ();
		[CCode (vfunc_name = "i_get_n_rows")]
		public virtual int get_n_rows ();
		public int get_row_from_values (GLib.SList<GLib.Value> values, int[] cols_index);
		public unowned GLib.Value? get_typed_value_at (int col, int row, GLib.Type expected_type, bool nullok) throws GLib.Error;
		public unowned GLib.Value? get_value_at (int col, int row) throws GLib.Error;
		[CCode (vfunc_name = "i_remove_row")]
		public virtual bool remove_row (int row) throws GLib.Error;
		[CCode (vfunc_name = "i_send_hint")]
		public virtual void send_hint (Gda.DataModelHint hint, GLib.Value hint_value);
		public void set_column_name (int col, string name);
		public void set_column_title (int col, string title);
		[CCode (vfunc_name = "i_set_value_at")]
		public virtual bool set_value_at (int col, int row, GLib.Value value) throws GLib.Error;
		[CCode (vfunc_name = "i_set_values")]
		public virtual bool set_values (int row, GLib.List<GLib.Value> values) throws GLib.Error;
		public void thaw ();
		public signal void changed ();
		public signal void reset ();
		public signal void row_inserted (int row);
		public signal void row_removed (int row);
		public signal void row_updated (int row);
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public interface Lockable : GLib.Object {
		[CCode (vfunc_name = "i_lock")]
		public virtual void @lock ();
		[CCode (vfunc_name = "i_trylock")]
		public virtual bool trylock ();
		[CCode (vfunc_name = "i_unlock")]
		public virtual void unlock ();
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public struct DsnInfo {
		public weak string name;
		public weak string provider;
		public weak string description;
		public weak string cnc_string;
		public weak string auth_string;
		public bool is_system;
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	[SimpleType]
	public struct SqlBuilderId : uint {
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	protected struct SqlParserIface {
		public Gda.SqlParser parser;
		public Gda.SqlStatement parsed_statement;
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_BATCH_CONFLICTING_PARAMETER_")]
	public enum BatchError {
		ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONFIG_")]
	public enum ConfigError {
		DSN_NOT_FOUND_ERROR,
		PERMISSION_ERROR,
		PROVIDER_NOT_FOUND_ERROR,
		PROVIDER_CREATION_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_")]
	public enum ConnectionError {
		DSN_NOT_FOUND_ERROR,
		PROVIDER_NOT_FOUND_ERROR,
		PROVIDER_ERROR,
		NO_CNC_SPEC_ERROR,
		NO_PROVIDER_SPEC_ERROR,
		OPEN_ERROR,
		STATEMENT_TYPE_ERROR,
		CANT_LOCK_ERROR,
		TASK_NOT_FOUND_ERROR,
		UNSUPPORTED_THREADS_ERROR,
		CLOSED_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_EVENT_CODE_")]
	public enum ConnectionEventCode {
		CONSTRAINT_VIOLATION,
		RESTRICT_VIOLATION,
		NOT_NULL_VIOLATION,
		FOREIGN_KEY_VIOLATION,
		UNIQUE_VIOLATION,
		CHECK_VIOLATION,
		INSUFFICIENT_PRIVILEGES,
		UNDEFINED_COLUMN,
		UNDEFINED_FUNCTION,
		UNDEFINED_TABLE,
		DUPLICATE_COLUMN,
		DUPLICATE_DATABASE,
		DUPLICATE_FUNCTION,
		DUPLICATE_SCHEMA,
		DUPLICATE_TABLE,
		DUPLICATE_ALIAS,
		DUPLICATE_OBJECT,
		SYNTAX_ERROR,
		UNKNOWN
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_EVENT_")]
	public enum ConnectionEventType {
		NOTICE,
		WARNING,
		ERROR,
		COMMAND
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_FEATURE_")]
	public enum ConnectionFeature {
		AGGREGATES,
		BLOBS,
		INDEXES,
		INHERITANCE,
		NAMESPACES,
		PROCEDURES,
		SEQUENCES,
		SQL,
		TRANSACTIONS,
		SAVEPOINTS,
		SAVEPOINTS_REMOVE,
		TRIGGERS,
		UPDATABLE_CURSOR,
		USERS,
		VIEWS,
		XA_TRANSACTIONS,
		MULTI_THREADING,
		LAST
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_META_")]
	public enum ConnectionMetaType {
		NAMESPACES,
		TYPES,
		TABLES,
		VIEWS,
		FIELDS,
		INDEXES
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_OPTIONS_")]
	[Flags]
	public enum ConnectionOptions {
		NONE,
		READ_ONLY,
		SQL_IDENTIFIERS_CASE_SENSITIVE,
		THREAD_SAFE,
		THREAD_ISOLATED,
		AUTO_META_DATA
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_CONNECTION_SCHEMA_")]
	public enum ConnectionSchema {
		AGGREGATES,
		DATABASES,
		FIELDS,
		INDEXES,
		LANGUAGES,
		NAMESPACES,
		PARENT_TABLES,
		PROCEDURES,
		SEQUENCES,
		TABLES,
		TRIGGERS,
		TYPES,
		USERS,
		VIEWS,
		CONSTRAINTS,
		TABLE_CONTENTS
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_COMPARATOR_")]
	public enum DataComparatorError {
		MISSING_DATA_MODEL_ERROR,
		COLUMN_TYPES_MISMATCH_ERROR,
		MODEL_ACCESS_ERROR,
		USER_CANCELLED_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_ACCESS_")]
	[Flags]
	public enum DataModelAccessFlags {
		RANDOM,
		CURSOR_FORWARD,
		CURSOR_BACKWARD,
		CURSOR,
		INSERT,
		UPDATE,
		DELETE,
		WRITE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_")]
	public enum DataModelError {
		ROW_OUT_OF_RANGE_ERROR,
		COLUMN_OUT_OF_RANGE_ERROR,
		VALUES_LIST_ERROR,
		VALUE_TYPE_ERROR,
		ROW_NOT_FOUND_ERROR,
		ACCESS_ERROR,
		FEATURE_NON_SUPPORTED_ERROR,
		FILE_EXIST_ERROR,
		XML_FORMAT_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_HINT_")]
	public enum DataModelHint {
		START_BATCH_UPDATE,
		END_BATCH_UPDATE,
		REFRESH
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_IO_")]
	public enum DataModelIOFormat {
		DATA_ARRAY_XML,
		TEXT_SEPARATED
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_MODEL_ITER_COLUMN_OUT_OF_RANGE_")]
	public enum DataModelIterError {
		ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_PROXY_")]
	public enum DataProxyError {
		COMMIT_ERROR,
		COMMIT_CANCELLED,
		READ_ONLY_VALUE,
		READ_ONLY_ROW,
		FILTER_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DATA_SELECT_")]
	public enum DataSelectError {
		MODIFICATION_STATEMENT_ERROR,
		MISSING_MODIFICATION_STATEMENT_ERROR,
		CONNECTION_ERROR,
		ACCESS_ERROR,
		SQL_ERROR,
		SAFETY_LOCKED_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_DIFF_")]
	public enum DiffType {
		ADD_ROW,
		REMOVE_ROW,
		MODIFY_ROW
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_EASY_CREATE_TABLE_")]
	public enum EasyCreateTableFlag {
		NOTHING_FLAG,
		PKEY_FLAG,
		NOT_NULL_FLAG,
		UNIQUE_FLAG,
		AUTOINC_FLAG,
		FKEY_FLAG,
		PKEY_AUTOINC_FLAG
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_EASY_")]
	public enum EasyError {
		OBJECT_NAME_ERROR,
		INCORRECT_VALUE_ERROR,
		OPERATION_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_HOLDER_")]
	public enum HolderError {
		STRING_CONVERSION_ERROR,
		VALUE_TYPE_ERROR,
		VALUE_NULL_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_DB_")]
	public enum MetaDbObjectType {
		UNKNOWN,
		TABLE,
		VIEW
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_FOREIGN_KEY_")]
	public enum MetaForeignKeyPolicy {
		UNKNOWN,
		NONE,
		NO_ACTION,
		RESTRICT,
		CASCADE,
		SET_NULL,
		SET_DEFAULT
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_GRAPH_")]
	[Flags]
	public enum MetaGraphInfo {
		COLUMNS
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_SORT_")]
	public enum MetaSortType {
		ALHAPETICAL,
		DEPENDENCIES
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_STORE_")]
	public enum MetaStoreChangeType {
		ADD,
		REMOVE,
		MODIFY
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_STORE_")]
	public enum MetaStoreError {
		INCORRECT_SCHEMA_ERROR,
		UNSUPPORTED_PROVIDER_ERROR,
		INTERNAL_ERROR,
		META_CONTEXT_ERROR,
		MODIFY_CONTENTS_ERROR,
		EXTRACT_SQL_ERROR,
		ATTRIBUTE_NOT_FOUND_ERROR,
		ATTRIBUTE_ERROR,
		SCHEMA_OBJECT_NOT_FOUND_ERROR,
		SCHEMA_OBJECT_CONFLICT_ERROR,
		SCHEMA_OBJECT_DESCR_ERROR,
		TRANSACTION_ALREADY_STARTED_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_STRUCT_")]
	public enum MetaStructError {
		UNKNOWN_OBJECT_ERROR,
		DUPLICATE_OBJECT_ERROR,
		INCOHERENCE_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_META_STRUCT_FEATURE_")]
	[Flags]
	public enum MetaStructFeature {
		NONE,
		FOREIGN_KEYS,
		VIEW_DEPENDENCIES,
		ALL
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_", has_type_id = false)]
	public enum PrefixDir {
		NO_DIR,
		BIN_DIR,
		SBIN_DIR,
		DATA_DIR,
		LOCALE_DIR,
		LIB_DIR,
		LIBEXEC_DIR,
		ETC_DIR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_CREATE_TABLE_")]
	[Flags]
	public enum ServerOperationCreateTableFlag {
		NOTHING_FLAG,
		PKEY_FLAG,
		NOT_NULL_FLAG,
		UNIQUE_FLAG,
		AUTOINC_FLAG,
		FKEY_FLAG,
		PKEY_AUTOINC_FLAG
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_")]
	public enum ServerOperationError {
		OBJECT_NAME_ERROR,
		INCORRECT_VALUE_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_STATUS_")]
	public enum ServerOperationNodeStatus {
		OPTIONAL,
		REQUIRED,
		UNKNOWN
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_NODE_")]
	public enum ServerOperationNodeType {
		PARAMLIST,
		DATA_MODEL,
		PARAM,
		SEQUENCE,
		SEQUENCE_ITEM,
		DATA_MODEL_COLUMN,
		UNKNOWN
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_OPERATION_")]
	public enum ServerOperationType {
		CREATE_DB,
		DROP_DB,
		CREATE_TABLE,
		DROP_TABLE,
		RENAME_TABLE,
		ADD_COLUMN,
		DROP_COLUMN,
		CREATE_INDEX,
		DROP_INDEX,
		CREATE_VIEW,
		DROP_VIEW,
		COMMENT_TABLE,
		COMMENT_COLUMN,
		CREATE_USER,
		ALTER_USER,
		DROP_USER,
		LAST
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SERVER_PROVIDER_")]
	public enum ServerProviderError {
		METHOD_NON_IMPLEMENTED_ERROR,
		PREPARE_STMT_ERROR,
		EMPTY_STMT_ERROR,
		MISSING_PARAM_ERROR,
		STATEMENT_EXEC_ERROR,
		OPERATION_ERROR,
		INTERNAL_ERROR,
		BUSY_ERROR,
		NON_SUPPORTED_ERROR,
		SERVER_VERSION_ERROR,
		DATA_ERROR,
		DEFAULT_VALUE_HANDLING_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SET_")]
	public enum SetError {
		XML_SPEC_ERROR,
		HOLDER_NOT_FOUND_ERROR,
		INVALID_ERROR,
		READ_ONLY_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_ANY_")]
	public enum SqlAnyPartType {
		STMT_SELECT,
		STMT_INSERT,
		STMT_UPDATE,
		STMT_DELETE,
		STMT_COMPOUND,
		STMT_BEGIN,
		STMT_ROLLBACK,
		STMT_COMMIT,
		STMT_SAVEPOINT,
		STMT_ROLLBACK_SAVEPOINT,
		STMT_DELETE_SAVEPOINT,
		STMT_UNKNOWN,
		EXPR,
		SQL_FIELD,
		SQL_TABLE,
		SQL_FUNCTION,
		SQL_OPERATION,
		SQL_CASE,
		SQL_SELECT_FIELD,
		SQL_SELECT_TARGET,
		SQL_SELECT_JOIN,
		SQL_SELECT_FROM,
		SQL_SELECT_ORDER
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_BUILDER_")]
	public enum SqlBuilderError {
		WRONG_TYPE_ERROR,
		MISUSE_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_IDENTIFIERS_")]
	[Flags]
	public enum SqlIdentifierStyle {
		LOWER_CASE,
		UPPER_CASE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_OPERATOR_TYPE_")]
	public enum SqlOperatorType {
		AND,
		OR,
		EQ,
		IS,
		LIKE,
		BETWEEN,
		GT,
		LT,
		GEQ,
		LEQ,
		DIFF,
		REGEXP,
		REGEXP_CI,
		NOT_REGEXP,
		NOT_REGEXP_CI,
		SIMILAR,
		ISNULL,
		ISNOTNULL,
		NOT,
		IN,
		NOTIN,
		CONCAT,
		PLUS,
		MINUS,
		STAR,
		DIV,
		REM,
		BITAND,
		BITOR,
		BITNOT
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_PARSER_")]
	public enum SqlParserError {
		SYNTAX_ERROR,
		OVERFLOW_ERROR,
		EMPTY_SQL_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_PARSER_FLAVOUR_")]
	public enum SqlParserFlavour {
		STANDARD,
		SQLITE,
		MYSQL,
		ORACLE,
		POSTGRESQL
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_PARSER_MODE_")]
	public enum SqlParserMode {
		PARSE,
		DELIMIT
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_SELECT_JOIN_")]
	public enum SqlSelectJoinType {
		CROSS,
		NATURAL,
		INNER,
		LEFT,
		RIGHT,
		FULL
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_STATEMENT_COMPOUND_")]
	public enum SqlStatementCompoundType {
		UNION,
		UNION_ALL,
		INTERSECT,
		INTERSECT_ALL,
		EXCEPT,
		EXCEPT_ALL
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_SQL_STATEMENT_")]
	public enum SqlStatementType {
		SELECT,
		INSERT,
		UPDATE,
		DELETE,
		COMPOUND,
		BEGIN,
		ROLLBACK,
		COMMIT,
		SAVEPOINT,
		ROLLBACK_SAVEPOINT,
		DELETE_SAVEPOINT,
		UNKNOWN,
		NONE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_STATEMENT_")]
	public enum StatementError {
		PARSE_ERROR,
		SYNTAX_ERROR,
		NO_CNC_ERROR,
		CNC_CLOSED_ERROR,
		EXEC_ERROR,
		PARAM_TYPE_ERROR,
		PARAM_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_STATEMENT_MODEL_")]
	[Flags]
	public enum StatementModelUsage {
		RANDOM_ACCESS,
		CURSOR_FORWARD,
		CURSOR_BACKWARD,
		CURSOR,
		ALLOW_NOPARAM
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_STATEMENT_SQL_")]
	[Flags]
	public enum StatementSqlFlag {
		PARAMS_AS_VALUES,
		PRETTY,
		PARAMS_LONG,
		PARAMS_SHORT,
		PARAMS_AS_COLON,
		PARAMS_AS_DOLLAR,
		PARAMS_AS_QMARK,
		PARAMS_AS_UQMARK
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_THREAD_WRAPPER_UNKNOWN_", has_type_id = false)]
	public enum ThreadWrapperError {
		ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TRANSACTION_ISOLATION_")]
	public enum TransactionIsolation {
		UNKNOWN,
		READ_COMMITTED,
		READ_UNCOMMITTED,
		REPEATABLE_READ,
		SERIALIZABLE
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TRANSACTION_STATUS_EVENT_")]
	public enum TransactionStatusEventType {
		SAVEPOINT,
		SQL,
		SUB_TRANSACTION
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TRANSACTION_STATUS_STATE_")]
	public enum TransactionStatusState {
		OK,
		FAILED
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TREE_UNKNOWN_")]
	public enum TreeError {
		ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TREE_MANAGER_UNKNOWN_")]
	public enum TreeManagerError {
		ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_TREE_NODE_UNKNOWN_")]
	public enum TreeNodeError {
		ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_VALUE_ATTR_")]
	[Flags]
	public enum ValueAttribute {
		NONE,
		IS_NULL,
		CAN_BE_NULL,
		IS_DEFAULT,
		CAN_BE_DEFAULT,
		IS_UNCHANGED,
		ACTIONS_SHOWN,
		DATA_NON_VALID,
		HAS_VALUE_ORIG,
		NO_MODIF,
		UNUSED
	}
	[CCode (cheader_filename = "libgda/libgda.h", cprefix = "GDA_XA_TRANSACTION_")]
	public enum XaTransactionError {
		ALREADY_REGISTERED_ERROR,
		DTP_NOT_SUPPORTED_ERROR,
		CONNECTION_BRANCH_LENGTH_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public errordomain SqlError {
		STRUCTURE_CONTENTS_ERROR,
		MALFORMED_IDENTIFIER_ERROR,
		MISSING_IDENTIFIER_ERROR,
		VALIDATION_ERROR
	}
	[CCode (cheader_filename = "libgda/libgda.h")]
	public delegate void AttributesManagerFunc (string att_name, GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public delegate void AttributesManagerSignal (GLib.Object obj, string att_name, GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public delegate void ServerProviderAsyncCallback (Gda.ServerProvider provider, Gda.Connection cnc, uint task_id, bool result_status, GLib.Error error);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public delegate void ServerProviderExecCallback (Gda.ServerProvider provider, Gda.Connection cnc, uint task_id, GLib.Object result_obj, GLib.Error error);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate bool SqlForeachFunc (Gda.SqlAnyPart p1, void* p2) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned string SqlRenderingExpr (Gda.SqlExpr expr, Gda.SqlRenderingContext context, bool is_default, bool is_null) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned string SqlRenderingFunc (Gda.SqlAnyPart node, Gda.SqlRenderingContext context) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned string SqlRenderingPSpecFunc (Gda.SqlParamSpec pspec, Gda.SqlExpr expr, Gda.SqlRenderingContext context, bool is_default, bool is_null) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned string SqlRenderingValue (GLib.Value value, Gda.SqlRenderingContext context) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate bool SqlReservedKeywordsFunc (string word);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public delegate void ThreadWrapperCallback (Gda.ThreadWrapper wrapper, void* instance, string signame, int n_param_values, GLib.Value param_values, void* gda_reserved);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate void* ThreadWrapperFunc (void* arg) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate void ThreadWrapperVoidFunc (void* arg) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned Gda.TreeNode TreeManagerNodeFunc (Gda.TreeManager manager, Gda.TreeNode parent, string name);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned GLib.SList TreeManagerNodesFunc (Gda.TreeManager manager, Gda.TreeNode node, GLib.SList children_nodes, bool out_error) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public delegate void VConnectionHubFunc (Gda.Connection cnc, string ns);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned GLib.List VconnectionDataModelCreateColumnsFunc (Gda.VconnectionDataModelSpec p1) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned Gda.DataModel VconnectionDataModelCreateFModelFunc (Gda.VconnectionDataModelSpec p1, int p2, string p3, int p4, out GLib.Value p5);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate unowned Gda.DataModel VconnectionDataModelCreateModelFunc (Gda.VconnectionDataModelSpec p1);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate void VconnectionDataModelFunc (Gda.DataModel p1, string p2, void* p3);
	[CCode (cheader_filename = "libgda/libgda.h", has_target = false)]
	public delegate void VconnectionDataModelParseFilterFunc (Gda.VconnectionDataModelSpec p1, Gda.VconnectionDataModelFilter p2);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string ATTRIBUTE_AUTO_INCREMENT;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string ATTRIBUTE_DESCRIPTION;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string ATTRIBUTE_IS_DEFAULT;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string ATTRIBUTE_NAME;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string ATTRIBUTE_NUMERIC_PRECISION;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string ATTRIBUTE_NUMERIC_SCALE;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string EXTRA_AUTO_INCREMENT;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string SQLSTATE_GENERAL_ERROR;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const string SQLSTATE_NO_ERROR;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const int TIMEZONE_INVALID;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public const int TYPE_NULL;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string alphanum_to_text (string text);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string completion_list_get (Gda.Connection cnc, string sql, int start, int end);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool compute_dml_statements (Gda.Connection cnc, Gda.Statement select_stmt, bool require_pk, out unowned Gda.Statement insert_stmt, out unowned Gda.Statement update_stmt, out unowned Gda.Statement delete_stmt) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.SqlStatement compute_select_statement_from_update (Gda.Statement update_stmt) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.SqlExpr compute_unique_table_row_condition (Gda.SqlStatementSelect stsel, Gda.MetaTable mtable, bool require_pk) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.SqlExpr compute_unique_table_row_condition_with_cnc (Gda.Connection cnc, Gda.SqlStatementSelect stsel, Gda.MetaTable mtable, bool require_pk) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string default_escape_string (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string default_unescape_string (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool delete_row_from_table (Gda.Connection cnc, string table, string condition_column_name, GLib.Value condition_value) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void dsn_split (string str, string out_dsn, string out_username, string out_password);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Quark easy_error_quark ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static int execute_non_select_command (Gda.Connection cnc, string sql) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.DataModel execute_select_command (Gda.Connection cnc, string sql) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Type g_type_from_string (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string g_type_to_string (GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string gbr_get_file_path (Gda.PrefixDir where);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void gbr_init ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string get_application_exec_path (string app_name);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.DataHandler get_default_handler (GLib.Type for_type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool identifier_equal (string id1, string id2);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static uint identifier_hash (string id);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void init ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool insert_row_into_table (Gda.Connection cnc, string table) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool insert_row_into_table_v (Gda.Connection cnc, string table, GLib.SList col_names, GLib.SList values) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void locale_changed ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void log_disable ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void log_enable ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void log_error (string format);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool log_is_enabled ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void log_message (string format);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool parse_iso8601_date (GLib.Date gdate, string value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool parse_iso8601_time (Gda.Time timegda, string value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool parse_iso8601_timestamp (Gda.Timestamp timestamp, string value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Statement parse_sql_string (Gda.Connection cnc, string sql, out unowned Gda.Set @params) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool perform_create_database (string provider, Gda.ServerOperation op) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool perform_create_table (Gda.ServerOperation op) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool perform_drop_database (string provider, Gda.ServerOperation op) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool perform_drop_table (Gda.ServerOperation op) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.ServerOperation prepare_create_database (string provider, string db_name) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.ServerOperation prepare_create_table (Gda.Connection cnc, string table_name) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.ServerOperation prepare_drop_database (string provider, string db_name) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.ServerOperation prepare_drop_table (Gda.Connection cnc, string table_name) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool rfc1738_decode (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string rfc1738_encode (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Statement select_alter_select_for_empty (Gda.Statement stmt) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Type short_get_type ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Quark sql_error_quark ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string sql_identifier_add_quotes (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool sql_identifier_needs_quotes (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string sql_identifier_quote (string id, Gda.Connection cnc, Gda.ServerProvider prov, bool meta_store_convention, bool force_quotes);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string sql_identifier_remove_quotes (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string sql_identifier_split (string id);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string sql_value_stringify (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Binary string_to_binary (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Blob string_to_blob (string str);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string text_to_alphanum (string text);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool update_row_in_table (Gda.Connection cnc, string table, string condition_column_name, GLib.Value condition_value) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool update_row_in_table_v (Gda.Connection cnc, string table, string condition_column_name, GLib.Value condition_value, GLib.SList col_names, GLib.SList values) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Type ushort_get_type ();
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool utility_check_data_model (Gda.DataModel model, int nbcols);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool utility_data_model_dump_data_to_xml (Gda.DataModel model, Xml.Node parent, int cols, int nb_cols, int rows, int nb_rows, bool use_col_ids);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string utility_data_model_find_column_description (Gda.DataSelect model, string field_name);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool utility_holder_load_attributes (Gda.Holder holder, Xml.Node node, GLib.SList sources) throws GLib.Error;
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static int value_compare (GLib.Value value1, GLib.Value value2);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value value_copy (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static int value_differ (GLib.Value value1, GLib.Value value2);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_free (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Binary value_get_binary (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Blob value_get_blob (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.GeometricPoint value_get_geometric_point (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.ValueList value_get_list (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Numeric value_get_numeric (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static short value_get_short (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Time value_get_time (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Gda.Timestamp value_get_timestamp (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static ushort value_get_ushort (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool value_is_null (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool value_is_number (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value value_new (GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value value_new_binary (uchar[] val, long size);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value value_new_blob (uchar[] val, long size);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value value_new_blob_from_file (string filename);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value value_new_from_string (string as_string, GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value value_new_from_xml (Xml.Node node);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static GLib.Value value_new_timestamp_from_timet (ulong val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_reset_with_type (GLib.Value value, GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_binary (GLib.Value value, Gda.Binary binary);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_blob (GLib.Value value, Gda.Blob blob);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool value_set_from_string (GLib.Value value, string as_string, GLib.Type type);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static bool value_set_from_value (GLib.Value value, GLib.Value from);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_geometric_point (GLib.Value value, Gda.GeometricPoint val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_list (GLib.Value value, Gda.ValueList val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_null (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_numeric (GLib.Value value, Gda.Numeric val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_short (GLib.Value value, short val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_time (GLib.Value value, Gda.Time val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_timestamp (GLib.Value value, Gda.Timestamp val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_set_ushort (GLib.Value value, ushort val);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned string value_stringify (GLib.Value value);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_take_binary (GLib.Value value, Gda.Binary binary);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static void value_take_blob (GLib.Value value, Gda.Blob blob);
	[CCode (cheader_filename = "libgda/libgda.h")]
	public static unowned Xml.Node value_to_xml (GLib.Value value);
}
