/* gtkdocrenderer.c generated by valac, the Vala compiler
 * generated from gtkdocrenderer.vala, do not modify */

/* gtkdocrenderer.vala
 *
 * Copyright (C) 2011 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <valagee.h>

enum  {
	VALADOC_GTKDOC_RENDERER_0_PROPERTY,
	VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY,
	VALADOC_GTKDOC_RENDERER_NUM_PROPERTIES
};
static GParamSpec* valadoc_gtkdoc_renderer_properties[VALADOC_GTKDOC_RENDERER_NUM_PROPERTIES];
#define _valadoc_markup_writer_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_markup_writer_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValadocGtkdocRendererPrivate {
	ValadocGtkDocMarkupWriter* writer;
	gboolean separated;
};

static gint ValadocGtkdocRenderer_private_offset;
static gpointer valadoc_gtkdoc_renderer_parent_class = NULL;

static gchar* valadoc_gtkdoc_renderer_get_cname (ValadocGtkdocRenderer* self,
                                          ValadocApiItem* item);
static void valadoc_gtkdoc_renderer_real_render (ValadocContentContentRenderer* base,
                                          ValadocContentContentElement* element);
static void valadoc_gtkdoc_renderer_reset (ValadocGtkdocRenderer* self);
static void valadoc_gtkdoc_renderer_real_render_children (ValadocContentContentRenderer* base,
                                                   ValadocContentContentElement* element);
static void valadoc_gtkdoc_renderer_real_visit_comment (ValadocContentContentVisitor* base,
                                                 ValadocContentComment* element);
static void valadoc_gtkdoc_renderer_real_visit_embedded (ValadocContentContentVisitor* base,
                                                  ValadocContentEmbedded* element);
static void valadoc_gtkdoc_renderer_real_visit_headline (ValadocContentContentVisitor* base,
                                                  ValadocContentHeadline* element);
static void valadoc_gtkdoc_renderer_real_visit_wiki_link (ValadocContentContentVisitor* base,
                                                   ValadocContentWikiLink* element);
static void valadoc_gtkdoc_renderer_write_string (ValadocGtkdocRenderer* self,
                                           const gchar* content);
static void valadoc_gtkdoc_renderer_real_visit_link (ValadocContentContentVisitor* base,
                                              ValadocContentLink* element);
static void valadoc_gtkdoc_renderer_real_visit_symbol_link (ValadocContentContentVisitor* base,
                                                     ValadocContentSymbolLink* element);
static void valadoc_gtkdoc_renderer_real_visit_list (ValadocContentContentVisitor* base,
                                              ValadocContentList* element);
static void valadoc_gtkdoc_renderer_real_visit_list_item (ValadocContentContentVisitor* base,
                                                   ValadocContentListItem* element);
static void valadoc_gtkdoc_renderer_real_visit_page (ValadocContentContentVisitor* base,
                                              ValadocContentPage* element);
static void valadoc_gtkdoc_renderer_real_visit_paragraph (ValadocContentContentVisitor* base,
                                                   ValadocContentParagraph* element);
static void valadoc_gtkdoc_renderer_real_visit_warning (ValadocContentContentVisitor* base,
                                                 ValadocContentWarning* element);
static void valadoc_gtkdoc_renderer_real_visit_note (ValadocContentContentVisitor* base,
                                              ValadocContentNote* element);
static void valadoc_gtkdoc_renderer_real_visit_run (ValadocContentContentVisitor* base,
                                             ValadocContentRun* element);
static void valadoc_gtkdoc_renderer_real_visit_source_code (ValadocContentContentVisitor* base,
                                                     ValadocContentSourceCode* element);
static void valadoc_gtkdoc_renderer_real_visit_table (ValadocContentContentVisitor* base,
                                               ValadocContentTable* element);
static void valadoc_gtkdoc_renderer_real_visit_table_cell (ValadocContentContentVisitor* base,
                                                    ValadocContentTableCell* element);
static void valadoc_gtkdoc_renderer_real_visit_table_row (ValadocContentContentVisitor* base,
                                                   ValadocContentTableRow* element);
static void valadoc_gtkdoc_renderer_real_visit_text (ValadocContentContentVisitor* base,
                                              ValadocContentText* element);
static void valadoc_gtkdoc_renderer_finalize (GObject * obj);
static GType valadoc_gtkdoc_renderer_get_type_once (void);
static void _vala_valadoc_gtkdoc_renderer_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
valadoc_gtkdoc_renderer_get_instance_private (ValadocGtkdocRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocGtkdocRenderer_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
valadoc_gtkdoc_renderer_get_cname (ValadocGtkdocRenderer* self,
                                   ValadocApiItem* item)
{
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	if (VALADOC_API_IS_METHOD (item)) {
		gchar* _tmp0_;
		_tmp0_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		result = _tmp0_;
		return result;
	} else {
		if (VALADOC_API_IS_PARAMETER (item)) {
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PARAMETER, ValadocApiParameter));
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		} else {
			if (VALADOC_API_IS_CONSTANT (item)) {
				gchar* _tmp4_;
				_tmp4_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				result = _tmp4_;
				return result;
			} else {
				if (VALADOC_API_IS_PROPERTY (item)) {
					gchar* _tmp5_;
					_tmp5_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
					result = _tmp5_;
					return result;
				} else {
					if (VALADOC_API_IS_SIGNAL (item)) {
						gchar* name = NULL;
						gchar* _tmp6_;
						const gchar* _tmp7_;
						gchar* _tmp8_;
						_tmp6_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
						name = _tmp6_;
						_tmp7_ = name;
						_tmp8_ = string_replace (_tmp7_, "_", "-");
						result = _tmp8_;
						_g_free0 (name);
						return result;
					} else {
						if (VALADOC_API_IS_CLASS (item)) {
							gchar* _tmp9_;
							_tmp9_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CLASS, ValadocApiClass));
							result = _tmp9_;
							return result;
						} else {
							if (VALADOC_API_IS_STRUCT (item)) {
								gchar* _tmp10_;
								_tmp10_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
								result = _tmp10_;
								return result;
							} else {
								if (VALADOC_API_IS_INTERFACE (item)) {
									gchar* _tmp11_;
									_tmp11_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
									result = _tmp11_;
									return result;
								} else {
									if (VALADOC_API_IS_ERROR_DOMAIN (item)) {
										gchar* _tmp12_;
										_tmp12_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
										result = _tmp12_;
										return result;
									} else {
										if (VALADOC_API_IS_ERROR_CODE (item)) {
											gchar* _tmp13_;
											_tmp13_ = valadoc_api_error_code_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ERROR_CODE, ValadocApiErrorCode));
											result = _tmp13_;
											return result;
										} else {
											if (VALADOC_API_IS_DELEGATE (item)) {
												gchar* _tmp14_;
												_tmp14_ = valadoc_api_delegate_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_DELEGATE, ValadocApiDelegate));
												result = _tmp14_;
												return result;
											} else {
												if (VALADOC_API_IS_ENUM (item)) {
													gchar* _tmp15_;
													_tmp15_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
													result = _tmp15_;
													return result;
												} else {
													if (VALADOC_API_IS_ENUM_VALUE (item)) {
														gchar* _tmp16_;
														_tmp16_ = valadoc_api_enum_value_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ENUM_VALUE, ValadocApiEnumValue));
														result = _tmp16_;
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
valadoc_gtkdoc_renderer_write_docbook_link (ValadocGtkdocRenderer* self,
                                            ValadocApiItem* item)
{
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocGtkDocMarkupWriter* _tmp49_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	if (VALADOC_API_IS_METHOD (item)) {
		ValadocGtkDocMarkupWriter* _tmp1_;
		ValadocMarkupWriter* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValadocMarkupWriter* _tmp5_;
		_tmp1_ = self->priv->writer;
		_tmp2_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp1_, "function", NULL, (gint) 0);
		_tmp3_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		_tmp4_ = _tmp3_;
		_tmp5_ = valadoc_markup_writer_text (_tmp2_, _tmp4_);
		valadoc_markup_writer_end_tag (_tmp5_, "function");
		_g_free0 (_tmp4_);
	} else {
		if (VALADOC_API_IS_PARAMETER (item)) {
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			ValadocGtkDocMarkupWriter* _tmp9_;
			ValadocMarkupWriter* _tmp10_;
			ValadocMarkupWriter* _tmp11_;
			_tmp7_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PARAMETER, ValadocApiParameter));
			_tmp8_ = _tmp7_;
			_tmp6_ = _tmp8_;
			if (_tmp6_ == NULL) {
				_tmp6_ = "...";
			}
			_tmp9_ = self->priv->writer;
			_tmp10_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp9_, "parameter", NULL, (gint) 0);
			_tmp11_ = valadoc_markup_writer_text (_tmp10_, _tmp6_);
			valadoc_markup_writer_end_tag (_tmp11_, "parameter");
		} else {
			if (VALADOC_API_IS_CONSTANT (item)) {
				ValadocGtkDocMarkupWriter* _tmp12_;
				ValadocMarkupWriter* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValadocMarkupWriter* _tmp16_;
				_tmp12_ = self->priv->writer;
				_tmp13_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp12_, "constant", NULL, (gint) 0);
				_tmp14_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				_tmp15_ = _tmp14_;
				_tmp16_ = valadoc_markup_writer_text (_tmp13_, _tmp15_);
				valadoc_markup_writer_end_tag (_tmp16_, "constant");
				_g_free0 (_tmp15_);
			} else {
				if (VALADOC_API_IS_PROPERTY (item)) {
					ValadocGtkDocMarkupWriter* _tmp17_;
					ValadocMarkupWriter* _tmp18_;
					ValadocApiItem* _tmp19_;
					ValadocApiItem* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					ValadocMarkupWriter* _tmp23_;
					ValadocMarkupWriter* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp17_ = self->priv->writer;
					_tmp18_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp17_, "#");
					_tmp19_ = valadoc_api_item_get_parent (item);
					_tmp20_ = _tmp19_;
					_tmp21_ = valadoc_gtkdoc_renderer_get_cname (self, _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = valadoc_markup_writer_text (_tmp18_, _tmp22_);
					_tmp24_ = valadoc_markup_writer_text (_tmp23_, ":");
					_tmp25_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
					_tmp26_ = _tmp25_;
					_tmp27_ = string_replace (_tmp26_, "_", "-");
					_tmp28_ = _tmp27_;
					valadoc_markup_writer_text (_tmp24_, _tmp28_);
					_g_free0 (_tmp28_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp22_);
				} else {
					if (VALADOC_API_IS_SIGNAL (item)) {
						ValadocGtkDocMarkupWriter* _tmp29_;
						ValadocMarkupWriter* _tmp30_;
						ValadocApiItem* _tmp31_;
						ValadocApiItem* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						ValadocMarkupWriter* _tmp35_;
						ValadocMarkupWriter* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp29_ = self->priv->writer;
						_tmp30_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp29_, "#");
						_tmp31_ = valadoc_api_item_get_parent (item);
						_tmp32_ = _tmp31_;
						_tmp33_ = valadoc_gtkdoc_renderer_get_cname (self, _tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = valadoc_markup_writer_text (_tmp30_, _tmp34_);
						_tmp36_ = valadoc_markup_writer_text (_tmp35_, "::");
						_tmp37_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
						_tmp38_ = _tmp37_;
						_tmp39_ = string_replace (_tmp38_, "_", "-");
						_tmp40_ = _tmp39_;
						valadoc_markup_writer_text (_tmp36_, _tmp40_);
						_g_free0 (_tmp40_);
						_g_free0 (_tmp38_);
						_g_free0 (_tmp34_);
					} else {
						if (VALADOC_API_IS_NAMESPACE (item)) {
							ValadocGtkDocMarkupWriter* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							_tmp41_ = self->priv->writer;
							_tmp42_ = valadoc_api_node_get_full_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_NAMESPACE, ValadocApiNamespace));
							_tmp43_ = _tmp42_;
							valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp41_, _tmp43_);
							_g_free0 (_tmp43_);
						} else {
							ValadocGtkDocMarkupWriter* _tmp44_;
							ValadocMarkupWriter* _tmp45_;
							gchar* _tmp46_;
							gchar* _tmp47_;
							ValadocMarkupWriter* _tmp48_;
							_tmp44_ = self->priv->writer;
							_tmp45_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp44_, "type", NULL, (gint) 0);
							_tmp46_ = valadoc_gtkdoc_renderer_get_cname (self, item);
							_tmp47_ = _tmp46_;
							_tmp48_ = valadoc_markup_writer_text (_tmp45_, _tmp47_);
							valadoc_markup_writer_end_tag (_tmp48_, "type");
							_g_free0 (_tmp47_);
						}
					}
				}
			}
		}
	}
	_tmp49_ = self->priv->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp49_, TRUE);
}

ValadocGtkdocRenderer*
valadoc_gtkdoc_renderer_construct (GType object_type)
{
	ValadocGtkdocRenderer * self = NULL;
	self = (ValadocGtkdocRenderer*) valadoc_content_content_renderer_construct (object_type);
	return self;
}

ValadocGtkdocRenderer*
valadoc_gtkdoc_renderer_new (void)
{
	return valadoc_gtkdoc_renderer_construct (VALADOC_TYPE_GTKDOC_RENDERER);
}

static void
valadoc_gtkdoc_renderer_real_render (ValadocContentContentRenderer* base,
                                     ValadocContentContentElement* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_gtkdoc_renderer_reset (self);
	valadoc_content_content_element_accept (element, (ValadocContentContentVisitor*) self);
}

void
valadoc_gtkdoc_renderer_render_symbol (ValadocGtkdocRenderer* self,
                                       ValadocContentComment* documentation)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	g_return_if_fail (self != NULL);
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) self, (ValadocContentContentElement*) documentation);
	_tmp0_ = valadoc_content_comment_find_taglets (documentation, NULL, VALADOC_TAGLETS_TYPE_THROWS);
	_tmp1_ = _tmp0_;
	valadoc_gtkdoc_renderer_append_exceptions (self, _tmp1_);
	_vala_iterable_unref0 (_tmp1_);
	_tmp2_ = valadoc_content_comment_find_taglets (documentation, NULL, VALADOC_TAGLETS_TYPE_SEE);
	_tmp3_ = _tmp2_;
	valadoc_gtkdoc_renderer_append_see (self, _tmp3_);
	_vala_iterable_unref0 (_tmp3_);
	_tmp4_ = valadoc_content_comment_find_taglets (documentation, NULL, VALADOC_TAGLETS_TYPE_SINCE);
	_tmp5_ = _tmp4_;
	valadoc_gtkdoc_renderer_append_since (self, _tmp5_);
	_vala_iterable_unref0 (_tmp5_);
}

static void
valadoc_gtkdoc_renderer_real_render_children (ValadocContentContentRenderer* base,
                                              ValadocContentContentElement* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_gtkdoc_renderer_reset (self);
	valadoc_content_content_element_accept_children (element, (ValadocContentContentVisitor*) self);
}

static void
valadoc_gtkdoc_renderer_reset (ValadocGtkdocRenderer* self)
{
	ValadocGtkDocMarkupWriter* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->separated = FALSE;
	_tmp0_ = self->priv->writer;
	valadoc_gtk_doc_markup_writer_reset (_tmp0_);
}

const gchar*
valadoc_gtkdoc_renderer_get_content (ValadocGtkdocRenderer* self)
{
	const gchar* result;
	ValadocGtkDocMarkupWriter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_gtk_doc_markup_writer_get_content (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_str_has_prefix (_tmp2_, "\n")) {
		ValadocGtkDocMarkupWriter* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = self->priv->writer;
		_tmp4_ = valadoc_gtk_doc_markup_writer_get_content (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_utf8_next_char (_tmp5_);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = self->priv->writer;
	_tmp8_ = valadoc_gtk_doc_markup_writer_get_content (_tmp7_);
	_tmp9_ = _tmp8_;
	result = _tmp9_;
	return result;
}

static void
valadoc_gtkdoc_renderer_real_visit_comment (ValadocContentContentVisitor* base,
                                            ValadocContentComment* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
}

static void
valadoc_gtkdoc_renderer_real_visit_embedded (ValadocContentContentVisitor* base,
                                             ValadocContentEmbedded* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp8_;
	ValadocGtkDocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	ValadocMarkupWriter* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	ValadocGtkDocMarkupWriter* _tmp27_;
	ValadocGtkDocMarkupWriter* _tmp28_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "figure", NULL, (gint) 0);
	_tmp1_ = valadoc_content_embedded_get_caption (element);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp3_;
		ValadocMarkupWriter* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValadocMarkupWriter* _tmp7_;
		_tmp3_ = self->priv->writer;
		_tmp4_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "title", NULL, (gint) 0);
		_tmp5_ = valadoc_content_embedded_get_caption (element);
		_tmp6_ = _tmp5_;
		_tmp7_ = valadoc_markup_writer_text (_tmp4_, _tmp6_);
		valadoc_markup_writer_end_tag (_tmp7_, "title");
	}
	_tmp8_ = self->priv->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp8_, "mediaobject", NULL, (gint) 0);
	_tmp9_ = self->priv->writer;
	_tmp10_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp9_, "imageobject", NULL, (gint) 0);
	_tmp11_ = g_strdup ("fileref");
	_tmp12_ = valadoc_content_embedded_get_url (element);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = g_new0 (gchar*, 2 + 1);
	_tmp15_[0] = _tmp11_;
	_tmp15_[1] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 2;
	_tmp17_ = valadoc_markup_writer_simple_tag (_tmp10_, "imagedata", _tmp16_, (gint) 2);
	valadoc_markup_writer_end_tag (_tmp17_, "imageobject");
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = valadoc_content_embedded_get_caption (element);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp20_;
		ValadocMarkupWriter* _tmp21_;
		ValadocMarkupWriter* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		ValadocMarkupWriter* _tmp25_;
		ValadocMarkupWriter* _tmp26_;
		_tmp20_ = self->priv->writer;
		_tmp21_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp20_, "textobject", NULL, (gint) 0);
		_tmp22_ = valadoc_markup_writer_start_tag (_tmp21_, "phrase", NULL, (gint) 0);
		_tmp23_ = valadoc_content_embedded_get_caption (element);
		_tmp24_ = _tmp23_;
		_tmp25_ = valadoc_markup_writer_text (_tmp22_, _tmp24_);
		_tmp26_ = valadoc_markup_writer_end_tag (_tmp25_, "phrase");
		valadoc_markup_writer_end_tag (_tmp26_, "textobject");
	}
	_tmp27_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp27_, "mediaobject");
	_tmp28_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp28_, "figure");
}

static void
valadoc_gtkdoc_renderer_real_visit_headline (ValadocContentContentVisitor* base,
                                             ValadocContentHeadline* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	g_assert_not_reached ();
}

static void
valadoc_gtkdoc_renderer_real_visit_wiki_link (ValadocContentContentVisitor* base,
                                              ValadocContentWikiLink* element)
{
	ValadocGtkdocRenderer * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) element);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = valadoc_content_wiki_link_get_name (element);
		_tmp5_ = _tmp4_;
		valadoc_gtkdoc_renderer_write_string (self, _tmp5_);
	}
}

static void
valadoc_gtkdoc_renderer_real_visit_link (ValadocContentContentVisitor* base,
                                         ValadocContentLink* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValadocGtkDocMarkupWriter* _tmp7_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("url");
	_tmp2_ = valadoc_content_link_get_url (element);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ulink", _tmp6_, (gint) 2);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp7_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp7_, "ulink");
}

static void
valadoc_gtkdoc_renderer_real_visit_symbol_link (ValadocContentContentVisitor* base,
                                                ValadocContentSymbolLink* element)
{
	ValadocGtkdocRenderer * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) element);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		ValadocGtkDocMarkupWriter* _tmp4_;
		ValadocGtkDocMarkupWriter* _tmp5_;
		ValadocGtkDocMarkupWriter* _tmp6_;
		_tmp4_ = self->priv->writer;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp4_, "\"");
		valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
		_tmp5_ = self->priv->writer;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp5_, "\" (");
		valadoc_gtkdoc_renderer_write_symbol_link (self, element);
		_tmp6_ = self->priv->writer;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp6_, ")");
	} else {
		valadoc_gtkdoc_renderer_write_symbol_link (self, element);
	}
}

void
valadoc_gtkdoc_renderer_write_symbol_link (ValadocGtkdocRenderer* self,
                                           ValadocContentSymbolLink* element)
{
	ValadocApiNode* _tmp0_;
	ValadocApiNode* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_content_symbol_link_get_symbol (element);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValadocGtkDocMarkupWriter* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->writer;
		_tmp3_ = valadoc_content_symbol_link_get_given_symbol_name (element);
		_tmp4_ = _tmp3_;
		valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp2_, _tmp4_);
	} else {
		ValadocApiNode* _tmp5_;
		ValadocApiNode* _tmp6_;
		_tmp5_ = valadoc_content_symbol_link_get_symbol (element);
		_tmp6_ = _tmp5_;
		valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp6_);
	}
}

static void
valadoc_gtkdoc_renderer_real_visit_list (ValadocContentContentVisitor* base,
                                         ValadocContentList* element)
{
	ValadocGtkdocRenderer * self;
	gchar* tag = NULL;
	gchar* _tmp0_;
	ValadocContentListBullet _tmp1_;
	ValadocContentListBullet _tmp2_;
	ValadocGtkDocMarkupWriter* _tmp37_;
	const gchar* _tmp38_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = g_strdup ("orderedlist");
	tag = _tmp0_;
	_tmp1_ = valadoc_content_list_get_bullet (element);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case VALADOC_CONTENT_LIST_BULLET_NONE:
		{
			ValadocGtkDocMarkupWriter* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			gchar* _tmp8_;
			_tmp3_ = self->priv->writer;
			_tmp4_ = g_strdup ("mark");
			_tmp5_ = g_strdup ("none");
			_tmp6_ = g_new0 (gchar*, 2 + 1);
			_tmp6_[0] = _tmp4_;
			_tmp6_[1] = _tmp5_;
			_tmp7_ = _tmp6_;
			_tmp7__length1 = 2;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "itemizedlist", _tmp7_, (gint) 2);
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
			_tmp8_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp8_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_UNORDERED:
		{
			ValadocGtkDocMarkupWriter* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = self->priv->writer;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp9_, "itemizedlist", NULL, (gint) 0);
			_tmp10_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp10_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED:
		{
			ValadocGtkDocMarkupWriter* _tmp11_;
			_tmp11_ = self->priv->writer;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "orderedlist", NULL, (gint) 0);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_NUMBER:
		{
			ValadocGtkDocMarkupWriter* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar** _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			_tmp12_ = self->priv->writer;
			_tmp13_ = g_strdup ("numeration");
			_tmp14_ = g_strdup ("arabic");
			_tmp15_ = g_new0 (gchar*, 2 + 1);
			_tmp15_[0] = _tmp13_;
			_tmp15_[1] = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp16__length1 = 2;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp12_, "orderedlist", _tmp16_, (gint) 2);
			_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ALPHA:
		{
			ValadocGtkDocMarkupWriter* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_;
			gchar** _tmp21_;
			gint _tmp21__length1;
			_tmp17_ = self->priv->writer;
			_tmp18_ = g_strdup ("numeration");
			_tmp19_ = g_strdup ("loweralpha");
			_tmp20_ = g_new0 (gchar*, 2 + 1);
			_tmp20_[0] = _tmp18_;
			_tmp20_[1] = _tmp19_;
			_tmp21_ = _tmp20_;
			_tmp21__length1 = 2;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp17_, "orderedlist", _tmp21_, (gint) 2);
			_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ALPHA:
		{
			ValadocGtkDocMarkupWriter* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** _tmp25_;
			gchar** _tmp26_;
			gint _tmp26__length1;
			_tmp22_ = self->priv->writer;
			_tmp23_ = g_strdup ("numeration");
			_tmp24_ = g_strdup ("upperalpha");
			_tmp25_ = g_new0 (gchar*, 2 + 1);
			_tmp25_[0] = _tmp23_;
			_tmp25_[1] = _tmp24_;
			_tmp26_ = _tmp25_;
			_tmp26__length1 = 2;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp22_, "orderedlist", _tmp26_, (gint) 2);
			_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ROMAN:
		{
			ValadocGtkDocMarkupWriter* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_;
			gchar** _tmp31_;
			gint _tmp31__length1;
			_tmp27_ = self->priv->writer;
			_tmp28_ = g_strdup ("numeration");
			_tmp29_ = g_strdup ("lowerroman");
			_tmp30_ = g_new0 (gchar*, 2 + 1);
			_tmp30_[0] = _tmp28_;
			_tmp30_[1] = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp31__length1 = 2;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp27_, "orderedlist", _tmp31_, (gint) 2);
			_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ROMAN:
		{
			ValadocGtkDocMarkupWriter* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_;
			gchar** _tmp36_;
			gint _tmp36__length1;
			_tmp32_ = self->priv->writer;
			_tmp33_ = g_strdup ("numeration");
			_tmp34_ = g_strdup ("upperroman");
			_tmp35_ = g_new0 (gchar*, 2 + 1);
			_tmp35_[0] = _tmp33_;
			_tmp35_[1] = _tmp34_;
			_tmp36_ = _tmp35_;
			_tmp36__length1 = 2;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp32_, "orderedlist", _tmp36_, (gint) 2);
			_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp37_ = self->priv->writer;
	_tmp38_ = tag;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp37_, _tmp38_);
	_g_free0 (tag);
}

static void
valadoc_gtkdoc_renderer_real_visit_list_item (ValadocContentContentVisitor* base,
                                              ValadocContentListItem* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocGtkDocMarkupWriter* _tmp1_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "listitem", NULL, (gint) 0);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp1_, "listitem");
}

static void
valadoc_gtkdoc_renderer_real_visit_page (ValadocContentContentVisitor* base,
                                         ValadocContentPage* element)
{
	ValadocGtkdocRenderer * self;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
}

static void
valadoc_gtkdoc_renderer_real_visit_paragraph (ValadocContentContentVisitor* base,
                                              ValadocContentParagraph* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocGtkDocMarkupWriter* _tmp1_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "para", NULL, (gint) 0);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp1_, "para");
}

static void
valadoc_gtkdoc_renderer_real_visit_warning (ValadocContentContentVisitor* base,
                                            ValadocContentWarning* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocGtkDocMarkupWriter* _tmp1_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "warning", NULL, (gint) 0);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp1_, "warning");
}

static void
valadoc_gtkdoc_renderer_real_visit_note (ValadocContentContentVisitor* base,
                                         ValadocContentNote* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocGtkDocMarkupWriter* _tmp1_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "note", NULL, (gint) 0);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp1_, "note");
}

static void
valadoc_gtkdoc_renderer_real_visit_run (ValadocContentContentVisitor* base,
                                        ValadocContentRun* element)
{
	ValadocGtkdocRenderer * self;
	gchar* tag = NULL;
	ValadocContentRunStyle _tmp0_;
	ValadocContentRunStyle _tmp1_;
	const gchar* _tmp18_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	tag = NULL;
	_tmp0_ = valadoc_content_run_get_style (element);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALADOC_CONTENT_RUN_STYLE_BOLD:
		{
			ValadocGtkDocMarkupWriter* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			gchar* _tmp7_;
			_tmp2_ = self->priv->writer;
			_tmp3_ = g_strdup ("role");
			_tmp4_ = g_strdup ("bold");
			_tmp5_ = g_new0 (gchar*, 2 + 1);
			_tmp5_[0] = _tmp3_;
			_tmp5_[1] = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 2;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp2_, "emphasis", _tmp6_, (gint) 2);
			_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
			_tmp7_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp7_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_ITALIC:
		{
			ValadocGtkDocMarkupWriter* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = self->priv->writer;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp8_, "emphasis", NULL, (gint) 0);
			_tmp9_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp9_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_UNDERLINED:
		{
			ValadocGtkDocMarkupWriter* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar** _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			gchar* _tmp15_;
			_tmp10_ = self->priv->writer;
			_tmp11_ = g_strdup ("role");
			_tmp12_ = g_strdup ("underline");
			_tmp13_ = g_new0 (gchar*, 2 + 1);
			_tmp13_[0] = _tmp11_;
			_tmp13_[1] = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp14__length1 = 2;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp10_, "emphasis", _tmp14_, (gint) 2);
			_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
			_tmp15_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp15_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_MONOSPACED:
		{
			ValadocGtkDocMarkupWriter* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = self->priv->writer;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp16_, "blockquote", NULL, (gint) 0);
			_tmp17_ = g_strdup ("blockquote");
			_g_free0 (tag);
			tag = _tmp17_;
			break;
		}
		default:
		{
			break;
		}
	}
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp18_ = tag;
	if (_tmp18_ != NULL) {
		ValadocGtkDocMarkupWriter* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = self->priv->writer;
		_tmp20_ = tag;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp19_, _tmp20_);
	}
	_g_free0 (tag);
}

static void
valadoc_gtkdoc_renderer_real_visit_source_code (ValadocContentContentVisitor* base,
                                                ValadocContentSourceCode* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocGtkDocMarkupWriter* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValadocGtkDocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "example", NULL, (gint) 0);
	valadoc_markup_writer_start_tag (_tmp1_, "programlisting", NULL, (gint) 0);
	_tmp2_ = self->priv->writer;
	_tmp3_ = valadoc_content_source_code_get_code (element);
	_tmp4_ = _tmp3_;
	valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp2_, _tmp4_);
	_tmp5_ = self->priv->writer;
	_tmp6_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp5_, "programlisting");
	valadoc_markup_writer_end_tag (_tmp6_, "example");
}

static void
valadoc_gtkdoc_renderer_real_visit_table (ValadocContentContentVisitor* base,
                                          ValadocContentTable* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocGtkDocMarkupWriter* _tmp5_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("align");
	_tmp2_ = g_strdup ("center");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "table", _tmp4_, (gint) 2);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp5_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp5_, "table");
}

static void
valadoc_gtkdoc_renderer_real_visit_table_cell (ValadocContentContentVisitor* base,
                                               ValadocContentTableCell* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocGtkDocMarkupWriter* _tmp11_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	_tmp1_ = g_strdup ("colspan");
	_tmp2_ = valadoc_content_table_cell_get_colspan (element);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = g_strdup ("rowspan");
	_tmp6_ = valadoc_content_table_cell_get_rowspan (element);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = g_new0 (gchar*, 4 + 1);
	_tmp9_[0] = _tmp1_;
	_tmp9_[1] = _tmp4_;
	_tmp9_[2] = _tmp5_;
	_tmp9_[3] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 4;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "td", _tmp10_, (gint) 4);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp11_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "td");
}

static void
valadoc_gtkdoc_renderer_real_visit_table_row (ValadocContentContentVisitor* base,
                                              ValadocContentTableRow* element)
{
	ValadocGtkdocRenderer * self;
	ValadocGtkDocMarkupWriter* _tmp0_;
	ValadocGtkDocMarkupWriter* _tmp1_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->writer;
	valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "tr", NULL, (gint) 0);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->writer;
	valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp1_, "tr");
}

static void
valadoc_gtkdoc_renderer_real_visit_text (ValadocContentContentVisitor* base,
                                         ValadocContentText* element)
{
	ValadocGtkdocRenderer * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValadocGtkdocRenderer*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_content_text_get_content (element);
	_tmp1_ = _tmp0_;
	valadoc_gtkdoc_renderer_write_string (self, _tmp1_);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
valadoc_gtkdoc_renderer_write_string (ValadocGtkdocRenderer* self,
                                      const gchar* content)
{
	gunichar chr = 0U;
	glong lpos = 0L;
	gint i = 0;
	ValadocGtkDocMarkupWriter* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	chr = (gunichar) string_get (content, (glong) 0);
	lpos = (glong) 0;
	i = 0;
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
				chr = (gunichar) string_get (content, (glong) i);
			}
			_tmp0_ = FALSE;
			if (!(chr != ((gunichar) '\0'))) {
				break;
			}
			switch (chr) {
				case '<':
				{
					ValadocGtkDocMarkupWriter* _tmp2_;
					gchar* _tmp3_;
					gchar* _tmp4_;
					ValadocGtkDocMarkupWriter* _tmp5_;
					_tmp2_ = self->priv->writer;
					_tmp3_ = string_substring (content, lpos, i - lpos);
					_tmp4_ = _tmp3_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp2_, _tmp4_);
					_g_free0 (_tmp4_);
					_tmp5_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp5_, "&lt;");
					lpos = (glong) (i + 1);
					break;
				}
				case '>':
				{
					ValadocGtkDocMarkupWriter* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					ValadocGtkDocMarkupWriter* _tmp9_;
					_tmp6_ = self->priv->writer;
					_tmp7_ = string_substring (content, lpos, i - lpos);
					_tmp8_ = _tmp7_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp6_, _tmp8_);
					_g_free0 (_tmp8_);
					_tmp9_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp9_, "&gt;");
					lpos = (glong) (i + 1);
					break;
				}
				case '"':
				{
					ValadocGtkDocMarkupWriter* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					ValadocGtkDocMarkupWriter* _tmp13_;
					_tmp10_ = self->priv->writer;
					_tmp11_ = string_substring (content, lpos, i - lpos);
					_tmp12_ = _tmp11_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp10_, _tmp12_);
					_g_free0 (_tmp12_);
					_tmp13_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp13_, "&quot;");
					lpos = (glong) (i + 1);
					break;
				}
				case '\'':
				{
					ValadocGtkDocMarkupWriter* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					ValadocGtkDocMarkupWriter* _tmp17_;
					_tmp14_ = self->priv->writer;
					_tmp15_ = string_substring (content, lpos, i - lpos);
					_tmp16_ = _tmp15_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp14_, _tmp16_);
					_g_free0 (_tmp16_);
					_tmp17_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp17_, "&apos;");
					lpos = (glong) (i + 1);
					break;
				}
				case '&':
				{
					ValadocGtkDocMarkupWriter* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					ValadocGtkDocMarkupWriter* _tmp21_;
					_tmp18_ = self->priv->writer;
					_tmp19_ = string_substring (content, lpos, i - lpos);
					_tmp20_ = _tmp19_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp18_, _tmp20_);
					_g_free0 (_tmp20_);
					_tmp21_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp21_, "&amp;");
					lpos = (glong) (i + 1);
					break;
				}
				case '#':
				{
					ValadocGtkDocMarkupWriter* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					ValadocGtkDocMarkupWriter* _tmp25_;
					_tmp22_ = self->priv->writer;
					_tmp23_ = string_substring (content, lpos, i - lpos);
					_tmp24_ = _tmp23_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp22_, _tmp24_);
					_g_free0 (_tmp24_);
					_tmp25_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp25_, "&num;");
					lpos = (glong) (i + 1);
					break;
				}
				case '%':
				{
					ValadocGtkDocMarkupWriter* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					ValadocGtkDocMarkupWriter* _tmp29_;
					_tmp26_ = self->priv->writer;
					_tmp27_ = string_substring (content, lpos, i - lpos);
					_tmp28_ = _tmp27_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp26_, _tmp28_);
					_g_free0 (_tmp28_);
					_tmp29_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp29_, "&percnt;");
					lpos = (glong) (i + 1);
					break;
				}
				case '@':
				{
					ValadocGtkDocMarkupWriter* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					ValadocGtkDocMarkupWriter* _tmp33_;
					_tmp30_ = self->priv->writer;
					_tmp31_ = string_substring (content, lpos, i - lpos);
					_tmp32_ = _tmp31_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp30_, _tmp32_);
					_g_free0 (_tmp32_);
					_tmp33_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp33_, "&commat;");
					lpos = (glong) (i + 1);
					break;
				}
				case '(':
				{
					ValadocGtkDocMarkupWriter* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					ValadocGtkDocMarkupWriter* _tmp37_;
					_tmp34_ = self->priv->writer;
					_tmp35_ = string_substring (content, lpos, i - lpos);
					_tmp36_ = _tmp35_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp34_, _tmp36_);
					_g_free0 (_tmp36_);
					_tmp37_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp37_, "&lpar;");
					lpos = (glong) (i + 1);
					break;
				}
				case ')':
				{
					ValadocGtkDocMarkupWriter* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					ValadocGtkDocMarkupWriter* _tmp41_;
					_tmp38_ = self->priv->writer;
					_tmp39_ = string_substring (content, lpos, i - lpos);
					_tmp40_ = _tmp39_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp38_, _tmp40_);
					_g_free0 (_tmp40_);
					_tmp41_ = self->priv->writer;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp41_, "&rpar;");
					lpos = (glong) (i + 1);
					break;
				}
				case '\n':
				{
					ValadocGtkDocMarkupWriter* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					ValadocGtkDocMarkupWriter* _tmp45_;
					_tmp42_ = self->priv->writer;
					_tmp43_ = string_substring (content, lpos, i - lpos);
					_tmp44_ = _tmp43_;
					valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp42_, _tmp44_);
					_g_free0 (_tmp44_);
					_tmp45_ = self->priv->writer;
					valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp45_, "br", NULL, (gint) 0);
					lpos = (glong) (i + 1);
					break;
				}
				default:
				break;
			}
		}
	}
	_tmp46_ = self->priv->writer;
	_tmp47_ = string_substring (content, lpos, i - lpos);
	_tmp48_ = _tmp47_;
	valadoc_markup_writer_raw_text ((ValadocMarkupWriter*) _tmp46_, _tmp48_);
	_g_free0 (_tmp48_);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
valadoc_gtkdoc_renderer_append_since (ValadocGtkdocRenderer* self,
                                      ValaList* taglets)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		gint __taglet_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint __taglet_index = 0;
		_tmp0_ = _vala_iterable_ref0 (taglets);
		__taglet_list = _tmp0_;
		_tmp1_ = __taglet_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		__taglet_size = _tmp3_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValadocTagletsSince* taglet = NULL;
			ValadocContentTaglet* _tmp8_;
			ValadocTagletsSince* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValadocTagletsSince* _tmp11_;
			ValadocGtkDocMarkupWriter* _tmp16_;
			ValadocGtkDocMarkupWriter* _tmp17_;
			ValadocMarkupWriter* _tmp18_;
			ValadocTagletsSince* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			ValadocGtkDocMarkupWriter* _tmp22_;
			__taglet_index = __taglet_index + 1;
			_tmp4_ = __taglet_index;
			_tmp5_ = __taglet_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = __taglet_list;
			_tmp7_ = vala_list_get (_tmp6_, __taglet_index);
			_taglet = (ValadocContentTaglet*) _tmp7_;
			_tmp8_ = _taglet;
			_tmp9_ = _g_object_ref0 (VALADOC_TAGLETS_IS_SINCE (_tmp8_) ? ((ValadocTagletsSince*) _tmp8_) : NULL);
			taglet = _tmp9_;
			_tmp11_ = taglet;
			if (_tmp11_ == NULL) {
				_tmp10_ = TRUE;
			} else {
				ValadocTagletsSince* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = taglet;
				_tmp13_ = valadoc_taglets_since_get_version (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp10_ = _tmp14_ == NULL;
			}
			if (_tmp10_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			if (self->priv->separated == FALSE) {
				ValadocGtkDocMarkupWriter* _tmp15_;
				_tmp15_ = self->priv->writer;
				valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp15_, "\n");
			}
			_tmp16_ = self->priv->writer;
			valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp16_, FALSE);
			_tmp17_ = self->priv->writer;
			_tmp18_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp17_, "\nSince: ");
			_tmp19_ = taglet;
			_tmp20_ = valadoc_taglets_since_get_version (_tmp19_);
			_tmp21_ = _tmp20_;
			valadoc_markup_writer_text (_tmp18_, _tmp21_);
			_tmp22_ = self->priv->writer;
			valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp22_, TRUE);
			self->priv->separated = TRUE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
			_vala_iterable_unref0 (__taglet_list);
			return;
		}
		_vala_iterable_unref0 (__taglet_list);
	}
}

void
valadoc_gtkdoc_renderer_append_see (ValadocGtkdocRenderer* self,
                                    ValaList* taglets)
{
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	first = TRUE;
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		gint __taglet_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint __taglet_index = 0;
		_tmp0_ = _vala_iterable_ref0 (taglets);
		__taglet_list = _tmp0_;
		_tmp1_ = __taglet_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		__taglet_size = _tmp3_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValadocTagletsSee* taglet = NULL;
			ValadocContentTaglet* _tmp8_;
			ValadocTagletsSee* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValadocTagletsSee* _tmp11_;
			ValadocTagletsSee* _tmp18_;
			ValadocApiNode* _tmp19_;
			ValadocApiNode* _tmp20_;
			__taglet_index = __taglet_index + 1;
			_tmp4_ = __taglet_index;
			_tmp5_ = __taglet_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = __taglet_list;
			_tmp7_ = vala_list_get (_tmp6_, __taglet_index);
			_taglet = (ValadocContentTaglet*) _tmp7_;
			_tmp8_ = _taglet;
			_tmp9_ = _g_object_ref0 (VALADOC_TAGLETS_IS_SEE (_tmp8_) ? ((ValadocTagletsSee*) _tmp8_) : NULL);
			taglet = _tmp9_;
			_tmp11_ = taglet;
			if (_tmp11_ == NULL) {
				_tmp10_ = TRUE;
			} else {
				ValadocTagletsSee* _tmp12_;
				ValadocApiNode* _tmp13_;
				ValadocApiNode* _tmp14_;
				_tmp12_ = taglet;
				_tmp13_ = valadoc_taglets_see_get_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp10_ = _tmp14_ == NULL;
			}
			if (_tmp10_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			if (first) {
				ValadocGtkDocMarkupWriter* _tmp15_;
				ValadocMarkupWriter* _tmp16_;
				_tmp15_ = self->priv->writer;
				_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp15_, "para", NULL, (gint) 0);
				valadoc_markup_writer_text (_tmp16_, "See also: ");
			} else {
				ValadocGtkDocMarkupWriter* _tmp17_;
				_tmp17_ = self->priv->writer;
				valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp17_, ", ");
			}
			_tmp18_ = taglet;
			_tmp19_ = valadoc_taglets_see_get_symbol (_tmp18_);
			_tmp20_ = _tmp19_;
			valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp20_);
			first = FALSE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
		}
		_vala_iterable_unref0 (__taglet_list);
	}
	if (first == FALSE) {
		ValadocGtkDocMarkupWriter* _tmp21_;
		_tmp21_ = self->priv->writer;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp21_, "para");
	}
}

void
valadoc_gtkdoc_renderer_append_exceptions (ValadocGtkdocRenderer* self,
                                           ValaList* taglets)
{
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglets != NULL);
	first = TRUE;
	{
		ValaList* __taglet_list = NULL;
		ValaList* _tmp0_;
		gint __taglet_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint __taglet_index = 0;
		_tmp0_ = _vala_iterable_ref0 (taglets);
		__taglet_list = _tmp0_;
		_tmp1_ = __taglet_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		__taglet_size = _tmp3_;
		__taglet_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValadocContentTaglet* _taglet = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValadocTagletsThrows* taglet = NULL;
			ValadocContentTaglet* _tmp8_;
			ValadocTagletsThrows* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValadocTagletsThrows* _tmp11_;
			ValadocGtkDocMarkupWriter* _tmp19_;
			ValadocGtkDocMarkupWriter* _tmp20_;
			ValadocTagletsThrows* _tmp21_;
			ValadocApiNode* _tmp22_;
			ValadocApiNode* _tmp23_;
			ValadocGtkDocMarkupWriter* _tmp24_;
			ValadocGtkDocMarkupWriter* _tmp25_;
			ValadocTagletsThrows* _tmp26_;
			ValadocGtkDocMarkupWriter* _tmp27_;
			ValadocGtkDocMarkupWriter* _tmp28_;
			__taglet_index = __taglet_index + 1;
			_tmp4_ = __taglet_index;
			_tmp5_ = __taglet_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = __taglet_list;
			_tmp7_ = vala_list_get (_tmp6_, __taglet_index);
			_taglet = (ValadocContentTaglet*) _tmp7_;
			_tmp8_ = _taglet;
			_tmp9_ = _g_object_ref0 (VALADOC_TAGLETS_IS_THROWS (_tmp8_) ? ((ValadocTagletsThrows*) _tmp8_) : NULL);
			taglet = _tmp9_;
			_tmp11_ = taglet;
			if (_tmp11_ == NULL) {
				_tmp10_ = TRUE;
			} else {
				ValadocTagletsThrows* _tmp12_;
				ValadocApiNode* _tmp13_;
				ValadocApiNode* _tmp14_;
				_tmp12_ = taglet;
				_tmp13_ = valadoc_taglets_throws_get_error_domain (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp10_ = _tmp14_ == NULL;
			}
			if (_tmp10_) {
				_g_object_unref0 (taglet);
				_g_object_unref0 (_taglet);
				continue;
			}
			if (first) {
				ValadocGtkDocMarkupWriter* _tmp15_;
				ValadocMarkupWriter* _tmp16_;
				ValadocMarkupWriter* _tmp17_;
				ValadocGtkDocMarkupWriter* _tmp18_;
				_tmp15_ = self->priv->writer;
				_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp15_, "para", NULL, (gint) 0);
				_tmp17_ = valadoc_markup_writer_text (_tmp16_, "This function may throw:");
				valadoc_markup_writer_end_tag (_tmp17_, "para");
				_tmp18_ = self->priv->writer;
				valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp18_, "table", NULL, (gint) 0);
			}
			_tmp19_ = self->priv->writer;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp19_, "tr", NULL, (gint) 0);
			_tmp20_ = self->priv->writer;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp20_, "td", NULL, (gint) 0);
			_tmp21_ = taglet;
			_tmp22_ = valadoc_taglets_throws_get_error_domain (_tmp21_);
			_tmp23_ = _tmp22_;
			valadoc_gtkdoc_renderer_write_docbook_link (self, (ValadocApiItem*) _tmp23_);
			_tmp24_ = self->priv->writer;
			valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp24_, "td");
			_tmp25_ = self->priv->writer;
			valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp25_, "td", NULL, (gint) 0);
			_tmp26_ = taglet;
			valadoc_content_content_element_accept_children ((ValadocContentContentElement*) _tmp26_, (ValadocContentContentVisitor*) self);
			_tmp27_ = self->priv->writer;
			valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp27_, "td");
			_tmp28_ = self->priv->writer;
			valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp28_, "tr");
			first = FALSE;
			_g_object_unref0 (taglet);
			_g_object_unref0 (_taglet);
		}
		_vala_iterable_unref0 (__taglet_list);
	}
	if (first == FALSE) {
		ValadocGtkDocMarkupWriter* _tmp29_;
		_tmp29_ = self->priv->writer;
		valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp29_, "table");
	}
}

static void
valadoc_gtkdoc_renderer_class_init (ValadocGtkdocRendererClass * klass,
                                    gpointer klass_data)
{
	valadoc_gtkdoc_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocGtkdocRenderer_private_offset);
	((ValadocContentContentRendererClass *) klass)->render = (void (*) (ValadocContentContentRenderer*, ValadocContentContentElement*)) valadoc_gtkdoc_renderer_real_render;
	((ValadocContentContentRendererClass *) klass)->render_children = (void (*) (ValadocContentContentRenderer*, ValadocContentContentElement*)) valadoc_gtkdoc_renderer_real_render_children;
	((ValadocContentContentVisitorClass *) klass)->visit_comment = (void (*) (ValadocContentContentVisitor*, ValadocContentComment*)) valadoc_gtkdoc_renderer_real_visit_comment;
	((ValadocContentContentVisitorClass *) klass)->visit_embedded = (void (*) (ValadocContentContentVisitor*, ValadocContentEmbedded*)) valadoc_gtkdoc_renderer_real_visit_embedded;
	((ValadocContentContentVisitorClass *) klass)->visit_headline = (void (*) (ValadocContentContentVisitor*, ValadocContentHeadline*)) valadoc_gtkdoc_renderer_real_visit_headline;
	((ValadocContentContentVisitorClass *) klass)->visit_wiki_link = (void (*) (ValadocContentContentVisitor*, ValadocContentWikiLink*)) valadoc_gtkdoc_renderer_real_visit_wiki_link;
	((ValadocContentContentVisitorClass *) klass)->visit_link = (void (*) (ValadocContentContentVisitor*, ValadocContentLink*)) valadoc_gtkdoc_renderer_real_visit_link;
	((ValadocContentContentVisitorClass *) klass)->visit_symbol_link = (void (*) (ValadocContentContentVisitor*, ValadocContentSymbolLink*)) valadoc_gtkdoc_renderer_real_visit_symbol_link;
	((ValadocContentContentVisitorClass *) klass)->visit_list = (void (*) (ValadocContentContentVisitor*, ValadocContentList*)) valadoc_gtkdoc_renderer_real_visit_list;
	((ValadocContentContentVisitorClass *) klass)->visit_list_item = (void (*) (ValadocContentContentVisitor*, ValadocContentListItem*)) valadoc_gtkdoc_renderer_real_visit_list_item;
	((ValadocContentContentVisitorClass *) klass)->visit_page = (void (*) (ValadocContentContentVisitor*, ValadocContentPage*)) valadoc_gtkdoc_renderer_real_visit_page;
	((ValadocContentContentVisitorClass *) klass)->visit_paragraph = (void (*) (ValadocContentContentVisitor*, ValadocContentParagraph*)) valadoc_gtkdoc_renderer_real_visit_paragraph;
	((ValadocContentContentVisitorClass *) klass)->visit_warning = (void (*) (ValadocContentContentVisitor*, ValadocContentWarning*)) valadoc_gtkdoc_renderer_real_visit_warning;
	((ValadocContentContentVisitorClass *) klass)->visit_note = (void (*) (ValadocContentContentVisitor*, ValadocContentNote*)) valadoc_gtkdoc_renderer_real_visit_note;
	((ValadocContentContentVisitorClass *) klass)->visit_run = (void (*) (ValadocContentContentVisitor*, ValadocContentRun*)) valadoc_gtkdoc_renderer_real_visit_run;
	((ValadocContentContentVisitorClass *) klass)->visit_source_code = (void (*) (ValadocContentContentVisitor*, ValadocContentSourceCode*)) valadoc_gtkdoc_renderer_real_visit_source_code;
	((ValadocContentContentVisitorClass *) klass)->visit_table = (void (*) (ValadocContentContentVisitor*, ValadocContentTable*)) valadoc_gtkdoc_renderer_real_visit_table;
	((ValadocContentContentVisitorClass *) klass)->visit_table_cell = (void (*) (ValadocContentContentVisitor*, ValadocContentTableCell*)) valadoc_gtkdoc_renderer_real_visit_table_cell;
	((ValadocContentContentVisitorClass *) klass)->visit_table_row = (void (*) (ValadocContentContentVisitor*, ValadocContentTableRow*)) valadoc_gtkdoc_renderer_real_visit_table_row;
	((ValadocContentContentVisitorClass *) klass)->visit_text = (void (*) (ValadocContentContentVisitor*, ValadocContentText*)) valadoc_gtkdoc_renderer_real_visit_text;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_gtkdoc_renderer_get_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_gtkdoc_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY, valadoc_gtkdoc_renderer_properties[VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY] = g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
valadoc_gtkdoc_renderer_instance_init (ValadocGtkdocRenderer * self,
                                       gpointer klass)
{
	ValadocGtkDocMarkupWriter* _tmp0_;
	self->priv = valadoc_gtkdoc_renderer_get_instance_private (self);
	_tmp0_ = valadoc_gtk_doc_markup_writer_new ();
	self->priv->writer = _tmp0_;
}

static void
valadoc_gtkdoc_renderer_finalize (GObject * obj)
{
	ValadocGtkdocRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_GTKDOC_RENDERER, ValadocGtkdocRenderer);
	_valadoc_markup_writer_unref0 (self->priv->writer);
	_g_object_unref0 (self->settings);
	G_OBJECT_CLASS (valadoc_gtkdoc_renderer_parent_class)->finalize (obj);
}

static GType
valadoc_gtkdoc_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocRenderer), 0, (GInstanceInitFunc) valadoc_gtkdoc_renderer_instance_init, NULL };
	GType valadoc_gtkdoc_renderer_type_id;
	valadoc_gtkdoc_renderer_type_id = g_type_register_static (VALADOC_CONTENT_TYPE_CONTENT_RENDERER, "ValadocGtkdocRenderer", &g_define_type_info, 0);
	ValadocGtkdocRenderer_private_offset = g_type_add_instance_private (valadoc_gtkdoc_renderer_type_id, sizeof (ValadocGtkdocRendererPrivate));
	return valadoc_gtkdoc_renderer_type_id;
}

GType
valadoc_gtkdoc_renderer_get_type (void)
{
	static volatile gsize valadoc_gtkdoc_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_renderer_type_id__volatile)) {
		GType valadoc_gtkdoc_renderer_type_id;
		valadoc_gtkdoc_renderer_type_id = valadoc_gtkdoc_renderer_get_type_once ();
		g_once_init_leave (&valadoc_gtkdoc_renderer_type_id__volatile, valadoc_gtkdoc_renderer_type_id);
	}
	return valadoc_gtkdoc_renderer_type_id__volatile;
}

static void
_vala_valadoc_gtkdoc_renderer_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ValadocGtkdocRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_GTKDOC_RENDERER, ValadocGtkdocRenderer);
	switch (property_id) {
		case VALADOC_GTKDOC_RENDERER_CONTENT_PROPERTY:
		g_value_set_string (value, valadoc_gtkdoc_renderer_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

