/* valaccodefunctioncall.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEFUNCTIONCALL_H__
#define __CCODE_VALACCODEFUNCTIONCALL_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_FUNCTION_CALL (vala_ccode_function_call_get_type ())
#define VALA_CCODE_FUNCTION_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall))
#define VALA_CCODE_FUNCTION_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCallClass))
#define VALA_IS_CCODE_FUNCTION_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FUNCTION_CALL))
#define VALA_IS_CCODE_FUNCTION_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FUNCTION_CALL))
#define VALA_CCODE_FUNCTION_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCallClass))

typedef struct _ValaCCodeFunctionCall ValaCCodeFunctionCall;
typedef struct _ValaCCodeFunctionCallClass ValaCCodeFunctionCallClass;
typedef struct _ValaCCodeFunctionCallPrivate ValaCCodeFunctionCallPrivate;

/**
 * Represents a function call in the C code.
 */
struct _ValaCCodeFunctionCall {
	ValaCCodeExpression parent_instance;
	ValaCCodeFunctionCallPrivate * priv;
};

struct _ValaCCodeFunctionCallClass {
	ValaCCodeExpressionClass parent_class;
};


ValaCCodeFunctionCall* vala_ccode_function_call_construct (GType object_type, ValaCCodeExpression* call);
ValaCCodeFunctionCall* vala_ccode_function_call_new (ValaCCodeExpression* call);
void vala_ccode_function_call_add_argument (ValaCCodeFunctionCall* self, ValaCCodeExpression* expr);
void vala_ccode_function_call_insert_argument (ValaCCodeFunctionCall* self, gint index, ValaCCodeExpression* expr);
GeeList* vala_ccode_function_call_get_arguments (ValaCCodeFunctionCall* self);
ValaCCodeExpression* vala_ccode_function_call_get_call (ValaCCodeFunctionCall* self);
void vala_ccode_function_call_set_call (ValaCCodeFunctionCall* self, ValaCCodeExpression* value);
GType vala_ccode_function_call_get_type (void);


G_END_DECLS

#endif
