/* valaccodelinedirective.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodewriter.h>




struct _ValaCCodeLineDirectivePrivate {
	char* _filename;
	gint _line_number;
};

#define VALA_CCODE_LINE_DIRECTIVE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_LINE_DIRECTIVE, ValaCCodeLineDirectivePrivate))
enum  {
	VALA_CCODE_LINE_DIRECTIVE_DUMMY_PROPERTY
};
static void vala_ccode_line_directive_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_line_directive_parent_class = NULL;
static void vala_ccode_line_directive_finalize (ValaCCodeNode* obj);



ValaCCodeLineDirective* vala_ccode_line_directive_construct (GType object_type, const char* _filename, gint _line) {
	ValaCCodeLineDirective* self;
	g_return_val_if_fail (_filename != NULL, NULL);
	self = (ValaCCodeLineDirective*) g_type_create_instance (object_type);
	vala_ccode_line_directive_set_filename (self, _filename);
	vala_ccode_line_directive_set_line_number (self, _line);
	return self;
}


ValaCCodeLineDirective* vala_ccode_line_directive_new (const char* _filename, gint _line) {
	return vala_ccode_line_directive_construct (VALA_TYPE_CCODE_LINE_DIRECTIVE, _filename, _line);
}


static void vala_ccode_line_directive_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeLineDirective * self;
	char* _tmp0;
	self = (ValaCCodeLineDirective*) base;
	g_return_if_fail (writer != NULL);
	if (!vala_ccode_writer_get_bol (writer)) {
		vala_ccode_writer_write_newline (writer);
	}
	_tmp0 = NULL;
	vala_ccode_writer_write_string (writer, _tmp0 = g_strdup_printf ("#line %d \"%s\"", self->priv->_line_number, self->priv->_filename));
	_tmp0 = (g_free (_tmp0), NULL);
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_line_directive_get_filename (ValaCCodeLineDirective* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_filename;
}


void vala_ccode_line_directive_set_filename (ValaCCodeLineDirective* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_filename = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_filename = (g_free (self->priv->_filename), NULL), _tmp2);
}


gint vala_ccode_line_directive_get_line_number (ValaCCodeLineDirective* self) {
	g_return_val_if_fail (self != NULL, 0);
	return self->priv->_line_number;
}


void vala_ccode_line_directive_set_line_number (ValaCCodeLineDirective* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_line_number = value;
}


static void vala_ccode_line_directive_class_init (ValaCCodeLineDirectiveClass * klass) {
	vala_ccode_line_directive_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_line_directive_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeLineDirectivePrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_line_directive_real_write;
}


static void vala_ccode_line_directive_instance_init (ValaCCodeLineDirective * self) {
	self->priv = VALA_CCODE_LINE_DIRECTIVE_GET_PRIVATE (self);
}


static void vala_ccode_line_directive_finalize (ValaCCodeNode* obj) {
	ValaCCodeLineDirective * self;
	self = VALA_CCODE_LINE_DIRECTIVE (obj);
	self->priv->_filename = (g_free (self->priv->_filename), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_line_directive_parent_class)->finalize (obj);
}


GType vala_ccode_line_directive_get_type (void) {
	static GType vala_ccode_line_directive_type_id = 0;
	if (vala_ccode_line_directive_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeLineDirectiveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_line_directive_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeLineDirective), 0, (GInstanceInitFunc) vala_ccode_line_directive_instance_init, NULL };
		vala_ccode_line_directive_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeLineDirective", &g_define_type_info, 0);
	}
	return vala_ccode_line_directive_type_id;
}




