/* valastructregisterfunction.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valastructregisterfunction.h>




struct _ValaStructRegisterFunctionPrivate {
	ValaStruct* _struct_reference;
};

#define VALA_STRUCT_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionPrivate))
enum  {
	VALA_STRUCT_REGISTER_FUNCTION_DUMMY_PROPERTY
};
static ValaTypeSymbol* vala_struct_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base);
static ValaSymbolAccessibility vala_struct_register_function_real_get_accessibility (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_struct_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base);
static gpointer vala_struct_register_function_parent_class = NULL;
static void vala_struct_register_function_finalize (ValaTypeRegisterFunction* obj);



/**
 * Creates a new C function to register the specified class at runtime.
 *
 * @param cl a class
 * @return   newly created class register function
 */
ValaStructRegisterFunction* vala_struct_register_function_construct (GType object_type, ValaStruct* st, ValaCodeContext* context) {
	ValaStructRegisterFunction* self;
	g_return_val_if_fail (st != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	self = (ValaStructRegisterFunction*) g_type_create_instance (object_type);
	vala_struct_register_function_set_struct_reference (self, st);
	vala_typeregister_function_set_context ((ValaTypeRegisterFunction*) self, context);
	return self;
}


ValaStructRegisterFunction* vala_struct_register_function_new (ValaStruct* st, ValaCodeContext* context) {
	return vala_struct_register_function_construct (VALA_TYPE_STRUCT_REGISTER_FUNCTION, st, context);
}


static ValaTypeSymbol* vala_struct_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base) {
	ValaStructRegisterFunction * self;
	ValaTypeSymbol* _tmp0;
	self = (ValaStructRegisterFunction*) base;
	_tmp0 = NULL;
	return (_tmp0 = (ValaTypeSymbol*) self->priv->_struct_reference, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
}


static ValaSymbolAccessibility vala_struct_register_function_real_get_accessibility (ValaTypeRegisterFunction* base) {
	ValaStructRegisterFunction * self;
	self = (ValaStructRegisterFunction*) base;
	return vala_symbol_get_access ((ValaSymbol*) self->priv->_struct_reference);
}


static ValaCCodeFragment* vala_struct_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base) {
	ValaStructRegisterFunction * self;
	self = (ValaStructRegisterFunction*) base;
	return vala_ccode_fragment_new ();
}


ValaStruct* vala_struct_register_function_get_struct_reference (ValaStructRegisterFunction* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_struct_reference;
}


void vala_struct_register_function_set_struct_reference (ValaStructRegisterFunction* self, ValaStruct* value) {
	g_return_if_fail (self != NULL);
	self->priv->_struct_reference = value;
}


static void vala_struct_register_function_class_init (ValaStructRegisterFunctionClass * klass) {
	vala_struct_register_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_struct_register_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaStructRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_struct_register_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_struct_register_function_real_get_accessibility;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_struct_register_function_real_get_type_interface_init_statements;
}


static void vala_struct_register_function_instance_init (ValaStructRegisterFunction * self) {
	self->priv = VALA_STRUCT_REGISTER_FUNCTION_GET_PRIVATE (self);
}


static void vala_struct_register_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaStructRegisterFunction * self;
	self = VALA_STRUCT_REGISTER_FUNCTION (obj);
	VALA_TYPEREGISTER_FUNCTION_CLASS (vala_struct_register_function_parent_class)->finalize (obj);
}


GType vala_struct_register_function_get_type (void) {
	static GType vala_struct_register_function_type_id = 0;
	if (vala_struct_register_function_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStructRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStructRegisterFunction), 0, (GInstanceInitFunc) vala_struct_register_function_instance_init, NULL };
		vala_struct_register_function_type_id = g_type_register_static (VALA_TYPE_TYPEREGISTER_FUNCTION, "ValaStructRegisterFunction", &g_define_type_info, 0);
	}
	return vala_struct_register_function_type_id;
}




