/* valasignaltype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASIGNALTYPE_H__
#define __VALA_VALASIGNALTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <vala/valadatatype.h>
#include <vala/valasignal.h>

G_BEGIN_DECLS


#define VALA_TYPE_SIGNAL_TYPE (vala_signal_type_get_type ())
#define VALA_SIGNAL_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL_TYPE, ValaSignalType))
#define VALA_SIGNAL_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL_TYPE, ValaSignalTypeClass))
#define VALA_IS_SIGNAL_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL_TYPE))
#define VALA_IS_SIGNAL_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL_TYPE))
#define VALA_SIGNAL_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL_TYPE, ValaSignalTypeClass))

typedef struct _ValaSignalType ValaSignalType;
typedef struct _ValaSignalTypeClass ValaSignalTypeClass;
typedef struct _ValaSignalTypePrivate ValaSignalTypePrivate;

/**
 * The type of a signal referencea.
 */
struct _ValaSignalType {
	ValaDataType parent_instance;
	ValaSignalTypePrivate * priv;
};

struct _ValaSignalTypeClass {
	ValaDataTypeClass parent_class;
};


ValaSignalType* vala_signal_type_construct (GType object_type, ValaSignal* signal_symbol);
ValaSignalType* vala_signal_type_new (ValaSignal* signal_symbol);
ValaSignal* vala_signal_type_get_signal_symbol (ValaSignalType* self);
void vala_signal_type_set_signal_symbol (ValaSignalType* self, ValaSignal* value);
GType vala_signal_type_get_type (void);


G_END_DECLS

#endif
