/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp659_ = FALSE;
	gboolean _tmp660_ = FALSE;
	gboolean _tmp661_ = FALSE;
	ValaExpression* _tmp662_;
	ValaExpression* _tmp663_;
	ValaSymbol* _tmp690_;
	ValaSymbol* _tmp691_;
	ValaSymbol* _tmp760_;
	ValaSymbol* _tmp761_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp797_;
	ValaSymbol* _tmp798_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp799_;
	ValaSymbol* _tmp800_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1248_;
	ValaSymbol* _tmp1249_;
	ValaSymbol* _tmp1251_;
	ValaVersionAttribute* _tmp1252_;
	ValaVersionAttribute* _tmp1253_;
	ValaSourceReference* _tmp1254_;
	ValaSourceReference* _tmp1255_;
	gboolean _tmp1256_ = FALSE;
	ValaSymbolAccessibility _tmp1257_;
	gboolean _tmp1309_ = FALSE;
	gboolean _tmp1336_ = FALSE;
	gboolean _tmp1337_ = FALSE;
	ValaDataType* _tmp1620_;
	ValaDataType* _tmp1621_;
	gboolean _tmp1624_;
	gboolean _tmp1625_;
	gboolean _tmp1626_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		gint _type_arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_type_arg_list = _tmp8_;
		_tmp9_ = _type_arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_type_arg_size = _tmp11_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaDataType* _tmp16_;
			_type_arg_index = _type_arg_index + 1;
			_tmp12_ = _type_arg_index;
			_tmp13_ = _type_arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _type_arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp15_;
			_tmp16_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp16_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp17_);
	visited_types = _tmp18_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp19_ = self->priv->_qualified;
	if (_tmp19_) {
		ValaNamespace* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaScope* _tmp23_;
		ValaScope* _tmp24_;
		const gchar* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		_tmp20_ = vala_code_context_get_root (context);
		_tmp21_ = _tmp20_;
		base_symbol = (ValaSymbol*) _tmp21_;
		_tmp22_ = base_symbol;
		_tmp23_ = vala_symbol_get_scope (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_member_name;
		_tmp26_ = vala_scope_lookup (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
	} else {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp179_ = FALSE;
			ValaSymbol* _tmp180_;
			ValaSymbol* _tmp181_;
			_tmp30_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp30_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp31_;
				ValaSemanticAnalyzer* _tmp32_;
				_tmp31_ = vala_code_context_get_analyzer (context);
				_tmp32_ = _tmp31_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp32_)) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp34_ = _tmp33_;
					vala_report_error (_tmp34_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp35_ = vala_code_context_get_analyzer (context);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_semantic_analyzer_get_current_symbol (_tmp36_);
			_tmp38_ = _tmp37_;
			base_symbol = _tmp38_;
			method_found = FALSE;
			_tmp39_ = vala_code_context_get_analyzer (context);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_semantic_analyzer_get_current_symbol (_tmp40_);
			_tmp42_ = _tmp41_;
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp90_;
				const gchar* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaSymbol* _tmp93_;
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp132_ = FALSE;
				gboolean _tmp133_ = FALSE;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaParameter* _tmp50_;
						ValaParameter* _tmp51_;
						_tmp48_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp49_ = cm;
						_tmp50_ = vala_method_get_this_parameter ((ValaMethod*) _tmp49_);
						_tmp51_ = _tmp50_;
						this_parameter = _tmp51_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp52_;
						_tmp52_ = sym;
						if (VALA_IS_PROPERTY (_tmp52_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp53_;
							ValaProperty* _tmp54_;
							ValaParameter* _tmp55_;
							ValaParameter* _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							_tmp53_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_this_parameter (_tmp54_);
							_tmp56_ = _tmp55_;
							this_parameter = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_instance_members = _tmp59_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_klass_members = _tmp62_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp63_;
							_tmp63_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp63_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaParameter* _tmp66_;
								ValaParameter* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaMemberBinding _tmp69_;
								ValaMemberBinding _tmp70_;
								_tmp64_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_this_parameter (_tmp65_);
								_tmp67_ = _tmp66_;
								this_parameter = _tmp67_;
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_binding (_tmp68_);
								_tmp70_ = _tmp69_;
								may_access_instance_members = _tmp70_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp71_;
								_tmp71_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp71_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaParameter* _tmp74_;
									ValaParameter* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaMemberBinding _tmp77_;
									ValaMemberBinding _tmp78_;
									_tmp72_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_this_parameter (_tmp73_);
									_tmp75_ = _tmp74_;
									this_parameter = _tmp75_;
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_binding (_tmp76_);
									_tmp78_ = _tmp77_;
									may_access_instance_members = _tmp78_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp79_;
									_tmp79_ = sym;
									if (VALA_IS_METHOD (_tmp79_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp80_;
										ValaMethod* _tmp81_;
										ValaParameter* _tmp82_;
										ValaParameter* _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										_tmp80_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_METHOD, ValaMethod);
										_tmp81_ = m;
										_tmp82_ = vala_method_get_this_parameter (_tmp81_);
										_tmp83_ = _tmp82_;
										this_parameter = _tmp83_;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_klass_members = _tmp89_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp90_ = sym;
				_tmp91_ = self->priv->_member_name;
				_tmp92_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp90_, _tmp91_);
				_tmp93_ = _tmp92_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp93_);
				_vala_code_node_unref0 (_tmp93_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp96_;
					ValaSymbol* _tmp97_;
					_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp97_ = _tmp96_;
					_tmp95_ = _tmp97_ == NULL;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaSymbol* _tmp98_;
					_tmp98_ = sym;
					_tmp94_ = VALA_IS_WITH_STATEMENT (_tmp98_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp99_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp100_;
					ValaLocalVariable* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaArrayList* _tmp111_;
					ValaDataType* _tmp112_;
					ValaDataType* _tmp113_;
					const gchar* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					_tmp99_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp100_ = w;
					_tmp101_ = vala_with_statement_get_with_variable (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_variable_get_variable_type ((ValaVariable*) _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = _vala_code_node_ref0 (_tmp104_);
					variable_type = _tmp105_;
					_tmp106_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp106_)) {
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						_tmp107_ = variable_type;
						_tmp108_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp109_ = _tmp108_;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp110_;
					}
					_tmp111_ = visited_types;
					_tmp112_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp111_, _tmp112_);
					_tmp113_ = variable_type;
					_tmp114_ = self->priv->_member_name;
					_tmp115_ = vala_data_type_get_member (_tmp113_, _tmp114_);
					_tmp116_ = _tmp115_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp116_);
					_vala_code_node_unref0 (_tmp116_);
					_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp118_ = _tmp117_;
					if (_tmp118_ != NULL) {
						ValaWithStatement* _tmp119_;
						ValaLocalVariable* _tmp120_;
						ValaLocalVariable* _tmp121_;
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						ValaSourceReference* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaMemberAccess* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaExpression* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						_tmp119_ = w;
						_tmp120_ = vala_with_statement_get_with_variable (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_member_access_new (NULL, _tmp123_, _tmp125_);
						_tmp127_ = _tmp126_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp127_);
						_vala_code_node_unref0 (_tmp127_);
						_tmp128_ = vala_member_access_get_inner (self);
						_tmp129_ = _tmp128_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					_tmp133_ = VALA_IS_TYPESYMBOL (_tmp136_);
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					_tmp132_ = may_access_instance_members;
				} else {
					_tmp132_ = FALSE;
				}
				if (_tmp132_) {
					ValaParameter* _tmp137_;
					ValaDataType* _tmp138_;
					ValaDataType* _tmp139_;
					const gchar* _tmp140_;
					ValaSymbol* _tmp141_;
					ValaSymbol* _tmp142_;
					gboolean _tmp143_ = FALSE;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					_tmp137_ = this_parameter;
					_tmp138_ = vala_variable_get_variable_type ((ValaVariable*) _tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = self->priv->_member_name;
					_tmp141_ = vala_data_type_get_member (_tmp139_, _tmp140_);
					_tmp142_ = _tmp141_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp142_);
					_vala_code_node_unref0 (_tmp142_);
					_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp145_ = _tmp144_;
					if (_tmp145_ != NULL) {
						ValaSymbol* _tmp146_;
						ValaSymbol* _tmp147_;
						_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp147_ = _tmp146_;
						_tmp143_ = vala_member_access_is_instance_symbol (_tmp147_);
					} else {
						_tmp143_ = FALSE;
					}
					if (_tmp143_) {
						ValaSourceReference* _tmp148_;
						ValaSourceReference* _tmp149_;
						ValaMemberAccess* _tmp150_;
						ValaMemberAccess* _tmp151_;
						ValaExpression* _tmp152_;
						ValaExpression* _tmp153_;
						ValaParameter* _tmp154_;
						ValaDataType* _tmp155_;
						ValaDataType* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaExpression* _tmp159_;
						ValaExpression* _tmp160_;
						ValaDataType* _tmp161_;
						ValaDataType* _tmp162_;
						ValaExpression* _tmp163_;
						ValaExpression* _tmp164_;
						ValaParameter* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaDataType* _tmp168_;
						ValaDataType* _tmp169_;
						const gchar* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp149_ = _tmp148_;
						_tmp150_ = vala_member_access_new (NULL, "this", _tmp149_);
						_tmp151_ = _tmp150_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp151_);
						_vala_code_node_unref0 (_tmp151_);
						_tmp152_ = vala_member_access_get_inner (self);
						_tmp153_ = _tmp152_;
						_tmp154_ = this_parameter;
						_tmp155_ = vala_variable_get_variable_type ((ValaVariable*) _tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_data_type_copy (_tmp156_);
						_tmp158_ = _tmp157_;
						vala_expression_set_value_type (_tmp153_, _tmp158_);
						_vala_code_node_unref0 (_tmp158_);
						_tmp159_ = vala_member_access_get_inner (self);
						_tmp160_ = _tmp159_;
						_tmp161_ = vala_expression_get_value_type (_tmp160_);
						_tmp162_ = _tmp161_;
						vala_data_type_set_value_owned (_tmp162_, FALSE);
						_tmp163_ = vala_member_access_get_inner (self);
						_tmp164_ = _tmp163_;
						_tmp165_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp164_, (ValaSymbol*) _tmp165_);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = vala_expression_get_value_type (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = self->priv->_member_name;
						_tmp171_ = vala_data_type_get_member (_tmp169_, _tmp170_);
						_tmp172_ = _tmp171_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp172_);
						_vala_code_node_unref0 (_tmp172_);
					}
				}
				_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				if (_tmp174_ == NULL) {
					ValaSymbol* _tmp175_;
					_tmp175_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp175_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp176_ = sym;
				_tmp177_ = vala_symbol_get_parent_symbol (_tmp176_);
				_tmp178_ = _tmp177_;
				sym = _tmp178_;
			}
			_tmp180_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp181_ = _tmp180_;
			if (_tmp181_ == NULL) {
				ValaSourceReference* _tmp182_;
				ValaSourceReference* _tmp183_;
				_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp183_ = _tmp182_;
				_tmp179_ = _tmp183_ != NULL;
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaList* _tmp186_;
					ValaList* _tmp187_;
					gint _ns_size = 0;
					ValaList* _tmp188_;
					gint _tmp189_;
					gint _tmp190_;
					gint _ns_index = 0;
					_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp185_ = _tmp184_;
					_tmp186_ = vala_source_reference_get_using_directives (_tmp185_);
					_tmp187_ = _tmp186_;
					_ns_list = _tmp187_;
					_tmp188_ = _ns_list;
					_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
					_tmp190_ = _tmp189_;
					_ns_size = _tmp190_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp191_;
						gint _tmp192_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp193_;
						gpointer _tmp194_;
						ValaUsingDirective* _tmp195_;
						gboolean _tmp196_;
						gboolean _tmp197_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp198_;
						ValaSymbol* _tmp199_;
						ValaSymbol* _tmp200_;
						ValaScope* _tmp201_;
						ValaScope* _tmp202_;
						const gchar* _tmp203_;
						ValaSymbol* _tmp204_;
						ValaSymbol* _tmp205_;
						_ns_index = _ns_index + 1;
						_tmp191_ = _ns_index;
						_tmp192_ = _ns_size;
						if (!(_tmp191_ < _tmp192_)) {
							break;
						}
						_tmp193_ = _ns_list;
						_tmp194_ = vala_list_get (_tmp193_, _ns_index);
						ns = (ValaUsingDirective*) _tmp194_;
						_tmp195_ = ns;
						_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
						_tmp197_ = _tmp196_;
						if (_tmp197_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp198_ = ns;
						_tmp199_ = vala_using_directive_get_namespace_symbol (_tmp198_);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_symbol_get_scope (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = self->priv->_member_name;
						_tmp204_ = vala_scope_lookup (_tmp202_, _tmp203_);
						local_sym = _tmp204_;
						_tmp205_ = local_sym;
						if (_tmp205_ != NULL) {
							gboolean _tmp206_ = FALSE;
							ValaSymbol* _tmp207_;
							ValaSymbol* _tmp208_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp222_;
							ValaSymbol* _tmp223_;
							ValaSymbol* _tmp224_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp244_;
							ValaExpression* _tmp245_;
							ValaExpression* _tmp246_;
							ValaSymbol* _tmp247_;
							_tmp207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp208_ = _tmp207_;
							if (_tmp208_ != NULL) {
								ValaSymbol* _tmp209_;
								ValaSymbol* _tmp210_;
								ValaSymbol* _tmp211_;
								_tmp209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp210_ = _tmp209_;
								_tmp211_ = local_sym;
								_tmp206_ = _tmp210_ != _tmp211_;
							} else {
								_tmp206_ = FALSE;
							}
							if (_tmp206_) {
								ValaSourceReference* _tmp212_;
								ValaSourceReference* _tmp213_;
								const gchar* _tmp214_;
								ValaSymbol* _tmp215_;
								ValaSymbol* _tmp216_;
								gchar* _tmp217_;
								gchar* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = self->priv->_member_name;
								_tmp215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = vala_symbol_get_full_name (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp219_ = local_sym;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								vala_report_error (_tmp213_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp214_, _tmp218_, _tmp221_);
								_g_free0 (_tmp221_);
								_g_free0 (_tmp218_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp222_ = local_sym;
							_tmp223_ = vala_symbol_get_parent_symbol (_tmp222_);
							_tmp224_ = _tmp223_;
							inner_sym = _tmp224_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp225_ = FALSE;
								ValaSymbol* _tmp226_;
								ValaMemberAccess* _tmp230_;
								ValaSymbol* _tmp231_;
								const gchar* _tmp232_;
								const gchar* _tmp233_;
								ValaSourceReference* _tmp234_;
								ValaSourceReference* _tmp235_;
								ValaMemberAccess* _tmp236_;
								ValaMemberAccess* _tmp237_;
								ValaMemberAccess* _tmp238_;
								ValaExpression* _tmp239_;
								ValaExpression* _tmp240_;
								ValaSymbol* _tmp241_;
								ValaSymbol* _tmp242_;
								ValaSymbol* _tmp243_;
								_tmp226_ = inner_sym;
								if (_tmp226_ != NULL) {
									ValaSymbol* _tmp227_;
									const gchar* _tmp228_;
									const gchar* _tmp229_;
									_tmp227_ = inner_sym;
									_tmp228_ = vala_symbol_get_name (_tmp227_);
									_tmp229_ = _tmp228_;
									_tmp225_ = _tmp229_ != NULL;
								} else {
									_tmp225_ = FALSE;
								}
								if (!_tmp225_) {
									break;
								}
								_tmp230_ = inner_ma;
								_tmp231_ = inner_sym;
								_tmp232_ = vala_symbol_get_name (_tmp231_);
								_tmp233_ = _tmp232_;
								_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp235_ = _tmp234_;
								_tmp236_ = vala_member_access_new (NULL, _tmp233_, _tmp235_);
								_tmp237_ = _tmp236_;
								vala_member_access_set_inner (_tmp230_, (ValaExpression*) _tmp237_);
								_vala_code_node_unref0 (_tmp237_);
								_tmp238_ = inner_ma;
								_tmp239_ = vala_member_access_get_inner (_tmp238_);
								_tmp240_ = _tmp239_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp240_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp241_ = inner_sym;
								_tmp242_ = vala_symbol_get_parent_symbol (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_sym = _tmp243_;
							}
							_tmp244_ = inner_ma;
							vala_member_access_set_qualified (_tmp244_, TRUE);
							_tmp245_ = vala_member_access_get_inner (self);
							_tmp246_ = _tmp245_;
							vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
							_tmp247_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp247_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp250_;
			gboolean _tmp251_;
			ValaExpression* _tmp252_;
			ValaExpression* _tmp253_;
			ValaDataType* _tmp254_;
			ValaDataType* _tmp255_;
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			gboolean _tmp300_ = FALSE;
			ValaExpression* _tmp301_;
			ValaExpression* _tmp302_;
			gboolean _tmp309_ = FALSE;
			ValaExpression* _tmp310_;
			ValaExpression* _tmp311_;
			gboolean _tmp332_ = FALSE;
			ValaExpression* _tmp333_;
			ValaExpression* _tmp334_;
			gboolean _tmp353_ = FALSE;
			ValaSymbol* _tmp354_;
			ValaSymbol* _tmp355_;
			gboolean _tmp389_ = FALSE;
			gboolean _tmp390_ = FALSE;
			ValaSymbol* _tmp391_;
			ValaSymbol* _tmp392_;
			ValaSymbol* _tmp625_;
			ValaSymbol* _tmp626_;
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_code_node_get_error ((ValaCodeNode*) _tmp249_);
			_tmp251_ = _tmp250_;
			if (_tmp251_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp252_ = vala_member_access_get_inner (self);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_expression_get_value_type (_tmp253_);
			_tmp255_ = _tmp254_;
			if (VALA_IS_POINTER_TYPE (_tmp255_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaPointerType* _tmp261_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp259_) ? ((ValaPointerType*) _tmp259_) : NULL;
				_tmp261_ = pointer_type;
				if (_tmp261_ != NULL) {
					ValaPointerType* _tmp262_;
					ValaDataType* _tmp263_;
					ValaDataType* _tmp264_;
					_tmp262_ = pointer_type;
					_tmp263_ = vala_pointer_type_get_base_type (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp260_ = VALA_IS_VALUE_TYPE (_tmp264_);
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaExpression* _tmp265_;
					ValaExpression* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					ValaExpression* _tmp278_;
					ValaExpression* _tmp279_;
					ValaSourceReference* _tmp280_;
					ValaSourceReference* _tmp281_;
					ValaPointerIndirection* _tmp282_;
					ValaPointerIndirection* _tmp283_;
					ValaExpression* _tmp284_;
					ValaExpression* _tmp285_;
					_tmp265_ = vala_member_access_get_inner (self);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_expression_get_formal_value_type (_tmp266_);
					_tmp268_ = _tmp267_;
					if (VALA_IS_GENERIC_TYPE (_tmp268_)) {
						ValaExpression* _tmp269_;
						ValaExpression* _tmp270_;
						ValaPointerType* _tmp271_;
						ValaDataType* _tmp272_;
						ValaDataType* _tmp273_;
						ValaSourceReference* _tmp274_;
						ValaSourceReference* _tmp275_;
						ValaCastExpression* _tmp276_;
						ValaCastExpression* _tmp277_;
						_tmp269_ = vala_member_access_get_inner (self);
						_tmp270_ = _tmp269_;
						_tmp271_ = pointer_type;
						_tmp272_ = vala_data_type_copy ((ValaDataType*) _tmp271_);
						_tmp273_ = _tmp272_;
						_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_cast_expression_new (_tmp270_, _tmp273_, _tmp275_);
						_tmp277_ = _tmp276_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp277_);
						_vala_code_node_unref0 (_tmp277_);
						_vala_code_node_unref0 (_tmp273_);
					}
					_tmp278_ = vala_member_access_get_inner (self);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp281_ = _tmp280_;
					_tmp282_ = vala_pointer_indirection_new (_tmp279_, _tmp281_);
					_tmp283_ = _tmp282_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp283_);
					_vala_code_node_unref0 (_tmp283_);
					_tmp284_ = vala_member_access_get_inner (self);
					_tmp285_ = _tmp284_;
					vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp286_ = vala_member_access_get_inner (self);
			_tmp287_ = _tmp286_;
			if (VALA_IS_MEMBER_ACCESS (_tmp287_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaMemberAccess* _tmp290_;
				gboolean _tmp291_;
				_tmp288_ = vala_member_access_get_inner (self);
				_tmp289_ = _tmp288_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp290_ = ma;
				_tmp291_ = _tmp290_->priv->_prototype_access;
				if (_tmp291_) {
					ValaSourceReference* _tmp292_;
					ValaSourceReference* _tmp293_;
					ValaExpression* _tmp294_;
					ValaExpression* _tmp295_;
					ValaSymbol* _tmp296_;
					ValaSymbol* _tmp297_;
					gchar* _tmp298_;
					gchar* _tmp299_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_member_access_get_inner (self);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_expression_get_symbol_reference (_tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = vala_symbol_get_full_name (_tmp297_);
					_tmp299_ = _tmp298_;
					vala_report_error (_tmp293_, "Access to instance member `%s' denied", _tmp299_);
					_g_free0 (_tmp299_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp301_ = vala_member_access_get_inner (self);
			_tmp302_ = _tmp301_;
			if (VALA_IS_CAST_EXPRESSION (_tmp302_)) {
				ValaExpression* _tmp303_;
				ValaExpression* _tmp304_;
				gboolean _tmp305_;
				gboolean _tmp306_;
				_tmp303_ = vala_member_access_get_inner (self);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp304_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp306_ = _tmp305_;
				_tmp300_ = _tmp306_;
			} else {
				_tmp300_ = FALSE;
			}
			if (_tmp300_) {
				ValaSourceReference* _tmp307_;
				ValaSourceReference* _tmp308_;
				_tmp307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp308_ = _tmp307_;
				vala_report_warning (_tmp308_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp310_ = vala_member_access_get_inner (self);
			_tmp311_ = _tmp310_;
			if (VALA_IS_MEMBER_ACCESS (_tmp311_)) {
				_tmp309_ = TRUE;
			} else {
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp309_ = VALA_IS_BASE_ACCESS (_tmp313_);
			}
			if (_tmp309_) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaSymbol* _tmp316_;
				ValaSymbol* _tmp317_;
				gboolean _tmp318_ = FALSE;
				ValaSymbol* _tmp319_;
				ValaSymbol* _tmp320_;
				_tmp314_ = vala_member_access_get_inner (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_expression_get_symbol_reference (_tmp315_);
				_tmp317_ = _tmp316_;
				base_symbol = _tmp317_;
				_tmp319_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp320_ = _tmp319_;
				if (_tmp320_ == NULL) {
					gboolean _tmp321_ = FALSE;
					ValaSymbol* _tmp322_;
					_tmp322_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp322_)) {
						_tmp321_ = TRUE;
					} else {
						ValaSymbol* _tmp323_;
						_tmp323_ = base_symbol;
						_tmp321_ = VALA_IS_TYPESYMBOL (_tmp323_);
					}
					_tmp318_ = _tmp321_;
				} else {
					_tmp318_ = FALSE;
				}
				if (_tmp318_) {
					ValaSymbol* _tmp324_;
					ValaScope* _tmp325_;
					ValaScope* _tmp326_;
					const gchar* _tmp327_;
					ValaSymbol* _tmp328_;
					ValaSymbol* _tmp329_;
					ValaExpression* _tmp330_;
					ValaExpression* _tmp331_;
					_tmp324_ = base_symbol;
					_tmp325_ = vala_symbol_get_scope (_tmp324_);
					_tmp326_ = _tmp325_;
					_tmp327_ = self->priv->_member_name;
					_tmp328_ = vala_scope_lookup (_tmp326_, _tmp327_);
					_tmp329_ = _tmp328_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp329_);
					_vala_code_node_unref0 (_tmp329_);
					_tmp330_ = vala_member_access_get_inner (self);
					_tmp331_ = _tmp330_;
					if (VALA_IS_BASE_ACCESS (_tmp331_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp333_ = vala_member_access_get_inner (self);
			_tmp334_ = _tmp333_;
			if (VALA_IS_MEMBER_ACCESS (_tmp334_)) {
				ValaExpression* _tmp335_;
				ValaExpression* _tmp336_;
				ValaSymbol* _tmp337_;
				ValaSymbol* _tmp338_;
				_tmp335_ = vala_member_access_get_inner (self);
				_tmp336_ = _tmp335_;
				_tmp337_ = vala_expression_get_symbol_reference (_tmp336_);
				_tmp338_ = _tmp337_;
				_tmp332_ = VALA_IS_TYPEPARAMETER (_tmp338_);
			} else {
				_tmp332_ = FALSE;
			}
			if (_tmp332_) {
				ValaExpression* _tmp339_;
				ValaExpression* _tmp340_;
				ValaExpression* _tmp341_;
				ValaExpression* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaSymbol* _tmp344_;
				ValaGenericType* _tmp345_;
				ValaGenericType* _tmp346_;
				ValaExpression* _tmp347_;
				ValaExpression* _tmp348_;
				ValaDataType* _tmp349_;
				ValaDataType* _tmp350_;
				ValaSourceReference* _tmp351_;
				ValaSourceReference* _tmp352_;
				_tmp339_ = vala_member_access_get_inner (self);
				_tmp340_ = _tmp339_;
				_tmp341_ = vala_member_access_get_inner (self);
				_tmp342_ = _tmp341_;
				_tmp343_ = vala_expression_get_symbol_reference (_tmp342_);
				_tmp344_ = _tmp343_;
				_tmp345_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp344_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp346_ = _tmp345_;
				vala_expression_set_value_type (_tmp340_, (ValaDataType*) _tmp346_);
				_vala_code_node_unref0 (_tmp346_);
				_tmp347_ = vala_member_access_get_inner (self);
				_tmp348_ = _tmp347_;
				_tmp349_ = vala_expression_get_value_type (_tmp348_);
				_tmp350_ = _tmp349_;
				_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp352_ = _tmp351_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp350_, _tmp352_);
			}
			_tmp354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp355_ = _tmp354_;
			if (_tmp355_ == NULL) {
				ValaExpression* _tmp356_;
				ValaExpression* _tmp357_;
				ValaDataType* _tmp358_;
				ValaDataType* _tmp359_;
				_tmp356_ = vala_member_access_get_inner (self);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_expression_get_value_type (_tmp357_);
				_tmp359_ = _tmp358_;
				_tmp353_ = _tmp359_ != NULL;
			} else {
				_tmp353_ = FALSE;
			}
			if (_tmp353_) {
				gboolean _tmp360_;
				ValaSymbol* _tmp387_;
				ValaSymbol* _tmp388_;
				_tmp360_ = self->priv->_pointer_member_access;
				if (_tmp360_) {
					ValaExpression* _tmp361_;
					ValaExpression* _tmp362_;
					ValaDataType* _tmp363_;
					ValaDataType* _tmp364_;
					const gchar* _tmp365_;
					ValaSymbol* _tmp366_;
					ValaSymbol* _tmp367_;
					_tmp361_ = vala_member_access_get_inner (self);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_expression_get_value_type (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = self->priv->_member_name;
					_tmp366_ = vala_data_type_get_pointer_member (_tmp364_, _tmp365_);
					_tmp367_ = _tmp366_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp367_);
					_vala_code_node_unref0 (_tmp367_);
				} else {
					ValaExpression* _tmp368_;
					ValaExpression* _tmp369_;
					ValaDataType* _tmp370_;
					ValaDataType* _tmp371_;
					ValaTypeSymbol* _tmp372_;
					ValaTypeSymbol* _tmp373_;
					ValaExpression* _tmp380_;
					ValaExpression* _tmp381_;
					ValaDataType* _tmp382_;
					ValaDataType* _tmp383_;
					const gchar* _tmp384_;
					ValaSymbol* _tmp385_;
					ValaSymbol* _tmp386_;
					_tmp368_ = vala_member_access_get_inner (self);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_expression_get_value_type (_tmp369_);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_data_type_get_type_symbol (_tmp371_);
					_tmp373_ = _tmp372_;
					if (_tmp373_ != NULL) {
						ValaExpression* _tmp374_;
						ValaExpression* _tmp375_;
						ValaDataType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaTypeSymbol* _tmp378_;
						ValaTypeSymbol* _tmp379_;
						_tmp374_ = vala_member_access_get_inner (self);
						_tmp375_ = _tmp374_;
						_tmp376_ = vala_expression_get_value_type (_tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_data_type_get_type_symbol (_tmp377_);
						_tmp379_ = _tmp378_;
						base_symbol = (ValaSymbol*) _tmp379_;
					}
					_tmp380_ = vala_member_access_get_inner (self);
					_tmp381_ = _tmp380_;
					_tmp382_ = vala_expression_get_value_type (_tmp381_);
					_tmp383_ = _tmp382_;
					_tmp384_ = self->priv->_member_name;
					_tmp385_ = vala_data_type_get_member (_tmp383_, _tmp384_);
					_tmp386_ = _tmp385_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp386_);
					_vala_code_node_unref0 (_tmp386_);
				}
				_tmp387_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp388_ = _tmp387_;
				if (_tmp388_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp391_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp392_ = _tmp391_;
			if (_tmp392_ == NULL) {
				ValaExpression* _tmp393_;
				ValaExpression* _tmp394_;
				ValaDataType* _tmp395_;
				ValaDataType* _tmp396_;
				_tmp393_ = vala_member_access_get_inner (self);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_expression_get_value_type (_tmp394_);
				_tmp396_ = _tmp395_;
				_tmp390_ = _tmp396_ != NULL;
			} else {
				_tmp390_ = FALSE;
			}
			if (_tmp390_) {
				ValaExpression* _tmp397_;
				ValaExpression* _tmp398_;
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				gboolean _tmp401_;
				gboolean _tmp402_;
				_tmp397_ = vala_member_access_get_inner (self);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_expression_get_value_type (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_data_type_get_is_dynamic (_tmp400_);
				_tmp402_ = _tmp401_;
				_tmp389_ = _tmp402_;
			} else {
				_tmp389_ = FALSE;
			}
			if (_tmp389_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp403_;
				ValaExpression* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				ValaObjectType* _tmp407_;
				ValaCodeNode* _tmp408_;
				ValaCodeNode* _tmp409_;
				ValaSymbol* _tmp573_;
				ValaSymbol* _tmp574_;
				ValaSymbol* _tmp623_;
				ValaSymbol* _tmp624_;
				_tmp403_ = vala_member_access_get_inner (self);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_expression_get_value_type (_tmp404_);
				_tmp406_ = _tmp405_;
				_tmp407_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp406_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp407_;
				_tmp408_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp409_ = _tmp408_;
				if (VALA_IS_METHOD_CALL (_tmp409_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp410_;
					ValaCodeNode* _tmp411_;
					ValaMethodCall* _tmp412_;
					ValaExpression* _tmp413_;
					ValaExpression* _tmp414_;
					_tmp410_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp411_ = _tmp410_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp412_ = invoc;
					_tmp413_ = vala_method_call_get_call (_tmp412_);
					_tmp414_ = _tmp413_;
					if (_tmp414_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp415_;
						ValaDataType* _tmp416_;
						ValaDataType* _tmp417_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp432_;
						ValaExpression* _tmp433_;
						ValaDataType* _tmp434_;
						ValaDataType* _tmp435_;
						const gchar* _tmp436_;
						ValaDataType* _tmp437_;
						ValaSourceReference* _tmp438_;
						ValaSourceReference* _tmp439_;
						ValaDynamicMethod* _tmp440_;
						ValaDynamicMethod* _tmp441_;
						ValaMethodCall* _tmp442_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp443_;
						ValaErrorType* _tmp444_;
						ValaDynamicMethod* _tmp445_;
						ValaErrorType* _tmp446_;
						ValaDynamicMethod* _tmp447_;
						ValaDynamicMethod* _tmp448_;
						ValaParameter* _tmp449_;
						ValaParameter* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaObjectType* _tmp452_;
						ValaDataType* _tmp453_;
						ValaDataType* _tmp454_;
						ValaDynamicMethod* _tmp455_;
						ValaSourceReference* _tmp456_;
						ValaSourceReference* _tmp457_;
						ValaParameter* _tmp458_;
						ValaParameter* _tmp459_;
						ValaObjectType* _tmp460_;
						ValaTypeSymbol* _tmp461_;
						ValaTypeSymbol* _tmp462_;
						ValaScope* _tmp463_;
						ValaScope* _tmp464_;
						ValaDynamicMethod* _tmp465_;
						ValaDynamicMethod* _tmp466_;
						_tmp415_ = invoc;
						_tmp416_ = vala_expression_get_target_type ((ValaExpression*) _tmp415_);
						_tmp417_ = _tmp416_;
						if (_tmp417_ != NULL) {
							ValaMethodCall* _tmp418_;
							ValaDataType* _tmp419_;
							ValaDataType* _tmp420_;
							ValaDataType* _tmp421_;
							ValaDataType* _tmp422_;
							_tmp418_ = invoc;
							_tmp419_ = vala_expression_get_target_type ((ValaExpression*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = vala_data_type_copy (_tmp420_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp421_;
							_tmp422_ = ret_type;
							vala_data_type_set_value_owned (_tmp422_, TRUE);
						} else {
							ValaMethodCall* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaCodeNode* _tmp425_;
							_tmp423_ = invoc;
							_tmp424_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp423_);
							_tmp425_ = _tmp424_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp425_)) {
								ValaVoidType* _tmp426_;
								_tmp426_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp426_;
							} else {
								ValaExpression* _tmp427_;
								ValaExpression* _tmp428_;
								ValaDataType* _tmp429_;
								ValaDataType* _tmp430_;
								ValaDataType* _tmp431_;
								_tmp427_ = vala_member_access_get_inner (self);
								_tmp428_ = _tmp427_;
								_tmp429_ = vala_expression_get_value_type (_tmp428_);
								_tmp430_ = _tmp429_;
								_tmp431_ = vala_data_type_copy (_tmp430_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp431_;
							}
						}
						_tmp432_ = vala_member_access_get_inner (self);
						_tmp433_ = _tmp432_;
						_tmp434_ = vala_expression_get_value_type (_tmp433_);
						_tmp435_ = _tmp434_;
						_tmp436_ = self->priv->_member_name;
						_tmp437_ = ret_type;
						_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp439_ = _tmp438_;
						_tmp440_ = vala_dynamic_method_new (_tmp435_, _tmp436_, _tmp437_, _tmp439_, NULL);
						m = _tmp440_;
						_tmp441_ = m;
						_tmp442_ = invoc;
						vala_dynamic_method_set_invocation (_tmp441_, _tmp442_);
						_tmp443_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp443_;
						_tmp444_ = err;
						vala_error_type_set_dynamic_error (_tmp444_, TRUE);
						_tmp445_ = m;
						_tmp446_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp445_, (ValaDataType*) _tmp446_);
						_tmp447_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp447_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp448_ = m;
						_tmp449_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp450_ = _tmp449_;
						vala_callable_add_parameter ((ValaCallable*) _tmp448_, _tmp450_);
						_vala_code_node_unref0 (_tmp450_);
						_tmp451_ = m;
						_tmp452_ = dynamic_object_type;
						_tmp453_ = vala_data_type_copy ((ValaDataType*) _tmp452_);
						_tmp454_ = _tmp453_;
						_tmp455_ = m;
						_tmp456_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp455_);
						_tmp457_ = _tmp456_;
						_tmp458_ = vala_parameter_new ("this", _tmp454_, _tmp457_);
						_tmp459_ = _tmp458_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp451_, _tmp459_);
						_vala_code_node_unref0 (_tmp459_);
						_vala_code_node_unref0 (_tmp454_);
						_tmp460_ = dynamic_object_type;
						_tmp461_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp460_);
						_tmp462_ = _tmp461_;
						_tmp463_ = vala_symbol_get_scope ((ValaSymbol*) _tmp462_);
						_tmp464_ = _tmp463_;
						_tmp465_ = m;
						vala_scope_add (_tmp464_, NULL, (ValaSymbol*) _tmp465_);
						_tmp466_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp466_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp467_;
					ValaCodeNode* _tmp468_;
					_tmp467_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp468_ = _tmp467_;
					if (VALA_IS_ASSIGNMENT (_tmp468_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp469_;
						ValaCodeNode* _tmp470_;
						ValaAssignment* _tmp471_;
						ValaExpression* _tmp472_;
						ValaExpression* _tmp473_;
						_tmp469_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp470_ = _tmp469_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp470_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp471_ = a;
						_tmp472_ = vala_assignment_get_left (_tmp471_);
						_tmp473_ = _tmp472_;
						if (_tmp473_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp474_;
							ValaExpression* _tmp475_;
							ValaDataType* _tmp476_;
							ValaDataType* _tmp477_;
							const gchar* _tmp478_;
							ValaSourceReference* _tmp479_;
							ValaSourceReference* _tmp480_;
							ValaDynamicProperty* _tmp481_;
							ValaDynamicProperty* _tmp482_;
							ValaDynamicProperty* _tmp483_;
							ValaDynamicProperty* _tmp484_;
							ValaSourceReference* _tmp485_;
							ValaSourceReference* _tmp486_;
							ValaPropertyAccessor* _tmp487_;
							ValaPropertyAccessor* _tmp488_;
							ValaDynamicProperty* _tmp489_;
							ValaExpression* _tmp490_;
							ValaExpression* _tmp491_;
							ValaDataType* _tmp492_;
							ValaDataType* _tmp493_;
							ValaTypeSymbol* _tmp494_;
							ValaTypeSymbol* _tmp495_;
							ValaScope* _tmp496_;
							ValaScope* _tmp497_;
							ValaObjectType* _tmp498_;
							ValaTypeSymbol* _tmp499_;
							ValaTypeSymbol* _tmp500_;
							ValaScope* _tmp501_;
							ValaScope* _tmp502_;
							ValaDynamicProperty* _tmp503_;
							ValaDynamicProperty* _tmp504_;
							_tmp474_ = vala_member_access_get_inner (self);
							_tmp475_ = _tmp474_;
							_tmp476_ = vala_expression_get_value_type (_tmp475_);
							_tmp477_ = _tmp476_;
							_tmp478_ = self->priv->_member_name;
							_tmp479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp480_ = _tmp479_;
							_tmp481_ = vala_dynamic_property_new (_tmp477_, _tmp478_, _tmp480_, NULL);
							prop = _tmp481_;
							_tmp482_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp482_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp483_ = prop;
							_tmp484_ = prop;
							_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp484_);
							_tmp486_ = _tmp485_;
							_tmp487_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp486_, NULL);
							_tmp488_ = _tmp487_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp483_, _tmp488_);
							_vala_code_node_unref0 (_tmp488_);
							_tmp489_ = prop;
							_tmp490_ = vala_member_access_get_inner (self);
							_tmp491_ = _tmp490_;
							_tmp492_ = vala_expression_get_value_type (_tmp491_);
							_tmp493_ = _tmp492_;
							_tmp494_ = vala_data_type_get_type_symbol (_tmp493_);
							_tmp495_ = _tmp494_;
							_tmp496_ = vala_symbol_get_scope ((ValaSymbol*) _tmp495_);
							_tmp497_ = _tmp496_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp489_, _tmp497_);
							_tmp498_ = dynamic_object_type;
							_tmp499_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp498_);
							_tmp500_ = _tmp499_;
							_tmp501_ = vala_symbol_get_scope ((ValaSymbol*) _tmp500_);
							_tmp502_ = _tmp501_;
							_tmp503_ = prop;
							vala_scope_add (_tmp502_, NULL, (ValaSymbol*) _tmp503_);
							_tmp504_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp504_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp505_ = FALSE;
						gboolean _tmp506_ = FALSE;
						ValaCodeNode* _tmp507_;
						ValaCodeNode* _tmp508_;
						_tmp507_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp508_ = _tmp507_;
						if (VALA_IS_MEMBER_ACCESS (_tmp508_)) {
							ValaExpression* _tmp509_;
							ValaExpression* _tmp510_;
							_tmp509_ = vala_member_access_get_inner (self);
							_tmp510_ = _tmp509_;
							_tmp506_ = VALA_IS_MEMBER_ACCESS (_tmp510_);
						} else {
							_tmp506_ = FALSE;
						}
						if (_tmp506_) {
							ValaCodeNode* _tmp511_;
							ValaCodeNode* _tmp512_;
							ValaCodeNode* _tmp513_;
							ValaCodeNode* _tmp514_;
							_tmp511_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp512_ = _tmp511_;
							_tmp513_ = vala_code_node_get_parent_node (_tmp512_);
							_tmp514_ = _tmp513_;
							_tmp505_ = VALA_IS_METHOD_CALL (_tmp514_);
						} else {
							_tmp505_ = FALSE;
						}
						if (_tmp505_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp515_;
							ValaCodeNode* _tmp516_;
							gboolean _tmp517_ = FALSE;
							ValaMemberAccess* _tmp518_;
							const gchar* _tmp519_;
							_tmp515_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp516_ = _tmp515_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp516_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp518_ = ma;
							_tmp519_ = _tmp518_->priv->_member_name;
							if (g_strcmp0 (_tmp519_, "connect") == 0) {
								_tmp517_ = TRUE;
							} else {
								ValaMemberAccess* _tmp520_;
								const gchar* _tmp521_;
								_tmp520_ = ma;
								_tmp521_ = _tmp520_->priv->_member_name;
								_tmp517_ = g_strcmp0 (_tmp521_, "connect_after") == 0;
							}
							if (_tmp517_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp522_;
								ValaExpression* _tmp523_;
								ValaDataType* _tmp524_;
								ValaDataType* _tmp525_;
								const gchar* _tmp526_;
								ValaVoidType* _tmp527_;
								ValaVoidType* _tmp528_;
								ValaSourceReference* _tmp529_;
								ValaSourceReference* _tmp530_;
								ValaDynamicSignal* _tmp531_;
								ValaDynamicSignal* _tmp532_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp533_;
								ValaCodeNode* _tmp534_;
								ValaCodeNode* _tmp535_;
								ValaCodeNode* _tmp536_;
								ValaMethodCall* _tmp537_;
								ValaMethodCall* _tmp538_;
								ValaList* _tmp539_;
								gint _tmp540_;
								gint _tmp541_;
								ValaDynamicSignal* _tmp565_;
								ValaObjectType* _tmp566_;
								ValaTypeSymbol* _tmp567_;
								ValaTypeSymbol* _tmp568_;
								ValaScope* _tmp569_;
								ValaScope* _tmp570_;
								ValaDynamicSignal* _tmp571_;
								ValaDynamicSignal* _tmp572_;
								_tmp522_ = vala_member_access_get_inner (self);
								_tmp523_ = _tmp522_;
								_tmp524_ = vala_expression_get_value_type (_tmp523_);
								_tmp525_ = _tmp524_;
								_tmp526_ = self->priv->_member_name;
								_tmp527_ = vala_void_type_new (NULL);
								_tmp528_ = _tmp527_;
								_tmp529_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp530_ = _tmp529_;
								_tmp531_ = vala_dynamic_signal_new (_tmp525_, _tmp526_, (ValaDataType*) _tmp528_, _tmp530_, NULL);
								_tmp532_ = _tmp531_;
								_vala_code_node_unref0 (_tmp528_);
								s = _tmp532_;
								_tmp533_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp534_ = _tmp533_;
								_tmp535_ = vala_code_node_get_parent_node (_tmp534_);
								_tmp536_ = _tmp535_;
								_tmp537_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp536_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp537_;
								_tmp538_ = mcall;
								_tmp539_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp538_);
								_tmp540_ = vala_collection_get_size ((ValaCollection*) _tmp539_);
								_tmp541_ = _tmp540_;
								if (_tmp541_ > 0) {
									ValaDynamicSignal* _tmp542_;
									ValaMethodCall* _tmp543_;
									ValaList* _tmp544_;
									gpointer _tmp545_;
									ValaExpression* _tmp546_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp547_;
									ValaExpression* _tmp548_;
									ValaExpression* _tmp549_;
									gboolean _tmp550_ = FALSE;
									gboolean _tmp551_ = FALSE;
									ValaMemberAccess* _tmp552_;
									_tmp542_ = s;
									_tmp543_ = mcall;
									_tmp544_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp543_);
									_tmp545_ = vala_list_get (_tmp544_, 0);
									_tmp546_ = (ValaExpression*) _tmp545_;
									vala_dynamic_signal_set_handler (_tmp542_, _tmp546_);
									_vala_code_node_unref0 (_tmp546_);
									_tmp547_ = s;
									_tmp548_ = vala_dynamic_signal_get_handler (_tmp547_);
									_tmp549_ = _tmp548_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp549_) ? ((ValaMemberAccess*) _tmp549_) : NULL;
									_tmp552_ = arg;
									if (_tmp552_ == NULL) {
										_tmp551_ = TRUE;
									} else {
										ValaMemberAccess* _tmp553_;
										_tmp553_ = arg;
										_tmp551_ = !vala_code_node_check ((ValaCodeNode*) _tmp553_, context);
									}
									if (_tmp551_) {
										_tmp550_ = TRUE;
									} else {
										ValaMemberAccess* _tmp554_;
										ValaSymbol* _tmp555_;
										ValaSymbol* _tmp556_;
										_tmp554_ = arg;
										_tmp555_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp554_);
										_tmp556_ = _tmp555_;
										_tmp550_ = !VALA_IS_METHOD (_tmp556_);
									}
									if (_tmp550_) {
										ValaDynamicSignal* _tmp557_;
										ValaExpression* _tmp558_;
										ValaExpression* _tmp559_;
										ValaSourceReference* _tmp560_;
										ValaSourceReference* _tmp561_;
										ValaDynamicSignal* _tmp562_;
										gchar* _tmp563_;
										gchar* _tmp564_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp557_ = s;
										_tmp558_ = vala_dynamic_signal_get_handler (_tmp557_);
										_tmp559_ = _tmp558_;
										_tmp560_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp559_);
										_tmp561_ = _tmp560_;
										_tmp562_ = s;
										_tmp563_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp562_);
										_tmp564_ = _tmp563_;
										vala_report_error (_tmp561_, "Invalid handler for `%s'", _tmp564_);
										_g_free0 (_tmp564_);
									}
								}
								_tmp565_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp565_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp566_ = dynamic_object_type;
								_tmp567_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp566_);
								_tmp568_ = _tmp567_;
								_tmp569_ = vala_symbol_get_scope ((ValaSymbol*) _tmp568_);
								_tmp570_ = _tmp569_;
								_tmp571_ = s;
								vala_scope_add (_tmp570_, NULL, (ValaSymbol*) _tmp571_);
								_tmp572_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp572_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp573_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp574_ = _tmp573_;
				if (_tmp574_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp575_;
					ValaExpression* _tmp576_;
					ValaDataType* _tmp577_;
					ValaDataType* _tmp578_;
					const gchar* _tmp579_;
					ValaSourceReference* _tmp580_;
					ValaSourceReference* _tmp581_;
					ValaDynamicProperty* _tmp582_;
					ValaDataType* _tmp583_;
					ValaDataType* _tmp584_;
					ValaDynamicProperty* _tmp595_;
					ValaDynamicProperty* _tmp596_;
					ValaDynamicProperty* _tmp597_;
					ValaDataType* _tmp598_;
					ValaDataType* _tmp599_;
					ValaDataType* _tmp600_;
					ValaDataType* _tmp601_;
					ValaDynamicProperty* _tmp602_;
					ValaSourceReference* _tmp603_;
					ValaSourceReference* _tmp604_;
					ValaPropertyAccessor* _tmp605_;
					ValaPropertyAccessor* _tmp606_;
					ValaDynamicProperty* _tmp607_;
					ValaExpression* _tmp608_;
					ValaExpression* _tmp609_;
					ValaDataType* _tmp610_;
					ValaDataType* _tmp611_;
					ValaTypeSymbol* _tmp612_;
					ValaTypeSymbol* _tmp613_;
					ValaScope* _tmp614_;
					ValaScope* _tmp615_;
					ValaObjectType* _tmp616_;
					ValaTypeSymbol* _tmp617_;
					ValaTypeSymbol* _tmp618_;
					ValaScope* _tmp619_;
					ValaScope* _tmp620_;
					ValaDynamicProperty* _tmp621_;
					ValaDynamicProperty* _tmp622_;
					_tmp575_ = vala_member_access_get_inner (self);
					_tmp576_ = _tmp575_;
					_tmp577_ = vala_expression_get_value_type (_tmp576_);
					_tmp578_ = _tmp577_;
					_tmp579_ = self->priv->_member_name;
					_tmp580_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp581_ = _tmp580_;
					_tmp582_ = vala_dynamic_property_new (_tmp578_, _tmp579_, _tmp581_, NULL);
					prop = _tmp582_;
					_tmp583_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp584_ = _tmp583_;
					if (_tmp584_ != NULL) {
						ValaDynamicProperty* _tmp585_;
						ValaDataType* _tmp586_;
						ValaDataType* _tmp587_;
						_tmp585_ = prop;
						_tmp586_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp587_ = _tmp586_;
						vala_property_set_property_type ((ValaProperty*) _tmp585_, _tmp587_);
					} else {
						ValaDynamicProperty* _tmp588_;
						ValaExpression* _tmp589_;
						ValaExpression* _tmp590_;
						ValaDataType* _tmp591_;
						ValaDataType* _tmp592_;
						ValaDataType* _tmp593_;
						ValaDataType* _tmp594_;
						_tmp588_ = prop;
						_tmp589_ = vala_member_access_get_inner (self);
						_tmp590_ = _tmp589_;
						_tmp591_ = vala_expression_get_value_type (_tmp590_);
						_tmp592_ = _tmp591_;
						_tmp593_ = vala_data_type_copy (_tmp592_);
						_tmp594_ = _tmp593_;
						vala_property_set_property_type ((ValaProperty*) _tmp588_, _tmp594_);
						_vala_code_node_unref0 (_tmp594_);
					}
					_tmp595_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp595_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp596_ = prop;
					_tmp597_ = prop;
					_tmp598_ = vala_property_get_property_type ((ValaProperty*) _tmp597_);
					_tmp599_ = _tmp598_;
					_tmp600_ = vala_data_type_copy (_tmp599_);
					_tmp601_ = _tmp600_;
					_tmp602_ = prop;
					_tmp603_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp602_);
					_tmp604_ = _tmp603_;
					_tmp605_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp601_, NULL, _tmp604_, NULL);
					_tmp606_ = _tmp605_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp596_, _tmp606_);
					_vala_code_node_unref0 (_tmp606_);
					_vala_code_node_unref0 (_tmp601_);
					_tmp607_ = prop;
					_tmp608_ = vala_member_access_get_inner (self);
					_tmp609_ = _tmp608_;
					_tmp610_ = vala_expression_get_value_type (_tmp609_);
					_tmp611_ = _tmp610_;
					_tmp612_ = vala_data_type_get_type_symbol (_tmp611_);
					_tmp613_ = _tmp612_;
					_tmp614_ = vala_symbol_get_scope ((ValaSymbol*) _tmp613_);
					_tmp615_ = _tmp614_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp607_, _tmp615_);
					_tmp616_ = dynamic_object_type;
					_tmp617_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp616_);
					_tmp618_ = _tmp617_;
					_tmp619_ = vala_symbol_get_scope ((ValaSymbol*) _tmp618_);
					_tmp620_ = _tmp619_;
					_tmp621_ = prop;
					vala_scope_add (_tmp620_, NULL, (ValaSymbol*) _tmp621_);
					_tmp622_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp622_);
					_vala_code_node_unref0 (prop);
				}
				_tmp623_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp624_ = _tmp623_;
				if (_tmp624_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp625_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp626_ = _tmp625_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp626_)) {
				ValaExpression* _tmp627_;
				ValaExpression* _tmp628_;
				ValaSymbol* _tmp629_;
				ValaSymbol* _tmp630_;
				_tmp627_ = vala_member_access_get_inner (self);
				_tmp628_ = _tmp627_;
				_tmp629_ = vala_expression_get_symbol_reference (_tmp628_);
				_tmp630_ = _tmp629_;
				if (VALA_IS_VARIABLE (_tmp630_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp631_;
					ValaSemanticAnalyzer* _tmp632_;
					ValaExpression* _tmp633_;
					ValaExpression* _tmp634_;
					ValaSymbol* _tmp635_;
					ValaSymbol* _tmp636_;
					ValaDataType* _tmp637_;
					ValaArrayType* _tmp638_;
					gboolean _tmp639_ = FALSE;
					ValaArrayType* _tmp640_;
					_tmp631_ = vala_code_context_get_analyzer (context);
					_tmp632_ = _tmp631_;
					_tmp633_ = vala_member_access_get_inner (self);
					_tmp634_ = _tmp633_;
					_tmp635_ = vala_expression_get_symbol_reference (_tmp634_);
					_tmp636_ = _tmp635_;
					_tmp637_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp632_, _tmp636_, TRUE);
					_tmp638_ = VALA_IS_ARRAY_TYPE (_tmp637_) ? ((ValaArrayType*) _tmp637_) : NULL;
					if (_tmp638_ == NULL) {
						_vala_code_node_unref0 (_tmp637_);
					}
					inner_type = _tmp638_;
					_tmp640_ = inner_type;
					if (_tmp640_ != NULL) {
						ValaArrayType* _tmp641_;
						gboolean _tmp642_;
						gboolean _tmp643_;
						_tmp641_ = inner_type;
						_tmp642_ = vala_array_type_get_inline_allocated (_tmp641_);
						_tmp643_ = _tmp642_;
						_tmp639_ = _tmp643_;
					} else {
						_tmp639_ = FALSE;
					}
					if (_tmp639_) {
						ValaSourceReference* _tmp644_;
						ValaSourceReference* _tmp645_;
						_tmp644_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp645_ = _tmp644_;
						vala_report_error (_tmp645_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp646_ = FALSE;
						ValaArrayType* _tmp647_;
						_tmp647_ = inner_type;
						if (_tmp647_ != NULL) {
							ValaArrayType* _tmp648_;
							gboolean _tmp649_;
							gboolean _tmp650_;
							_tmp648_ = inner_type;
							_tmp649_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp648_);
							_tmp650_ = _tmp649_;
							_tmp646_ = !_tmp650_;
						} else {
							_tmp646_ = FALSE;
						}
						if (_tmp646_) {
							ValaSourceReference* _tmp651_;
							ValaSourceReference* _tmp652_;
							_tmp651_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp652_ = _tmp651_;
							vala_report_error (_tmp652_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp653_;
					ValaExpression* _tmp654_;
					ValaSymbol* _tmp655_;
					ValaSymbol* _tmp656_;
					_tmp653_ = vala_member_access_get_inner (self);
					_tmp654_ = _tmp653_;
					_tmp655_ = vala_expression_get_symbol_reference (_tmp654_);
					_tmp656_ = _tmp655_;
					if (VALA_IS_CONSTANT (_tmp656_)) {
						ValaSourceReference* _tmp657_;
						ValaSourceReference* _tmp658_;
						_tmp657_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp658_ = _tmp657_;
						vala_report_error (_tmp658_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp662_ = vala_member_access_get_inner (self);
	_tmp663_ = _tmp662_;
	if (_tmp663_ == NULL) {
		ValaSymbol* _tmp664_;
		ValaSymbol* _tmp665_;
		_tmp664_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp665_ = _tmp664_;
		_tmp661_ = _tmp665_ == NULL;
	} else {
		_tmp661_ = FALSE;
	}
	if (_tmp661_) {
		ValaDataType* _tmp666_;
		ValaDataType* _tmp667_;
		_tmp666_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp667_ = _tmp666_;
		_tmp660_ = _tmp667_ != NULL;
	} else {
		_tmp660_ = FALSE;
	}
	if (_tmp660_) {
		ValaDataType* _tmp668_;
		ValaDataType* _tmp669_;
		ValaTypeSymbol* _tmp670_;
		ValaTypeSymbol* _tmp671_;
		_tmp668_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp669_ = _tmp668_;
		_tmp670_ = vala_data_type_get_type_symbol (_tmp669_);
		_tmp671_ = _tmp670_;
		_tmp659_ = VALA_IS_ENUM (_tmp671_);
	} else {
		_tmp659_ = FALSE;
	}
	if (_tmp659_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp672_;
		ValaDataType* _tmp673_;
		ValaTypeSymbol* _tmp674_;
		ValaTypeSymbol* _tmp675_;
		_tmp672_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp673_ = _tmp672_;
		_tmp674_ = vala_data_type_get_type_symbol (_tmp673_);
		_tmp675_ = _tmp674_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp675_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp676_;
			ValaList* _tmp677_;
			gint _val_size = 0;
			ValaList* _tmp678_;
			gint _tmp679_;
			gint _tmp680_;
			gint _val_index = 0;
			_tmp676_ = enum_type;
			_tmp677_ = vala_enum_get_values (_tmp676_);
			_val_list = _tmp677_;
			_tmp678_ = _val_list;
			_tmp679_ = vala_collection_get_size ((ValaCollection*) _tmp678_);
			_tmp680_ = _tmp679_;
			_val_size = _tmp680_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp681_;
				gint _tmp682_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp683_;
				gpointer _tmp684_;
				const gchar* _tmp685_;
				ValaEnumValue* _tmp686_;
				const gchar* _tmp687_;
				const gchar* _tmp688_;
				_val_index = _val_index + 1;
				_tmp681_ = _val_index;
				_tmp682_ = _val_size;
				if (!(_tmp681_ < _tmp682_)) {
					break;
				}
				_tmp683_ = _val_list;
				_tmp684_ = vala_list_get (_tmp683_, _val_index);
				val = (ValaEnumValue*) _tmp684_;
				_tmp685_ = self->priv->_member_name;
				_tmp686_ = val;
				_tmp687_ = vala_symbol_get_name ((ValaSymbol*) _tmp686_);
				_tmp688_ = _tmp687_;
				if (g_strcmp0 (_tmp685_, _tmp688_) == 0) {
					ValaEnumValue* _tmp689_;
					_tmp689_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp689_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp690_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp691_ = _tmp690_;
	if (_tmp691_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp692_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp693_ = FALSE;
		ValaExpression* _tmp694_;
		ValaExpression* _tmp695_;
		gchar* base_type_package = NULL;
		gchar* _tmp715_;
		gboolean _tmp716_ = FALSE;
		ValaSymbol* _tmp717_;
		gchar* visited_types_string = NULL;
		gchar* _tmp732_;
		ValaSourceReference* _tmp748_;
		ValaSourceReference* _tmp749_;
		const gchar* _tmp750_;
		const gchar* _tmp751_;
		const gchar* _tmp752_;
		const gchar* _tmp753_;
		ValaInvalidType* _tmp754_;
		ValaInvalidType* _tmp755_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp692_ = g_strdup ("(null)");
		base_type_name = _tmp692_;
		base_type = NULL;
		_tmp694_ = vala_member_access_get_inner (self);
		_tmp695_ = _tmp694_;
		if (_tmp695_ != NULL) {
			ValaExpression* _tmp696_;
			ValaExpression* _tmp697_;
			ValaDataType* _tmp698_;
			ValaDataType* _tmp699_;
			_tmp696_ = vala_member_access_get_inner (self);
			_tmp697_ = _tmp696_;
			_tmp698_ = vala_expression_get_value_type (_tmp697_);
			_tmp699_ = _tmp698_;
			_tmp693_ = _tmp699_ != NULL;
		} else {
			_tmp693_ = FALSE;
		}
		if (_tmp693_) {
			ValaExpression* _tmp700_;
			ValaExpression* _tmp701_;
			ValaDataType* _tmp702_;
			ValaDataType* _tmp703_;
			gchar* _tmp704_;
			ValaExpression* _tmp705_;
			ValaExpression* _tmp706_;
			ValaDataType* _tmp707_;
			ValaDataType* _tmp708_;
			ValaTypeSymbol* _tmp709_;
			ValaTypeSymbol* _tmp710_;
			_tmp700_ = vala_member_access_get_inner (self);
			_tmp701_ = _tmp700_;
			_tmp702_ = vala_expression_get_value_type (_tmp701_);
			_tmp703_ = _tmp702_;
			_tmp704_ = vala_code_node_to_string ((ValaCodeNode*) _tmp703_);
			_g_free0 (base_type_name);
			base_type_name = _tmp704_;
			_tmp705_ = vala_member_access_get_inner (self);
			_tmp706_ = _tmp705_;
			_tmp707_ = vala_expression_get_value_type (_tmp706_);
			_tmp708_ = _tmp707_;
			_tmp709_ = vala_data_type_get_type_symbol (_tmp708_);
			_tmp710_ = _tmp709_;
			base_type = (ValaSymbol*) _tmp710_;
		} else {
			ValaSymbol* _tmp711_;
			_tmp711_ = base_symbol;
			if (_tmp711_ != NULL) {
				ValaSymbol* _tmp712_;
				gchar* _tmp713_;
				ValaSymbol* _tmp714_;
				_tmp712_ = base_symbol;
				_tmp713_ = vala_symbol_get_full_name (_tmp712_);
				_g_free0 (base_type_name);
				base_type_name = _tmp713_;
				_tmp714_ = base_symbol;
				base_type = _tmp714_;
			}
		}
		_tmp715_ = g_strdup ("");
		base_type_package = _tmp715_;
		_tmp717_ = base_type;
		if (_tmp717_ != NULL) {
			ValaSymbol* _tmp718_;
			gboolean _tmp719_;
			gboolean _tmp720_;
			_tmp718_ = base_type;
			_tmp719_ = vala_symbol_get_external_package (_tmp718_);
			_tmp720_ = _tmp719_;
			_tmp716_ = _tmp720_;
		} else {
			_tmp716_ = FALSE;
		}
		if (_tmp716_) {
			ValaSymbol* _tmp721_;
			ValaSourceReference* _tmp722_;
			ValaSourceReference* _tmp723_;
			ValaSourceFile* _tmp724_;
			ValaSourceFile* _tmp725_;
			const gchar* _tmp726_;
			const gchar* _tmp727_;
			gchar* _tmp728_;
			const gchar* _tmp729_;
			_tmp721_ = base_symbol;
			_tmp722_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp721_);
			_tmp723_ = _tmp722_;
			_tmp724_ = vala_source_reference_get_file (_tmp723_);
			_tmp725_ = _tmp724_;
			_tmp726_ = vala_source_file_get_package_name (_tmp725_);
			_tmp727_ = _tmp726_;
			_tmp728_ = g_strdup (_tmp727_);
			_g_free0 (base_type_package);
			base_type_package = _tmp728_;
			_tmp729_ = base_type_package;
			if (_tmp729_ != NULL) {
				const gchar* _tmp730_;
				gchar* _tmp731_;
				_tmp730_ = base_type_package;
				_tmp731_ = g_strdup_printf (" (%s)", _tmp730_);
				_g_free0 (base_type_package);
				base_type_package = _tmp731_;
			}
		}
		_tmp732_ = g_strdup ("");
		visited_types_string = _tmp732_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp733_;
			gint _type_size = 0;
			ValaArrayList* _tmp734_;
			gint _tmp735_;
			gint _tmp736_;
			gint _type_index = 0;
			_tmp733_ = visited_types;
			_type_list = _tmp733_;
			_tmp734_ = _type_list;
			_tmp735_ = vala_collection_get_size ((ValaCollection*) _tmp734_);
			_tmp736_ = _tmp735_;
			_type_size = _tmp736_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp737_;
				gint _tmp738_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp739_;
				gpointer _tmp740_;
				const gchar* _tmp741_;
				ValaDataType* _tmp742_;
				gchar* _tmp743_;
				gchar* _tmp744_;
				gchar* _tmp745_;
				gchar* _tmp746_;
				gchar* _tmp747_;
				_type_index = _type_index + 1;
				_tmp737_ = _type_index;
				_tmp738_ = _type_size;
				if (!(_tmp737_ < _tmp738_)) {
					break;
				}
				_tmp739_ = _type_list;
				_tmp740_ = vala_list_get ((ValaList*) _tmp739_, _type_index);
				type = (ValaDataType*) _tmp740_;
				_tmp741_ = visited_types_string;
				_tmp742_ = type;
				_tmp743_ = vala_code_node_to_string ((ValaCodeNode*) _tmp742_);
				_tmp744_ = _tmp743_;
				_tmp745_ = g_strdup_printf (" or `%s'", _tmp744_);
				_tmp746_ = _tmp745_;
				_tmp747_ = g_strconcat (_tmp741_, _tmp746_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp747_;
				_g_free0 (_tmp746_);
				_g_free0 (_tmp744_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp748_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp749_ = _tmp748_;
		_tmp750_ = self->priv->_member_name;
		_tmp751_ = base_type_name;
		_tmp752_ = base_type_package;
		_tmp753_ = visited_types_string;
		vala_report_error (_tmp749_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp750_, _tmp751_, _tmp752_, _tmp753_);
		_tmp754_ = vala_invalid_type_new ();
		_tmp755_ = _tmp754_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp755_);
		_vala_code_node_unref0 (_tmp755_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp756_;
		ValaSymbol* _tmp757_;
		gboolean _tmp758_;
		gboolean _tmp759_;
		_tmp756_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp757_ = _tmp756_;
		_tmp758_ = vala_code_node_get_error ((ValaCodeNode*) _tmp757_);
		_tmp759_ = _tmp758_;
		if (_tmp759_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp760_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp761_ = _tmp760_;
	if (VALA_IS_SIGNAL (_tmp761_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp762_;
		ValaSymbol* _tmp763_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp770_;
		ValaCodeNode* _tmp771_;
		ValaCodeNode* _tmp772_;
		gboolean _tmp773_ = FALSE;
		gboolean _tmp774_ = FALSE;
		gboolean _tmp775_ = FALSE;
		ValaCodeNode* _tmp776_;
		_tmp762_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp763_ = _tmp762_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp763_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp764_;
			ValaCodeNode* _tmp765_;
			ValaCodeNode* _tmp766_;
			ValaCodeNode* _tmp767_;
			ValaCodeNode* _tmp768_;
			ValaCodeNode* _tmp769_;
			_tmp764_ = ma;
			_tmp765_ = vala_code_node_get_parent_node (_tmp764_);
			_tmp766_ = _tmp765_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp766_)) {
				break;
			}
			_tmp767_ = ma;
			_tmp768_ = vala_code_node_get_parent_node (_tmp767_);
			_tmp769_ = _tmp768_;
			ma = _tmp769_;
		}
		_tmp770_ = ma;
		_tmp771_ = vala_code_node_get_parent_node (_tmp770_);
		_tmp772_ = _tmp771_;
		parent = _tmp772_;
		_tmp776_ = parent;
		if (_tmp776_ != NULL) {
			ValaCodeNode* _tmp777_;
			_tmp777_ = parent;
			_tmp775_ = !VALA_IS_ELEMENT_ACCESS (_tmp777_);
		} else {
			_tmp775_ = FALSE;
		}
		if (_tmp775_) {
			ValaCodeNode* _tmp778_;
			ValaExpression* _tmp779_;
			ValaExpression* _tmp780_;
			_tmp778_ = ma;
			_tmp779_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp778_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp780_ = _tmp779_;
			_tmp774_ = !VALA_IS_BASE_ACCESS (_tmp780_);
		} else {
			_tmp774_ = FALSE;
		}
		if (_tmp774_) {
			gboolean _tmp781_ = FALSE;
			ValaCodeNode* _tmp782_;
			_tmp782_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp782_)) {
				_tmp781_ = TRUE;
			} else {
				ValaCodeNode* _tmp783_;
				ValaList* _tmp784_;
				_tmp783_ = parent;
				_tmp784_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp783_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp781_ = vala_collection_contains ((ValaCollection*) _tmp784_, (ValaExpression*) self);
			}
			_tmp773_ = _tmp781_;
		} else {
			_tmp773_ = FALSE;
		}
		if (_tmp773_) {
			ValaSignal* _tmp785_;
			ValaAttribute* _tmp786_;
			_tmp785_ = sig;
			_tmp786_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp785_, "HasEmitter");
			if (_tmp786_ != NULL) {
				ValaSignal* _tmp787_;
				ValaSignal* _tmp788_;
				ValaMethod* _tmp789_;
				ValaMethod* _tmp790_;
				_tmp787_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp787_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp788_ = sig;
				_tmp789_ = vala_signal_get_emitter (_tmp788_);
				_tmp790_ = _tmp789_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp790_);
			} else {
				ValaSourceReference* _tmp791_;
				ValaSourceReference* _tmp792_;
				ValaSymbol* _tmp793_;
				ValaSymbol* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp791_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp792_ = _tmp791_;
				_tmp793_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp794_ = _tmp793_;
				_tmp795_ = vala_symbol_get_full_name (_tmp794_);
				_tmp796_ = _tmp795_;
				vala_report_error (_tmp792_, "Signal `%s' requires emitter in this context", _tmp796_);
				_g_free0 (_tmp796_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp797_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp798_ = _tmp797_;
	member = _tmp798_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp799_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp799_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp800_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp800_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp801_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp802_;
		ValaSymbol* _tmp803_;
		ValaSymbol* _tmp804_;
		gboolean _tmp805_ = FALSE;
		ValaBlock* _tmp806_;
		_tmp801_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp801_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp802_ = local;
		_tmp803_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp802_);
		_tmp804_ = _tmp803_;
		block = VALA_IS_BLOCK (_tmp804_) ? ((ValaBlock*) _tmp804_) : NULL;
		_tmp806_ = block;
		if (_tmp806_ != NULL) {
			ValaBlock* _tmp807_;
			ValaSymbol* _tmp808_;
			ValaSemanticAnalyzer* _tmp809_;
			ValaSemanticAnalyzer* _tmp810_;
			ValaSymbol* _tmp811_;
			ValaSymbol* _tmp812_;
			_tmp807_ = block;
			_tmp808_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp807_);
			_tmp809_ = vala_code_context_get_analyzer (context);
			_tmp810_ = _tmp809_;
			_tmp811_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp810_);
			_tmp812_ = _tmp811_;
			_tmp805_ = _tmp808_ != _tmp812_;
		} else {
			_tmp805_ = FALSE;
		}
		if (_tmp805_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp813_;
			ValaSemanticAnalyzer* _tmp814_;
			ValaSymbol* _tmp815_;
			ValaSymbol* _tmp816_;
			ValaLocalVariable* _tmp827_;
			ValaBlock* _tmp828_;
			ValaLocalVariable* _tmp829_;
			ValaDataType* _tmp830_;
			ValaDataType* _tmp831_;
			ValaTypeSymbol* _tmp832_;
			ValaTypeSymbol* _tmp833_;
			ValaSemanticAnalyzer* _tmp834_;
			ValaSemanticAnalyzer* _tmp835_;
			ValaDataType* _tmp836_;
			ValaTypeSymbol* _tmp837_;
			ValaTypeSymbol* _tmp838_;
			_tmp813_ = vala_code_context_get_analyzer (context);
			_tmp814_ = _tmp813_;
			_tmp815_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp814_);
			_tmp816_ = _tmp815_;
			sym = _tmp816_;
			while (TRUE) {
				ValaSymbol* _tmp817_;
				ValaBlock* _tmp818_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp819_;
				ValaMethod* _tmp820_;
				ValaSymbol* _tmp824_;
				ValaSymbol* _tmp825_;
				ValaSymbol* _tmp826_;
				_tmp817_ = sym;
				_tmp818_ = block;
				if (!(_tmp817_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp818_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp819_ = sym;
				method = VALA_IS_METHOD (_tmp819_) ? ((ValaMethod*) _tmp819_) : NULL;
				_tmp820_ = method;
				if (_tmp820_ != NULL) {
					ValaMethod* _tmp821_;
					ValaMethod* _tmp822_;
					ValaLocalVariable* _tmp823_;
					_tmp821_ = method;
					vala_method_set_closure (_tmp821_, TRUE);
					_tmp822_ = method;
					_tmp823_ = local;
					vala_method_add_captured_variable (_tmp822_, _tmp823_);
				}
				_tmp824_ = sym;
				_tmp825_ = vala_symbol_get_parent_symbol (_tmp824_);
				_tmp826_ = _tmp825_;
				sym = _tmp826_;
			}
			_tmp827_ = local;
			vala_local_variable_set_captured (_tmp827_, TRUE);
			_tmp828_ = block;
			vala_block_set_captured (_tmp828_, TRUE);
			_tmp829_ = local;
			_tmp830_ = vala_variable_get_variable_type ((ValaVariable*) _tmp829_);
			_tmp831_ = _tmp830_;
			_tmp832_ = vala_data_type_get_type_symbol (_tmp831_);
			_tmp833_ = _tmp832_;
			_tmp834_ = vala_code_context_get_analyzer (context);
			_tmp835_ = _tmp834_;
			_tmp836_ = _tmp835_->va_list_type;
			_tmp837_ = vala_data_type_get_type_symbol (_tmp836_);
			_tmp838_ = _tmp837_;
			if (_tmp833_ == _tmp838_) {
				ValaSourceReference* _tmp839_;
				ValaSourceReference* _tmp840_;
				ValaLocalVariable* _tmp841_;
				gchar* _tmp842_;
				gchar* _tmp843_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp839_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp840_ = _tmp839_;
				_tmp841_ = local;
				_tmp842_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp841_);
				_tmp843_ = _tmp842_;
				vala_report_error (_tmp840_, "Capturing `va_list' variable `%s' is not allowed", _tmp843_);
				_g_free0 (_tmp843_);
			}
		}
	} else {
		ValaSymbol* _tmp844_;
		_tmp844_ = member;
		if (VALA_IS_PARAMETER (_tmp844_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp845_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp846_;
			ValaSymbol* _tmp847_;
			ValaSymbol* _tmp848_;
			gboolean _tmp849_ = FALSE;
			gboolean _tmp850_ = FALSE;
			ValaMethod* _tmp851_;
			_tmp845_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp845_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp846_ = param;
			_tmp847_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp846_);
			_tmp848_ = _tmp847_;
			m = VALA_IS_METHOD (_tmp848_) ? ((ValaMethod*) _tmp848_) : NULL;
			_tmp851_ = m;
			if (_tmp851_ != NULL) {
				ValaMethod* _tmp852_;
				ValaSemanticAnalyzer* _tmp853_;
				ValaSemanticAnalyzer* _tmp854_;
				ValaSymbol* _tmp855_;
				ValaSymbol* _tmp856_;
				_tmp852_ = m;
				_tmp853_ = vala_code_context_get_analyzer (context);
				_tmp854_ = _tmp853_;
				_tmp855_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp854_);
				_tmp856_ = _tmp855_;
				_tmp850_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp852_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp856_;
			} else {
				_tmp850_ = FALSE;
			}
			if (_tmp850_) {
				ValaParameter* _tmp857_;
				ValaMethod* _tmp858_;
				ValaParameter* _tmp859_;
				ValaParameter* _tmp860_;
				_tmp857_ = param;
				_tmp858_ = m;
				_tmp859_ = vala_method_get_this_parameter (_tmp858_);
				_tmp860_ = _tmp859_;
				_tmp849_ = _tmp857_ != _tmp860_;
			} else {
				_tmp849_ = FALSE;
			}
			if (_tmp849_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp861_;
				ValaSemanticAnalyzer* _tmp862_;
				ValaSymbol* _tmp863_;
				ValaSymbol* _tmp864_;
				ValaParameter* _tmp873_;
				ValaMethod* _tmp874_;
				ValaBlock* _tmp875_;
				ValaBlock* _tmp876_;
				ValaParameter* _tmp877_;
				ValaParameterDirection _tmp878_;
				ValaParameterDirection _tmp879_;
				ValaParameter* _tmp885_;
				ValaDataType* _tmp886_;
				ValaDataType* _tmp887_;
				ValaTypeSymbol* _tmp888_;
				ValaTypeSymbol* _tmp889_;
				ValaSemanticAnalyzer* _tmp890_;
				ValaSemanticAnalyzer* _tmp891_;
				ValaDataType* _tmp892_;
				ValaTypeSymbol* _tmp893_;
				ValaTypeSymbol* _tmp894_;
				_tmp861_ = vala_code_context_get_analyzer (context);
				_tmp862_ = _tmp861_;
				_tmp863_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp862_);
				_tmp864_ = _tmp863_;
				sym = _tmp864_;
				while (TRUE) {
					ValaSymbol* _tmp865_;
					ValaMethod* _tmp866_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp867_;
					ValaMethod* _tmp868_;
					ValaSymbol* _tmp870_;
					ValaSymbol* _tmp871_;
					ValaSymbol* _tmp872_;
					_tmp865_ = sym;
					_tmp866_ = m;
					if (!(_tmp865_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp866_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp867_ = sym;
					method = VALA_IS_METHOD (_tmp867_) ? ((ValaMethod*) _tmp867_) : NULL;
					_tmp868_ = method;
					if (_tmp868_ != NULL) {
						ValaMethod* _tmp869_;
						_tmp869_ = method;
						vala_method_set_closure (_tmp869_, TRUE);
					}
					_tmp870_ = sym;
					_tmp871_ = vala_symbol_get_parent_symbol (_tmp870_);
					_tmp872_ = _tmp871_;
					sym = _tmp872_;
				}
				_tmp873_ = param;
				vala_parameter_set_captured (_tmp873_, TRUE);
				_tmp874_ = m;
				_tmp875_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp874_);
				_tmp876_ = _tmp875_;
				vala_block_set_captured (_tmp876_, TRUE);
				_tmp877_ = param;
				_tmp878_ = vala_parameter_get_direction (_tmp877_);
				_tmp879_ = _tmp878_;
				if (_tmp879_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp880_;
					ValaSourceReference* _tmp881_;
					ValaParameter* _tmp882_;
					gchar* _tmp883_;
					gchar* _tmp884_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp880_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp881_ = _tmp880_;
					_tmp882_ = param;
					_tmp883_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp882_);
					_tmp884_ = _tmp883_;
					vala_report_error (_tmp881_, "Cannot capture reference or output parameter `%s'", _tmp884_);
					_g_free0 (_tmp884_);
				}
				_tmp885_ = param;
				_tmp886_ = vala_variable_get_variable_type ((ValaVariable*) _tmp885_);
				_tmp887_ = _tmp886_;
				_tmp888_ = vala_data_type_get_type_symbol (_tmp887_);
				_tmp889_ = _tmp888_;
				_tmp890_ = vala_code_context_get_analyzer (context);
				_tmp891_ = _tmp890_;
				_tmp892_ = _tmp891_->va_list_type;
				_tmp893_ = vala_data_type_get_type_symbol (_tmp892_);
				_tmp894_ = _tmp893_;
				if (_tmp889_ == _tmp894_) {
					ValaSourceReference* _tmp895_;
					ValaSourceReference* _tmp896_;
					ValaParameter* _tmp897_;
					gchar* _tmp898_;
					gchar* _tmp899_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp895_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp896_ = _tmp895_;
					_tmp897_ = param;
					_tmp898_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp897_);
					_tmp899_ = _tmp898_;
					vala_report_error (_tmp896_, "Capturing `va_list' parameter `%s' is not allowed", _tmp899_);
					_g_free0 (_tmp899_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp900_;
				ValaSymbol* _tmp901_;
				ValaSymbol* _tmp902_;
				ValaSymbol* _tmp903_;
				ValaSymbol* _tmp904_;
				gboolean _tmp905_ = FALSE;
				gboolean _tmp906_ = FALSE;
				ValaPropertyAccessor* _tmp907_;
				_tmp900_ = param;
				_tmp901_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp900_);
				_tmp902_ = _tmp901_;
				_tmp903_ = vala_symbol_get_parent_symbol (_tmp902_);
				_tmp904_ = _tmp903_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp904_) ? ((ValaPropertyAccessor*) _tmp904_) : NULL;
				_tmp907_ = acc;
				if (_tmp907_ != NULL) {
					ValaPropertyAccessor* _tmp908_;
					ValaSemanticAnalyzer* _tmp909_;
					ValaSemanticAnalyzer* _tmp910_;
					ValaSymbol* _tmp911_;
					ValaSymbol* _tmp912_;
					_tmp908_ = acc;
					_tmp909_ = vala_code_context_get_analyzer (context);
					_tmp910_ = _tmp909_;
					_tmp911_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp910_);
					_tmp912_ = _tmp911_;
					_tmp906_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp908_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp912_;
				} else {
					_tmp906_ = FALSE;
				}
				if (_tmp906_) {
					ValaParameter* _tmp913_;
					ValaPropertyAccessor* _tmp914_;
					ValaProperty* _tmp915_;
					ValaProperty* _tmp916_;
					ValaParameter* _tmp917_;
					ValaParameter* _tmp918_;
					_tmp913_ = param;
					_tmp914_ = acc;
					_tmp915_ = vala_property_accessor_get_prop (_tmp914_);
					_tmp916_ = _tmp915_;
					_tmp917_ = vala_property_get_this_parameter (_tmp916_);
					_tmp918_ = _tmp917_;
					_tmp905_ = _tmp913_ != _tmp918_;
				} else {
					_tmp905_ = FALSE;
				}
				if (_tmp905_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp919_;
					ValaSemanticAnalyzer* _tmp920_;
					ValaSymbol* _tmp921_;
					ValaSymbol* _tmp922_;
					ValaParameter* _tmp931_;
					ValaPropertyAccessor* _tmp932_;
					ValaBlock* _tmp933_;
					ValaBlock* _tmp934_;
					_tmp919_ = vala_code_context_get_analyzer (context);
					_tmp920_ = _tmp919_;
					_tmp921_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp920_);
					_tmp922_ = _tmp921_;
					sym = _tmp922_;
					while (TRUE) {
						ValaSymbol* _tmp923_;
						ValaMethod* _tmp924_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp925_;
						ValaMethod* _tmp926_;
						ValaSymbol* _tmp928_;
						ValaSymbol* _tmp929_;
						ValaSymbol* _tmp930_;
						_tmp923_ = sym;
						_tmp924_ = m;
						if (!(_tmp923_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp924_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp925_ = sym;
						method = VALA_IS_METHOD (_tmp925_) ? ((ValaMethod*) _tmp925_) : NULL;
						_tmp926_ = method;
						if (_tmp926_ != NULL) {
							ValaMethod* _tmp927_;
							_tmp927_ = method;
							vala_method_set_closure (_tmp927_, TRUE);
						}
						_tmp928_ = sym;
						_tmp929_ = vala_symbol_get_parent_symbol (_tmp928_);
						_tmp930_ = _tmp929_;
						sym = _tmp930_;
					}
					_tmp931_ = param;
					vala_parameter_set_captured (_tmp931_, TRUE);
					_tmp932_ = acc;
					_tmp933_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp932_);
					_tmp934_ = _tmp933_;
					vala_block_set_captured (_tmp934_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp935_;
			_tmp935_ = member;
			if (VALA_IS_FIELD (_tmp935_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp936_;
				ValaField* _tmp937_;
				ValaSymbolAccessibility _tmp938_;
				ValaSymbolAccessibility _tmp939_;
				ValaField* _tmp940_;
				ValaMemberBinding _tmp941_;
				ValaMemberBinding _tmp942_;
				ValaField* _tmp943_;
				ValaMemberBinding _tmp944_;
				ValaMemberBinding _tmp945_;
				ValaField* _tmp946_;
				ValaDataType* _tmp947_;
				ValaDataType* _tmp948_;
				_tmp936_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp936_, VALA_TYPE_FIELD, ValaField);
				_tmp937_ = f;
				_tmp938_ = vala_symbol_get_access ((ValaSymbol*) _tmp937_);
				_tmp939_ = _tmp938_;
				access = _tmp939_;
				_tmp940_ = f;
				_tmp941_ = vala_field_get_binding (_tmp940_);
				_tmp942_ = _tmp941_;
				instance = _tmp942_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp943_ = f;
				_tmp944_ = vala_field_get_binding (_tmp943_);
				_tmp945_ = _tmp944_;
				klass = _tmp945_ == VALA_MEMBER_BINDING_CLASS;
				_tmp946_ = f;
				_tmp947_ = vala_variable_get_variable_type ((ValaVariable*) _tmp946_);
				_tmp948_ = _tmp947_;
				if (VALA_IS_GENERIC_TYPE (_tmp948_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp949_;
				_tmp949_ = member;
				if (VALA_IS_CONSTANT (_tmp949_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp950_;
					ValaConstant* _tmp951_;
					ValaSymbolAccessibility _tmp952_;
					ValaSymbolAccessibility _tmp953_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp954_;
					ValaSymbol* _tmp955_;
					ValaSymbol* _tmp956_;
					gboolean _tmp957_ = FALSE;
					ValaBlock* _tmp958_;
					_tmp950_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp950_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp951_ = c;
					_tmp952_ = vala_symbol_get_access ((ValaSymbol*) _tmp951_);
					_tmp953_ = _tmp952_;
					access = _tmp953_;
					_tmp954_ = c;
					_tmp955_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp954_);
					_tmp956_ = _tmp955_;
					block = VALA_IS_BLOCK (_tmp956_) ? ((ValaBlock*) _tmp956_) : NULL;
					_tmp958_ = block;
					if (_tmp958_ != NULL) {
						ValaBlock* _tmp959_;
						ValaSymbol* _tmp960_;
						ValaSemanticAnalyzer* _tmp961_;
						ValaSemanticAnalyzer* _tmp962_;
						ValaSymbol* _tmp963_;
						ValaSymbol* _tmp964_;
						_tmp959_ = block;
						_tmp960_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp959_);
						_tmp961_ = vala_code_context_get_analyzer (context);
						_tmp962_ = _tmp961_;
						_tmp963_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp962_);
						_tmp964_ = _tmp963_;
						_tmp957_ = _tmp960_ != _tmp964_;
					} else {
						_tmp957_ = FALSE;
					}
					if (_tmp957_) {
						ValaSourceReference* _tmp965_;
						ValaSourceReference* _tmp966_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp965_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp966_ = _tmp965_;
						vala_report_error (_tmp966_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp967_;
					_tmp967_ = member;
					if (VALA_IS_METHOD (_tmp967_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp968_;
						ValaMethod* _tmp969_;
						gboolean _tmp970_;
						gboolean _tmp971_;
						ValaMethod* _tmp1058_;
						ValaSymbolAccessibility _tmp1059_;
						ValaSymbolAccessibility _tmp1060_;
						ValaMethod* _tmp1061_;
						ValaMethod* _tmp1065_;
						ValaMemberBinding _tmp1066_;
						ValaMemberBinding _tmp1067_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1087_;
						ValaDataType* _tmp1088_;
						ValaDataType* _tmp1089_;
						gboolean _tmp1090_ = FALSE;
						ValaGenericType* _tmp1091_;
						_tmp968_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp968_, VALA_TYPE_METHOD, ValaMethod);
						_tmp969_ = m;
						_tmp970_ = vala_method_get_is_async_callback (_tmp969_);
						_tmp971_ = _tmp970_;
						if (_tmp971_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp972_;
							ValaSemanticAnalyzer* _tmp973_;
							ValaMethod* _tmp974_;
							ValaMethod* _tmp975_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp976_;
							ValaMethod* _tmp1003_;
							ValaSemanticAnalyzer* _tmp1004_;
							ValaSemanticAnalyzer* _tmp1005_;
							ValaMethod* _tmp1006_;
							ValaMethod* _tmp1007_;
							ValaMethod* _tmp1023_;
							ValaMethod* _tmp1024_;
							ValaMethod* _tmp1025_;
							ValaSymbol* _tmp1026_;
							ValaSymbol* _tmp1027_;
							_tmp972_ = vala_code_context_get_analyzer (context);
							_tmp973_ = _tmp972_;
							_tmp974_ = vala_semantic_analyzer_get_current_async_method (_tmp973_);
							_tmp975_ = _tmp974_;
							async_method = _tmp975_;
							is_valid_access = FALSE;
							_tmp976_ = async_method;
							if (_tmp976_ != NULL) {
								ValaMethod* _tmp977_;
								ValaMethod* _tmp978_;
								ValaMethod* _tmp979_;
								_tmp977_ = m;
								_tmp978_ = async_method;
								_tmp979_ = vala_method_get_callback_method (_tmp978_);
								if (_tmp977_ == _tmp979_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp980_ = FALSE;
									ValaMethod* _tmp981_;
									ValaMethod* _tmp982_;
									ValaMethod* _tmp983_;
									_tmp981_ = async_method;
									_tmp982_ = vala_method_get_base_method (_tmp981_);
									_tmp983_ = _tmp982_;
									if (_tmp983_ != NULL) {
										ValaMethod* _tmp984_;
										ValaMethod* _tmp985_;
										ValaMethod* _tmp986_;
										ValaMethod* _tmp987_;
										ValaMethod* _tmp988_;
										_tmp984_ = m;
										_tmp985_ = async_method;
										_tmp986_ = vala_method_get_base_method (_tmp985_);
										_tmp987_ = _tmp986_;
										_tmp988_ = vala_method_get_callback_method (_tmp987_);
										_tmp980_ = _tmp984_ == _tmp988_;
									} else {
										_tmp980_ = FALSE;
									}
									if (_tmp980_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp989_ = FALSE;
										ValaMethod* _tmp990_;
										ValaMethod* _tmp991_;
										ValaMethod* _tmp992_;
										_tmp990_ = async_method;
										_tmp991_ = vala_method_get_base_interface_method (_tmp990_);
										_tmp992_ = _tmp991_;
										if (_tmp992_ != NULL) {
											ValaMethod* _tmp993_;
											ValaMethod* _tmp994_;
											ValaMethod* _tmp995_;
											ValaMethod* _tmp996_;
											ValaMethod* _tmp997_;
											_tmp993_ = m;
											_tmp994_ = async_method;
											_tmp995_ = vala_method_get_base_interface_method (_tmp994_);
											_tmp996_ = _tmp995_;
											_tmp997_ = vala_method_get_callback_method (_tmp996_);
											_tmp989_ = _tmp993_ == _tmp997_;
										} else {
											_tmp989_ = FALSE;
										}
										if (_tmp989_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp998_;
								ValaSourceReference* _tmp999_;
								ValaMethod* _tmp1000_;
								gchar* _tmp1001_;
								gchar* _tmp1002_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp998_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp999_ = _tmp998_;
								_tmp1000_ = m;
								_tmp1001_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1000_);
								_tmp1002_ = _tmp1001_;
								vala_report_error (_tmp999_, "Access to async callback `%s' not allowed in this context", _tmp1002_);
								_g_free0 (_tmp1002_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1003_ = async_method;
							_tmp1004_ = vala_code_context_get_analyzer (context);
							_tmp1005_ = _tmp1004_;
							_tmp1006_ = vala_semantic_analyzer_get_current_method (_tmp1005_);
							_tmp1007_ = _tmp1006_;
							if (_tmp1003_ != _tmp1007_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1008_;
								ValaSemanticAnalyzer* _tmp1009_;
								ValaMethod* _tmp1010_;
								ValaMethod* _tmp1011_;
								ValaMethod* _tmp1020_;
								ValaBlock* _tmp1021_;
								ValaBlock* _tmp1022_;
								_tmp1008_ = vala_code_context_get_analyzer (context);
								_tmp1009_ = _tmp1008_;
								_tmp1010_ = vala_semantic_analyzer_get_current_method (_tmp1009_);
								_tmp1011_ = _tmp1010_;
								sym = (ValaSymbol*) _tmp1011_;
								while (TRUE) {
									ValaSymbol* _tmp1012_;
									ValaMethod* _tmp1013_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1014_;
									ValaMethod* _tmp1015_;
									ValaSymbol* _tmp1017_;
									ValaSymbol* _tmp1018_;
									ValaSymbol* _tmp1019_;
									_tmp1012_ = sym;
									_tmp1013_ = async_method;
									if (!(_tmp1012_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1013_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1014_ = sym;
									method = VALA_IS_METHOD (_tmp1014_) ? ((ValaMethod*) _tmp1014_) : NULL;
									_tmp1015_ = method;
									if (_tmp1015_ != NULL) {
										ValaMethod* _tmp1016_;
										_tmp1016_ = method;
										vala_method_set_closure (_tmp1016_, TRUE);
									}
									_tmp1017_ = sym;
									_tmp1018_ = vala_symbol_get_parent_symbol (_tmp1017_);
									_tmp1019_ = _tmp1018_;
									sym = _tmp1019_;
								}
								_tmp1020_ = async_method;
								_tmp1021_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1020_);
								_tmp1022_ = _tmp1021_;
								vala_block_set_captured (_tmp1022_, TRUE);
							}
							_tmp1023_ = async_method;
							_tmp1024_ = vala_method_get_callback_method (_tmp1023_);
							m = _tmp1024_;
							_tmp1025_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1025_);
							_tmp1026_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1027_ = _tmp1026_;
							member = _tmp1027_;
						} else {
							ValaMethod* _tmp1028_;
							ValaMethod* _tmp1029_;
							ValaMethod* _tmp1030_;
							_tmp1028_ = m;
							_tmp1029_ = vala_method_get_base_method (_tmp1028_);
							_tmp1030_ = _tmp1029_;
							if (_tmp1030_ != NULL) {
								ValaMethod* _tmp1031_;
								ValaMethod* _tmp1032_;
								ValaMethod* _tmp1033_;
								ValaMethod* _tmp1034_;
								ValaSignal* _tmp1035_;
								ValaSignal* _tmp1036_;
								ValaSymbol* _tmp1041_;
								ValaSymbol* _tmp1042_;
								_tmp1031_ = m;
								_tmp1032_ = vala_method_get_base_method (_tmp1031_);
								_tmp1033_ = _tmp1032_;
								m = _tmp1033_;
								_tmp1034_ = m;
								_tmp1035_ = vala_method_get_signal_reference (_tmp1034_);
								_tmp1036_ = _tmp1035_;
								if (_tmp1036_ != NULL) {
									ValaMethod* _tmp1037_;
									ValaSignal* _tmp1038_;
									ValaSignal* _tmp1039_;
									_tmp1037_ = m;
									_tmp1038_ = vala_method_get_signal_reference (_tmp1037_);
									_tmp1039_ = _tmp1038_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1039_);
								} else {
									ValaMethod* _tmp1040_;
									_tmp1040_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1040_);
								}
								_tmp1041_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1042_ = _tmp1041_;
								member = _tmp1042_;
							} else {
								ValaMethod* _tmp1043_;
								ValaMethod* _tmp1044_;
								ValaMethod* _tmp1045_;
								_tmp1043_ = m;
								_tmp1044_ = vala_method_get_base_interface_method (_tmp1043_);
								_tmp1045_ = _tmp1044_;
								if (_tmp1045_ != NULL) {
									ValaMethod* _tmp1046_;
									ValaMethod* _tmp1047_;
									ValaMethod* _tmp1048_;
									ValaMethod* _tmp1049_;
									ValaSignal* _tmp1050_;
									ValaSignal* _tmp1051_;
									ValaSymbol* _tmp1056_;
									ValaSymbol* _tmp1057_;
									_tmp1046_ = m;
									_tmp1047_ = vala_method_get_base_interface_method (_tmp1046_);
									_tmp1048_ = _tmp1047_;
									m = _tmp1048_;
									_tmp1049_ = m;
									_tmp1050_ = vala_method_get_signal_reference (_tmp1049_);
									_tmp1051_ = _tmp1050_;
									if (_tmp1051_ != NULL) {
										ValaMethod* _tmp1052_;
										ValaSignal* _tmp1053_;
										ValaSignal* _tmp1054_;
										_tmp1052_ = m;
										_tmp1053_ = vala_method_get_signal_reference (_tmp1052_);
										_tmp1054_ = _tmp1053_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1054_);
									} else {
										ValaMethod* _tmp1055_;
										_tmp1055_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1055_);
									}
									_tmp1056_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1057_ = _tmp1056_;
									member = _tmp1057_;
								}
							}
						}
						_tmp1058_ = m;
						_tmp1059_ = vala_symbol_get_access ((ValaSymbol*) _tmp1058_);
						_tmp1060_ = _tmp1059_;
						access = _tmp1060_;
						_tmp1061_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1061_)) {
							ValaMethod* _tmp1062_;
							ValaMemberBinding _tmp1063_;
							ValaMemberBinding _tmp1064_;
							_tmp1062_ = m;
							_tmp1063_ = vala_method_get_binding (_tmp1062_);
							_tmp1064_ = _tmp1063_;
							instance = _tmp1064_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1065_ = m;
						_tmp1066_ = vala_method_get_binding (_tmp1065_);
						_tmp1067_ = _tmp1066_;
						klass = _tmp1067_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1068_;
							ValaList* _tmp1069_;
							gint _param_size = 0;
							ValaList* _tmp1070_;
							gint _tmp1071_;
							gint _tmp1072_;
							gint _param_index = 0;
							_tmp1068_ = m;
							_tmp1069_ = vala_callable_get_parameters ((ValaCallable*) _tmp1068_);
							_param_list = _tmp1069_;
							_tmp1070_ = _param_list;
							_tmp1071_ = vala_collection_get_size ((ValaCollection*) _tmp1070_);
							_tmp1072_ = _tmp1071_;
							_param_size = _tmp1072_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1073_;
								gint _tmp1074_;
								ValaParameter* param = NULL;
								ValaList* _tmp1075_;
								gpointer _tmp1076_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1077_;
								ValaDataType* _tmp1078_;
								ValaDataType* _tmp1079_;
								gboolean _tmp1080_ = FALSE;
								ValaGenericType* _tmp1081_;
								_param_index = _param_index + 1;
								_tmp1073_ = _param_index;
								_tmp1074_ = _param_size;
								if (!(_tmp1073_ < _tmp1074_)) {
									break;
								}
								_tmp1075_ = _param_list;
								_tmp1076_ = vala_list_get (_tmp1075_, _param_index);
								param = (ValaParameter*) _tmp1076_;
								_tmp1077_ = param;
								_tmp1078_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1077_);
								_tmp1079_ = _tmp1078_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1079_) ? ((ValaGenericType*) _tmp1079_) : NULL;
								_tmp1081_ = generic_type;
								if (_tmp1081_ != NULL) {
									ValaGenericType* _tmp1082_;
									ValaTypeParameter* _tmp1083_;
									ValaTypeParameter* _tmp1084_;
									ValaSymbol* _tmp1085_;
									ValaSymbol* _tmp1086_;
									_tmp1082_ = generic_type;
									_tmp1083_ = vala_generic_type_get_type_parameter (_tmp1082_);
									_tmp1084_ = _tmp1083_;
									_tmp1085_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1084_);
									_tmp1086_ = _tmp1085_;
									_tmp1080_ = VALA_IS_TYPESYMBOL (_tmp1086_);
								} else {
									_tmp1080_ = FALSE;
								}
								if (_tmp1080_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1087_ = m;
						_tmp1088_ = vala_callable_get_return_type ((ValaCallable*) _tmp1087_);
						_tmp1089_ = _tmp1088_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1089_) ? ((ValaGenericType*) _tmp1089_) : NULL;
						_tmp1091_ = generic_type;
						if (_tmp1091_ != NULL) {
							ValaGenericType* _tmp1092_;
							ValaTypeParameter* _tmp1093_;
							ValaTypeParameter* _tmp1094_;
							ValaSymbol* _tmp1095_;
							ValaSymbol* _tmp1096_;
							_tmp1092_ = generic_type;
							_tmp1093_ = vala_generic_type_get_type_parameter (_tmp1092_);
							_tmp1094_ = _tmp1093_;
							_tmp1095_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1094_);
							_tmp1096_ = _tmp1095_;
							_tmp1090_ = VALA_IS_TYPESYMBOL (_tmp1096_);
						} else {
							_tmp1090_ = FALSE;
						}
						if (_tmp1090_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1097_;
						_tmp1097_ = member;
						if (VALA_IS_PROPERTY (_tmp1097_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1098_;
							ValaProperty* _tmp1099_;
							ValaProperty* _tmp1100_;
							ValaProperty* _tmp1101_;
							ValaProperty* _tmp1102_;
							ValaProperty* _tmp1118_;
							ValaSymbolAccessibility _tmp1119_;
							ValaSymbolAccessibility _tmp1120_;
							gboolean _tmp1121_;
							gboolean _tmp1122_;
							ValaProperty* _tmp1221_;
							ValaMemberBinding _tmp1222_;
							ValaMemberBinding _tmp1223_;
							ValaProperty* _tmp1224_;
							ValaDataType* _tmp1225_;
							ValaDataType* _tmp1226_;
							_tmp1098_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1098_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1099_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1099_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1100_ = prop;
							_tmp1101_ = vala_property_get_base_property (_tmp1100_);
							_tmp1102_ = _tmp1101_;
							if (_tmp1102_ != NULL) {
								ValaProperty* _tmp1103_;
								ValaProperty* _tmp1104_;
								ValaProperty* _tmp1105_;
								ValaProperty* _tmp1106_;
								ValaSymbol* _tmp1107_;
								ValaSymbol* _tmp1108_;
								_tmp1103_ = prop;
								_tmp1104_ = vala_property_get_base_property (_tmp1103_);
								_tmp1105_ = _tmp1104_;
								prop = _tmp1105_;
								_tmp1106_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1106_);
								_tmp1107_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1108_ = _tmp1107_;
								member = _tmp1108_;
							} else {
								ValaProperty* _tmp1109_;
								ValaProperty* _tmp1110_;
								ValaProperty* _tmp1111_;
								_tmp1109_ = prop;
								_tmp1110_ = vala_property_get_base_interface_property (_tmp1109_);
								_tmp1111_ = _tmp1110_;
								if (_tmp1111_ != NULL) {
									ValaProperty* _tmp1112_;
									ValaProperty* _tmp1113_;
									ValaProperty* _tmp1114_;
									ValaProperty* _tmp1115_;
									ValaSymbol* _tmp1116_;
									ValaSymbol* _tmp1117_;
									_tmp1112_ = prop;
									_tmp1113_ = vala_property_get_base_interface_property (_tmp1112_);
									_tmp1114_ = _tmp1113_;
									prop = _tmp1114_;
									_tmp1115_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1115_);
									_tmp1116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1117_ = _tmp1116_;
									member = _tmp1117_;
								}
							}
							_tmp1118_ = prop;
							_tmp1119_ = vala_symbol_get_access ((ValaSymbol*) _tmp1118_);
							_tmp1120_ = _tmp1119_;
							access = _tmp1120_;
							_tmp1121_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1122_ = _tmp1121_;
							if (_tmp1122_) {
								ValaProperty* _tmp1123_;
								ValaPropertyAccessor* _tmp1124_;
								ValaPropertyAccessor* _tmp1125_;
								ValaProperty* _tmp1169_;
								ValaSymbolAccessibility _tmp1170_;
								ValaSymbolAccessibility _tmp1171_;
								_tmp1123_ = prop;
								_tmp1124_ = vala_property_get_set_accessor (_tmp1123_);
								_tmp1125_ = _tmp1124_;
								if (_tmp1125_ == NULL) {
									ValaSourceReference* _tmp1126_;
									ValaSourceReference* _tmp1127_;
									ValaProperty* _tmp1128_;
									gchar* _tmp1129_;
									gchar* _tmp1130_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1127_ = _tmp1126_;
									_tmp1128_ = prop;
									_tmp1129_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1128_);
									_tmp1130_ = _tmp1129_;
									vala_report_error (_tmp1127_, "Property `%s' is read-only", _tmp1130_);
									_g_free0 (_tmp1130_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1131_ = FALSE;
									ValaProperty* _tmp1132_;
									ValaPropertyAccessor* _tmp1133_;
									ValaPropertyAccessor* _tmp1134_;
									gboolean _tmp1135_;
									gboolean _tmp1136_;
									_tmp1132_ = prop;
									_tmp1133_ = vala_property_get_set_accessor (_tmp1132_);
									_tmp1134_ = _tmp1133_;
									_tmp1135_ = vala_property_accessor_get_writable (_tmp1134_);
									_tmp1136_ = _tmp1135_;
									if (!_tmp1136_) {
										ValaProperty* _tmp1137_;
										ValaPropertyAccessor* _tmp1138_;
										ValaPropertyAccessor* _tmp1139_;
										gboolean _tmp1140_;
										gboolean _tmp1141_;
										_tmp1137_ = prop;
										_tmp1138_ = vala_property_get_set_accessor (_tmp1137_);
										_tmp1139_ = _tmp1138_;
										_tmp1140_ = vala_property_accessor_get_construction (_tmp1139_);
										_tmp1141_ = _tmp1140_;
										_tmp1131_ = _tmp1141_;
									} else {
										_tmp1131_ = FALSE;
									}
									if (_tmp1131_) {
										ValaSemanticAnalyzer* _tmp1142_;
										ValaSemanticAnalyzer* _tmp1143_;
										ValaMethod* _tmp1144_;
										_tmp1142_ = vala_code_context_get_analyzer (context);
										_tmp1143_ = _tmp1142_;
										_tmp1144_ = vala_semantic_analyzer_find_current_method (_tmp1143_);
										if (VALA_IS_CREATION_METHOD (_tmp1144_)) {
											ValaSourceReference* _tmp1145_;
											ValaSourceReference* _tmp1146_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1146_ = _tmp1145_;
											vala_report_error (_tmp1146_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1147_;
											ValaSemanticAnalyzer* _tmp1148_;
											_tmp1147_ = vala_code_context_get_analyzer (context);
											_tmp1148_ = _tmp1147_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1148_)) {
												ValaSemanticAnalyzer* _tmp1149_;
												ValaSemanticAnalyzer* _tmp1150_;
												ValaTypeSymbol* _tmp1151_;
												ValaTypeSymbol* _tmp1152_;
												ValaProperty* _tmp1153_;
												ValaSymbol* _tmp1154_;
												ValaSymbol* _tmp1155_;
												_tmp1149_ = vala_code_context_get_analyzer (context);
												_tmp1150_ = _tmp1149_;
												_tmp1151_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1150_);
												_tmp1152_ = _tmp1151_;
												_tmp1153_ = prop;
												_tmp1154_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1153_);
												_tmp1155_ = _tmp1154_;
												if (!vala_typesymbol_is_subtype_of (_tmp1152_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1155_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1156_;
													ValaSourceReference* _tmp1157_;
													ValaProperty* _tmp1158_;
													gchar* _tmp1159_;
													gchar* _tmp1160_;
													ValaSemanticAnalyzer* _tmp1161_;
													ValaSemanticAnalyzer* _tmp1162_;
													ValaTypeSymbol* _tmp1163_;
													ValaTypeSymbol* _tmp1164_;
													gchar* _tmp1165_;
													gchar* _tmp1166_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1157_ = _tmp1156_;
													_tmp1158_ = prop;
													_tmp1159_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1158_);
													_tmp1160_ = _tmp1159_;
													_tmp1161_ = vala_code_context_get_analyzer (context);
													_tmp1162_ = _tmp1161_;
													_tmp1163_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1162_);
													_tmp1164_ = _tmp1163_;
													_tmp1165_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1164_);
													_tmp1166_ = _tmp1165_;
													vala_report_error (_tmp1157_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1160_, _tmp1166_);
													_g_free0 (_tmp1166_);
													_g_free0 (_tmp1160_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1167_;
												ValaSourceReference* _tmp1168_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1167_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1168_ = _tmp1167_;
												vala_report_error (_tmp1168_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1169_ = prop;
								_tmp1170_ = vala_symbol_get_access ((ValaSymbol*) _tmp1169_);
								_tmp1171_ = _tmp1170_;
								if (_tmp1171_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1172_;
									ValaPropertyAccessor* _tmp1173_;
									ValaPropertyAccessor* _tmp1174_;
									ValaSymbolAccessibility _tmp1175_;
									ValaSymbolAccessibility _tmp1176_;
									_tmp1172_ = prop;
									_tmp1173_ = vala_property_get_set_accessor (_tmp1172_);
									_tmp1174_ = _tmp1173_;
									_tmp1175_ = vala_symbol_get_access ((ValaSymbol*) _tmp1174_);
									_tmp1176_ = _tmp1175_;
									access = _tmp1176_;
								} else {
									gboolean _tmp1177_ = FALSE;
									ValaProperty* _tmp1178_;
									ValaSymbolAccessibility _tmp1179_;
									ValaSymbolAccessibility _tmp1180_;
									_tmp1178_ = prop;
									_tmp1179_ = vala_symbol_get_access ((ValaSymbol*) _tmp1178_);
									_tmp1180_ = _tmp1179_;
									if (_tmp1180_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1181_;
										ValaPropertyAccessor* _tmp1182_;
										ValaPropertyAccessor* _tmp1183_;
										ValaSymbolAccessibility _tmp1184_;
										ValaSymbolAccessibility _tmp1185_;
										_tmp1181_ = prop;
										_tmp1182_ = vala_property_get_set_accessor (_tmp1181_);
										_tmp1183_ = _tmp1182_;
										_tmp1184_ = vala_symbol_get_access ((ValaSymbol*) _tmp1183_);
										_tmp1185_ = _tmp1184_;
										_tmp1177_ = _tmp1185_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1177_ = FALSE;
									}
									if (_tmp1177_) {
										ValaProperty* _tmp1186_;
										ValaPropertyAccessor* _tmp1187_;
										ValaPropertyAccessor* _tmp1188_;
										ValaSymbolAccessibility _tmp1189_;
										ValaSymbolAccessibility _tmp1190_;
										_tmp1186_ = prop;
										_tmp1187_ = vala_property_get_set_accessor (_tmp1186_);
										_tmp1188_ = _tmp1187_;
										_tmp1189_ = vala_symbol_get_access ((ValaSymbol*) _tmp1188_);
										_tmp1190_ = _tmp1189_;
										access = _tmp1190_;
									}
								}
							} else {
								ValaProperty* _tmp1191_;
								ValaPropertyAccessor* _tmp1192_;
								ValaPropertyAccessor* _tmp1193_;
								ValaProperty* _tmp1199_;
								ValaSymbolAccessibility _tmp1200_;
								ValaSymbolAccessibility _tmp1201_;
								_tmp1191_ = prop;
								_tmp1192_ = vala_property_get_get_accessor (_tmp1191_);
								_tmp1193_ = _tmp1192_;
								if (_tmp1193_ == NULL) {
									ValaSourceReference* _tmp1194_;
									ValaSourceReference* _tmp1195_;
									ValaProperty* _tmp1196_;
									gchar* _tmp1197_;
									gchar* _tmp1198_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1195_ = _tmp1194_;
									_tmp1196_ = prop;
									_tmp1197_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1196_);
									_tmp1198_ = _tmp1197_;
									vala_report_error (_tmp1195_, "Property `%s' is write-only", _tmp1198_);
									_g_free0 (_tmp1198_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1199_ = prop;
								_tmp1200_ = vala_symbol_get_access ((ValaSymbol*) _tmp1199_);
								_tmp1201_ = _tmp1200_;
								if (_tmp1201_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1202_;
									ValaPropertyAccessor* _tmp1203_;
									ValaPropertyAccessor* _tmp1204_;
									ValaSymbolAccessibility _tmp1205_;
									ValaSymbolAccessibility _tmp1206_;
									_tmp1202_ = prop;
									_tmp1203_ = vala_property_get_get_accessor (_tmp1202_);
									_tmp1204_ = _tmp1203_;
									_tmp1205_ = vala_symbol_get_access ((ValaSymbol*) _tmp1204_);
									_tmp1206_ = _tmp1205_;
									access = _tmp1206_;
								} else {
									gboolean _tmp1207_ = FALSE;
									ValaProperty* _tmp1208_;
									ValaSymbolAccessibility _tmp1209_;
									ValaSymbolAccessibility _tmp1210_;
									_tmp1208_ = prop;
									_tmp1209_ = vala_symbol_get_access ((ValaSymbol*) _tmp1208_);
									_tmp1210_ = _tmp1209_;
									if (_tmp1210_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1211_;
										ValaPropertyAccessor* _tmp1212_;
										ValaPropertyAccessor* _tmp1213_;
										ValaSymbolAccessibility _tmp1214_;
										ValaSymbolAccessibility _tmp1215_;
										_tmp1211_ = prop;
										_tmp1212_ = vala_property_get_get_accessor (_tmp1211_);
										_tmp1213_ = _tmp1212_;
										_tmp1214_ = vala_symbol_get_access ((ValaSymbol*) _tmp1213_);
										_tmp1215_ = _tmp1214_;
										_tmp1207_ = _tmp1215_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1207_ = FALSE;
									}
									if (_tmp1207_) {
										ValaProperty* _tmp1216_;
										ValaPropertyAccessor* _tmp1217_;
										ValaPropertyAccessor* _tmp1218_;
										ValaSymbolAccessibility _tmp1219_;
										ValaSymbolAccessibility _tmp1220_;
										_tmp1216_ = prop;
										_tmp1217_ = vala_property_get_get_accessor (_tmp1216_);
										_tmp1218_ = _tmp1217_;
										_tmp1219_ = vala_symbol_get_access ((ValaSymbol*) _tmp1218_);
										_tmp1220_ = _tmp1219_;
										access = _tmp1220_;
									}
								}
							}
							_tmp1221_ = prop;
							_tmp1222_ = vala_property_get_binding (_tmp1221_);
							_tmp1223_ = _tmp1222_;
							instance = _tmp1223_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1224_ = prop;
							_tmp1225_ = vala_property_get_property_type (_tmp1224_);
							_tmp1226_ = _tmp1225_;
							if (VALA_IS_GENERIC_TYPE (_tmp1226_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1227_;
							_tmp1227_ = member;
							if (VALA_IS_SIGNAL (_tmp1227_)) {
								ValaSymbol* _tmp1228_;
								ValaSymbolAccessibility _tmp1229_;
								ValaSymbolAccessibility _tmp1230_;
								instance = TRUE;
								_tmp1228_ = member;
								_tmp1229_ = vala_symbol_get_access (_tmp1228_);
								_tmp1230_ = _tmp1229_;
								access = _tmp1230_;
							} else {
								gboolean _tmp1231_ = FALSE;
								gboolean _tmp1232_;
								_tmp1232_ = self->priv->_creation_member;
								if (!_tmp1232_) {
									ValaSymbol* _tmp1233_;
									_tmp1233_ = member;
									_tmp1231_ = VALA_IS_ERROR_CODE (_tmp1233_);
								} else {
									_tmp1231_ = FALSE;
								}
								if (_tmp1231_) {
									ValaSymbol* _tmp1234_;
									ValaConstant* _tmp1235_;
									ValaConstant* _tmp1236_;
									ValaSymbol* _tmp1237_;
									ValaSymbol* _tmp1238_;
									_tmp1234_ = member;
									_tmp1235_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1234_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1236_ = _tmp1235_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1236_);
									_tmp1237_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1238_ = _tmp1237_;
									member = _tmp1238_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1239_;
		ValaSymbol* _tmp1240_;
		ValaCodeNode* _tmp1241_;
		ValaCodeNode* _tmp1242_;
		ValaCodeNode* _tmp1243_;
		gboolean _tmp1244_ = FALSE;
		ValaCodeNode* _tmp1245_;
		_tmp1239_ = parent;
		_tmp1240_ = member;
		if (!(_tmp1239_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1240_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1241_ = parent;
		_tmp1242_ = vala_code_node_get_parent_node (_tmp1241_);
		_tmp1243_ = _tmp1242_;
		parent = _tmp1243_;
		_tmp1245_ = parent;
		if (_tmp1245_ == NULL) {
			_tmp1244_ = TRUE;
		} else {
			ValaCodeNode* _tmp1246_;
			ValaSymbol* _tmp1247_;
			_tmp1246_ = parent;
			_tmp1247_ = member;
			_tmp1244_ = _tmp1246_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1247_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1244_) {
			break;
		}
	}
	_tmp1248_ = parent;
	_tmp1249_ = member;
	if (_tmp1248_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1249_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1250_;
		_tmp1250_ = member;
		vala_symbol_set_used (_tmp1250_, TRUE);
	}
	_tmp1251_ = member;
	_tmp1252_ = vala_symbol_get_version (_tmp1251_);
	_tmp1253_ = _tmp1252_;
	_tmp1254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1255_ = _tmp1254_;
	vala_version_attribute_check (_tmp1253_, context, _tmp1255_);
	_tmp1257_ = access;
	if (_tmp1257_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1258_;
		ValaSymbol* _tmp1259_;
		ValaSymbol* _tmp1260_;
		_tmp1258_ = member;
		_tmp1259_ = vala_symbol_get_parent_symbol (_tmp1258_);
		_tmp1260_ = _tmp1259_;
		_tmp1256_ = VALA_IS_TYPESYMBOL (_tmp1260_);
	} else {
		_tmp1256_ = FALSE;
	}
	if (_tmp1256_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1261_;
		ValaSymbol* _tmp1262_;
		ValaSymbol* _tmp1263_;
		gboolean in_subtype = FALSE;
		_tmp1261_ = member;
		_tmp1262_ = vala_symbol_get_parent_symbol (_tmp1261_);
		_tmp1263_ = _tmp1262_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1263_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1264_;
			ValaSemanticAnalyzer* _tmp1265_;
			ValaSymbol* _tmp1266_;
			ValaSymbol* _tmp1267_;
			ValaSymbol* _tmp1268_;
			_tmp1264_ = vala_code_context_get_analyzer (context);
			_tmp1265_ = _tmp1264_;
			_tmp1266_ = vala_semantic_analyzer_get_current_symbol (_tmp1265_);
			_tmp1267_ = _tmp1266_;
			_tmp1268_ = _vala_code_node_ref0 (_tmp1267_);
			this_symbol = _tmp1268_;
			{
				gboolean _tmp1269_ = FALSE;
				_tmp1269_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1274_;
					ValaSymbol* _tmp1275_;
					ValaTypeSymbol* _tmp1276_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1277_;
					gboolean _tmp1278_ = FALSE;
					ValaClass* _tmp1279_;
					if (!_tmp1269_) {
						ValaSymbol* _tmp1270_;
						ValaSymbol* _tmp1271_;
						ValaSymbol* _tmp1272_;
						ValaSymbol* _tmp1273_;
						_tmp1270_ = this_symbol;
						_tmp1271_ = vala_symbol_get_parent_symbol (_tmp1270_);
						_tmp1272_ = _tmp1271_;
						_tmp1273_ = _vala_code_node_ref0 (_tmp1272_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1273_;
					}
					_tmp1269_ = FALSE;
					_tmp1274_ = this_symbol;
					if (!(_tmp1274_ != NULL)) {
						break;
					}
					_tmp1275_ = this_symbol;
					_tmp1276_ = target_type;
					if (_tmp1275_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1276_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1277_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1277_) ? ((ValaClass*) _tmp1277_) : NULL;
					_tmp1279_ = cl;
					if (_tmp1279_ != NULL) {
						ValaClass* _tmp1280_;
						ValaTypeSymbol* _tmp1281_;
						_tmp1280_ = cl;
						_tmp1281_ = target_type;
						_tmp1278_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1280_, _tmp1281_);
					} else {
						_tmp1278_ = FALSE;
					}
					if (_tmp1278_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1282_;
			ValaSourceReference* _tmp1283_;
			ValaSymbol* _tmp1284_;
			gchar* _tmp1285_;
			gchar* _tmp1286_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1282_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1283_ = _tmp1282_;
			_tmp1284_ = member;
			_tmp1285_ = vala_symbol_get_full_name (_tmp1284_);
			_tmp1286_ = _tmp1285_;
			vala_report_error (_tmp1283_, "Access to protected member `%s' denied", _tmp1286_);
			_g_free0 (_tmp1286_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1287_;
		_tmp1287_ = access;
		if (_tmp1287_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1288_;
			ValaSymbol* _tmp1289_;
			ValaSymbol* _tmp1290_;
			gboolean in_target_type = FALSE;
			_tmp1288_ = member;
			_tmp1289_ = vala_symbol_get_parent_symbol (_tmp1288_);
			_tmp1290_ = _tmp1289_;
			target_type = _tmp1290_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1291_;
				ValaSemanticAnalyzer* _tmp1292_;
				ValaSymbol* _tmp1293_;
				ValaSymbol* _tmp1294_;
				ValaSymbol* _tmp1295_;
				_tmp1291_ = vala_code_context_get_analyzer (context);
				_tmp1292_ = _tmp1291_;
				_tmp1293_ = vala_semantic_analyzer_get_current_symbol (_tmp1292_);
				_tmp1294_ = _tmp1293_;
				_tmp1295_ = _vala_code_node_ref0 (_tmp1294_);
				this_symbol = _tmp1295_;
				{
					gboolean _tmp1296_ = FALSE;
					_tmp1296_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1301_;
						ValaSymbol* _tmp1302_;
						ValaSymbol* _tmp1303_;
						if (!_tmp1296_) {
							ValaSymbol* _tmp1297_;
							ValaSymbol* _tmp1298_;
							ValaSymbol* _tmp1299_;
							ValaSymbol* _tmp1300_;
							_tmp1297_ = this_symbol;
							_tmp1298_ = vala_symbol_get_parent_symbol (_tmp1297_);
							_tmp1299_ = _tmp1298_;
							_tmp1300_ = _vala_code_node_ref0 (_tmp1299_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1300_;
						}
						_tmp1296_ = FALSE;
						_tmp1301_ = this_symbol;
						if (!(_tmp1301_ != NULL)) {
							break;
						}
						_tmp1302_ = target_type;
						_tmp1303_ = this_symbol;
						if (_tmp1302_ == _tmp1303_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1304_;
				ValaSourceReference* _tmp1305_;
				ValaSymbol* _tmp1306_;
				gchar* _tmp1307_;
				gchar* _tmp1308_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1304_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1305_ = _tmp1304_;
				_tmp1306_ = member;
				_tmp1307_ = vala_symbol_get_full_name (_tmp1306_);
				_tmp1308_ = _tmp1307_;
				vala_report_error (_tmp1305_, "Access to private member `%s' denied", _tmp1308_);
				_g_free0 (_tmp1308_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1310_;
		ValaExpression* _tmp1311_;
		_tmp1310_ = vala_member_access_get_inner (self);
		_tmp1311_ = _tmp1310_;
		_tmp1309_ = _tmp1311_ != NULL;
	} else {
		_tmp1309_ = FALSE;
	}
	if (_tmp1309_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1312_;
		ValaExpression* _tmp1313_;
		ValaDataType* _tmp1314_;
		ValaDataType* _tmp1315_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1316_;
		ValaExpression* _tmp1317_;
		ValaDataType* _tmp1318_;
		ValaDataType* _tmp1319_;
		ValaPointerType* _tmp1320_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1324_;
		gboolean _tmp1325_ = FALSE;
		gboolean _tmp1326_ = FALSE;
		ValaObjectType* _tmp1327_;
		_tmp1312_ = vala_member_access_get_inner (self);
		_tmp1313_ = _tmp1312_;
		_tmp1314_ = vala_expression_get_value_type (_tmp1313_);
		_tmp1315_ = _tmp1314_;
		instance_type = _tmp1315_;
		_tmp1316_ = vala_member_access_get_inner (self);
		_tmp1317_ = _tmp1316_;
		_tmp1318_ = vala_expression_get_value_type (_tmp1317_);
		_tmp1319_ = _tmp1318_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1319_) ? ((ValaPointerType*) _tmp1319_) : NULL;
		_tmp1320_ = pointer_type;
		if (_tmp1320_ != NULL) {
			ValaPointerType* _tmp1321_;
			ValaDataType* _tmp1322_;
			ValaDataType* _tmp1323_;
			_tmp1321_ = pointer_type;
			_tmp1322_ = vala_pointer_type_get_base_type (_tmp1321_);
			_tmp1323_ = _tmp1322_;
			instance_type = _tmp1323_;
		}
		_tmp1324_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1324_) ? ((ValaObjectType*) _tmp1324_) : NULL;
		_tmp1327_ = object_type;
		if (_tmp1327_ != NULL) {
			ValaObjectType* _tmp1328_;
			ValaObjectTypeSymbol* _tmp1329_;
			ValaObjectTypeSymbol* _tmp1330_;
			_tmp1328_ = object_type;
			_tmp1329_ = vala_object_type_get_object_type_symbol (_tmp1328_);
			_tmp1330_ = _tmp1329_;
			_tmp1326_ = vala_object_type_symbol_has_type_parameters (_tmp1330_);
		} else {
			_tmp1326_ = FALSE;
		}
		if (_tmp1326_) {
			ValaDataType* _tmp1331_;
			_tmp1331_ = instance_type;
			_tmp1325_ = !vala_data_type_has_type_arguments (_tmp1331_);
		} else {
			_tmp1325_ = FALSE;
		}
		if (_tmp1325_) {
			ValaExpression* _tmp1332_;
			ValaExpression* _tmp1333_;
			ValaSourceReference* _tmp1334_;
			ValaSourceReference* _tmp1335_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1332_ = vala_member_access_get_inner (self);
			_tmp1333_ = _tmp1332_;
			_tmp1334_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1333_);
			_tmp1335_ = _tmp1334_;
			vala_report_error (_tmp1335_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1337_ = !may_access_instance_members;
	} else {
		_tmp1337_ = FALSE;
	}
	if (_tmp1337_) {
		_tmp1336_ = TRUE;
	} else {
		gboolean _tmp1338_ = FALSE;
		if (klass) {
			_tmp1338_ = !may_access_klass_members;
		} else {
			_tmp1338_ = FALSE;
		}
		_tmp1336_ = _tmp1338_;
	}
	if (_tmp1336_) {
		ValaSymbol* _tmp1339_;
		ValaSymbol* _tmp1340_;
		ValaDataType* _tmp1363_;
		ValaDataType* _tmp1364_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1339_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1340_ = _tmp1339_;
		if (VALA_IS_METHOD (_tmp1340_)) {
			ValaSemanticAnalyzer* _tmp1341_;
			ValaSemanticAnalyzer* _tmp1342_;
			ValaSymbol* _tmp1343_;
			ValaSymbol* _tmp1344_;
			gboolean _tmp1345_;
			gboolean _tmp1346_;
			ValaDataType* _tmp1347_;
			ValaDataType* _tmp1348_;
			_tmp1341_ = vala_code_context_get_analyzer (context);
			_tmp1342_ = _tmp1341_;
			_tmp1343_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1344_ = _tmp1343_;
			_tmp1345_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1346_ = _tmp1345_;
			_tmp1347_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1342_, _tmp1344_, _tmp1346_);
			_tmp1348_ = _tmp1347_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1348_);
			_vala_code_node_unref0 (_tmp1348_);
		} else {
			ValaSymbol* _tmp1349_;
			ValaSymbol* _tmp1350_;
			_tmp1349_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1350_ = _tmp1349_;
			if (VALA_IS_FIELD (_tmp1350_)) {
				ValaSymbol* _tmp1351_;
				ValaSymbol* _tmp1352_;
				ValaFieldPrototype* _tmp1353_;
				ValaFieldPrototype* _tmp1354_;
				_tmp1351_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1352_ = _tmp1351_;
				_tmp1353_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1352_, VALA_TYPE_FIELD, ValaField));
				_tmp1354_ = _tmp1353_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1354_);
				_vala_code_node_unref0 (_tmp1354_);
			} else {
				ValaSymbol* _tmp1355_;
				ValaSymbol* _tmp1356_;
				_tmp1355_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1356_ = _tmp1355_;
				if (VALA_IS_PROPERTY (_tmp1356_)) {
					ValaSymbol* _tmp1357_;
					ValaSymbol* _tmp1358_;
					ValaPropertyPrototype* _tmp1359_;
					ValaPropertyPrototype* _tmp1360_;
					_tmp1357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1358_ = _tmp1357_;
					_tmp1359_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1358_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1360_ = _tmp1359_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1360_);
					_vala_code_node_unref0 (_tmp1360_);
				} else {
					ValaInvalidType* _tmp1361_;
					ValaInvalidType* _tmp1362_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1361_ = vala_invalid_type_new ();
					_tmp1362_ = _tmp1361_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1362_);
					_vala_code_node_unref0 (_tmp1362_);
				}
			}
		}
		_tmp1363_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1364_ = _tmp1363_;
		if (_tmp1364_ != NULL) {
			ValaDataType* _tmp1365_;
			ValaDataType* _tmp1366_;
			ValaDataType* _tmp1367_;
			ValaDataType* _tmp1368_;
			gboolean _tmp1369_;
			gboolean _tmp1370_;
			_tmp1365_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1366_ = _tmp1365_;
			_tmp1367_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1368_ = _tmp1367_;
			_tmp1369_ = vala_data_type_get_value_owned (_tmp1368_);
			_tmp1370_ = _tmp1369_;
			vala_data_type_set_value_owned (_tmp1366_, _tmp1370_);
		}
	} else {
		gboolean _tmp1371_ = FALSE;
		gboolean _tmp1392_ = FALSE;
		gboolean _tmp1393_ = FALSE;
		gboolean _tmp1394_ = FALSE;
		gboolean _tmp1395_ = FALSE;
		gboolean _tmp1436_ = FALSE;
		gboolean _tmp1437_ = FALSE;
		gboolean _tmp1438_ = FALSE;
		gboolean _tmp1439_ = FALSE;
		gboolean _tmp1440_ = FALSE;
		gboolean _tmp1441_;
		gboolean _tmp1442_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1467_;
		ValaSymbol* _tmp1468_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1469_;
		ValaExpression* _tmp1470_;
		gboolean _tmp1471_ = FALSE;
		gboolean _tmp1472_ = FALSE;
		gboolean _tmp1473_ = FALSE;
		gboolean _tmp1474_ = FALSE;
		gboolean _tmp1475_ = FALSE;
		ValaMethod* _tmp1476_;
		ValaSemanticAnalyzer* _tmp1514_;
		ValaSemanticAnalyzer* _tmp1515_;
		ValaSymbol* _tmp1516_;
		ValaSymbol* _tmp1517_;
		gboolean _tmp1518_;
		gboolean _tmp1519_;
		ValaDataType* _tmp1520_;
		ValaDataType* _tmp1521_;
		gboolean _tmp1522_ = FALSE;
		ValaExpression* _tmp1523_;
		ValaExpression* _tmp1524_;
		ValaSymbol* _tmp1537_;
		ValaSymbol* _tmp1538_;
		gboolean _tmp1612_ = FALSE;
		gboolean _tmp1613_ = FALSE;
		ValaExpression* _tmp1614_;
		ValaExpression* _tmp1615_;
		if (instance) {
			ValaExpression* _tmp1372_;
			ValaExpression* _tmp1373_;
			_tmp1372_ = vala_member_access_get_inner (self);
			_tmp1373_ = _tmp1372_;
			_tmp1371_ = _tmp1373_ == NULL;
		} else {
			_tmp1371_ = FALSE;
		}
		if (_tmp1371_) {
			ValaSourceReference* _tmp1374_;
			ValaSourceReference* _tmp1375_;
			ValaMemberAccess* _tmp1376_;
			ValaMemberAccess* _tmp1377_;
			ValaExpression* _tmp1378_;
			ValaExpression* _tmp1379_;
			ValaParameter* _tmp1380_;
			ValaDataType* _tmp1381_;
			ValaDataType* _tmp1382_;
			ValaDataType* _tmp1383_;
			ValaDataType* _tmp1384_;
			ValaExpression* _tmp1385_;
			ValaExpression* _tmp1386_;
			ValaDataType* _tmp1387_;
			ValaDataType* _tmp1388_;
			ValaExpression* _tmp1389_;
			ValaExpression* _tmp1390_;
			ValaParameter* _tmp1391_;
			_tmp1374_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1375_ = _tmp1374_;
			_tmp1376_ = vala_member_access_new (NULL, "this", _tmp1375_);
			_tmp1377_ = _tmp1376_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1377_);
			_vala_code_node_unref0 (_tmp1377_);
			_tmp1378_ = vala_member_access_get_inner (self);
			_tmp1379_ = _tmp1378_;
			_tmp1380_ = this_parameter;
			_tmp1381_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1380_);
			_tmp1382_ = _tmp1381_;
			_tmp1383_ = vala_data_type_copy (_tmp1382_);
			_tmp1384_ = _tmp1383_;
			vala_expression_set_value_type (_tmp1379_, _tmp1384_);
			_vala_code_node_unref0 (_tmp1384_);
			_tmp1385_ = vala_member_access_get_inner (self);
			_tmp1386_ = _tmp1385_;
			_tmp1387_ = vala_expression_get_value_type (_tmp1386_);
			_tmp1388_ = _tmp1387_;
			vala_data_type_set_value_owned (_tmp1388_, FALSE);
			_tmp1389_ = vala_member_access_get_inner (self);
			_tmp1390_ = _tmp1389_;
			_tmp1391_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1390_, (ValaSymbol*) _tmp1391_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1395_ = !klass;
		} else {
			_tmp1395_ = FALSE;
		}
		if (_tmp1395_) {
			ValaSymbol* _tmp1396_;
			ValaSymbol* _tmp1397_;
			_tmp1396_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1397_ = _tmp1396_;
			_tmp1394_ = !VALA_IS_CREATION_METHOD (_tmp1397_);
		} else {
			_tmp1394_ = FALSE;
		}
		if (_tmp1394_) {
			_tmp1393_ = may_access_instance_members;
		} else {
			_tmp1393_ = FALSE;
		}
		if (_tmp1393_) {
			ValaExpression* _tmp1398_;
			ValaExpression* _tmp1399_;
			_tmp1398_ = vala_member_access_get_inner (self);
			_tmp1399_ = _tmp1398_;
			_tmp1392_ = _tmp1399_ != NULL;
		} else {
			_tmp1392_ = FALSE;
		}
		if (_tmp1392_) {
			ValaExpression* _tmp1400_;
			ValaExpression* _tmp1401_;
			ValaSymbol* _tmp1402_;
			ValaSymbol* _tmp1403_;
			_tmp1400_ = vala_member_access_get_inner (self);
			_tmp1401_ = _tmp1400_;
			_tmp1402_ = vala_expression_get_symbol_reference (_tmp1401_);
			_tmp1403_ = _tmp1402_;
			if (VALA_IS_METHOD (_tmp1403_)) {
			} else {
				ValaSourceReference* _tmp1404_;
				ValaSourceReference* _tmp1405_;
				ValaSymbol* _tmp1406_;
				ValaSymbol* _tmp1407_;
				gchar* _tmp1408_;
				gchar* _tmp1409_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1410_;
				ValaSymbol* _tmp1411_;
				ValaSymbol* _tmp1412_;
				ValaSymbol* _tmp1413_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1433_;
				ValaExpression* _tmp1434_;
				ValaExpression* _tmp1435_;
				_tmp1404_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1405_ = _tmp1404_;
				_tmp1406_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1407_ = _tmp1406_;
				_tmp1408_ = vala_symbol_get_full_name (_tmp1407_);
				_tmp1409_ = _tmp1408_;
				vala_report_warning (_tmp1405_, "Access to static member `%s' with an instance reference", _tmp1409_);
				_g_free0 (_tmp1409_);
				_tmp1410_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1411_ = _tmp1410_;
				_tmp1412_ = vala_symbol_get_parent_symbol (_tmp1411_);
				_tmp1413_ = _tmp1412_;
				inner_sym = _tmp1413_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1414_ = FALSE;
					ValaSymbol* _tmp1415_;
					ValaMemberAccess* _tmp1419_;
					ValaSymbol* _tmp1420_;
					const gchar* _tmp1421_;
					const gchar* _tmp1422_;
					ValaSourceReference* _tmp1423_;
					ValaSourceReference* _tmp1424_;
					ValaMemberAccess* _tmp1425_;
					ValaMemberAccess* _tmp1426_;
					ValaMemberAccess* _tmp1427_;
					ValaExpression* _tmp1428_;
					ValaExpression* _tmp1429_;
					ValaSymbol* _tmp1430_;
					ValaSymbol* _tmp1431_;
					ValaSymbol* _tmp1432_;
					_tmp1415_ = inner_sym;
					if (_tmp1415_ != NULL) {
						ValaSymbol* _tmp1416_;
						const gchar* _tmp1417_;
						const gchar* _tmp1418_;
						_tmp1416_ = inner_sym;
						_tmp1417_ = vala_symbol_get_name (_tmp1416_);
						_tmp1418_ = _tmp1417_;
						_tmp1414_ = _tmp1418_ != NULL;
					} else {
						_tmp1414_ = FALSE;
					}
					if (!_tmp1414_) {
						break;
					}
					_tmp1419_ = inner_ma;
					_tmp1420_ = inner_sym;
					_tmp1421_ = vala_symbol_get_name (_tmp1420_);
					_tmp1422_ = _tmp1421_;
					_tmp1423_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1424_ = _tmp1423_;
					_tmp1425_ = vala_member_access_new (NULL, _tmp1422_, _tmp1424_);
					_tmp1426_ = _tmp1425_;
					vala_member_access_set_inner (_tmp1419_, (ValaExpression*) _tmp1426_);
					_vala_code_node_unref0 (_tmp1426_);
					_tmp1427_ = inner_ma;
					_tmp1428_ = vala_member_access_get_inner (_tmp1427_);
					_tmp1429_ = _tmp1428_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1429_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1430_ = inner_sym;
					_tmp1431_ = vala_symbol_get_parent_symbol (_tmp1430_);
					_tmp1432_ = _tmp1431_;
					inner_sym = _tmp1432_;
				}
				_tmp1433_ = inner_ma;
				vala_member_access_set_qualified (_tmp1433_, TRUE);
				_tmp1434_ = vala_member_access_get_inner (self);
				_tmp1435_ = _tmp1434_;
				vala_code_node_check ((ValaCodeNode*) _tmp1435_, context);
			}
		}
		_tmp1441_ = vala_code_context_get_experimental_non_null (context);
		_tmp1442_ = _tmp1441_;
		if (_tmp1442_) {
			_tmp1440_ = instance;
		} else {
			_tmp1440_ = FALSE;
		}
		if (_tmp1440_) {
			ValaExpression* _tmp1443_;
			ValaExpression* _tmp1444_;
			ValaDataType* _tmp1445_;
			ValaDataType* _tmp1446_;
			gboolean _tmp1447_;
			gboolean _tmp1448_;
			_tmp1443_ = vala_member_access_get_inner (self);
			_tmp1444_ = _tmp1443_;
			_tmp1445_ = vala_expression_get_value_type (_tmp1444_);
			_tmp1446_ = _tmp1445_;
			_tmp1447_ = vala_data_type_get_nullable (_tmp1446_);
			_tmp1448_ = _tmp1447_;
			_tmp1439_ = _tmp1448_;
		} else {
			_tmp1439_ = FALSE;
		}
		if (_tmp1439_) {
			ValaExpression* _tmp1449_;
			ValaExpression* _tmp1450_;
			ValaDataType* _tmp1451_;
			ValaDataType* _tmp1452_;
			_tmp1449_ = vala_member_access_get_inner (self);
			_tmp1450_ = _tmp1449_;
			_tmp1451_ = vala_expression_get_value_type (_tmp1450_);
			_tmp1452_ = _tmp1451_;
			_tmp1438_ = !VALA_IS_POINTER_TYPE (_tmp1452_);
		} else {
			_tmp1438_ = FALSE;
		}
		if (_tmp1438_) {
			ValaExpression* _tmp1453_;
			ValaExpression* _tmp1454_;
			ValaDataType* _tmp1455_;
			ValaDataType* _tmp1456_;
			_tmp1453_ = vala_member_access_get_inner (self);
			_tmp1454_ = _tmp1453_;
			_tmp1455_ = vala_expression_get_value_type (_tmp1454_);
			_tmp1456_ = _tmp1455_;
			_tmp1437_ = !VALA_IS_GENERIC_TYPE (_tmp1456_);
		} else {
			_tmp1437_ = FALSE;
		}
		if (_tmp1437_) {
			ValaExpression* _tmp1457_;
			ValaExpression* _tmp1458_;
			ValaDataType* _tmp1459_;
			ValaDataType* _tmp1460_;
			_tmp1457_ = vala_member_access_get_inner (self);
			_tmp1458_ = _tmp1457_;
			_tmp1459_ = vala_expression_get_value_type (_tmp1458_);
			_tmp1460_ = _tmp1459_;
			_tmp1436_ = !VALA_IS_ARRAY_TYPE (_tmp1460_);
		} else {
			_tmp1436_ = FALSE;
		}
		if (_tmp1436_) {
			ValaSourceReference* _tmp1461_;
			ValaSourceReference* _tmp1462_;
			ValaSymbol* _tmp1463_;
			ValaSymbol* _tmp1464_;
			gchar* _tmp1465_;
			gchar* _tmp1466_;
			_tmp1461_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1462_ = _tmp1461_;
			_tmp1463_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1464_ = _tmp1463_;
			_tmp1465_ = vala_symbol_get_full_name (_tmp1464_);
			_tmp1466_ = _tmp1465_;
			vala_report_error (_tmp1462_, "Access to instance member `%s' from nullable reference denied", _tmp1466_);
			_g_free0 (_tmp1466_);
		}
		_tmp1467_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1468_ = _tmp1467_;
		m = VALA_IS_METHOD (_tmp1468_) ? ((ValaMethod*) _tmp1468_) : NULL;
		_tmp1469_ = vala_member_access_get_inner (self);
		_tmp1470_ = _tmp1469_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1470_) ? ((ValaMemberAccess*) _tmp1470_) : NULL;
		_tmp1476_ = m;
		if (_tmp1476_ != NULL) {
			ValaMethod* _tmp1477_;
			ValaMemberBinding _tmp1478_;
			ValaMemberBinding _tmp1479_;
			_tmp1477_ = m;
			_tmp1478_ = vala_method_get_binding (_tmp1477_);
			_tmp1479_ = _tmp1478_;
			_tmp1475_ = _tmp1479_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1475_ = FALSE;
		}
		if (_tmp1475_) {
			ValaMethod* _tmp1480_;
			ValaSymbol* _tmp1481_;
			ValaSymbol* _tmp1482_;
			_tmp1480_ = m;
			_tmp1481_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1480_);
			_tmp1482_ = _tmp1481_;
			_tmp1474_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1482_);
		} else {
			_tmp1474_ = FALSE;
		}
		if (_tmp1474_) {
			ValaExpression* _tmp1483_;
			ValaExpression* _tmp1484_;
			_tmp1483_ = vala_member_access_get_inner (self);
			_tmp1484_ = _tmp1483_;
			_tmp1473_ = _tmp1484_ != NULL;
		} else {
			_tmp1473_ = FALSE;
		}
		if (_tmp1473_) {
			ValaExpression* _tmp1485_;
			ValaExpression* _tmp1486_;
			ValaDataType* _tmp1487_;
			ValaDataType* _tmp1488_;
			_tmp1485_ = vala_member_access_get_inner (self);
			_tmp1486_ = _tmp1485_;
			_tmp1487_ = vala_expression_get_value_type (_tmp1486_);
			_tmp1488_ = _tmp1487_;
			_tmp1472_ = _tmp1488_ == NULL;
		} else {
			_tmp1472_ = FALSE;
		}
		if (_tmp1472_) {
			ValaMemberAccess* _tmp1489_;
			ValaList* _tmp1490_;
			gint _tmp1491_;
			gint _tmp1492_;
			_tmp1489_ = inner_ma;
			_tmp1490_ = _tmp1489_->priv->type_argument_list;
			_tmp1491_ = vala_collection_get_size ((ValaCollection*) _tmp1490_);
			_tmp1492_ = _tmp1491_;
			_tmp1471_ = _tmp1492_ > 0;
		} else {
			_tmp1471_ = FALSE;
		}
		if (_tmp1471_) {
			ValaExpression* _tmp1493_;
			ValaExpression* _tmp1494_;
			ValaMethod* _tmp1495_;
			ValaSymbol* _tmp1496_;
			ValaSymbol* _tmp1497_;
			ValaObjectType* _tmp1498_;
			ValaObjectType* _tmp1499_;
			_tmp1493_ = vala_member_access_get_inner (self);
			_tmp1494_ = _tmp1493_;
			_tmp1495_ = m;
			_tmp1496_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1495_);
			_tmp1497_ = _tmp1496_;
			_tmp1498_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1497_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1499_ = _tmp1498_;
			vala_expression_set_value_type (_tmp1494_, (ValaDataType*) _tmp1499_);
			_vala_code_node_unref0 (_tmp1499_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1500_;
				ValaList* _tmp1501_;
				gint _type_argument_size = 0;
				ValaList* _tmp1502_;
				gint _tmp1503_;
				gint _tmp1504_;
				gint _type_argument_index = 0;
				_tmp1500_ = inner_ma;
				_tmp1501_ = _tmp1500_->priv->type_argument_list;
				_type_argument_list = _tmp1501_;
				_tmp1502_ = _type_argument_list;
				_tmp1503_ = vala_collection_get_size ((ValaCollection*) _tmp1502_);
				_tmp1504_ = _tmp1503_;
				_type_argument_size = _tmp1504_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1505_;
					gint _tmp1506_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1507_;
					gpointer _tmp1508_;
					ValaExpression* _tmp1509_;
					ValaExpression* _tmp1510_;
					ValaDataType* _tmp1511_;
					ValaDataType* _tmp1512_;
					ValaDataType* _tmp1513_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1505_ = _type_argument_index;
					_tmp1506_ = _type_argument_size;
					if (!(_tmp1505_ < _tmp1506_)) {
						break;
					}
					_tmp1507_ = _type_argument_list;
					_tmp1508_ = vala_list_get (_tmp1507_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1508_;
					_tmp1509_ = vala_member_access_get_inner (self);
					_tmp1510_ = _tmp1509_;
					_tmp1511_ = vala_expression_get_value_type (_tmp1510_);
					_tmp1512_ = _tmp1511_;
					_tmp1513_ = type_argument;
					vala_data_type_add_type_argument (_tmp1512_, _tmp1513_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1514_ = vala_code_context_get_analyzer (context);
		_tmp1515_ = _tmp1514_;
		_tmp1516_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1517_ = _tmp1516_;
		_tmp1518_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1519_ = _tmp1518_;
		_tmp1520_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1515_, _tmp1517_, _tmp1519_);
		_tmp1521_ = _tmp1520_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1521_);
		_vala_code_node_unref0 (_tmp1521_);
		_tmp1523_ = vala_member_access_get_inner (self);
		_tmp1524_ = _tmp1523_;
		if (_tmp1524_ != NULL) {
			ValaDataType* _tmp1525_;
			ValaDataType* _tmp1526_;
			_tmp1525_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1526_ = _tmp1525_;
			_tmp1522_ = _tmp1526_ != NULL;
		} else {
			_tmp1522_ = FALSE;
		}
		if (_tmp1522_) {
			ValaDataType* _tmp1527_;
			ValaDataType* _tmp1528_;
			ValaExpression* _tmp1529_;
			ValaExpression* _tmp1530_;
			ValaDataType* _tmp1531_;
			ValaDataType* _tmp1532_;
			ValaDataType* _tmp1533_;
			ValaDataType* _tmp1534_;
			_tmp1527_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1528_ = _tmp1527_;
			_tmp1529_ = vala_member_access_get_inner (self);
			_tmp1530_ = _tmp1529_;
			_tmp1531_ = vala_expression_get_value_type (_tmp1530_);
			_tmp1532_ = _tmp1531_;
			_tmp1533_ = vala_data_type_get_actual_type (_tmp1528_, _tmp1532_, NULL, (ValaCodeNode*) self);
			_tmp1534_ = _tmp1533_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1534_);
			_vala_code_node_unref0 (_tmp1534_);
		} else {
			ValaDataType* _tmp1535_;
			ValaDataType* _tmp1536_;
			_tmp1535_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1536_ = _tmp1535_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1536_);
		}
		_tmp1537_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1538_ = _tmp1537_;
		if (VALA_IS_METHOD (_tmp1538_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1539_;
			ValaSymbol* _tmp1540_;
			ValaDataType* _tmp1541_;
			ValaDataType* _tmp1542_;
			gboolean _tmp1549_ = FALSE;
			_tmp1539_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1540_ = _tmp1539_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1540_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1541_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1542_ = _tmp1541_;
			if (_tmp1542_ != NULL) {
				ValaDataType* _tmp1543_;
				ValaDataType* _tmp1544_;
				ValaDataType* _tmp1545_;
				ValaDataType* _tmp1546_;
				gboolean _tmp1547_;
				gboolean _tmp1548_;
				_tmp1543_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1544_ = _tmp1543_;
				_tmp1545_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1546_ = _tmp1545_;
				_tmp1547_ = vala_data_type_get_value_owned (_tmp1546_);
				_tmp1548_ = _tmp1547_;
				vala_data_type_set_value_owned (_tmp1544_, _tmp1548_);
			}
			if (instance) {
				ValaMethod* _tmp1550_;
				ValaSymbol* _tmp1551_;
				ValaSymbol* _tmp1552_;
				_tmp1550_ = method;
				_tmp1551_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1550_);
				_tmp1552_ = _tmp1551_;
				_tmp1549_ = VALA_IS_TYPESYMBOL (_tmp1552_);
			} else {
				_tmp1549_ = FALSE;
			}
			if (_tmp1549_) {
				ValaExpression* _tmp1553_;
				ValaExpression* _tmp1554_;
				ValaMethod* _tmp1555_;
				ValaSymbol* _tmp1556_;
				ValaSymbol* _tmp1557_;
				ValaDataType* _tmp1558_;
				ValaDataType* _tmp1559_;
				ValaExpression* _tmp1560_;
				ValaExpression* _tmp1561_;
				ValaDataType* _tmp1562_;
				ValaDataType* _tmp1563_;
				ValaMethod* _tmp1564_;
				ValaParameter* _tmp1565_;
				ValaParameter* _tmp1566_;
				ValaDataType* _tmp1567_;
				ValaDataType* _tmp1568_;
				gboolean _tmp1569_;
				gboolean _tmp1570_;
				_tmp1553_ = vala_member_access_get_inner (self);
				_tmp1554_ = _tmp1553_;
				_tmp1555_ = method;
				_tmp1556_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1555_);
				_tmp1557_ = _tmp1556_;
				_tmp1558_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1557_);
				_tmp1559_ = _tmp1558_;
				vala_expression_set_target_type (_tmp1554_, _tmp1559_);
				_vala_code_node_unref0 (_tmp1559_);
				_tmp1560_ = vala_member_access_get_inner (self);
				_tmp1561_ = _tmp1560_;
				_tmp1562_ = vala_expression_get_target_type (_tmp1561_);
				_tmp1563_ = _tmp1562_;
				_tmp1564_ = method;
				_tmp1565_ = vala_method_get_this_parameter (_tmp1564_);
				_tmp1566_ = _tmp1565_;
				_tmp1567_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1566_);
				_tmp1568_ = _tmp1567_;
				_tmp1569_ = vala_data_type_get_value_owned (_tmp1568_);
				_tmp1570_ = _tmp1569_;
				vala_data_type_set_value_owned (_tmp1563_, _tmp1570_);
			}
		} else {
			gboolean _tmp1571_ = FALSE;
			gboolean _tmp1572_ = FALSE;
			ValaSymbol* _tmp1573_;
			ValaSymbol* _tmp1574_;
			_tmp1573_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1574_ = _tmp1573_;
			if (VALA_IS_PROPERTY (_tmp1574_)) {
				_tmp1572_ = instance;
			} else {
				_tmp1572_ = FALSE;
			}
			if (_tmp1572_) {
				ValaSymbol* _tmp1575_;
				ValaSymbol* _tmp1576_;
				ValaSymbol* _tmp1577_;
				ValaSymbol* _tmp1578_;
				_tmp1575_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1576_ = _tmp1575_;
				_tmp1577_ = vala_symbol_get_parent_symbol (_tmp1576_);
				_tmp1578_ = _tmp1577_;
				_tmp1571_ = _tmp1578_ != NULL;
			} else {
				_tmp1571_ = FALSE;
			}
			if (_tmp1571_) {
				ValaExpression* _tmp1579_;
				ValaExpression* _tmp1580_;
				ValaSymbol* _tmp1581_;
				ValaSymbol* _tmp1582_;
				ValaSymbol* _tmp1583_;
				ValaSymbol* _tmp1584_;
				ValaDataType* _tmp1585_;
				ValaDataType* _tmp1586_;
				_tmp1579_ = vala_member_access_get_inner (self);
				_tmp1580_ = _tmp1579_;
				_tmp1581_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1582_ = _tmp1581_;
				_tmp1583_ = vala_symbol_get_parent_symbol (_tmp1582_);
				_tmp1584_ = _tmp1583_;
				_tmp1585_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1584_);
				_tmp1586_ = _tmp1585_;
				vala_expression_set_target_type (_tmp1580_, _tmp1586_);
				_vala_code_node_unref0 (_tmp1586_);
			} else {
				gboolean _tmp1587_ = FALSE;
				gboolean _tmp1588_ = FALSE;
				gboolean _tmp1589_ = FALSE;
				ValaSymbol* _tmp1590_;
				ValaSymbol* _tmp1591_;
				_tmp1590_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1591_ = _tmp1590_;
				if (VALA_IS_FIELD (_tmp1591_)) {
					_tmp1589_ = TRUE;
				} else {
					ValaSymbol* _tmp1592_;
					ValaSymbol* _tmp1593_;
					_tmp1592_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1593_ = _tmp1592_;
					_tmp1589_ = VALA_IS_SIGNAL (_tmp1593_);
				}
				if (_tmp1589_) {
					_tmp1588_ = instance;
				} else {
					_tmp1588_ = FALSE;
				}
				if (_tmp1588_) {
					ValaSymbol* _tmp1594_;
					ValaSymbol* _tmp1595_;
					ValaSymbol* _tmp1596_;
					ValaSymbol* _tmp1597_;
					_tmp1594_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1595_ = _tmp1594_;
					_tmp1596_ = vala_symbol_get_parent_symbol (_tmp1595_);
					_tmp1597_ = _tmp1596_;
					_tmp1587_ = _tmp1597_ != NULL;
				} else {
					_tmp1587_ = FALSE;
				}
				if (_tmp1587_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1598_;
					ValaSymbol* _tmp1599_;
					ValaSymbol* _tmp1600_;
					ValaSymbol* _tmp1601_;
					ValaDataType* _tmp1602_;
					ValaExpression* _tmp1603_;
					ValaExpression* _tmp1604_;
					ValaDataType* _tmp1605_;
					ValaExpression* _tmp1606_;
					ValaExpression* _tmp1607_;
					ValaDataType* _tmp1608_;
					ValaDataType* _tmp1609_;
					ValaDataType* _tmp1610_;
					ValaDataType* _tmp1611_;
					_tmp1598_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1599_ = _tmp1598_;
					_tmp1600_ = vala_symbol_get_parent_symbol (_tmp1599_);
					_tmp1601_ = _tmp1600_;
					_tmp1602_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1601_);
					parent_type = _tmp1602_;
					_tmp1603_ = vala_member_access_get_inner (self);
					_tmp1604_ = _tmp1603_;
					_tmp1605_ = parent_type;
					_tmp1606_ = vala_member_access_get_inner (self);
					_tmp1607_ = _tmp1606_;
					_tmp1608_ = vala_expression_get_value_type (_tmp1607_);
					_tmp1609_ = _tmp1608_;
					_tmp1610_ = vala_data_type_get_actual_type (_tmp1605_, _tmp1609_, NULL, (ValaCodeNode*) self);
					_tmp1611_ = _tmp1610_;
					vala_expression_set_target_type (_tmp1604_, _tmp1611_);
					_vala_code_node_unref0 (_tmp1611_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1614_ = vala_member_access_get_inner (self);
		_tmp1615_ = _tmp1614_;
		if (_tmp1615_ == NULL) {
			ValaDataType* _tmp1616_;
			ValaDataType* _tmp1617_;
			_tmp1616_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1617_ = _tmp1616_;
			_tmp1613_ = _tmp1617_ != NULL;
		} else {
			_tmp1613_ = FALSE;
		}
		if (_tmp1613_) {
			ValaProfile _tmp1618_;
			ValaProfile _tmp1619_;
			_tmp1618_ = vala_code_context_get_profile (context);
			_tmp1619_ = _tmp1618_;
			_tmp1612_ = _tmp1619_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1612_ = FALSE;
		}
		if (_tmp1612_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1620_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1621_ = _tmp1620_;
	if (_tmp1621_ != NULL) {
		ValaDataType* _tmp1622_;
		ValaDataType* _tmp1623_;
		_tmp1622_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1623_ = _tmp1622_;
		vala_code_node_check ((ValaCodeNode*) _tmp1623_, context);
	}
	_tmp1624_ = self->priv->_tainted_access;
	if (!_tmp1624_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1625_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1626_ = _tmp1625_;
	result = !_tmp1626_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

