/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_partial;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_opaque;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static guint _vala_symbol_hash_func_ghash_func (gconstpointer key);
static gboolean _vala_symbol_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_partial (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_partial;
	return result;
}

void
vala_class_set_is_partial (ValaClass* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_partial = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

gboolean
vala_class_get_is_opaque (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_opaque;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "Compact", "opaque", FALSE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_opaque);
		self->priv->_is_opaque = _tmp2_;
	}
	_tmp3_ = self->priv->_is_opaque;
	result = *_tmp3_;
	return result;
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

static guint
_vala_symbol_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_symbol_hash_func ((ValaSymbol*) key);
	return result;
}

static gboolean
_vala_symbol_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = vala_symbol_equal_func ((ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp25_ = FALSE;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		ValaScope* _tmp17_;
		ValaScope* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValaParameter* _tmp23_;
		ValaParameter* _tmp24_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_parameter_new ("this", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		vala_method_set_this_parameter (m, _tmp16_);
		_vala_code_node_unref0 (_tmp16_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_method_get_this_parameter (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_method_get_this_parameter (m);
		_tmp24_ = _tmp23_;
		vala_scope_add (_tmp18_, _tmp22_, (ValaSymbol*) _tmp24_);
	}
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp27_ = _tmp26_;
	if (!VALA_IS_VOID_TYPE (_tmp27_)) {
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp28_ = vala_method_get_postconditions (m);
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp25_ = _tmp30_ > 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		ValaLocalVariable* _tmp48_;
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		if (_tmp32_ != NULL) {
			ValaScope* _tmp33_;
			ValaScope* _tmp34_;
			ValaLocalVariable* _tmp35_;
			ValaLocalVariable* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp33_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			vala_scope_remove (_tmp34_, _tmp38_);
		}
		_tmp39_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_copy (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_local_variable_new (_tmp42_, "result", NULL, _tmp44_);
		_tmp46_ = _tmp45_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp46_);
		_vala_code_node_unref0 (_tmp46_);
		_vala_code_node_unref0 (_tmp42_);
		_tmp47_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp48_ = _tmp47_;
		vala_local_variable_set_is_result (_tmp48_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp49_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp50_ = _tmp49_;
		if (_tmp50_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp61_, "missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp16_;
	ValaField* _tmp17_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		vala_property_set_this_parameter (prop, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_property_get_this_parameter (prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp16_ = vala_property_get_field (prop);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaField* _tmp18_;
		ValaField* _tmp19_;
		_tmp18_ = vala_property_get_field (prop);
		_tmp19_ = _tmp18_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp19_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_constructor_set_this_parameter (c, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constructor_get_this_parameter (c);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_constructor_get_this_parameter (c);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_destructor_set_this_parameter (d, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_destructor_get_this_parameter (d);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_destructor_get_this_parameter (d);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp10_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp14_;
	ValaConstructor* _tmp17_;
	ValaConstructor* _tmp18_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp22_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp26_;
	ValaDestructor* _tmp29_;
	ValaDestructor* _tmp30_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp9_ = vala_class_get_constructor (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaConstructor* _tmp11_;
		ValaConstructor* _tmp12_;
		_tmp11_ = vala_class_get_constructor (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	}
	_tmp13_ = vala_class_get_class_constructor (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaConstructor* _tmp15_;
		ValaConstructor* _tmp16_;
		_tmp15_ = vala_class_get_class_constructor (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
	_tmp17_ = vala_class_get_static_constructor (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaConstructor* _tmp19_;
		ValaConstructor* _tmp20_;
		_tmp19_ = vala_class_get_static_constructor (self);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
	_tmp21_ = vala_class_get_destructor (self);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaDestructor* _tmp23_;
		ValaDestructor* _tmp24_;
		_tmp23_ = vala_class_get_destructor (self);
		_tmp24_ = _tmp23_;
		vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
	}
	_tmp25_ = vala_class_get_static_destructor (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaDestructor* _tmp27_;
		ValaDestructor* _tmp28_;
		_tmp27_ = vala_class_get_static_destructor (self);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
	}
	_tmp29_ = vala_class_get_class_destructor (self);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		ValaDestructor* _tmp31_;
		ValaDestructor* _tmp32_;
		_tmp31_ = vala_class_get_class_destructor (self);
		_tmp32_ = _tmp31_;
		vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp18_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_prereq_index = _prereq_index + 1;
			_tmp4_ = _prereq_index;
			_tmp5_ = _prereq_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prereq_list;
			_tmp7_ = vala_list_get (_tmp6_, _prereq_index);
			prereq = (ValaDataType*) _tmp7_;
			_tmp8_ = prereq;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			type = _tmp11_;
			_tmp12_ = type;
			if (_tmp12_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp13_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp13_);
			_tmp14_ = type;
			if (VALA_IS_INTERFACE (_tmp14_)) {
				ValaTypeSymbol* _tmp15_;
				_tmp15_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_CLASS (_tmp10_)) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = base_type;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			} else {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = base_type;
				_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp71_ = FALSE;
	ValaClass* _tmp72_;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp93_ = FALSE;
	gboolean _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp109_;
	gboolean _tmp110_;
	gboolean _tmp121_;
	ValaConstructor* _tmp236_;
	ValaConstructor* _tmp237_;
	ValaConstructor* _tmp240_;
	ValaConstructor* _tmp241_;
	ValaConstructor* _tmp244_;
	ValaConstructor* _tmp245_;
	ValaDestructor* _tmp248_;
	ValaDestructor* _tmp249_;
	ValaDestructor* _tmp252_;
	ValaDestructor* _tmp253_;
	ValaDestructor* _tmp256_;
	ValaDestructor* _tmp257_;
	gboolean _tmp296_;
	gboolean _tmp297_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp338_;
	ValaArrayList* _tmp339_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp355_;
	ValaArrayList* _tmp356_;
	ValaList* _tmp370_;
	gint _tmp371_;
	gint _tmp372_;
	ValaSourceFileType _tmp396_;
	ValaSourceFileType _tmp397_;
	ValaSemanticAnalyzer* _tmp614_;
	ValaSemanticAnalyzer* _tmp615_;
	ValaSourceFile* _tmp616_;
	ValaSemanticAnalyzer* _tmp617_;
	ValaSemanticAnalyzer* _tmp618_;
	ValaSymbol* _tmp619_;
	gboolean _tmp620_;
	gboolean _tmp621_;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_class_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp41_;
			ValaDataType* _tmp49_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp28_ = _base_type_reference_index;
			_tmp29_ = _base_type_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _base_type_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp32_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp33_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp33_)) {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaDataType* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = base_type_reference;
				_tmp37_ = vala_code_node_to_string ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp35_, "base type `%s' of class `%s' is not an object type", _tmp38_, _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = base_type_reference;
			if (!vala_data_type_is_accessible (_tmp41_, (ValaSymbol*) self)) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				ValaDataType* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = base_type_reference;
				_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp48_ = _tmp47_;
				vala_report_error (_tmp43_, "base type `%s' is less accessible than class `%s'", _tmp46_, _tmp48_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp49_ = base_type_reference;
			if (!vala_data_type_check_type_arguments (_tmp49_, context, FALSE)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (base_type_reference);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp50_;
		gint _type_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _type_index = 0;
		_tmp50_ = self->priv->base_types;
		_type_list = _tmp50_;
		_tmp51_ = _type_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_type_size = _tmp53_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp54_;
			gint _tmp55_;
			ValaDataType* type = NULL;
			ValaList* _tmp56_;
			gpointer _tmp57_;
			ValaDataType* _tmp58_;
			ValaSemanticAnalyzer* _tmp59_;
			ValaSemanticAnalyzer* _tmp60_;
			ValaDataType* _tmp61_;
			_type_index = _type_index + 1;
			_tmp54_ = _type_index;
			_tmp55_ = _type_size;
			if (!(_tmp54_ < _tmp55_)) {
				break;
			}
			_tmp56_ = _type_list;
			_tmp57_ = vala_list_get (_tmp56_, _type_index);
			type = (ValaDataType*) _tmp57_;
			_tmp58_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp58_, context);
			_tmp59_ = vala_code_context_get_analyzer (context);
			_tmp60_ = _tmp59_;
			_tmp61_ = type;
			vala_semantic_analyzer_check_type (_tmp60_, _tmp61_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp62_;
		gint _p_size = 0;
		ValaList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _p_index = 0;
		_tmp62_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp62_;
		_tmp63_ = _p_list;
		_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_p_size = _tmp65_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaTypeParameter* _tmp70_;
			_p_index = _p_index + 1;
			_tmp66_ = _p_index;
			_tmp67_ = _p_size;
			if (!(_tmp66_ < _tmp67_)) {
				break;
			}
			_tmp68_ = _p_list;
			_tmp69_ = vala_list_get (_tmp68_, _p_index);
			p = (ValaTypeParameter*) _tmp69_;
			_tmp70_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp70_, context);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp72_ = self->priv->_base_class;
	if (_tmp72_ != NULL) {
		ValaClass* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		_tmp73_ = self->priv->_base_class;
		_tmp74_ = vala_class_get_is_singleton (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp71_ = _tmp75_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		ValaSourceReference* _tmp76_;
		ValaSourceReference* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		ValaClass* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = self->priv->_base_class;
		_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp80_);
		_tmp82_ = _tmp81_;
		vala_report_error (_tmp77_, "`%s' cannot inherit from SingleInstance class `%s'", _tmp79_, _tmp82_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp79_);
	}
	_tmp84_ = vala_class_get_is_singleton (self);
	_tmp85_ = _tmp84_;
	if (_tmp85_) {
		ValaSemanticAnalyzer* _tmp86_;
		ValaSemanticAnalyzer* _tmp87_;
		ValaClass* _tmp88_;
		_tmp86_ = vala_code_context_get_analyzer (context);
		_tmp87_ = _tmp86_;
		_tmp88_ = _tmp87_->object_type;
		_tmp83_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp88_);
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		vala_report_error (_tmp90_, "SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp92_);
		_g_free0 (_tmp92_);
	}
	_tmp94_ = vala_class_get_is_singleton (self);
	_tmp95_ = _tmp94_;
	if (_tmp95_) {
		ValaConstructor* _tmp96_;
		ValaConstructor* _tmp97_;
		_tmp96_ = vala_class_get_constructor (self);
		_tmp97_ = _tmp96_;
		_tmp93_ = _tmp97_ == NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp98_;
		ValaSourceReference* _tmp99_;
		ValaConstructor* _tmp100_;
		ValaConstructor* _tmp101_;
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaBlock* _tmp104_;
		ValaBlock* _tmp105_;
		ValaConstructor* _tmp106_;
		_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_constructor_new (_tmp99_);
		c = _tmp100_;
		_tmp101_ = c;
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_block_new (_tmp103_);
		_tmp105_ = _tmp104_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp101_, _tmp105_);
		_vala_code_node_unref0 (_tmp105_);
		_tmp106_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp106_);
		_vala_code_node_unref0 (c);
	}
	_tmp109_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp110_ = _tmp109_;
	if (!_tmp110_) {
		ValaClass* _tmp111_;
		_tmp111_ = self->priv->_base_class;
		_tmp108_ = _tmp111_ != NULL;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		ValaClass* _tmp112_;
		gboolean _tmp113_;
		_tmp112_ = self->priv->_base_class;
		_tmp113_ = _tmp112_->priv->_is_sealed;
		_tmp107_ = _tmp113_;
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		ValaSourceReference* _tmp114_;
		ValaSourceReference* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		ValaClass* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp117_ = _tmp116_;
		_tmp118_ = self->priv->_base_class;
		_tmp119_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp118_);
		_tmp120_ = _tmp119_;
		vala_report_error (_tmp115_, "`%s' cannot inherit from sealed class `%s'", _tmp117_, _tmp120_);
		_g_free0 (_tmp120_);
		_g_free0 (_tmp117_);
	}
	_tmp121_ = self->priv->_is_sealed;
	if (_tmp121_) {
		gboolean _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp128_;
		_tmp122_ = vala_class_get_is_compact (self);
		_tmp123_ = _tmp122_;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp127_ = _tmp126_;
			vala_report_error (_tmp125_, "Sealed class `%s' cannot be compact", _tmp127_);
			_g_free0 (_tmp127_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp128_ = self->priv->_is_abstract;
		if (_tmp128_) {
			ValaSourceReference* _tmp129_;
			ValaSourceReference* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp130_, "Sealed class `%s' cannot be abstract", _tmp132_);
			_g_free0 (_tmp132_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp133_;
		gint _en_size = 0;
		ValaList* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gint _en_index = 0;
		_tmp133_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp133_;
		_tmp134_ = _en_list;
		_tmp135_ = vala_collection_get_size ((ValaCollection*) _tmp134_);
		_tmp136_ = _tmp135_;
		_en_size = _tmp136_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp137_;
			gint _tmp138_;
			ValaEnum* en = NULL;
			ValaList* _tmp139_;
			gpointer _tmp140_;
			ValaEnum* _tmp141_;
			_en_index = _en_index + 1;
			_tmp137_ = _en_index;
			_tmp138_ = _en_size;
			if (!(_tmp137_ < _tmp138_)) {
				break;
			}
			_tmp139_ = _en_list;
			_tmp140_ = vala_list_get (_tmp139_, _en_index);
			en = (ValaEnum*) _tmp140_;
			_tmp141_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp141_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp142_;
		gint _f_size = 0;
		ValaList* _tmp143_;
		gint _tmp144_;
		gint _tmp145_;
		gint _f_index = 0;
		_tmp142_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp142_;
		_tmp143_ = _f_list;
		_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
		_tmp145_ = _tmp144_;
		_f_size = _tmp145_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp146_;
			gint _tmp147_;
			ValaField* f = NULL;
			ValaList* _tmp148_;
			gpointer _tmp149_;
			gboolean _tmp150_ = FALSE;
			gboolean _tmp151_;
			gboolean _tmp152_;
			ValaField* _tmp190_;
			_f_index = _f_index + 1;
			_tmp146_ = _f_index;
			_tmp147_ = _f_size;
			if (!(_tmp146_ < _tmp147_)) {
				break;
			}
			_tmp148_ = _f_list;
			_tmp149_ = vala_list_get (_tmp148_, _f_index);
			f = (ValaField*) _tmp149_;
			_tmp151_ = vala_class_get_is_compact (self);
			_tmp152_ = _tmp151_;
			if (_tmp152_) {
				ValaField* _tmp153_;
				ValaMemberBinding _tmp154_;
				ValaMemberBinding _tmp155_;
				_tmp153_ = f;
				_tmp154_ = vala_field_get_binding (_tmp153_);
				_tmp155_ = _tmp154_;
				_tmp150_ = _tmp155_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp150_ = FALSE;
			}
			if (_tmp150_) {
				gboolean _tmp156_ = FALSE;
				gboolean _tmp157_ = FALSE;
				gboolean _tmp158_;
				gboolean _tmp159_;
				gboolean _tmp168_ = FALSE;
				gboolean _tmp169_ = FALSE;
				gboolean _tmp170_;
				gboolean _tmp171_;
				ValaField* _tmp184_;
				ValaMemberBinding _tmp185_;
				ValaMemberBinding _tmp186_;
				_tmp158_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp159_ = _tmp158_;
				if (!_tmp159_) {
					gboolean _tmp160_;
					gboolean _tmp161_;
					_tmp160_ = vala_class_get_is_opaque (self);
					_tmp161_ = _tmp160_;
					_tmp157_ = !_tmp161_;
				} else {
					_tmp157_ = FALSE;
				}
				if (_tmp157_) {
					ValaField* _tmp162_;
					ValaSymbolAccessibility _tmp163_;
					ValaSymbolAccessibility _tmp164_;
					_tmp162_ = f;
					_tmp163_ = vala_symbol_get_access ((ValaSymbol*) _tmp162_);
					_tmp164_ = _tmp163_;
					_tmp156_ = _tmp164_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp156_ = FALSE;
				}
				if (_tmp156_) {
					ValaField* _tmp165_;
					ValaSourceReference* _tmp166_;
					ValaSourceReference* _tmp167_;
					_tmp165_ = f;
					_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp165_);
					_tmp167_ = _tmp166_;
					vala_report_error (_tmp167_, "private fields are only supported in opaque compact classes, use [Comp" \
"act (opaque = true)]");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp170_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp171_ = _tmp170_;
				if (!_tmp171_) {
					gboolean _tmp172_;
					gboolean _tmp173_;
					_tmp172_ = vala_class_get_is_opaque (self);
					_tmp173_ = _tmp172_;
					_tmp169_ = _tmp173_;
				} else {
					_tmp169_ = FALSE;
				}
				if (_tmp169_) {
					gboolean _tmp174_ = FALSE;
					ValaField* _tmp175_;
					ValaSymbolAccessibility _tmp176_;
					ValaSymbolAccessibility _tmp177_;
					_tmp175_ = f;
					_tmp176_ = vala_symbol_get_access ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					if (_tmp177_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						_tmp174_ = TRUE;
					} else {
						ValaField* _tmp178_;
						ValaSymbolAccessibility _tmp179_;
						ValaSymbolAccessibility _tmp180_;
						_tmp178_ = f;
						_tmp179_ = vala_symbol_get_access ((ValaSymbol*) _tmp178_);
						_tmp180_ = _tmp179_;
						_tmp174_ = _tmp180_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
					}
					_tmp168_ = _tmp174_;
				} else {
					_tmp168_ = FALSE;
				}
				if (_tmp168_) {
					ValaField* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaSourceReference* _tmp183_;
					_tmp181_ = f;
					_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp181_);
					_tmp183_ = _tmp182_;
					vala_report_error (_tmp183_, "fields in opaque compact classes must be private or internal");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp184_ = f;
				_tmp185_ = vala_field_get_binding (_tmp184_);
				_tmp186_ = _tmp185_;
				if (_tmp186_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaSourceReference* _tmp189_;
					_tmp187_ = f;
					_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp187_);
					_tmp189_ = _tmp188_;
					vala_report_error (_tmp189_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp190_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp190_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp191_;
		gint _c_size = 0;
		ValaList* _tmp192_;
		gint _tmp193_;
		gint _tmp194_;
		gint _c_index = 0;
		_tmp191_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp191_;
		_tmp192_ = _c_list;
		_tmp193_ = vala_collection_get_size ((ValaCollection*) _tmp192_);
		_tmp194_ = _tmp193_;
		_c_size = _tmp194_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp195_;
			gint _tmp196_;
			ValaConstant* c = NULL;
			ValaList* _tmp197_;
			gpointer _tmp198_;
			ValaConstant* _tmp199_;
			_c_index = _c_index + 1;
			_tmp195_ = _c_index;
			_tmp196_ = _c_size;
			if (!(_tmp195_ < _tmp196_)) {
				break;
			}
			_tmp197_ = _c_list;
			_tmp198_ = vala_list_get (_tmp197_, _c_index);
			c = (ValaConstant*) _tmp198_;
			_tmp199_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp199_, context);
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp200_;
		gint _m_size = 0;
		ValaList* _tmp201_;
		gint _tmp202_;
		gint _tmp203_;
		gint _m_index = 0;
		_tmp200_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp200_;
		_tmp201_ = _m_list;
		_tmp202_ = vala_collection_get_size ((ValaCollection*) _tmp201_);
		_tmp203_ = _tmp202_;
		_m_size = _tmp203_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp204_;
			gint _tmp205_;
			ValaMethod* m = NULL;
			ValaList* _tmp206_;
			gpointer _tmp207_;
			ValaMethod* _tmp208_;
			_m_index = _m_index + 1;
			_tmp204_ = _m_index;
			_tmp205_ = _m_size;
			if (!(_tmp204_ < _tmp205_)) {
				break;
			}
			_tmp206_ = _m_list;
			_tmp207_ = vala_list_get (_tmp206_, _m_index);
			m = (ValaMethod*) _tmp207_;
			_tmp208_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp208_, context);
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp209_;
		gint _prop_size = 0;
		ValaList* _tmp210_;
		gint _tmp211_;
		gint _tmp212_;
		gint _prop_index = 0;
		_tmp209_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp209_;
		_tmp210_ = _prop_list;
		_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
		_tmp212_ = _tmp211_;
		_prop_size = _tmp212_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp213_;
			gint _tmp214_;
			ValaProperty* prop = NULL;
			ValaList* _tmp215_;
			gpointer _tmp216_;
			gboolean _tmp217_ = FALSE;
			ValaProperty* _tmp218_;
			ValaAttribute* _tmp219_;
			ValaProperty* _tmp226_;
			_prop_index = _prop_index + 1;
			_tmp213_ = _prop_index;
			_tmp214_ = _prop_size;
			if (!(_tmp213_ < _tmp214_)) {
				break;
			}
			_tmp215_ = _prop_list;
			_tmp216_ = vala_list_get (_tmp215_, _prop_index);
			prop = (ValaProperty*) _tmp216_;
			_tmp218_ = prop;
			_tmp219_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp218_, "NoAccessorMethod");
			if (_tmp219_ != NULL) {
				ValaSemanticAnalyzer* _tmp220_;
				ValaSemanticAnalyzer* _tmp221_;
				ValaClass* _tmp222_;
				_tmp220_ = vala_code_context_get_analyzer (context);
				_tmp221_ = _tmp220_;
				_tmp222_ = _tmp221_->object_type;
				_tmp217_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp222_);
			} else {
				_tmp217_ = FALSE;
			}
			if (_tmp217_) {
				ValaProperty* _tmp223_;
				ValaSourceReference* _tmp224_;
				ValaSourceReference* _tmp225_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp223_ = prop;
				_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp223_);
				_tmp225_ = _tmp224_;
				vala_report_error (_tmp225_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp226_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp226_, context);
			_vala_code_node_unref0 (prop);
		}
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp227_;
		gint _sig_size = 0;
		ValaList* _tmp228_;
		gint _tmp229_;
		gint _tmp230_;
		gint _sig_index = 0;
		_tmp227_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp227_;
		_tmp228_ = _sig_list;
		_tmp229_ = vala_collection_get_size ((ValaCollection*) _tmp228_);
		_tmp230_ = _tmp229_;
		_sig_size = _tmp230_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp231_;
			gint _tmp232_;
			ValaSignal* sig = NULL;
			ValaList* _tmp233_;
			gpointer _tmp234_;
			ValaSignal* _tmp235_;
			_sig_index = _sig_index + 1;
			_tmp231_ = _sig_index;
			_tmp232_ = _sig_size;
			if (!(_tmp231_ < _tmp232_)) {
				break;
			}
			_tmp233_ = _sig_list;
			_tmp234_ = vala_list_get (_tmp233_, _sig_index);
			sig = (ValaSignal*) _tmp234_;
			_tmp235_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp235_, context);
			_vala_code_node_unref0 (sig);
		}
	}
	_tmp236_ = vala_class_get_constructor (self);
	_tmp237_ = _tmp236_;
	if (_tmp237_ != NULL) {
		ValaConstructor* _tmp238_;
		ValaConstructor* _tmp239_;
		_tmp238_ = vala_class_get_constructor (self);
		_tmp239_ = _tmp238_;
		vala_code_node_check ((ValaCodeNode*) _tmp239_, context);
	}
	_tmp240_ = vala_class_get_class_constructor (self);
	_tmp241_ = _tmp240_;
	if (_tmp241_ != NULL) {
		ValaConstructor* _tmp242_;
		ValaConstructor* _tmp243_;
		_tmp242_ = vala_class_get_class_constructor (self);
		_tmp243_ = _tmp242_;
		vala_code_node_check ((ValaCodeNode*) _tmp243_, context);
	}
	_tmp244_ = vala_class_get_static_constructor (self);
	_tmp245_ = _tmp244_;
	if (_tmp245_ != NULL) {
		ValaConstructor* _tmp246_;
		ValaConstructor* _tmp247_;
		_tmp246_ = vala_class_get_static_constructor (self);
		_tmp247_ = _tmp246_;
		vala_code_node_check ((ValaCodeNode*) _tmp247_, context);
	}
	_tmp248_ = vala_class_get_destructor (self);
	_tmp249_ = _tmp248_;
	if (_tmp249_ != NULL) {
		ValaDestructor* _tmp250_;
		ValaDestructor* _tmp251_;
		_tmp250_ = vala_class_get_destructor (self);
		_tmp251_ = _tmp250_;
		vala_code_node_check ((ValaCodeNode*) _tmp251_, context);
	}
	_tmp252_ = vala_class_get_static_destructor (self);
	_tmp253_ = _tmp252_;
	if (_tmp253_ != NULL) {
		ValaDestructor* _tmp254_;
		ValaDestructor* _tmp255_;
		_tmp254_ = vala_class_get_static_destructor (self);
		_tmp255_ = _tmp254_;
		vala_code_node_check ((ValaCodeNode*) _tmp255_, context);
	}
	_tmp256_ = vala_class_get_class_destructor (self);
	_tmp257_ = _tmp256_;
	if (_tmp257_ != NULL) {
		ValaDestructor* _tmp258_;
		ValaDestructor* _tmp259_;
		_tmp258_ = vala_class_get_class_destructor (self);
		_tmp259_ = _tmp258_;
		vala_code_node_check ((ValaCodeNode*) _tmp259_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp260_;
		gint _cl_size = 0;
		ValaList* _tmp261_;
		gint _tmp262_;
		gint _tmp263_;
		gint _cl_index = 0;
		_tmp260_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp260_;
		_tmp261_ = _cl_list;
		_tmp262_ = vala_collection_get_size ((ValaCollection*) _tmp261_);
		_tmp263_ = _tmp262_;
		_cl_size = _tmp263_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp264_;
			gint _tmp265_;
			ValaClass* cl = NULL;
			ValaList* _tmp266_;
			gpointer _tmp267_;
			ValaClass* _tmp268_;
			_cl_index = _cl_index + 1;
			_tmp264_ = _cl_index;
			_tmp265_ = _cl_size;
			if (!(_tmp264_ < _tmp265_)) {
				break;
			}
			_tmp266_ = _cl_list;
			_tmp267_ = vala_list_get (_tmp266_, _cl_index);
			cl = (ValaClass*) _tmp267_;
			_tmp268_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp268_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp269_;
		gint _iface_size = 0;
		ValaList* _tmp270_;
		gint _tmp271_;
		gint _tmp272_;
		gint _iface_index = 0;
		_tmp269_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp269_;
		_tmp270_ = _iface_list;
		_tmp271_ = vala_collection_get_size ((ValaCollection*) _tmp270_);
		_tmp272_ = _tmp271_;
		_iface_size = _tmp272_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp273_;
			gint _tmp274_;
			ValaInterface* iface = NULL;
			ValaList* _tmp275_;
			gpointer _tmp276_;
			ValaInterface* _tmp277_;
			_iface_index = _iface_index + 1;
			_tmp273_ = _iface_index;
			_tmp274_ = _iface_size;
			if (!(_tmp273_ < _tmp274_)) {
				break;
			}
			_tmp275_ = _iface_list;
			_tmp276_ = vala_list_get (_tmp275_, _iface_index);
			iface = (ValaInterface*) _tmp276_;
			_tmp277_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp277_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp278_;
		gint _st_size = 0;
		ValaList* _tmp279_;
		gint _tmp280_;
		gint _tmp281_;
		gint _st_index = 0;
		_tmp278_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp278_;
		_tmp279_ = _st_list;
		_tmp280_ = vala_collection_get_size ((ValaCollection*) _tmp279_);
		_tmp281_ = _tmp280_;
		_st_size = _tmp281_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp282_;
			gint _tmp283_;
			ValaStruct* st = NULL;
			ValaList* _tmp284_;
			gpointer _tmp285_;
			ValaStruct* _tmp286_;
			_st_index = _st_index + 1;
			_tmp282_ = _st_index;
			_tmp283_ = _st_size;
			if (!(_tmp282_ < _tmp283_)) {
				break;
			}
			_tmp284_ = _st_list;
			_tmp285_ = vala_list_get (_tmp284_, _st_index);
			st = (ValaStruct*) _tmp285_;
			_tmp286_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp286_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp287_;
		gint _d_size = 0;
		ValaList* _tmp288_;
		gint _tmp289_;
		gint _tmp290_;
		gint _d_index = 0;
		_tmp287_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp287_;
		_tmp288_ = _d_list;
		_tmp289_ = vala_collection_get_size ((ValaCollection*) _tmp288_);
		_tmp290_ = _tmp289_;
		_d_size = _tmp290_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp291_;
			gint _tmp292_;
			ValaDelegate* d = NULL;
			ValaList* _tmp293_;
			gpointer _tmp294_;
			ValaDelegate* _tmp295_;
			_d_index = _d_index + 1;
			_tmp291_ = _d_index;
			_tmp292_ = _d_size;
			if (!(_tmp291_ < _tmp292_)) {
				break;
			}
			_tmp293_ = _d_list;
			_tmp294_ = vala_list_get (_tmp293_, _d_index);
			d = (ValaDelegate*) _tmp294_;
			_tmp295_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp295_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp296_ = vala_class_get_is_compact (self);
	_tmp297_ = _tmp296_;
	if (_tmp297_) {
		gboolean _tmp313_ = FALSE;
		gboolean _tmp314_ = FALSE;
		gboolean _tmp315_ = FALSE;
		gboolean _tmp316_;
		gboolean _tmp317_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp298_;
			gint _base_type_size = 0;
			ValaList* _tmp299_;
			gint _tmp300_;
			gint _tmp301_;
			gint _base_type_index = 0;
			_tmp298_ = vala_class_get_base_types (self);
			_base_type_list = _tmp298_;
			_tmp299_ = _base_type_list;
			_tmp300_ = vala_collection_get_size ((ValaCollection*) _tmp299_);
			_tmp301_ = _tmp300_;
			_base_type_size = _tmp301_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp302_;
				gint _tmp303_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp304_;
				gpointer _tmp305_;
				ValaDataType* _tmp306_;
				ValaTypeSymbol* _tmp307_;
				ValaTypeSymbol* _tmp308_;
				_base_type_index = _base_type_index + 1;
				_tmp302_ = _base_type_index;
				_tmp303_ = _base_type_size;
				if (!(_tmp302_ < _tmp303_)) {
					break;
				}
				_tmp304_ = _base_type_list;
				_tmp305_ = vala_list_get (_tmp304_, _base_type_index);
				base_type = (ValaDataType*) _tmp305_;
				_tmp306_ = base_type;
				_tmp307_ = vala_data_type_get_type_symbol (_tmp306_);
				_tmp308_ = _tmp307_;
				if (VALA_IS_INTERFACE (_tmp308_)) {
					ValaSourceReference* _tmp309_;
					ValaSourceReference* _tmp310_;
					gchar* _tmp311_;
					gchar* _tmp312_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp309_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp310_ = _tmp309_;
					_tmp311_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp312_ = _tmp311_;
					vala_report_error (_tmp310_, "compact classes `%s' may not implement interfaces", _tmp312_);
					_g_free0 (_tmp312_);
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp316_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp317_ = _tmp316_;
		if (!_tmp317_) {
			gboolean _tmp318_;
			gboolean _tmp319_;
			_tmp318_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp319_ = _tmp318_;
			_tmp315_ = !_tmp319_;
		} else {
			_tmp315_ = FALSE;
		}
		if (_tmp315_) {
			ValaClass* _tmp320_;
			_tmp320_ = self->priv->_base_class;
			_tmp314_ = _tmp320_ != NULL;
		} else {
			_tmp314_ = FALSE;
		}
		if (_tmp314_) {
			ValaClass* _tmp321_;
			ValaSemanticAnalyzer* _tmp322_;
			ValaSemanticAnalyzer* _tmp323_;
			ValaClass* _tmp324_;
			_tmp321_ = self->priv->_base_class;
			_tmp322_ = vala_code_context_get_analyzer (context);
			_tmp323_ = _tmp322_;
			_tmp324_ = _tmp323_->gsource_type;
			_tmp313_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp321_, (ValaTypeSymbol*) _tmp324_);
		} else {
			_tmp313_ = FALSE;
		}
		if (_tmp313_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp325_;
				gint _f_size = 0;
				ValaList* _tmp326_;
				gint _tmp327_;
				gint _tmp328_;
				gint _f_index = 0;
				_tmp325_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp325_;
				_tmp326_ = _f_list;
				_tmp327_ = vala_collection_get_size ((ValaCollection*) _tmp326_);
				_tmp328_ = _tmp327_;
				_f_size = _tmp328_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp329_;
					gint _tmp330_;
					ValaField* f = NULL;
					ValaList* _tmp331_;
					gpointer _tmp332_;
					ValaField* _tmp333_;
					ValaMemberBinding _tmp334_;
					ValaMemberBinding _tmp335_;
					_f_index = _f_index + 1;
					_tmp329_ = _f_index;
					_tmp330_ = _f_size;
					if (!(_tmp329_ < _tmp330_)) {
						break;
					}
					_tmp331_ = _f_list;
					_tmp332_ = vala_list_get (_tmp331_, _f_index);
					f = (ValaField*) _tmp332_;
					_tmp333_ = f;
					_tmp334_ = vala_field_get_binding (_tmp333_);
					_tmp335_ = _tmp334_;
					if (_tmp335_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp336_;
						ValaSourceReference* _tmp337_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp336_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp337_ = _tmp336_;
						vala_report_error (_tmp337_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
	}
	_tmp338_ = g_direct_equal;
	_tmp339_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp338_);
	prerequisites = (ValaList*) _tmp339_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp340_;
		gint _base_type_size = 0;
		ValaList* _tmp341_;
		gint _tmp342_;
		gint _tmp343_;
		gint _base_type_index = 0;
		_tmp340_ = vala_class_get_base_types (self);
		_base_type_list = _tmp340_;
		_tmp341_ = _base_type_list;
		_tmp342_ = vala_collection_get_size ((ValaCollection*) _tmp341_);
		_tmp343_ = _tmp342_;
		_base_type_size = _tmp343_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp344_;
			gint _tmp345_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp346_;
			gpointer _tmp347_;
			ValaDataType* _tmp348_;
			ValaTypeSymbol* _tmp349_;
			ValaTypeSymbol* _tmp350_;
			_base_type_index = _base_type_index + 1;
			_tmp344_ = _base_type_index;
			_tmp345_ = _base_type_size;
			if (!(_tmp344_ < _tmp345_)) {
				break;
			}
			_tmp346_ = _base_type_list;
			_tmp347_ = vala_list_get (_tmp346_, _base_type_index);
			base_type = (ValaDataType*) _tmp347_;
			_tmp348_ = base_type;
			_tmp349_ = vala_data_type_get_type_symbol (_tmp348_);
			_tmp350_ = _tmp349_;
			if (VALA_IS_INTERFACE (_tmp350_)) {
				ValaDataType* _tmp351_;
				ValaTypeSymbol* _tmp352_;
				ValaTypeSymbol* _tmp353_;
				ValaList* _tmp354_;
				_tmp351_ = base_type;
				_tmp352_ = vala_data_type_get_type_symbol (_tmp351_);
				_tmp353_ = _tmp352_;
				_tmp354_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp353_, VALA_TYPE_INTERFACE, ValaInterface), _tmp354_);
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	_tmp355_ = g_str_equal;
	_tmp356_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp355_);
	missing_prereqs = (ValaList*) _tmp356_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp357_;
		gint _prereq_size = 0;
		ValaList* _tmp358_;
		gint _tmp359_;
		gint _tmp360_;
		gint _prereq_index = 0;
		_tmp357_ = prerequisites;
		_prereq_list = _tmp357_;
		_tmp358_ = _prereq_list;
		_tmp359_ = vala_collection_get_size ((ValaCollection*) _tmp358_);
		_tmp360_ = _tmp359_;
		_prereq_size = _tmp360_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp361_;
			gint _tmp362_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp363_;
			gpointer _tmp364_;
			ValaTypeSymbol* _tmp365_;
			_prereq_index = _prereq_index + 1;
			_tmp361_ = _prereq_index;
			_tmp362_ = _prereq_size;
			if (!(_tmp361_ < _tmp362_)) {
				break;
			}
			_tmp363_ = _prereq_list;
			_tmp364_ = vala_list_get (_tmp363_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp364_;
			_tmp365_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp365_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp366_;
				ValaTypeSymbol* _tmp367_;
				gchar* _tmp368_;
				gchar* _tmp369_;
				_tmp366_ = missing_prereqs;
				_tmp367_ = prereq;
				_tmp368_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp367_);
				_tmp369_ = _tmp368_;
				vala_list_insert (_tmp366_, 0, _tmp369_);
				_g_free0 (_tmp369_);
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	_tmp370_ = missing_prereqs;
	_tmp371_ = vala_collection_get_size ((ValaCollection*) _tmp370_);
	_tmp372_ = _tmp371_;
	if (_tmp372_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp373_;
		gchar* _tmp374_;
		gchar* _tmp375_;
		gchar* _tmp376_;
		gboolean first = FALSE;
		const gchar* _tmp391_;
		gchar* _tmp392_;
		ValaSourceReference* _tmp393_;
		ValaSourceReference* _tmp394_;
		const gchar* _tmp395_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp373_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp374_ = _tmp373_;
		_tmp375_ = g_strdup_printf ("%s: some prerequisites (", _tmp374_);
		_tmp376_ = _tmp375_;
		_g_free0 (_tmp374_);
		error_string = _tmp376_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp377_;
			gint _s_size = 0;
			ValaList* _tmp378_;
			gint _tmp379_;
			gint _tmp380_;
			gint _s_index = 0;
			_tmp377_ = missing_prereqs;
			_s_list = _tmp377_;
			_tmp378_ = _s_list;
			_tmp379_ = vala_collection_get_size ((ValaCollection*) _tmp378_);
			_tmp380_ = _tmp379_;
			_s_size = _tmp380_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp381_;
				gint _tmp382_;
				gchar* s = NULL;
				ValaList* _tmp383_;
				gpointer _tmp384_;
				_s_index = _s_index + 1;
				_tmp381_ = _s_index;
				_tmp382_ = _s_size;
				if (!(_tmp381_ < _tmp382_)) {
					break;
				}
				_tmp383_ = _s_list;
				_tmp384_ = vala_list_get (_tmp383_, _s_index);
				s = (gchar*) _tmp384_;
				if (first) {
					const gchar* _tmp385_;
					const gchar* _tmp386_;
					gchar* _tmp387_;
					_tmp385_ = error_string;
					_tmp386_ = s;
					_tmp387_ = g_strdup_printf ("%s`%s'", _tmp385_, _tmp386_);
					_g_free0 (error_string);
					error_string = _tmp387_;
					first = FALSE;
				} else {
					const gchar* _tmp388_;
					const gchar* _tmp389_;
					gchar* _tmp390_;
					_tmp388_ = error_string;
					_tmp389_ = s;
					_tmp390_ = g_strdup_printf ("%s, `%s'", _tmp388_, _tmp389_);
					_g_free0 (error_string);
					error_string = _tmp390_;
				}
				_g_free0 (s);
			}
		}
		_tmp391_ = error_string;
		_tmp392_ = g_strconcat (_tmp391_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp392_;
		_tmp393_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp394_ = _tmp393_;
		_tmp395_ = error_string;
		vala_report_error (_tmp394_, "%s", _tmp395_);
		_g_free0 (error_string);
	}
	_tmp396_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp397_ = _tmp396_;
	if (_tmp397_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp548_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp398_;
			gint _base_type_size = 0;
			ValaList* _tmp399_;
			gint _tmp400_;
			gint _tmp401_;
			gint _base_type_index = 0;
			_tmp398_ = vala_class_get_base_types (self);
			_base_type_list = _tmp398_;
			_tmp399_ = _base_type_list;
			_tmp400_ = vala_collection_get_size ((ValaCollection*) _tmp399_);
			_tmp401_ = _tmp400_;
			_base_type_size = _tmp401_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp402_;
				gint _tmp403_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp404_;
				gpointer _tmp405_;
				ValaDataType* _tmp406_;
				ValaTypeSymbol* _tmp407_;
				ValaTypeSymbol* _tmp408_;
				_base_type_index = _base_type_index + 1;
				_tmp402_ = _base_type_index;
				_tmp403_ = _base_type_size;
				if (!(_tmp402_ < _tmp403_)) {
					break;
				}
				_tmp404_ = _base_type_list;
				_tmp405_ = vala_list_get (_tmp404_, _base_type_index);
				base_type = (ValaDataType*) _tmp405_;
				_tmp406_ = base_type;
				_tmp407_ = vala_data_type_get_type_symbol (_tmp406_);
				_tmp408_ = _tmp407_;
				if (VALA_IS_INTERFACE (_tmp408_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp409_;
					ValaTypeSymbol* _tmp410_;
					ValaTypeSymbol* _tmp411_;
					gboolean _tmp412_ = FALSE;
					ValaClass* _tmp413_;
					_tmp409_ = base_type;
					_tmp410_ = vala_data_type_get_type_symbol (_tmp409_);
					_tmp411_ = _tmp410_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp413_ = self->priv->_base_class;
					if (_tmp413_ != NULL) {
						ValaClass* _tmp414_;
						ValaInterface* _tmp415_;
						_tmp414_ = self->priv->_base_class;
						_tmp415_ = iface;
						_tmp412_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp414_, (ValaTypeSymbol*) _tmp415_);
					} else {
						_tmp412_ = FALSE;
					}
					if (_tmp412_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp416_;
						ValaList* _tmp417_;
						gint _m_size = 0;
						ValaList* _tmp418_;
						gint _tmp419_;
						gint _tmp420_;
						gint _m_index = 0;
						_tmp416_ = iface;
						_tmp417_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp416_);
						_m_list = _tmp417_;
						_tmp418_ = _m_list;
						_tmp419_ = vala_collection_get_size ((ValaCollection*) _tmp418_);
						_tmp420_ = _tmp419_;
						_m_size = _tmp420_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp421_;
							gint _tmp422_;
							ValaMethod* m = NULL;
							ValaList* _tmp423_;
							gpointer _tmp424_;
							ValaMethod* _tmp425_;
							gboolean _tmp426_;
							gboolean _tmp427_;
							_m_index = _m_index + 1;
							_tmp421_ = _m_index;
							_tmp422_ = _m_size;
							if (!(_tmp421_ < _tmp422_)) {
								break;
							}
							_tmp423_ = _m_list;
							_tmp424_ = vala_list_get (_tmp423_, _m_index);
							m = (ValaMethod*) _tmp424_;
							_tmp425_ = m;
							_tmp426_ = vala_method_get_is_abstract (_tmp425_);
							_tmp427_ = _tmp426_;
							if (_tmp427_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp428_ = FALSE;
									ValaClass* _tmp429_;
									ValaClass* _tmp482_;
									ValaClass* _tmp483_;
									_tmp429_ = base_class;
									if (_tmp429_ != NULL) {
										_tmp428_ = !implemented;
									} else {
										_tmp428_ = FALSE;
									}
									if (!_tmp428_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp430_;
										ValaList* _tmp431_;
										gint _impl_size = 0;
										ValaList* _tmp432_;
										gint _tmp433_;
										gint _tmp434_;
										gint _impl_index = 0;
										_tmp430_ = base_class;
										_tmp431_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp430_);
										_impl_list = _tmp431_;
										_tmp432_ = _impl_list;
										_tmp433_ = vala_collection_get_size ((ValaCollection*) _tmp432_);
										_tmp434_ = _tmp433_;
										_impl_size = _tmp434_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp435_;
											gint _tmp436_;
											ValaMethod* impl = NULL;
											ValaList* _tmp437_;
											gpointer _tmp438_;
											gboolean _tmp439_ = FALSE;
											ValaMethod* _tmp440_;
											ValaMethod* _tmp441_;
											ValaMethod* _tmp442_;
											ValaMethod* _tmp443_;
											_impl_index = _impl_index + 1;
											_tmp435_ = _impl_index;
											_tmp436_ = _impl_size;
											if (!(_tmp435_ < _tmp436_)) {
												break;
											}
											_tmp437_ = _impl_list;
											_tmp438_ = vala_list_get (_tmp437_, _impl_index);
											impl = (ValaMethod*) _tmp438_;
											_tmp440_ = impl;
											_tmp441_ = vala_method_get_base_interface_method (_tmp440_);
											_tmp442_ = _tmp441_;
											_tmp443_ = m;
											if (_tmp442_ == _tmp443_) {
												_tmp439_ = TRUE;
											} else {
												gboolean _tmp444_ = FALSE;
												gboolean _tmp445_ = FALSE;
												gboolean _tmp446_ = FALSE;
												gboolean _tmp447_ = FALSE;
												ValaClass* _tmp448_;
												_tmp448_ = base_class;
												if (_tmp448_ != self) {
													ValaMethod* _tmp449_;
													ValaMethod* _tmp450_;
													ValaMethod* _tmp451_;
													_tmp449_ = impl;
													_tmp450_ = vala_method_get_base_interface_method (_tmp449_);
													_tmp451_ = _tmp450_;
													_tmp447_ = _tmp451_ == NULL;
												} else {
													_tmp447_ = FALSE;
												}
												if (_tmp447_) {
													ValaMethod* _tmp452_;
													const gchar* _tmp453_;
													const gchar* _tmp454_;
													ValaMethod* _tmp455_;
													const gchar* _tmp456_;
													const gchar* _tmp457_;
													_tmp452_ = impl;
													_tmp453_ = vala_symbol_get_name ((ValaSymbol*) _tmp452_);
													_tmp454_ = _tmp453_;
													_tmp455_ = m;
													_tmp456_ = vala_symbol_get_name ((ValaSymbol*) _tmp455_);
													_tmp457_ = _tmp456_;
													_tmp446_ = g_strcmp0 (_tmp454_, _tmp457_) == 0;
												} else {
													_tmp446_ = FALSE;
												}
												if (_tmp446_) {
													gboolean _tmp458_ = FALSE;
													ValaMethod* _tmp459_;
													ValaDataType* _tmp460_;
													ValaDataType* _tmp461_;
													_tmp459_ = impl;
													_tmp460_ = vala_method_get_base_interface_type (_tmp459_);
													_tmp461_ = _tmp460_;
													if (_tmp461_ == NULL) {
														_tmp458_ = TRUE;
													} else {
														ValaMethod* _tmp462_;
														ValaDataType* _tmp463_;
														ValaDataType* _tmp464_;
														ValaTypeSymbol* _tmp465_;
														ValaTypeSymbol* _tmp466_;
														ValaInterface* _tmp467_;
														_tmp462_ = impl;
														_tmp463_ = vala_method_get_base_interface_type (_tmp462_);
														_tmp464_ = _tmp463_;
														_tmp465_ = vala_data_type_get_type_symbol (_tmp464_);
														_tmp466_ = _tmp465_;
														_tmp467_ = iface;
														_tmp458_ = _tmp466_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp467_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp445_ = _tmp458_;
												} else {
													_tmp445_ = FALSE;
												}
												if (_tmp445_) {
													ValaMethod* _tmp468_;
													ValaMethod* _tmp469_;
													_tmp468_ = impl;
													_tmp469_ = m;
													_tmp444_ = vala_method_compatible_no_error (_tmp468_, _tmp469_);
												} else {
													_tmp444_ = FALSE;
												}
												_tmp439_ = _tmp444_;
											}
											if (_tmp439_) {
												ValaMethod* _tmp470_;
												ValaVersionAttribute* _tmp471_;
												ValaVersionAttribute* _tmp472_;
												ValaSourceReference* _tmp473_;
												ValaSourceReference* _tmp474_;
												ValaMethod* _tmp475_;
												ValaMethod* _tmp476_;
												ValaMethod* _tmp477_;
												ValaMethod* _tmp478_;
												_tmp470_ = impl;
												_tmp471_ = vala_symbol_get_version ((ValaSymbol*) _tmp470_);
												_tmp472_ = _tmp471_;
												_tmp473_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp474_ = _tmp473_;
												vala_version_attribute_check (_tmp472_, context, _tmp474_);
												_tmp475_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp475_, TRUE);
												implemented = TRUE;
												_tmp476_ = impl;
												_tmp477_ = vala_method_get_base_interface_method (_tmp476_);
												_tmp478_ = _tmp477_;
												if (_tmp478_ == NULL) {
													ValaHashMap* _tmp479_;
													ValaMethod* _tmp480_;
													ValaMethod* _tmp481_;
													_tmp479_ = self->priv->implicit_implementations;
													_tmp480_ = m;
													_tmp481_ = impl;
													vala_map_set ((ValaMap*) _tmp479_, _tmp480_, _tmp481_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
									}
									_tmp482_ = base_class;
									_tmp483_ = _tmp482_->priv->_base_class;
									base_class = _tmp483_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp484_;
									ValaSourceReference* _tmp485_;
									gchar* _tmp486_;
									gchar* _tmp487_;
									ValaMethod* _tmp488_;
									gchar* _tmp489_;
									gchar* _tmp490_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp484_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp485_ = _tmp484_;
									_tmp486_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp487_ = _tmp486_;
									_tmp488_ = m;
									_tmp489_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp488_);
									_tmp490_ = _tmp489_;
									vala_report_error (_tmp485_, "`%s' does not implement interface method `%s'", _tmp487_, _tmp490_);
									_g_free0 (_tmp490_);
									_g_free0 (_tmp487_);
								}
							}
							_vala_code_node_unref0 (m);
						}
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp491_;
						ValaList* _tmp492_;
						gint _prop_size = 0;
						ValaList* _tmp493_;
						gint _tmp494_;
						gint _tmp495_;
						gint _prop_index = 0;
						_tmp491_ = iface;
						_tmp492_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp491_);
						_prop_list = _tmp492_;
						_tmp493_ = _prop_list;
						_tmp494_ = vala_collection_get_size ((ValaCollection*) _tmp493_);
						_tmp495_ = _tmp494_;
						_prop_size = _tmp495_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp496_;
							gint _tmp497_;
							ValaProperty* prop = NULL;
							ValaList* _tmp498_;
							gpointer _tmp499_;
							ValaProperty* _tmp500_;
							gboolean _tmp501_;
							gboolean _tmp502_;
							_prop_index = _prop_index + 1;
							_tmp496_ = _prop_index;
							_tmp497_ = _prop_size;
							if (!(_tmp496_ < _tmp497_)) {
								break;
							}
							_tmp498_ = _prop_list;
							_tmp499_ = vala_list_get (_tmp498_, _prop_index);
							prop = (ValaProperty*) _tmp499_;
							_tmp500_ = prop;
							_tmp501_ = vala_property_get_is_abstract (_tmp500_);
							_tmp502_ = _tmp501_;
							if (_tmp502_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp515_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp503_ = FALSE;
									ValaClass* _tmp504_;
									ValaClass* _tmp506_;
									ValaScope* _tmp507_;
									ValaScope* _tmp508_;
									ValaProperty* _tmp509_;
									const gchar* _tmp510_;
									const gchar* _tmp511_;
									ValaSymbol* _tmp512_;
									ValaClass* _tmp513_;
									ValaClass* _tmp514_;
									_tmp504_ = base_class;
									if (_tmp504_ != NULL) {
										ValaSymbol* _tmp505_;
										_tmp505_ = sym;
										_tmp503_ = !VALA_IS_PROPERTY (_tmp505_);
									} else {
										_tmp503_ = FALSE;
									}
									if (!_tmp503_) {
										break;
									}
									_tmp506_ = base_class;
									_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
									_tmp508_ = _tmp507_;
									_tmp509_ = prop;
									_tmp510_ = vala_symbol_get_name ((ValaSymbol*) _tmp509_);
									_tmp511_ = _tmp510_;
									_tmp512_ = vala_scope_lookup (_tmp508_, _tmp511_);
									_vala_code_node_unref0 (sym);
									sym = _tmp512_;
									_tmp513_ = base_class;
									_tmp514_ = _tmp513_->priv->_base_class;
									base_class = _tmp514_;
								}
								_tmp515_ = sym;
								if (VALA_IS_PROPERTY (_tmp515_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp516_;
									ValaProperty* _tmp517_;
									gchar* invalid_match = NULL;
									gboolean _tmp518_ = FALSE;
									ValaProperty* _tmp519_;
									gboolean _tmp520_;
									gboolean _tmp521_;
									ValaSymbol* _tmp535_;
									ValaVersionAttribute* _tmp536_;
									ValaVersionAttribute* _tmp537_;
									ValaSourceReference* _tmp538_;
									ValaSourceReference* _tmp539_;
									ValaSymbol* _tmp540_;
									_tmp516_ = sym;
									_tmp517_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp516_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp517_;
									invalid_match = NULL;
									_tmp519_ = base_prop;
									_tmp520_ = vala_symbol_get_hides ((ValaSymbol*) _tmp519_);
									_tmp521_ = _tmp520_;
									if (!_tmp521_) {
										ValaProperty* _tmp522_;
										ValaProperty* _tmp523_;
										gchar* _tmp524_ = NULL;
										gboolean _tmp525_;
										_tmp522_ = base_prop;
										_tmp523_ = prop;
										_tmp525_ = vala_property_compatible (_tmp522_, _tmp523_, &_tmp524_);
										_g_free0 (invalid_match);
										invalid_match = _tmp524_;
										_tmp518_ = !_tmp525_;
									} else {
										_tmp518_ = FALSE;
									}
									if (_tmp518_) {
										ValaSourceReference* _tmp526_;
										ValaSourceReference* _tmp527_;
										ValaProperty* _tmp528_;
										gchar* _tmp529_;
										gchar* _tmp530_;
										ValaProperty* _tmp531_;
										gchar* _tmp532_;
										gchar* _tmp533_;
										const gchar* _tmp534_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp526_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp527_ = _tmp526_;
										_tmp528_ = prop;
										_tmp529_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp528_);
										_tmp530_ = _tmp529_;
										_tmp531_ = base_prop;
										_tmp532_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp531_);
										_tmp533_ = _tmp532_;
										_tmp534_ = invalid_match;
										vala_report_error (_tmp527_, "Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp530_, _tmp533_, _tmp534_);
										_g_free0 (_tmp533_);
										_g_free0 (_tmp530_);
									}
									_tmp535_ = sym;
									_tmp536_ = vala_symbol_get_version (_tmp535_);
									_tmp537_ = _tmp536_;
									_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp539_ = _tmp538_;
									vala_version_attribute_check (_tmp537_, context, _tmp539_);
									_tmp540_ = sym;
									vala_symbol_set_used (_tmp540_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp541_;
									ValaSourceReference* _tmp542_;
									gchar* _tmp543_;
									gchar* _tmp544_;
									ValaProperty* _tmp545_;
									gchar* _tmp546_;
									gchar* _tmp547_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp542_ = _tmp541_;
									_tmp543_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp544_ = _tmp543_;
									_tmp545_ = prop;
									_tmp546_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp545_);
									_tmp547_ = _tmp546_;
									vala_report_error (_tmp542_, "`%s' does not implement interface property `%s'", _tmp544_, _tmp547_);
									_g_free0 (_tmp547_);
									_g_free0 (_tmp544_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp548_ = self->priv->_is_abstract;
		if (!_tmp548_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp549_;
			_tmp549_ = self->priv->_base_class;
			base_class = _tmp549_;
			while (TRUE) {
				gboolean _tmp550_ = FALSE;
				ValaClass* _tmp551_;
				ValaClass* _tmp612_;
				ValaClass* _tmp613_;
				_tmp551_ = base_class;
				if (_tmp551_ != NULL) {
					ValaClass* _tmp552_;
					gboolean _tmp553_;
					_tmp552_ = base_class;
					_tmp553_ = _tmp552_->priv->_is_abstract;
					_tmp550_ = _tmp553_;
				} else {
					_tmp550_ = FALSE;
				}
				if (!_tmp550_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp554_;
					ValaList* _tmp555_;
					gint _base_method_size = 0;
					ValaList* _tmp556_;
					gint _tmp557_;
					gint _tmp558_;
					gint _base_method_index = 0;
					_tmp554_ = base_class;
					_tmp555_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp554_);
					_base_method_list = _tmp555_;
					_tmp556_ = _base_method_list;
					_tmp557_ = vala_collection_get_size ((ValaCollection*) _tmp556_);
					_tmp558_ = _tmp557_;
					_base_method_size = _tmp558_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp559_;
						gint _tmp560_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp561_;
						gpointer _tmp562_;
						ValaMethod* _tmp563_;
						gboolean _tmp564_;
						gboolean _tmp565_;
						_base_method_index = _base_method_index + 1;
						_tmp559_ = _base_method_index;
						_tmp560_ = _base_method_size;
						if (!(_tmp559_ < _tmp560_)) {
							break;
						}
						_tmp561_ = _base_method_list;
						_tmp562_ = vala_list_get (_tmp561_, _base_method_index);
						base_method = (ValaMethod*) _tmp562_;
						_tmp563_ = base_method;
						_tmp564_ = vala_method_get_is_abstract (_tmp563_);
						_tmp565_ = _tmp564_;
						if (_tmp565_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp566_;
							const gchar* _tmp567_;
							const gchar* _tmp568_;
							ValaSymbol* _tmp569_;
							ValaMethod* _tmp570_;
							gboolean _tmp571_ = FALSE;
							ValaMethod* _tmp572_;
							_tmp566_ = base_method;
							_tmp567_ = vala_symbol_get_name ((ValaSymbol*) _tmp566_);
							_tmp568_ = _tmp567_;
							_tmp569_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp568_);
							_tmp570_ = VALA_IS_METHOD (_tmp569_) ? ((ValaMethod*) _tmp569_) : NULL;
							if (_tmp570_ == NULL) {
								_vala_code_node_unref0 (_tmp569_);
							}
							override_method = _tmp570_;
							_tmp572_ = override_method;
							if (_tmp572_ == NULL) {
								_tmp571_ = TRUE;
							} else {
								ValaMethod* _tmp573_;
								gboolean _tmp574_;
								gboolean _tmp575_;
								_tmp573_ = override_method;
								_tmp574_ = vala_method_get_overrides (_tmp573_);
								_tmp575_ = _tmp574_;
								_tmp571_ = !_tmp575_;
							}
							if (_tmp571_) {
								ValaSourceReference* _tmp576_;
								ValaSourceReference* _tmp577_;
								gchar* _tmp578_;
								gchar* _tmp579_;
								ValaMethod* _tmp580_;
								gchar* _tmp581_;
								gchar* _tmp582_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp576_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp577_ = _tmp576_;
								_tmp578_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp579_ = _tmp578_;
								_tmp580_ = base_method;
								_tmp581_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp580_);
								_tmp582_ = _tmp581_;
								vala_report_error (_tmp577_, "`%s' does not implement abstract method `%s'", _tmp579_, _tmp582_);
								_g_free0 (_tmp582_);
								_g_free0 (_tmp579_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp583_;
					ValaList* _tmp584_;
					gint _base_property_size = 0;
					ValaList* _tmp585_;
					gint _tmp586_;
					gint _tmp587_;
					gint _base_property_index = 0;
					_tmp583_ = base_class;
					_tmp584_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp583_);
					_base_property_list = _tmp584_;
					_tmp585_ = _base_property_list;
					_tmp586_ = vala_collection_get_size ((ValaCollection*) _tmp585_);
					_tmp587_ = _tmp586_;
					_base_property_size = _tmp587_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp588_;
						gint _tmp589_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp590_;
						gpointer _tmp591_;
						ValaProperty* _tmp592_;
						gboolean _tmp593_;
						gboolean _tmp594_;
						_base_property_index = _base_property_index + 1;
						_tmp588_ = _base_property_index;
						_tmp589_ = _base_property_size;
						if (!(_tmp588_ < _tmp589_)) {
							break;
						}
						_tmp590_ = _base_property_list;
						_tmp591_ = vala_list_get (_tmp590_, _base_property_index);
						base_property = (ValaProperty*) _tmp591_;
						_tmp592_ = base_property;
						_tmp593_ = vala_property_get_is_abstract (_tmp592_);
						_tmp594_ = _tmp593_;
						if (_tmp594_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp595_;
							const gchar* _tmp596_;
							const gchar* _tmp597_;
							ValaSymbol* _tmp598_;
							ValaProperty* _tmp599_;
							gboolean _tmp600_ = FALSE;
							ValaProperty* _tmp601_;
							_tmp595_ = base_property;
							_tmp596_ = vala_symbol_get_name ((ValaSymbol*) _tmp595_);
							_tmp597_ = _tmp596_;
							_tmp598_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp597_);
							_tmp599_ = VALA_IS_PROPERTY (_tmp598_) ? ((ValaProperty*) _tmp598_) : NULL;
							if (_tmp599_ == NULL) {
								_vala_code_node_unref0 (_tmp598_);
							}
							override_property = _tmp599_;
							_tmp601_ = override_property;
							if (_tmp601_ == NULL) {
								_tmp600_ = TRUE;
							} else {
								ValaProperty* _tmp602_;
								gboolean _tmp603_;
								gboolean _tmp604_;
								_tmp602_ = override_property;
								_tmp603_ = vala_property_get_overrides (_tmp602_);
								_tmp604_ = _tmp603_;
								_tmp600_ = !_tmp604_;
							}
							if (_tmp600_) {
								ValaSourceReference* _tmp605_;
								ValaSourceReference* _tmp606_;
								gchar* _tmp607_;
								gchar* _tmp608_;
								ValaProperty* _tmp609_;
								gchar* _tmp610_;
								gchar* _tmp611_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp605_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp606_ = _tmp605_;
								_tmp607_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp608_ = _tmp607_;
								_tmp609_ = base_property;
								_tmp610_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp609_);
								_tmp611_ = _tmp610_;
								vala_report_error (_tmp606_, "`%s' does not implement abstract property `%s'", _tmp608_, _tmp611_);
								_g_free0 (_tmp611_);
								_g_free0 (_tmp608_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
				}
				_tmp612_ = base_class;
				_tmp613_ = _tmp612_->priv->_base_class;
				base_class = _tmp613_;
			}
		}
	}
	_tmp614_ = vala_code_context_get_analyzer (context);
	_tmp615_ = _tmp614_;
	_tmp616_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp615_, _tmp616_);
	_tmp617_ = vala_code_context_get_analyzer (context);
	_tmp618_ = _tmp617_;
	_tmp619_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp618_, _tmp619_);
	_tmp620_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp621_ = _tmp620_;
	result = !_tmp621_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_symbol_hash_func_ghash_func, _vala_symbol_equal_func_gequal_func, _tmp2_);
	self->priv->implicit_implementations = _tmp3_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_opaque);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__once = 0;
	if (g_once_init_enter (&vala_class_type_id__once)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__once, vala_class_type_id);
	}
	return vala_class_type_id__once;
}

