/* valaccodestruct.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;
typedef struct _ValaCCodeNodePrivate ValaCCodeNodePrivate;

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;

#define VALA_TYPE_CCODE_STRUCT (vala_ccode_struct_get_type ())
#define VALA_CCODE_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT, ValaCCodeStruct))
#define VALA_CCODE_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructClass))
#define VALA_IS_CCODE_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT))
#define VALA_IS_CCODE_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT))
#define VALA_CCODE_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructClass))

typedef struct _ValaCCodeStruct ValaCCodeStruct;
typedef struct _ValaCCodeStructClass ValaCCodeStructClass;
typedef struct _ValaCCodeStructPrivate ValaCCodeStructPrivate;

#define VALA_TYPE_CCODE_STATEMENT (vala_ccode_statement_get_type ())
#define VALA_CCODE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatement))
#define VALA_CCODE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatementClass))
#define VALA_IS_CCODE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STATEMENT))
#define VALA_IS_CCODE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STATEMENT))
#define VALA_CCODE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STATEMENT, ValaCCodeStatementClass))

typedef struct _ValaCCodeStatement ValaCCodeStatement;
typedef struct _ValaCCodeStatementClass ValaCCodeStatementClass;

#define VALA_TYPE_CCODE_DECLARATION (vala_ccode_declaration_get_type ())
#define VALA_CCODE_DECLARATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclaration))
#define VALA_CCODE_DECLARATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationClass))
#define VALA_IS_CCODE_DECLARATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION))
#define VALA_IS_CCODE_DECLARATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION))
#define VALA_CCODE_DECLARATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationClass))

typedef struct _ValaCCodeDeclaration ValaCCodeDeclaration;
typedef struct _ValaCCodeDeclarationClass ValaCCodeDeclarationClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gee_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (gee_collection_object_unref (var), NULL)))

#define VALA_TYPE_CCODE_DECLARATOR (vala_ccode_declarator_get_type ())
#define VALA_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclarator))
#define VALA_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))
#define VALA_IS_CCODE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_IS_CCODE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATOR))
#define VALA_CCODE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATOR, ValaCCodeDeclaratorClass))

typedef struct _ValaCCodeDeclarator ValaCCodeDeclarator;
typedef struct _ValaCCodeDeclaratorClass ValaCCodeDeclaratorClass;

#define VALA_TYPE_CCODE_EXPRESSION (vala_ccode_expression_get_type ())
#define VALA_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression))
#define VALA_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))
#define VALA_IS_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_IS_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_CCODE_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))

typedef struct _ValaCCodeExpression ValaCCodeExpression;
typedef struct _ValaCCodeExpressionClass ValaCCodeExpressionClass;

#define VALA_TYPE_CCODE_VARIABLE_DECLARATOR (vala_ccode_variable_declarator_get_type ())
#define VALA_CCODE_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclarator))
#define VALA_CCODE_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorClass))
#define VALA_IS_CCODE_VARIABLE_DECLARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR))
#define VALA_IS_CCODE_VARIABLE_DECLARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_VARIABLE_DECLARATOR))
#define VALA_CCODE_VARIABLE_DECLARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorClass))

typedef struct _ValaCCodeVariableDeclarator ValaCCodeVariableDeclarator;
typedef struct _ValaCCodeVariableDeclaratorClass ValaCCodeVariableDeclaratorClass;
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeNodePrivate * priv;
};

struct _ValaCCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeNode *self);
	void (*write) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_declaration) (ValaCCodeNode* self, ValaCCodeWriter* writer);
	void (*write_combined) (ValaCCodeNode* self, ValaCCodeWriter* writer);
};

struct _ValaCCodeStruct {
	ValaCCodeNode parent_instance;
	ValaCCodeStructPrivate * priv;
};

struct _ValaCCodeStructClass {
	ValaCCodeNodeClass parent_class;
};

struct _ValaCCodeStructPrivate {
	char* _name;
	GeeList* declarations;
};


static gpointer vala_ccode_struct_parent_class = NULL;

gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void);
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void);
GType vala_ccode_struct_get_type (void);
GType vala_ccode_statement_get_type (void);
GType vala_ccode_declaration_get_type (void);
#define VALA_CCODE_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructPrivate))
enum  {
	VALA_CCODE_STRUCT_DUMMY_PROPERTY
};
ValaCCodeNode* vala_ccode_node_construct (GType object_type);
void vala_ccode_struct_set_name (ValaCCodeStruct* self, const char* value);
ValaCCodeStruct* vala_ccode_struct_new (const char* name);
ValaCCodeStruct* vala_ccode_struct_construct (GType object_type, const char* name);
void vala_ccode_struct_add_declaration (ValaCCodeStruct* self, ValaCCodeDeclaration* decl);
ValaCCodeDeclaration* vala_ccode_declaration_new (const char* type_name);
ValaCCodeDeclaration* vala_ccode_declaration_construct (GType object_type, const char* type_name);
GType vala_ccode_declarator_get_type (void);
void vala_ccode_declaration_add_declarator (ValaCCodeDeclaration* self, ValaCCodeDeclarator* decl);
GType vala_ccode_expression_get_type (void);
ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new (const char* name, ValaCCodeExpression* initializer, const char* declarator_suffix);
ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_construct (GType object_type, const char* name, ValaCCodeExpression* initializer, const char* declarator_suffix);
GType vala_ccode_variable_declarator_get_type (void);
void vala_ccode_struct_add_field (ValaCCodeStruct* self, const char* type_name, const char* name);
void vala_ccode_writer_write_string (ValaCCodeWriter* self, const char* s);
const char* vala_ccode_struct_get_name (ValaCCodeStruct* self);
void vala_ccode_writer_write_begin_block (ValaCCodeWriter* self);
void vala_ccode_node_write_declaration (ValaCCodeNode* self, ValaCCodeWriter* writer);
void vala_ccode_writer_write_end_block (ValaCCodeWriter* self);
void vala_ccode_writer_write_newline (ValaCCodeWriter* self);
static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_struct_finalize (ValaCCodeNode* obj);



ValaCCodeStruct* vala_ccode_struct_construct (GType object_type, const char* name) {
	ValaCCodeStruct* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaCCodeStruct*) vala_ccode_node_construct (object_type);
	vala_ccode_struct_set_name (self, name);
	return self;
}


ValaCCodeStruct* vala_ccode_struct_new (const char* name) {
	return vala_ccode_struct_construct (VALA_TYPE_CCODE_STRUCT, name);
}


void vala_ccode_struct_add_declaration (ValaCCodeStruct* self, ValaCCodeDeclaration* decl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (decl != NULL);
	gee_collection_add ((GeeCollection*) self->priv->declarations, decl);
}


void vala_ccode_struct_add_field (ValaCCodeStruct* self, const char* type_name, const char* name) {
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_name != NULL);
	g_return_if_fail (name != NULL);
	decl = vala_ccode_declaration_new (type_name);
	vala_ccode_declaration_add_declarator (decl, (ValaCCodeDeclarator*) (_tmp0_ = vala_ccode_variable_declarator_new (name, NULL, NULL)));
	_vala_ccode_node_unref0 (_tmp0_);
	vala_ccode_struct_add_declaration (self, decl);
	_vala_ccode_node_unref0 (decl);
}


static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeStruct * self;
	self = (ValaCCodeStruct*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "struct ");
	vala_ccode_writer_write_string (writer, self->priv->_name);
	vala_ccode_writer_write_begin_block (writer);
	{
		GeeIterator* _decl_it;
		_decl_it = gee_iterable_iterator ((GeeIterable*) self->priv->declarations);
		while (TRUE) {
			ValaCCodeDeclaration* decl;
			if (!gee_iterator_next (_decl_it)) {
				break;
			}
			decl = (ValaCCodeDeclaration*) gee_iterator_get (_decl_it);
			vala_ccode_node_write_declaration ((ValaCCodeNode*) decl, writer);
			_vala_ccode_node_unref0 (decl);
		}
		_gee_collection_object_unref0 (_decl_it);
	}
	vala_ccode_writer_write_end_block (writer);
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_struct_get_name (ValaCCodeStruct* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void vala_ccode_struct_set_name (ValaCCodeStruct* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
}


static void vala_ccode_struct_class_init (ValaCCodeStructClass * klass) {
	vala_ccode_struct_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_struct_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeStructPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_struct_real_write;
}


static void vala_ccode_struct_instance_init (ValaCCodeStruct * self) {
	self->priv = VALA_CCODE_STRUCT_GET_PRIVATE (self);
	self->priv->declarations = (GeeList*) gee_array_list_new (VALA_TYPE_CCODE_DECLARATION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_ccode_struct_finalize (ValaCCodeNode* obj) {
	ValaCCodeStruct * self;
	self = VALA_CCODE_STRUCT (obj);
	_g_free0 (self->priv->_name);
	_gee_collection_object_unref0 (self->priv->declarations);
	VALA_CCODE_NODE_CLASS (vala_ccode_struct_parent_class)->finalize (obj);
}


GType vala_ccode_struct_get_type (void) {
	static GType vala_ccode_struct_type_id = 0;
	if (vala_ccode_struct_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStruct), 0, (GInstanceInitFunc) vala_ccode_struct_instance_init, NULL };
		vala_ccode_struct_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeStruct", &g_define_type_info, 0);
	}
	return vala_ccode_struct_type_id;
}




