/***************************************************************************
                          dciconloader.cpp  -  description
                             -------------------
    begin                : Fri Jan 23 2004
    copyright            : (C) 2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>

#include <icons/gv.xpm>

#include <dcconfig.h>
#include "dciconloader.h"

DCIconLoader * g_pIconLoader = 0;

/** */
DCIconLoader::DCIconLoader()
{
	m_bError = 0;

	g_pIconLoader = this;
}

/** */
DCIconLoader::~DCIconLoader()
{
	g_pIconLoader = NULL;

	// clear the map
	m_PixmapMap.clear();
}

/** */
QPixmap DCIconLoader::LoadPixmap( QString file )
{
	QString s;
	QPixmap p;
	
	s  = g_pConfig->GetValknutDataPath();
	
	if ( p.load(s + "/icons/appl/" + g_pConfig->GetApplicationIconTheme() + "/" + file) )
		return p;
	if ( p.load(s + "/icons/emot/" + g_pConfig->GetEmoticonTheme() + "/" + file) )
		return p;
	if ( p.load(s + "/icons/user/" + g_pConfig->GetUserListIconTheme() + "/" + file) )
		return p;

	printf("DCIconLoader::LoadPixmap: Can't load '%s'\n",file.ascii());

	m_bError = TRUE;

	p = QPixmap(gv_xpm);

	return p;
}

/** */
bool DCIconLoader::Load()
{
	m_bError = FALSE;

	m_PixmapMap[eiBACK] = LoadPixmap("back.xpm");
	m_PixmapMap[eiBALL_GREEN] = LoadPixmap("ball_green.xpm");
	m_PixmapMap[eiBALL_RED] = LoadPixmap("ball_red.xpm");
	m_PixmapMap[eiBALL_YELLOW] = LoadPixmap("ball_yellow.xpm");
	m_PixmapMap[eiBOOKMARK_ADD] = LoadPixmap("bookmark_add.xpm");
	m_PixmapMap[eiBOOKMARK_FOLDER] = LoadPixmap("bookmark_folder.xpm");
	m_PixmapMap[eiCONFIGURE] = LoadPixmap("configure.xpm");
	m_PixmapMap[eiCONFIGURE_22x22] = LoadPixmap("configure_22x22.xpm");
	m_PixmapMap[eiCONNECT_CREATING] = LoadPixmap("connect_creating.xpm");
	m_PixmapMap[eiCONNECT_NO] = LoadPixmap("connect_no.xpm");
	m_PixmapMap[eiCONNECTED] = LoadPixmap("connected.xpm");
	m_PixmapMap[eiGLOBE] = LoadPixmap("globe.xpm");
	m_PixmapMap[eiICON_22x22] = LoadPixmap("icon_22x22.xpm");
	m_PixmapMap[eiDOWN] = LoadPixmap("down.xpm");
	m_PixmapMap[eiDOWNLOAD] = LoadPixmap("download.xpm");
	m_PixmapMap[eiEDIT] = LoadPixmap("edit.xpm");
	m_PixmapMap[eiEDITADD] = LoadPixmap("editadd.xpm");
	m_PixmapMap[eiEDITCOPY] = LoadPixmap("editcopy.xpm");
	m_PixmapMap[eiEDITDELETE] = LoadPixmap("editdelete.xpm");
	m_PixmapMap[eiEXIT] = LoadPixmap("exit.xpm");
	m_PixmapMap[eiFILECLOSE] = LoadPixmap("fileclose.xpm");
	m_PixmapMap[eiFILEFIND] = LoadPixmap("filefind.xpm");
	m_PixmapMap[eiFIND] = LoadPixmap("find.xpm");
	m_PixmapMap[eiFIND_22x22] = LoadPixmap("find_22x22.xpm");
	m_PixmapMap[eiGV] = LoadPixmap("gv.xpm");
	m_PixmapMap[eiHELP] = LoadPixmap("help.xpm");
	m_PixmapMap[eiICON_OPERATOR] = LoadPixmap("icon_operator.xpm");
	m_PixmapMap[eiICON_USER] = LoadPixmap("icon_user.xpm");
	m_PixmapMap[eiICON_USER_AWAY] = LoadPixmap("icon_user_away.xpm");
	m_PixmapMap[eiINFO] = LoadPixmap("info.xpm");
	m_PixmapMap[eiINFO_22x22] = LoadPixmap("info_22x22.xpm");
	m_PixmapMap[eiMESSAGE] = LoadPixmap("message.xpm");
	m_PixmapMap[eiNOTCONNECTED] = LoadPixmap("notconnected.xpm");
	m_PixmapMap[eiOPEN] = LoadPixmap("open.xpm");
	m_PixmapMap[eiRELOAD] = LoadPixmap("reload.xpm");
	m_PixmapMap[eiRELOAD_22x22] = LoadPixmap("reload_22x22.xpm");
	m_PixmapMap[eiSAVE] = LoadPixmap("save.xpm");
	m_PixmapMap[eiSERVER] = LoadPixmap("server.xpm");
	m_PixmapMap[eiSPLASH] = LoadPixmap("splash.xpm");
	m_PixmapMap[eiSPY] = LoadPixmap("spy.xpm");
	m_PixmapMap[eiTRANSFER] = LoadPixmap("transfer.xpm");
	m_PixmapMap[eiTRANSLATE] = LoadPixmap("translate.xpm");
	m_PixmapMap[eiUP] = LoadPixmap("up.xpm");
	m_PixmapMap[eiVIEW_SIDETREE] = LoadPixmap("view_sidetree.xpm");
	m_PixmapMap[eiFOLDER_BLUE] = LoadPixmap("folder_blue.xpm");
	m_PixmapMap[eiFOLDER_BLUE_OPEN] = LoadPixmap("folder_blue_open.xpm");
	m_PixmapMap[eiFOLDER_RED] = LoadPixmap("folder_red.xpm");
	m_PixmapMap[eiSSL_NO] = LoadPixmap("ssl_no.xpm");
	m_PixmapMap[eiSSL_YES] = LoadPixmap("ssl_yes.xpm");
	m_PixmapMap[eiPLAYER_PLAY] = LoadPixmap("player_play.xpm");
	m_PixmapMap[eiPLAYER_PAUSE] = LoadPixmap("player_pause.xpm");
	m_PixmapMap[eiFLAG_BRAZILIAN] = LoadPixmap("flag_brazilian.xpm");
	m_PixmapMap[eiFLAG_BOSNIAN] = LoadPixmap("flag_bosnian.xpm");
	m_PixmapMap[eiFLAG_CZECH] = LoadPixmap("flag_czech.xpm");
	m_PixmapMap[eiFLAG_DENMARK] = LoadPixmap("flag_denmark.xpm");
	m_PixmapMap[eiFLAG_ENGLISH] = LoadPixmap("flag_english.xpm");
	m_PixmapMap[eiFLAG_FINLAND] = LoadPixmap("flag_finland.xpm");
	m_PixmapMap[eiFLAG_FRANCE] = LoadPixmap("flag_france.xpm");
	m_PixmapMap[eiFLAG_GERMANY] = LoadPixmap("flag_germany.xpm");
	m_PixmapMap[eiFLAG_GREEK] = LoadPixmap("flag_greek.xpm");
	m_PixmapMap[eiFLAG_HUNGARY] = LoadPixmap("flag_hungary.xpm");
	m_PixmapMap[eiFLAG_ICELAND] = LoadPixmap("flag_iceland.xpm");
	m_PixmapMap[eiFLAG_ITALY] = LoadPixmap("flag_italy.xpm");
	m_PixmapMap[eiFLAG_NETHERLAND] = LoadPixmap("flag_netherland.xpm");
	m_PixmapMap[eiFLAG_NORWAY] = LoadPixmap("flag_norway.xpm");
	m_PixmapMap[eiFLAG_POLAND] = LoadPixmap("flag_poland.xpm");
	m_PixmapMap[eiFLAG_ROMANIA] = LoadPixmap("flag_romania.xpm");
	m_PixmapMap[eiFLAG_SPAIN] = LoadPixmap("flag_spain.xpm");
	m_PixmapMap[eiFLAG_SWEDEN] = LoadPixmap("flag_sweden.xpm");
	m_PixmapMap[eiFLAG_LATVIAN] = LoadPixmap("flag_latvian.xpm");
	m_PixmapMap[eiFLAG_RUSSIA] = LoadPixmap("flag_russia.xpm");
	m_PixmapMap[eiFLAG_SLOVAK] = LoadPixmap("flag_slovak.xpm");
	
	m_PixmapMap[eiUSERICONS] = LoadPixmap("usericons.xpm");
	
	return m_bError;
}

/** */
QPixmap & DCIconLoader::GetPixmap( enum eIcons e )
{
	return m_PixmapMap[e];
}
