/***************************************************************************
                          dcgeturl.cpp  -  description
                             -------------------
    begin                : Thu Oct 4 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qpushbutton.h>
#include <qhttp.h>
#include <qnetwork.h>
#include <qurloperator.h>
#include <qprogressbar.h>

#include <dclib/core/cbytearray.h>

#include "dcgeturl.h"

#include <dclib/dcos.h>

DCGetURL::DCGetURL( QString sURL )
	: DCDialogGetURL( 0, "", TRUE )
{
#if QT_VERSION > 0x030000
	qInitNetworkProtocols();
#endif
	m_pOp    = new QUrlOperator(sURL);
	m_baData = new CByteArray();
	m_baData->SetSize(0);

	m_bRun = FALSE;

	InitDocument();
}

DCGetURL::~DCGetURL()
{
	if ( m_pOp )
		delete m_pOp;

	if ( m_baData )
		delete m_baData;
}

/** */
void DCGetURL::InitDocument()
{
	connect( m_pOp, SIGNAL(data(const QByteArray &, QNetworkOperation *)), this, SLOT(slotData(const QByteArray &, QNetworkOperation *)) );
	connect( m_pOp, SIGNAL(dataTransferProgress(int, int, QNetworkOperation*)), this, SLOT(slotDataTransferProgress( int, int, QNetworkOperation *)) );
	connect( m_pOp, SIGNAL(finished( QNetworkOperation *)), this, SLOT(slotFinished( QNetworkOperation *)) );
	connect( PushButton_CANCEL, SIGNAL(clicked()), this, SLOT(reject()));
}

/** */
void DCGetURL::show()
{
	if ( !m_bRun )
	{
		m_pOp->get();
		m_bRun = TRUE;
	}

	DCDialogGetURL::show();
}

/** */
void DCGetURL::GetData( CByteArray * data )
{
	if(!data)
		return;

	data->SetSize(0);
	data->Append( m_baData->Data(), m_baData->Size() );
}

/** */
void DCGetURL::slotData( const QByteArray & data, QNetworkOperation * )
{
	m_baData->Append( (const unsigned char*)data.data(), data.size() );
}

/** */
void DCGetURL::slotDataTransferProgress( int bytesDone, int bytesTotal, QNetworkOperation * )
{
	QString s;

	ProgressBar_Download->setTotalSteps(bytesTotal);
	ProgressBar_Download->setProgress(bytesDone);

	s.sprintf("%d/%d",bytesDone,bytesTotal);

	TextLabel_Status->setText(s);
}

/** */
void DCGetURL::slotFinished( QNetworkOperation * op )
{
	switch( op->state() )
	{
		case QNetworkProtocol::StWaiting:
			TextLabel_Status->setText("waiting ...");
			break;
		case QNetworkProtocol::StInProgress:
			TextLabel_Status->setText("in progress ...");
			break;
		case QNetworkProtocol::StDone:
			TextLabel_Status->setText("done ...");
			accept();
			break;
		case QNetworkProtocol::StFailed:
			TextLabel_Status->setText("failed ...");
			done(-1); //reject();
			break;
		case QNetworkProtocol::StStopped:
			TextLabel_Status->setText("stopped ...");
			done(-1); //reject();
			break;
		default:
			TextLabel_Status->setText("unknown ...");
			break;
	}
}

/*
QNetworkProtocol::StWaiting - The operation is in the queue of the QNetworkProtocol and is waiting to be prcessed.
QNetworkProtocol::StInProgress - The operation is being processed.
QNetworkProtocol::StDone - The operation has been processed succesfully.
QNetworkProtocol::StFailed - The operation has been processed but an error occurred.
QNetworkProtocol::StStopped - The operation has been processed but has been stopped before it finished, and is waiting to be processed.
*/
