/***************************************************************************
                          dcoptions.cpp  -  description
                             -------------------
    begin                : Sun Feb 24 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qslider.h>
#include <qtabwidget.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qstylefactory.h>
#include <qapplication.h>
#include <qlistview.h>
#include <qinputdialog.h>
#include <qfontdialog.h>
#include <qlayout.h>
#include <qsound.h>
#include <qregexp.h>
#include <qcolordialog.h>
#include <qtoolbutton.h>
#include <qimage.h>
#include <qcursor.h>
#include <qpopupmenu.h>

#include <cfloatspinbox.h>

#include <dclib/core/cbytearray.h>
#include <dclib/core/cstring.h>
#include <dclib/core/csocket.h>
#include <dclib/core/cdir.h>
#include <dclib/cconfig.h>
#include <dclib/cfilemanager.h>

#include <dcfiletool.h>
#include <dcfilebrowser.h>
#include <dcmenuhandler.h>
#include <dciconloader.h>
#include <dcgeturl.h>
#include <dctransferview.h>

#include "DCDialogEditSharePath.h"

#include "dcoptions.h"

#include <dclib/dcos.h>
#include <dclib/cutils.h>
#include <math.h>

/** */
DCOptions::DCOptions()
{
	// set default icon
	setIcon( g_pIconLoader->GetPixmap(eiCONFIGURE) );

	InitDocument();
}

/** */
DCOptions::~DCOptions()
{
}

/** */
void DCOptions::InitDocument()
{
	// insert speed
	ComboBox_SPEED->insertItem( "28.8Kbps" );
	ComboBox_SPEED->insertItem( "33.6Kbps" );
	ComboBox_SPEED->insertItem( "56Kbps" );
	ComboBox_SPEED->insertItem( "Modem" );
	ComboBox_SPEED->insertItem( "Satellite" );
	ComboBox_SPEED->insertItem( "ISDN" );
	ComboBox_SPEED->insertItem( "DSL" );
	ComboBox_SPEED->insertItem( "Cable" );
	ComboBox_SPEED->insertItem( "LAN(T1)" );
	ComboBox_SPEED->insertItem( "LAN(T3)" );
	ComboBox_SPEED->insertItem( "Microwave" );
	ComboBox_SPEED->insertItem( "Wireless" );

	// set width mode
	ListView_OPTIONTREE->setColumnWidthMode( 0, QListView::Maximum );
	// hide the column header
	ListView_OPTIONTREE->header()->hide();
	// disable sort
	ListView_OPTIONTREE->setSorting(-1);

	// setup spin boxes
	SpinBox_MAXUPLOADRATE->setMinValue(0);
	SpinBox_MAXUPLOADRATE->setMaxValue(99999999);
	SpinBox_MAXDOWNLOADRATE->setMinValue(0);
	SpinBox_MAXDOWNLOADRATE->setMaxValue(99999999);

	// setup the option tree
	plviSecurity = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviSecurity->setText( 0, tr( "Security" ) );

	plviOther = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviOther->setText( 0, tr( "Hub Lists" ) );

	plviLog = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviLog->setText( 0, tr( "Log" ) );

	plviSound = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviSound->setText( 0, tr( "Sound" ) );

	plviGUI = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviGUI->setText( 0, tr( "GUI" ) );
	plviGUI->setOpen( true );
	plviGUIUser = new QListViewItem( plviGUI, 0 );
	plviGUIUser->setText( 0, tr( "User" ) );
	plviGUIChat = new QListViewItem( plviGUI, 0 );
	plviGUIChat->setText( 0, tr( "Chat" ) );
	plviGUITransfer = new QListViewItem( plviGUI, 0 );
	plviGUITransfer->setText( 0, tr( "Transfer" ) );
	plviGUIGeneral = new QListViewItem( plviGUI, 0 );
	plviGUIGeneral->setText( 0, tr( "General" ) );

	plviConnection = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviConnection->setText( 0, tr( "Connection" ) );
	plviConnection->setOpen( true );
	plviConnectionSettings = new QListViewItem( plviConnection, 0 );
	plviConnectionSettings->setText( 0, tr( "Settings" ) );
	plviConnectionMode = new QListViewItem( plviConnection, 0 );
	plviConnectionMode->setText( 0, tr( "Mode" ) );

	plviTransfer = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviTransfer->setText( 0, tr( "Transfer" ) );
	plviTransfer->setOpen( true );
	plviTransferSettings = new QListViewItem( plviTransfer, 0 );
	plviTransferSettings->setText( 0, tr( "Settings" ) );
	plviTransferFolder = new QListViewItem( plviTransfer, 0 );
	plviTransferFolder->setText( 0, tr( "Folder" ) );

	plviDCGUI = new QListViewItem( ListView_OPTIONTREE, 0 );
	plviDCGUI->setText( 0, tr( "Valknut" ) );
	plviDCGUI->setOpen( true );
	plviDCGUIIdentify = new QListViewItem( plviDCGUI, 0 );
	plviDCGUIIdentify->setText( 0, tr( "Identify" ) );

	connect( ToolButton_PHOTO, SIGNAL(clicked()), this, SLOT(slotChangePhoto()) );

	connect( ListView_OPTIONTREE, SIGNAL(clicked( QListViewItem * )), this, SLOT(slotListViewOptionClicked( QListViewItem * )) );

	connect( ToolButton_BROWSESOUNDFILECONNECT, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileConnect()) );
	connect( ToolButton_BROWSESOUNDFILEDISCONNECT, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileDisconnect()) );
	connect( ToolButton_BROWSESOUNDFILESEND, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileSend()) );
	connect( ToolButton_BROWSESOUNDFILERECEIVE, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileReceive()) );
	connect( ToolButton_BROWSESOUNDFILEFIRSTRECEIVE, SIGNAL(clicked()), this, SLOT(slotBrowseSoundFileFirstReceive()) );

	connect( ToolButton_PREVIEWSOUNDFILECONNECT, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileConnect()) );
	connect( ToolButton_PREVIEWSOUNDFILEDISCONNECT, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileDisconnect()) );
	connect( ToolButton_PREVIEWSOUNDFILESEND, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileSend()) );
	connect( ToolButton_PREVIEWSOUNDFILERECEIVE, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileReceive()) );
	connect( ToolButton_PREVIEWSOUNDFILEFIRSTRECEIVE, SIGNAL(clicked()), this, SLOT(slotPreviewSoundFileFirstReceive()) );

	connect( ToolButton_BROWSESOUNDPLAYER, SIGNAL(clicked()), this, SLOT(slotBrowseSoundPlayer()) );

	// Transfer->Folder
	connect( ToolButton_BROWSEDOWNLOADFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDownloadFolder()) );
	connect( ToolButton_BROWSEDOWNLOADFINISHEDFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDownloadFinishedFolder()) );

	connect( ToolButton_CREATESHARELIST, SIGNAL(clicked()), this, SLOT(slotCreateShareList()) );
	connect( ToolButton_BROWSEFILELIST, SIGNAL(clicked()), this, SLOT(slotBrowseShareList()) );
	connect( ToolButton_SHARELISTINFO, SIGNAL(clicked()), this, SLOT(slotShareListInfo()) );
	connect( ToolButton_ADDSHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotAddSharedFolder()) );
	connect( ToolButton_REMOVESHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotRemoveSharedFolder()) );
	connect( ToolButton_EDITSHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotEditSharedFolder()) );

	//
	connect( PushButton_SAVE, SIGNAL(clicked()), this, SLOT(slotSave()) );
	connect( PushButton_CANCEL, SIGNAL(clicked()), this, SLOT(reject()) );
	
	connect( PushButton_TESTHOST, SIGNAL(clicked()), this, SLOT(slotTestHost()) );
	connect( PushButton_GETINTERFACE, SIGNAL(clicked()), this, SLOT(slotGetInterface()) );
	connect( PushButton_GETINTERNETIP, SIGNAL(clicked()), this, SLOT(slotGetInternetIP()) );

	// GUI->General
	connect( ToolButton_BROWSELANGUAGEFILE, SIGNAL(clicked()), this, SLOT(slotBrowseLanguageFile()) );
	connect( ToolButton_SELECTLANGUAGE, SIGNAL(clicked()), this, SLOT(slotSelectLanguage()) );
	connect( PushButton_SETTHEME, SIGNAL(clicked()), this, SLOT(slotSetTheme()) );
	connect( ToolButton_BROWSEAPPFONT, SIGNAL(clicked()), this, SLOT(slotBrowseAppFont()) );
	connect( ToolButton_BROWSEDATAFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDataFolder()) );

	// GUI->Chat
	connect( ToolButton_BROWSEBROWSER, SIGNAL(clicked()), this, SLOT(slotBrowseBrowser()) );
	connect( ListBox_CHATCOLOR, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotDoubleClickedChatColor(QListBoxItem *)) );

	// GUI->Client
	connect( CheckBox_AUTOAWAYMODE, SIGNAL(clicked()), this, SLOT(slotAutoAwayMode()) );

	// LOG->Chat
	connect( CheckBox_LOGCHAT_ENABLELOGGING, SIGNAL(clicked()), this, SLOT(slotLogChatEnableLogging()) );
	connect( CheckBox_LOGCHAT_ENABLENICKNAMEFILTER, SIGNAL(clicked()), this, SLOT(slotLogChatEnableNickNameFilter()) );
	connect( ToolButton_LOGCHAT_NICKNAMEFILTER_ADD, SIGNAL(clicked()), this, SLOT(slotLogChatAddNickNameFilter()) );
	connect( ToolButton_LOGCHAT_NICKNAMEFILTER_DEL, SIGNAL(clicked()), this, SLOT(slotLogChatDelNickNameFilter()) );

	//
	connect( ToolButton_BROWSETRANSFERCERT, SIGNAL(clicked()), this, SLOT(slotBrowseTransferCert()) );
	connect( ToolButton_BROWSETRANSFERKEY, SIGNAL(clicked()), this, SLOT(slotBrowseTransferKey()) );

	connect( RadioButton_ACTIVEMODE, SIGNAL(toggled(bool)), this, SLOT(slotModeActiveChange(bool)) );
	connect( RadioButton_PASSIVEMODE, SIGNAL(toggled(bool)), this, SLOT(slotModePassiveChange(bool)) );
	connect( RadioButton_IPHOSTNAME, SIGNAL(toggled(bool)), this, SLOT(slotIPHOSTNAMEChange(bool)) );
	connect( RadioButton_INTERFACE, SIGNAL(toggled(bool)), this, SLOT(slotINTERFACEChange(bool)) );

	// Hub List
	connect( ToolButton_ADDHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotAddHubListUrl()) );
	connect( ToolButton_EDITHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotEditHubListUrl()) );
	connect( ToolButton_REMOVEHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotRemoveHubListUrl()) );

	connect( CheckBox_SOUNDDISABLED, SIGNAL(clicked()), this, SLOT(slotDisableSound()) );
	
	connect( CheckBox_EXTERNALPLAYER, SIGNAL(clicked()), this, SLOT(slotExternalPlayer()) );
	connect( CheckBox_SOUNDPLAYCONNECT, SIGNAL(clicked()), this, SLOT(slotSoundPlayConnect()) );
	connect( CheckBox_SOUNDPLAYDISCONNECT, SIGNAL(clicked()), this, SLOT(slotSoundPlayDisconnect()) );
	connect( CheckBox_SOUNDPLAYSEND, SIGNAL(clicked()), this, SLOT(slotSoundPlaySend()) );
	connect( CheckBox_SOUNDPLAYRECEIVE, SIGNAL(clicked()), this, SLOT(slotSoundPlayRecieve()) );
	connect( CheckBox_SOUNDPLAYFIRSTRECEIVE, SIGNAL(clicked()), this, SLOT(slotSoundPlayFirstReceive()) );

	connect( ToolButton_BROWSELOGFILE, SIGNAL(clicked()), this, SLOT(slotBrowseLogFile()) );

	// style options
	ComboBox_THEME->clear();

	if ( g_pConfig->GetThemeSupport() == TRUE )
	{
		QStringList list = QStyleFactory::keys();

		if ( list.count() > 0 )
		{
			list.sort();
			ComboBox_THEME->insertStringList(list);
			list.clear();
		}
	}
	else
	{
		// disable the theme support
		ComboBox_THEME->setEnabled(FALSE);
		PushButton_SETTHEME->setEnabled(FALSE);
	}
}

/** */
void DCOptions::slotSave()
{
	int tcpport, udpport;
	bool ok;

	// check if mode change
	if ( ((RadioButton_ACTIVEMODE->isOn() == TRUE) && (g_pConfig->GetMode(TRUE) == ecmPASSIVE)) ||
	     ((RadioButton_ACTIVEMODE->isOn() == FALSE) && (g_pConfig->GetMode(TRUE) == ecmACTIVE)) )
	{
		QMessageBox::warning( 0, "Valknut",
			QString(tr("You changed the client mode! Please restart Valknut!")));
	}

	if ( LineEdit_DOWNLOADFOLDER->text() == "" )
	{
		QMessageBox::critical( 0, "Valknut",
		QString(tr("You must set a Download Folder!")));
		return;
	}

	if ( LineEdit_DOWNLOADFINISHEDFOLDER->text() == LineEdit_DOWNLOADFOLDER->text() )
	{
		QMessageBox::critical( 0, "Valknut",
		QString(tr("Download Finished Folder and Download Folder must be different!")));
		return;
	}

	// check active mode settings
	if ( RadioButton_ACTIVEMODE->isOn() == TRUE )
	{
		// check fake host
		if ( (RadioButton_IPHOSTNAME->isOn() == TRUE) &&
	     	     (LineEdit_IP->text() == "") )

		{
			QMessageBox::critical( 0, "Valknut",
			QString(tr("You must enter a valid 'Fake Host'!")));
			return;
		}

		// check interface
		if ( (RadioButton_INTERFACE->isOn() == TRUE) &&
	     	     (LineEdit_IP->text() == "") )

		{
			QMessageBox::critical( 0, "Valknut",
			QString(tr("You must enter a valid interface!")));
			return;
		}

		// check ports
		tcpport = LineEdit_TCPLISTENPORT->text().toInt(&ok);

		if ( (ok == FALSE) || (tcpport == 0) )
		{
			QMessageBox::critical( 0, "Valknut",
			QString(tr("You must enter a valid tcp listen port!")));
			return;
		}

		udpport = LineEdit_UDPLISTENPORT->text().toInt(&ok);

		if ( (ok == FALSE) || (udpport == 0) )
		{
			QMessageBox::critical( 0, "Valknut",
			QString(tr("You must enter a valid udp listen port!")));
			return;
		}

#ifndef WIN32
		if ( (tcpport < 1024) || (udpport < 1024) )
		{
			QMessageBox::critical( 0, "Valknut",
			QString(tr("You have set Valknut to listen on a port < 1024! You can run Valknut only as root in active mode!")));
		}
#endif
	}

	// no nick is given
	if ( LineEdit_NICK->text() == "" )
	{
		QMessageBox::critical( 0, "Valknut",
		QString(tr("You must enter a valid nick!")));
		return;
	}

	// no search nick is given
	if ( (LineEdit_SEARCHNICK->text() == "") || (LineEdit_SEARCHNICK->text() == "nick_search") )
	{
		QMessageBox::critical( 0, "Valknut",
		QString(tr("You must enter a valid search nick!")));
		return;
	}

	if (LineEdit_APPFONT->text() != "")
	{
		QFont font;
		if (font.fromString(LineEdit_APPFONT->text()) == TRUE)
		{
			QApplication::setFont(font, TRUE);
		}
	}

	accept();
}

/** */
void DCOptions::SetUserPhoto( QString filename )
{
	QImage im;

	if ( filename != "" )
	{
		if ( im.load(filename) == TRUE )
		{
			if ( (im.width() > 32) ||
			     (im.height() > 32) )
			{
				im = im.smoothScale(32,32,QImage::ScaleMin);
			}

			if ( im.depth() > 8 )
				im = im.convertDepth(8);

			if ( im.numColors() > 256 )
				im.setNumColors(256);

			if ( im.save( (g_pConfig->GetConfigPath() + "photo.png").Data(), "PNG", 0 ) == FALSE )
			{
				QMessageBox::critical( 0, "Valknut", QString(tr("Can't save Image!")));
			}
			else
			{
				ToolButton_PHOTO->setIconSet( QIconSet(im, QIconSet::Large) );
				// ToolButton_PHOTO->setTextLabel(filename);
				ToolButton_PHOTO->setTextLabel((g_pConfig->GetConfigPath() + "photo.png").Data());
			}
		}
		else
		{
			QMessageBox::critical( 0, "Valknut", QString(tr("Can't load Image!")));
		}
	}
}

/** */
void DCOptions::slotChangePhoto()
{
	QString file;

	file = QFileDialog::getOpenFileName( "", "", this, "blf", tr("Select a 64x64 Photo") );

	if( file != "" )
	{
		SetUserPhoto(file.ascii());
	}
	else
	{
		ToolButton_PHOTO->setIconSet( QIconSet(QImage(""), QIconSet::Large) );
		ToolButton_PHOTO->setTextLabel("");
	}
}

/** */
void DCOptions::slotAutoAwayMode()
{
	Frame_AUTOAWAYTIME->setEnabled(CheckBox_AUTOAWAYMODE->isChecked());
}

/** */
void DCOptions::slotDoubleClickedChatColor( QListBoxItem * item )
{
	QPixmap p(10,10);
	QColor color(item->pixmap()->convertToImage().pixel(0,0));
	color = QColorDialog::getColor(color);
	p.fill(color);
	ListBox_CHATCOLOR->changeItem( p, item->text(), ListBox_CHATCOLOR->currentItem() );
}

/** */
void DCOptions::slotLogChatEnableLogging()
{
	bool b;

	b = CheckBox_LOGCHAT_ENABLELOGGING->isChecked();

	CheckBox_LOGCHAT_APPENDDATE->setEnabled(b);
	CheckBox_LOGCHAT_APPENDHUBNAME->setEnabled(b);
	CheckBox_LOGCHAT_APPENDHUBHOST->setEnabled(b);
	CheckBox_LOGCHAT_DISABLEPUBLICCHAT->setEnabled(b);
	CheckBox_LOGCHAT_ENABLENICKNAMEFILTER->setEnabled(b);

	b = b & CheckBox_LOGCHAT_ENABLENICKNAMEFILTER->isChecked();

	GroupBox_LOGNICKNAMEFILTER->setEnabled(b);
}

/** */
void DCOptions::slotLogChatEnableNickNameFilter()
{
	bool b;

	b = CheckBox_LOGCHAT_ENABLENICKNAMEFILTER->isChecked();

	GroupBox_LOGNICKNAMEFILTER->setEnabled(b);
}

/** */
void DCOptions::slotLogChatAddNickNameFilter()
{
	bool ok = FALSE;

	QString text = QInputDialog::getText(
		tr("Add new nick name filter"),
		tr("Please enter a nick" ),
		QLineEdit::Normal, "", &ok, this );

	if ( ok && !text.isEmpty() )
	{
		if ( ListBox_LOGCHAT_NICKNAMEFILTER_LIST->findItem(text) == NULL )
		{
			ListBox_LOGCHAT_NICKNAMEFILTER_LIST->insertItem(text);
		}
	}
}

/** */
void DCOptions::slotLogChatDelNickNameFilter()
{
	int i;

	i = ListBox_LOGCHAT_NICKNAMEFILTER_LIST->currentItem();

	if ( i >= 0 )
	{
		ListBox_LOGCHAT_NICKNAMEFILTER_LIST->removeItem(i);
	}
}

/** */
void DCOptions::slotIPHOSTNAMEChange( bool )
{
	PushButton_GETINTERFACE->setEnabled(FALSE);
	PushButton_GETINTERNETIP->setEnabled(TRUE);
}

/** */
void DCOptions::slotINTERFACEChange( bool )
{
	PushButton_GETINTERFACE->setEnabled(TRUE);
	PushButton_GETINTERNETIP->setEnabled(FALSE);
}

/** */
void DCOptions::slotModeActiveChange(bool b)
{
	ButtonGroup_ACTIVEMODESETTINGS->setEnabled(b);
	ButtonGroup_PASSIVEMODESETTINGS->setEnabled(!b);
}

/** */
void DCOptions::slotModePassiveChange(bool b)
{
	ButtonGroup_ACTIVEMODESETTINGS->setEnabled(!b);
	ButtonGroup_PASSIVEMODESETTINGS->setEnabled(b);
}

/** */
void DCOptions::slotTestHost()
{
	QString sip="";
	CSocket Socket;
	CString s;

	if ( RadioButton_IPHOSTNAME->isOn() )
	{
		s = LineEdit_IP->text().ascii();
		s = s.Replace(' ',"");
		LineEdit_IP->setText(s.Data());

		if ( s != "" )
		{
			sip = CSocket::GetHostByName(s).Data();
		}

		if ( sip != "" )
		{
			QMessageBox::information( 0, "Valknut", QString(tr("Host IP: "))+sip);
		}
		else
		{
			QMessageBox::critical( 0, "Valknut", QString(tr("Can't get Host IP!")));
		}
	}
	else
	{
		sip = Socket.GetInterfaceIP(LineEdit_IP->text().ascii()).Data();

		if ( sip != "" )
		{
			QMessageBox::information( 0, "Valknut", QString(tr("Interface IP: "))+sip);
		}
		else
		{
			QMessageBox::critical( 0, "Valknut", QString(tr("Can't get interface IP!")));
		}
	}
}

/** */
void DCOptions::slotGetInterface()
{
	CSocket Socket;
	CList<CString> interfacelist;
	CString * s;
	QStringList lst;

	if ( Socket.GetInterfaceList(&interfacelist) > 0 )
	{
		s = 0;

		while( (s=interfacelist.Next(s)) != 0 )
		{
			lst << s->Data();
		}
  
		bool ok = FALSE;

		QString res = QInputDialog::getItem(
				tr( "Interface List" ),
				tr( "Please select an interface" ), lst, 1, TRUE, &ok, this );

		if ( ok )
		{
			LineEdit_IP->setText(res);
		}
	}
	else
	{
		QMessageBox::information( 0, "Valknut", QString(tr("No interfaces found!")));
	}
}

/** */
void DCOptions::slotGetInternetIP()
{
	QString ip="";
	DCGetURL * d;

	// http://whatismyip.org/
	d = new DCGetURL("http://dcgui.berlios.de/ip.php");

	if ( d->exec() == QDialog::Accepted )
	{
		CString s;
		CByteArray in;
		d->GetData(&in);
		s.Set((char*)in.Data(),in.Size());

		if ( s != "" )
		{
			ip = s.Data();
		}

		ip = ip.replace( QRegExp("<ip>"), "" );
		ip = ip.replace( QRegExp("</ip>"), "" );
		
		if ( ip == "" )
		{
			QMessageBox::about(this,tr("Latest release..."),
					tr("Can't get your ip") );
		}
		else
		{
			LineEdit_IP->setText(ip);
		}
	}

	delete d;
}

/** */
void DCOptions::slotDisableSound()
{
	bool b;

	b = !CheckBox_SOUNDDISABLED->isChecked();

	CheckBox_SOUNDDISABLEDAWAY->setEnabled(b);
	CheckBox_SOUNDPLAYCONNECT->setEnabled(b);
	CheckBox_SOUNDPLAYDISCONNECT->setEnabled(b);
	CheckBox_SOUNDPLAYSEND->setEnabled(b);
	CheckBox_SOUNDPLAYRECEIVE->setEnabled(b);
	CheckBox_SOUNDPLAYFIRSTRECEIVE->setEnabled(b);
	CheckBox_EXTERNALPLAYER->setEnabled(b);

	if (!b) {
		LineEdit_EXTERNALPLAYER->setEnabled(b);
		ToolButton_BROWSESOUNDPLAYER->setEnabled(b);
		LineEdit_SOUNDFILECONNECT->setEnabled(b);
		ToolButton_BROWSESOUNDFILECONNECT->setEnabled(b);
		ToolButton_PREVIEWSOUNDFILECONNECT->setEnabled(b);
		LineEdit_SOUNDFILEDISCONNECT->setEnabled(b);
		ToolButton_BROWSESOUNDFILEDISCONNECT->setEnabled(b);
		ToolButton_PREVIEWSOUNDFILEDISCONNECT->setEnabled(b);
		LineEdit_SOUNDFILESEND->setEnabled(b);
		ToolButton_BROWSESOUNDFILESEND->setEnabled(b);
		ToolButton_PREVIEWSOUNDFILESEND->setEnabled(b);
		LineEdit_SOUNDFILERECEIVE->setEnabled(b);
		ToolButton_BROWSESOUNDFILERECEIVE->setEnabled(b);
		ToolButton_PREVIEWSOUNDFILERECEIVE->setEnabled(b);
		LineEdit_SOUNDFILEFIRSTRECEIVE->setEnabled(b);
		ToolButton_BROWSESOUNDFILEFIRSTRECEIVE->setEnabled(b);
		ToolButton_PREVIEWSOUNDFILEFIRSTRECEIVE->setEnabled(b);
	} else {
		slotExternalPlayer();
		slotSoundPlayConnect();
		slotSoundPlayConnect();
		slotSoundPlayDisconnect();
		slotSoundPlaySend();
		slotSoundPlayRecieve();
		slotSoundPlayFirstReceive();
	}
}

/** */
void DCOptions::slotExternalPlayer()
{
	bool b;

	b = CheckBox_EXTERNALPLAYER->isChecked();
	
	LineEdit_EXTERNALPLAYER->setEnabled(b);
	ToolButton_BROWSESOUNDPLAYER->setEnabled(b);
}

/** */
void DCOptions::slotSoundPlayConnect()
{
	bool b;

	b = CheckBox_SOUNDPLAYCONNECT->isChecked();
	
	LineEdit_SOUNDFILECONNECT->setEnabled(b);
	ToolButton_BROWSESOUNDFILECONNECT->setEnabled(b);
	ToolButton_PREVIEWSOUNDFILECONNECT->setEnabled(b);
}

/** */
void DCOptions::slotSoundPlayDisconnect()
{
	bool b;

	b = CheckBox_SOUNDPLAYDISCONNECT->isChecked();
	
	LineEdit_SOUNDFILEDISCONNECT->setEnabled(b);
	ToolButton_BROWSESOUNDFILEDISCONNECT->setEnabled(b);
	ToolButton_PREVIEWSOUNDFILEDISCONNECT->setEnabled(b);
}

/** */
void DCOptions::slotSoundPlaySend()
{
	bool b;

	b = CheckBox_SOUNDPLAYSEND->isChecked();
	
	LineEdit_SOUNDFILESEND->setEnabled(b);
	ToolButton_BROWSESOUNDFILESEND->setEnabled(b);
	ToolButton_PREVIEWSOUNDFILESEND->setEnabled(b);
}

/** */
void DCOptions::slotSoundPlayRecieve()
{
	bool b;

	b = CheckBox_SOUNDPLAYRECEIVE->isChecked();
	
	LineEdit_SOUNDFILERECEIVE->setEnabled(b);
	ToolButton_BROWSESOUNDFILERECEIVE->setEnabled(b);
	ToolButton_PREVIEWSOUNDFILERECEIVE->setEnabled(b);
}

/** */
void DCOptions::slotSoundPlayFirstReceive()
{
	bool b;

	b = CheckBox_SOUNDPLAYFIRSTRECEIVE->isChecked();
	
	LineEdit_SOUNDFILEFIRSTRECEIVE->setEnabled(b);
	ToolButton_BROWSESOUNDFILEFIRSTRECEIVE->setEnabled(b);
	ToolButton_PREVIEWSOUNDFILEFIRSTRECEIVE->setEnabled(b);
}

/** */
void DCOptions::slotBrowseSoundPlayer()
{
	QString file;

	file = QFileDialog::getOpenFileName( "", "", this, "blf", tr("Select sound player") );

	if( file != "" )
	{
		LineEdit_EXTERNALPLAYER->setText(file);
	}
}

/** */
void DCOptions::slotBrowseTransferCert()
{
	QString file;

	file = QFileDialog::getOpenFileName( "", "", this, "blf", tr("Select transfer cert") );

	if( file != "" )
	{
		LineEdit_TRANSFERCERT->setText(file);
	}
}

/** */
void DCOptions::slotBrowseTransferKey()
{
	QString file;

	file = QFileDialog::getOpenFileName( "", "", this, "blf", tr("Select transfer key") );

	if( file != "" )
	{
		LineEdit_TRANSFERKEY->setText(file);
	}
}

/** */
void DCOptions::slotBrowseBrowser()
{
	QString file;

	file = QFileDialog::getOpenFileName( "", "", this, "blf", tr("Select a browser") );

	if( file != "" )
	{
		LineEdit_BROWSER->setText(file);
	}
}

/** */
void DCOptions::BrowseSoundFile( eUserSound usersound )
{
	QString file;
	QString filter;

	filter = tr("au")        + " (*.au);;"  +
		 tr("wav")       + " (*.wav);;" +
		 tr("All Files") + " (*)";

	file = QFileDialog::getOpenFileName( "", filter, this, "blf", tr("Select sound file") );

	if( file != "" )
	{
		switch(usersound)
		{
			case eusCONNECT:
				LineEdit_SOUNDFILECONNECT->setText(file);
				break;
			case eusDISCONNECT:
				LineEdit_SOUNDFILEDISCONNECT->setText(file);
				break;
			case eusSEND:
				LineEdit_SOUNDFILESEND->setText(file);
				break;
			case eusRECEIVE:
				LineEdit_SOUNDFILERECEIVE->setText(file);
				break;
			case eusFIRSTRECEIVE:
				LineEdit_SOUNDFILEFIRSTRECEIVE->setText(file);
				break;
			default:
				break;
		}
	}
}

/** */
void DCOptions::PreviewSoundFile( eUserSound usersound )
{
	QString file="";

	switch(usersound)
	{
		case eusCONNECT:
			file = LineEdit_SOUNDFILECONNECT->text();
			break;
		case eusDISCONNECT:
			file = LineEdit_SOUNDFILEDISCONNECT->text();
			break;
		case eusSEND:
			file = LineEdit_SOUNDFILESEND->text();
			break;
		case eusRECEIVE:
			file = LineEdit_SOUNDFILERECEIVE->text();
			break;
		case eusFIRSTRECEIVE:
			file = LineEdit_SOUNDFILEFIRSTRECEIVE->text();
			break;
		default:
			break;
	}

	g_pConfig->PlaySound( file.ascii() );
}

/** */
void DCOptions::slotBrowseDownloadFolder()
{
	QString dir;

	dir = QFileDialog::getExistingDirectory ( "", this, "bdf", tr("Select download folder"), TRUE );

	if(dir!="")
	{
		LineEdit_DOWNLOADFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseDownloadFinishedFolder()
{
	QString dir;

	dir = QFileDialog::getExistingDirectory ( "", this, "bdf", tr("Select download finished folder"), TRUE );

	if(dir!="")
	{
		LineEdit_DOWNLOADFINISHEDFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseDataFolder()
{
	QString dir;

	dir = QFileDialog::getExistingDirectory ( "", this, "bdf", tr("Select data folder"), TRUE );

	if( dir != "" )
	{
		LineEdit_DATAFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseShareList()
{
	g_pTransferView->NewLocalFileBrowser(TRUE);
}

/** */
void DCOptions::slotBrowseLogFile()
{
	QString logfile;

	logfile = QFileDialog::getSaveFileName ( "", "", this, 0, tr("Select log file") );

	if( !logfile.isEmpty() )
	{
		LineEdit_LOGFILENAME->setText(logfile);
	}
}

/** */
void DCOptions::slotAddSharedFolder()
{
	CDir di;
	QString dir;
	CString s;
	int i;

	dir = QFileDialog::getExistingDirectory ( "", this, "bdf", tr("Select share folder"), TRUE );

	if( dir != "" )
	{
		if ( ListView_SHAREDFOLDERS->findItem( dir, 0 ) == 0 )
		{
			di.SetPath(dir.ascii());
			s = di.Path();
			i = 1;

			while( ListView_SHAREDFOLDERS->findItem( di.DirName().Data(), 1 ) != 0 )
			{
				di.SetPath( s + CString().setNum(i) );
				i++;
			}

			new QListViewItem( ListView_SHAREDFOLDERS, dir, di.DirName().Data() );
		}
	}
}

/** */
void DCOptions::slotRemoveSharedFolder()
{
	QListViewItem * item = ListView_SHAREDFOLDERS->currentItem();

	if ( item )
	{
		ListView_SHAREDFOLDERS->takeItem(item);
		delete item;
	}
}

/** */
void DCOptions::slotEditSharedFolder()
{
	QString s;
	QListViewItem * item = ListView_SHAREDFOLDERS->currentItem();

	if ( item )
	{
		DCDialogEditSharePath dlg;
		
		dlg.LineEdit_PATH->setText( item->text(0) );
		dlg.LineEdit_ALIAS->setText( item->text(1) );
		
		if ( dlg.exec() == QDialog::Accepted )
		{
			item->setText(0,dlg.LineEdit_PATH->text());
			
			s = dlg.LineEdit_ALIAS->text();
			s = s.replace( QRegExp("\\"),"");
			s = s.replace( QRegExp("/"),"");
			item->setText(1,s);
		}
	}
}

/** */
void DCOptions::SetValues()
{
	int i;
	CList<DCConfigShareFolder> list;
	DCConfigShareFolder * csf;

	// identify
	LineEdit_NICK->setText(g_pConfig->GetNick().Data());
	LineEdit_SEARCHNICK->setText(g_pConfig->GetSearchNick().Data());
	LineEdit_EMAIL->setText(g_pConfig->GetEMail(TRUE).Data());
	CheckBox_ANTISPAM->setChecked(g_pConfig->GetAntiSpam());
	LineEdit_DESCRIPTION->setText(g_pConfig->GetDescription(TRUE).Data());
	CheckBox_DESCRIPTION_TAG->setChecked(g_pConfig->GetDescriptionTag());
	LineEdit_AWAYPREFIX->setText(g_pConfig->GetAwayPrefix().Data());

	SetUserPhoto(g_pConfig->GetUserPhotoFileName().Data());

	for(i=0;i<ComboBox_SPEED->count();i++)
	{
		if ( ComboBox_SPEED->text(i) == g_pConfig->GetSpeed() )
		{
			ComboBox_SPEED->setCurrentItem(i);
			break;
		}
	}

	TextEdit_AWAYMESSAGE->setText(QString(g_pConfig->GetAwayMessage().Data()).replace( QRegExp("\\r"), "" ));

	// transfer->folder
	LineEdit_DOWNLOADFOLDER->setText(g_pConfig->GetDownloadFolder().Data());
	LineEdit_DOWNLOADFINISHEDFOLDER->setText(g_pConfig->GetDownloadFinishedFolder().Data());

	// save shared folders
	ListView_SHAREDFOLDERS->clear();

	g_pConfig->GetSharedFolders(&list);

	csf = 0;
	while( (csf=list.Next(csf)) != 0 )	
	{
		new QListViewItem( ListView_SHAREDFOLDERS, csf->m_sPath.Data(), csf->m_sAlias.Data() );
	}

	CheckBox_AUTORECREATESHARELIST->setChecked(g_pConfig->GetAutoRecreateShareList());

	// transfer->settings
	SpinBox_SAVEDOWNLOADQUEUETIME->setValue( g_pConfig->GetDownloadQueueTime() );
	SpinBox_USERUPLOADSLOTS->setValue(g_pConfig->GetUserUploadSlots());
	CheckBox_DYNAMICUPLOADRATE->setChecked(g_pConfig->GetDynamicUploadRate());
	SpinBox_MAXUPLOADRATE->setValue( floor(((10.0*g_pConfig->GetMaxUploadRate())/1024)+0.5) );
	SpinBox_MAXDOWNLOADRATE->setValue( floor(((10.0*g_pConfig->GetMaxDownloadRate())/1024)+0.5) );
	SpinBox_MAXSIMULTANEOUSUPLOADS->setValue( g_pConfig->GetMaxUpload() );
	SpinBox_TRANSFERRESENDTIMEOUT->setValue(g_pConfig->GetTransferResendTimeout());
	SpinBox_TRANSFERRESPONSETIMEOUT->setValue(g_pConfig->GetTransferResponseTimeout());

	switch ( g_pConfig->GetHubOfflineTransferClose() )
	{
		case ectNONE:
			RadioButton_NONE->setChecked(TRUE);
			break;
		case ectUPLD:
			RadioButton_UPLOAD->setChecked(TRUE);
			break;
		case ectDLD:
			RadioButton_DOWNLOAD->setChecked(TRUE);
			break;
		case ectBOTH:
			RadioButton_BOTH->setChecked(TRUE);
			break;
	}

	CheckBox_TRANSFERAUTOSEARCH->setChecked(g_pConfig->GetTransferAutoSearch());
	CheckBox_DISABLEHASHLIST->setChecked(g_pConfig->GetDisableHashList());
	SpinBox_RECREATESHARELISTTIME->setValue(g_pConfig->GetRecreateShareListTime());

	// connection->mode
	if ( g_pConfig->GetMode(TRUE) == ecmPASSIVE )
	{
		RadioButton_PASSIVEMODE->setChecked(TRUE);
		slotModeActiveChange(FALSE);
	}
	else
	{
		RadioButton_ACTIVEMODE->setChecked(TRUE);
		slotModeActiveChange(TRUE);
	}

	if ( g_pConfig->GetExternalIP() == TRUE )
	{
		RadioButton_IPHOSTNAME->setChecked(TRUE);
		slotIPHOSTNAMEChange(TRUE);
	}
	else
	{
		RadioButton_INTERFACE->setChecked(TRUE);
		slotINTERFACEChange(TRUE);
	}

	LineEdit_IP->setText(g_pConfig->GetHost().Data());
	LineEdit_LISTENIP->setText(g_pConfig->GetListenHost().Data());
	LineEdit_TCPLISTENPORT->setText( QString().setNum(g_pConfig->GetTCPListenPort()) );
	LineEdit_UDPLISTENPORT->setText( QString().setNum(g_pConfig->GetUDPListenPort()) );
	CheckBox_SENDMESSAGEONACTIVEMODEREQUEST->setChecked( g_pConfig->GetSendMessageOnActiveModeRequest() );

	// connection->settings
	SpinBox_RECONNECTCOUNT->setValue(g_pConfig->GetReconnectCount());
	SpinBox_RECONNECTTIMEOUT->setValue(g_pConfig->GetReconnectTimeout());
	CheckBox_FORCEMOVEENABLED->setChecked(g_pConfig->GetForceMoveEnabled());
	CheckBox_CHECKPRIVATEADDRESSSPACE->setChecked(g_pConfig->GetCheckPrivateAddressSpace());

	// gui->general
	LineEdit_LANGUAGEFILE->setText( g_pConfig->GetLanguageFile().Data() );

	for(i=0;i<ComboBox_THEME->count();i++)
	{
		if ( g_pConfig->GetTheme() == CString(ComboBox_THEME->text(i).ascii()) )
		{
			ComboBox_THEME->setCurrentItem(i);
			break;
		}
	}

	switch(g_pConfig->GetUnit())
	{
		case euBYTE:
			RadioButton_UNITBYTE->setChecked(TRUE);
			break;
		case euKBYTE:
			RadioButton_UNITKBYTE->setChecked(TRUE);
			break;
		case euMBYTE:
			RadioButton_UNITMBYTE->setChecked(TRUE);
			break;
		case euGBYTE:
			RadioButton_UNITGBYTE->setChecked(TRUE);
			break;
		default:
			RadioButton_UNITAUTO->setChecked(TRUE);
			break;
	}

	LineEdit_APPFONT->setText( g_pConfig->GetAppFont().Data() );
	LineEdit_DATAFOLDER->setText(g_pConfig->GetValknutDataPath());
	CheckBox_SHOWSTATUSMESSAGE->setChecked( g_pConfig->GetShowStatusMessage() );
	CheckBox_QUERYONEXIT->setChecked( g_pConfig->GetQueryOnExit() );
	CheckBox_QUERYONFILEDELETE->setChecked( g_pConfig->GetQueryOnFileDelete() );

	// gui->transfer
	CheckBox_TV_PERCENTCHUNK->setChecked(g_pConfig->GetTransferViewOptions(etvoCHUNKPERCENT));
	CheckBox_TV_PERCENTFILE->setChecked(g_pConfig->GetTransferViewOptions(etvoFILEPERCENT));
	CheckBox_TV_CHUNKSIZE->setChecked(g_pConfig->GetTransferViewOptions(etvoCHUNKSIZE));
	CheckBox_TV_FILESIZE->setChecked(g_pConfig->GetTransferViewOptions(etvoFILESIZE));
	CheckBox_TV_DOWNLOADRATESINGLE->setChecked(g_pConfig->GetTransferViewOptions(etvoDOWNLOADRATESINGLE));
	CheckBox_TV_ELAPSEDTIMESINGLE->setChecked(g_pConfig->GetTransferViewOptions(etvoELAPSEDTIMESINGLE));
	CheckBox_TV_DOWNLOADRATEMULTI->setChecked(g_pConfig->GetTransferViewOptions(etvoDOWNLOADRATEMULTI));
	CheckBox_TV_ELAPSEDTIMEMULTI->setChecked(g_pConfig->GetTransferViewOptions(etvoELAPSEDTIMEMULTI));

	// gui->chat
	CheckBox_OPENPRIVATECHATWINDOW->setChecked(g_pConfig->GetOpenPrivateChatWindow());
	CheckBox_SHOWCHATINTAB->setChecked(g_pConfig->GetShowChatInTab());
	CheckBox_SENDHIDEPRIVATECHATTOPUBLICCHAT->setChecked( g_pConfig->GetSendHidePrivateChatToPublicChat());
	CheckBox_EMOTICONS->setChecked(g_pConfig->GetEnableEmoticons());
	CheckBox_SHOWCHATSENDBUTTON->setChecked(g_pConfig->GetShowChatSendButton());
	CheckBox_CHATSHOWJOINSANDPARTS->setChecked(g_pConfig->GetChatShowJoinsAndParts());
	CheckBox_CHATRECVOFFLINEMESSAGES->setChecked(g_pConfig->GetChatRecvOfflineMessages());
	CheckBox_CHATSENDOFFLINEMESSAGES->setChecked(g_pConfig->GetChatSendOfflineMessages());
	SpinBox_CHATMAXPARAGRAPH->setValue(g_pConfig->GetChatMaxParagraph());
	SpinBox_CHATMESSAGEMAXLINES->setValue( g_pConfig->GetChatMessageMaxLines() );

	for(i=0;i<ComboBox_SENDCHAT->count();i++)
	{
		if ( g_pConfig->GetSendChat() == CString(ComboBox_SENDCHAT->text(i).ascii()) )
		{
			ComboBox_SENDCHAT->setCurrentItem(i);
			break;
		}
	}

	LineEdit_BROWSER->setText(g_pConfig->GetBrowser().Data());

	QColor c;
	QPixmap p(10,10);

	c.setNamedColor(g_pConfig->GetChatColor(eccCHATTIMESTAMP).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Timestamp"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATLOCALNICK).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Local Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATLOCALTEXT).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Local Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATREMOTENICK).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Remote Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATREMOTETEXT).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Remote Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSTATUSNICK).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Status Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSTATUSTEXT).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Status Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATTIMESTAMP).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Timestamp"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATLOCALNICK).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Local Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATLOCALTEXT).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Local Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATREMOTENICK).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Remote Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATREMOTETEXT).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Remote Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATSTATUSNICK).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Status Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATSTATUSTEXT).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat Status Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICPRIVATECHATNICK).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Private Chat Nick"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICPRIVATECHATTEXT).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Private Chat Text"));
	c.setNamedColor(g_pConfig->GetChatColor(eccCHATSAY).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Chat Say"));
	c.setNamedColor(g_pConfig->GetChatColor(eccPUBLICCHATMENICK).Data());
	p.fill(c);
	ListBox_CHATCOLOR->insertItem(p,tr("Public Chat ME Nick"));

	// gui->client
	CheckBox_CLIENTWINDOWSMINIMIZED->setChecked(g_pConfig->GetOpenClientWindowsMinimized());
	CheckBox_USERLISTRIGHTALIGNMENT->setChecked(g_pConfig->GetUserListRightAlignment());
	CheckBox_AUTOAWAYMODE->setChecked(g_pConfig->GetAutoAwayMode());
	SpinBox_AUTOAWAYTIME->setValue(g_pConfig->GetAutoAwayTime());
	CheckBox_CLIENTCOLUMNS_COMMENT->setChecked(g_pConfig->GetClientColumn(eclcCOMMENT));
	CheckBox_CLIENTCOLUMNS_TAG->setChecked(g_pConfig->GetClientColumn(eclcTAG));
	CheckBox_CLIENTCOLUMNS_SPEED->setChecked(g_pConfig->GetClientColumn(eclcSPEED));
	CheckBox_CLIENTCOLUMNS_EMAIL->setChecked(g_pConfig->GetClientColumn(eclcEMAIL));
	CheckBox_CLIENTCOLUMNS_SHARE->setChecked(g_pConfig->GetClientColumn(eclcSHARE));
	CheckBox_CLIENTCOLUMNS_IP->setChecked(g_pConfig->GetClientColumn(eclcIP));
	CheckBox_CLIENTCOLUMNS_LOCKPK->setChecked(g_pConfig->GetClientColumn(eclcLOCKPK));
	CheckBox_CLIENTCOLUMNS_SUPPORTS->setChecked(g_pConfig->GetClientColumn(eclcSUPPORTS));
	
	// sound
	CheckBox_SOUNDDISABLED->setChecked(g_pConfig->GetSoundDisabled());
	CheckBox_SOUNDDISABLEDAWAY->setChecked(g_pConfig->GetSoundDisabledAway());
	CheckBox_EXTERNALPLAYER->setChecked(g_pConfig->GetExternalSoundPlayer());
	LineEdit_EXTERNALPLAYER->setText( g_pConfig->GetExternalPlayer().Data() );
	LineEdit_SOUNDFILECONNECT->setText( g_pConfig->GetSoundFile(eusCONNECT).Data() );
	LineEdit_SOUNDFILEDISCONNECT->setText( g_pConfig->GetSoundFile(eusDISCONNECT).Data() );
	LineEdit_SOUNDFILESEND->setText( g_pConfig->GetSoundFile(eusSEND).Data() );
	LineEdit_SOUNDFILERECEIVE->setText( g_pConfig->GetSoundFile(eusRECEIVE).Data() );
	LineEdit_SOUNDFILEFIRSTRECEIVE->setText( g_pConfig->GetSoundFile(eusFIRSTRECEIVE).Data() );
	CheckBox_SOUNDPLAYCONNECT->setChecked(g_pConfig->GetSoundEnabled(eusCONNECT));
	CheckBox_SOUNDPLAYDISCONNECT->setChecked(g_pConfig->GetSoundEnabled(eusDISCONNECT));
	CheckBox_SOUNDPLAYSEND->setChecked(g_pConfig->GetSoundEnabled(eusSEND));
	CheckBox_SOUNDPLAYRECEIVE->setChecked(g_pConfig->GetSoundEnabled(eusRECEIVE));
	CheckBox_SOUNDPLAYFIRSTRECEIVE->setChecked(g_pConfig->GetSoundEnabled(eusFIRSTRECEIVE));

	// log
	CheckBox_LOGFILE->setChecked(g_pConfig->GetLogFile());
	LineEdit_LOGFILENAME->setText( g_pConfig->GetLogFileName().Data() );
	CheckBox_TIMESTAMPPRIVATECHAT->setChecked(g_pConfig->GetTimeStamp(etsPRIVATECHAT));
	CheckBox_TIMESTAMPHUBCHAT->setChecked(g_pConfig->GetTimeStamp(etsHUBCHAT));

	CheckBox_LOGCHAT_ENABLELOGGING->setChecked( g_pConfig->GetLogChatOption(elcoENABLELOGGING) );
	CheckBox_LOGCHAT_APPENDDATE->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDDATE) );
	CheckBox_LOGCHAT_APPENDHUBNAME->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDHUBNAME) );
	CheckBox_LOGCHAT_APPENDHUBHOST->setChecked( g_pConfig->GetLogChatOption(elcoAPPENDHUBHOST) );
	CheckBox_LOGCHAT_DISABLEPUBLICCHAT->setChecked( g_pConfig->GetLogChatOption(elcoDISABLEPUBLICCHAT) );
	CheckBox_LOGCHAT_ENABLENICKNAMEFILTER->setChecked( g_pConfig->GetLogChatOption(elcoENABLENICKNAMEFILTER) );
	CheckBox_LOGCHAT_NICKNAMEFILTER_ENABLELOGGING->setChecked( g_pConfig->GetLogChatOption(elcoNICKNAMEFILTER_ENABLELOGGING) );

	CList<CString> nnflist;
	CString * ps = 0;
	g_pConfig->GetLogChatNickNameFilter( &nnflist );

	ListBox_LOGCHAT_NICKNAMEFILTER_LIST->clear();

	while( (ps=nnflist.Next(ps)) != 0 )
	{
		ListBox_LOGCHAT_NICKNAMEFILTER_LIST->insertItem(ps->Data());
	}

	// other
	CheckBox_HUBLISTSTORELOCAL->setChecked(g_pConfig->GetHubListStoreLocal());
	SpinBox_RELOADHUBLISTTIME->setValue(g_pConfig->GetReloadHubListTime());

	DCConfigHubListUrl * hublisturl = 0;

	CList<DCConfigHubListUrl> hublisturllist;
	g_pConfig->GetHubListUrlList(&hublisturllist);

	while( (hublisturl=hublisturllist.Next(hublisturl)) != 0 )
	{
		QCheckListItem * cli = new QCheckListItem( ListView_HUBLISTURL, hublisturl->sUrl.Data(), QCheckListItem::CheckBox );
		cli->setOn(hublisturl->bEnabled);
	}

	// security
	SpinBox_FLOODCOUNT->setValue(g_pConfig->GetFloodCount());
	CheckBox_FLOODOPKICK->setChecked(g_pConfig->GetFloodOpKick());
	LineEdit_FLOODOPKICKMESSAGE->setText(QString(g_pConfig->GetFloodOpKickMessage().Data()).replace( QRegExp("\\r"), "" ));
	LineEdit_TRANSFERCERT->setText(g_pConfig->GetTransferCert().Data());
	LineEdit_TRANSFERKEY->setText(g_pConfig->GetTransferKey().Data());

	// init the sound tab
	slotDisableSound();
	// init log tab
	slotLogChatEnableLogging();
	// init away
	slotAutoAwayMode();
}

/** */
void DCOptions::GetValues()
{
	bool ok;

	g_pConfig->SetNick(LineEdit_NICK->text().ascii());
	g_pConfig->SetSearchNick(LineEdit_SEARCHNICK->text().ascii());
	g_pConfig->SetAwayMessage(TextEdit_AWAYMESSAGE->text().replace( QRegExp("\\n"), "\xd\xa" ).ascii());
	g_pConfig->SetDescription(LineEdit_DESCRIPTION->text().ascii());
	g_pConfig->SetAwayPrefix(LineEdit_AWAYPREFIX->text().ascii());
	g_pConfig->SetDescriptionTag(CheckBox_DESCRIPTION_TAG->isChecked());
	g_pConfig->SetEMail(LineEdit_EMAIL->text().ascii());
	g_pConfig->SetAntiSpam(CheckBox_ANTISPAM->isChecked());
	g_pConfig->SetCheckPrivateAddressSpace(CheckBox_CHECKPRIVATEADDRESSSPACE->isChecked());
	g_pConfig->SetShowChatSendButton(CheckBox_SHOWCHATSENDBUTTON->isChecked());
	g_pConfig->SetBrowser(LineEdit_BROWSER->text().ascii());
	g_pConfig->SetDynamicUploadRate(CheckBox_DYNAMICUPLOADRATE->isChecked());
	g_pConfig->SetShowChatInTab(CheckBox_SHOWCHATINTAB->isChecked());
	g_pConfig->SetChatMaxParagraph(SpinBox_CHATMAXPARAGRAPH->value());
	g_pConfig->SetTransferAutoSearch(CheckBox_TRANSFERAUTOSEARCH->isChecked());
	g_pConfig->SetDisableHashList(CheckBox_DISABLEHASHLIST->isChecked());

	g_pConfig->SetUserPhotoFileName(ToolButton_PHOTO->textLabel().ascii());

	g_pConfig->SetSpeed(ComboBox_SPEED->currentText().ascii());
	g_pConfig->SetDownloadFolder(LineEdit_DOWNLOADFOLDER->text().ascii());
	g_pConfig->SetDownloadFinishedFolder(LineEdit_DOWNLOADFINISHEDFOLDER->text().ascii());
	g_pConfig->SetValknutDataPath(LineEdit_DATAFOLDER->text());
	
	g_pConfig->SetAutoRecreateShareList(CheckBox_AUTORECREATESHARELIST->isChecked());
	g_pConfig->SetRecreateShareListTime(SpinBox_RECREATESHARELISTTIME->value());

	g_pConfig->SetFloodOpKickMessage(LineEdit_FLOODOPKICKMESSAGE->text().replace( QRegExp("\\n"), "\xd\xa" ).ascii());
	g_pConfig->SetFloodCount(SpinBox_FLOODCOUNT->value());
	g_pConfig->SetFloodOpKick(CheckBox_FLOODOPKICK->isChecked());

	g_pConfig->SetTransferCert(LineEdit_TRANSFERCERT->text().ascii());
	g_pConfig->SetTransferKey(LineEdit_TRANSFERKEY->text().ascii());

	SaveSharedFolders();

	g_pConfig->SetMaxUpload( SpinBox_MAXSIMULTANEOUSUPLOADS->value() );
	g_pConfig->SetMaxUploadRate( floor((SpinBox_MAXUPLOADRATE->cleanText().toFloat()*1024)+0.5) );
	g_pConfig->SetMaxDownloadRate( floor((SpinBox_MAXDOWNLOADRATE->cleanText().toFloat()*1024)+0.5) );
	g_pConfig->SetDownloadQueueTime(SpinBox_SAVEDOWNLOADQUEUETIME->value());

	g_pConfig->SetTCPListenPort(LineEdit_TCPLISTENPORT->text().toInt(&ok));
	g_pConfig->SetUDPListenPort(LineEdit_UDPLISTENPORT->text().toInt(&ok));
	g_pConfig->SetExternalIP(RadioButton_IPHOSTNAME->isOn());

	if ( RadioButton_ACTIVEMODE->isOn() )
		g_pConfig->SetMode(ecmACTIVE);
	else
		g_pConfig->SetMode(ecmPASSIVE);

	g_pConfig->SetHost(LineEdit_IP->text().ascii());
	g_pConfig->SetListenHost(LineEdit_LISTENIP->text().ascii());	
	g_pConfig->SetSendMessageOnActiveModeRequest(CheckBox_SENDMESSAGEONACTIVEMODEREQUEST->isChecked());

	// gui settings
	g_pConfig->SetOpenPrivateChatWindow(CheckBox_OPENPRIVATECHATWINDOW->isChecked());
	g_pConfig->SetEnableEmoticons(CheckBox_EMOTICONS->isChecked());

	if ( RadioButton_UNITBYTE->isChecked() )
		g_pConfig->SetUnit(euBYTE);
	else if ( RadioButton_UNITKBYTE->isChecked() )
		g_pConfig->SetUnit(euKBYTE);
	else if ( RadioButton_UNITMBYTE->isChecked() )
		g_pConfig->SetUnit(euMBYTE);
	else if ( RadioButton_UNITGBYTE->isChecked() )
		g_pConfig->SetUnit(euGBYTE);
	else
		g_pConfig->SetUnit(euAUTO);
	
	g_pConfig->SetTheme(ComboBox_THEME->currentText().ascii());
	g_pConfig->SetSendChat(ComboBox_SENDCHAT->currentText().ascii());
	g_pConfig->SetLanguageFile(LineEdit_LANGUAGEFILE->text().ascii());
	g_pConfig->SetShowStatusMessage(CheckBox_SHOWSTATUSMESSAGE->isChecked());
	g_pConfig->SetQueryOnExit(CheckBox_QUERYONEXIT->isChecked());
	g_pConfig->SetQueryOnFileDelete(CheckBox_QUERYONFILEDELETE->isChecked());
	g_pConfig->SetSendHidePrivateChatToPublicChat(CheckBox_SENDHIDEPRIVATECHATTOPUBLICCHAT->isChecked());
	g_pConfig->SetChatSendOfflineMessages(CheckBox_CHATSENDOFFLINEMESSAGES->isChecked());
	g_pConfig->SetChatRecvOfflineMessages(CheckBox_CHATRECVOFFLINEMESSAGES->isChecked());
	g_pConfig->SetChatMessageMaxLines( SpinBox_CHATMESSAGEMAXLINES->value() );

	// sound settings
	g_pConfig->SetSoundDisabled(CheckBox_SOUNDDISABLED->isChecked());
	g_pConfig->SetSoundDisabledAway(CheckBox_SOUNDDISABLEDAWAY->isChecked());

	g_pConfig->SetSoundEnabled(eusCONNECT,CheckBox_SOUNDPLAYCONNECT->isChecked());
	g_pConfig->SetSoundEnabled(eusDISCONNECT,CheckBox_SOUNDPLAYDISCONNECT->isChecked());
	g_pConfig->SetSoundEnabled(eusSEND,CheckBox_SOUNDPLAYSEND->isChecked());
	g_pConfig->SetSoundEnabled(eusRECEIVE,CheckBox_SOUNDPLAYRECEIVE->isChecked());
	g_pConfig->SetSoundEnabled(eusFIRSTRECEIVE,CheckBox_SOUNDPLAYFIRSTRECEIVE->isChecked());

	g_pConfig->SetExternalSoundPlayer(CheckBox_EXTERNALPLAYER->isChecked());
	g_pConfig->SetExternalPlayer(LineEdit_EXTERNALPLAYER->text().ascii());
	g_pConfig->SetSoundFile( eusCONNECT, LineEdit_SOUNDFILECONNECT->text().ascii());
	g_pConfig->SetSoundFile( eusDISCONNECT, LineEdit_SOUNDFILEDISCONNECT->text().ascii());
	g_pConfig->SetSoundFile( eusSEND, LineEdit_SOUNDFILESEND->text().ascii());
	g_pConfig->SetSoundFile( eusRECEIVE, LineEdit_SOUNDFILERECEIVE->text().ascii());
	g_pConfig->SetSoundFile( eusFIRSTRECEIVE, LineEdit_SOUNDFILEFIRSTRECEIVE->text().ascii());

	g_pConfig->SetAppFont(LineEdit_APPFONT->text().ascii());

	// gui->chat
	g_pConfig->SetChatShowJoinsAndParts(CheckBox_CHATSHOWJOINSANDPARTS->isChecked());

	// gui->client
	g_pConfig->SetOpenClientWindowsMinimized(CheckBox_CLIENTWINDOWSMINIMIZED->isChecked());
	g_pConfig->SetUserListRightAlignment(CheckBox_USERLISTRIGHTALIGNMENT->isChecked());
	g_pConfig->SetAutoAwayMode(CheckBox_AUTOAWAYMODE->isChecked());
	g_pConfig->SetAutoAwayTime(SpinBox_AUTOAWAYTIME->value());
	g_pConfig->SetClientColumn(eclcCOMMENT,CheckBox_CLIENTCOLUMNS_COMMENT->isChecked());
	g_pConfig->SetClientColumn(eclcTAG,CheckBox_CLIENTCOLUMNS_TAG->isChecked());
	g_pConfig->SetClientColumn(eclcSPEED,CheckBox_CLIENTCOLUMNS_SPEED->isChecked());
	g_pConfig->SetClientColumn(eclcEMAIL,CheckBox_CLIENTCOLUMNS_EMAIL->isChecked());
	g_pConfig->SetClientColumn(eclcSHARE,CheckBox_CLIENTCOLUMNS_SHARE->isChecked());
	g_pConfig->SetClientColumn(eclcIP,CheckBox_CLIENTCOLUMNS_IP->isChecked());
	g_pConfig->SetClientColumn(eclcLOCKPK,CheckBox_CLIENTCOLUMNS_LOCKPK->isChecked());
	g_pConfig->SetClientColumn(eclcSUPPORTS,CheckBox_CLIENTCOLUMNS_SUPPORTS->isChecked());
	
	// log settings
	g_pConfig->SetLogFile(CheckBox_LOGFILE->isChecked());
	g_pConfig->SetLogFileName( LineEdit_LOGFILENAME->text().ascii() );
	g_pConfig->SetTimeStamp(etsPRIVATECHAT,CheckBox_TIMESTAMPPRIVATECHAT->isChecked());
	g_pConfig->SetTimeStamp(etsHUBCHAT,CheckBox_TIMESTAMPHUBCHAT->isChecked());

	g_pConfig->SetLogChatOption(elcoENABLELOGGING, CheckBox_LOGCHAT_ENABLELOGGING->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDDATE, CheckBox_LOGCHAT_APPENDDATE->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDHUBNAME, CheckBox_LOGCHAT_APPENDHUBNAME->isChecked() );
	g_pConfig->SetLogChatOption(elcoAPPENDHUBHOST, CheckBox_LOGCHAT_APPENDHUBHOST->isChecked() );
	g_pConfig->SetLogChatOption(elcoDISABLEPUBLICCHAT, CheckBox_LOGCHAT_DISABLEPUBLICCHAT->isChecked() );
	g_pConfig->SetLogChatOption(elcoENABLENICKNAMEFILTER, CheckBox_LOGCHAT_ENABLENICKNAMEFILTER->isChecked() );
	g_pConfig->SetLogChatOption(elcoNICKNAMEFILTER_ENABLELOGGING, CheckBox_LOGCHAT_NICKNAMEFILTER_ENABLELOGGING->isChecked() );

	CList<CString> nnflist;
	uint i = 0;

	for(i=0;i<ListBox_LOGCHAT_NICKNAMEFILTER_LIST->count();i++)
	{
		nnflist.Add( new CString(ListBox_LOGCHAT_NICKNAMEFILTER_LIST->text(i).ascii()) );
	}

	g_pConfig->SetLogChatNickNameFilter( &nnflist );

	// other settings
	g_pConfig->SetHubListStoreLocal(CheckBox_HUBLISTSTORELOCAL->isChecked());
	g_pConfig->SetReconnectCount( SpinBox_RECONNECTCOUNT->value() );
	g_pConfig->SetReconnectTimeout( SpinBox_RECONNECTTIMEOUT->value() );
	g_pConfig->SetTransferResendTimeout(SpinBox_TRANSFERRESENDTIMEOUT->value());
	g_pConfig->SetTransferResponseTimeout(SpinBox_TRANSFERRESPONSETIMEOUT->value());
	g_pConfig->SetForceMoveEnabled(CheckBox_FORCEMOVEENABLED->isChecked());
	g_pConfig->SetReloadHubListTime(SpinBox_RELOADHUBLISTTIME->value());

	// transfer view settings
	g_pConfig->SetTransferViewOptions(etvoCHUNKPERCENT,CheckBox_TV_PERCENTCHUNK->isChecked());
	g_pConfig->SetTransferViewOptions(etvoFILEPERCENT,CheckBox_TV_PERCENTFILE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoCHUNKSIZE,CheckBox_TV_CHUNKSIZE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoFILESIZE,CheckBox_TV_FILESIZE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoDOWNLOADRATESINGLE,CheckBox_TV_DOWNLOADRATESINGLE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoELAPSEDTIMESINGLE,CheckBox_TV_ELAPSEDTIMESINGLE->isChecked());
	g_pConfig->SetTransferViewOptions(etvoDOWNLOADRATEMULTI,CheckBox_TV_DOWNLOADRATEMULTI->isChecked());
	g_pConfig->SetTransferViewOptions(etvoELAPSEDTIMEMULTI,CheckBox_TV_ELAPSEDTIMEMULTI->isChecked());
	g_pConfig->SetUserUploadSlots(SpinBox_USERUPLOADSLOTS->value());

        if ( RadioButton_NONE->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectNONE );
	else if ( RadioButton_UPLOAD->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectUPLD );
	else if ( RadioButton_DOWNLOAD->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectDLD );
	else if ( RadioButton_BOTH->isChecked() )
		g_pConfig->SetHubOfflineTransferClose( ectBOTH );

	CList<DCConfigHubListUrl> hublisturllist;

	QCheckListItem * cli = (QCheckListItem*)ListView_HUBLISTURL->firstChild();

	while(cli)
	{
		DCConfigHubListUrl * hublisturl = new DCConfigHubListUrl();

		hublisturl->sUrl     = cli->text(0);
		hublisturl->bEnabled = cli->isOn();

		hublisturllist.Add(hublisturl);

		cli = (QCheckListItem*)cli->nextSibling();
	}

	g_pConfig->SetHubListUrlList(&hublisturllist);

	i=0;

	g_pConfig->SetChatColor(eccCHATTIMESTAMP,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccCHATLOCALNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccCHATLOCALTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccCHATREMOTENICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccCHATREMOTETEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccCHATSTATUSNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccCHATSTATUSTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICCHATTIMESTAMP,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICCHATLOCALNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICCHATLOCALTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICCHATREMOTENICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICCHATREMOTETEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICCHATSTATUSNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICCHATSTATUSTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICPRIVATECHATNICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICPRIVATECHATTEXT,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccCHATSAY,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
	g_pConfig->SetChatColor(eccPUBLICCHATMENICK,QColor(ListBox_CHATCOLOR->item(i++)->pixmap()->convertToImage().pixel(0,0)).name().ascii());
}

/** */
void DCOptions::SaveSharedFolders()
{
	CList<DCConfigShareFolder> sharedfolders;
	DCConfigShareFolder * csf;

	// save shared folders
	sharedfolders.Clear();

	QListViewItemIterator it( ListView_SHAREDFOLDERS );

	for ( ; it.current(); ++it )
	{
		csf = new DCConfigShareFolder();
		csf->m_sPath  = it.current()->text(0).ascii();
		csf->m_sAlias = it.current()->text(1).ascii();
		sharedfolders.Add(csf);
	}

	g_pConfig->SetSharedFolders( &sharedfolders );
}

/** */
void DCOptions::slotCreateShareList()
{
	SaveSharedFolders();

	if ( CFileManager::Instance() )
	{
		CFileManager::Instance()->CreateShareList();
	}
}

/** */
void DCOptions::slotShareListInfo()
{
	QString s;

	if ( CFileManager::Instance()->GetShareSize() == 0 )
	{
		s = tr("Share list not available");
	}
	else
	{
		s = tr("Compressed list size (HE3/BZ/XML): ") +
			QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtHE3)) + "/" +
			QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtBZ)) + "/" +
			QString().setNum(CFileManager::Instance()->GetShareBufferSize(esbtXMLBZ)) + " " +
			tr("bytes") + "\n" +
			tr("Total shared: ") +
			CUtils::GetSizeString(CFileManager::Instance()->GetShareSize(),g_pConfig->GetUnit()).Data();
	}

	QMessageBox::information( this, tr("Share List Info"), s );
}

/** */
void DCOptions::slotSetTheme()
{
	QString s;

	if ( g_pConfig->GetThemeSupport() == TRUE )
	{
		s = ComboBox_THEME->currentText();

		if ( s != "" )
		{
			QApplication::setStyle(s);
		}
	}
}

/** */
void DCOptions::slotBrowseLanguageFile()
{
	QString file;

	file = QFileDialog::getOpenFileName( "", "Language File (*.qm)", this, "blf", tr("Select language file") );

	if( file != "" )
	{
		LineEdit_LANGUAGEFILE->setText(file);
	}
}

/** */
void DCOptions::slotSelectLanguage()
{
	int id;
	QPopupMenu *m;
	CString s = "";

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenu( m, emiLANGUAGE_BOSNIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_BRAZILIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_CZECH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_DANISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_DUTCH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_ENGLISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_FINNISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_FRENCH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_GERMAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_GREEK );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_HUNGARIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_ICELANDIC );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_ITALIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_LATVIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_NORWEGIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_POLISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_ROMANIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_RUSSIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_SLOVAKIAN );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_SPANISH );
	DCMenuHandler::InsertMenu( m, emiLANGUAGE_SWEDISH );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == emiLANGUAGE_BOSNIAN )
		s = "valknut.bs.qm";
	else if ( id == emiLANGUAGE_BRAZILIAN )
		s = "valknut.pt_br.qm";
	else if ( id == emiLANGUAGE_CZECH )
		s = "valknut.cs.qm";
	else if ( id == emiLANGUAGE_DANISH )
		s = "valknut.da.qm";
	else if ( id == emiLANGUAGE_DUTCH )
		s = "valknut.nl.qm";
	else if ( id == emiLANGUAGE_ENGLISH )
		s = "";
	else if ( id == emiLANGUAGE_FINNISH )
		s = "valknut.fi.qm";
	else if ( id == emiLANGUAGE_FRENCH )
		s = "valknut.fr.qm";
	else if ( id == emiLANGUAGE_GERMAN )
		s = "valknut.de.qm";
	else if ( id == emiLANGUAGE_GREEK )
		s = "valknut.el.qm";
	else if ( id == emiLANGUAGE_HUNGARIAN )
		s = "valknut.hu.qm";
	else if ( id == emiLANGUAGE_ICELANDIC )
		s = "valknut.is.qm";
	else if ( id == emiLANGUAGE_ITALIAN )
		s = "valknut.it.qm";
	else if ( id == emiLANGUAGE_LATVIAN )
		s = "valknut.lv.qm";
	else if ( id == emiLANGUAGE_NORWEGIAN )
		s = "valknut.nb.qm";
	else if ( id == emiLANGUAGE_POLISH )
		s = "valknut.pl.qm";
	else if ( id == emiLANGUAGE_ROMANIAN )
		s = "valknut.ro.qm";
	else if ( id == emiLANGUAGE_RUSSIAN )
		s = "valknut.rus.qm";
	else if ( id == emiLANGUAGE_SLOVAKIAN )
		s = "valknut.sk.qm";
	else if ( id == emiLANGUAGE_SPANISH )
		s = "valknut.es.qm";
	else if ( id == emiLANGUAGE_SWEDISH )
		s = "valknut.sv.qm";

	if ( s != "" )
	{
		LineEdit_LANGUAGEFILE->setText(LineEdit_DATAFOLDER->text()+DIRSEPARATOR+"translation"+DIRSEPARATOR+s.Data());
	}
	else if ( id == emiLANGUAGE_ENGLISH )
	{
		LineEdit_LANGUAGEFILE->setText("");
	}
}

/** */
void DCOptions::slotBrowseAppFont()
{
  bool ok;
  QFont font = QFontDialog::getFont(&ok, QApplication::font(), this);
  if (ok == TRUE)
  {
	LineEdit_APPFONT->setText(font.toString());
  }
}

/** */
void DCOptions::slotAddHubListUrl()
{
	bool ok = FALSE;
	QString url;

	url = QInputDialog::getText(
		tr("HubList URL"),
		tr("Please enter a url"),
		QLineEdit::Normal, QString::null, &ok, this );

	if (ok)
	{
		new QCheckListItem( ListView_HUBLISTURL, url, QCheckListItem::CheckBox );
	}
}

/** */
void DCOptions::slotEditHubListUrl()
{
	QListViewItem * item = ListView_HUBLISTURL->currentItem();

	if ( !item )
		return;

	bool ok = FALSE;
	QString url;

	url = QInputDialog::getText(
		tr("HubList URL"),
		tr("Edit url"),
		QLineEdit::Normal, item->text(0), &ok, this );

	if (ok)
	{
		item->setText(0,url);
	}
}

/** */
void DCOptions::slotRemoveHubListUrl()
{
	QListViewItem * item = ListView_HUBLISTURL->currentItem();

	if (item)
	{
		ListView_HUBLISTURL->takeItem(item);
		delete item;
	}
}

/** */
void DCOptions::slotListViewOptionClicked( QListViewItem * item )
{
	if ( item == plviDCGUI )
	{
		TabWidget_DCGUI->setCurrentPage(0);
	}
	else if ( item == plviDCGUIIdentify )
	{
		TabWidget_DCGUI->setCurrentPage(0);
	}
	else if ( item == plviTransfer )
	{
		TabWidget_DCGUI->setCurrentPage(1);
		TabWidget_TRANSFER->setCurrentPage(0);
	}
	else if ( item == plviTransferFolder )
	{
		TabWidget_DCGUI->setCurrentPage(1);
		TabWidget_TRANSFER->setCurrentPage(0);
	}
	else if ( item == plviTransferSettings )
	{
		TabWidget_DCGUI->setCurrentPage(1);
		TabWidget_TRANSFER->setCurrentPage(1);
	}
	else if ( item == plviConnection )
	{
		TabWidget_DCGUI->setCurrentPage(2);
		TabWidget_CONNECTION->setCurrentPage(0);
	}
	else if ( item == plviConnectionMode )
	{
		TabWidget_DCGUI->setCurrentPage(2);
		TabWidget_CONNECTION->setCurrentPage(0);
	}
	else if ( item == plviConnectionSettings )
	{
		TabWidget_DCGUI->setCurrentPage(2);
		TabWidget_CONNECTION->setCurrentPage(1);
	}
	else if ( item == plviGUI )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(0);
	}
	else if ( item == plviGUIUser )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(3);
	}
	else if ( item == plviGUIChat )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(2);
	}
	else if ( item == plviGUITransfer )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(1);
	}
	else if ( item == plviGUIGeneral )
	{
		TabWidget_DCGUI->setCurrentPage(3);
		TabWidget_GUI->setCurrentPage(0);
	}
	else if ( item == plviSound )
	{
		TabWidget_DCGUI->setCurrentPage(4);
	}
	else if ( item == plviLog )
	{
		TabWidget_DCGUI->setCurrentPage(5);
	}
	else if ( item == plviOther )
	{
		TabWidget_DCGUI->setCurrentPage(6);
	}
	else if ( item == plviSecurity )
	{
		TabWidget_DCGUI->setCurrentPage(7);
	}
}
