/***************************************************************************
                          dcsplash.cpp  -  description
                             -------------------
    begin                : Fre Apr 12 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtranslator.h>
#include <qlabel.h>
#include <qpixmap.h>

#include <dciconloader.h>

#include "dcsplash.h"

#include <dclib/dcos.h>

#if QT_VERSION >= 0x030200
#define WSTYLE_SPLASH	Qt::WStyle_Splash
#else
#define WSTYLE_SPLASH	WStyle_NoBorder | WStyle_StaysOnTop | WStyle_Tool | WWinOwnDC | WX11BypassWM
#endif

/** */
DCSplash::DCSplash(QWidget *parent, const char *name, int /*wflags*/ ) : DCDialogSplash(parent,name,WSTYLE_SPLASH)
{
	QPixmap pm(g_pIconLoader->GetPixmap(eiSPLASH));

	Frame_PIXMAP->setBackgroundPixmap(pm);

	Frame_PIXMAP->setText( tr("Valknut " VERSION
				"\n\nMaintainer: Mathias Kster"
				"\nLogo: Mathias Kster"
				"\n\nhttp://dcgui.berlios.de"));

	Frame_PIXMAP->installEventFilter(this);
}

/** */
DCSplash::~DCSplash()
{
}

/** event filter */
bool DCSplash::eventFilter(QObject* object, QEvent* event)
{
	if ( (event->type() == QEvent::MouseButtonPress) ||
	     (event->type() == QEvent::MouseButtonRelease) ||
	     (event->type() == QEvent::MouseButtonDblClick) )
	{
		hide();
	}

	return QWidget::eventFilter( object, event );    // standard event processing
}
