/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/pixmaps.h"
#include "vdk/forms.h"
#include "vdk/colors.h"
#include "vdk/tooltips.h"
#include <stdio.h>
#include <string>
#include <unistd.h>
#include "vdk/rawpixmap.h"

extern void PixSize(int* width, int* height, char* filename);
/*
 */
VDKPixmap::VDKPixmap(VDKForm* owner,
		     char* pixfile,
		     char* tipString):
  VDKObject(owner)
{
  width = height = 0;
  widget = gtk_event_box_new();
  GdkBitmap *mask;

  if(!GTK_WIDGET_REALIZED(owner->Window()))
    gtk_widget_realize(owner->Window());

  if(pixfile)
    {
      GtkStyle* style = gtk_widget_get_style(owner->Window());
      pixmap = gdk_pixmap_create_from_xpm(owner->Window()->window,
					  &mask,
					  &style->bg[GTK_STATE_NORMAL],
					  pixfile);
      if(pixmap != NULL)
	{
	  pixmapWid = gtk_pixmap_new(pixmap,mask);
	  gtk_widget_show(pixmapWid);
	  PixSize(&width,&height,pixfile);
	  gtk_widget_set_usize(widget,width,height);
	  gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	}
      else
	pixmapWid = NULL;
    }
  else
    {
      pixmap = NULL;
      pixmapWid = NULL;
      tip = NULL;
    }
  oldRawPix = NULL;

  if(tipString)
    tip = new VDKTooltip(owner,this,tipString);
  else
    tip = NULL;

  gtk_signal_connect (GTK_OBJECT (widget), "button_press_event",
		      GTK_SIGNAL_FUNC(VDKObject::VDKEventPipe),this);
  ConnectDefaultSignals();

}
/*
 */
VDKPixmap::VDKPixmap(VDKForm* owner,
		     char** pixdata,
		     char* tipString):
  VDKObject(owner)
{
  width = height = 0;
  widget = gtk_event_box_new();
  GdkBitmap *mask;
  if(!GTK_WIDGET_REALIZED(owner->Window()))
    gtk_widget_realize(owner->Window());
  if(pixdata)
    {
      GtkStyle* style = gtk_widget_get_style(owner->Window());
      pixmap = gdk_pixmap_create_from_xpm_d(owner->Window()->window,
					    &mask,
					    &style->bg[GTK_STATE_NORMAL],
					    pixdata);
      if(pixmap != NULL)
	{
	  pixmapWid = gtk_pixmap_new(pixmap,mask);
	  sscanf (pixdata[0],"%d %d", &width, &height);
	  gtk_widget_set_usize(widget,width+1,height+1);
	  gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	  gtk_widget_show(pixmapWid);
	}
      else
	pixmapWid = NULL;
    }
  else
    {
      pixmap = NULL;
      pixmapWid = NULL;
      tip = NULL;
    }
  oldRawPix = NULL;

  if(tipString)
    tip = new VDKTooltip(owner,this,tipString);
  else
    tip = NULL;

  gtk_signal_connect (GTK_OBJECT (widget), "button_press_event",
		      GTK_SIGNAL_FUNC(VDKObject::VDKEventPipe),this);
  ConnectDefaultSignals();
}

VDKPixmap::~VDKPixmap()
{
  // VDK 0.5
  // this caused a:
  /*
    Gdk-ERROR **: BadAccess (attempt to access private resource denied)
    serial 2887 error_code 10 request_code 88 minor_code 0

    aborting...

    [1]+  IOT trap/Abort          (core dumped) testvdk
  */
  // problem should be further investigated...
  //---
  /*
    if(pixmap)
    gdk_pixmap_unref(pixmap);
  */
}
/*
 */
VDKRawPixmap* VDKPixmap::SetPixmap(char* file)
{
  return SetPixmap(new VDKRawPixmap(this,file));
}
/*
 */
VDKRawPixmap* VDKPixmap::SetPixmap(char** pixdata)
{
  return SetPixmap(new VDKRawPixmap(this,pixdata));
}


static void clear_widget(GtkWidget * widget);
VDKRawPixmap*
VDKPixmap::SetPixmap(VDKRawPixmap* newpix)
{
  VDKRawPixmap* oldpix;
  if(oldRawPix == newpix)
    return NULL;
  else
    {
      oldpix = oldRawPix;
      if(pixmap)
	{
	  pixmap = NULL;
	}
      if(pixmapWid)
	{
	    pixmap = *newpix;
	    gtk_pixmap_set (GTK_PIXMAP(pixmapWid),
			  pixmap,
			  newpix->Mask());
	    gtk_widget_queue_draw(pixmapWid);
	}	
      else
	{
	    pixmap = *newpix;
	    pixmapWid = gtk_pixmap_new(pixmap,newpix->Mask());
	    gtk_widget_set_usize(widget,newpix->Width(),newpix->Height());
	    gtk_container_add(GTK_CONTAINER(widget),pixmapWid);
	    gtk_widget_show(pixmapWid);
	}
      oldRawPix = newpix;
    }
  return oldpix;
}

void
clear_widget(GtkWidget * widget)
{
  gint x, y, w, h;

  x = widget->allocation.x;
  y = widget->allocation.y;
  w = widget->allocation.width;
  h = widget->allocation.height;

  /* Don't try to refresh an area if the width or height is 0. */
  if (w == 0 || h == 0)
    return;
  /* Clear */
  GdkWindow *window = widget->window;
  g_return_if_fail(window != NULL);
  gdk_window_clear_area (window, x, y, w, h);	
  gtk_widget_draw (widget, NULL);	
}


/*
 */
void VDKPixmap::Clear()
{
  if(! pixmapWid)
    return;
  GtkWidget* wid;
  GdkPixmap *pix;
  wid = pixmapWid;
  if(pixmap) 
    pix = pixmap; 
  else if(oldRawPix) 
    pix = *oldRawPix; 
  else 
    pix = NULL; 
  //  GdkPixmap *pix = pixmap ? pixmap : oldRawPix ? *oldRawPix : NULL ; 
  if(pix)
      {
	  gdk_draw_rectangle(pix,
			     wid->style->
			     bg_gc[GTK_WIDGET_STATE(wid)],
			     TRUE,
			     0,
			     0,
			     wid->allocation.width,
			     wid->allocation.height);
	  gtk_widget_queue_draw(wid);
      }
  //  gtk_widget_draw(wid,NULL);
}







