/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0.2
 * April 2002
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/vdkdockable.h>
/*
*/
VDKDockerBox:: VDKDockerBox (VDKForm* owner,  int mode):
  VDKBox (owner, mode), 
  justify(l_justify),
  fill(1),
  expand(1),
  padding(0),
  Docked ("Docked", this, false,
          &VDKDockerBox::SetDocked,
          &VDKDockerBox::GetDocked)
{
  dock_form = NULL;
}
/*
*/
VDKDockerBox::~VDKDockerBox ()
{
}
/*
*/
void
VDKDockerBox::Dock ()
{

  VDKObjectContainer *container = 
    dynamic_cast <VDKObjectContainer*>(parent);
   g_return_if_fail (container != NULL);
  if (container && !dock_form)
    {
    dock_form = new VDKDockerBoxForm (Owner (), NULL);
    container->RemoveObjectFromContainer (this);
    dock_form->box_from = container;
    dock_form->docker = this;
    dock_form->Add (this);
    dock_form->Objects ().remove (this);
    gtk_widget_unref (widget);
    dock_form->Show ();
    }
}
/*
*/
void
VDKDockerBox::Undock ()
{
  if (dock_form)
    dock_form->Close ();
  }

/*
*/
void
VDKDockerBox::SetDocked (bool flag)
{
  if (flag)
    {
      Dock ();
      SignalEmit(docked_signal);
      SignalEmit("docked");
    }
  else
    {
      Undock ();
    }
}

/*
*/
bool
VDKDockerBox::GetDocked ()
{
  return dock_form !=  NULL;
}
/*
  DOCKABLE FORM
*/
 VDKDockerBoxForm::VDKDockerBoxForm (VDKForm* owner,  char* title):
  VDKForm (owner, title), box_from (NULL),  docker (NULL)
{
}
/*
*/
VDKDockerBoxForm::~VDKDockerBoxForm ()
{
}
/*
*/
void 
VDKDockerBoxForm::Setup ()
{
}
/*
*/
bool
VDKDockerBoxForm::CanClose ()
{
  Box ()->RemoveObjectFromContainer (docker);
  box_from->Add (docker,docker->justify,docker->fill,docker->expand,docker->padding);
  gtk_widget_unref (docker->WrappedWidget ());
  docker->dock_form = NULL;
  docker->SignalEmit(undocked_signal);
  docker->SignalEmit("undocked");
  return true;
}
