/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#define VERBOSE 0
#if HAVE_CONFIG_H
#include <config.h>
#endif


#if !HAVE_GNOME
  #if ENABLE_NLS
#include <libintl.h>
//    #define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )

#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#endif
#include <sys/param.h>
#include <locale.h>
#include <vdkb2/vdkb_locale.h>
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_about.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/waitcursor.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include "./pixmaps/help.xpm"
#include "./pixmaps/options.xpm"
//////////////////////////////
#include "./pixmaps/vdkb.xpm"
#include "./pixmaps/quit.xpm"
#include "./pixmaps/convert.xpm"
#include "./pixmaps/project16.xpm"
#include "./pixmaps/debug.xpm"
//////// ide defaults ///////////////
/*
  emacs support
 */
extern bool EmacsServerStarted();
extern int StartEmacs(char ** args);
extern int EmacsPid();
//
VDKBDefaults VDKBuilder::ideDefaults;
VDKBuilder* TheApp = NULL;
extern char *gear_xpm[];
char buff[512];
// non vdk modal window stuff
static gboolean cmw_destroy_cb(GtkWidget *widget);
static bool install_resources(char* home);

// void create_nonvdk_modal_window (char* prompt);
static  GtkWidget *warning = NULL;
static void make_message_dialog (GtkWidget **dialog,
		     char* prompt,
                     GtkMessageType  type,
                     GtkButtonsType  buttons,
		     gint           default_response);

// file to open passed trough gnome MIME-type
char mime_file[256] = "";
///////global operational state //////
OpState  OperationalState = { op_ready, act_nope, tgt_no_target , NULL, NULL};
// global widget clipboard
VDKBWidgetClipboard* WidgetClipboard = NULL;
/*
  global DnD support
*/
enum {
  TARGET_STRING,
  TARGET_ROOTWIN,
  TARGET_URL
};

static GtkTargetEntry target_table[] = {
  { "STRING",0, TARGET_STRING },
  { "TEXT", 0, TARGET_STRING },
  { "URL", 0, TARGET_URL },
  { "application/x-rootwin-drop", 0, TARGET_ROOTWIN }
};
static guint n_targets = sizeof(target_table) / sizeof(target_table[0]);
VDKDnD *DragAndDrop = NULL;
DnDBuilderList* DragAndDropTable = NULL;

/*
editor completions, code templates and hints
*/
TokenList* tokenlist;
int tklist_size;
HintBTree* hint_tree;

/*
 a C interface with gtkeditor and al.
*/
extern "C"
{
  int GetEditorTab();
  int GetEditorExtAsciiSupport();
};

int GetEditorTab()
{
  return atoi((char*) VDKBuilder::ideDefaults.editor.tab);
}

int GetEditorExtAsciiSupport()
{
  char* extascii = VDKBuilder::ideDefaults.project.extascii;
  return !strcmp(extascii,CHECK_YES);
}

/*
this code denies to run
a second builder instance on the
same user
 */
/*
 */
static
bool create_lock_file(char* flock)
{
  int lockFile;
  if((lockFile=open(flock,O_CREAT|O_EXCL|O_WRONLY,0600)) != -1)
    {
      pid_t mypid=getpid();
      write(lockFile, (void*) &mypid, sizeof(pid_t));
      close(lockFile);
      return true;
    }
  else
    return false;
}
/*
 */
static
bool is_first_instance(char* flock)
{
  if(!create_lock_file(flock))
    {
    int lockFile;
    pid_t pid;
    lockFile = open(flock,O_RDONLY);
    read(lockFile, (void*) &pid, sizeof(pid_t));
    close(lockFile);
    if( (kill(pid,0)!= 0) && (errno == ESRCH) )
      { /*no process is holding the lock*/
	remove(flock);
	return create_lock_file(flock);
      }
    else /*another process is holding the lock*/
      return false;
    }
  else
    return true;
}
//////////////////////////////////////////////////////
/*
 */
int  AskUserToSaveFile(char* name)
{
  if( !TheApp)
    return IDNO;
  char local[256];
  VDKString Yes = CHECK_YES;
  if(VDKBuilder::ideDefaults.project.autosave == Yes)
    return IDYES;
  sprintf(local,"%s\n%s",name,
	  _(user_messages[user_request_save])
	  );
  return TheApp->MessageBox(APPNAME,
			    local,
			    MB_ICONQUESTION|MB_YESNO,
			    _(user_messages[user_ok]),
			    _(user_messages[user_no])
			    );
}

/////////////////////////
//      VDKBUILDER
/////////////////////////
VDKBuilder::VDKBuilder(int* argc, char** argv, char* rc):
#if HAVE_GNOME
  VDKGnomeApplication("vdkb","vdkb",argc,argv)	
#else
  VDKApplication(argc,argv,rc) 
#endif
{
#if USE_XDB
  theXdb = new VDKXDatabase;
#endif
}
VDKBuilder:: ~VDKBuilder()
{
#if USE_XDB
  if(theXdb)
    delete theXdb;
#endif
}

/////////////////////////////////////
//      VDK BUILDER ENTRY
/////////////////////////////////
#ifdef HAVE_GNOME
// static poptContext pctx;
/*
static struct poptOption options[] = {
  {
    NULL,
    '\0',
    0,
    NULL,
    0,
    NULL,
    NULL
  }
};
*/
#endif

int LANG = 1;
int main (int argc, char *argv[])
{
  char user_home[256];
  struct stat info;
  // disabled and substitued with NLS
  // look for lang support
  // forced to be: 
  LANG = ENGLISH;
  // localize
  // #ifdef VDKBDEBUG
  // char* i18n = NULL;
  // i18n = gtk_set_locale();
  /* 
  printf("\nLocalize to: %s",i18n ? i18n : "none");
  fflush(stdout);
  */
  // #else
  gtk_set_locale();
  // #endif
  //----------------------------------------------------
  // initialize gtk, safe since further inits do nothing
  //----------------------------------------------------
    // FIX ME:
    // this need a vdk change
#if 0 // HAVE_GNOME
  gnome_init_with_popt_table ("VDKBuilder", 
			      VERSION, 
			      argc, 
			      argv, 
			      options, 
			      0, 
			      &pctx);
#else
  gtk_init(&argc,&argv);
#endif
  /*
    read first arg, load a global buffer.
    Project manager will read it and open
    corresponding project file
   */
  if(argc == 2)
      strcpy(mime_file,argv[1]);
  else
    // set buffer to null
    *mime_file = '\0';

#if ENABLE_NLS
  bindtextdomain(PACKAGE,VDKB_LOCALE_DIR);
  textdomain(PACKAGE);
#endif
  // store home and pwd
  // get HOME
  char* homedir = getenv("HOME");
  if(!homedir)
    {
      make_message_dialog (&warning, 
			   ("No user home found,\nsorry i can't run VDKBuilder"),
			   GTK_MESSAGE_WARNING, 
			   GTK_BUTTONS_CLOSE, 
			   GTK_RESPONSE_OK);
      /*
      create_nonvdk_modal_window (_("No user home found,\n\
sorry i can't run VDKBuilder"));
      */
      exit(1);
    }
  else
    strcpy(user_home,homedir);
  //------------------------------------------------
  // set resource file, so will be loaded and parsed
  //------------------------------------------------
  sprintf(buff,"%s/.vdkb2/%s",user_home,VDKB_RESOURCE_FILE);
  if (stat(buff,&info) == -1)
    {
      //-------------------------------------
      // install local copy of resources file
      // into: <homedir>/.vdkb2/res
      //------------------------------------
      if(install_resources(homedir))
	sprintf(buff,
_("VDKBuilder has installed:\
\nvdkide.defaults\
\nvdkbrc\
\nplugins.db\
\ntokens.db\
\ninto your home: %s/.vdkb2/res"),homedir);
      else
	sprintf(buff,_("* WARNING * VDKBuilder couldn't install \
vdkbuilder resources into your home: %s"),homedir);

      make_message_dialog (&warning, 
			   buff,
			   GTK_MESSAGE_WARNING, 
			   GTK_BUTTONS_CLOSE, 
			   GTK_RESPONSE_OK);

//      create_nonvdk_modal_window (buff);
      sprintf(buff,"%s/.vdkb2/%s",user_home,VDKB_RESOURCE_FILE);
    }
  // something went wrong on installing resource files
  if (stat(buff,&info) == -1)
    {
      sprintf(buff,
      _("Local resource file:%s/.vdkb2/%s not found\nrevert to default one"),
	      user_home,VDKB_RESOURCE_FILE);
      make_message_dialog (&warning, 
			   buff,
			   GTK_MESSAGE_WARNING, 
			   GTK_BUTTONS_CLOSE, 
			   GTK_RESPONSE_OK);
      //       create_nonvdk_modal_window (buff);
      sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_RESOURCE_FILE);
    }
  else
    {
      // install tokens database for editor completions
      char command[256];
      sprintf(command,"%s/.vdkb2/%s",user_home,VDKB_TOKENS_FILE);
      if(access(command,F_OK))
	{
	  sprintf(command,"cp %s/%s %s/.vdkb2/res",
		  VDKB_DATADIR,
		  VDKB_TOKENS_FILE,
		  user_home);
	  system(command);
	}
      // install hints database for editor
      sprintf(command,"%s/.vdkb2/%s",user_home,VDKB_HINT_FILE);
      if(access(command,F_OK))
	{
	  sprintf(command,"cp %s/%s %s/.vdkb2/res",
		  VDKB_DATADIR,
		  VDKB_HINT_FILE,
		  user_home);
	  system(command);
	}
    }

  //---------------------------------------------------------------
  // check for a lock file (denies more than one instance per user)
  //---------------------------------------------------------------
  char *local = new char[512];
  sprintf(local,"%s/.vdkb2/%s",user_home,VDKB_LOCKFILE);
  if(!is_first_instance(local))
    {

      sprintf(buff,_("Lock file:%s\ndetected another instance\n\
sorry i can't run VDKBuilder twice,\n\
either kill running instance or remove lock file"),local);
      make_message_dialog (&warning, 
			   buff,
			   GTK_MESSAGE_WARNING, 
			   GTK_BUTTONS_CLOSE, 
			   GTK_RESPONSE_OK);
      //      create_nonvdk_modal_window (buff); 
      delete[] local;
      exit(1);
    }
  else
    delete[] local;
  //-------------------
  // builds application
  // with VDKB_RESOURCE_FILE
  // and setting localization
  //-------------------
  VDKBuilder app(&argc, argv);
  // set global <TheApp>
  TheApp = &app;
  // sets home dir
  if(homedir)
    app.user_home = homedir;
   // gets and sets prg work dir
  char* cwd = getcwd(NULL,MAXPATHLEN);
  if(cwd)
    {
      app.user_cwd = cwd;
      free(cwd);
    }
  else
    app.user_cwd = app.user_home;
  //------------------
  // load ide defaults
  //------------------
  VDKBuilder::ideDefaults.LoadDefaults(app.user_home);
  VDKString Yes = CHECK_YES;
  // set resource file if requested
  if(VDKBuilder::ideDefaults.project.theme == Yes)
    app.SetResourceFile(buff);
  // change to HOME or to startup dir
  VDKString startupdir = VDKBuilder::ideDefaults.project.startupdir;
  VDKString Home = "home";
  if(startupdir == Home)
    chdir((char*) app.user_home);
  else
    {
      if(chdir((char*) startupdir) < 0)
	{
	  sprintf(buff,_("\nCould not change to dir:%s\nreverting to home"),
		 (char*) startupdir);
	  make_message_dialog (&warning, 
			       buff,
			       GTK_MESSAGE_WARNING, 
			       GTK_BUTTONS_CLOSE, 
			       GTK_RESPONSE_OK);
      // 	  create_nonvdk_modal_window (buff);	
	  chdir((char*) app.user_home);
	}
    }
  //-------------
  // load plugins
  //-------------
  //   FIX ME:
  sprintf(buff,"%s/.vdkb2/%s",(char*) app.user_home,VDKB_PLUGIN_FILE);
  if (stat(buff,&info) == -1)
      {
	char local[256];
	sprintf(local,_("\nUser file:%s\nnot found, using default"),buff);
	make_message_dialog (&warning, 
			     buff,
			     GTK_MESSAGE_WARNING, 
			     GTK_BUTTONS_CLOSE, 
			     GTK_RESPONSE_OK);
	// 	create_nonvdk_modal_window (local);
	sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_PLUGIN_FILE);
      }
  if(!app.PluginList().Load(buff))
    {
      // deactivated warning
      sprintf(buff,_("\nError during loading plugins.db"));
      make_message_dialog (&warning, 
			   buff,
			   GTK_MESSAGE_WARNING, 
			   GTK_BUTTONS_CLOSE, 
			   GTK_RESPONSE_OK);
      //       create_nonvdk_modal_window (buff);	
     }
  else if(! app.PluginList().DlOpen())
    {
      sprintf(buff,_("\nError during opening plugins"));
      make_message_dialog (&warning, 
			   buff,
			   GTK_MESSAGE_WARNING, 
			   GTK_BUTTONS_CLOSE, 
			   GTK_RESPONSE_OK);
      //      create_nonvdk_modal_window (buff);	
    } 
  
  //-------------
  // builder runs
  //-------------
  app.Run();
  //---------------
  // builder quiets
  //---------------
  /*
    this trick avoid to segfault if plugins are disconnected before
    main form deleting.  Otherwise garbage collection finds corrupted
    object pointers. So before delete MainForm and after disconnect plugins.
  */
  delete app.MainForm;
  // this must be done otherwise mainForm will be deleted twice.
  // by app destructor
  app.MainForm = NULL;
  // closes plugins

  if(!app.PluginList().DlClose())
    {
      sprintf(buff,_("\nError during closing plugins"));
      make_message_dialog (&warning, 
			   buff,
			   GTK_MESSAGE_WARNING, 
			   GTK_BUTTONS_CLOSE, 
			   GTK_RESPONSE_OK);
      //      create_nonvdk_modal_window (buff);	
    }
  // destroy lock file
  sprintf(buff,"%s/.vdkb2/%s",
	  (char*) app.user_home,
	  VDKB_LOCKFILE);
  remove(buff);
  // change to current cwd
  chdir((char*) app.user_cwd);
  return 0;
}
////////////////////////////////
// VDKBUILDER MAIN FORM CLASS
////////////////////////////////
/*
 */
bool
VDKBMainForm::About(VDKObject*)
{
  VDKBAboutForm *about = new VDKBAboutForm(this);
  about->Setup();
  about->ShowModal();
  return true;
}
/*
 */
bool
VDKBMainForm::Quit(VDKObject*)
{

  Close();
  return true;
}
/*
Constructor
*/
VDKBMainForm::VDKBMainForm( VDKApplication* app, gchar* title):
  VDKForm(app,title)
{
  // set subsystem pointers to NULL
  editor = NULL;
  prjman = NULL;
  maker = NULL;
  lrumanager = NULL;
  formlistform = NULL;
  // global widget clipboard
  WidgetClipboard = new VDKBWidgetClipboard;
  // global drag and drop
  // temporarly disabled due to a gtk+ bug
  DragAndDrop = new VDKDnD(this, target_table,n_targets);
  DragAndDropTable = new DnDBuilderList;
}
/*
Destructor
 */
VDKBMainForm::~VDKBMainForm()
{
if(WidgetClipboard)
  delete WidgetClipboard;
if(DragAndDropTable)
  delete DragAndDropTable;
 if(lrumanager)
   delete lrumanager;
}
/*
  Save words completions list to file
 */
bool
VDKBMainForm::SaveTokens()
{
  FILE* fp = (FILE*) NULL;
  sprintf(buff,"%s/.vdkb2/%s",(char*) TheApp->user_home,VDKB_TOKENS_FILE);
  fp = fopen(buff,"w+");
  if(fp)
    {
      for(TokenListIterator li(*tokenlist);li;li++)
	  fprintf(fp,"%s\n",(char*) li.current());
      fclose(fp);
    }
  return fp != (FILE*) NULL;
}
/*
  Load words completions list from file
 */
bool
VDKBMainForm::LoadTokens()
{
  FILE* fp;
  sprintf(buff,"%s/.vdkb2/%s",(char*) TheApp->user_home,VDKB_TOKENS_FILE);
  if(access(buff,F_OK))
    {
      TheApp->MessageBox(APPNAME,
_("User file for completions not found\n\
reverting to default one"),
			 MB_ICONINFORMATION|MB_OK,
			 _(user_messages[user_ok])
			 );
      sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_TOKENS_FILE);
    }
  fp = fopen(buff,"r");
  if(fp)
    {
      char token[256];
      while(fgets(token,256,fp))
	{
	  token[strlen(token)-1] = '\0';
	  VDKString tk = token;
	  tokenlist->add(tk);
	}
      fclose(fp);
      return true;
    }
  else
    return false;
}

/*
  Load hints from file
 */
#define HINT (char*) "HINT{"
#define HINT_END (char*) "}"
#define HINT_KEY (char*)  "KEY["
#define TEXT_KEY (char*)  "TEXT["
#define KEY_END (char*) "]"
bool
VDKBMainForm::LoadHints()
{
  FILE* fp;
  sprintf(buff,"%s/.vdkb2/%s",
	  (char*) TheApp->user_home,
	  VDKB_HINT_FILE);
  if ( !(fp = fopen(buff,"r")) )
    return false;
  else
    {
      char* buffer,*p,*section;
      int c;
      struct stat info;
      stat(buff,&info);
      unsigned int size = info.st_size;
      buffer = p = new char[size+1];
      while( (c = fgetc(fp)) != EOF)
	*p++ = (char) c;
      *p ='\0';
      fclose(fp);
      // parse buffer
      p = buffer;
      while( ( section  = ExtractSection(p,HINT,HINT_END)) )
	{
	  char key[128];
	  char text[512];
	  if(ExtractWord(p,key,HINT_KEY,KEY_END) &&
	     ExtractWord(p,text,TEXT_KEY,KEY_END) )
	    {
	      VDKHint hint(key,text);
	      hint_tree->add(hint);
	      // + 1 for a new line that should separate hints
	      p += strlen(HINT)+strlen(HINT_END)+strlen(section)+1;
	      delete[] section;
	    }
	  else
	    {
	      delete[] section;
	      break;
	    }

	}
      delete[] buffer;
      return true;
    }
}
/*
Setup
 */
void
VDKBMainForm::Setup()
{
  logo = new VDKBLogo(this);
  logo->Setup();
  logo->Show();
  // load token list from file
  tokenlist = new TokenList;
  if(!LoadTokens())
    TheApp->MessageBox(APPNAME,
      _("Completion list not loaded\ncompletion won't be available"),
		       MB_ICONINFORMATION|MB_OK,
		       _(user_messages[user_ok]),
		       NULL,
		       3000
		       );
  else
    tklist_size = tokenlist->size();
  // load hints tree for text editor
  hint_tree = new HintBTree;
  if(!LoadHints())
    TheApp->MessageBox(APPNAME,
      _("Hints tree not loaded\neditor hints won't be available"),
		       MB_ICONINFORMATION|MB_OK,
		       _(user_messages[user_ok])
		       );

  // setup for Mozilla
  mozpid = 0;
  SignalConnect("KillMozillaSignal",&VDKBMainForm::MozillaMourn, false);
  struct sigaction *sac = new struct sigaction;
  sigemptyset(&(sac->sa_mask));
  sac->sa_flags=0;
  sac->sa_handler = VDKBMainForm::MozillaReaper;
  sigaction(SIGCHLD, sac, NULL);
  }
/*
  Manages child closing
*/
void
VDKBMainForm::OnChildClosing(VDKForm* child)
{
if(child == logo)
  {
      logo = NULL;
      ContinueSetup(NULL);
      Visible = true;
  }
else if(child == editor)
  {
    Automa(automa_editor_off);
    editor = NULL;
  }
else if(child == prjman)
  {
    Automa(automa_prjman_off);
    prjman = NULL;
  }
else if(child == maker)
  {
    if(! maker->IsModal())
      {
	// load editor with errors
	VDKBStringList* list = maker->ErrorList();
	if(list)
	  {

	    sprintf(buff,_("VDKBuilder maker terminated %s"),
		    list->size() ? _("with errors or messages") : 
			   _("successfully"));
	    Application()->MessageBox(APPNAME,buff,
				      MB_OK| MB_ICONINFORMATION,
				      _(user_messages[user_ok]),
				      NULL, 1500);
	    // if list size == 0 then no erros, so
	    // we add an happy message
	    if(! list->size())
	      {
		VDKString s = _("Compilation successfull");
		list->add(s);
	      }

	    // in vdkb_acsupport.cc
	    LoadEditorWithErrors(list);
	    delete list;
	  }
      }
    maker = NULL;
  }
else if(child == formlistform)
  {
    formlistform = NULL;
  }
}
/*
Finishes main form set up
 */
/*
  NLS translation tables
 */
extern char* folder_widget_titles[];

bool
VDKBMainForm::ContinueSetup(VDKObject*)
{
  SetIcon(new VDKRawPixmap(this,vdkb_xpm));
  SetIconName(APPNAME);
  MakeMainMenu();
  VDKBox* hbox = new VDKBox(this,h_box);
   hbox->Add(MakeToolBox(),FALSE,FALSE,0);
   hbox->Add(new VDKSeparator(this,v_separator),FALSE,FALSE,0);
     VDKBox* vbox = new VDKBox(this);
     widget_folder = new VDKNotebook(this);
     vbox->Add(widget_folder);
   hbox->Add(vbox);
  Add(hbox);
  widget_folder->AddPage(MakeContainerWidgetFolder(),
			 _(folder_widget_titles[1])
			 );
  widget_folder->AddPage(MakeButtonsWidgetFolder(),
			 _(folder_widget_titles[0])
			 );
  widget_folder->AddPage(MakeMiscWidgetFolder(),
			 _(folder_widget_titles[3])
			 );
  widget_folder->AddPage(MakeTextWidgetFolder(),
			 _(folder_widget_titles[4])
			 );
  widget_folder->AddPage(MakePluginWidgetFolder(),
			 _(folder_widget_titles[5])
			 );
#if HAVE_GNOME
  widget_folder->AddPage(MakeGnomeWidgetFolder(),
			 _(folder_widget_titles[6])
			 );
#endif
#if USE_XDB
  widget_folder->AddPage(MakeXdbWidgetFolder(),
			 _(folder_widget_titles[7])
			 );
#endif
  //_defSize = VDKPoint((gdk_screen_width()*9)/10,-1/*100*/);  
  _defSize = VDKPoint(gdk_screen_width()-10,-1);  
  SetSize(_defSize.x,_defSize.y);
  // does not allow to shrink or grow
  gtk_window_set_policy(GTK_WINDOW(Window()),false,false,true);
  return true;
}
/*
 */
void
VDKBMainForm::OnShow(VDKForm* )
{
  // set main form position near to upper right
  // screen corner
  Position = VDKPoint(30,30);
  // set automa initial state
  Automa(automa_init);
  // make and open project manager
  if(!prjman)
  {
    prjman = new VDKBProjectManager(this);
    prjman->Setup();
    prjman->Visible = true;
  }
}
/*
Intercepts moving
 */
void
VDKBMainForm::OnMove(VDKForm* )
{
}
/*
intercepts activate
*/
void 
VDKBMainForm::OnFormActivate(VDKForm* sender, bool in_out)
{
  /*
    disabled since unuseful and somewhat confusing
    if(! in_out)
    return;
    // raises main form childs
    ChildListIterator li(Childs());
    for(;li;li++)
    {
    if(! li.current()->Iconized)
    li.current()->Raise();
    }
    // raises also gui editors if any
    if(prjman)
    {
    GuiFormListIterator li(*(prjman->FormList()));
    for(;li;li++)
    {
    if(! li.current()->Iconized)
    li.current()->Raise();
    }
    if(prjman->objInspector && ! prjman->objInspector->Iconized)
    prjman->objInspector->Raise();
    }
  */
}
/*
Intercepts resizing, forcing
to default size
Changed: 30.12.98 mm
using gtk_window_set_policy()
that's better
 */
void
VDKBMainForm::OnResize(VDKForm* ,VDKPoint& )
{
  /*
  if(_defSize != p)
    SetFormSize(_defSize);
  */
}
//////////////////////////////////////////
// Makes main form interface
// all pixmaps, prompts, menus
// loaded from locale
//////////////////////////////////////////
/*
Makes VDKBuilder ManForm main menu
 */
/*
  NLS translation tables
 */
extern char* main_menu_prompts[];

void
VDKBMainForm::MakeMainMenu()
{
  menubar       =   new VDKMenubar(this);
  // file menu
  file_menu     =   new VDKMenuItem(menubar,
				    _(main_menu_prompts[0])
				    );
  VDKMenu *menuf =   new VDKMenu(this);
  new_item      =   new VDKMenuItem(menuf,
				    _(main_menu_prompts[1])
				    );
  VDKMenu      *newmenu = new VDKMenu(this);
  newprj_item  = new VDKMenuItem(newmenu,
				 _(main_menu_prompts[2]),
				 main_menu_pixmaps[0]);
  newunit_item = new VDKMenuItem(newmenu,
				 _(main_menu_prompts[3]),
				 main_menu_pixmaps[1]);
  newform_item = new VDKMenuItem(newmenu,
				 _(main_menu_prompts[4]),
				 main_menu_pixmaps[2]);
  newformmenu = new VDKMenu(this);
  newformdefault_item = new VDKMenuItem(newformmenu,
					_(main_menu_prompts[5]),
					main_menu_pixmaps[2]);
  newform_item->Add(newformmenu);
  new_item->Add(newmenu);

  open_item     =   new VDKMenuItem(menuf,
				    _(main_menu_prompts[8])
				    );
  VDKMenu      *openmenu = new VDKMenu(this);
  openprj_item  = new VDKMenuItem(openmenu,
				  _(main_menu_prompts[9]),
				  main_menu_pixmaps[3]);
  openfile_item = new VDKMenuItem(openmenu,
				  _(main_menu_prompts[10]),
				  main_menu_pixmaps[4]);
  open_item->Add(openmenu);

  // reopening menu
  reopen_item  =  new VDKMenuItem(menuf, _(main_menu_prompts[49]));
  reopenmenu = new VDKMenu(this);
  /* 
     Creates a lru manager
     LRUManager::Init() fills a list with lru projects name
  */
  lrumanager = new LRUManager();
  lrumanager->Init();
  // update reopenmenu adding subitems and connecting them
  // to a single response function
  UpdateLRU();
  reopen_item->Add(reopenmenu);


  save_item     =   new VDKMenuItem(menuf,
				    _(main_menu_prompts[11]),
				    main_menu_pixmaps[5]);
  saveall_item   =   new VDKMenuItem(menuf,
				     _(main_menu_prompts[12]),
				     main_menu_pixmaps[6]);


  menuf->Separator();
  quit_item     =   new VDKMenuItem(menuf,
				    _(main_menu_prompts[13])
				    );
  file_menu->Add(menuf);
  


  // Search menu
  search_menu = new VDKMenuItem(menubar,
				_(main_menu_prompts[15])
				);
  VDKMenu *searchv = new VDKMenu(this);
  search_item = new VDKMenuItem(searchv,
				_(main_menu_prompts[30]),
				main_menu_pixmaps[11]);
  repeat_search_item = new VDKMenuItem(searchv,
				       _(main_menu_prompts[31])
				       /*, main_menu_pixmaps[xx]*/
				       );
  replace_item = new VDKMenuItem(searchv,
				 _(main_menu_prompts[32])
				 /*, main_menu_pixmaps[yy]*/
				 );
  search_menu->Add(searchv);
  
  // View menu
  view_menu = new VDKMenuItem(menubar,
			      _(main_menu_prompts[16])
			      );
  VDKMenu *menuv = new VDKMenu(this);
  viewunits_item = new VDKMenuItem(menuv,
				   _(main_menu_prompts[17]),
				   main_menu_pixmaps[7]);
  viewforms_item = new VDKMenuItem(menuv,
				   _(main_menu_prompts[18]),
				   main_menu_pixmaps[8]);
  view_menu->Add(menuv);
  // Project menu
  prj_menu = new VDKMenuItem(menubar,
			     _(main_menu_prompts[19]),
			     project16_xpm
			     );
  VDKMenu *menup = new VDKMenu(this);
  prjmake_item = new VDKMenuItem(menup,
				 _(main_menu_prompts[27]),
				 // stolen to project manager
				 gear_xpm);
  prjmakeclean_item = new VDKMenuItem(menup,
				      _(main_menu_prompts[29]),
				      NULL);
  prjdebug_item = new VDKMenuItem(menup,
				  _(main_menu_prompts[36]),
				  debug_xpm);
  menup->Separator();
  prjoptions_item = new VDKMenuItem(menup,
				    _(main_menu_prompts[28]),
				    options_xpm
				    );
#if USE_XDB
  xdb_opentables = new VDKMenuItem(menup,
				   _(main_menu_prompts[47]),
				   NULL);
#endif
  prj_menu->Add(menup);
  // Component menu
  compo_menu = new VDKMenuItem(menubar,
			       _(main_menu_prompts[22]),
			       convert_xpm);
  // Tools menu
  tools_menu = new VDKMenuItem(menubar, _(main_menu_prompts[23]),options_xpm );
  VDKMenu* menut = new VDKMenu(this);
  // environment setup
  envset_item = new VDKMenuItem(menut,
				_(main_menu_prompts[37]),
				options_xpm);
  edhint_item = new VDKMenuItem(menut,
				_(main_menu_prompts[50]),
				NULL);
  // grep
  exec_item = new VDKMenuItem(menut,
			      _(main_menu_prompts[38]),
				   NULL);
  exec_item->Enabled = false;
  tools_menu->Add(menut);
  // automake/autoconf support
  ac_menu = new VDKMenuItem(menubar,
			    _(main_menu_prompts[39]),
			    main_menu_pixmaps[12]);
  VDKMenu *menuac = new VDKMenu(this);
  ac_autogen = new VDKMenuItem(menuac,
			       _(main_menu_prompts[40]),
			       NULL);
  ac_make = new VDKMenuItem(menuac,
			    _(main_menu_prompts[41]),
			    NULL);
  ac_makeclean = new VDKMenuItem(menuac,
				 _(main_menu_prompts[42]),
				 NULL);
  ac_makedist = new VDKMenuItem(menuac,
				_(main_menu_prompts[43]),
				NULL);
  ac_makedistclean = new VDKMenuItem(menuac,
				     _(main_menu_prompts[44]),
				     NULL);
  ac_menu->Add(menuac);
  ac_menu->Enabled = false;
  // help menu
  help_menu     =   new VDKMenuItem(menubar,
				    _(main_menu_prompts[24]),
				    help_xpm,
				    r_justify);
  VDKMenu *menuh =  new VDKMenu(this);
  // tutorial removed
  /*
  help_index    =   new VDKMenuItem(menuh,
				    _(main_menu_prompts[25])
				    );
  */
  help_vdk    =   new VDKMenuItem(menuh,
				  _(main_menu_prompts[45])
				  );
  menuh->Separator();
  help_about    =   new VDKMenuItem(menuh,
				    _(main_menu_prompts[26])
				    );
  help_menu->Add(menuh);
  Add(menubar,FALSE,FALSE,0);
}

/*
  lru list visited to add menu sub-items and connect them to a single
  response, load an array of menu items adrresses as well.
  Array will be parsed by response function to retrieve which item
  has been activated.
*/
void
VDKBMainForm::UpdateLRU()
{
  int t = 0;
  // removes menu items from menu
  for(;t < lru_items.size();t++)
    {
      lru_items[t]->Visible = false;
      gtk_container_remove (GTK_CONTAINER (reopenmenu->WrappedWidget()), 
			    lru_items[t]->WrappedWidget());
    }
  // readd new items
  if(lrumanager->ItemList().size() > 0)
    {
      t = 0;
      // resize menu item array
      lru_items.resize(lrumanager->ItemList().size());
      VDKMenuItem* menu_item;
      LRUItemsIterator li(lrumanager->ItemList());
      for(;li;li++,t++)
	{
	  // retrieves project name from list item
	  const char* prompt = li.current().Name();
	  // makes menu items without accelerator
	  // to avoid be confusing by file names with underscores
	  menu_item = new VDKMenuItem(reopenmenu,
				      prompt,
				      NULL, // no pixmap
				      GDK_VoidSymbol,
				      GDK_MOD1_MASK,
				      false);
	  lru_items[t] = menu_item;
	  SignalConnect(menu_item,"activate",
			&VDKBMainForm::OnReopenMenu);
	}
      reopen_item->Enabled = true;
    }
  else
    // lru list was empty so disable reopen menu
    reopen_item->Enabled = false;
  return;
}

 /*
    NLS translation tables
  */
extern char *main_toolbar_tips[];
extern char *main_toolbar1_tips[];

VDKBox*
VDKBMainForm::MakeToolBox()
{
  int t;
  VDKBox* vbox = new VDKBox(this,v_box);
  VDKFrame* frame = new VDKFrame(this,NULL,h_box,shadow_etched_in);
  VDKFrame* frame1 = new VDKFrame(this,NULL,h_box,shadow_etched_in);
  VDKBox *tbar = new VDKBox(this,h_box);
  newprj_nb =   nb_array[0] = new VDKHLButton(this,(const char**)main_toolbar_pixmaps[0]);
  newprj_nb->SetTip(_(main_toolbar_tips[0]));
  newunit_nb =  nb_array[1] = new VDKHLButton(this,(const char**)main_toolbar_pixmaps[1]);
  newunit_nb->SetTip(_(main_toolbar_tips[1]));
  newform_nb =  nb_array[2] = new VDKHLButton(this,(const char**)main_toolbar_pixmaps[2]);
  newform_nb->SetTip(_(main_toolbar_tips[2]));
  loadprj_nb =  nb_array[3] = new VDKHLButton(this,(const char**)main_toolbar_pixmaps[3]);
  loadprj_nb->SetTip(_(main_toolbar_tips[3]));
  loadfile_nb = nb_array[4] = new VDKHLButton(this,(const char**)main_toolbar_pixmaps[4]);
  loadfile_nb->SetTip(_(main_toolbar_tips[4]));
  saveprj_nb =  nb_array[5] = new VDKHLButton(this,(const char**)main_toolbar_pixmaps[5]);
  saveprj_nb->SetTip(_(main_toolbar_tips[5]));
  savefile_nb = nb_array[6] = new VDKHLButton(this,(const char**)main_toolbar_pixmaps[6]);
  savefile_nb->SetTip(_(main_toolbar_tips[6]));
  nb_array[7] = NULL;

  for( t=0; nb_array[t]; t++)
      tbar->Add(nb_array[t],l_justify,false,false,0);
  frame->Add(tbar,l_justify,false,false,0);
  //vbox->Add(tbar);
  vbox->Add(frame,l_justify,false,false,0);
  /* 
  toolbar = new VDKToolbar(this);
  for( t=0; main_toolbar_pixmaps[t]; t++)
    {
      toolbar->AddButton(main_toolbar_pixmaps[t],
			 _(main_toolbar_tips[t]),
			 NULL);
    }
  vbox->Add(toolbar);
  */

// vbox->Add(new VDKSeparator(this,h_separator),FALSE,FALSE,0);

  VDKBox *tbar1 = new VDKBox(this,h_box);
  //toolbar1 = new VDKToolbar(this);
  // toolbar->Borderless = true;
  /*
  toolbar1->AddButton(main_menu_pixmaps[7],
		      _(main_menu_prompts[17]),
		      NULL);
  */
  unitlist_nb = nb_array1[0] = new VDKHLButton(this,(const char**) main_menu_pixmaps[7]);
  unitlist_nb->SetTip(_(main_menu_prompts[17]));
  tbar1->Add(unitlist_nb,l_justify,false,false,0);
  /*
  toolbar1->AddButton(main_toolbar1_pixmaps[0],
		      _(main_toolbar1_tips[0]),
		      NULL);
  */
  toggle_nb = nb_array1[1] = new VDKHLButton(this,(const char**) main_toolbar1_pixmaps[0]);
  toggle_nb->SetTip(_(main_toolbar1_tips[0]));
  tbar1->Add(toggle_nb,l_justify,false,false,0);
  /*
  toolbar1->AddButton(main_menu_pixmaps[8], 
		      _(main_menu_prompts[18]),
		      NULL);
  */
  formlist_nb = nb_array1[2] = new VDKHLButton(this,(const char**) main_menu_pixmaps[8]);
  formlist_nb->SetTip(_(main_menu_prompts[18]));
  tbar1->Add(formlist_nb,l_justify,false,false,0);
  /* 
  toolbar1->AddButton(main_toolbar1_pixmaps[1],
		      _(main_toolbar1_tips[1]),
		      NULL); 
  */
  runprj_nb = nb_array1[3] = new VDKHLButton(this,(const char**) main_toolbar1_pixmaps[1]);
  runprj_nb->SetTip(_(main_toolbar1_tips[1]));
  tbar1->Add(runprj_nb,l_justify,false,false,0);
  // ends array
  nb_array1[4] = NULL;

  // reset = new VDKCustomButton(this,(const char**) main_toolbar1_pixmaps[2],NULL);
  reset = new VDKHLButton(this,(const char**) main_toolbar1_pixmaps[2],NULL);
  reset->SetTip(_(main_toolbar1_tips[2]));
  // reset->Relief = GTK_RELIEF_NONE;
  reset->Enabled = false;
  // toolbar1->AddWidget(reset);
  tbar1->Add(reset,l_justify,false,false,0);
  //  emacs = new VDKCustomButton(this, (const char**) main_toolbar1_pixmaps[3],NULL);
  emacs = new VDKHLButton(this, (const char**) main_toolbar1_pixmaps[3],NULL);
  emacs->SetTip(_(main_toolbar1_tips[3]));
  // emacs->Relief = GTK_RELIEF_NONE;
  // toolbar1->AddWidget(emacs);
  tbar1->Add(emacs,l_justify,false,false,0);
  emacs->Visible = !strcmp((char*) VDKBuilder::ideDefaults.project.emacs,CHECK_YES);

  VDKHLButton* quit_nb =  new VDKHLButton(this,(const char**) quit_xpm);
  quit_nb->SetTip(_("Quit VDKBuilder"));
  tbar1->Add(quit_nb,l_justify,false,false,0);
  SignalConnect(quit_nb,"clicked",&VDKBMainForm::Quit,false);
  frame1->Add(tbar1,l_justify,false,false,0);
  //vbox->Add(tbar);
  vbox->Add(frame1,l_justify,false,false,0);
  // vbox->Add(toolbar1);
  // vbox->Add(tbar1);
  return vbox;
}
/*
  NLS translation tables
 */
extern char *container_widgets_tips[];
/*
 */
//VDKToolbar*
VDKHLButtonBar*
VDKBMainForm::MakeContainerWidgetFolder()
{
  int t = 0;
  //  containers_widgets_bar = new VDKToolbar(this);
  containers_widgets_bar = new VDKHLButtonBar(this,h_box,shadow_etched_in);
  for(; t < CONTAINER_WIDGETS_TIPS; t++)
    {
	containers_widgets_bar->AddButton((const char**) container_widgets_pixmaps[t],
					  _(container_widgets_tips[t]),
					  NULL);
	// containers_widgets_bar->AddSpace();
	// add toolbar buttons to dnd support
	if(DragAndDrop)
	  {
	    DragAndDrop->AddSource((*containers_widgets_bar)[t]);
	    DragAndDrop->SetIcon((*containers_widgets_bar)[t],
			     new VDKRawPixmap(this,
					      container_widgets_pixmaps[t]));
	    // load builder dnd table
	    DnDBuilderEntry entry((*containers_widgets_bar)[t],
				  CONTAINERS_TOOL_BEGIN+t);
	    DragAndDropTable->add(entry);
	  }
    }
  // containers_widgets_bar->Borderless = true;
  SignalConnect(containers_widgets_bar,"clicked",&VDKBMainForm::HandleAllWidgetsBar,false);
  return containers_widgets_bar;
}
/*
  NLS translation tables
 */
extern char * button_widgets_tips[];
/*
 */
//VDKToolbar*
VDKHLButtonBar*
VDKBMainForm::MakeButtonsWidgetFolder()
{
  int t = 0;
  //  button_widgets_bar = new VDKToolbar(this);
  button_widgets_bar = new VDKHLButtonBar(this);
  for(; t < BUTTON_WIDGETS_TIPS; t++)
    {
	button_widgets_bar->AddButton((const char**) button_widgets_pixmaps[t],
				      _(button_widgets_tips[t]),
				      NULL);
	//	button_widgets_bar->AddSpace();
	// add toolbar buttons to dnd support
	if(DragAndDrop)
	  {
	    DragAndDrop->AddSource((*button_widgets_bar)[t]);
	    DragAndDrop->SetIcon((*button_widgets_bar)[t],
			     new VDKRawPixmap(this,button_widgets_pixmaps[t]));
	    // load builder dnd table
	    DnDBuilderEntry entry((*button_widgets_bar)[t],
				  BUTTON_TOOL_BEGIN+t);
	    DragAndDropTable->add(entry);
	  }

    }
  //  button_widgets_bar->Borderless = true;
  SignalConnect(button_widgets_bar,"clicked",&VDKBMainForm::HandleAllWidgetsBar,false);
  return button_widgets_bar;
}

/*
  NLS translation tables
 */
extern char * text_widgets_tips[];

//VDKToolbar*
VDKHLButtonBar*
VDKBMainForm::MakeTextWidgetFolder()
{
  int t = 0;
  // text_widgets_bar = new VDKToolbar(this);
  text_widgets_bar = new VDKHLButtonBar(this);
  for(; t < TEXT_WIDGETS_TIPS; t++)
    {
      text_widgets_bar->AddButton((const char**)text_widgets_pixmaps[t],
				  _(text_widgets_tips[t]),
				  NULL);
      //      text_widgets_bar->AddSpace();
      // add toolbar buttons to dnd support
      if(DragAndDrop)
	{
	  DragAndDrop->AddSource((*text_widgets_bar)[t]);
	  DragAndDrop->SetIcon((*text_widgets_bar)[t],
			       new VDKRawPixmap(this,
						text_widgets_pixmaps[t]));
	  // load builder dnd table
	  DnDBuilderEntry entry((*text_widgets_bar)[t],
				TEXT_TOOL_BEGIN+t);
	  DragAndDropTable->add(entry);
	}
    }
  // text_widgets_bar->Borderless = true;
  SignalConnect(text_widgets_bar,"clicked",&VDKBMainForm::HandleAllWidgetsBar,false);
  return text_widgets_bar;
}

/*
 */
//VDKToolbar*
VDKHLButtonBar*
VDKBMainForm::MakePluginWidgetFolder()
{
  int t = 0;
  // plugin_widgets_bar = new VDKToolbar(this);
  plugin_widgets_bar = new VDKHLButtonBar(this);
  // scanning plugin table
  // add plugin tool icon and tip
  VDKBPluginListIterator li(TheApp->PluginList());
  for(;li;li++,t++)
    {
      if(li.current().IsValid())
	{
	  VDKBAbstractComponentInterface* interface = li.current().Interface();
	  if(interface)
	    {
	      plugin_widgets_bar->AddButton((const char**) interface->Icon(),
					    (char*) interface->Tip(),
					    NULL);
	      /// plugin_widgets_bar->AddSpace();
	      // add toolbar buttons to dnd support
	      if(DragAndDrop)
		{
		  DragAndDrop->AddSource((*plugin_widgets_bar)[t]);
		  DragAndDrop->SetIcon((*plugin_widgets_bar)[t],
				 new VDKRawPixmap(this,
						  (char**) interface->Icon()));
		  // load builder dnd table
		  DnDBuilderEntry entry((*plugin_widgets_bar)[t],
					PLUGIN_TOOL_BEGIN+t);
		  DragAndDropTable->add(entry);
		}
	    }
	}
    }
  // plugin_widgets_bar->Borderless = true;
  SignalConnect(plugin_widgets_bar,"clicked",&VDKBMainForm::HandleAllWidgetsBar,false);
  return plugin_widgets_bar;
}

/*
  NLS translation tables
 */
extern char * misc_widgets_tips[];

//VDKToolbar*
VDKHLButtonBar*
VDKBMainForm::MakeMiscWidgetFolder()
{
  int t = 0;
  // misc_widgets_bar = new VDKToolbar(this);
  misc_widgets_bar = new VDKHLButtonBar(this);
  for(; t < MISC_WIDGETS_TIPS; t++)
    {
      misc_widgets_bar->AddButton((const char**)misc_widgets_pixmaps[t],
				  _(misc_widgets_tips[t]),
				  NULL);
      //      misc_widgets_bar->AddSpace();
            // add toolbar buttons to dnd support
      if(DragAndDrop)
	{
	  DragAndDrop->AddSource((*misc_widgets_bar)[t]);
	  DragAndDrop->SetIcon((*misc_widgets_bar)[t],
			       new VDKRawPixmap(this,
						misc_widgets_pixmaps[t]));
	  // load builder dnd table
	  DnDBuilderEntry entry((*misc_widgets_bar)[t],
				MISC_TOOL_BEGIN+t);
	  DragAndDropTable->add(entry);
	}
    }
  // disables timer widget
  (*misc_widgets_bar)[6]->Enabled = false;
  // temporary disables grid widget, waiting for Feiguin..
  // (*misc_widgets_bar)[12]->Enabled = false;
  //
  // misc_widgets_bar->Borderless = true;
  SignalConnect(misc_widgets_bar,"clicked",&VDKBMainForm::HandleAllWidgetsBar,false);
  return misc_widgets_bar;
}



#if HAVE_GNOME
/*   NLS translation tables  */
// extern char * gnome_widgets_tips[];
//VDKToolbar*
VDKHLButtonBar*
VDKBMainForm::MakeGnomeWidgetFolder()
{
  int t = 0;
  // gnome_widgets_bar = new VDKToolbar(this);
  gnome_widgets_bar = new VDKHLButtonBar(this);
  for(; t < GNOME_WIDGETS_TIPS; t++)
    {
      gnome_widgets_bar->AddButton((const char**)gnome_widgets_pixmaps[t],
				   _(gnome_widgets_tips[t]),
				   NULL);
      // gnome_widgets_bar->AddSpace();
      // add toolbar buttons to dnd support
      if(DragAndDrop)
	{
	  DragAndDrop->AddSource((*gnome_widgets_bar)[t]);
	  DragAndDrop->SetIcon((*gnome_widgets_bar)[t],
			       new VDKRawPixmap(this,
						gnome_widgets_pixmaps[t]));
	  // load builder dnd table
	  DnDBuilderEntry entry((*gnome_widgets_bar)[t],
				GNOME_TOOL_BEGIN+t);
	  DragAndDropTable->add(entry);
	}
    }
  // gnome_widgets_bar->Borderless = true;
  SignalConnect(gnome_widgets_bar,"clicked",&VDKBMainForm::HandleAllWidgetsBar,false);
  return gnome_widgets_bar;
}

/*
 */
void
VDKBMainForm::EnableGnomeWidgets(bool flag)
{
     for(int t = 0; t < GNOME_WIDGETS_TIPS; t++)
	 (*gnome_widgets_bar)[t]->Enabled = flag;
}
#endif


#if USE_XDB
/*   NLS translation tables  */
//extern char * xdb_widgets_tips[];
//VDKToolbar*
VDKHLButtonBar*
VDKBMainForm::MakeXdbWidgetFolder()
{
  int t = 0;
  // xdb_widgets_bar = new VDKToolbar(this);
  xdb_widgets_bar = new VDKHLButtonBar(this);
  for(; xdb_widgets_tips[t]; t++)
    {
      xdb_widgets_bar->AddButton((const char**)xdb_widgets_pixmaps[t],
				   _(xdb_widgets_tips[t]),
				   NULL);
      // xdb_widgets_bar->AddSpace();
      // add toolbar buttons to dnd support
      if(DragAndDrop)
	{
	  DragAndDrop->AddSource((*xdb_widgets_bar)[t]);
	  DragAndDrop->SetIcon((*xdb_widgets_bar)[t],
			       new VDKRawPixmap(this,
						xdb_widgets_pixmaps[t]));
	  // load builder dnd table
	  DnDBuilderEntry entry((*xdb_widgets_bar)[t],
				XDB_TOOL_BEGIN+t);
	  DragAndDropTable->add(entry);
	}
    }
  // xdb_widgets_bar->Borderless = true;
  SignalConnect(xdb_widgets_bar,"clicked",&VDKBMainForm::HandleAllWidgetsBar,false);
  return xdb_widgets_bar;
}
#endif

//////////////// INTERFACE COMPLETE /////////////////////
/*
makes editor
*/

VDKBEditor*
VDKBMainForm::MakeEditor()
{
  if(!editor)
    {
      editor = new VDKBEditor(this);
      editor->Setup();
      editor->Visible = ! EmacsServerStarted();
    }
  else if(!editor->Visible)
    editor->Visible = ! EmacsServerStarted();
  else if(editor->Iconized )
    editor->Iconized = EmacsServerStarted();
  // anyways raise
  else if(!EmacsServerStarted())
    editor->Raise();
  if(editor)
    {
      Automa(automa_editor_on);
      editor->EnableMaker(prj_menu->Enabled);
    }
  return editor;
}
/*
manages main form and VDKBuilder termination
*/
VDKPoint mainformLastPosition;

bool
VDKBMainForm::CanClose()
{
int answer =
  Application()->MessageBox(
	APPNAME,
	_(user_messages[user_can_close]),
	MB_YESNO| MB_ICONQUESTION,
	_(user_messages[user_ok]),
	_(user_messages[user_no]),
	6000); /*  after 6 seconds without answer
		   closes with IDNO */
// closes project manager,editor
// and mozilla (if activated)
if(answer == IDYES)
   {
     // saves last position that will be used
     // by project manager on SaveLastSession()
     mainformLastPosition = Position;
     if(prjman)
       prjman->ForceToClose = true;
     if(editor)
       {
	 // editor->ForceToClose = true;
	 /*
	   by mm - version 2.0.2
	   due to a not investigated bug 
	   better close it as first action
	   avoiding a weird sigsgev.
	   However editor won't be closed at this point 
	   (since editor->ForceToClose remain false)
	   just hidden and files updated
	 */
	 editor->Close();
       }
     if(mozpid)
       kill(mozpid, SIGTERM);
     if(hint_tree)
       delete hint_tree;
     // delete words completions list
    if(tokenlist)
      {
	if( tklist_size != tokenlist->size() )
	  {
	    sprintf(buff,_("Completion list has been changed\n Save it ?"));
	    if (TheApp->MessageBox(APPNAME,
				   buff,
				   MB_ICONQUESTION|MB_YESNO,
				   _(user_messages[user_ok]),
				   _(user_messages[user_no])) == IDYES)
	      {
		SaveTokens();
	      }
	  }
	delete tokenlist;
      }
    // kill emacs server if any
    if(EmacsServerStarted())
      kill(EmacsPid(),SIGTERM);
   }
return answer == IDYES;
}
/*
 */
void
VDKBMainForm::EnableToggleFormUnit(bool active, char* file)
{
  //(*toolbar1)[1]->Enabled = active;
  nb_array1[1]->Enabled = active;
  ToBeToggled = file;
}

////////////////////////////////
// Application class
///////////////////////////////
void
VDKBuilder::Setup()
  {
     // install auto timed gc
    SetGarbageCollection(2000);
    sprintf(buff,"%s/bin/vdkb2",VDKB_PREFIX);
    if(!access(buff,F_OK))
      {
	struct stat info;
	stat(buff,&info);
	time_t t = info.st_mtime;
	sprintf(buff,"%s - %s",VDKBVERSION,ctime(&t));
	buff[strlen(buff)-1] = '\0';
	MainForm = new VDKBMainForm(this,buff);
      }
    else
      MainForm = new VDKBMainForm(this,VDKBVERSION);
    MainForm->Setup();
  }


/*
=========================================
NON VDK STUFF
used to install vdkbuilder resource files
=========================================
*/
/*
install resources
*/
static bool
install_resources(char* home)
{
  char* cwd;
  char command1[256],command2[256],command3[256];
  int result = -1;
   // makes .vdkb dir
  cwd = getcwd(NULL,MAXPATHLEN);
  if(!cwd)
    return false;
  if(chdir(home) < 0)
    {
      free(cwd);
      return false;
    }
  sprintf(command1,"cp %s/%s .vdkb2/res",VDKB_DATADIR,DEFAULTS_FILE);
  sprintf(command2,"cp %s/%s .vdkb2/res",VDKB_DATADIR,VDKB_RESOURCE_FILE);
  sprintf(command3,"cp %s/%s .vdkb2/res",VDKB_DATADIR,VDKB_PLUGIN_FILE);
  result = system("mkdir .vdkb2");
  if( result != 127 && result >= 0)
    {
      result = system("mkdir .vdkb2/res");
      if( result != 127 && result >= 0)
	{
	  result = system(command1);
	  if( result != 127 && result >= 0)
	    {
	      result = system(command2);
	      if( result != 127 && result >= 0)
		  {	
		    result = system(command3);
		  }
	    }
	}
    }
  chdir(cwd);
  free(cwd);
  return result != 127 && result >= 0;
}

static void
make_message_dialog (GtkWidget **dialog,
		     char* prompt,
                     GtkMessageType  type,
                     GtkButtonsType  buttons,
		     gint           default_response)
{

  *dialog = gtk_message_dialog_new (NULL, (GtkDialogFlags) 0, type, buttons,prompt);

  gtk_signal_connect_object (GTK_OBJECT (*dialog),
                             "response",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (*dialog));
  
  gtk_signal_connect (GTK_OBJECT (*dialog),
                      "destroy",
                      GTK_SIGNAL_FUNC (cmw_destroy_cb),
                      dialog);

  gtk_dialog_set_default_response (GTK_DIALOG (*dialog), default_response);

  gtk_widget_show (*dialog);
  gtk_main();
}

/*
destroy
*/ 
static gboolean
cmw_destroy_cb(GtkWidget *widget)
{
  // This is needed to get out of gtk_main
  gtk_main_quit ();
  return FALSE;
}


/*
void 
create_nonvdk_modal_window (char* prompt)
{
  GtkWidget *window = NULL;
  GtkWidget *box1,*box2,*box3;
  GtkWidget *label;
  GtkWidget *btnOk = NULL;
  // Create modal window
  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW(window),"VDKBuilder");
  // Set window as modal
  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
  // Create widgets 
  box1 = gtk_vbox_new (FALSE,5);
  box2 = gtk_vbox_new (TRUE,5);
  box3 = gtk_hbox_new (TRUE,5);
  btnOk = gtk_button_new_with_label ("Ok"); 
  label = gtk_label_new(prompt);
  // Init widgets 
  gtk_container_set_border_width (GTK_CONTAINER(box1),3);
  gtk_container_set_border_width (GTK_CONTAINER(box2),3);
  // Pack widgets 
  gtk_container_add (GTK_CONTAINER (window), box1);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 4);
  gtk_box_pack_start (GTK_BOX (box2), label, FALSE, FALSE, 4);
  gtk_box_pack_start (GTK_BOX (box3), btnOk, FALSE, FALSE, 4);
  gtk_box_pack_start (GTK_BOX (box1), gtk_hseparator_new (), FALSE, FALSE, 4);
  gtk_box_pack_start (GTK_BOX (box1), box3, FALSE, FALSE, 4);
  // connect signals 
  gtk_signal_connect_object (GTK_OBJECT (btnOk), "clicked",
			       GTK_SIGNAL_FUNC (gtk_widget_destroy),
			       GTK_OBJECT (window));
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (cmw_destroy_cb),NULL);
  // Show widgets 
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_widget_show_all(window);
  // wait until dialog get destroyed 
  gtk_main();
}
*/









