/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_prj.h>
#include <stdio.h>
#include <sys/stat.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdk/vdkutils.h>
#include <string.h>
#include <vdkb2/vdkb_object.h>
#include <vdkb2/vdkb_evbox.h>
// #include <vdkb2/vdkb_labelbutton.h>
#include <vdkb2/vdkb_textlabel.h>
#include <vdkb2/vdkb_frame.h>
#include <vdkb2/vdkb_pixmap.h>
#include <vdkb2/vdkb_image.h>
#include <vdkb2/vdkb_scrolled.h>
#include <vdkb2/vdkb_menubar.h>
#include <vdkb2/vdkb_menuitem.h>
#include <vdkb2/vdkb_textwidget.h>
#include <vdkb2/vdkb_menu.h>
#include <vdkb2/vdkb_paned.h>
#include <vdkb2/vdkb_entry.h>
#include <vdkb2/vdkb_notebook.h>
// #include <vdkb2/vdkb_pixbutton.h>
#include <vdkb2/vdkb_toolbar.h>
#include <vdkb2/vdkb_customlist.h>
#include <vdkb2/vdkb_customtree.h>
#include <vdkb2/vdkb_separator.h>
#include <vdkb2/vdkb_table.h>
#include <vdkb2/vdkb_rbgroup.h>
#include <vdkb2/vdkb_handlebox.h>
#include <vdkb2/vdkb_guicanvas.h>
#include <vdkb2/vdkb_combo.h>
#include <vdkb2/vdkb_checkbutton.h>
#include <vdkb2/vdkb_radiobutton.h>
#include <vdkb2/vdkb_spinbutton.h>
#include <vdkb2/vdkb_pbar.h>
#include <vdkb2/vdkb_custombutton.h>
#include <vdkb2/vdkb_sbar.h>
//#include <vdkb2/vdkb_grid.h>
// #include <vdkb2/vdkb_packer.h>
// #include <vdkb2/vdkb_treeview.h>
#include <vdkb2/vdkb_slider.h>
#include <vdkb2/vdkb_pholder.h>
#include <vdkb2/vdkb_fixed.h>
#if HAVE_GNOME
#include <vdkb2/vdkb_gnomeappbar.h>
#include <vdkb2/vdkb_dedit.h>
#include <vdkb2/vdkb_gnomeentry.h>
#endif
#if USE_XDB
#include <vdkxdb2/vdkxtable.h>
#include <vdkb2/vdkb_xentry.h>
#include <vdkb2/vdkb_xcheckbutton.h>
#include <vdkb2/vdkb_xmemo.h>
#include <vdkb2/vdkb_xcustomlist.h>
#endif
#include <ctype.h>

static char buff[256];
extern VDKBuilder* TheApp;
extern char* source_prompts[];
/*
TABLE:
contains mapping between vdk class names
and static class members of each class
Used by parser to make widgets during
.frm parsing
 */
struct
{
  char *Class;
  char* (*create_source)(char* buffer,VDKBParser& parser);
  bool (*create_widget)(VDKBGuiForm* owner,
			char* buffer,VDKBParser& parser);
} vdkclass[] =

{
  // containers
  { "VDKBox", VDKBEventBox::CreateSource,
    VDKBEventBox::CreateWidget },
  { "VDKFrame",
    VDKBFrame::CreateSource, VDKBFrame::CreateWidget },
  { "VDKScrolled",
    VDKBScrolled::CreateSource, VDKBScrolled::CreateWidget },
  { "VDKPaned",
    VDKBPaned::CreateSource, VDKBPaned::CreateWidget },
  { "VDKMenubar",
    VDKBMenubar::CreateSource, VDKBMenubar::CreateWidget },
  { "VDKNotebook",
    VDKBGuiNotebook::CreateSource, VDKBGuiNotebook::CreateWidget },
  { "VDKToolbar",
    VDKBToolbar::CreateSource, VDKBToolbar::CreateWidget },
  { "VDKTable",
    VDKBTable::CreateSource, VDKBTable::CreateWidget },
  { "VDKRadioButtonGroup",
    VDKBRadioButtonGroup::CreateSource, VDKBRadioButtonGroup::CreateWidget },
  { "VDKHandleBox",
    VDKBHandleBox::CreateSource, VDKBHandleBox::CreateWidget },
  //  { "VDKPacker",
  //  VDKBPacker::CreateSource, VDKBPacker::CreateWidget }, 
  { "VDKFixed",
    VDKBFixed::CreateSource, VDKBFixed::CreateWidget },
  // buttons
  //  { "VDKLabelButton",
  //  VDKBLabelButton::CreateSource, VDKBLabelButton::CreateWidget },
  // { "VDKPixmapButton",
  //  VDKBPixmapButton::CreateSource, VDKBPixmapButton::CreateWidget },
  { "VDKCheckButton",
    VDKBCheckButton::CreateSource, VDKBCheckButton::CreateWidget },
  { "VDKRadioButton",
    VDKBRadioButton::CreateSource, VDKBRadioButton::CreateWidget },
  { "VDKSpinButton",
    VDKBSpinButton::CreateSource, VDKBSpinButton::CreateWidget },
  { "VDKCustomButton",
    VDKBCustomButton::CreateSource, VDKBCustomButton::CreateWidget },
  // texts
  { "VDKLabel",
    VDKBTextLabel::CreateSource, VDKBTextLabel::CreateWidget },
  { "VDKTextView",
    VDKBTextWidget::CreateSource, VDKBTextWidget::CreateWidget },
  { "VDKEntry",
    VDKBEntry::CreateSource, VDKBEntry::CreateWidget },
  // misc
  { "VDKCanvas",
    VDKBGuiCanvas::CreateSource, VDKBGuiCanvas::CreateWidget },
  { "VDKPixmap",
    VDKBPixmap::CreateSource, VDKBPixmap::CreateWidget },
  { "VDKImage",
    VDKBImage::CreateSource, VDKBImage::CreateWidget },
  { "VDKMenuItem",
    VDKBMenuItem::CreateSource, VDKBMenuItem::CreateWidget },
  { "VDKMenu",
    VDKBMenu::CreateSource, VDKBMenu::CreateWidget },
  { "VDKCustomList",
    VDKBCustomList::CreateSource, VDKBCustomList::CreateWidget },
  { "VDKCombo",
    VDKBCombo::CreateSource, VDKBCombo::CreateWidget },
  { "VDKCustomTree",
    VDKBGuiCustomTree::CreateSource, VDKBGuiCustomTree::CreateWidget },
  { "VDKSeparator",
    VDKBSeparator::CreateSource, VDKBSeparator::CreateWidget },
  { "VDKProgressBar",
    VDKBProgressBar::CreateSource, VDKBProgressBar::CreateWidget },
  { "VDKStatusbar",
    VDKBStatusbar::CreateSource, VDKBStatusbar::CreateWidget },
  //  { "VDKGrid",
  //  VDKBGrid::CreateSource, VDKBGrid::CreateWidget },
  { "VDKSlider",
    VDKBSlider::CreateSource, VDKBSlider::CreateWidget },
  { "VDKPlaceHolder",
    VDKBPlaceHolder::CreateSource, VDKBPlaceHolder::CreateWidget },
  //  { "VDKTreeView",
  //  VDKBTreeView::CreateSource, VDKBTreeView::CreateWidget },
  // gnome
#if HAVE_GNOME
  { "VDKGnomeAppBar",
    VDKBGnomeAppBar::CreateSource, VDKBGnomeAppBar::CreateWidget },
  {"VDKGnomeDateEdit",
   VDKBGnomeDateEdit::CreateSource, VDKBGnomeDateEdit::CreateWidget },
  {"VDKGnomeEntry",
   VDKBGnomeEntry::CreateSource, VDKBGnomeEntry::CreateWidget },
#endif
  // xdb support
#if USE_XDB
  {"VDKXEntry",
   VDKBXEntry::CreateSource, VDKBXEntry::CreateWidget },
  {"VDKXCheckButton",
   VDKBXCheckButton::CreateSource, VDKBXCheckButton::CreateWidget },
  {"VDKXMemo",
   VDKBXMemo::CreateSource, VDKBXMemo::CreateWidget },
  {"VDKXCustomList",
   VDKBXCustomList::CreateSource, VDKBXCustomList::CreateWidget },
#endif
  // map end
  { NULL,NULL,NULL }
};

//////////////////////////////////////////////////////////////////
/*
 */
char*
CreateSource(char* classname, char* buffer, VDKBParser& parser)
{
  int t;
  VDKBAbstractComponentInterface* interface = NULL;
  for(t=0; vdkclass[t].Class; t++)
    if(!strcmp(classname,vdkclass[t].Class))
      return vdkclass[t].create_source(buffer,parser);
  // statically unsopported widget
  // try to seek it into plugins list
  interface =
    TheApp->PluginList().Interface(classname);
  if(interface)
    return interface->CreateSource(buffer,parser);
  else
    return (char*) NULL;
}
/*
 */
bool
CreateWidget(VDKBGuiForm* owner, char* classname,
	     char* buffer, VDKBParser& parser)
{
  int t;
  VDKBAbstractComponentInterface* interface = NULL;
  for(t=0; vdkclass[t].Class; t++)
    if(!strcmp(classname,vdkclass[t].Class))
      return vdkclass[t].create_widget(owner,buffer,parser);
  // statically unsopported widget
  // try to seek it into plugins list
  interface =
    TheApp->PluginList().Interface(classname);
  if(interface)
    return interface->CreateWidget(owner,buffer,parser);
  else
    return false;
}

// in vdkb_object.cc
extern char* vdkbclass_names[];
extern int ClassTypeLookup(char* word);

//==============================
static void Filter(char* s, char* filter)
{
  bool flag = false;
  char* p = s;
  for(;*s;s++)
    {
      if(strchr(filter,*s))
	{
	  if(flag && (*s == ' '))
	    *p++ = *s;
	  if(*s == '\"')
	    flag = flag ? false : true;
	}
      else
	*p++ = *s;
    }
  *p = '\0';
}
////////////////////////////////////////
void
VDKBProject::WriteGuiHeaderParsingFrm(FILE* fp, char* fname)
{
  VDKBParser parser(fname);
  char arg[256];
  char* object;
  char obj_type[128];
  char obj_name[128];
  char slot[64];
  char declare[12];
  bool isUpper = false; // if first project anme char is upper
  // has the parser correctly loaded and filtered fname ?
  if(! parser.Buffer())
    return;
  char* name;
  char* memname = new char[strlen(fname)+1];
  strcpy(memname,fname);
  char* p = get_shortfilename(memname);
  if(p)
    name = p;
  else
     {
      delete[] memname;
      return ;
    }
  p =  get_extension(name);
  if(p)
    *p = '\0';
// write developer header / gpl license
  // write file header
  time_t ltime;
  time(&ltime);
  struct tm * lct = localtime(&ltime);
  fprintf(fp,source_prompts[34],(char*)options.author);
  fprintf(fp,source_prompts[35],(char*)options.email);
  if(options.gpld)
      fprintf(fp,source_prompts[36]);
  fprintf(fp,source_prompts[37],(char*)options.author,1900+lct->tm_year);
  fprintf(fp,source_prompts[38]);
  fprintf(fp,source_prompts[2],name);
  // search for background pixmap if any
  p = parser.Buffer();
  if(parser.GetParam(arg,p,PROP_BACKPIX) && 
     strcmp(arg,NIHIL_PROP))
    fprintf(fp,"\nprivate: VDKRawPixmap* _backpix;");
  // writes widgets pointers declaration
  while( (p = strstr(p,"[object]")) )
    {
      sprintf(arg,"[object]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetObjectClass(object,obj_type) &&
	     parser.GetObjectName(object,obj_name))
	    {
	      // checks if is a place holder
	      if(!strcmp(obj_type,"VDKPlaceHolder"))
		{
		  // extract obj type from place holder ctor
		  char ctor[256];
		  *ctor = '\0';
		  if(parser.GetParam(ctor,object,"Ctor:"))
		     {
		       int t;
		       for(t=0; ctor[t] && ctor[t] != '('; t++);
		       ctor[t] = '\0';
		     }
		  if(*ctor)
		    strcpy(obj_type,ctor);
		}
	      // checks if is an event-aware box
	      else if(!strcmp(obj_type,"VDKBox") &&
		      parser.GetParam(arg,object,"event-aware:") &&
		      !strcmp(arg,CHECK_TRUE)
		      )
		strcpy(obj_type,"VDKEventBox");
	      // checks if is a docker
	      else if(!strcmp(obj_type,"VDKBox") &&
		      parser.GetParam(arg,object,"dockable:") &&
		      !strcmp(arg,CHECK_TRUE)
		      )
		strcpy(obj_type,"VDKDockerBox");
	      // actually writes widget declaration
	      // checking if should be declared as public or not
	      bool publicDec;
	      if(parser.GetParam(arg,object,PROP_DECLARE_PUBLIC) &&
		 !strcmp(arg,CHECK_YES))
		publicDec = true;
	      else
		publicDec = false;
	      fprintf(fp,"\n%s %s* %s;",
		      publicDec ? "public:" :"protected:",
		      obj_type,
		      obj_name);
	    }
	  p+=strlen(object);
	  delete[] object;
	}
      else
	break;
  }
  p = parser.Buffer();
  // write form events handlers declaration
  object = parser.GetObject(name);
  if(object)
    {
      if(parser.GetParam(arg,object,"OnFormActivate:") && 
	 !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnFormActivate(VDKForm* sender, bool in_out);");
      if(parser.GetParam(arg,object,"OnExpose:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnExpose(VDKForm* sender, GdkRectangle area);");
      if(parser.GetParam(arg,object,"OnShow:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnShow(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnChildClosing:") && 
	 !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnChildClosing(VDKForm* child);");
      if(parser.GetParam(arg,object,"OnIconize:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnIconize(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnRestore:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnRestore(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnMove:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnMove(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnResize:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnResize(VDKForm* sender, VDKPoint& new_size);");
      if(parser.GetParam(arg,object,"OnConfigure:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnConfigure(VDKForm* sender);");
      if(parser.GetParam(arg,object,"OnRealize:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nvoid OnRealize(VDKForm* sender);");
      if(parser.GetParam(arg,object,"CanClose:") && !strcmp(arg,CHECK_TRUE))
	fprintf(fp,"\nbool CanClose();");
      delete[] object;
    }
  //
  fprintf(fp,"\npublic:");

  // write signal map declaration
  isUpper = isupper(name[0]);
  if(!isUpper)
    name[0] = toupper(name[0]);
  if( strstr(p,"[connect]"))
    fprintf(fp,"\nDECLARE_SIGNAL_MAP(%sForm);",name);
  p = parser.Buffer();
  // write response function declarations
  while( (p = strstr(p,"[connect]")) )
    {
      sprintf(arg,"[connect]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetParam(slot,object,"slot:") &&
	     parser.GetParam(declare,object,"declare:"))
	    {
	      if(atoi(declare))
		fprintf(fp,"\nbool %s(VDKObject* sender);",slot);
	    }
	  p+=strlen(object);
	  delete[] object;
	}
      else
	break;
    }
  fprintf(fp,source_prompts[3]);
  fprintf(fp,"\nDECLARE_SIGNAL_LIST(%sForm);",name);
  fprintf(fp,"\nDECLARE_EVENT_LIST(%sForm);",name);
  fprintf(fp,"\n// declares two static used to initialize");
  fprintf(fp,"\n// form display type and initial position");
  fprintf(fp,"\nstatic GtkWindowType %sForm::%s;",name,DISPLAY_TYPE);
  fprintf(fp,"\nstatic GtkWindowPosition %sForm::%s;",name,WINPOS);
  //
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  if(!isUpper)
    name[0] = tolower(name[0]);
  fprintf(fp,source_prompts[0], SOURCE_END_MARK, name, h_ext);
  fclose(fp);
  delete[] memname;
}
/*
 */

void
VDKBProject::WriteGUIBoxesSetup(VDKBParser& parser, FILE* fp)
{
  char arg[64];
  char* object;
  char obj_name[128];
  char obj_type[64];
  char* source = NULL;
  //char* parent;
  char* p = parser.Buffer();
  while( (p = strstr(p,"[object]")) )
    {
      sprintf(arg,"[object]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetObjectClass(object,obj_type) &&
	     parser.GetObjectName(object,obj_name) &&
	    ( source = CreateSource(obj_type,p,parser) ))
	    {
	      fprintf(fp,source);
	      delete source;
	    }
	  p+=strlen(object);
	  delete[] object;
	}
      else
	break;
  }
}
////////////////////////////////////////
static char* form_display_types[] = 
{
  "GTK_WINDOW_TOPLEVEL",
  "GTK_WINDOW_POPUP",
  0
};

static char* win_positions[] = 
{
  "GTK_WIN_POS_NONE",
  "GTK_WIN_POS_CENTER",
  "GTK_WIN_POS_MOUSE",
  "GTK_WIN_POS_CENTER_ALWAYS",
  0
};

void
VDKBProject::WriteGUISetupParsingFrm(FILE* fp,
				     char* fname)
{
  VDKBParser parser(fname);
  char* property;
  // has the parser correctly loaded and filtered fname ?
  if(! parser.Buffer())
    return;
  bool nls_support = options.nls_support == VDKString("yes");
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* cc_ext  = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  ///////////////////////////////
  // extract form name from fname
  char* name;
  char* memname = new char[strlen(fname)+1];
  bool isUpper = false;
  strcpy(memname,fname);
  char* p = get_shortfilename(memname);
  if(p)
    name = p;
  else
     {
      delete memname;
      return ;
    }
  // write developer header / gpl license
  // write file header
  time_t ltime;
  time(&ltime);
  struct tm * lct = localtime(&ltime);
  fprintf(fp,source_prompts[34],(char*)options.author);
  fprintf(fp,source_prompts[35],(char*)options.email);
  if(options.gpld)
      fprintf(fp,source_prompts[36]);
  fprintf(fp,source_prompts[37],(char*)options.author,1900+lct->tm_year);
  fprintf(fp,source_prompts[38]);

  if(nls_support)
    fprintf(fp,"#if HAVE_CONFIG_H\n\
#include <config.h>\n#endif\n#if !HAVE_GNOME\n#if ENABLE_NLS\n\
#include <libintl.h>\n#define _(str) \\\n\
( g_utf8_validate(gettext(str),-1,NULL) ? \\\n\
gettext(str) : \\\n\
 g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL))\n#define N_(str) str\n\
#else\n#define _(str) str\n#define N_(str) str\n#endif\n#endif\n");
  p = get_extension(memname);
  if(p)
    *p = '\0';
  fprintf(fp,"\n#include <%s.%s>",name,h_ext);
  isUpper = isupper(name[0]);
  if(!isUpper)
    name[0] = toupper(name[0]);
  // write static display type and initial form position
  char arg[8];
  int dst = 0;
  p = parser.Buffer();

  fprintf(fp,"\n//define static display type and initial form position");
  if(parser.GetParam(arg,p,PROP_DISPLAY_TYPE))
      dst = atoi(arg);
  dst = dst <= 1 ? dst : 0;
  fprintf(fp,"\nGtkWindowType %sForm::%s = %s;",name,DISPLAY_TYPE,form_display_types[dst]);

  if(parser.GetParam(arg,p,PROP_WINPOS))
      dst = atoi(arg);
  dst = dst <= 3 ? dst : 0;
  fprintf(fp,"\nGtkWindowPosition %sForm::%s = %s;",name,WINPOS,win_positions[dst]);

  // write static table
  fprintf(fp,source_prompts[4]);
  fprintf(fp,"\nDEFINE_SIGNAL_LIST(%sForm,%s);",
	  name,
	  Type == vdk_project ? "VDKForm" : "VDKForm" /*"VDKGnomeForm"*/);
  fprintf(fp,"\nDEFINE_EVENT_LIST(%sForm,%s);",
	  name,
	  Type == vdk_project ? "VDKForm" : "VDKForm" /*"VDKGnomeForm"*/);

  if(strstr(p,"[connect]"))
    {
      char* object;
      char slot[64];
      char sender[64];
      char signal[64];
      char arg[32];
      fprintf(fp,source_prompts[5]);
      fprintf(fp,"\nDEFINE_SIGNAL_MAP(%sForm,%s)",
	      name,
	      Type == vdk_project ? "VDKForm" : "VDKForm" /*"VDKGnomeForm"*/);
      bool flag = false;
      while( (p = strstr(p,"[connect]")) )
	{
	  sprintf(arg,"[connect]{");
	  object = ExtractSection(p,arg,"}");
	  if(object)
	    {
	      if(flag)
		fprintf(fp,",");
	      flag = true;
	      if(parser.GetParam(sender,object,"sender:") &&
		 parser.GetParam(signal,object,"signal:") &&
		 parser.GetParam(slot,object,"slot:"))
		{
		  sprintf(buff,"ON_SIGNAL(%s,%s,%s)",
			  sender, signal, slot);
		  fprintf(fp,"\n%s",buff);
		  p+=strlen(object);
		  delete object;
		}
	    }
	  else
	    break;
	}
      fprintf(fp,"\nEND_SIGNAL_MAP");
    }
  fprintf(fp,source_prompts[6]);
  fprintf(fp,"\nvoid\n%sForm::GUISetup(void)\n{",
	  name);
  if(!isUpper)
    name[0] = tolower(name[0]);
  /////////////////////////////////////////////
  char* object = parser.GetObject(name);
  if(!object)
    {
      // error, just write an useless form
      fprintf(fp,source_prompts[7]);
      fprintf(fp,"\n\tTitle = \"%s\";",name);
      fprintf(fp,"\n\tSetSize(400,300);");
      fprintf(fp,"\n}\n");
      fprintf(fp,source_prompts[0],SOURCE_END_MARK, name, cc_ext);
      fclose(fp);
      delete[] memname;
      return;
    }

  //////////////////////// BACKGROUND ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_NORMALBACKGROUND))
     &&
     strcmp(property,NIHIL_PROP))
    fprintf(fp,"\n\tNormalBackground = VDKRgb(%s);",buff);
  //////////////////////// FOREGROUND ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_FOREGROUND))
     &&
     strcmp(property,NIHIL_PROP))
    fprintf(fp,"\n\tForeground = VDKRgb(%s);",buff);
    //////////////////////// FONT ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_FONT))
     &&
     strcmp(property,NIHIL_PROP))
    fprintf(fp,"\n\tFont = new VDKFont(this,\"%s\");",buff);
  //////////////////////// CURSOR ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_CURSOR))
     &&
     strcmp(property,NIHIL_PROP))
    fprintf(fp,"\n\tCursor = %s;",buff);

  //////////////////////// SIZE ///////////////////////////
  if( (property = parser.GetParam(buff,object,PROP_FREEZE_USIZE))
     && !strcmp(property,CHECK_TRUE))
    {
      VDKPoint pt = parser.Size(object);
      if(pt.X() > 0)
	//fprintf(fp,"\n\tSetDefaultSize(VDKPoint(%d,%d));",pt.X(),pt.Y());
	fprintf(fp,"\n\tSetSize(%d,%d);",pt.X(),pt.Y());
      else
	fprintf(fp,"\n\tSetSize(400,300);");
    }
   ////////////////////// TITLE ////////////////////////////
  if(parser.GetParam(buff,object,"Title:"))
    {
        if(options.nls_support == VDKString("yes"))
	  fprintf(fp,"\n\tTitle = _(\"%s\");",buff);
	else
	  fprintf(fp,"\n\tTitle = \"%s\";",buff);
    }
  else
    fprintf(fp,"\n\tTitle = \"%s\";",name);
  ////////////////////// GNOME APP BAR /////////////////////
#if HAVE_GNOME
  //  if(Type == vdk_gnome_project)
  //  fprintf(fp,"\n\tAdd(gnome_bar = new VDKGnomeAppBar(this));");
#endif
  ////////////////////// BACKGROUND PIXMAP//////////
  if(parser.GetParam(buff,object,PROP_BACKPIX) &&
     strcmp(buff,NIHIL_PROP))
    {
      fprintf(fp,"\n_backpix = new VDKRawPixmap(this,\"%s\");",
	      buff);
      fprintf(fp,"\nif(_backpix) BackgroundPixmap = _backpix ;");
    }
  ////////////////////////////////////////////////////
  WriteGUIBoxesSetup(parser,fp);
  ///////////////////////////////////////////////////
  ////////////////////// FOCUS WIDGET ///////////////
  if(parser.GetParam(buff,object,PROP_FOCUSWIDGET) &&
     strcmp(buff,NIHIL_PROP))
    fprintf(fp,"\n\tFocusWidget = %s;",buff);
  //////////////////////////////////////////////////
  fprintf(fp,"\n}\n");
#if USE_XDB
  {
    char* local = new char[strlen(name)+1];
    strcpy(local,name);
    // local[0] = toupper(local[0]);
    WriteXDBSetup(fp,local);
    delete[] local;
  }
#endif
  fprintf(fp,source_prompts[0], SOURCE_END_MARK, name, cc_ext);
  fclose(fp);
  delete[] object;
  delete[] memname;
}

#if USE_XDB
#include <vdkxdb2/vdkxdb.h>
#include <vdkxdb2/vdkxtable.h>
/*
  writes database setup.
  Preconditions:
  source code will be written if:
  - the interested module is the project main
  - xdb size is > 0
*/
void
VDKBProject::WriteXDBSetup(FILE* fp, char* name)
{
  bool isUpper = false;
  VDKXDatabase* xdb = TheApp->theXdb;
  TableList* tlist = xdb->TList();
  /*
  if(tlist->size() <= 0)
    return;
  */
  /*
  isUpper = isupper(name[0]);
  if(!isUpper)
    name[0] = tolower(name[0]);
  */
  // checks module name against project name
  // method will be written only on the main module
  VDKString prjname = Name;
  char* p = get_extension(prjname);
  if(p)
    *p = '\0';
  if(strcmp(name,(char*) prjname))
     return;
  if(tlist->size() > 0)
    fprintf(fp,
"\n/*\nVDKXDatabase setup\n\
Initializes all tables and indexes contained into\n\
%s.prj.xdb\n\
and open tables if marked as active.\n\
Notes:\n\
- all path to tables and indexes files\n\
are relative to XDB_DATA_PATH symbolic constant,\n\
change it into %s.h header file if you need\n\
a different path, all data files should be contained\n\
into a single directory however\n\
- method will be empty if no tables are used\n*/\n",
	  name,name);
  isUpper = isupper(name[0]);
  if(!isUpper)
    name[0] = toupper(name[0]);
  fprintf(fp,"\n#ifdef VDKXDB_SUPPORT");
  fprintf(fp,"\nvoid\n%sApp::XDBSetup(void)\n{",
	  name);
  if(tlist->size() > 0)
    {
      fprintf(fp,"\nVDKXTable* table = NULL;");
      fprintf(fp,"\nVDKXTableIndex* index = NULL;");
      fprintf(fp,"\nVDKString dbname;");
      fprintf(fp,"\nVDKString ndxname;");
      TableListIterator li(*tlist);
      // lops into xdb tables
      for(;li;li++)
	{
	  VDKXTable* table = li.current();
	  IndexList* nlist = table->NdxList();
	  char* dbName = table->Name();
	  bool active = table->Active;
	  fprintf(fp,"\ndbname = XDB_DATA_PATH;");
	  fprintf(fp,"\ndbname += \"%s\";",get_shortfilename(dbName));
	  fprintf(fp,"\ntable = new VDKXTable(xdb,(char*) dbname);");
	  if(active)
	    fprintf(fp,"\nif(table) table->Open();");
	  if(nlist->size() > 0)
	    {
	      IndexListIterator ln(*nlist);
	      // loops into table indexes
	      for(;ln;ln++)
		{
		  char* ndxName = ln.current()->Name();
		  fprintf(fp,"\nndxname = XDB_DATA_PATH;");
		  fprintf(fp,"\nndxname += \"%s\";",
			  get_shortfilename(ndxName));
		  fprintf(fp,
		  "\nindex = new VDKXTableIndex(table,(char*) ndxname);");
		  if(active)
		    fprintf(fp,"\nif(index) index->Open();");
		}
	    }

	  if(active)
	    {
	      fprintf(fp,
"\nif(index && table && table->IsOpen())\n    table->Order = 0;");
	      fprintf(fp,
"\nif(table && table->IsOpen())\n    table->First();");
	    }

	}
    }
  fprintf(fp,"\n}\n#endif\n");
}
#endif
/*
read form signal file
to load form signal list
 */
void
VDKBGuiForm::ReadSignals(VDKBParser& parser)
{
  char arg[64];
  char* object;
  char sender[64];
  char signal[64];
  char slot[64];
  char declare[16];
  char* p = parser.Buffer();
  SignalList.flush();
  while( (p = strstr(p,"[connect]")) )
    {
      sprintf(arg,"[connect]{");
      object = ExtractSection(p,arg,"}");
      if(object)
	{
	  if(parser.GetParam(sender,object,"sender:") &&
	     parser.GetParam(signal,object,"signal:") &&
	     parser.GetParam(slot,object,"slot:") &&
	     parser.GetParam(declare,object,"declare:"))
	    {
	      bool b = !strcmp(declare,"1");;
	      VDKBConnection c(sender,signal,slot,b);
	      SignalList.add(c);
	    }
	  p+=strlen(object);
	  delete[] object;
	}
      else
	break;
    }
}
///////////////////////////////////////
VDKBParser::~VDKBParser()
{
  if(buffer)
    delete[] buffer;
}
////////////////////////////////////////
VDKBParser::VDKBParser(char* fname):fname(fname)
{
  char* filter = "\n\t \"", *p;
  int c;
  FILE *fp = fopen(fname,"r");
  if(! fp)
    {
      buffer = NULL;
      return;
    }
  struct stat info;
  stat(fname,&info);
  unsigned int size = info.st_size;
  buffer = p = new char[size+1];
  while( (c = fgetc(fp)) != EOF)
    *p++ = (char) c;
  *p ='\0';
  fclose(fp);
  Filter(buffer,filter);
}
/*
 */
char*
VDKBParser::GetObject(char* name)
{
  char arg[64];
  sprintf(arg,"[%s]{",name);
  return ExtractSection(buffer,arg,"}");
}
/*
 */
char*
VDKBParser::GetWidget(char* name)
{
 char arg[128];
 sprintf(arg,"[object]{this:%s;",name);
 return ExtractSection(buffer,arg,"}");
}
/*
 */
char*
VDKBParser::GetObjectName(char* object,char* tgt)
{
return ExtractWord(object,tgt,"this:",";");
}
/*
 */
char*
VDKBParser::GetObjectClass(char* object,char* tgt)
{
return ExtractWord(object,tgt,PARSER_CLASS,";");
}
/*
 */
char*
VDKBParser::GetParam(
		     char* tgt, // target
		     char* object, // object buffer
		     char* param) // param name
{
  if(!object)
    return (char*) NULL;
  else
    return ExtractWord(object,tgt,param,";");

}
/*
 */
int
VDKBParser::ClassName(char* name)
{
  char local[64];
  char* object = GetObject(name);
  char* word = GetParam(local,object,PARSER_CLASS);
  if(word)
      return ClassTypeLookup(word);
  else
    return vdkbclass_none;
}
/*
 */
VDKPoint
VDKBParser::Size(char* object)
{
  char local[64];
  VDKPoint p;
  char* word = GetParam(local,object,PROP_USIZE);
  if(!word || !strcmp(word,NIHIL_PROP))
    return p;
  char* comma = strchr(word,',');
  if(comma)
    {
      *comma++= '\0';
      int x = atoi(word);
      int y = atoi(comma);
      p = VDKPoint(x,y);
    }
  return p;
}
/*
 */
VDKRgb
VDKBParser::Color(char*object, char* colortype)
{
  char local[64],*comma;
  VDKRgb rgb(-1,-1,-1);
  int red,green,blue;
  char* word = GetParam(local,object,colortype);
  if(!word || !strcmp(word,NIHIL_PROP))
    return rgb;
  comma = strchr(word,',');
  if(comma)
    {
      *comma++ = '\0';
      red = atoi(word);
      word = comma;
      comma = strchr(word,',');
      if(comma)
	{
	  *comma++= '\0';
	  green = atoi(word);
	  blue = atoi(comma);
	  rgb = VDKRgb(red,green,blue);
	  return rgb;
	}
    }
  return rgb;
}
/////////////////////////////////////////////////
//           CODE GENERATION
/////////////////////////////////////////////////
/*
 */
bool
VDKBParser::GetNameAndParent(char* pars_buff,			
			     char* obj_name,
			     char* obj_parent)
{
  if (
      !GetParam(obj_name,pars_buff,PARSER_THIS) ||
      !GetParam(obj_parent,pars_buff, PARSER_PARENT)
      )
    // this or parent not found
    return false;
  // no parent widget
  else  if(!strcmp(obj_parent,NIHIL_PROP))
    return false;
  return true;
}
/*

 */
void
VDKBParser::WriteCodeToPack(
			    char* obj_parent,
			    char* obj_name,
			    char* source,
			    char* buffer,
			    char* tmp,
			    bool viewport)
{
 char justify[16],expand[16],fill[16],padding[16];
 if(viewport)
   {
     if(GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
	GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
	GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
	GetParam(padding,buffer,PROP_PADDING_INTERNAL))
       {
	 sprintf(tmp,"\n%s->%s(%s,%s,%s,%s,%s);",
		 obj_parent, STATEMENT_ADD,
		 obj_name,justify,expand,fill,padding);
	 strcat(source,tmp);
       }
     else
       {
	 sprintf(tmp,"\n%s->%s(%s);", obj_parent, STATEMENT_ADD, obj_name);
	 strcat(source,tmp);
       }
   }
 else
   {
     sprintf(tmp,"\n%s->%s(%s,l_justify,0,0,0);", obj_parent, STATEMENT_ADD_NO_VIEWPORT, obj_name);
     strcat(source,tmp);
   }

}

/*
  visible property must be wrote after adding it to a parent
  container. That's the reason why is written here and not
  in vdkb_object class as should be. Written only if == false
 */
void
VDKBParser::WriteVisible(char* obj_name, char* arg,
			 char* source,	 char* buffer,
			 char* tmp)
{
  if(
     GetParam(arg,buffer,PROP_VISIBLE) &&
     !strcmp(arg,CHECK_FALSE)
     )
    {
      sprintf(tmp,"\n%s->%s = %s;",
	      obj_name,
	      STATEMENT_VISIBLE,
	      arg);
      strcat(source,tmp);
   }
}


bool
VDKBParser::CheckNLSSupport()
{
  bool result = false;
  VDKBMainForm* mainform = dynamic_cast<VDKBMainForm*>(TheApp->MainForm);
  VDKBProjectManager* prjman = mainform ? mainform->PrjManager(): NULL;
  VDKBProject* prj = prjman ? prjman->Project(): NULL;
  if(prj)
      result = (*prj->Options()).nls_support == VDKString("yes");
  return result;
}

/*
 */
#if USE_XDB
void
VDKBParser::WriteXDBAssignCode(char* obj_name,
			       char* assigntable,
			       char* assignfield,
			       char* source,
			       char* tmp)
{
  char prjname[256];
  CheckXDBSupport(1); // checks for assigning
  prjname[0] = '\0';
  VDKBMainForm* mainform = dynamic_cast<VDKBMainForm*>(TheApp->MainForm);
  VDKBProjectManager* prjman = mainform ? mainform->PrjManager(): NULL;
  VDKBProject* prj = prjman ? prjman->Project(): NULL;
  if(prj)
    {
      char* p = NULL;
      strcpy(prjname,(char*) prj->Name);
      p = get_extension(prjname);
      if(p)
	*p ='\0';
    }
  if(*prjname)
    {
      prjname[0] = toupper(prjname[0]);
      sprintf(tmp,"\n#ifdef VDKXDB_SUPPORT");
      strcat(source,tmp);
      sprintf(tmp,"\n{\nVDKString dbname;");
      strcat(source,tmp);
      sprintf(tmp,
	      "\n%sApp* app = dynamic_cast<%sApp*>(Application());",
	      prjname,prjname);
      strcat(source,tmp);
      sprintf(tmp,"\ndbname = XDB_DATA_PATH;\ndbname += \"%s\";",
	      assigntable);
      strcat(source,tmp);
      sprintf(tmp,"\nif(app && app->TheXdb())");
      strcat(source,tmp);
      sprintf(tmp,
	      "\n%s->AssignTableField(app->TheXdb(),(char*) dbname,\"%s\");",
	      obj_name,assignfield);
      strcat(source,tmp);
      sprintf(tmp,"\n}");
      strcat(source,tmp);
      sprintf(tmp,"\n#endif");
      strcat(source,tmp);
    }
}
/*
 */
void
VDKBParser::WriteXDBClistAssignCode(char* obj_name,
			       char* assigntable,
			       char* assignfield,
			       char* source,
			       char* tmp)
{
  char prjname[256];
  CheckXDBSupport(1); // checks for assigning
  prjname[0] = '\0';
  VDKBMainForm* mainform = dynamic_cast<VDKBMainForm*>(TheApp->MainForm);
  VDKBProjectManager* prjman = mainform ? mainform->PrjManager(): NULL;
  VDKBProject* prj = prjman ? prjman->Project(): NULL;
  if(prj)
    {
      char* p = NULL;
      strcpy(prjname,(char*) prj->Name);
      p = get_extension(prjname);
      if(p)
	*p ='\0';
    }
  if(*prjname)
    {
      // check if there are some columns assignment
      {
	int t = 0; bool there_are = false;
	char* local = new char[strlen(assignfield)+1], *p;
	char fname[11];
	strcpy(local,assignfield);
	p = strtok(local,",");
	while(p)
	  {
	    strcpy(fname,p);
	    if(strcmp(fname,NIHIL_PROP))
	      {
		there_are = true;
		break;
	      }
	    t++;
	    p = strtok(NULL,",");
	  }
	delete[] local;
	if(!there_are)
	  return;
      }
      prjname[0] = toupper(prjname[0]);
      sprintf(tmp,"\n#ifdef VDKXDB_SUPPORT");
      strcat(source,tmp);
      sprintf(tmp,"\n{\nVDKString dbname;");
      strcat(source,tmp);
      sprintf(tmp,
	      "\n%sApp* app = dynamic_cast<%sApp*>(Application());",
	      prjname,prjname);
      strcat(source,tmp);
      sprintf(tmp,"\ndbname = XDB_DATA_PATH;\ndbname += \"%s\";",
	      assigntable);
      strcat(source,tmp);
      sprintf(tmp,"\nif(app && app->TheXdb())\n{");
      strcat(source,tmp);
      {
	int t = 0;
	char* local = new char[strlen(assignfield)+1], *p;
	char fname[11];
	strcpy(local,assignfield);
	p = strtok(local,",");
	while(p)
	  {
	    strcpy(fname,p);
	    if(strcmp(fname,NIHIL_PROP))
	      {
		sprintf(tmp,
"\n%s->AssignTableFieldToColumn(%d,app->TheXdb(),(char*) dbname,\"%s\");",
	      obj_name,t,p);
		strcat(source,tmp);
	      }
	    t++;
	    p = strtok(NULL,",");
	  }
	delete[] local;
      }
      sprintf(tmp,"\n}\n}");
      strcat(source,tmp);
      sprintf(tmp,"\n#endif");
      strcat(source,tmp);
    }
}

/*
  mode = 0 checks gor constructin
  mode = 1 checks for assigning
 */
bool
VDKBParser::CheckXDBSupport(int mode)
{
  VDKXDatabase* xdb = TheApp->theXdb;
  TableList* tlist = xdb->TList();
  bool dbempty = tlist->size() <= 0;
  bool xdbsupport_defined = false;
  VDKBMainForm* mainform = dynamic_cast<VDKBMainForm*>(TheApp->MainForm);
  VDKBProjectManager* prjman = mainform ? mainform->PrjManager(): NULL;
  VDKBProject* prj = prjman ? prjman->Project(): NULL;
  if(!mainform)
    return true;
  if(prj)
    {
      char* defines = (char*) (*prj->Options()).defines;
      xdbsupport_defined = strstr(defines,"VDKXDB_SUPPORT") != NULL;
    }
  if(dbempty && !xdbsupport_defined)
    {
      bool result;
      switch(mode)
	{
	case 0:
	  result = mainform->Application()->MessageBox(APPNAME,
				  _("\
You are constructing a data-aware widget\n\
without using tables (VDKBuilder tables database is empty).\n\
If you want avoid compilation errors, explicitely define\n\
VDKXDB_SUPPORT or add the proper table to\n\
VDKBuilder tables database using \"Tools\" menu.\n\
Do you want define VDKXDB_SUPPORT now ?"),
				  MB_ICONQUESTION|MB_YESNO,
				  _(user_messages[user_ok]),
				  _(user_messages[user_no])) == IDYES;
	  if(result)
	    (*prj->Options()).defines += " -DVDKXDB_SUPPORT";
	  break;
	case 1:
	  result = mainform->Application()->MessageBox(APPNAME,
					      _("\
You are assigning a table/field to data-aware widget\n\
without using tables (VDKBuilder tables database is empty).\n\
If you want avoid compilation errors, explicitely define\n\
VDKXDB_SUPPORT or add the proper table to\n\
VDKBuilder tables database using \"Tools\" menu.\n\
Do you want define VDKXDB_SUPPORT now ?"),
				  MB_ICONQUESTION|MB_YESNO,
				  _(user_messages[user_ok]),
				  _(user_messages[user_no])) == IDYES;
	  if( result)
	    (*prj->Options()).defines += " -DVDKXDB_SUPPORT";
	  break;
	}
    }
  return true;
}

#endif




