/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if USE_XDB

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str

  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_xcheckbutton.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>
#include <ctype.h>

/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBXCheckButton
// put here vdk class name string
#define VDK_CLASS "VDKXCheckButton"
// put here vdk class name 
#define VDK_ANCESTOR  VDKXCheckButton
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "xcheckbutton"

//=================================================================

extern char *wi_widget_prompts[];
static char buff[128];
extern VDKBuilder* TheApp;
extern void 
LoadTableList(VDKCustomList* tablelist,
	      VDKXDatabase* xdb, char* tablename);
extern void 
LoadFieldList(VDKCustomList *fieldlist,
	      char* tablename, VDKXDatabase* xdb,
	      char* fieldname);
// used to autogenerate default
int CLASS::Counter = 0;
/* 
 properties,signals and nicknames
*/
char* vdkxcheckbutton_props[] = {  CAPTION,CAPTIONWRAP,
ASSIGNTABLE,ASSIGNFIELD,0 };
char* vdkxcheckbutton_signals[] = { SIGNAL_TOGGLED,0 };
char* vdkxcheckbutton_nicknames[] = { NICK_TOGGLED,0 };
//////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
//////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner,
	     char* label, char* tip):
  VDKXCheckButton(owner,label,tip),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list
  for(t=0; vdkxcheckbutton_props[t]; t++)
    proplist.add(VDKBProperty(vdkxcheckbutton_props[t]));
  // add to VDKBObject signal list 
  for(t=0; vdkxcheckbutton_signals[t]; t++)
    siglist.add(VDKBSignal(vdkxcheckbutton_signals[t],
			   this,
			   vdkxcheckbutton_nicknames[t]));
  // connects common events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  //
  if(label)
    SetPropValue( CAPTION,label);
}
/////////////////////////////////////
//
//          WRITE TO .FRM FILE
//
/////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  //============================
  // USER STUFF BEGINS HERE
  // writes specific properties
  fprintf(fp,"\n\t%s\"%s\";",
	  PROP_CAPTION,
	  (char*) GetProp( CAPTION));
  fprintf(fp,"\n\t%s%s;",
	  PROP_CAPTIONWRAP,
	  (char*) GetProp( CAPTIONWRAP));
  fprintf(fp,"\n\t%s%s;",
	  PROP_ASSIGNTABLE,
	  (char*) GetProp(ASSIGNTABLE));
  fprintf(fp,"\n\t%s%s;",
	  PROP_ASSIGNFIELD,
	  (char*) GetProp(ASSIGNFIELD));
}
////////////////////////////////////////
//
//        PREPARE GUI WIDGETS
//
////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable counter
  // to ensure unicity
  CLASS* button;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    // actually makes widget
    button = new CLASS(buff,owner,buff);
  // add widget to form
  return owner->AddToSelf(button,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char obj_caption[128];
  char assigntable[256],assignfield[256];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  bool nls_support = parser.CheckNLSSupport();
  if(!parser.GetParam(obj_caption,buffer,PROP_CAPTION))
    strcpy(obj_caption,"none");
  parser.CheckXDBSupport(0); // checks for contructing
  if(nls_support)
    sprintf(tmp,"\n%s = new %s(this,_(\"%s\"));",
	    obj_name,
	    VDK_CLASS,
	    obj_caption);
  else
    sprintf(tmp,"\n%s = new %s(this,\"%s\");",
	    obj_name,
	    VDK_CLASS,
	    obj_caption);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // set widget specific properties
  // get label button  props
  if(parser.GetParam(arg,buffer,PROP_CAPTIONWRAP) && 
     strcmp(arg,NIHIL_PROP)
     )
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,CAPTIONWRAP,arg);
     strcat(source,tmp);
   }    
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  // get table and field to assign
  if(parser.GetParam(assigntable,buffer,PROP_ASSIGNTABLE) &&
     strcmp(assigntable,NIHIL_PROP) &&
     parser.GetParam(assignfield,buffer,PROP_ASSIGNFIELD) &&
     strcmp(assignfield,NIHIL_PROP))
    parser.WriteXDBAssignCode(obj_name, assigntable, assignfield,
			    source, tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char obj_caption[256];
  char arg[64];
  char assigntable[256],assignfield[256];
  CLASS* button;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  // get caption
  if(!parser.GetParam(obj_caption,buffer,PROP_CAPTION))
    strcpy(obj_caption,"none");
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      button = new CLASS(obj_name,owner,obj_caption);
      if(
	 parser.GetParam(arg,buffer,PROP_CAPTIONWRAP) &&
	 strcmp(arg,NIHIL_PROP)
	 )
	{
	button->CaptionWrap = !strcmp(arg,CHECK_TRUE);
	button->SetPropValue(CAPTIONWRAP,arg);
	}
      
      if(parser.GetParam(assigntable,buffer,PROP_ASSIGNTABLE) &&
	 strcmp(assigntable,NIHIL_PROP) &&
	 parser.GetParam(assignfield,buffer,PROP_ASSIGNFIELD) &&
	 strcmp(assignfield,NIHIL_PROP))
	{
	  VDKXTable *table = NULL;
	  button->SetPropValue(ASSIGNTABLE,assigntable);
	  button->SetPropValue(ASSIGNFIELD,assignfield);
	  // search for table on xdb
	  TableList *tlist = TheApp->theXdb->TList();
	  TableListIterator li(*tlist);
	  for(;li;li++)
	    {
	      char* dbname = (char*) li.current()->Name();
	      if(!strcmp(assigntable,get_shortfilename(dbname)))
		{
		  table = li.current();
		  break;
		}
	    }
	  if(table && button->AssignTableField(table,assignfield) &&
	     table->Active && (table->First() == XB_NO_ERROR))
		button->Read();
	}
      // pack widget to container
      return owner->PackToSelf(button, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  // FIX ME: lang support
  VDKTable* table = new VDKTable(inspector,4,2);
  // table->SetSize(300,-1);
  VDKCustomButton* button = 
    new VDKCustomButton(inspector,_(wi_widget_prompts[0]));
  table->AddToCell(button,0,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetCaption);
  caption = new VDKEntry(inspector,0,(char*) GetProp(CAPTION));
  caption->SetSize(100,-1);
  table->AddToCell(caption,0,1);
  caption->Parent(this);
  SignalConnect(caption,"activate",&CLASS::OnSetCaption);

  wrap = new VDKCheckButton(inspector,_(wi_widget_prompts[1]));
  table->AddToCell(wrap,1,0);
  wrap->Parent(this);
  SignalConnect(wrap,"toggled",&CLASS::OnSetCaptionWrap);
  
  char* ttitle[2]  = { N_("Tables"), 0 };
  tablelist = new VDKCustomList(inspector,1,ttitle,GTK_SELECTION_SINGLE);
  // tablelist->SetSize(150,80);
  table->AddToCell(tablelist,2,0);
  tablelist->Parent(this);
  SignalConnect(tablelist,"select_row",&CLASS::OnTableListSelectRow,false);
  SignalConnect(tablelist,"unselect_row",&CLASS::OnTableListUnselectRow,false);
  char* ftitle[2] = { N_("Fields"), 0 };
  fieldlist = new VDKCustomList(inspector,1,ftitle,GTK_SELECTION_SINGLE);
  // fieldlist->SetSize(105,80);
  table->AddToCell(fieldlist,2,1);
  fieldlist->Parent(this);


  assignButton = new VDKCustomButton(inspector,_("Assign to table field"));
  table->AddToCell(assignButton,3,0);
  assignButton->Parent(this);
  assignButton->Enabled = false;
  assignButton->SetTip(_("Selecting \"nihil\" will reset field assignement"));
  SignalConnect(assignButton,"clicked",&CLASS::OnAssignButtonClicked);
  bframe->Add(table,l_justify,false,false,false);
  ::LoadTableList(tablelist,TheApp->theXdb,GetProp(ASSIGNTABLE));
  return bframe; 
}
//////////////////////////////////////////////////////
// These response methods actually change both 
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
bool
CLASS::OnSetCaptionWrap(VDKObject*)
{
  SetPropValue(CAPTIONWRAP, wrap->Checked ? CHECK_TRUE : CHECK_FALSE);
  CaptionWrap = wrap->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetCaption(VDKObject*)
{
  if(strlen(caption->Text)>0)
    {
      sprintf(buff,"%s",(char*) caption->Text);
      SetPropValue(CAPTION,buff);
      Caption = caption->Text;
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool 
CLASS::OnTableListSelectRow(VDKObject*)
{
  int ndx = tablelist->Selected.Row();
  if(ndx < 0)
    {
      assignButton->Enabled = false;
      return true;
    }
  else
    {
      Tuple tuple = tablelist->Tuples[ndx];
      LoadFieldList(fieldlist,(char*) tuple[0],TheApp->theXdb,
		    GetProp(ASSIGNFIELD));
      assignButton->Enabled = true;      
    }
  return true;
}
/*
 */
bool 
CLASS::OnTableListUnselectRow(VDKObject*)
{
  fieldlist->Clear();
  assignButton->Enabled = false;
  return true;
}
/*
 */
bool
CLASS::OnAssignButtonClicked(VDKObject*)
{
  VDKXTable* table = NULL;
  VDKXDatabase *xdb = TheApp->theXdb;
  int tndx = tablelist->Selected.Row();
  int fndx = fieldlist->Selected.Row();
  char* tname = NULL;
  char* fname = NULL;
  if( (tndx < 0) || (fndx < 0))
    return true;
  // clears field
  Checked = false;
  Tuple ttuple = tablelist->Tuples[tndx];
  Tuple ftuple = fieldlist->Tuples[fndx];
  tname = (char*) ttuple[0];
  fname = (char*) ftuple[0];
  if(!strcmp(fname,NIHIL_PROP))
    {
      SetPropValue(ASSIGNTABLE,NIHIL_PROP);
      SetPropValue(ASSIGNFIELD,NIHIL_PROP);
      return true;
    }
  table = (*xdb)[tname];

  if(!table)
    return true;
  if(AssignTableField(table,fname))
    {
      xbShort fno;
      if(table->Active && (table->First() == XB_NO_ERROR))
	    Read();
      SetPropValue(ASSIGNTABLE,get_shortfilename(tname));
      SetPropValue(ASSIGNFIELD,fname);
      fno = table->GetFieldNo(fname);
      if(fno >= 0)
	{
	  xbShort flen = table->GetFieldLen(fno);
	  sprintf(buff,"%d",flen);
	  SetPropValue(MAXCHARS,buff);	  
	}
      inspector->FormNeedToBeChanged();
    }
  else
    {
      sprintf(buff,_("Couldn't assign to field \"%s\" on table %s"),
	      fname,tname);
      Owner()->Application()->MessageBox(
	 APPNAME,
	 buff,
	 MB_ICONINFORMATION|MB_OK,
	 _(user_messages[user_ok]),
	 NULL,
	 5000); // warns user
    }
  return true;
} 
#endif






