/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */ 
#include <vdkxdb/vdkxdb.h>
#include <vdkxdb/vdkxtable.h>
/*
 */
VDKXDatabase::VDKXDatabase(): xbXBase()
{
  initialized = true;
}

/*
 */
VDKXDatabase::~VDKXDatabase()
{
  TableListIterator li(tList);
  for(;li;li++)
    {
      VDKXTable* table = li.current();
      delete table;
    }
}
/*
 */
void
VDKXDatabase::Clear()
{
  TableListIterator li(tList);
  for(;li;li++)
    {
      VDKXTable* table = li.current();
      delete table;
    }
  tList.flush();
}
/*
 */
bool
VDKXDatabase::RemoveTable(char* name)
{
  int result = 0;
  VDKXTable* table = (*this)[name];
  if(table)
    {
      result = tList.remove(table);
      if(result)
	delete table;
    }
  return result;
}
/*
 */
VDKXTable*
VDKXDatabase::operator[](char* name)
{
  VDKXTable* table = (VDKXTable*) NULL;
  TableListIterator li(tList);
  for(;li;li++)
    if( !strcmp(name, (char*) li.current()->Name()))
      {
	table = li.current();
	break;
      }
  return table;
}
/*
 */
VDKXTable*
VDKXDatabase::operator[](int k)
{
  VDKXTable* table = (VDKXTable*) NULL;
  if(k >= 0 && k < tList.size())
    table = tList[k];
  return table;
}


