/*
 * MP3/MPlayer plugin to VDR (C++)
 *
 * (C) 2001,2002 Stefan Huelswitt <huels@iname.com>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#ifndef ___MENU_MP3_H
#define ___MENU_MP3_H

#include <vdr/osd.h>
#include <vdr/menuitems.h>

#include "setup-mp3.h"

class cPlayLists;

// ----------------------------------------------------------------

class cMenuSetupMP3 : public cMenuSetupPage {
private:
  cMP3Setup data;
protected:
  virtual void Store(void);
public:
  cMenuSetupMP3(void);
  };

// ----------------------------------------------------------------

class cMenuMP3 : public cOsdMenu {
private:
  cPlayLists *lists;
  bool renaming, sourcing, instanting;
  int buttonnum;
  eOSState Play(void);
  eOSState Edit(void);
  eOSState New(void);
  eOSState Delete(void);
  eOSState Rename(bool second);
  eOSState Source(bool second);
  eOSState Instant(bool second);
  void ScanLists(void);
  eOSState SetButtons(int num);
public:
  cMenuMP3(void);
  ~cMenuMP3(void);
  virtual eOSState ProcessKey(eKeys Key);
  };

#endif //___MENU_MP3_H
