/*
 * i18n.c: Internationalization
 *
 * See the main source file 'vdr.c' for copyright information and
 * how to reach the author.
 *
 * $Id: i18n.c 1.195 2005/06/18 10:42:31 kls Exp $
 *
 * Translations provided by:
 *
 * Slovenian   Miha Setina <mihasetina@softhome.net>, Matjaz Thaler <matjaz.thaler@guest.arnes.si>
 * Italian     Alberto Carraro <bertocar@tin.it>, Antonio Ospite <ospite@studenti.unina.it>, Sean Carlos <seanc@libero.it>
 * Dutch       Arnold Niessen <niessen@iae.nl> <arnold.niessen@philips.com>, Hans Dingemans <hans.dingemans@tacticalops.nl>
 * Portuguese  Paulo Lopes <pmml@netvita.pt>
 * French      Jean-Claude Repetto <jc@repetto.org>, Olivier Jacques <jacquesolivier@hotmail.com>, Gregoire Favre <greg@magma.unil.ch>
 * Norwegian   Jrgen Tvedt <pjtvedt@online.no>, Truls Slevigen <truls@slevigen.no>
 * Finnish     Hannu Savolainen <hannu@opensound.com>, Jaakko Hyvtti <jaakko@hyvatti.iki.fi>, Niko Tarnanen <niko.tarnanen@hut.fi>, Rolf Ahrenberg <rahrenbe@cc.hut.fi>
 * Polish      Michael Rakowski <mrak@gmx.de>
 * Spanish     Ruben Nunez Francisco <ruben.nunez@tang-it.com>
 * Greek       Dimitrios Dimitrakos <mail@dimitrios.de>
 * Swedish     Tomas Prybil <tomas@prybil.se>, Jan Ekholm <chakie@infa.abo.fi>
 * Romanian    Paul Lacatus <paul@campina.iiruc.ro>, Lucian Muresan <lucianm@users.sourceforge.net>
 * Hungarian   Istvan Koenigsberger <istvnko@hotmail.com>, Guido Josten <guido.josten@t-online.de>
 * Catalanian  Marc Rovira Vall <tm05462@salleURL.edu>, Ramon Roca <ramon.roca@xcombo.com>, Jordi Vil <jvila@tinet.org>
 * Russian     Vyacheslav Dikonov <sdiconov@mail.ru>
 * Croatian    Drazen Dupor <drazen.dupor@dupor.com>, Dino Ravnic <dino.ravnic@fer.hr>
 * Estonian    Arthur Konovalov <kasjas@hot.ee>
 * Danish      Mogens Elneff <mogens@elneff.dk>
 *
 */

/*
 * How to add a new language:
 *
 * 1. Announce your translation action on the VDR mailing
 *    list to avoid duplicate work.
 * 2. Increase the value of 'I18nNumLanguages' in 'i18n.h'.
 * 3. Insert a new line in every member of the 'Phrases[]' array,
 *    containing the translated text for the new language.
 *    For example, assuming you want to add the Italian language,
 *
 *       { "English",
 *         "Deutsch",
 *       },
 *
 *    would become
 *
 *       { "English",
 *         "Deutsch",
 *         "Italiano",
 *       },
 *
 *    and so on. Append your language after the last existing language
 *    and write the name of your language in your language (not in English,
 *    which means that it should be 'Italiano', not 'Italian').
 *    Note that only the characters defined in 'fontosd.c' will
 *    be available!
 * 4. If your language requires a character set other than the default iso8859-1
 *    you need to make the appropriate entry in the second phrase below, and
 *    also create the necessary font files in case they are not yet part of
 *    the VDR source (see how this is done for iso8859-7, for instance). Don't
 *    forget to adjust the files font.h and font.c accordingly.
 * 5. Compile VDR and test the new language by switching to it
 *    in the "Setup/OSD" menu.
 * 6. Send the modified files to <kls@cadsoft.de> to have
 *    it included in the next version of VDR.
 *
 * In case an English phrase is used in more than one context (and might need
 * different translations in other languages) it can be preceeded with an
 * arbitrary string to describe its context, separated from the actual phrase
 * by a '$' character (see for instance "Button$Stop" vs. "Stop").
 * Of course this means that no English phrase may contain the '$' character!
 * If this should ever become necessary, the existing '$' would have to be
 * replaced with something different...
 */

#include "i18n.h"
#include <ctype.h>
#include "config.h"
#include "tools.h"

const tI18nPhrase Phrases[] = {
  // The name of the language (this MUST be the first phrase!):
  { "English",
    "Deutsch",
    "Slovenski",
    "Italiano",
    "Nederlands",
    "Portugus",
    "Franais",
    "Norsk",
    "suomi", // Finnish (this is not a typo - it's really lowercase!)
    "Polski",
    "Espaol",
    "", // Greek
    "Svenska",
    "Romn",
    "Magyar",
    "Catal",
    "", // Russian
    "Hrvatski",
    "Eesti",
    "Dansk",
  },
  // The character set needed for this language (this MUST be the second phrase!):
  { "iso8859-15",
    "iso8859-15",
    "iso8859-1",
    "iso8859-1",
    "iso8859-1",
    "iso8859-1",
    "iso8859-1",
    "iso8859-1",
    "iso8859-15",
    "iso8859-1",
    "iso8859-1",
    "iso8859-7",
    "iso8859-1",
    "iso8859-2",
    "iso8859-1",
    "iso8859-1",
    "iso8859-5",
    "iso8859-2",
    "iso8859-13",
    "iso8859-1",
  },
  // The 3-letter names of the language (this MUST be the third phrase!):
  { "eng,dos",
    "deu,ger",
    "slv",
    "ita",
    "dut,nla,nld",
    "por",
    "fra,fre",
    "nor",
    "fin,smi",
    "pol",
    "esl,spa",
    "ell,gre",
    "sve,swe",
    "rom,rum",
    "hun",
    "cat,cln",
    "rus",
    "hrv",
    "est",
    "dan",
  },
  // Menu titles:
  { "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
    "VDR",
  },
  { "Schedule",
    "Programm",
    "Program",
    "Programmi",
    "Gids",
    "Programao",
    "Programmes",
    "Programmer",
    "Ohjelmisto",
    "Program",
    "Gua de Programacin",
    "",
    "Program",
    "Program (EPG)",
    "Program",
    "Guia de Programaci",
    "",
    "Raspored",
    "Kava",
    "Programoversigt",
  },
  { "Channels",
    "Kanle",
    "Kanali",
    "Canali",
    "Kanalen",
    "Canais",
    "Chanes",
    "Kanaler",
    "Kanavat",
    "Kanaly",
    "Canales",
    "",
    "Kanaler",
    "Canale",
    "Csatornk",
    "Canals",
    "",
    "Programi",
    "Kanalid",
    "Kanaler",
  },
  { "Timers",
    "Timer",
    "Termini",
    "Timer",
    "Timers",
    "Timers",
    "Programmation",
    "Timere",
    "Ajastin",
    "Timery",
    "Timer",
    "",
    "Timers",
    "Timer-e",
    "Felvtel beprogramozsa",
    "Temporitzadors",
    "",
    "Termini",
    "Taimer",
    "Timere",
  },
  { "Recordings",
    "Aufzeichnungen",
    "Posnetki",
    "Registrazioni",
    "Opnames",
    "Gravaes",
    "Enregistrements",
    "Opptak",
    "Tallenteet",
    "Nagrania",
    "Grabaciones",
    "",
    "Inspelningar",
    "nregistrri",
    "Felvett adsok",
    "Veure programes gravats",
    "",
    "Snimke",
    "Salvestused",
    "Optagelser",
  },
  { "Setup",
    "Einstellungen",
    "Nastavitve",
    "Opzioni",
    "Instellingen",
    "Configurar",
    "Configuration",
    "Konfigurasjon",
    "Asetukset",
    "Nastawy",
    "Configuracin",
    "",
    "Instllningar",
    "Configuraie",
    "Belltsok",
    "Configuraci",
    "",
    "Konfiguracija",
    "Stted",
    "Indstillinger",
  },
  { "Commands",
    "Befehle",
    "Ukazi",
    "Comandi",
    "Commando's",
    "Comandos",
    "Commandes",
    "Kommandoer",
    "Komennot",
    "Rozkazy",
    "rdenes",
    "",
    "Kommandon",
    "Comenzi",
    "Parancsok",
    "Ordres",
    "",
    "Naredbe",
    "Ksud",
    "Kommandoer",
  },
  { "Recording commands",
    "Befehle fr Aufzeichnungen",
    "Ukazi za snemanje",
    "Comandi di Registrazione",
    "Opname commando's",
    "",// TODO
    "Commandes d'enregistrement",
    "",// TODO
    "Tallennuskomennot",
    "Rozkazy Nagran",
    "rdenes de grabacin",
    "  ",
    "Inspelningskommandon",
    "Comenzi nregistrare",
    "Parancsok a felvett filmekhez",
    "Ordres de gravaci",
    " ",
    "Naredbe za snimanje",
    "Salvestuse ksud",
    "Optage kommandoer",
  },
  { "Edit channel",
    "Kanal editieren",
    "Uredi kanal",
    "Modifica canale",
    "Kanaal aanpassen",
    "Modificar canal",
    "Modifier une chane",
    "Editer kanal",
    "Muokkaa kanavaa",
    "Ustawienie kanalu",
    "Modificar canal",
    " ",
    "ndra kanal",
    "Modificare canal",
    "Csatornk belltsa",
    "Editar canal",
    " ",
    "Ureivanje programa",
    "Kanali muutmine",
    "Rediger kanal",
  },
  { "Edit timer",
    "Timer editieren",
    "Uredi termin",
    "Modifica timer",
    "Timer veranderen",
    "Modificar timer",
    "Changer la programmation",
    "Editer timer",
    "Muokkaa ajastinta",
    "Ustawienie timerow",
    "Modificar timer",
    " ",
    "ndra timer",
    "Modificare timer",
    "Felvtel beprogramozsnak megvltoztatsa",
    "Editar temporitzador",
    " ",
    "Ureivanje termina",
    "Taimeri muutmine",
    "Rediger timer",
  },
  { "Event",
    "Sendung",
    "Oddaja",
    "Eventi",
    "Uitzending",
    "Evento",
    "Evnement",
    "Hendelse",
    "Tapahtuma",
    "Audycja",
    "Evento",
    "",
    "Sndning",
    "Emisiune",
    "Ads",
    "Esdeveniment",
    "",
    "Emisija",
    "Sndmus",
    "Udsendelse",
  },
  { "Summary",
    "Inhalt",
    "Vsebina",
    "Sommario",
    "Inhoud",
    "Resumo",
    "Rsum",
    "Sammendrag",
    "Yhteenveto",
    "Zawartosc",
    "Resmen",
    "",
    "Sammanfattning",
    "Detalii",
    "Tartalom",
    "Sinopsi",
    "",
    "Sadraj",
    "Kokkuvte",
    "Omtale",
  },
  { "Info",
    "Info",
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "Tiedot",
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "",//TODO
    "Info",
    "",//TODO
  },
  { "Schedule - %s",
    "Programm - %s",
    "Program - %s",
    "Programma - %s",
    "Programma - %s",
    "Programa - %s",
    "Programmes - %s",
    "Program Guide - %s",
    "Ohjelmisto - %s",
    "Program - %s",
    "Programa - %s",
    " - %s",
    "Program - %s",
    "Programul canalului %s",
    "Program - %s",
    "Guia de Programaci - %s",
    " - %s",
    "Raspored - %s",
    "Programm - %s",
    "Program - %s",
  },
  { "What's on now?",
    "Was luft jetzt?",
    "Kaj je na sporedu?",
    "In programmazione",
    "Wat is er nu?",
    "Programa actual?",
    "Programmes en cours",
    "Hvilket program sendes n?",
    "Menossa nyt",
    "Program biezacy",
    "Qu hay ahora?",
    " ",
    "Vilket program snds nu?",
    "Ce emisiuni sunt acum?",
    "Mi megy most?",
    "Qu fan ara?",
    "  :",
    "to je trenutno na programu?",
    "Hetkel eetris",
    "Hvilket program vises nu?",
  },
  { "What's on next?",
    "Was luft als nchstes?",
    "Kaj sledi?",
    "Prossimi programmi",
    "Wat komt er hierna?",
    "Prximo Programa?",
    "Prochains programmes",
    "Hvilket program er neste?",
    "Tulossa seuraavaksi",
    "Program nastepny",
    "Qu hay proximo?",
    " ",
    "Vilket r nsta program?",
    "Ce emisiuni urmeaz?",
    "Mi kvetkezik?",
    "Qu fan desprs?",
    "  :",
    "to slijedi?",
    "Jrgmisena eetris",
    "Hvilket nste program vises?",
  },
  // Button texts (should not be more than 10 characters!):
  { "Edit",
    "Editieren",
    "Uredi",
    "Modifica",
    "Verander",
    "Modificar",
    "Modifier",
    "Editer",
    "Muokkaa",
    "Edycja",
    "Modificar",
    "",
    "ndra",
    "Modific",
    "Belltani",
    "Editar",
    "",
    "Promijeni",
    "Muuda",
    "Rediger",
  },
  { "New",
    "Neu",
    "Novo",
    "Nuovo",
    "Nieuw",
    "Novo",
    "Nouveau",
    "Ny",
    "Uusi",
    "Nowy",
    "Nuevo",
    "",
    "Ny",
    "Nou",
    "j",
    "Nou",
    "",
    "Novi",
    "Uus",
    "Ny",
  },
  { "Delete",
    "Lschen",
    "Izbrisi",
    "Cancella",
    "Verwijder",
    "Apagar",
    "Supprimer",
    "Slett",
    "Poista",
    "Usunac",
    "Borrar",
    "",
    "Ta bort",
    "terge",
    "Trlni",
    "Esborrar",
    "",
    "Obrii",
    "Kustuta",
    "Slet",
  },
  { "Mark",
    "Markieren",
    "Oznaci",
    "Marca",
    "Verplaats",
    "Marcar",
    "Marquer",
    "Marker",
    "Siirr",
    "Zaznaczyc",
    "Marcar",
    "",
    "Mrk",
    "Marcheaz",
    "Megjellni",
    "Marcar",
    "",
    "Oznai",
    "Siirda",
    "Markr",
  },
  { "On/Off",
    "Ein/Aus",
    "Vklop/Izklop",
    "On/Off",
    "Aan/Uit",
    "On/Off",
    "Marche/Arr",
    "Av/P",
    "Pll/Pois",
    "Zal./ Wyl.",
    "On/Off",
    "A/K",
    "P/Av",
    "Act./Inact.",
    "Be/Ki",
    "On/Off",
    "/",
    "De-/Aktiviraj",
    "Sees/Vljas",
    "Til/Fra",
  },
  { "Record",
    "Aufnehmen",
    "Posnemi",
    "Registra",
    "Opnemen",
    "Gravar",
    "Enregistre",
    "Ta opp",
    "Tallenna",
    "Nagrywac",
    "Grabar",
    "",
    "Inspelning",
    "nregistr.",
    "Felvenni",
    "Gravar",
    "",
    "Snimi",
    "Salvesta",
    "Optag",
  },
  { "Play",
    "Wiedergabe",
    "Predvajaj",
    "Riproduci",
    "Afspelen",
    "Play",
    "Lire",
    "Spill av",
    "Toista",
    "Odtwarzac",
    "Play",
    "",
    "Spela upp",
    "Redare",
    "Lejtszani",
    "Reproduir",
    "",
    "Start",
    "Start",
    "Afspil",
  },
  { "Rewind",
    "Anfang",
    "Na zacetek",
    "Da inizio",
    "Naar begin",
    "Rebobinar",
    "Retour",
    "Spol tilbake",
    "Alkuun",
    "Poczatek",
    "Rebobinar",
    "",
    "terspolning",
    "napoi",
    "Vissza az elejre",
    "Enrera",
    "",
    "Na poetak",
    "Algusesse",
    "Forfra",
  },
  { "Button$Stop",
    "Beenden",
    "Ustavi",
    "Stop",
    "Eindigen",
    "Parar",
    "Arrt",
    "Stopp",
    "Lopeta",
    "Zakonczyc",
    "Parar",
    "",
    "Stopp",
    "Stop",
    "Stop",
    "Aturar",
    "",
    "Stop",
    "Stopp",
    "Stop",
  },
  { "Resume",
    "Weiter",
    "Nadaljuj",
    "Riprendi",
    "Verder",
    "Continuar",
    "Reprendre",
    "Fortsett",
    "Jatka",
    "Dalej",
    "Continuar",
    "",
    "Fortstt",
    "Revenire",
    "Tovbb",
    "Continuar",
    "",
    "Nastavi",
    "Jtka",
    "Fortst",
  },
  { "Summary",
    "Inhalt",
    "Vsebina",
    "Sommario",
    "Inhoud",
    "Resumo",
    "Rsum",
    "Sammendrag",
    "Yhteenveto",
    "Zawartosc",
    "Resumen",
    "",
    "Sammanfattning",
    "Cuprins",
    "Tartalom",
    "Resum",
    "",
    "Sadraj",
    "Kokkuvte",
    "Omtale",
  },
  { "Open",
    "ffnen",
    "Odpri",
    "Apri",
    "Openen",
    "Abrir",
    "Ouvrir",
    "pne",
    "Avaa",
    "Otworzyc",
    "Abrir",
    "",
    "ppna",
    "Deschide",
    "Kinyitni",
    "Obrir",
    "",
    "Otvori",
    "Ava",
    "bn",
  },
  { "Switch",
    "Umschalten",
    "Preklopi",
    "Cambia",
    "Selecteer",
    "Seleccionar",
    "Regarder",
    "Skift til",
    "Valitse",
    "Przelaczyc",
    "Cambiar",
    "A",
    "Byt",
    "Comut",
    "tkapcsolni",
    "Canviar",
    "",
    "Prebaci",
    "Vali",
    "Skift",
  },
  { "Now",
    "Jetzt",
    "Sedaj",
    "Adesso",
    "Nu",
    "Agora",
    "Maintenant",
    "N",
    "Nyt",
    "Teraz",
    "Ahora",
    "",
    "Nu",
    "Acum",
    "Most",
    "Ara",
    "",
    "Trenutno",
    "Nd",
    "Nu",
  },
  { "Next",
    "Nchste",
    "Sledi",
    "Prossimo",
    "Hierna",
    "Proximo",
    "Aprs",
    "Neste",
    "Seuraavaksi",
    "Nastepny",
    "Siguiente",
    "",
    "Nsta",
    "Urmtor",
    "Kvetkez",
    "Segent",
    "",
    "Slijedi",
    "Jrgmine",
    "Nste",
  },
  { "Button$Schedule",
    "Programm",
    "Program",
    "Programma",
    "Programma",
    "Programao",
    "Programme",
    "Programmer",
    "Ohjelmisto",
    "Program",
    "Programa",
    "",
    "Program",
    "Program",
    "Program",
    "Programar",
    "",
    "Raspored",
    "Kava",
    "Program",
  },
  { "Language",
    "Sprache",
    "Jezik",
    "Linguaggio",
    "Taal",
    "Linguagem",
    "Langue",
    "Sprk",
    "Kieli",
    "Jezyk",
    "Idioma",
    "",
    "Sprk",
    "Limba",
    "Nyelv",
    "Idioma",
    "",
    "Jezik",
    "Keel",
    "Sprog",
  },
  { "Eject",
    "Auswerfen",
    "Izvrzi",
    "Eject",
    "Eject",
    "Ejectar",
    "Ejection",
    "Eject",
    "Avaa",
    "Wyrzucenie",
    "Expulsar",
    "",
    "Mata ut",
    "Ejecteaz",
    "Kidobni",
    "Expulsar",
    "",
    "Izbaci",
    "Ava",
    "Skub ud",
  },
  { "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "AB/",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
    "/",
    "ABC/abc",
    "ABC/abc",
    "ABC/abc",
  },
  { "Insert",
    "Einfgen",
    "Vstavi",
    "Inserisci",
    "Invoegen",
    "",// TODO
    "Insrt",
    "",// TODO
    "Lis",
    "Wstawiac",
    "Insertar",
    "",
    "Infoga",
    "Insereaz",
    "Beilleszteni",
    "Inserir",
    "",
    "Umetni",
    "Lisa (INS)",
    "Indst",
  },
  { "Overwrite",
    "berschreiben",
    "Prepisi",
    "Sovrascrivi",
    "Overschrijven",
    "",// TODO
    "craser",
    "",// TODO
    "Korvaa",
    "Przepisac",
    "Sobreescribir",
    "",
    "Skriv ver",
    "Suprascrie",
    "trni",
    "Sobrescriure",
    "",
    "Prepii",
    "Asenda (OVR)",
    "Overskriv",
  },
  { "Menu",
    "Men",
    "Meni",
    "Men",
    "Menu",
    "Menu",
    "Menu",
    "Meny",
    "Valikko",
    "Menu",
    "Men",
    "M",
    "Meny",
    "Meniu",
    "Men",
    "Men",
    "",
    "Izbor",
    "Men",
    "Menu",
  },
  { "Reset",
    "Reset",
    "Reset",
    "Reset",
    "Herstart",
    "",//TODO
    "Rinitialisation",
    "",//TODO
    "Alusta",
    "Reset",
    "Reiniciar",
    "",
    "terstll",
    "Resetare",
    "Reset",
    "Reiniciar",
    "",
    "Reset",
    "Nullimine",
    "Nulstille",
  },
  { "Scan",
    "Scan",
    "",//TODO
    "Scansione",
    "Scan",
    "",//TODO
    "Scan",
    "",//TODO
    "Pivit",
    "",//TODO
    "",//TODO
    "",//TODO
    "Skanna",
    "Cutare canale",
    "",//TODO
    "",//TODO
    "",
    "Pretrai",
    "Uuenda",
    "Skan",
  },
  // Confirmations:
  { "Delete channel?",
    "Kanal lschen?",
    "Izbrisi kanal?",
    "Cancello il canale?",
    "Kanaal verwijderen?",
    "Apagar o canal?",
    "Supprimer la chane?",
    "Slette kanal?",
    "Poistetaanko kanava?",
    "Usunac kanal?",
    "Eliminar canal?",
    " ?",
    "Ta bort kanalen?",
    "terg canalul?",
    "Csatorna trlse?",
    "Esborrar el canal?",
    " ?",
    "Obrisati program?",
    "Kustutan kanali?",
    "Slet kanal?",
  },
  { "Delete timer?",
    "Timer lschen?",
    "Izbrisi termin?",
    "Cancello il timer?",
    "Timer verwijderen?",
    "Apagar o timer?",
    "Supprimer la programmation?",
    "Slette timer?",
    "Poistetaanko ajastin?",
    "Usunac timer?",
    "Eliminar timer?",
    " ?",
    "Ta bort timern?",
    "terg timer-ul?",
    "Felvtel beprogramozsnak trlse?",
    "Esborrar el temporitzador?",
    " ?",
    "Obrisati termin?",
    "Kustutan taimeri?",
    "Slet timer?",
  },
  { "Delete recording?",
    "Aufzeichnung lschen?",
    "Izbrisi posnetek?",
    "Cancello la registrazione?",
    "Opname verwijderen?",
    "Apagar a gravao?",
    "Supprimer l'enregistrement?",
    "Slette opptak?",
    "Poistetaanko tallenne?",
    "Usunac nagranie?",
    "Eliminar grabacion?",
    " ?",
    "Ta bort inspelningen?",
    "terg nregistrarea?",
    "Felvtel trlse?",
    "Esborrar gravaci?",
    " ?",
    "Obrisati snimku?",
    "Kustutan salvestuse?",
    "Slet optagelse?",
  },
  { "Timer still recording - really delete?",
    "Timer zeichnet auf - trotzdem lschen?",
    "Snemanje po terminu - zares izbrisi?",
    "Timer in registrazione - cancello?",
    "Timer neemt nog op - toch verwijderen?",
    "Timer activo - tm a certeza que quer apagar?",
    "Enregistrement en cours - confirmez la suppression",
    "Timer gjr opptak - vil du slette likevel?",
    "Ajastettu tallennus kynniss - keskeytetnk?",
    "Nagrywanie w trakcie - napewno usunac?",
    "Timer activo - de verdad eliminarlo?",
    "   -  ?",
    "Timerstyrd inspelning pgr - Avbryta nd?",
    "Timer-ul tocmai nregistreaz - terg, totui?",
    "Felvtel folyamatban van - mgis trlni?",
    "Temporitzador activat - Esborrar de totes maneres?",
    "    -  ?",
    "Jo snimam - zaista obrisati?",
    "Salvestus aktiivne - kustutan?",
    "Timerstyret optagelse i gang - slet alligevel?",
  },
  { "Stop recording?",
    "Aufzeichnung beenden?",
    "Koncaj snemanje?",
    "Fermo la registrazione?",
    "Opname stoppen?",
    "Parar Gravao?",
    "Arrter l'enregistrement?",
    "Stoppe opptak?",
    "Lopetetaanko tallennus?",
    "Zakonczyc nagranie?",
    "Parar grabacin?",
    " ?",
    "Stanna inspelning?",
    "Opresc nregistrarea?",
    "Felvtel befejezni?",
    "Aturar la gravaci?",
    " ?",
    "Zaustaviti snimanje?",
    "Lpetan salvestamise?",
    "Stop optagelse?",
  },
  { "on primary interface",
    "auf dem primren Interface",
    "na primarni napravi",
    "su interfaccia primaria",
    "op eerste interface",
    "no interface primrio",
    "sur la carte primaire",
    "p frste enhet",
    "pvastaanottimella",
    "na pierwszym interfejsie",
    "en interface primario",
    "  ",
    "frn den frsta enheten?",
    "pe prima interfa",
    "az els krtyn",
    "a la interfcie primria",
    "  ",
    "na primarnom ureaju",
    "peavastuvtjal",
    "p primr enhed",
  },
  { "Cancel editing?",
    "Schneiden abbrechen?",
    "Zelite prekiniti urejanje?",
    "Annullo la modifica?",
    "Bewerken afbreken?",
    "Cancelar Modificaes?",
    "Annuler les modifications?",
    "Avbryte redigering?",
    "Perutaanko muokkaus?",
    "Zakonczyc montaz?",
    "Cancelar modificacin?",
    "A ?",
    "Avbryta redigeringen?",
    "Opresc montajul nregistrrii?",
    "Vgst befejezni?",
    "Cancellar l'edici?",
    " ?",
    "Otkazati ureivanje?",
    "Thistan muudatuse?",
    "Afbryd redigering?",
  },
  { "Really restart?",
    "Wirklich neu starten?",
    "Zares ponoven zagon?",
    "Eseguo un restart?",
    "Werkelijk opnieuw starten?",
    "Tem a certeza que quer reiniciar?",
    "Redmarrer?",
    "Vil du virkelig starte p nytt?",
    "Kynnistetnk uudelleen?",
    "Rzeczywiscie nowy start?",
    "De verdad reiniciar?",
    "N   ?",
    "Vill du verkligen starta om?",
    "Sigur repornesc?",
    "Tnyleg jraindtani?",
    "Segur que voleu reiniciar?",
    " ?",
    "Zaista ponovo pokrenuti?",
    "Restart?",
    "Vil du virkelig genstarte?",
  },
  { "Recording - restart anyway?",
    "Aufnahme luft - trotzdem neu starten?",
    "Snemanje - zares ponoven zagon?",
    "In registrazione - restart comunque?",
    "Opname loopt - toch opnieuw starten?",
    "Em gravao - quer mesmo reiniciar?",
    "Enregistrement en cours - redmarrer?",
    "Gjr opptak - starte p nytt likevel?",
    "Tallennus kesken - kynnistetnk uudelleen?",
    "Nagrywanie w trakcie - rzeczywiscie nowy start?",
    "Grabando - reiniciar?",
    "  -    ?",
    "Inspelning pgr, vill du nd starta om?",
    "Tocmai se nregistreaz - repornesc, totui?",
    "Felvtel folyamatban van - mgis jraindtani?",
    "Gravant - Reiniciar de totes maneres?",
    "  -  ?",
    "Snimanje traje - svejedno restart sistema?",
    "Salvestamine aktiivne - restart?",
    "Optagelse igang - genstart alligevel?",
  },
  { "Recording - shut down anyway?",
    "Aufnahme luft - trotzdem ausschalten?",
    "Snemanje - zares izklopi?",
    "In registrazione - spengo comunque?",
    "Opname loopt - toch uitschakelen?",
    "Em gravao - quer mesmo desligar?",
    "Enregistrement en cours - confirmez l'arrt",
    "Gjr opptak - sl av likevel?",
    "Tallennus kesken - sammutetaanko?",
    "Nagrywanie w trakcie - mimo to wylaczyc?",
    "Grabando - apagar?",
    "  -    ?",
    "Inspelning pgr, vill du nd avbryta?",
    "Tocmai se nregistreaz - nchid, totui?",
    "Felvtel folyamatban van - mgis kikapcsolni?",
    "Gravant - Apagar de totes maneres?",
    "  -  ?",
    "Snimanje traje - svejedno iskljuiti?",
    "Salvestamine aktiivne - llitan vlja?",
    "Optagelse igang - sluk alligevel?",
  },
  { "Recording in %d minutes, shut down anyway?",
    "Aufnahme in %d Minuten - trotzdem ausschalten?",
    "Snemanje cez %d minut, zares izklopi?",
    "Registrazione fra %d minuti - spengo comunque?",
    "Opname in %d minuten - toch uitschakelen?",
    "Em gravao dentro de %d minutos - quer mesmo desligar?",
    "Enregistrement dans %d minutes - confirmez l'arrt",
    "Skal gjre opptak om %d minutter - sl av likevel?",
    "Tallennus alkaa %d min kuluttua - sammutetaanko?",
    "Nagrywanie za %d minut - mimo to wylaczyc?",
    "Grabando en %d minutos, de verdad apagar?",
    "   %d  -   ?",
    "Inspelning startar om %d minuter, vill du avsluta?",
    "nregistrez peste %d minute - nchid, totui?",
    "Felvtel %d perc mulva kezddik - mgis kikapcsolni?",
    "Hi ha una gravaci en %d minuts - Apagar de totes maneres?",
    " %d    -  ?",
    "Snimanje za %d minuta - svejedno iskljuiti?",
    "Salvestamine algab %d minuti prast - llitan vlja?",
    "Optagelse om %d minutter - sluk alligevel?",
  },
  { "Press any key to cancel shutdown",
    "Taste drcken um Shutdown abzubrechen",
    "Pritisni katerikoli gumb za preklic izklopa",
    "Un tasto per annullare lo spegnimento",
    "Druk een toets om shutdown af te breken",
    "Pressione qualquer tecla para cancelar",
    "Appuyez sur une touche pour annuler l'arrt",
    "Trykk en tast for ikke  sl av",
    "Peru sammutus painamalla mit tahansa nppint",
    "Dowolny przycisk zatrzyma wylaczanie",
    "Pulse una tecla para interrumpir apagar",
    "     ",
    "Tryck valfri knapp fr att terkalla avstngningen",
    "Apas orice tast pentru a anula nchiderea",
    "Nyomj egy gombot a lells meglltshoz",
    "Prem qualsevol tecla per cancellar l'aturada",
    "     .",
    "Pritisnite tipku ako ne elite ugasiti sistem",
    "Vajuta suvalist klahvi vljallitamise thistamiseks",
    "Tryk vilkrlig tast for at annullere sluk",
  },
  // Channel parameters:
  { "Name",
    "Name",
    "Naziv",
    "Nome",
    "Naam",
    "Nome",
    "Nom",
    "Navn",
    "Nimi",
    "Nazwa",
    "Nombre",
    "",
    "Namn",
    "Nume",
    "Nv",
    "Nom",
    "",
    "Naziv",
    "Nimi",
    "Navn",
  },
  { "Frequency",
    "Frequenz",
    "Frekvenca",
    "Frequenza",
    "Frequentie",
    "Frequncia",
    "Frquence",
    "Frekvens",
    "Taajuus",
    "Czestotliwosc",
    "Frecuencia",
    "",
    "Frekvens",
    "Frecven",
    "Frekvencia",
    "Freqncia",
    "",
    "Frekvencija",
    "Sagedus",
    "Frekvens",
  },
  { "Polarization",
    "Polarisation",
    "Polarizacija",
    "Polarizzazione",
    "Polarisatie",
    "Polarizao",
    "Polarisation",
    "Polarisasjon",
    "Polarisaatio",
    "Polaryzacja",
    "Polarizacin",
    "",
    "Polarisation",
    "Polarizare",
    "Polarizci",
    "Polaritzaci",
    "",
    "Polarizacija",
    "Polarisatsioon",
    "Polarisation",
  },
  { "Source",
    "Quelle",
    "Pozicija",
    "Sorgente",
    "Bron",
    "",//TODO
    "Source",
    "",//TODO
    "Lhde",
    "Zrodlo",
    "",//TODO
    "",
    "Klla",
    "Surs",
    "Forrs",
    "Origen",
    "",
    "Izvor",
    "Allikas",
    "Kilde",
  },
  { "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Srate",
    "Frq. Symbole",
    "Srate",
    "Symbolinopeus",
    "Srate",
    "Srate",
    "Srate",
    "Symbolrate",
    "Rat simboluri",
    "Srate",
    "Srate",
    ". ",
    "Srate", // hrv
    "Srate",
    "Srate",
  },
  { "Vpid",
    "Vpid",
    "Vpid",
    "Vpid",
    "Vpid",
    "PID de Vdeo",
    "PID Vido",
    "Vpid",
    "Kuva-PID",
    "Vpid",
    "Vpid",
    "B PID",
    "Video PID",
    "PID Video",
    "Vpid",
    "PID Vdeo",
    "Vpid ()",
    "Vpid",
    "Vpid",
    "Vpid",
  },
  { "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Aikatieto-PID",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
    "Ppid",
  },
  { "Apid1",
    "Apid1",
    "Apid1",
    "Apid1",
    "Apid1",
    "PID udio (1)",
    "PID Audio (1)",
    "Apid1",
    "ni-PID (1)",
    "Apid1",
    "Apid1",
    "Apid1",
    "Audio PID1",
    "PID Audio (1)",
    "Apid1",
    "PID udio (1)",
    "Apid1 ( 1)",
    "Apid1", // hrv
    "Apid1",
    "Apid1",
  },
  { "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "Apid2",
    "PID Audio (2)",
    "Apid2",
    "ni-PID (2)",
    "Apid2",
    "Apid2",
    "Apid2",
    "Audio PID2",
    "PID Audio (2)",
    "Apid2",
    "PID udio (2)",
    "Apid2 ( 2)",
    "Apid2", // hrv
    "Apid2",
    "Apid2",
  },
  { "Dpid1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "PID AC3 (1)",
    "PID AC3 (1)",
    "AC3pid1",
    "Dolby-PID (1)",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "Dpid1",
    "PID AC3 (1)",
    "Dpid1",
    "PID AC3 (1)",
    "Dpid1 (AC3 1)",
    "Dpid1", // hrv
    "Dpid1",
    "Dpid1",
  },
  { "Dpid2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "PID AC3 (2)",
    "PID AC3 (2)",
    "AC3pid2",
    "Dolby-PID (2)",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "Dpid2",
    "PID AC3 (2)",
    "Dpid2",
    "PID AC3 (2)",
    "Dpid2 (AC3 2)",
    "Dpid2", // hrv
    "Dpid2",
    "Dpid2",
  },
  { "Tpid",
    "Tpid",
    "Tpid",
    "Tpid",
    "Tpid",
    "PID Teletexto",
    "PID Tltexte",
    "Tekst-TV pid",
    "Teksti-TV-PID",
    "Tpid",
    "Tpid",
    "Tpid",
    "Teletext PID",
    "PID Teletext",
    "Tpid",
    "PID Teletext",
    "Tpid ()",
    "Tpid", // hrv
    "Tpid",
    "Tpid",
  },
  { "CA",
    "CA",
    "CA",
    "CA",
    "CA",
    "Encriptao",
    "Cryptage",
    "Kortleser",
    "Salaus",
    "CA",
    "CA",
    "CA",
    "Kortlsare",
    "CA (Acces Condiional)",
    "CA",
    "Accs Condicional",
    "CA ()",
    "Kodiranje (CA)",
    "CA",
    "CA",
  },
  { "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Palvelu-ID",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid",
    "Sid", // hrv
    "Sid",
    "Sid",
  },
  { "Inversion",
    "Inversion",
    "Inverzija",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversio",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversion",
    "Inversiune",
    "Inversion",
    "Inversi",
    "",
    "Inverzija",
    "Inversioon",
    "Inversion",
  },
  { "Bandwidth",
    "Bandwidth",
    "Pasovna sirina",
    "Bandwidth",
    "Bandwidth",
    "Bandwidth",
    "Bande passante",
    "Bandwidth",
    "Kaistanleveys",
    "Szerokosc pasma",
    "Bandwidth",
    "Bandwidth",
    "Bandbredd",
    "Lrgime de band",
    "Bandwidth",
    "Amplada de banda",
    "",
    "Bandwidth", // hrv "Pojasna irina",
    "Ribalaius",
    "Bndbredde",
  },
  { "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "Ylsuojaustaso",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH",
    "CoderateH", // hrv
    "CoderateH",
    "CoderateH",
  },
  { "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "Alasuojaustaso",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL",
    "CoderateL", // hrv
    "CoderateL",
    "CoderateL",
  },
  { "Modulation",
    "Modulation",
    "Modulacija",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulaatio",
    "Modulacja",
    "Modulation",
    "Modulation",
    "Modulation",
    "Modulaie",
    "Modulation",
    "Modulaci",
    "",
    "Modulacija",
    "Modulatsioon",
    "Modulation",
  },
  { "Transmission",
    "Transmission",
    "Prenos",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmission",
    "Lhetystila",
    "Transmisja",
    "Transmission",
    "Transmission",
    "Transmission",
    "Transmisiune",
    "Transmission",
    "Transmissi",
    "",
    "Prijenos",
    "Transmissioon",
    "Transmission",
  },
  { "Guard",
    "Guard",
    "Zascita",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Suojavli",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Guard",
    "Protegir",
    "",
    "Zatita",
    "Guard",
    "Guard",
  },
  { "Hierarchy",
    "Hierarchy",
    "Hierarhija",
    "Hierarchy",
    "Hierarchy",
    "Hierarchy",
    "Hirarchie",
    "Hierarchy",
    "Hierarkia",
    "Hierachia",
    "Hierarchy",
    "Hierarchy",
    "Hierarchy",
    "Ierarhie",
    "Hierarchy",
    "Jerarquia",
    "",
    "Hijerarhija",
    "Hierarhia",
    "Hierarki",
  },
  // Timer parameters:
  { "Active",
    "Aktiv",
    "Aktivno",
    "Attivo",
    "Actief",
    "Activo",
    "Actif",
    "Aktiv",
    "Aktiivinen",
    "Aktywny",
    "Activo",
    "",
    "Aktiv",
    "Activ",
    "Aktiv",
    "Actiu",
    "",
    "Aktivan",
    "Aktiivne",
    "Aktiv",
  },
  { "Channel",
    "Kanal",
    "Kanal",
    "Canale",
    "Kanaal",
    "Canal",
    "Chane",
    "Kanal",
    "Kanava",
    "Kanal",
    "Canal",
    "",
    "Kanal",
    "Canal",
    "Csatorna",
    "Canal",
    "",
    "Program",
    "Kanal",
    "Kanal",
  },
  { "Day",
    "Tag",
    "Dan",
    "Giorno",
    "Dag",
    "Dia",
    "Jour",
    "Dag",
    "Piv",
    "Dzien",
    "Da",
    "",
    "Dag",
    "Ziua",
    "Nap",
    "Dia",
    "",
    "Dan",
    "Pev",
    "Dag",
  },
  { "Start",
    "Anfang",
    "Zacetek",
    "Inizio",
    "Begin",
    "Inicio",
    "Dbut",
    "Start",
    "Aloitus",
    "Poczatek",
    "Comienzo",
    "",
    "Brjar",
    "nceput",
    "Kezdet",
    "Inici",
    "",
    "Poetak",
    "Start",
    "Start",
  },
  { "Stop",
    "Ende",
    "Konec",
    "Fine",
    "Einde",
    "Fim",
    "Fin",
    "Slutt",
    "Lopetus",
    "Koniec",
    "Fin",
    "",
    "Slutar",
    "Sfrit",
    "Vge",
    "Fi",
    "",
    "Kraj",
    "Stopp",
    "Stop",
  },
  { "VPS",
    "VPS",
    "",// TODO
    "VPS",
    "VPS",
    "",// TODO
    "VPS",
    "",// TODO
    "VPS",
    "",// TODO
    "",// TODO
    "",// TODO
    "VPS",
    "VPS",
    "",// TODO
    "",// TODO
    "VPS ",
    "VPS", // hrv
    "VPS",
    "VPS",
  },
  { "Priority",
    "Prioritt",
    "Prioriteta",
    "Priorita'",
    "Prioriteit",
    "Prioridade",
    "Priorit",
    "Prioritet",
    "Prioriteetti",
    "Priorytet",
    "Prioridad",
    "",
    "Prioritet",
    "Prioritate",
    "Priorits",
    "Prioritat",
    "",
    "Prioritet",
    "Prioriteet",
    "Prioritet",
  },
  { "Lifetime",
    "Lebensdauer",
    "Veljavnost",
    "Durata",
    "Bewaarduur",
    "Durao",
    "Dure de vie",
    "Levetid",
    "Elinik",
    "Trwalosc dni",
    "Durabilidad",
    " ",
    "Livstid",
    "Timp de pstrare",
    "lettartam",
    "Durada",
    " ",
    "Trajanje",
    "Eluiga",
    "Levetid",
  },
  { "File",
    "Datei",
    "Datoteka",
    "Nome",
    "Filenaam",
    "Ficheiro",
    "Fichier",
    "Filnavn",
    "Tiedosto",
    "Plik",
    "Fichero",
    "",
    "Filnamn",
    "Fiier",
    "File",
    "Arxiu",
    "",
    "Datoteka",
    "Fail",
    "Fil",
  },
  { "First day",
    "Erster Tag",
    "Prvi dan",
    "Primo giorno",
    "Eerste dag",
    "Primeiro dia",
    "Premier jour",
    "Frste dag",
    "1. piv",
    "Pierwszy dzien",
    "Primer da",
    " ",
    "Frsta dag",
    "Prima zi",
    "Els nap",
    "Primer dia",
    " ",
    "Prvi dan",
    "Esimene pev",
    "Frste dag",
  },
  // Error messages:
  { "Channel is being used by a timer!",
    "Kanal wird von einem Timer benutzt!",
    "Kanal uporablja termin za snemanje!",
    "Canale occupato da un timer!",
    "Kanaal wordt gebruikt door een timer!",
    "Canal a ser utilizador por um timer!",
    "Cette chane est en cours d'utilisation!",
    "Kanalen er i bruk av en timer!",
    "Kanava on ajastimen kytss!",
    "Kanal jest zajety przez timer nagran",
    "Canal est ocupado por un timer!",
    "    !",
    "Kanalen anvnds av en timer!",
    "Canalul este utilizat de un timer!",
    "Csatornt ms hasznlja!",
    "Canal en s per un temporitzador!",
    "  !",
    "Program je trenutno zauzet terminom za snimanje",
    "Kanal on taimeri kasutuses!",
    "Kanal anvendes af en timer!",
  },
  { "Can't switch channel!",
    "Kanal kann nicht umgeschaltet werden!",
    "Ne morem preklopiti kanala!",
    "Impossibile cambiare canale!",
    "Kan geen kanaal wisselen!",
    "No pode mudar de canal!",
    "Impossible de changer de chane!",
    "Ikke mulig  skifte kanal!",
    "Kanavan vaihtaminen ei mahdollista!",
    "Kanal nie moze byc teraz przelaczony!",
    "No puedo cambiar canal!",
    "  !",
    "Omjligt att byta kanal!",
    "Nu pot comuta canalul!",
    "Csatornt nem lehet tkapcsolni!",
    "No puc canviar de canal!",
    "  !",
    "Ne mogu prebaciti program!",
    "Kanali vahetus ei ole vimalik!",
    "Kan ikke skifte kanal!",
  },
  { "Timer is recording!",
    "Timer zeichnet gerade auf!",
    "Snemanje po terminu!",
    "Registrazione di un timer in corso!",
    "Timer is aan het opnemen!",
    "Timer a gravar!",
    "Enregistrement en cours!",
    "Timer gjr opptak!",
    "Ajastintallennus kynniss!",
    "Timer nagrywa!",
    "Timer esta grabando!",
    "  !",
    "Timerstyrd inspelning pgr!",
    "Timer-ul tocmai nregistreaz!",
    "Felvtel folyamatban van!",
    "El temporitzador est gravant!",
    "   !",
    "Snimanje po definiranom terminu!",
    "Taimeri salvestamine!",
    "Timer optager nu!",
  },
  { "Error while accessing recording!",
    "Fehler beim Ansprechen der Aufzeichnung!",
    "Napaka pri dostopu do posnetka!",
    "Errore nell'accesso alla registrazione",
    "Fout bij lezen opname!",
    "Erro ao aceder  gravao",
    "Impossible d'accder  l'enregistrement",
    "Feil under lesing av opptak!",
    "Tallenteen toistaminen eponnistui!",
    "Blad - brak dostepu do nagrania!",
    "Error al acceder a la grabacin!",
    "   !",
    "Inspelningen gr inte att lsa!",
    "Eroare la accesarea nregistrrii",
    "Hiba a felvtel hozzfrsnl",
    "Error a l'accedir a la gravaci!",
    "   !",
    "Greka pri pristupanju snimke!",
    "Salvestuse taasesitus ebannestus!",
    "Fejl ved lsning af optagelse!",
  },
  { "Error while deleting recording!",
    "Fehler beim Lschen der Aufzeichnung!",
    "Napaka pri brisanju posnetka!",
    "Errore nel cancellare la registrazione!",
    "Fout bij verwijderen opname!",
    "Erro enquanto apagava uma gravao!",
    "Erreur de suppression de l'enregistrement!",
    "Feil under sletting av opptak!",
    "Tallenteen poistaminen eponnistui!",
    "Blad przy usuwaniu nagrania!",
    "Error al borrar la grabacin!",
    "     !",
    "Inspelningen gr inte att ta bort!",
    "Eroare la tergerea nregistrrii!",
    "Hiba a felvtel trlsnl!",
    "Error a l'esborrar la gravaci!",
    "  !",
    "Greka pri brisanju snimke!",
    "Salvestuse kustutamine ebannestus!",
    "Fejl ved sletning af optagelse!",
  },
  { "*** Invalid Channel ***",
    "*** Ungltiger Kanal ***",
    "*** Neznan kanal ***",
    "*** CANALE INVALIDO ***",
    "*** Ongeldig kanaal ***",
    "*** Canal Invlido! ***",
    "*** Chane invalide! ***",
    "*** Ugyldig Kanal! ***",
    "*** Virheellinen kanavavalinta! ***",
    "*** Niewazny kanal ***",
    "*** Canal invlido ***",
    "***   ***",
    "*** Felaktig kanal ***",
    "*** Canal invalid ***",
    "*** rvnytelen csatorna ***",
    "*** Canal incorrecte ***",
    "***   ***",
    "*** Neispravan program ***",
    "*** Vigane kanal ***",
    "*** Ugyldig kanal! ***",
  },
  { "No free DVB device to record!",
    "Keine freie DVB-Karte zum Aufnehmen!",
    "Ni proste DVB naprave za snemanje!",
    "Nessuna periferica DVB disponibile per registrare!",
    "Geen vrije DVB kaart om op te nemen!",
    "Nenhuma placa DVB disponivel para gravar!",
    "Pas de carte DVB disponible pour l'enregistrement!",
    "Ingen ledige DVB enheter for opptak!",
    "Ei vapaata vastaanotinta tallennukselle!",
    "Brak wolnej karty DVB do nagrywania!",
    "No hay dispositivo DVB disponible para grabar!",
    " DVB   !",
    "Det finns ingen ledig DVB enhet fr inspelning!",
    "Nu mai sunt dispozitive DVB disponibile pentru nregistrare!",
    "Nincs szabad DVB krtya a felvtelhez!",
    "No hi ha cap dispositiu DVB lliure per gravar!",
    "  DVB-  !",
    "Nema slobodnog DVB ureaja za snimanje!",
    "Puudub vaba DVB seade salvestamiseks!",
    "Ingen fri DVB enhed til optagelse!",
  },
  { "Channel not available!",
    "Kanal nicht verfgbar!",
    "Kanal ni razpolozljiv!",
    "Canale non disponibile!",
    "Kanaal niet beschikbaar",
    "",//TODO
    "Chane non disponible!",
    "",//TODO
    "Kanava ei ole kytettviss!",
    "Kanal jest niedostepny!",
    "!Canal no disponible!",
    "    !",
    "Kanalen ej tillgnglig!",
    "Canal indisponibil",
    "A csatorna nem elrhet",
    "Canal no disponible!",
    " !",
    "Program nije dostupan!",
    "Kanal ei ole kttesaadav!",
    "Kanal er ikke tilgngelig!",
  },
  { "Channel settings are not unique!",
    "Kanaleinstellungen sind nicht eindeutig!",
    "Nastavitve kanala niso edinstvene!",
    "Paramentri Canale non unici!",
    "Kanaalinstellingen zijn niet uniek!",
    "",//TODO
    "Caractristiques des chanes ne sont pas uniques",
    "",//TODO
    "Kanava-asetukset eivt ole yksillliset!",
    "Nastawy kanalu sa niejednoznaczne!",
    "!Propiedades de canal duplicadas!",
    "    !",
    "Kanalinstllningarna r ej unika!",
    "Parametrii canalului nu sunt univoci!",
    "A csatornabelltsok nem egyrtelmek",
    "Propietats del canal duplicades!",
    "   !",
    "Parametri programa nisu jednoznani!",
    "Kanaliseaded ei ole unikaalsed!",
    "Kanalindstillinger er ikke entydige!",
  },
  { "Channel locked (recording)!",
    "Kanal blockiert (zeichnet auf)!",
    "Zaklenjen kanal (snemanje)!",
    "Canale bloccato (in registrazione)!",
    "Kanaal geblokkeerd (neemt op)!",
    "Canal bloqueado (a gravar)!",
    "Chane verrouille (enregistrement en cours)!",
    "Kanalen er lst (opptak)!",
    "Kanava lukittu (tallennus kynniss)!",
    "Kanal zablokowany (nagrywanie w toku)!",
    "Canal bloqueado (grabando)!",
    "    ( )!",
    "Kanalen r lst (inspelning pgr)!",
    "Canal blocat (nregistrare)!",
    "Csatorna hozzfrhetetlen (felvtel)!",
    "Canal bloquejat (gravant)!",
    "  ( )!",
    "Program blokiran (snimanje)!",
    "Kanal lukus (salvestamine aktiivne)!",
    "Kanal blokeret (optagelse i gang)",
  },
  { "Can't start Transfer Mode!",
    "Transfer-Mode kann nicht gestartet werden!",
    "Ne morem zaceti z prenosnim nacinom",
    "Impossibile iniziare la modalita' di trasferimento!",
    "Kan Transfer-Mode niet starten",
    "Impossvel iniciar modo de transferncia!",
    "Impossible d'utiliser le mode transfert!",
    "Kan ikke starte transfer modus!",
    "Siirtotilan aloitus eponnistui!",
    "Tryb transferowy jest niemozliwy!",
    "No puedo iniciar modo de transferencia!",
    "   !",
    "Kan inte starta Transfer Mode!",
    "Nu pot porni modul de transfer!",
    "Transfer-Mode nem indthat!",
    "No puc iniciar el mode de transferncia!",
    "   !", // ???
    "Ne mogu zapoeti 'prijenosni' nain!",
    "Siirdemooduse start ebannestus!",
    "Kan ikke starte Transfer Mode!",
  },
  { "No editing marks defined!",
    "Keine Schnittmarken gesetzt!",
    "Nobena tocka ni definirana!",
    "Nessun marcatore di modifica definito!",
    "Geen bewerkingsmarkeringen gedefinieerd!",
    "",//TODO
    "Pas de marques d'dition dfinies!",
    "",//TODO
    "Muokkausmerkinnt puuttuvat!",
    "Brak znakow montazowych!",
    "",//TODO
    "    ",
    "Det finns inga redigeringsmrken",//TODO
    "Nu s-au pus marcaje de montaj pentru aceast nregistrare",
    "A vgpont nincs kijellve",//TODO
    "No hi ha marques d'edici definides",
    "    !",
    "Nijedna prekidna toka nije postavljena!",
    "Redigeerimise markerid puuduvad!",
    "Der er ikke sat nogen redigeringsmrker!",
  },
  { "Can't start editing process!",
    "Schnitt kann nicht gestartet werden!",
    "Ne morem zaceti urejanja!",
    "Impossibile iniziare processo di modifica!",
    "Kan niet beginnen met bewerken!",
    "No pode iniciar a modificao!",
    "Impossible de commencer le montage!",
    "Kan ikke starte redigeringsprosessen!",
    "Muokkauksen aloitus eponnistui!",
    "Uruchamianie montazu jest niemozliwe!",
    "No puedo iniciar proceso de modificacin!",
    "   !",
    "Kan inte starta redigering!",
    "Nu pot porni montajul nregistrrii!",
    "A vgs nem indthat!",
    "No puc iniciar el procs d'edici!",
    "   !",
    "Ne mogu zapoeti ureivanje!",
    "Redigeerimise start ebannestus!",
    "Kan ikke starte redigeringsprocessen!",
  },
  { "Editing process already active!",
    "Schnitt bereits aktiv!",
    "Urejanje je ze aktivno!",
    "Processo di modifica gia` attivo!",
    "Bewerken is al actief!",
    "Processo de modificao j activo!",
    "Montage dj en cours!",
    "Redigeringsprosessen er allerede aktiv!",
    "Muokkaus on jo kynniss!",
    "Montaz w toku!",
    "Proceso de modificacin ya fue iniciado!",
    "   !",
    "Redigeringen r redan aktiv!",
    "Montajul nregistrrii este deja activ!",
    "A vgs mr aktivlt!",
    "Procs d'edici iniciat anteriorment!",
    "   !",
    "Ureivanje je ve aktivirano!",
    "Redigeerimine on juba aktiivne!",
    "Redigeringsproces er allerede aktiv!",
  },
  { "Can't shutdown - option '-s' not given!",
    "Shutdown unmglich - Option '-s' fehlt!",
    "Zaustavitev ni izvedljiva - opcija '-s' ni podana!",
    "Impossibile spegnere - parametro '-s' non passato!",
    "Shutdown onmogelijk - Optie '-s' ontbreekt!",
    "Impossvel desligar - falta a opo '-s'!",
    "Arrt impossible - option '-s' absente!",
    "Kan ikke sl av - startet uten parameteret '-s'!",
    "Sammutus ei onnistu - '-s' parametri puuttuu!",
    "Wylaczenie niemozliwe - brak opcji '-s'!",
    "No puedo apagar - opcin '-s' ausente!",
    "   .    '-s'!",
    "Kan inte avsluta, mste anvnda parameter '-s'",
    "Nu pot nchide - vezi opiunea '-s'",
    "A lellts nem lehetsges - Opci '-s' hinyzik!",
    "No puc apagar, falta la opci -s !",
    "  -    '-s'!",
    "Gaenje nemogue - nedostaje opcija '-s'!",
    "Vljallitamine ebannestus - '-s' parameeter puudub!",
    "Kan ikke slukke - parameter '-s' ikke angivet!",
  },
  { "Low disk space!",
    "Platte beinahe voll!",
    "Zmanjkuje prostora na disku",
    "Poco spazio su disco!",
    "Disk bijna vol!",
    "Espao em disco reduzido!",
    "Disque presque plein!",
    "Lite ledig diskplass!",
    "Kovalevy lhes tynn!",
    "Dysk wkrotce pelny!",
    "Disco casi lleno",
    "    !",
    "Lgt diskutrymme!",
    "Spaiul pe disc e foarte sczut!",
    "A merev lemez majdnem tele!",
    "Disc gaireb ple!",
    "   !",
    "Nedovoljno prostora na disku",
    "Kvaketas peaaegu tis!",
    "Kun lidt diskplads tilbage!",
  },
  { "Can't open CAM menu!",
    "CAM-Men kann nicht geffnet werden!",
    "Ne morem odpreti CAM menija!",
    "Impossibile aprire il menu CAM!",
    "Kan CAM-menu niet openen!",
    "",//TODO
    "Impossible d'ouvrir le menu CAM!",
    "",//TODO
    "Salausmoduulin valikko ei saatavilla",
    "CAM-Menu niedostepne!",
    "No pudeo acceder al men de la CAM!",
    "    CAM !",
    "Det gr inte att ppna CAM menyn!",
    "Nu pot deschide meniul CAM",
    "A CAM-Men nem nyithat",
    "No puc obrir el men de la CAM!",
    " CAM- !",
    "Ne mogu otvoriti CAM izbor!",
    "Ei saa avada CAM mend!",
    "Kan ikke bne CAM menuen!",
  },
  { "Can't reset CAM!",
    "CAM-Reset fehlgeschlagen!",
    "Ne morem resetirati CAM-a",
    "Impossibile reimpostare il modulo CAM!",
    "Kan CAM niet herstarten!",
    "",//TODO
    "Impossible de rinitialiser la CAM!",
    "",//TODO
    "Salausmoduulin alustus eponnistui!",
    "Nieudany CAM-Reset!",
    "No puedo reiniciar la CAM!",
    "     CAM",
    "Kan inte terstlla CAM!",
    "Nu pot reseta CAM",
    "A CAM-Reset nem sikerlt",
    "No puc reiniciar la CAM!",
    "  CAM-!",
    "Ne mogu resetirati CAM",
    "CAM mooduli taaskivitus ebannestus!",
    "Kan ikke nulstille CAM!",
  },
  { "CAM has been reset",
    "CAM wurde zurckgesetzt!",
    "CAM je resetiran!",
    "Modulo CAM reimpostato!",
    "CAM is herstart!",
    "",//TODO
    "La CAM a t rinitialise",
    "",//TODO
    "Salausmoduuli alustettu",
    "CAM-Reset wykonany!",
    "CAM reiniciada",
    " CAM  ",
    "CA modulen har terstllts",
    "CAM-ul a fost resetat",
    "A CAM vissza lett lltva",
    "CAM reiniciada",
    "CAM- !",
    "CAM je resetiran!",
    "CAM mooduli taaskivitus tehtud",
    "CAM er blevet nulstillet",
  },
  { "No audio available!",
    "Kein Audio verfgbar!",
    "",//TODO
    "",//TODO
    "Geen audio beschikbaar!",
    "",//TODO
    "",//TODO
    "Pas d'audio disponible!",
    "nen kieli ei ole valittavissa!",
    "",//TODO
    "",//TODO
    "",//TODO
    "Ljud saknas!"
    "",//TODO
    "",//TODO
    "",//TODO
    " !",
    "",//TODO
    "Audio kttesaamatu!",
    "Ingen lyd tilgngelig!",
  },
  // Setup pages:
  { "OSD",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "Affichage des menus",
    "OSD",
    "Kuvaruutunytt",
    "OSD",
    "Mens en pantalla",
    "OSD",
    "OSD",
    "OSD",
    "OSD",
    "Informaci en pantalla",
    "",
    "OSD",
    "Ekraanimen",
    "OSD",
  },
  { "EPG",
    "EPG",
    "Programski vodnik",
    "Guida programmi EPG",
    "EPG",
    "EPG",
    "Guide des programmes",
    "Programoversikt",
    "Ohjelmaopas",
    "EPG",
    "Gua de Programacin",
    " ",
    "Elektronisk programguide",
    "EPG",
    "EPG",
    "Guia de Programes",
    "",
    "Pregled emisija (EPG)",
    "EPG",
    "EPG",
  },
  { "DVB",
    "DVB",
    "DVB",
    "Scheda DVB",
    "DVB",
    "DVB",
    "Cartes DVB",
    "DVB-enheter",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
    "Dispozitiv DVB",
    "DVB",
    "Tarja DVB",
    "DVB",
    "DVB",
    "DVB",
    "DVB",
  },
  { "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "LNB",
    "Configuraci de l'LNB",
    "",
    "LNB",
    "LNB",
    "LNB",
  },
  { "CICAM",
    "CICAM",
    "CICAM",
    "Accesso condizionato CICAM",
    "CICAM",
    "CICAM",
    "Accs conditionnel",
    "CICAM",
    "CI-moduuli",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CICAM",
    "CI Accs condicional",
    " ",
    "CICAM",
    "CICAM",
    "CICAM",
  },
  { "Recording",
    "Aufnahme",
    "Snemanje",
    "Registrazione",
    "Opname",
    "A gravar",
    "Enregistrement",
    "Opptak",
    "Tallennus",
    "Nagranie",
    "Opciones de Grabacin",
    "",
    "Inspelning",
    "nregistrare",
    "Felvtel",
    "Opcions de Gravaci",
    "",
    "Snimanje",
    "Salvestamine",
    "Optagelse",
  },
  { "Replay",
    "Wiedergabe",
    "Predvajanje",
    "Replay",
    "Afspelen",
    "Replay",
    "Lecture",
    "Spill av",
    "Toisto",
    "Odtwarzanie",
    "Opciones de Reproduccin",
    "",
    "Uppspelning",
    "Redare",
    "Lejtszs",
    "Opcions de Reproducci",
    "",
    "Reprodukcija",
    "Taasesitus",
    "Afspilning",
  },
  { "Miscellaneous",
    "Sonstiges",
    "Ostalo",
    "Generici",
    "Overig",
    "Outros",
    "Divers",
    "Forskjellig",
    "Sekalaiset",
    "Pozostale",
    "Varios",
    "",
    "Diverse",
    "Diverse",
    "Egyb",
    "Miscellnia",
    "",
    "Ostalo",
    "Muud stted",
    "Diverse",
  },
  { "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Plugins",
    "Laajennokset",
    "Plugins",
    "Plugins",
    "",
    "Moduler",
    "Plugin-uri",
    "Plugins",
    "Plugins",
    " ",
    "Dodaci (Plugins)",
    "Laiendusmoodulid",
    "Plugins",
  },
  { "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Plugin",
    "Laajennos",
    "Plugin",
    "Plugin",
    "",
    "Modul",
    "Plugin (modul adiional)",
    "Plugin",
    "Plugin",
    "",
    "Plugin",
    "Laiendusmoodul",
    "Plugin",
  },
  { "Restart",
    "Neustart",
    "Ponoven zagon",
    "Riavvio",
    "Herstart",
    "Reiniciar",
    "Redmarrer",
    "Start p nytt",
    "Kynnist uudelleen",
    "Zastartowac",
    "Reiniciar",
    "",
    "Omstart",
    "Repornire",
    "jraindts",
    "Reiniciar",
    "",
    "Restart sistema",
    "Restart",
    "Genstart",
  },
  // Setup parameters:
  { "Setup.OSD$Language",
    "Sprache",
    "Jezik",
    "Linguaggio",
    "Taal",
    "Linguagem",
    "Langue",
    "Sprk",
    "Kieli",
    "Jezyk",
    "Idioma",
    "",
    "Sprk",
    "Limba OSD",
    "Nyelv",
    "Idioma",
    "",
    "Jezik",
    "Keel",
    "Sprog",
  },
  { "Setup.OSD$Skin",
    "Oberflche",
    "",// TODO
    "Superficie Skin",
    "Skin",
    "",// TODO
    "Skin",
    "",// TODO
    "Ulkoasu",
    "",// TODO
    "",// TODO
    "",// TODO
    "Skin",
    "Skin",
    "",// TODO
    "",// TODO
    "",
    "Povrina",
    "Kest",
    "Skin",
  },
  { "Setup.OSD$Theme",
    "Thema",
    "",// TODO
    "Tema",
    "Thema",
    "",// TODO
    "Thme",
    "",// TODO
    "Teema",
    "",// TODO
    "",// TODO
    "",// TODO
    "Tema",
    "Tem",
    "",// TODO
    "",// TODO
    "",
    "Tema",
    "Teema",
    "Tema",
  },
  { "Setup.OSD$Left",
    "Links",
    "",// TODO
    "Sinistra",
    "Links",
    "",// TODO
    "Gauche",
    "",// TODO
    "Vaakakeskitys",
    "",// TODO
    "",// TODO
    "",// TODO
    "Vnster",
    "Stnga",
    "",// TODO
    "",// TODO
    " ",
    "Lijevo",
    "Vasakule",
    "Venstre",
  },
  { "Setup.OSD$Top",
    "Oben",
    "",// TODO
    "Cima",
    "Boven",
    "",// TODO
    "Haut",
    "",// TODO
    "Pystykeskitys",
    "",// TODO
    "",// TODO
    "",// TODO
    "vre",
    "Sus",
    "",// TODO
    "",// TODO
    " ",
    "Gore",
    "lesse",
    "Top",
  },
  { "Setup.OSD$Width",
    "Breite",
    "Sirina",
    "Larghezza OSD",
    "Breedte",
    "Largura",
    "Largeur",
    "Bredde",
    "Leveys",
    "Szerokosc",
    "Anchura",
    "",
    "Bredd",
    "Lime OSD",
    "Szlessg",
    "Amplada",
    "",
    "irina",
    "Laius",
    "Bredde",
  },
  { "Setup.OSD$Height",
    "Hhe",
    "Visina",
    "Altezza OSD",
    "Hoogte",
    "Altura",
    "Hauteur",
    "Hyde",
    "Korkeus",
    "Wysokosc",
    "Altura",
    "",
    "Hjd",
    "nlime OSD",
    "Magassg",
    "Alada",
    "",
    "Visina",
    "Krgus",
    "Hjde",
  },
  { "Setup.OSD$Message time (s)",
    "Anzeigedauer fr Nachrichten (s)",
    "Cas sporocila (s)",
    "Tempo del messaggio (s)",
    "Weergave duur van berichten (s)",
    "Mostrar contador (s)",
    "Dure affichage message (s)",
    "Tid meldinger skal vises (s)",
    "Viestien esitysaika (s)",
    "Czas wyswietlania wiadomosci (s)",
    "Duracin muestra mensajes (s)",
    "   ()",
    "Tid fr meddelanden (sek)",
    "Timp afiare mesaje (sec)",
    "Informci feltntetsnek idtartama",
    "Durada dels missatges (s)",
    "   ()",
    "Vrijeme prikaza poruka (s)",
    "Teate esitusaeg (s)",
    "Tid beskeder skal vises (s)",
  },
  { "Setup.OSD$Use small font",
    "Kleine Schrift benutzen",
    "",// TODO
    "Utilizzare caratteri piccoli",
    "Klein lettertype gebruiken",
    "",// TODO
    "Utiliser les petits caractres",
    "",// TODO
    "Kyt pieni kirjasimia",
    "",// TODO
    "",// TODO
    "",// TODO
    "Anvnd liten font",
    "Utilizare fonturi mici",
    "",// TODO
    "",// TODO
    "  ",
    "Koristi mala slova",
    "Vikese fondi kasutamine",
    "Anvend lille skrift",
  },
  { "never",
    "nie",
    "",// TODO
    "mai",
    "nooit",
    "",// TODO
    "jamais",
    "",// TODO
    "ei koskaan",
    "",// TODO
    "",// TODO
    "",// TODO
    "aldrig",
    "niciodat",
    "",// TODO
    "",// TODO
    "",
    "nikada",
    "mitte kunagi",
    "aldrig",
  },
  { "skin dependent",
    "je nach Oberflche",
    "",// TODO
    "in base alla superficie",
    "skin afhankelijk",
    "",// TODO
    "Dpend du skin",
    "",// TODO
    "ulkoasun mukaan",
    "",// TODO
    "",// TODO
    "",// TODO
    "skin beroende",
    "dep. de skin",
    "",// TODO
    "",// TODO
    " ",
    "ovisno o povrini",
    "kestast sltuv",
    "skin afhngig",
  },
  { "always",
    "immer",
    "",// TODO
    "sempre",
    "altijd",
    "",// TODO
    "toujours",
    "",// TODO
    "aina",
    "",// TODO
    "",// TODO
    "",// TODO
    "alltid",
    "ntotdeauna",
    "",// TODO
    "",// TODO
    "",
    "uvijek",
    "alati",
    "altid",
  },
  { "Setup.OSD$Channel info position",
    "Kanal-Info Position",
    "Pozicija informacije o kanalu",
    "Posizione informazioni canale",
    "Kanaal info positie",
    "Posio de info dos canais",
    "Position infos chanes",
    "Posisjon p kanalinformasjon",
    "Kanavatiedon sijainti",
    "Lokalizacja informacji o kanale",
    "Posicin para informacin canal",
    "  ",
    "Placering av kanalinformation",
    "Poziia informaiilor despre canal",
    "Csatorna-Inf pozicija",
    "Posici de la informaci del canal",
    "    ",
    "Pozicija informacije o programu",
    "Kanaliinfo asukoht",
    "Placering af kanalinfo",
  },
  { "Setup.OSD$Channel info time (s)",
    "Anzeigedauer fr Kanal-Info (s)",
    "",// TODO
    "",// TODO
    "Duur tonen kanaal-informatie (s)",
    "",// TODO
    "Dure affichage infos chanes (s)",
    "",// TODO
    "Kanavatiedon esitysaika (s)",
    "",// TODO
    "",// TODO
    "",// TODO
    "Kanal information (s)",
    "",// TODO
    "",// TODO
    "",// TODO
    "    ()",
    "",// TODO
    "Kanaliteate esitusaeg (s)",
    "Tid kanalinfo skal vises (s)",
  },
  { "Setup.OSD$Info on channel switch",
    "Info beim Kanalwechsel",
    "Pokazi naziv kanala",
    "Mostra info al cambio canale",
    "Kanaal info tonen",
    "Mostrar info ao mudar de Canal",
    "Affichage progr. en cours",
    "Info ved kanalskifte",
    "Nyt kanavatieto",
    "Informacja przy zmianie kanalu",
    "Informacin para cambio de canal",
    "   ",
    "Information vid kanalbyte",
    "Informaii la comutarea canalului",
    "Inf a csatorna vltsnl",
    "Informaci del canvi de canal",
    "   ",
    "Informacije kod promjene kanala",
    "Kanaliteate nitamine",
    "Info ved kanalskift",
  },
  { "Setup.OSD$Scroll pages",
    "Seitenweise scrollen",
    "Drsni meni",
    "Scorri pagina nel menu",
    "Scrollen per pagina",
    "Scroll da pgina no menu",
    "Scrolling par pages",
    "Rask rulling i menyer",
    "Valikkosivujen pikaselaus",
    "Przesuwac stronami",
    "Desplazar pgina entera",
    " ",
    "Blddra sidor",
    "Deruleaz pagini",
    "Oldalanknt lptetmi",
    "Desplaar pgina sencera",
    "  ",
    "Listaj po stranicama",
    "Leheklje kerimine",
    "Rul sider",
  },
  { "Setup.OSD$Scroll wraps",
    "Rundum scrollen",
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
  },
  { "Setup.OSD$Sort timers",
    "Timer sortieren",
    "Sortiraj termine",
    "Ordinamento timer",
    "Timers sorteren",
    "Ordenar os timers",
    "Trier les programmations",
    "Sorter timere",
    "Jrjest ajastimet",
    "Sortowanie timerow",
    "Ordenar timers",
    " ",
    "Sortera timers",
    "Sortare timer-e",
    "A beprogramozott felvtelek elrendezse",
    "Ordenar gravacions programades",
    " ",
    "Sortiraj termine",
    "Taimeri sorteerimine",
    "Sorter timere",
  },
  { "Setup.OSD$Recording directories",
    "Aufnahmeverzeichnisse",
    "Direktoriji za posnetke",
    "Directory di registrazione",
    "Opname directories",
    "Directorias de gravao",
    "Dossiers d'enregistrements",
    "Kataloger til opptak",
    "Tallennehakemistot",
    "Wykaz nagran",
    "Gracaciones en directorios",
    " ",
    "Kataloger fr inspelningar",
    "Directoare nregistrri",
    "Felvtelek listja",
    "Gravacions en subcarpetes",
    "  ",
    "Imenik za snimke",
    "Kausta nime salvestamine",
    "Optagelser i foldere",
  },
  { "Setup.EPG$EPG scan timeout (h)",
    "Zeit bis EPG Scan (h)",
    "Cas do EPG pregleda (h)",
    "Timeout scansione aggiornamento EPG (ore)",
    "EPG-scan Timeout (h)",
    "Expirou o EPG (h)",
    "Inactivit avant rech. EPG (h)",
    "Ledig tid fr EPG-sk (h)",
    "Ohjelmaoppaan taustapivitys (h)",
    "Czas do skanu EPG (h)",
    "Tiempo hasta exploracin EPG (h)",
    "   EPG  ",
    "EPG skning timeout",
    "Interval achiziie EPG (h)",
    "Fennmaradt id az EPG-g (h)",
    "Mxim d'Hores a cercar per la Guia",
    "   ()",
    "Vrijeme do EPG pregleda (h)",
    "EPG skaneerimise viide (h)",
    "Tid fr EPG skanning (t)",
  },
  { "Setup.EPG$EPG bugfix level",
    "EPG Fehlerbereinigung",
    "Nivo za popravilo EPG napak",
    "Livello correzione EPG",
    "EPG foutcorrectieniveau",
    "Nvel de correcto EPG",
    "Niveau de correction EPG",
    "Niv for EPG-feilretting",
    "Ohjelmaoppaan korjaustaso",
    "Poziom bledow EPG",
    "Nivel para arreglar EPG",
    "   EPG",
    "Niv fr EPG bugfix",
    "Nivel corecie EPG",
    "EPG hibaelhrts",
    "Nivell de correcci de la Guia",
    "  ",
    "Nivo popravka EPG greaka",
    "EPG veaparanduse tase",
    "Niveau for EPG fejlrettelse",
  },
  { "Setup.EPG$EPG linger time (min)",
    "Alte EPG-Daten anzeigen (min)",// TODO
    "",// TODO
    "Visualizzazione dati vecchi (min)",
    "Oude EPG data tonen (min)",
    "",// TODO
    "Montrer l'EPG plus vieux de m min",
    "",// TODO
    "Vanha tieto nkyy (min)",
    "",// TODO
    "",// TODO
    "",// TODO
    "Visa gammal info (min)",
    "Date EPG expirate cel mult (min)",
    "",// TODO
    "",// TODO
    "   ()",
    "Prikai stare EPG podatke (min)",
    "Vana EPG viide (min)",
    "Vise gammel EPG info (min)",
  },
  { "Setup.EPG$Set system time",
    "Systemzeit stellen",
    "Nastavi sistemski cas",
    "Settaggio orario automatico",
    "Systeem klok instellen",
    "Ajustar relgio do sistema",
    "Ajuster l'heure du systme",
    "Juster system-klokken",
    "Aseta kellonaika",
    "Ustawianie czasu",
    "Ajustar reloj de sistema",
    "  ",
    "Stll in systemtid",
    "Potrivete ceasul sistem",
    "Az id belltsa",
    "Ajustar l'hora del sistema",
    "  ",
    "Podesi vrijeme sistema",
    "Kella snkroniseerimine",
    "Indstil system tid",
  },
  { "Setup.EPG$Use time from transponder",
    "Transponder fr Systemzeit",
    "Transponder za nastavitev casa",
    "Utilizza orario da transponder",
    "Gebruik transponder tijd voor systeem",
    "Usar relgio do transponder",
    "Utiliser l'heure de la chane",
    "Bruk klokke fra transponder",
    "Vastaanota kellonaika transponderilta",
    "Transponder do ustawiania czasu",
    "Transponder para reloj de sistema",
    "  ",
    "Anvnd klockan frn transponder",
    "Preia ora din transponder",
    "Idhz tartoz Transponder",
    "Usar el temps del mltiplex",
    "  ",
    "Transponder za podeavanje sata",
    "Kella snkroniseerimise transponder",
    "Anvend tid fra transponder",
  },
  { "Setup.EPG$Preferred languages", // note the plural
    "Bevorzugte Sprachen",
    "",// TODO
    "Lingue preferite",
    "Voorkeurstalen",
    "",// TODO
    "Langues prfres",
    "",// TODO
    "Suosikkikielet",
    "",// TODO
    "",// TODO
    "",// TODO
    "nskade sprk",
    "Limbi preferate",
    "",// TODO
    "",// TODO
    "  ()",
    "Preferirani jezici",
    "Eelistatuid keeli",
    "Foretrukne sprog",
  },
  { "Setup.EPG$Preferred language", // note the singular
    "Bevorzugte Sprache",
    "",// TODO
    "Lingua preferita",
    "Voorkeurstaal",
    "",// TODO
    "Langue prfre",
    "",// TODO
    "Suosikkikieli",
    "",// TODO
    "",// TODO
    "",// TODO
    "nskat sprk",
    "Limba preferat",
    "",// TODO
    "",// TODO
    "",
    "Preferirani jezik",
    "Eelistatud keel",
    "Foretrukket sprog",
  },
  { "Setup.DVB$Primary DVB interface",
    "Primres DVB Interface",
    "Primarna naprava",
    "Scheda DVB primaria",
    "Eerste DVB kaart",
    "Interface DVB primrio",
    "Carte DVB primaire",
    "Hoved DVB-enhet",
    "Pvastaanotin",
    "Pierwotny interfejs DVB",
    "Primer interface DVB",
    " DVB ",
    "Primr DVB enhet",
    "Dispozitiv DVB primar",
    "Els DVB interface",
    "Tarja DVB primria",
    " DVB-",
    "Primarni DVB ureaj",
    "Esmane DVB seade",
    "Primr DVB enhed",
  },
  { "Setup.DVB$Video display format",
    "Video Anzeige-Format",
    "",//TODO
    "",//TODO
    "Video display format",
    "",//TODO
    "",//TODO
    "",//TODO
    "Nyttmuoto",
    "",//TODO
    "",//TODO
    "",//TODO
    "Format fr Video display",
    "",//TODO
    "",//TODO
    "",//TODO
    " ",
    "",//TODO
    "Video kuvamise formaat",
    "Video display format",
  },
  { "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "pan&scan",
    "",
    "pan&scan",
    "pan&scan",
    "pan&scan",
  },
  { "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "letterbox",
    "",
    "letterbox",
    "letterbox",
    "letterbox",
  },
  { "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    "center cut out",
    " ",
    "center cut out",
    "center cut out",
    "center cut out",
  },
  { "Setup.DVB$Video format",
    "Video Format",
    "Video format",
    "Formato video",
    "Videoformaat",
    "Formato vdeo",
    "Format vido",
    "TV-Format",
    "Kuvasuhde",
    "Format telewizyjny",
    "Formato Vdeo",
    " ",
    "Video format",
    "Format video",
    "Video formtum",
    "Format del vdeo",
    " ",
    "Video format",
    "TV klgsuhe",
    "Video format",
  },
  { "Setup.DVB$Use Dolby Digital",
    "Dolby Digital Ton benutzen",
    "",//TODO
    "",//TODO
    "Dolby Digital gebruiken",
    "",//TODO
    "Utiliser le Dolby Digital",
    "",//TODO
    "Kyt Dolby Digital -nt",
    "",//TODO
    "",//TODO
    "",//TODO
    "Anvnd Dolby Digital",
    "",//TODO
    "",//TODO
    "",//TODO
    " Dolby Digital",
    "",//TODO
    "Dolby Digital kasutamine",
    "Anvend Dolby Digital",
  },
  { "Setup.DVB$Update channels",
    "Kanle aktualisieren",
    "",// TODO
    "Aggiornare i canali",
    "Kanalen actualiseren",
    "",// TODO
    "Mettre  jour les chanes",
    "",// TODO
    "Pivit kanavat",
    "",// TODO
    "",// TODO
    "",// TODO
    "Uppdatera kanaler",
    "Actualizare canale",
    "",// TODO
    "",// TODO
    "  ",
    "Aktualiziraj programe",
    "Kanalite uuendamine",
    "Opdatr kanaler",
  },
  { "names only",
    "nur Namen",
    "",// TODO
    "solo nomi",
    "alleen namen",
    "",// TODO
    "Seulement les noms",
    "",// TODO
    "vain nimet",
    "",// TODO
    "",// TODO
    "",// TODO
    "bara namn",
    "doar numele",
    "",// TODO
    "",// TODO
    " ",
    "samo imena",
    "ainult nimed",
    "kun navne",
  },
  { "names and PIDs",
    "Namen und PIDs",
    "",// TODO
    "nomi e PIDs",
    "namen en PIDs",
    "",// TODO
    "Noms et PIDs",
    "",// TODO
    "nimet ja PID:it",
    "",// TODO
    "",// TODO
    "",// TODO
    "namn och PIDdar",
    "nume si PID-uri",
    "",// TODO
    "",// TODO
    "  PID",
    "imena i identifikatore (PIDs)",
    "nimed ja PID-id",
    "navne og PIDs",
  },
  { "add new channels",
    "neue Kanle hinzufgen",
    "",// TODO
    "aggiungere canali nuovi",
    "nieuwe kanalen toevoegen",
    "",// TODO
    "Ajouter les nouvelles chanes",
    "",// TODO
    "lis uudet kanavat",
    "",// TODO
    "",// TODO
    "",// TODO
    "lgg till nya kanaler",
    "adugare canale noi",
    "",// TODO
    "",// TODO
    " ",
    "dodaj nove programe",
    "lisa uued kanalid",
    "tilf. ny kanaler",
  },
  { "add new transponders",
    "neue Transponder hinzufgen",
    "",// TODO
    "aggiungere transponder nuovi",
    "nieuwe transponders toevoegen",
    "",// TODO
    "Ajouter les nouveaux transpondeurs",
    "",// TODO
    "lis uudet transponderit",
    "",// TODO
    "",// TODO
    "",// TODO
    "lgg till nya transponders",
    "adugare transpondere noi",
    "",// TODO
    "",// TODO
    ". ",
    "dodaj nove transpondere", // hrv TODO transponderi == odasiljai?
    "lisa uued transponderid",
    "tilf. ny transp.",
  },
  { "Setup.DVB$Audio languages",  // note the plural
    "",//TODO
    "",//TODO
    "",//TODO
    "Audio talen",
    "",//TODO
    "",//TODO
    "",//TODO
    "nen kielet",
    "",//TODO
    "",//TODO
    "",//TODO
    "Antal ljudsprk",
    "",//TODO
    "",//TODO
    "",//TODO
    "  ()",
    "",//TODO
    "Audio keeled",
    "Audio sprog (ant.)",
  },
  { "Setup.DVB$Audio language",  // note the singular
    "",//TODO
    "",//TODO
    "",//TODO
    "Audio taal",
    "",//TODO
    "",//TODO
    "",//TODO
    "nen kieli",
    "",//TODO
    "",//TODO
    "",//TODO
    "Ljudsprk",
    "",//TODO
    "",//TODO
    "",//TODO
    "",
    "",//TODO
    "Audio keel",
    "Audio sprog",
  },
  { "Setup.LNB$SLOF (MHz)",
    "SLOF (MHz)",
    "Frekvenca preklopa (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "Limite de bandas LNB (MHz)",
    "Limite de bandes LNB (MHz)",
    "LO-grensefrekvens (MHz)",
    "LNB rajataajuus (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "Frecven comutare band, SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
    "  (SLOF) ()",
    "Frekv. preklopa SLOF (MHz)",
    "SLOF (MHz)",
    "SLOF (MHz)",
  },
  { "Setup.LNB$Low LNB frequency (MHz)",
    "Untere LNB-Frequenz (MHz)",
    "Spodnja LNB-frek. (MHz)",
    "Freq LO LNB (MHz)",
    "Laagste LNB frequentie (MHz)",
    "Frequncia base LNB (MHz)",
    "Frquence basse LNB (MHz)",
    "LO-frekvens i lavbndet (MHz)",
    "LNB alempi taajuus (MHz)",
    "Dolna czestotliwosc LNB (MHz)",
    "Frecuencia baja LNB (MHz)",
    " LNB- (MHz)",
    "Undre LNB frekvens (MHz)",
    "Frecvn LNB inferioar (Mhz)",
    "Als LNB-frekvencia (MHZ)",
    "Freqncia LNB baixa (MHz)",
    "   ()",
    "Donja LNB frekv. (MHz)",
    "Alumine (LO) LNB sagedus (MHz)",
    "Nedre LNB frekvens (MHz)",
  },
  { "Setup.LNB$High LNB frequency (MHz)",
    "Obere LNB-Frequenz (MHz)",
    "Zgornja LNB-frek. (MHz)",
    "Freq HI LNB (MHz)",
    "Hoogste LNB frequentie (MHz)",
    "Frequncia alta LNB (MHz)",
    "Frquence haute LNB (MHz)",
    "LO-frekvens i hybndet (MHz)",
    "LNB ylempi taajuus (MHz)",
    "Gorna czestotliwosc LNB (MHz)",
    "Frecuencia alta LNB (MHz)",
    " LNB- (MHz)",
    "vre LNB frekvens (MHz)",
    "Frecvn LNB superioar (MHz)",
    "Fels LNB-frekvencia (MHZ)",
    "Freqncia LNB alta (MHz)",
    "   ()",
    "Gornja LNB frekv. (MHz)",
    "lemine (HI) LNB sagedus (MHz)",
    "vre LNB frekvens (MHz)",
  },
  { "Setup.LNB$Use DiSEqC",
    "DiSEqC benutzen",
    "Uporabi DiSEqC",
    "Utilizza DiSEqC",
    "DiSEqC gebruiken",
    "Utilizar DiSEqC",
    "Utiliser le DiSEqC",
    "Bruk DiSEqC",
    "DiSEqC kytss",
    "Uzywac DiSEqC",
    "Utilizar DiSEqC",
    " DiSEqC",
    "Anvnd DiSEqC",
    "Utilizare DiSEqC",
    "DiSEqC hasznlata",
    "Utilitzar DiSEqC",
    " DiSEqC",
    "Koristi DiSEqC",
    "DiSEqC kasutamine",
    "Anvend DiSEqC",
  },
  { "Setup.CICAM$CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "Accs conditionnel",
    "CICAM DVB",
    "CI-moduuli DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
    "Accs condicional CICAM",
    "CAM- DVB",
    "CICAM DVB",
    "CICAM DVB",
    "CICAM DVB",
  },
  { "Setup.Recording$Margin at start (min)",
    "Zeitpuffer bei Anfang (min)",
    "Premor pred zacetkom (min)",
    "Margine iniziale (min)",
    "Tijd marge begin (min)",
    "Margem inicial (min)",
    "Marge antrieure (min)",
    "Opptaksmargin start (min)",
    "Aloitusmarginaali (min)",
    "Poczatkowy czas buforowy (min)",
    "Comenzar grabacin antes (min)",
    "    ()",
    "Marginal fr start (min)",
    "Marj la pornire (min)",
    "Ideltolds a kezdsnl (min)",
    "Marge d'inici de gravaci (min)",
    "   ()",
    "Rezerva na poetku snimanja (min)",
    "Salvestamise algusvaru (min)",
    "Margin ved start (min)",
  },
  { "Setup.Recording$Margin at stop (min)",
    "Zeitpuffer bei Ende (min)",
    "Premor za koncem (min)",
    "Margine finale (min)",
    "Tijd marge eind (min)",
    "Margem final (min)",
    "Marge postrieure (min)",
    "Opptaksmargin slutt (min)",
    "Lopetusmarginaali (min)",
    "Koncowy czas buforowy (min)",
    "Cortar grabacin despus (min)",
    "    ()",
    "Marginal fr stopp (min)",
    "Marj la oprire (min)",
    "Ideltolds a befejezsnl",
    "Marge de fi de gravaci (min)",
    "   ()",
    "Rezerva na kraju (min)",
    "Salvestamise lpuvaru (min)",
    "Margin ved stop (min)",
  },
  { "Setup.Recording$Primary limit",
    "Primr-Limit",
    "Osnovna meja",
    "Limite primario",
    "Eerste grens",
    "Limite Primrio",
    "Limite primaire",
    "Prioritetsgrense HovedDVB",
    "Pvastaanottimen prioriteetti",
    "Pierwotny limit",
    "Lmite primario",
    " ",
    "Primr grns",
    "Limit primar",
    "Primr-hatr",
    "Lmit primari",
    ".   . ",
    "Standardno ogranienje",
    "Esmase seadme prioriteet",
    "Primr grnse",
  },
  { "Setup.Recording$Default priority",
    "Default Prioritt",
    "Osnovna prioriteta",
    "Priorita' predefinita",
    "Standaard prioriteit",
    "Prioridade por defeito",
    "Priorit par dfaut",
    "Normal prioritet (Timer)",
    "Tallenteen oletusprioriteetti",
    "Priorytet pierwotny",
    "Prioridad predefinida",
    "",
    "Normal prioritet",
    "Prioritate implicit",
    "Default priority",
    "Prioritat per defecte",
    "   ",
    "Standardni prioritet",
    "Vaikimisi prioriteet",
    "Standard prioritet",
  },
  { "Setup.Recording$Default lifetime (d)",
    "Default Lebensdauer (d)",
    "Osnovni zivljenski cas (d)",
    "Durata predefinita (gg)",
    "Standaard levensduur (d)",
    "Validade por defeito (d)",
    "Dure de vie par dfaut (j)",
    "Normal levetid timer (d)",
    "Tallenteen oletuselinik (d)",
    "Pierwotna trwalosc (d)",
    "Duracin predefinida",
    "   ()",
    "Normal livstid (dagar)",
    "Timp de pstrare predefinit (zile)",
    "Default lettartam",
    "Durada predefinida",
    "     ()",
    "Standardno trajanje (d)",
    "Salvestuse eluiga (pevi)",
    "Standard levetid (d)",
  },
  { "Setup.Recording$Pause priority",
    "Pause Prioritt",
    "Prioriteta pavze",
    "Priorita' di pausa",
    "Pauze prioriteit",
    "",// TODO
    "Priorit des pauses",
    "",// TODO
    "Taukotallenteen prioriteetti",
    "Priorytet przerwy",
    "",// TODO
    " ",
    "Prioritet fr direktinspelning",
    "Prioritate pauz",
    "Sznet priorits",
    "Prioritat de la pausa",
    "  ",
    "Prioritet pauze",
    "Pausi prioriteet",
    "Pause prioritet",
  },
  { "Setup.Recording$Pause lifetime (d)",
    "Pause Lebensdauer (d)",
    "Cas pavze (d)",
    "Durata pausa (gg)",
    "Pauze levensduur (d)",
    "",// TODO
    "Dure de vie des pauses (j)",
    "",// TODO
    "Taukotallenteen elinik (d)",
    "Okres trwania przerwy (d)",
    "",// TODO
    " ",
    "Livstid fr direktinspelning (dagar)",
    "Pstrarea emisiunilor 'pauzate' (zile)",
    "Sznet lettartama",
    "Durada de la pausa (d)",
    "   ()",
    "Trajanje pauze (d)",
    "Pausi eluiga (pevi)",
    "Pause levetid (d)",
  },
  { "Setup.Recording$Use episode name",
    "Episodenname verwenden",
    "Uporabi ime epizode",
    "Utilizza il nome dell'episodio",
    "Gebruik episode naam",
    "Utilizar o nome do episdio",
    "Utiliser le nom de l'pisode",
    "Bruk episodenavn",
    "Kyt jakson nime",
    "Czy uzywac nazwe epizodu",
    "Utilizar nombre de episodo",
    "  ",
    "Anvnd episodnamn",
    "Utilizeaz numele episodului",
    "Epizdnv felhasznlsa",
    "Utilitzar el nom de l'episodi",
    "   ",
    "Koristi ime epizode",
    "Episoodi nime kasutamine",
    "Anvend udsendelsesnavn",
  },
  { "Setup.Recording$Use VPS",
    "VPS benutzen",
    "",// TODO
    "Utilizzare VPS",
    "VPS gebruiken",
    "",// TODO
    "Utiliser le VPS",
    "",// TODO
    "Kyt VPS-toimintoa",
    "",// TODO
    "",// TODO
    "",// TODO
    "Anvnd VPS",
    "Utilizeaz VPS",
    "",// TODO
    "",// TODO
    "  VPS",
    "Koristi VPS",
    "VPS-i kasutamine",
    "Anvend VPS",
  },
  { "Setup.Recording$VPS margin (s)",
    "Zeitpuffer bei VPS (s)",
    "",// TODO
    "Margine VPS",
    "Marge VPS (s)",
    "",// TODO
    "Marge VPS",
    "",// TODO
    "VPS-toiminnon aloitusmarginaali (s)",
    "",// TODO
    "",// TODO
    "",// TODO
    "VPS marginal (s)",
    "Marj de timp la utilizare VPS (s)",
    "",// TODO
    "",// TODO
    "  VPS ()",
    "Vremenska rezerva kod VPS (s)",
    "VPS-i algusvaru (s)",
    "VPS margin (s)",
  },
  { "Setup.Recording$Mark instant recording",
    "Direktaufzeichnung markieren",
    "Oznaci direktno snemanje",
    "Marca la registrazione",
    "Direkte opnamen markeren",
    "Marca de gravao rpida",
    "Marquage enregistr. immdiats",
    "Markere direkteopptak",
    "Merkitse pikatallenne",
    "Zaznaczyc natychm. nagranie",
    "Marcar grabaciones instantneas",
    "  ",
    "Mrk direktinspelning",
    "Marcheaz nregistrare imediat",
    "Direktfelvtel megjellse",
    "Marcar gravaci instantnia",
    "   ",
    "Oznai direktno snimanje",
    "Otsesalvestuse mrgistamine",
    "Markr direkte optagelse",
  },
  { "Setup.Recording$Name instant recording",
    "Direktaufzeichnung benennen",
    "Ime za direktno snemanje",
    "Nome registrazione istantanea",
    "Naam direkt-opname",
    "Nome de gravao rpida",
    "Noms enregistr. immdiats",
    "Navngi direkteopptak",
    "Nime pikatallenne",
    "Nazwac natychm. nagranie",
    "Nombrar grabaciones instantneas",
    "  ",
    "Namnge direktinspelning",
    "Nume nregistrare imediat",
    "Direktfelvtel megnevezse",
    "Anomenar gravacions instantnies",
    "   ",
    "Imenuj direktno snimanje",
    "Otsesalvestuse nimi",
    "Navngiv direkte optagelse",
  },
  { "Setup.Recording$Instant rec. time (min)",
    "Dauer der Direktaufzeichnung (min)",
    "Cas direktnega snemanja (min)",
    "Tempo registrazione istantanea (min)",
    "Duur van de directe opname (min)",
    "",//TODO
    "Dure enregistr. immdiat (min)",
    "",//TODO
    "Pikatallennuksen kesto (min)",
    "Dlugosc bezposredniego nagrania (min)",
    "Tiempo de grabacin instantnea (min)",
    "   ()",
    "Direktinspelning lngd (min)",
    "Timpul de nregistare imediat (min)",
    "Felvtel idtartama",
    "Temps de gravaci instantnia (min)",
    "   ()",
    "Trajanje direktnog snimanja (min)",
    "Otsesalvestuse kestus (min)",
    "Lngde af direkte optagelse (min)",
  },
  { "Setup.Recording$Max. video file size (MB)",
    "Max. Video Dateigre (MB)",
    "Najvecja velikost datoteke (MB)",
    "Dimensione massima file video (MB)",
    "Maximale omvang video file (MB)",
    "Tamanho mximo dos ficheiros (MB)",
    "Taille maxi des fichiers (MB)",
    "Maksimal strrelse p videofiler (MB)",
    "Suurin tiedostokoko (Mt)",
    "Maks. wielkosc pliku (MB)",
    "Tamao mx. de fichero (MB)",
    "   (MB)",
    "Maximal filstorlek fr inspelning (MB)",
    "Dimensiune maxim a fiierului video (MB)",
    "Max. video File-terjedelem (MB)",
    "Mida mxima de l'arxiu (MB)",
    ".   ()",
    "Maksimalna veliina datoteke (MB)",
    "Maksimaalne failisuurus (MB)",
    "Max. video filstrrelse (MB)",
  },
  { "Setup.Recording$Split edited files",
    "Editierte Dateien aufteilen",
    "Razdeli urejene datoteke",
    "Dividi i file modificati",
    "Bewerkte files opdelen",
    "Quebrar ficheiros",
    "Sparer les squences dites",
    "Splitt redigerte filer",
    "Jaottele muokatut tallenteet",
    "Dzielic montowane pliki",
    "Quebrar ficheros",
    "  ",
    "Dela upp redigerade filer",
    "Separare fiiere montate",
    "Feldolgozott File-k felosztsa",
    "Separar arxius",
    "  ",
    "Podijeli ureene datoteke",
    "Redigeeritud failide tkeldamine",
    "Opdel redigerede filer",
  },
  { "Setup.Replay$Multi speed mode",
    "MultiSpeed Modus",
    "Rezim z vec hitrostmi",
    "Modalita' multispeed",
    "Multi-speed mode",
    "Modo de multi-speed",
    "Mode multi-vitesses",
    "Multispeed modus",
    "Moninopeustila",
    "Tryb wielopredkosciowy",
    "Modo multi-velocidad",
    "  ",
    "Multispeed mode",
    "Mod multi-vitez",
    "MultiSpeed funkci",
    "Mode de multivelocitat",
    " ",
    "MultiSpeed nain",
    "Multi-kiiruse moodus",
    "Multi hastighedsmodus",
  },
  { "Setup.Replay$Show replay mode",
    "Wiedergabestatus anzeigen",
    "Prikazi rezim predvajanja",
    "Modalita' di visualizz su replay",
    "Weergave mode aangeven",
    "Mostrar modo de replay",
    "Affichage mode de lecture",
    "Vis avspillingsmodus",
    "Nyt toiston tila",
    "Wyswietlac status odtwarzania",
    "Mostrar modo de replay",
    "  ",
    "Visa uppspelnings lge",
    "Afieaz redarea",
    "Lejtszs feltntetse",
    "Mostrar mode de reproducci",
    "  ", // ???
    "Prikai nain prikazivanja",
    "Korduse moodus",
    "Vis afspilningsmodus",
  },
  { "Setup.Replay$Resume ID",
    "Wiedergabe ID",
    "Predvajalni ID",
    "ID Ripresa",
    "Hervattings ID",
    "Resume ID",// TODO
    "ID de reprise",
    "Resume ID",// TODO
    "Tallenteen paluutunniste",
    "ID odtwarzania",
    "Continuar ID",
    "ID ",
    "teruppta ID",
    "Identificator continuare",
    "Lejtszs ID",
    "ID de Continuar",
    "ID ", // ???
    "ID nastavka",
    "Jtkamise ID",
    "Genoptagelses ID",
  },
  { "Setup.Miscellaneous$Min. event timeout (min)",
    "Mindest Event Pause (min)",
    "Najmanjsi cas dogodka (min)",
    "Spegnimento: controllo prossimo evento (m)",
    "Minimale event time-out (min)",
    "Perodo mnimo de pausa (min)",
    "MinEventTimeout (min)",
    "Minste hendelsespause (min)",
    "Tapahtuman odotusaika (min)",
    "Min. czas do nast. akcji (Event) (min)",
    "Tiempo mnimo pausa (min)",
    "   ()",
    "Minsta hndelse-pause (min)",
    "Durat minim emisiuni (min)",
    "Min. esemny sznet (min)",
    "Temps mnim en pausa (min)",
    ".    ()",
    "Najmanje vrijeme pauze",
    "Min. sndmuse kestus (min)",
    "Mindste hndelsespause (min)",
  },
  { "Setup.Miscellaneous$Min. user inactivity (min)",
    "Mindest Benutzer-Inaktivitt (min)",
    "Najmanjsi cas neaktivnosti (min)",
    "Spegnimento: tempo minimo di inattivit (m)",
    "Minimum gebruikers inactiviteit (min)",
    "Perodo mnimo de inactividade (min)",
    "Dure minimale d'inact. (min)",
    "Minimumstid med inaktivitet (min)",
    "Kyttjtoiminnon odotusaika (min)",
    "Min. brak aktywnosci uzytkownika (min)",
    "Tiempo mnimo inactividad (min)",
    "   ()",
    "Minsta anndar-inaktivitet (min)",
    "Durata minim de inactivitate (min)",
    "Min. kezelsi aktivits (min)",
    "Temps mnim d'inactivitat (min)",
    ".    ()",
    "Najmanje vrijeme neaktivnosti (min)",
    "Min. kasutaja tegevusetus (min)",
    "Min. bruger inaktivitet (min)",
  },
  { "Setup.Miscellaneous$SVDRP timeout (s)",
    "SVDRP Timeout (s)",
    "SVDRP cas neaktivnosti (s)",
    "Timeout SVDRP (s)",
    "SVDRP Timeout (s)",
    "Timeout SVDRP (s)",
    "Temps maxi SVDRP (s)",
    "Ubrukt SVDRP-levetid (s)",
    "SVDRP odotusaika (s)",
    "Min. brak aktywnosci SVDRP (s)",
    "SVDRP Timeout (s)",
    "SVDRP  ()",
    "SVDRP Timeout (d)",
    "Timeout SVDRP (sec)",
    "SVDRP Timeout (s)",
    "SVDRP Timeout (s)",
    "  . SVDRP ()",
    "SVDRP vrijeme neaktivnosti",
    "SVDRP ooteaeg (s)",
    "SVDRP timeout (s)",
  },
  { "Setup.Miscellaneous$Zap timeout (s)",
    "Zap Timeout (s)",
    "",// TODO
    "Timeout Zapping",
    "Zap timeout (s)",
    "",// TODO
    "Prise en compte dernire chane (s)",
    "",// TODO
    "Kanavavalinnan odotusaika (s)",
    "",// TODO
    "",// TODO
    "  ()",
    "Zap timeout(s)",
    "Interval zapping (s)",
    "",// TODO
    "",// TODO
    "   ()",
    "",// hrv TODO
    "Kanalivahetuse ooteaeg (s)",
    "Zap timeout (s)",
  },
  // The days of the week:
  { "MTWTFSS",
    "MDMDFSS",
    "PTSCPSN",
    "LMMGVSD",
    "MDWDVZZ",
    "STQQSSD",
    "LMMJVSD",
    "MTOTFLS",
    "MTKTPLS",
    "PWSCPSN",
    "LMMJVSD",
    "",
    "MTOTFLS",
    "LMMJVSD",
    "HKSCPSV",
    "LMCJVSG",
    "ǿ",
    "PUSPSN", // hrv
    "ETKNRLP",
    "MTOTFLS",
  },
  { "MonTueWedThuFriSatSun", // must all be 3 letters!
    "MonDieMitDonFreSamSon",
    "PonTorSreCetPetSobNed",
    "LunMarMerGioVenSabDom",
    "MaaDinWoeDonVryZatZon",
    "SegTerQuaQuiSexSabDom",
    "LunMarMerJeuVenSamDim",
    "ManTirOnsTorFreLrSn",
    "Ma Ti Ke To Pe La Su ",
    "PonWtoSroCzwPiaSobNie",
    "LunMarMieJueVieSabDom",
    "K",
    "MnTisOnsTorFreLrSn",
    "LunMarMieJoiVinSmDum",
    "HtKedSzeCsPnSzoVas",
    "Dl Dm Dc Dj Dv Ds Dg ",
    "ݲҿѲ",
    "PonUtoSrietPetSubNed", // hrv
    " E  T  K  N  R  L  P ",
    "ManTirOnsTorFreLrSn",
  },
  // The allowed characters in strings:
  { " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    "",// TODO
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    "",// TODO
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " 0123456789-.#~abcdefghijklmnopqrstuvwxyz",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.,#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.,#~_",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~", // hrv
    " abcdefghijklmnopqrsztuvwxy0123456789-.#~",
    " abcdefghijklmnopqrstuvwxyz0123456789-.#~",
  },
  // Learning keys:
  { "Learning Remote Control Keys",
    "Fernbedienungs-Codes lernen",
    "Ucenje kod upravljalca",
    "Apprendimento tasti unita` remota",
    "Leren toetsen afstandsbediening",
    "Aprender as teclas do telecomando",
    "Apprentissage des codes de tlcommande",
    "Lre fjernkontrolltaster",
    "Kaukostimen opettaminen",
    "Nauka kodu pilota",
    "Aprendiendo teclas del telemando",
    "  ",
    "Inlrning av fjrrkontrollsknappar",
    "nvare taste telecomand",
    "Tvirnyt betantsa",
    "Aprenent les tecles del comandament a distncia",
    "   ",
    "Uenje kda daljinskog upravljaa",
    "Kaugjuhtimispuldi petamine",
    "Lrer fjernbetjeningstaster",
  },
  { "Phase 1: Detecting RC code type",
    "Phase 1: FB Code feststellen",
    "Faza 1: Sprejemanje IR kode",
    "Fase 1: tipo ricevitore RC",
    "Fase 1: detecteren type afstandsbediening",
    "Fase 1: detectar tipo de receptor",
    "Phase 1: Dtection du type de code",
    "Fase 1: Finne fjernkontroll-kodetype",
    "Vaihe 1: Koodauksen tunnistaminen",
    "Faza 1: Detekcja typu kodu",
    "Fase 1: Detectando tipo de receptor",
    " 1:   RC",
    "Steg1: identifiering av RC kod",
    "Faza 1: Detecia tipului telecomenzii",
    "Els lps: tvirnyt kdjnak meghatrozsa",
    "Fase 1: Detectant el tipus de receptor",
    " 1:    ",
    "Faza 1: detektiranje kda daljinskog upravljaa.",
    "Aste 1: Kodeerimisssteemi tuvastamine",
    "Fase 1: Detekterer fjernbetjenings-kodetype",
  },
  { "Press any key on the RC unit",
    "Eine Taste auf der FB drcken",
    "Pritisnite tipko na upravljalcu",
    "Premere un tasto dell'unita` RC",
    "Druk op een willekeurige knop",
    "Pressione qualquer tecla do telecomando",
    "Appuyer sur une touche de la tlcommande",
    "Trykk en av tastene p fjernkontrollen",
    "Paina mit tahansa kaukostimen nppint",
    "Nacisnac klawisz pilota",
    "Pulse una tecla en el telemando",
    "    ",
    "Tryck valfri tangent p fjrrkontrollen",
    "Apsai o tast pe telecomand",
    "Nyomjon meg egy gombot a tvirnytn",
    "Premeu qualsevol tecla del comandament",
    "    ",
    "Pritisnite tipku na daljinskom upravljau",
    "Vajuta puldil suvalist klahvi",
    "Tryk vilkrlig tast p fjernbetjeningen",
  },
  { "RC code detected!",
    "FB Code erkannt!",
    "IR koda sprejeta!",
    "Codice RC rilevato!",
    "Afstandsbediening code herkend!",
    "Cdigo do telecomando detectado!",
    "Code de la tlcommande dtect!",
    "Fjernkontroll-kodetype funnet!",
    "Nppinpainallus vastaanotettu!",
    "Kod pilota zostal poznany!",
    "Cdigo detectado!",
    "  RC!",
    "RC koden detekterad!",
    "S-a detectat tipul telecomenzii!",
    "Tvirnyt kdja felismerve!",
    "Codi detectat!",
    "  !",
    "Kd daljinskog upravljaa je prepoznat!",
    "Kodeerimisssteem tuvastatud!",
    "Fjernbetjenings-kodetype fundet!",
  },
  { "Do not press any key...",
    "Keine Taste drcken...",
    "Ne pritiskajte tipk...",
    "Non premere alcun tasto...",
    "Druk niet op een knop...",
    "No pressione nada...",
    "N'appuyer sur aucune touche ...",
    "Ikke trykk p noen av tastene...",
    "l paina kaukostimen nppimi...",
    "Nie naciskac klawiszy...",
    "No pulse ninguna tecla...",
    "  ...",
    "Tryck inte p ngon knapp...",
    "Nu apsai nici o tast...",
    "Ne nyomjon meg gombot...",
    "No premeu cap tecla...",
    "  ...",
    "Ne pritiskajte tipku...",
    "ra vajuta puldil htki klahvi...",
    "Tryk ikke p nogen tast...",
  },
  { "Phase 2: Learning specific key codes",
    "Phase 2: Einzelne Tastencodes lernen",
    "Faza 2: Ucenje posebnih kod",
    "Fase 2: Codici specifici dei tasti",
    "Fase 2: Leren specifieke toets-codes",
    "Fase 2: A aprender cdigos especificos",
    "Phase 2: Apprentissage des codes des touches",
    "Fase 2: Lre spesifikke tastekoder",
    "Vaihe 2: Nppinkoodien opettelu",
    "Faza 2: Nauka pojedynczych klawiszy",
    "Fase 2: Aprendiendo cdigos especficos",
    " 2:   ",
    "Fas 2: Inlrning av specifika knapp koder",
    "Faza 2: nvarea codurilor anumitor taste",
    "Msodik lps: az egyes gombok betantsa",
    "Fase 2: Aprenentantge de les funcions",
    " 2:    ",
    "Faza 2: Uenje posebnih kdova",
    "Aste 2: Klahvide petamine",
    "Fase 2: Lr individuelle tast koder",
  },
  { "Press key for '%s'",
    "Taste fr '%s' drcken",
    "Pritisnite tipko za '%s'",
    "Premere il tasto per '%s'",
    "Druk knop voor '%s'",
    "Pressione tecla para '%s'",
    "Appuyer sur la touche '%s'",
    "Trykk tasten for '%s'",
    "Paina nppint toiminnolle '%s'",
    "Nacisnac klawisz dla '%s'",
    "Pulsar tecla para '%s'",
    "    '%s'",
    "Tryck p knappen fr '%s'",
    "Apsai tasta pentru '%s'",
    "'%s' gomb megnyomsa",
    "Premeu una tecla per '%s'",
    "  '%s'",
    "Pritisnite tipku za '%s'",
    "Vajuta klahvile '%s'",
    "Tryk tasten for '%s'",
  },
  { "Press 'Up' to confirm",
    "'Auf' drcken zum Besttigen",
    "Pritisnite tipko 'Gor' za potrditev",
    "Premere 'Su' per confermare",
    "Druk 'Omhoog' om te bevestigen",
    "Pressione 'Cima' para confirmar",
    "Appuyer sur 'Haut' pour confirmer",
    "Trykk 'Opp' for  bekrefte",
    "Hyvksy painamalla 'Yls'",
    "Nacisnac 'Gora' do potwierdzenia",
    "Pulse 'Arriba' para confirmar",
    " ''  ",
    "Tryck 'Upp' fr att bekrfta",
    "Apsai 'Sus' pentru confirmare",
    "'Fel' megnyomsa az elfogadshoz",
    "Premeu 'Amunt' per confirmar",
    " ''  ",
    "Pritisnite 'Gore' za potvrdu",
    "Kinnitamiseks vajuta 'les'",
    "Tryk 'Op' for at bekrfte",
  },
  { "Press 'Down' to continue",
    "'Ab' drcken zum Weitermachen",
    "Pritisnite tipko 'Dol' za nadaljevanje",
    "Premere 'Giu' per continuare",
    "Druk 'Omlaag' om verder te gaan",
    "Pressione 'Baixo' para continuar",
    "Appuyer sur 'Bas' pour continuer",
    "Trykk Ned' for  fortsette",
    "Jatka painamalla 'Alas'",
    "Nacisnac 'Dol' zeby kontynuowac",
    "Pulse 'Abajo' para confirmar",
    " ''  ",
    "Tryck 'Ner' fr att bekrfta",
    "Apsai 'Jos' pentru continuare",
    "'Le' megnyomsa a folytatshoz",
    "Premeu 'Avall' per continuar",
    " ''  ",
    "Pritisnite 'Dolje' za nastavak",
    "Jtkamiseks vajuta 'Alla'",
    "Tryk 'Ned' for at fortstte",
  },
  { "(press 'Up' to go back)",
    "('Auf' drcken um zurckzugehen)",
    "(pritisnite 'Gor' za nazaj)",
    "(premere 'Su' per tornare indietro)",
    "(druk 'Omhoog' om terug te gaan)",
    "(Pressione 'Cima' para voltar)",
    "(Appuyer sur 'Haut' pour revenir en arrire)",
    "(trykk 'Opp' for  g tilbake)",
    "(palaa takaisin painamalla 'Yls')",
    "(Nacisnac 'Gora' cofa)",
    "(Pulse 'Arriba' para retornar)",
    "( ''  ",
    "(Tryck 'Upp' fr att backa)",
    "(Apsai 'Sus' pentru revenire)",
    "(Fel' megnyomsa a visszatrshez)",
    "(Premeu 'Amunt' per retornar)",
    "( ''  )",
    "(pritisnite 'Gore' za nazad)",
    "(tagasiminekuks vajuta 'les')",
    "(tryk 'Op' for at g tilbage)",
  },
  { "(press 'Down' to end key definition)",
    "('Ab' drcken zum Beenden)",
    "(pritisnite 'Dol' za konec)",
    "('Giu' per finire la definizione tasti)",
    "(Druk 'Omlaag' om te beeindigen)",
    "(Pressione 'Baixo' para terminar a definio)",
    "(Appuyer sur 'Bas' pour terminer)",
    "(trykk 'Ned' for  avslutte innlring)",
    "(lopeta opettaminen painamalla 'Alas')",
    "(Nacisnac 'Dol' by zakonczyc)",
    "(Pulse 'Abajo' para terminar programacin teclas)",
    "( ''    )",
    "(Tryck 'Ner' fr att avsluta knapp definition)",
    "(Apsai 'Jos' pentru terminare)",
    "('Le' megnyomsa a befejezshez)",
    "(Premeu 'Avall' per finalitzar l'aprenentatge)",
    "( ''    )",
    "(pritisnite 'Dolje' za kraj)",
    "(lpetamiseks vajuta 'Alla')",
    "(tryk 'Ned' for at afslutte indlringen)",
  },
  { "(press 'Menu' to skip this key)",
    "('Men' drcken zum berspringen)",
    "pritisnite 'Meni' za preskok te tipke",
    "(premere 'Menu' per saltare questo tasto)",
    "Druk 'Menu' om deze toets over te slaan",
    "",// TODO
    "('Menu' pour passer cette touche)",
    "",// TODO
    "nppimen puuttuessa paina 'Valikko'",
    "(Nacisnac 'Menu' by ominac klawisz)",
    "Pulse 'Menu' para saltarse esta tecla",
    " ''     ",
    "Tryck 'Meny' fr att hoppa ver denna knapp.",
    "Apsai 'Meniu' pentru a sri peste aceast tast",
    "A Men gombot nyomni ennek a gombnak a kihagyshoz",
    "Premeu 'Men' per obviar aquesta tecla",
    "( ''   )",
    "pritisnite 'Izbor' da preskoite ovu tipku",
    "(selle klahvi vahelejtmiseks vajuta 'Men')",
    "(tryk 'Menu' for at springe denne tast over)",
  },
  { "Phase 3: Saving key codes",
    "Phase 3: Codes abspeichern",
    "Faza 3: Shranjevanje kod tipk",
    "Fase 3: Salvataggio codici tasti",
    "Fase 3: Opslaan toets codes",
    "Fase 3: A salvar os cdigos das teclas",
    "Phase 3: Sauvegarde des codes des touches",
    "Fase 3: Lagre tastekoder",
    "Vaihe 3: Nppinkoodien tallentaminen",
    "Faza 3: Zapamietac Kod",
    "Fase 3: Guardar cdigos de teclas",
    " 3:  ",
    "Fas 3: Spara knappkoder",
    "Faza 3: Salvarea codurilor de taste",
    "Harmadik lps: kd mentse",
    "Fase 3: Guardant els codis de les tecles",
    " 3:   ",
    "Faza 3: Spremanje kdova tipki",
    "Aste 3: Klavhikoodide salvestamine",
    "Fase 3: Gemmer tast koder",
  },
  { "Press 'Up' to save, 'Down' to cancel",
    "'Auf' speichert, 'Ab' bricht ab",
    "'Gor' za potrditev, 'Dol' za prekinitev",
    "'Su' per salvare, 'Giu' per annullare",
    "'Omhoog' te bewaren, 'Omlaag' voor annuleren",
    "'Cima' para Salvar, 'Baixo' para Cancelar",
    "Appuyer sur 'Haut' pour sauvegarder, 'Bas' pour annuler",
    "Trykk 'Opp' for  lagre, 'Ned' for  avbryte",
    "Paina 'Yls' tallentaaksesi ja 'Alas' peruuttaaksesi",
    "'Gora' zapamietuje, 'Dol' przerywa",
    "Pulse 'Arriba' para guardar, 'Abajo' para anular",
    "'' , '' ",
    "Tryck 'Upp' fr att spara, 'Ner' fr att avsluta",
    "Apsai 'Sus' pentru salvare, 'Jos' pentru anulare",
    "'Fel' ments, 'Le mgse",
    "Premeu 'Amunt' per guardar, 'Avall' per anullar",
    " ''  , ''  ",
    "'Gore' za potvrdu, 'Dolje' za prekid",
    "Salvestamiseks vajuta 'les' ja katkestamiseks 'Alla'",
    "Tryk 'Op' for at gemme, 'Ned' for at annullere",
  },
  // Key names:
  { "Up",
    "Auf",
    "Gor",
    "Su",
    "Omhoog",
    "Cima",
    "Haut",
    "Opp",
    "Yls",
    "Gora",
    "Arriba",
    "",
    "Upp",
    "Sus",
    "Fel",
    "Amunt",
    "",
    "Gore",
    "les",
    "Op",
  },
  { "Down",
    "Ab",
    "Dol",
    "Gi",
    "Omlaag",
    "Baixo",
    "Bas",
    "Ned",
    "Alas",
    "Dol",
    "Abajo",
    "",
    "Ner",
    "Jos",
    "Le",
    "Avall",
    "",
    "Dolje",
    "Alla",
    "Ned",
  },
  { "Menu",
    "Men",
    "Meni",
    "Men",
    "Menu",
    "Menu",
    "Menu",
    "Meny",
    "Valikko",
    "Menu",
    "Menu",
    "",
    "Meny",
    "Meniu",
    "Men",
    "Men",
    "",
    "Izbor",
    "Men",
    "Menu",
  },
  { "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
    "",
    "Ok",
    "OK",
    "Ok",
    "D'acord",
    "Ok",
    "Ok",
    "Ok",
    "Ok",
  },
  { "Back",
    "Zurck",
    "Nazaj",
    "Indietro",
    "Terug",
    "Voltar",
    "Retour",
    "Tilbake",
    "Takaisin",
    "Wstecz",
    "Retornar",
    "",
    "Tillbaka",
    "napoi",
    "Vissza",
    "Retornar",
    "",
    "Nazad",
    "Tagasi",
    "Tilbage",
  },
  { "Left",
    "Links",
    "Levo",
    "Sinistra",
    "Links",
    "Esquerda",
    "Gauche",
    "Venstre",
    "Vasemmalle",
    "Lewo",
    "Izquierda",
    "",
    "Vnster",
    "Stnga",
    "Balra",
    "Esquerra",
    "",
    "Lijevo",
    "Vasakule",
    "Venstre",
  },
  { "Right",
    "Rechts",
    "Desno",
    "Destra",
    "Rechts",
    "Direita",
    "Droite",
    "Hyre",
    "Oikealle",
    "Prawo",
    "Derecha",
    "",
    "Hger",
    "Dreapta",
    "Jobbra",
    "Dreta",
    "",
    "Desno",
    "Paremale",
    "Hjre",
  },
  { "Red",
    "Rot",
    "Rdeca",
    "Rosso",
    "Rood",
    "Vermelho",
    "Rouge",
    "Rd",
    "Punainen",
    "Czerwony",
    "Rojo",
    "",
    "Rd",
    "Rou",
    "Piros",
    "Vermell",
    "",
    "Crveno",
    "Punane",
    "Rd",
  },
  { "Green",
    "Grn",
    "Zelena",
    "Verde",
    "Groen",
    "Verde",
    "Vert",
    "Grnn",
    "Vihre",
    "Zielony",
    "Verde",
    "",
    "Grn",
    "Verde",
    "Zld",
    "Verd",
    "",
    "Zeleno",
    "Roheline",
    "Grn",
  },
  { "Yellow",
    "Gelb",
    "Rumena",
    "Giallo",
    "Geel",
    "Amarelo",
    "Jaune",
    "Gul",
    "Keltainen",
    "Zolty",
    "Amarillo",
    "",
    "Gul",
    "Galben",
    "Srga",
    "Groc",
    "",
    "uto",
    "Kollane",
    "Gul",
  },
  { "Blue",
    "Blau",
    "Modra",
    "Blu",
    "Blauw",
    "Azul",
    "Bleu",
    "Bl",
    "Sininen",
    "Niebieski",
    "Azul",
    "",
    "Bl",
    "Albastru",
    "Kk",
    "Blau",
    "",
    "Plavo",
    "Sinine",
    "Bl",
  },
  { "Play",
    "Wiedergabe",
    "Predvajaj",
    "Riproduci",
    "Weergeven",
    "",// TODO
    "Lecture",
    "",// TODO
    "Toista",
    "Odtworzenie",
    "Reproducir",
    "A",
    "Spela upp",
    "Redare",
    "Lejtszs",
    "Reproduir",
    "",
    "Start",
    "Start",
    "Afspil",
  },
  { "Pause",
    "Pause",
    "Pavza",
    "Pausa",
    "Pauze",
    "",// TODO
    "Pause",
    "",// TODO
    "Tauko",
    "Przerwa",
    "Pausa",
    "",
    "Pausa",
    "Pauz",
    "Sznet",
    "Pausa",
    "",
    "Pauza",
    "Paus",
    "Pause",
  },
  { "Stop",
    "Stop",
    "Ustavi",
    "Stop",
    "Stop",
    "Stop",
    "Stop",
    "",// TODO
    "Lopeta",
    "Stop",
    "Parar",
    "T",
    "Stoppa",
    "Stop",
    "Stop",
    "Aturar",
    "",
    "Stop",
    "Stopp",
    "Stop",
  },
  { "Record",
    "Aufnehmen",
    "Snemaj",
    "Registra",
    "Opnemen",
    "",// TODO
    "Enregistrement",
    "",// TODO
    "Tallenna",
    "Nagrywac",
    "Grabar",
    "E",
    "Spela in",
    "nregistrare",
    "Felvenni",
    "Gravar",
    "",
    "Snimaj",
    "Salvestamine",
    "Optag",
  },
  { "FastFwd",
    "Vorlauf",
    "Hitro naprej",
    "Avanti Veloce",
    "Vooruitspoelen",
    "",// TODO
    "Avance rapide",
    "",// TODO
    "Pikakelaus >>",
    "Naprzod",
    "Adelante rpido",
    " ",
    "Snabbspolning framt",
    "Derulare nainte",
    "Elre prgetni",
    "Endavant rpidament",
    "",
    "Naprijed",
    "Edasikerimine",
    "Spol fremad",
  },
  { "FastRew",
    "Rcklauf",
    "Hitro nazaj",
    "Indietro Veloce",
    "Terugspoelen",
    "",// TODO
    "Retour rapide",
    "",// TODO
    "Pikakelaus <<",
    "Wstecz",
    "Atrs rpido",
    " ",
    "Snabbspolning bakt",
    "Derulare napoi",
    "Vissza prgetni",
    "Enrera rpidament",
    "",
    "Nazad",
    "Tagasikerimine",
    "Spol tilbage",
  },
  { "Power",
    "Ausschalten",
    "Izklop",
    "Power",
    "Uitschakelen",
    "Ligar",
    "Veille", // This one caused some bug reports ;)
    "Power",
    "Virtakytkin",
    "Wylaczyc",
    "Corriente",
    "K",
    "P/Av",
    "nchidere",
    "Kikapcsolni",
    "Aturar",
    "",
    "Iskljui",
    "Toide",
    "Sluk",
  },
  { "Channel+",
    "Kanal+",
    "Kanal+",
    "Canale +",
    "Kanaal+",
    "",// TODO
    "Chane+",
    "",// TODO
    "Kanava +",
    "Kanal+",
    "Canal +",
    "+",
    "Kanal+",
    "Canal+",
    "Csatorna+",
    "Canal +",
    " +",
    "Program +",
    "Kanal+",
    "Kanal+",
  },
  { "Channel-",
    "Kanal-",
    "Kanal-",
    "Canale -",
    "Kanaal-",
    "",// TODO
    "Chane-",
    "",// TODO
    "Kanava -",
    "Kanal-",
    "Canal -",
    "-",
    "Kanal-",
    "Canal-",
    "Csatorna-",
    "Canal -",
    " -",
    "Program -",
    "Kanal-",
    "Kanal-",
  },
  { "Volume+",
    "Lautstrke+",
    "Glasnost+",
    "Volume +",
    "Volume+",
    "Volume+",
    "Volume+",
    "Volum+",
    "nenvoimakkuus +",
    "Glosnej",
    "Volumen+",
    "+",
    "Volym+",
    "Volum+",
    "Hanger+",
    "Volum +",
    " +",
    "Glasnije", // hrv "Glasnocca +"
    "Helitugevus+",
    "Lydstyrke+",
  },
  { "Volume-",
    "Lautstrke-",
    "Glasnost-",
    "Volume -",
    "Volume-",
    "Volume-",
    "Volume-",
    "Volum-",
    "nenvoimakkuus -",
    "Ciszej",
    "Volumen-",
    "-",
    "Volym-",
    "Volum-",
    "Hanger-",
    "Volum -",
    " -",
    "Tie", // hrv Glasnocca -"
    "Helitugevus-",
    "Lydstyrke-",
  },
  { "Mute",
    "Stumm",
    "Izklop zvoka",
    "Mute",
    "Geluid onderbreken",
    "Sem som",
    "Coupure du son",
    "Lyd av",
    "netn",
    "Cisza",
    "Mudo",
    "",
    "Ljud Av",
    "Fr sunet",
    "Csend",
    "En silenci",
    " ",
    "Bez zvuka",
    "Hletu",
    "Sluk lyd",
  },
  { "Audio",
    "Audio",
    "",// TODO
    "",// TODO
    "Audio",
    "",// TODO
    "Audio",
    "",// TODO
    "ni",
    "",// TODO
    "",// TODO
    "",// TODO
    "Ljud",
    "",// TODO
    "",// TODO
    "",// TODO
    "",
    "",// TODO
    "Audio",
    "Audio",
  },
  // Miscellaneous:
  { "yes",
    "ja",
    "da",
    "si",
    "ja",
    "sim",
    "oui",
    "ja",
    "kyll",
    "tak",
    "s",
    "",
    "ja",
    "da",
    "igen",
    "s",
    "",
    "da",
    "jah",
    "ja",
  },
  { "no",
    "nein",
    "ne",
    "no",
    "nee",
    "no",
    "non",
    "nei",
    "ei",
    "nie",
    "no",
    "",
    "nej",
    "nu",
    "nem",
    "no",
    "",
    "ne",
    "ei",
    "nej",
  },
  { "off",
    "aus",
    "izklop",
    "off",
    "uit",
    "off",
    "off",
    "",// TODO
    "pois",
    "wyl.",
    "off",
    "",
    "av",
    "inactiv",
    "ki",
    "off",
    "",
    "ugasi",
    "vlja",
    "fra",
  },
  { "none",
    "keine",
    "nobeden",
    "nessuno",
    "geen",
    "",// TODO
    "aucun",
    "",// TODO
    "tyhj",
    "zaden",
    "ninguno",
    "",
    "ingen",
    "niciuna(ul)",
    "semmi",
    "cap",
    "",
    "nijedan",
    "thi",
    "ingen",
  },
  { "auto",
    "auto",
    "avtomatsko",
    "auto",
    "auto",
    "",// TODO
    "auto",
    "",// TODO
    "auto",
    "auto",
    "auto",
    "",
    "automatisk",
    "automat",
    "auto",
    "auto",
    "",
    "automatski",
    "automaatne",
    "automatisk",
  },
  { "top",
    "oben",
    "zgoraj",
    "limite sup",
    "boven",
    "topo",
    "haut",
    "vre",
    "ylreuna",
    "gora",
    "parte superior",
    "",
    "vre",
    "sus",
    "Fent",
    "a dalt",
    "",
    "gore",
    "leval",
    "top",
  },
  { "bottom",
    "unten",
    "spodaj",
    "limite inf",
    "onder",
    "fundo",
    "bas",
    "nedre",
    "alareuna",
    "dol",
    "parte inferior",
    "",
    "undre",
    "jos",
    "lent",
    "a baix",
    "",
    "dolje",
    "all",
    "bund",
  },
  { "Disk",
    "Disk",
    "Disk",
    "Disco",
    "Disk",
    "Disk",
    "Disque",
    "Disk",
    "Levy",
    "Disk",
    "Disco",
    "",
    "Disk",
    "Disc",
    "Lemez",
    "Disc",
    "",
    "Disk",
    "Ketas",
    "Disk",
  },
  { "free",
    "frei",
    "prosto",
    "liberi",
    "vrij",
    "livre",
    "restant",
    "ledig",
    "vapaana",
    "pozostalo",
    "libre",
    "",
    "ledigt",
    "liber",
    "szabad",
    "lliure",
    "",
    "slobodno",
    "vaba",
    "fri",
  },
  { "Jump: ", // note the trailing blank
    "Springen: ",
    "Skoci: ",
    "Vai a: ",
    "Springen: ",
    "Saltar: ",
    "Accs direct: ",
    "Hopp: ",
    "Siirry: ",
    "Skok: ",
    "Salta a: ",
    ": ",
    "Hopp: ",
    "Salt la: ",
    "Ugrs: ",
    "Salta a:",
    ": ",
    "Skoi: ",
    "Hpe: ",
    "Hop: ",
  },
  { "Volume ", // note the trailing blank
    "Lautstrke ",
    "Glasnost ",
    "Volume ",
    "Volume ",
    "Volume ",
    "Volume ",
    "Volum ",
    "nenvoimakkuus ",
    "Glosnosc ",
    "Volumen ",
    " ",
    "Volym ",
    "Volum ",
    "Hanger ",
    "Volum ",
    " ",
    "Glasnoa ",
    "Helitugevus ",
    "Lydstyrke ",
  },
  { " Stop replaying", // note the leading blank!
    " Wiedergabe beenden",
    " Prekini ponavljanje",
    " Interrompi riproduzione",
    " Stop afspelen",
    " Parar reproduo",
    " Arrter la lecture",
    " Stopp avspilling",
    " Lopeta toisto",
    " Zatrzymac odtwarzanie",
    " Parar reproducin",
    "  ",
    " Avsluta uppspelning",
    " Oprete redarea",
    " Lejtszst befejzni",
    " Aturar la reproducci",
    "  ",
    " Prekini reprodukciju",
    " Lpeta taasesitamine",
    " Stop afspilning",
  },
  { " Stop recording ", // note the leading and trailing blanks!
    " Aufzeichnung beenden ",
    " Prekini snemanje ",
    " Interrompi registrazione ",
    " Stop opnemen ",
    " Parar gravao ",
    " Arrter l'enregistrement ",
    " Stopp opptak fra ",
    " Lopeta tallennus ",
    " Zatrzymac nagrywanie ",
    " Parar grabacin ",
    "   ",
    " Avsluta inspelning ",
    " Oprete nregistrarea ",
    " Felvtelt befejezni ",
    " Aturar la gravaci ",
    "   ",
    " Prekini snimanje ",
    " Lpeta salvestamine ",
    " Stop optagelse ",
  },
  { " Cancel editing", // note the leading blank!
    " Schneiden abbrechen",
    " Prekini urejanje",
    " Annulla modifiche",
    " Bewerken afbreken",
    " Anular modificao",
    " Annuler le montage",
    " Avbryt redigering",
    " Peru muokkaus",
    " Przerwac montaz",
    " Anular modificacin ",
    "  ",
    " Avbryt redigering",
    " Oprete montajul nregistrrii",
    " Vgst megszaktani",
    " Cancellar l'edici ",
    "   ",
    " Prekini ureivanje",
    " Katkesta monteerimine",
    " Afbryd redigering",
  },
  { "Switching primary DVB...",
    "Primres Interface wird umgeschaltet...",
    "Preklapljanje primarne naprave...",
    "Cambio su card DVB primaria...",
    "Eerste DVB-kaart wordt omgeschakeld...",
    "A mudar interface DVB primrio...",
    "Changement de carte DVB primaire...",
    "Bytter frste DVB-enhet...",
    "Vaihdetaan pvastaanottimelle...",
    "Pierwszy interfejs DVB przelacza...",
    "Cambio al interface DVB primario...",
    "  DVB  ...",
    "Byter primr DVB enhet...",
    "Comut dispozitiv DVB primar...",
    "Primr Interface tkapcsolva...",
    "Canviant a la interfcie DVB primria...",
    "  DVB-...",
    "Preklapanje primarnog DVB ureaja...",
    "Esmase DVB seadme mberllitus...",
    "Skifter primr DVB enhed...",
  },
  { "Up/Dn for new location - OK to move",
    "Auf/Ab fr neue Position - dann OK",
    "Gor/Dol za novo poz. - Ok za premik",
    "Su/Gi per nuova posizione - OK per muovere",
    "Gebruik Omhoog/Omlaag - daarna Ok",
    "Cima/Baixo para nova localizao - Ok para mover",
    "Haut/Bas -> nouvelle place - OK -> dplacer",
    "Opp/Ned for ny plass - OK for  flytte",
    "'Yls/Alas' uusi paikka - 'OK' hyvksy",
    "Gora/Dol na nowa pozycje - Ok zmienia",
    "Arriba/Abajo para el nuevo lugar - OK para mover",
    "/   .  ",
    "Upp/Ner fr ny plats - OK fr att flytta",
    "Sus/Jos pentru noua locaie - OK pentru a muta",
    "Fel/Le egy uj opcirt - aztn OK",
    "Amunt/Avall per una nova localitzaci - OK per moure",
    " \"\"/\"\"   ,   \"OK\"",
    "Gore/Dolje na novu poziciju - zatim OK",
    "'les/Alla' uus asukoht - 'OK' kinnitus",
    "Op/Ned for ny placering - OK for at flytte",
  },
  { "Editing process started",
    "Schnitt gestartet",
    "Urejanje se je zacelo",
    "Processo di modifica iniziato",
    "Bewerken is gestart",
    "Processo de modificao iniciado",
    "Opration de montage lance",
    "Redigeringsprosess startet",
    "Muokkaus aloitettu",
    "Uruchomiony proces montazu",
    "Proceso modificacin iniciado",
    " ",
    "Redigering startad",
    "Montajul nregistrrii a nceput",
    "Vgs elindtva",
    "Procs d'edici iniciat",
    "  ",
    "Rezanje je zapoeto",
    "Redigeerimine algas",
    "Redigeringsproces startet",
  },
  { "Editing process finished",
    "Schnitt beendet",
    "Proces urejanja je koncan",
    "Processo di modifica terminato",
    "Bewerken is klaar",
    "Processo de modificao terminado",
    "Montage termin",
    "Redigeringsprosess avsluttet",
    "Muokkaus valmis",
    "Proces montazu zakonczony",
    "Proceso de modificacin terminado",
    "  ",
    "Redigering avslutad",
    "Montajul nregistrrii s-a terminat",
    "Vgs befejezve",
    "Procs d'edici finalitzat",
    " ",
    "Rezanje zavreno",
    "Redigeerimine on lpetatud",
    "Redigeringsproces afsluttet",
  },
  { "Editing process failed!",
    "Schnitt gescheitert!",
    "Napaka pri procesu urejenja!",
    "Processo di modifica fallito!",
    "Bewerken is mislukt!",
    "Falha no processo de modificao",
    "Echec du montage!",
    "Feil under redigering!",
    "Muokkaus eponnistui!",
    "Bledny proces montazu!",
    "Modificacin ha fallado!",
    "  !",
    "Redigeringsprocessen misslyckades",
    "Montajul nregistrrii a euat",
    "Vgs sikertelen!",
    "Procs d'edici fallit!",
    "    !",
    "Rezanje neuspjeno!",
    "Redigeerimine ebannestus",
    "Redigeringsproces fejlede!",
  },
  { "scanning recordings...",
    "Aufzeichnungen werden durchsucht...",
    "iskanje posnetkov...",
    "scansione registrazioni...",
    "Doorzoeken opnames...",
    "A pesquisar gravaes...",
    "Recherche des enregistrements...",
    "Gr igjennom opptakene...",
    "haetaan tallenteita...",
    "Skan nagran...",
    "buscando grabaciones...",
    " ...",
    "Sker igenom inspelningarna...",
    "Caut nregistrri...",
    "Felvett adsok bngszse...",
    "cercant gravacions...",
    " ...",
    "pretraivanje snimljenog...",
    "salvestuste skaneerimine...",
    "skanner optagelser...",
  },
  { "Pausing live video...",
    "Live-Signal wird angehalten...",
    "Ustavljanje predvajanja v zivo...",
    "Pausa del canale in visione...",
    "Pauzeren live uitzending...",
    "",// TODO
    "Pause de l'mission en direct...",
    "",// TODO
    "Pysytetn lhetys...",
    "Zatrzymany program biezacy...",
    "Emisin en directo parada...",
    "  ",
    "Pausar direktinspelningen",
    "Trec n pauz emisiunea transmis...",
    "Az l ads meglltva...",
    "Pausa d'emissi en directe...",
    "  ...",
    "Zaustavljanje ivog signala...",
    "Saate edastamise peatamine...",
    "Pausere live udsendelse...",
  },
  { "Starting EPG scan",
    "Beginne mit EPG-Scan",
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "Ohjelmaoppaan pivitys aloitettu",
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "EPG skaneerimine kivitatud",
    "Starter EPG skanning",
  },
  { "This plugin has no setup parameters!",
    "Dieses Plugin hat keine Setup-Parameter!",
    "Ta plugin nima nastavitvenih parametrov!",
    "Questo plugin non ha parametri di setup!",
    "Deze plugin heeft geen instelparameters",
    "",// TODO
    "Ce plugin n'a pas de paramtres!",
    "",// TODO
    "Tll laajennoksella ei ole asetuksia!",
    "Ten plugin niema parametrow!",
    "Este plugin no admite configuracin",
    "     ",
    "Den hr modulen har inga parametrar",
    "Acest plugin nu se configureaz!",
    "Ennek a plugin-nak nincs setup-parametere!",
    "Aquest plugin no admet configuraci!",
    "    !",
    "Ovaj dodatak (Plugin) nema parametara!",
    "Sellel laienudusmoodulil ei ole seadeid!",
    "Denne plugin har ingen parametre",
  },
  { "Classic VDR",
    "Klassischer VDR",
    "",// TODO
    "VDR Classico",
    "VDR Klassiek",
    "",// TODO
    "",// TODO
    "",// TODO
    "Klassinen VDR",
    "",// TODO
    "",// TODO
    "",// TODO
    "Klassisk VDR",
    "VDR clasic",
    "",// TODO
    "",// TODO
    "",
    "Klasini VDR",
    "Klassikaline VDR",
    "Klassisk VDR",
  },
  { "ST:TNG Panels",
    "ST:TNG Konsolen",
    "",// TODO
    "Consolles ST:TNG",
    "ST:TNG Consoles",
    "",// TODO
    "",// TODO
    "",// TODO
    "ST:TNG konsoli",
    "",// TODO
    "",// TODO
    "",// TODO
    "ST:TNG konsol",
    "Cons. ST:TNG",
    "",// TODO
    "",// TODO
    "ST:TNG ",
    "ST:TNG Konzole",
    "ST:TNG konsool",
    "ST:TNG konsol",
  },
  { "No title",
    "Kein Titel",
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "Ei esityst",
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
    "",// TODO
  },
  { NULL }
  };

// --- cI18nEntry ------------------------------------------------------------

class cI18nEntry : public cListObject {
private:
  const tI18nPhrase *phrases;
  const char *plugin;
public:
  cI18nEntry(const tI18nPhrase * const Phrases, const char *Plugin);
  const tI18nPhrase *Phrases(void) { return phrases; }
  const char *Plugin(void) { return plugin; }
  };

cI18nEntry::cI18nEntry(const tI18nPhrase * const Phrases, const char *Plugin)
{
  phrases = Phrases;
  plugin = Plugin;
}

// --- cI18nList -------------------------------------------------------------

class cI18nList : public cList<cI18nEntry> {
public:
  cI18nEntry *Get(const char *Plugin);
  const tI18nPhrase *GetPhrases(const char *Plugin);
  };

cI18nEntry *cI18nList::Get(const char *Plugin)
{
  if (Plugin) {
     for (cI18nEntry *p = First(); p; p = Next(p)) {
         if (strcmp(p->Plugin(), Plugin) == 0)
            return p;
         }
     }
  return NULL;
}

const tI18nPhrase *cI18nList::GetPhrases(const char *Plugin)
{
  cI18nEntry *p = Get(Plugin);
  return p ? p->Phrases() : NULL;
}

cI18nList I18nList;

// ---

void I18nRegister(const tI18nPhrase * const Phrases, const char *Plugin)
{
  cI18nEntry *p = I18nList.Get(Plugin);
  if (p)
     I18nList.Del(p);
  if (Phrases)
     I18nList.Add(new cI18nEntry(Phrases, Plugin));
}

const char *I18nTranslate(const char *s, const char *Plugin)
{
  if (Setup.OSDLanguage) {
     const tI18nPhrase *p = Plugin ? I18nList.GetPhrases(Plugin) : Phrases;
     if (!p)
        p = Phrases;
     for (int i = ((p == Phrases) ? 1 : 2); i--; ) {
         for (; **p; p++) {
             if (strcmp(s, **p) == 0) {
                const char *t = (*p)[Setup.OSDLanguage];
                if (t && *t)
                   return t;
                }
             }
         p = Phrases;
         }
     esyslog("%s%sno translation found for '%s' in language %d (%s)\n", Plugin ? Plugin : "", Plugin ? ": " : "", s, Setup.OSDLanguage, Phrases[0][Setup.OSDLanguage]);
     }
  const char *p = strchr(s, '$');
  return p ? p + 1 : s;
}

const char * const * I18nLanguages(void)
{
  return &Phrases[0][0];
}

const char * const * I18nCharSets(void)
{
  return &Phrases[1][0];
}

const char * I18nLanguageCode(int Index)
{
  return 0 <= Index && Index < I18nNumLanguages ? Phrases[2][Index] : NULL;
}

int I18nLanguageIndex(const char *Code)
{
  for (int i = 0; i < I18nNumLanguages; i++) {
      if (strcasestr(Phrases[2][i], Code))
         return i;
      }
  //dsyslog("unknown language code: '%s'", Code);
  return -1;
}

const char *I18nNormalizeLanguageCode(const char *Code)
{
  if (Code[0] && !isalnum(Code[0]) || Code[1] && !isalnum(Code[1]) || Code[2] && !isalnum(Code[2])) {
     // ISO 639 language codes are defined as alphabetical characters, but digits are apparently
     // also used, for instance for "2ch"
     //dsyslog("invalid language code: '%s'", Code);
     return "???";
     }
  int n = I18nLanguageIndex(Code);
  return n >= 0 ? I18nLanguageCode(n) : Code;
}

bool I18nIsPreferredLanguage(int *PreferredLanguages, int LanguageIndex, int &OldPreference)
{
  for (int i = 0; i < I18nNumLanguages; i++) {
      if (PreferredLanguages[i] < 0)
         break; // the language is not a preferred one
      if (PreferredLanguages[i] == LanguageIndex) {
         if (OldPreference < 0 || i < OldPreference) {
            OldPreference = i;
            return true;
            }
         break;
         }
      }
  if (OldPreference < 0) {
     OldPreference = I18nNumLanguages; // higher than the maximum possible value
     return true; // if we don't find a preferred one, we take the first one
     }
  return false;
}
