from vedo import *
from vedo.pyplot import histogram
import numpy as np

N = 2000
x = np.random.randn(N) * 1.0
y = np.random.randn(N) * 1.5

# hexagonal binned histogram:
histo = histogram(x, y,
                  bins=10,
                  mode='hexbin',
                  xtitle="x gaussian, s=1.0",
                  ytitle="y gaussian, s=1.5",
                  fill=True,
                  cmap='terrain',
                  )

# add a formula:
f = r'f(x, y)=A \exp \left(-\left(\frac{\left(x-x_{o}\right)^{2}}'
f+= r'{2 \sigma_{x}^{2}}+\frac{\left(y-y_{o}\right)^{2}}'
f+= r'{2 \sigma_{y}^{2}}\right)\right)'
formula = Latex(f, c='k', s=1.5).rotateX(90).rotateZ(90).pos(1.5,-2,1)

show(histo, formula, axes=1, viewup='z')
