/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.resolver.BasicResolver;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.util.IvyPattern;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class AbstractResourceResolver
extends BasicResolver {
    private List _ivyPatterns = new ArrayList();
    private List _artifactPatterns = new ArrayList();
    private boolean _m2compatible = false;

    protected ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        ResolvedResource rres = this.findResourceUsingPatterns(mrid, this._ivyPatterns, "ivy", "ivy", "xml", data.getDate());
        return rres;
    }

    protected ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this._artifactPatterns, artifact.getName(), artifact.getType(), artifact.getExt(), date);
    }

    protected ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevision, List patternList, String artifact, String type, String ext, Date date) {
        ResolvedResource rres = null;
        Iterator iter = patternList.iterator();
        while (iter.hasNext() && rres == null) {
            String pattern = (String)iter.next();
            rres = this.findResourceUsingPattern(moduleRevision, pattern, artifact, type, ext, date);
        }
        return rres;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, String var3, String var4, String var5, Date var6);

    protected abstract ResolvedResource[] findAll(ModuleRevisionId var1, String var2, String var3, String var4, String var5);

    protected abstract long get(Resource var1, File var2) throws IOException;

    protected void logIvyNotFound(ModuleRevisionId mrid) {
        DefaultArtifact artifact = new DefaultArtifact(mrid, new Date(), "ivy", "ivy", "xml");
        String revisionToken = mrid.getRevision().startsWith("latest.") ? "[any " + mrid.getRevision().substring("latest.".length()) + "]" : "[" + mrid.getRevision() + "]";
        DefaultArtifact latestArtifact = new DefaultArtifact(new ModuleRevisionId(mrid.getModuleId(), revisionToken), new Date(), "ivy", "ivy", "xml");
        if (this._ivyPatterns.isEmpty()) {
            this.logIvyAttempt("no ivy pattern => no attempt to find ivy file for " + mrid);
        } else {
            Iterator iter = this._ivyPatterns.iterator();
            while (iter.hasNext()) {
                String pattern = (String)iter.next();
                String resolvedFileName = IvyPatternHelper.substitute(pattern, artifact);
                this.logIvyAttempt(resolvedFileName);
                if (mrid.isExactRevision()) continue;
                resolvedFileName = IvyPatternHelper.substitute(pattern, latestArtifact);
                this.logIvyAttempt(resolvedFileName);
            }
        }
    }

    protected void logArtifactNotFound(Artifact artifact) {
        if (this._artifactPatterns.isEmpty()) {
            this.logArtifactAttempt(artifact, "no artifact pattern => no attempt to find artifact " + artifact);
        }
        Iterator iter = this._artifactPatterns.iterator();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            String resolvedFileName = IvyPatternHelper.substitute(pattern, artifact);
            this.logArtifactAttempt(artifact, resolvedFileName);
        }
    }

    protected Collection findNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        names.addAll(this.findIvyNames(tokenValues, token));
        names.addAll(this.findArtifactNames(tokenValues, token));
        return names;
    }

    protected Collection findIvyNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", "ivy");
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", "xml");
        this.findTokenValues(names, this.getIvyPatterns(), tokenValues, token);
        this.getIvy().filterIgnore(names);
        return names;
    }

    protected Collection findArtifactNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap(tokenValues);
        tokenValues.put("artifact", tokenValues.get("module"));
        tokenValues.put("type", "jar");
        tokenValues.put("ext", "jar");
        this.findTokenValues(names, this.getArtifactPatterns(), tokenValues, token);
        this.getIvy().filterIgnore(names);
        return names;
    }

    protected void findTokenValues(Collection names, List patterns, Map tokenValues, String token) {
    }

    public void addIvyPattern(String pattern) {
        this._ivyPatterns.add(pattern);
    }

    public void addArtifactPattern(String pattern) {
        this._artifactPatterns.add(pattern);
    }

    public List getIvyPatterns() {
        return Collections.unmodifiableList(this._ivyPatterns);
    }

    public List getArtifactPatterns() {
        return Collections.unmodifiableList(this._artifactPatterns);
    }

    protected void setIvyPatterns(List ivyPatterns) {
        this._ivyPatterns = ivyPatterns;
    }

    protected void setArtifactPatterns(List artifactPatterns) {
        this._artifactPatterns = artifactPatterns;
    }

    public void addConfiguredIvy(IvyPattern p) {
        this._ivyPatterns.add(p.getPattern());
    }

    public void addConfiguredArtifact(IvyPattern p) {
        this._artifactPatterns.add(p.getPattern());
    }

    public void dumpConfig() {
        String p;
        super.dumpConfig();
        Message.debug("\t\tm2compatible: " + this.isM2compatible());
        Message.debug("\t\tivy patterns:");
        ListIterator iter = this.getIvyPatterns().listIterator();
        while (iter.hasNext()) {
            p = (String)iter.next();
            Message.debug("\t\t\t" + p);
        }
        Message.debug("\t\tartifact patterns:");
        iter = this.getArtifactPatterns().listIterator();
        while (iter.hasNext()) {
            p = (String)iter.next();
            Message.debug("\t\t\t" + p);
        }
    }

    public boolean isM2compatible() {
        return this._m2compatible;
    }

    public void setM2compatible(boolean m2compatible) {
        this._m2compatible = m2compatible;
    }

    protected ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId mrid) {
        if (mrid.getOrganisation().indexOf(46) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('.', '/'), mrid.getName(), mrid.getRevision());
    }
}

