#include <stdio.h>
#include <stdlib.h>
#include <verbiste/c-api.h>


static
int
demo(const char *latin1_infinitive)
{
    int k;

    for (k = 0;
	verbiste_valid_modes_and_tenses[k].mode != VERBISTE_INVALID_MODE;
	k++)
    {
	Verbiste_Mode mode = verbiste_valid_modes_and_tenses[k].mode;
	Verbiste_Tense tense = verbiste_valid_modes_and_tenses[k].tense;
	Verbiste_PersonArray person_array;
	size_t i;
	char *lower_latin1;

	lower_latin1 = verbiste_tolower_latin1(latin1_infinitive);
	person_array = verbiste_conjugate(lower_latin1, mode, tense);
	verbiste_free_string(lower_latin1);

	if (person_array == NULL)
	{
	    printf("Unknown infinitive.\n");
	    return -1;
	}

	printf("- %s %s:\n",
	    (const char*) verbiste_get_mode_name(mode), 
	    (const char*) verbiste_get_tense_name(tense));


	//for (i = 0; vec[i].inflections != NULL; i++)
	for (i = 0; person_array[i] != NULL; i++)
	{
	    size_t j;

	    //for (j = 0; vec[i].inflections[j] != NULL; j++)
	    for (j = 0; person_array[i][j] != NULL; j++)
	    {
		if (j != 0)
		    printf(", ");
		printf(person_array[i][j]);
	    }
	    printf("\n");
	}

	verbiste_free_person_array(person_array);
    }
    printf("-\n");
    return 0;
}


int main( int argc, char *argv[])
{
    const char *libdatadir;
    char conjFN[512], verbsFN[512];
    int exit_status;

    if (argc < 2)
    {
	printf("french-conjugator-c demo for the C api of libverbiste\n");
	printf("Usage: french-conjugator-c word\n");
	return EXIT_FAILURE;
    }

    libdatadir = getenv("LIBDATADIR");
    if (libdatadir == NULL)
	libdatadir = LIBDATADIR;

    snprintf(conjFN, sizeof(conjFN), "%s/conjugation-fr.xml", libdatadir);
    snprintf(verbsFN, sizeof(verbsFN), "%s/verbs-fr.xml", libdatadir);

    verbiste_init(conjFN, verbsFN);

    exit_status = demo(argv[1]);

    verbiste_close();

    return exit_status;
}
