#include <stdio.h>
#include <stdlib.h>
#include <verbiste/c-api.h>


int main(int argc, char *argv[])
{
    Verbiste_ModeTensePersonNumber *vec;
    size_t i;
    const char *libdatadir;
    char conjFN[512], verbsFN[512];
    char *lower_latin1;

    libdatadir = getenv("LIBDATADIR");
    if (libdatadir == NULL)
	libdatadir = LIBDATADIR;

    snprintf(conjFN, sizeof(conjFN), "%s/conjugation-fr.xml", libdatadir);
    snprintf(verbsFN, sizeof(verbsFN), "%s/verbs-fr.xml", libdatadir);

    verbiste_init(conjFN, verbsFN);

    if (argc < 2)
    {
	printf("french-deconjugator-c demo for the C api of libverbiste\n");
	printf("Usage: french-deconjugator-c word\n");
	return 1;
    }


    lower_latin1 = verbiste_tolower_latin1(argv[1]);
    vec = verbiste_deconjugate(lower_latin1);
    verbiste_free_string(lower_latin1);

    if (vec == NULL) 
    {        
	fprintf(stderr, "Internal error in libverbiste.\n");
	return 1;
    }


    for (i = 0; vec[i].infinitive_verb != NULL; i++)
    {
	printf("%s, %s, %s, %d, %s\n", 
		    vec[i].infinitive_verb,
		    (const char*) verbiste_get_mode_name(vec[i].mode),
		    (const char*) verbiste_get_tense_name(vec[i].tense),
		    vec[i].person,
		    vec[i].plural ? "plural" : "singular");
    }
    printf("\n");

    verbiste_free_mtpn_array(vec);

    verbiste_close();

    return 0;
}
