/*
 * +-------------------------------------------------------+
 * |                                                       |
 * |     videogen                                          |
 * |                                                       |
 * |     a simple XFree86 Modeline calculator              |
 * |     (c) 1997-2002, Szabolcs Rumi                      |   
 * |                                                       |
 * |     http://www.rtfm.hu/videogen                       |
 * |                                                       |
 * |     the videogen package is distributed under the     |
 * |     GNU General Public License Version 2 (GPLv2)      |
 * |                                                       |
 * +-------------------------------------------------------+   
 */

#ifndef CONFIG_H
# define CONFIG_H

/*
 *
 *
 * Here you can configure some compile-time defaults, but you should
 * only modify these if you are really sure you know what you are doing.
 *
 *
 */



/*
 * The version number reported by the program. This should not be bothered...
 */
#define CFG_VIDEOGEN_VERSION "0.31"



/*
 * verbose output
 *
 * default: 1
 */
#define CFG_VERBOSE 1

/*
 * default configuration file
 *
 * default: ~/.videogen
 */
#define CFG_CFGFILE "~/.videogen"

/*
 * Linux framebuffer (fbset) timings calculation mode
 *
 * default: 0
 */
#define CFG_FBSET 0

/*
 * Linux NVidia driver compatibility mode
 *
 * default: 1
 */
#define CFG_NVIDIA 1

/*
 * parameter preferences
 */
#define CFG_PREC_DEFAULT 0
#define CFG_PREC_CFGFILE 1
#define CFG_PREC_CMDLINE 2

/*
 * how many percents of horizontal frame length is visible
 * default: 80%
 */
#define CFG_HORIZ_VISIBLE 80

/*
 * how many percents of vertical frame length is visible
 * default: 95%
 */
#define CFG_VERT_VISIBLE 95

/*
 * horizontal front porch interval (must be n*8)
 * default: 32 [ticks]
 */
#define CFG_HORIZ_FRONT_PORCH 64

/*
 * horizontal back porch interval (must be n*8)
 * default: 64 [ticks]
 */
#define CFG_HORIZ_BACK_PORCH 128

/*
 * default minimum horizontal sync pulse duration
 * default: 0.5 [us]
 */
#define CFG_HORIZ_SYNC_PULSE 0.5

/*
 * vertical front porch interval
 * default: 2 [ticks]
 */
#define CFG_VERT_FRONT_PORCH 2

/*
 * vertical back porch interval
 * default: 32 [ticks]
 */
#define CFG_VERT_BACK_PORCH 32

/*
 * default vertical sync pulse duration
 * default: 50 [us]
 */
#define CFG_VERT_SYNC_PULSE 50

/*
 * default limits for hardware parameter bounds checking
 * do not bother these.
 */
#define CFG_WIDTH_MIN			320
#define CFG_WIDTH_MAX			2048
#define CFG_HEIGHT_MIN			200
#define CFG_HEIGHT_MAX			1536
#define CFG_MAX_DOTCLK_MIN		5
#define CFG_MAX_DOTCLK_MAX		500
#define CFG_MAX_HFREQ_MIN		15
#define CFG_MAX_HFREQ_MAX		200
#define CFG_MAX_VFREQ_MIN		40
#define CFG_MAX_VFREQ_MAX		200
#define CFG_TARGET_VFREQ_MIN		40
#define CFG_TARGET_VFREQ_MAX		200
#define CFG_ASPECT_RATIO_MIN		0.5
#define CFG_ASPECT_RATIO_MAX		0.9
#define CFG_HORIZ_VISIBLE_MIN		70
#define CFG_HORIZ_VISIBLE_MAX		97
#define CFG_VERT_VISIBLE_MIN		70
#define CFG_VERT_VISIBLE_MAX		99
#define CFG_HORIZ_FRONT_PORCH_MIN	32
#define CFG_HORIZ_FRONT_PORCH_MAX	512
#define CFG_HORIZ_BACK_PORCH_MIN	32
#define CFG_HORIZ_BACK_PORCH_MAX	512
#define CFG_HORIZ_SYNC_PULSE_MIN	0.3
#define CFG_HORIZ_SYNC_PULSE_MAX	1.5
#define CFG_VERT_FRONT_PORCH_MIN	0
#define CFG_VERT_FRONT_PORCH_MAX	256
#define CFG_VERT_BACK_PORCH_MIN		0
#define CFG_VERT_BACK_PORCH_MAX		256
#define CFG_VERT_SYNC_PULSE_MIN		30
#define CFG_VERT_SYNC_PULSE_MAX		150
#define CFG_NV_MAX_HBLANK		1016
#define CFG_NV_MAX_HSP			256
#define CFG_NV_MAX_VBLANK		128
#define CFG_NV_MAX_VSP			16






#endif /* CONFIG_H */
