#!/usr/bin/env python
# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2009  Olivier Ponchaut <opvg@edpnet.be>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

from distutils.core import setup

setup(name = "videoporama",
      version = "0.7.6",
      description = "Videoporama - Application to make video of image slideshow",
      author = "Ponchaut Olivier",
      author_email = "opvg@edpnet.be",
      url = "http://www.videoporama.tuxfamily.org",
      data_files = [("./",["README",
                                      "INSTALL",
                                      "licences.txt",
                                      "about.py",
                                      "configuration.py",
                                      "firsttime.py",
                                      "main_win.py",
                                      "lot.py",
                                      "start.py",
                                      "interface.py",
                                      "videoporama.py",
                                      "mplayer.py",
                                      "process.py",
                                      "showprogress.py",
                                      "statusconf.py",
                                      "warning.py"]),
                    ("locale",["locale/videoporama_fr.qm","locale/videoporama_es.qm","locale/videoporama_it.qm" ]),
                    ("help", ["help/help_fr.pdf","help/help_en.pdf"]),
                    ("icons", ["icons/open.png",
                                      "icons/add.png",
                                      "icons/arrow_left.png",
                                      "icons/arrow_right.png",
                                      "icons/bin.png",
                                      "icons/config.png",
                                      "icons/copy.png",
                                      "icons/cut.png",
                                      "icons/paste.png",
                                      "icons/delete.png",
                                      "icons/exit.png",
                                      "icons/film.png",
                                      "icons/new.png",
                                      "icons/nok.png",
                                      "icons/ok.png",
                                      "icons/pencil.png",
                                      "icons/pencil_add.png",
                                      "icons/pencil_delete.png",
                                      "icons/pictures.png",
                                      "icons/player_pause.png",
                                      "icons/player_play.png",
                                      "icons/player_stop.png",
                                      "icons/tavbottom.png",
                                      "icons/text_align_center.png",
                                      "icons/text_align_left.png",
                                      "icons/text_align_right.png",
                                      "icons/text_bold.png",
                                      "icons/text_italic.png",
                                      "icons/text_underline.png",
                                      "icons/textfield_delete.png",
                                      "icons/undo.png",
                                      "icons/vcard_add.png",
                                      "icons/vcard_delete.png",
                                      "icons/vcard_edit.png",
                                      "icons/open.png",
                                      "icons/redo.png",
                                      "icons/save.png",
                                      "icons/videoporama.png",
                                      "icons/videoporama_big.png"]),
                       ("template",["template/idv_config.xml",
                                      "template/idv_config_win.xml",
                                      "template/template_data.idv"]),
                       ("luma",["luma/bar_bottom.png",
                                      "luma/bar_left.png",
                                      "luma/bar_right.png",
                                      "luma/bar_top.png",
                                      "luma/barn_bottomleft.png",
                                      "luma/barn_horz.png",
                                      "luma/barn_topleft.png",
                                      "luma/barn_vert.png",
                                      "luma/box_bottomcentre.png",
                                      "luma/box_bottomleft.png",
                                      "luma/box_bottomright.png",
                                      "luma/box_leftcentre.png",
                                      "luma/box_rightcentre.png",
                                      "luma/box_topcentre.png",
                                      "luma/box_topleft.png",
                                      "luma/box_topright.png",
                                      "luma/burst.png",
                                      "luma/checkerboard_small.png",
                                      "luma/clock.png",
                                      "luma/clock_clockwise12.png",
                                      "luma/clock_clockwise6.png",
                                      "luma/diag_bottomleft.png",
                                      "luma/diag_bottomright.png",
                                      "luma/diag_topleft.png",
                                      "luma/diag_topright.png",
                                      "luma/fourbox_in.png",
                                      "luma/fourbox_out.png",
                                      "luma/horizontal_barn_doors.png",
                                      "luma/horizontal_blinds.png",
                                      "luma/iris_circle.png",
                                      "luma/iris_rectangle.png",
                                      "luma/left_to_right.png",
                                      "luma/matrix_snake_toplefthorizontal.png",
                                      "luma/symmetric_clock.png"])],
      scripts = ["videoporama"],
      long_description = """
Videoporama is an application to make diaporama from images export in video file. It is written in Python using QT4 and the PyQt4 GUI toolkit.
"""          
      )