#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
import Image
import random
from math import *
from __builtin__ import hex as hexp
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from main_win import *
from statusconf import *
from about import *
from mplayer import *
from configuration import *
from GlobalDefines import *
from DefTextDlg import *
from DefZoomPointDlg import *
from lotDlg import *

# Debug
debug = False

class Gui_Main(QMainWindow,Ui_MainWindow) : #OK QT4
    def __init__(self, parent=None):
        super(Gui_Main, self).__init__(parent)
        self.setupUi(self)
    
    #domledom : Add resizeEvent signal
    def resizeEvent (self, event):
      self.emit(SIGNAL("resizeEvent(QResizeEvent)"),event)

class StatusConf(QDialog,Ui_statusconf) : #OK QT4
    def __init__(self, parent=None):
        super(StatusConf, self).__init__(parent)
        self.setupUi(self)

class Configuration(QDialog,Ui_Configuration) : #OK QT4
    def __init__(self, parent=None):
        super(Configuration, self).__init__(parent)
        self.setupUi(self)

class About(QDialog,Ui_about) : #OK QT4
    def __init__(self, parent=None):
        super(About, self).__init__(parent)
        self.setupUi(self)

class CFileDialogIMG(QFileDialog) :
    def addPreview(self) :
      layout=self.layout()
      vbox = QVBoxLayout()
      title = QGroupBox(self.tr("Image preview"))
      self.preview=QLabel()
      self.preview.setFixedWidth(120)
      vbox.addWidget(self.preview)
      vbox.addStretch()
      title.setLayout(vbox)
      layout.addWidget(title, 1, layout.columnCount())
      #Signaux et slots
      self.connect(self, SIGNAL("currentChanged(QString)"), self.showPreview)

    def showPreview(self, urlim) :
      if not os.path.isdir(unicode(urlim)) :
        prev = QPixmap(urlim)
        try : self.preview.setPixmap(prev.scaledToWidth(120))
        except : None

class stopObject(QLabel) :
    def __init__(self, boxItem, pix, idf, parent=None) :
      super(stopObject, self).__init__(parent)
      self.boxItem = boxItem
      self.setPixmap(pix)
      self.setScaledContents(True)
      self.idf = idf

    def getBoxItem(self) :
      return self.boxItem

    def setBoxItem(self, boxRect) :
      self.boxItem = boxRect

    def getIdf(self) :
      return self.idf

    def copy(self) :
      cp = stopObject(self.boxItem, self.pixmap(), self.idf)
      return cp

    def getProperties(self) :
      prop = unicode(self.idf)+u":"+unicode(self.boxItem.x())+u":"+unicode(self.boxItem.y())+u":"+unicode(self.boxItem.width())+u":"+unicode(self.boxItem.height())
      return prop

#-------------------------------------------------------------------------------------------------------------------------

class checkSoxEncoding(QWidget) :
  """checkSoxEncoding est une class pour vérifier les possibilités de Sox pour l'encodage du format mp2/mp3. Si ce n'est pas le cas, retourne 0 -> adaptation de l'interface pour supprimer ces possibilités"""
  def __init__(self, listeformat, parent=None) :
    super(checkSoxEncoding, self).__init__(parent)
    self.hide()
    self.listeFormat = listeformat
    self.parent = parent
    self.index = 0
    self.checkListeFormat = []

  def run(self) :
    self.soxP = QProcess(self.parent)
    self.connect(self.soxP, SIGNAL('finished(int)'), self.finProcess)
    self.write = 0
    commande = u"sox -n -t %s %s trim 00:00:00.000 00:00:01.000" % (self.listeFormat[self.index], os.path.expanduser("~")+os.sep+u"checkSoxEssai."+self.listeFormat[self.index])
    self.soxP.setProcessChannelMode(QProcess.MergedChannels)
    self.soxP.start(commande)

  def finProcess(self,statut) :
    # Test if the command has been correctly executed
    if not statut :
      # If OK -> Add the extension to the list of format which are supported in encoding by sox
      self.checkListeFormat.append((self.listeFormat[self.index],True))
      os.remove(os.path.expanduser("~")+os.sep+u"checkSoxEssai."+self.listeFormat[self.index])
    else :
      # if not OK, add the extension with status unusable
      self.checkListeFormat.append((self.listeFormat[self.index],False))
    # Incrémentation du compteur pour explorer tous les formats à tester
    self.index += 1
    # If the check process reach the end of the format list to test, send the end signal with the list
    if self.index == len(self.listeFormat) :
      self.emit(SIGNAL("checkSox"), self.checkListeFormat)
    else :
      self.run()


class QComboTable(QComboBox) :
    def __init__(self,row=-1,parent=None) :
      super(QComboTable,self).__init__(parent)
      self.row=row
      self.connect(self,SIGNAL("currentIndexChanged(int)"),self.sigChanged)

    def setRow(self,row) :
      self.row=row

    def sigChanged(self) :
      self.index=self.currentIndex()
      self.emit(SIGNAL("QCBchanged"),self.index,self.row)

#---------------------------------------------------------------------------------------------------------------------------------------------------------------

class ZoomPointItem(QLabel) :
    def __init__(self,x,y,w,h,timeFixe, zoom, timeToTravel, VideoporamaInstance,TextToAdd,NumZoomPoint,ImageItem,parent=None) :
      super(ZoomPointItem,self).__init__(parent)
      self.VideoporamaInstance = VideoporamaInstance
      self.VideoporamaInstance.StopMAJSpinbox = False

      self.x            = float(x)
      self.y            = float(y)
      self.w            = float(w)      # for render in the tablewidget
      self.h            = float(h)      # for render in the tablewidget
      self.zoom         = float(zoom)
      self.XMLText      = TextToAdd     # XML Document containing zoompoint text
      self.NumZoomPoint = NumZoomPoint  # Number of zoompoint item
      self.ImageItem    = ImageItem     # Image item (parent)
      self.CacheThumb   = None          # Cache of thumbnail to speed interface
      self.timeFixe = float(timeFixe)
      self.timeToTravel = float(timeToTravel)

    def updatePix(self) :
      if self.CacheThumb==None : self.CacheThumb=self.ImageItem.ToRenderImageForDisplay(self.NumZoomPoint,self.w,self.h,0,0,0,0,False,False,False)
      dessin=self.CacheThumb.copy()

      # Init a QPainter object
      p=QPainter(dessin)

      # Fill the area with lightGray or White backgroundcolor if is selected
      row=self.VideoporamaInstance.win.TableZoomPoint.currentRow()
      if row!=-1 : item=self.VideoporamaInstance.win.TableZoomPoint.cellWidget(row,0)
      else : item=None
      if (item==self) :
        #define a pen for the rectangle
        pen=QPen(QtCore.Qt.blue)
        pen.setWidth(6)
        p.setPen(pen)
        #draw select rectangle
        p.drawRect(QRect(0,0,self.w,self.h))
#        self.VideoporamaInstance.win.ZoomPointTimeFixe.setValue(self.timeFixe)
#        self.VideoporamaInstance.win.ZoomPointTimeTravel.setValue(self.timeToTravel)

      # Close QPainter object
      p.end()

      self.setPixmap(QPixmap.fromImage(dessin))

    def SetupInterface(self):
      if self.VideoporamaInstance.StopMAJSpinbox: return
      self.VideoporamaInstance.StopMAJSpinbox=True
      if self.VideoporamaInstance.ConfDisplayUnit=="0" :
        # Define the value and max value (in %)
        self.VideoporamaInstance.win.ZoomPointXValue.setRange(0,99-self.zoom)
        self.VideoporamaInstance.win.ZoomPointXValue.setValue(self.x*100)
        self.VideoporamaInstance.win.ZoomPointXValue.setSingleStep(int(100/20)) 
        self.VideoporamaInstance.win.ZoomPointYValue.setRange(0,99-self.zoom)
        self.VideoporamaInstance.win.ZoomPointYValue.setValue(self.y*100)
        self.VideoporamaInstance.win.ZoomPointYValue.setSingleStep(int(100/20)) 
        self.VideoporamaInstance.win.ZoomPointZoomValue.setRange(1,100)
        self.VideoporamaInstance.win.ZoomPointZoomValue.setValue(self.zoom)
        self.VideoporamaInstance.win.ZoomPointZoomValue.setSingleStep(int(100/20)) 
        # Setup label associated with each edit
        self.VideoporamaInstance.win.ZoomPointXLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.VideoporamaInstance.win.ZoomPointYLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.VideoporamaInstance.win.ZoomPointZoomLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
      else :
        # Define the value and max value (in pixel)
        w=self.ImageItem.xmax*self.zoom/100
        h=self.ImageItem.ymax*self.zoom/100
        self.VideoporamaInstance.win.ZoomPointXValue.setRange(0,self.ImageItem.xmax-w)
        self.VideoporamaInstance.win.ZoomPointXValue.setValue(self.x*self.ImageItem.xmax)
        self.VideoporamaInstance.win.ZoomPointXValue.setSingleStep(int(self.ImageItem.xmax/20))
        self.VideoporamaInstance.win.ZoomPointYValue.setRange(0,self.ImageItem.ymax-h)
        self.VideoporamaInstance.win.ZoomPointYValue.setValue(self.y*self.ImageItem.ymax)
        self.VideoporamaInstance.win.ZoomPointYValue.setSingleStep(int(self.ImageItem.ymax/20))
        self.VideoporamaInstance.win.ZoomPointZoomValue.setRange(1,self.ImageItem.xmax)
        self.VideoporamaInstance.win.ZoomPointZoomValue.setValue(self.ImageItem.xmax*(self.zoom/100)) 
        self.VideoporamaInstance.win.ZoomPointZoomValue.setSingleStep(int(self.ImageItem.xmax/20)) 
        # Setup label associated with each edit
        self.VideoporamaInstance.win.ZoomPointXLabel.setText("/"+unicode(int(self.ImageItem.xmax-w)))
        self.VideoporamaInstance.win.ZoomPointYLabel.setText("/"+unicode(int(self.ImageItem.ymax-h)))
        self.VideoporamaInstance.win.ZoomPointZoomLabel.setText("/"+unicode(int(self.ImageItem.xmax)))
 
      self.VideoporamaInstance.win.ZoomPointTimeFixe.setValue(self.timeFixe)
      self.VideoporamaInstance.win.ZoomPointTimeTravel.setValue(self.timeToTravel)
      self.VideoporamaInstance.StopMAJSpinbox=False

    def copy(self) :
      doc=Document()
      if self.XMLText!=None: newXML=doc.importNode(self.XMLText,True)
      else: newXML=None
      cp=ZoomPointItem(self.x,self.y,self.w,self.h,self.timeFixe,self.zoom,self.timeToTravel,self.VideoporamaInstance,newXML,self.NumZoomPoint,self.ImageItem)
 
      return cp

#---------------------------------------------------------------------------------------------------------------------------------------------------------------

class myLabel(QLabel) :
    #See render order on the ToRenderImage function
    imgwide        = 0                        #Image geometrie : 1=16/9
    StateSelected  = False                    #True if selected
    hpix           = 0                        #Height of the timeline
    wpix           = 0                        #Width of the timeline
    urlim          = ""                       #Filepath to the image
    time           = 0                        #Duration time
    bgfile         = ""                       #Background file
    bgcolor        = 0                        #Background color
    typet          = 0                        #Transition type
    opttransi      = 0                        #Transition option
    speedt         = 0                        #Transition duration
    NbrZoomPoint   = 0                        #Number Of ZoomPointItem
    ZoomPointList  = None                     #ZoomPointList XMLDocument
    CacheThumb     = None                     #Cache of Thumbnail to speed interface
    xmax           = -1                       #Size of the full image use by pixel display mode
    ymax           = -1                       #Size of the full image use by pixel display mode

    def __init__(self,urlim,bgfile,bgcolor,typet,opttransi,speedt,imgwide,VideoporamaInstance,parent=None) :
      super(myLabel,self).__init__(parent)
      self.VideoporamaInstance = VideoporamaInstance
      self.RealImageSizeWidth  = 0                    # Real image size
      self.RealImageSizeHeight = 0                    # Real image size
      self.ImageLoaded         = None                 # Cache image for display
      self.ImageCacheMovie     = None                 # Cache image for movie generation
      self.imgwide             = imgwide
      self.StateSelected       = False
      self.urlim               = urlim
      self.bgfile              = bgfile
      self.bgcolor             = bgcolor
      self.typet               = int(typet)
      self.opttransi           = int(opttransi)
      self.speedt              = speedt
      self.NbrZoomPoint        = 0
      self.CacheThumb          = None
      self.xmax                = -1
      self.ymax                = -1
      self.nbrFrame = 0
      self.XMLText=None

      #Init ZoomPointList to an empty XML
      self.ZoomPointList = Document()
      xmltag = self.ZoomPointList.createElement(u"ZoomPointTable")
      self.ZoomPointList.appendChild(xmltag)
      
    def copy(self) :
      cp=myLabel(self.urlim,self.bgfile,self.bgcolor,self.typet,self.opttransi,self.speedt,self.imgwide,self.VideoporamaInstance)
      cp.ZoomPointList=self.ZoomPointList
      cp.XMLText = self.XMLText
      cp.RealImageSizeWidth=self.RealImageSizeWidth
      cp.RealImageSizeHeight=self.RealImageSizeHeight
      cp.ImageLoaded=self.ImageLoaded.copy()
      cp.CacheThumb=self.CacheThumb.copy()
      cp.MakeTableZoomPointFromXML()
      return cp

    # Calc which number item is for this item
    def GetSeqNumber(self) :
      SeqNumber=0
      k=0
      while k<self.VideoporamaInstance.win.timeline.columnCount() :
        if self==self.VideoporamaInstance.win.timeline.cellWidget(0,k) : 
          SeqNumber=k
          k=self.VideoporamaInstance.win.timeline.columnCount() # Stop searching
        k=k+1
      if self==self.VideoporamaInstance.win.timeline.cellWidget(0,SeqNumber) :
        return SeqNumber
      else : return -1

    #add a zoompoint item and insert it in last position on the and in the xml (ZoomPointList)
    def AddZoomPointItem(self,x,y,timeFixe,zoom,timeToTravel=0.0, MakeList=True,MakeTableWidget=True,TextToAdd=None):
      w=self.VideoporamaInstance.win.TableZoomPoint.width()-18
      if self.imgwide == 1 : h=w*9/16
      else : h=w*3/4
      if MakeTableWidget: 
        count=self.VideoporamaInstance.win.TableZoomPoint.rowCount()
        ZoomPoint=ZoomPointItem(x,y,w,h,timeFixe, zoom,timeToTravel,self.VideoporamaInstance,TextToAdd,count,self)
        self.VideoporamaInstance.win.TableZoomPoint.insertRow(count)
        self.NbrZoomPoint+=1
        self.VideoporamaInstance.win.TableZoomPoint.setCellWidget(count,0,ZoomPoint)
        self.VideoporamaInstance.win.TableZoomPoint.setRowHeight(count,ZoomPoint.h)
        self.VideoporamaInstance.win.TableZoomPoint.repaint()
        if MakeList: 
          self.MakeXMLZoomPointList()
          self.VideoporamaInstance.win.TableZoomPoint.setCurrentCell(count,0)
      else:
        #Count number of item
        i=0
        while LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")!="": i+=1
        #Add new item
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",unicode(x),u"ZoomPointTable")
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"y",unicode(y),u"ZoomPointTable")
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"zoom",unicode(zoom),u"ZoomPointTable")
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeFixe",unicode(timeFixe),u"ZoomPointTable")
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeToTravel",unicode(timeToTravel),u"ZoomPointTable")
        if TextToAdd!=None:
          xmlPoint=self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(i))[0]
          xmlPoint.appendChild(TextToAdd)

        self.NbrZoomPoint+=1

    #Construct TableZoomPoint by scanning ZoomPointList
    def MakeTableZoomPointFromXML(self):
      #Clean TableZoomPoint
      i=0
      while i<self.VideoporamaInstance.win.TableZoomPoint.rowCount() : self.VideoporamaInstance.win.TableZoomPoint.removeRow(i)
      self.NbrZoomPoint=0
      i=0
      x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")
      while x!="":
        y   =LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"y",u"ZoomPointTable")
        zoom=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"zoom",u"ZoomPointTable")
        timeFixe = LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeFixe",u"ZoomPointTable")
        timeToTravel = LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeToTravel",u"ZoomPointTable")
         # Text
        xmlPoint=self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(i))[0]
        xmlText=xmlPoint.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText=xmlText[0]
          TextToAdd=Document()
          xmlRoot=TextToAdd.createElement(u"SaveXML")
          TextToAdd.appendChild(xmlRoot)
          xmlRoot.appendChild(self.ZoomPointList.importNode(xmlText,True))
        else:
          TextToAdd=None
        self.AddZoomPointItem(float(x),float(y),float(timeFixe),float(zoom), float(timeToTravel),False,True,TextToAdd)

        i+=1
        x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")

    #Construct ZoomPointList by scanning TableZoomPoint
    def MakeXMLZoomPointList(self):
      self.ZoomPointList = Document()
      xmltag = self.ZoomPointList.createElement(u"ZoomPointTable")
      self.ZoomPointList.appendChild(xmltag)
      i=0
      while i<self.VideoporamaInstance.win.TableZoomPoint.rowCount():
        item=self.VideoporamaInstance.win.TableZoomPoint.cellWidget(i,0)
        if item!=None : 
          UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",unicode(item.x),u"ZoomPointTable")
          UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"y",unicode(item.y),u"ZoomPointTable")
          UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"zoom",unicode(item.zoom),u"ZoomPointTable")
          UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeFixe",unicode(item.timeFixe),u"ZoomPointTable")
          UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeToTravel",unicode(item.timeToTravel),u"ZoomPointTable")
          # Text
          if item.XMLText!=None:
            xmlPoint=self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(i))[0]
            xmlText=item.XMLText.getElementsByTagName(u"Text")
            if xmlText.length>0 :
              xmlText=xmlText[0]
              TextToAdd=item.XMLText.importNode(xmlText,True)
              xmlPoint.appendChild(TextToAdd)
        i+=1

    def ResetThumb(self):
      i=0
      while (i<self.VideoporamaInstance.win.TableZoomPoint.rowCount()):
        self.VideoporamaInstance.win.TableZoomPoint.cellWidget(i,0).CacheThumb=None
        self.VideoporamaInstance.win.TableZoomPoint.cellWidget(i,0).updatePix()
        i+=1
      self.CacheThumb=None
      self.ImageLoaded=None
      self.updatePix()
      
    def updatePix(self) :
      hpix=self.VideoporamaInstance.win.timeline.height()-18
      if self.imgwide == 1 : wpix=(hpix-4)*16/9+34
      else : wpix=(hpix-4)*4/3+34

      dessin=QPixmap(wpix,hpix)
      
      # Init a QPainter object
      p=QPainter(dessin)
      
      # Fill the area with lightGray or White backgroundcolor if is selected
      p.fillRect(QRect(0,0,wpix,hpix), QColor(QtCore.Qt.lightGray))

      # Display the rendered image
      if self.CacheThumb==None:
        Image=self.ToRenderImageForDisplay(0,wpix-38,hpix-4,0,0,0,0,False,False,False)
        self.CacheThumb=Image
      else: Image=self.CacheThumb
      p.drawImage(2,2,Image)

      # Display the image time and transition time
      p.setFont(QtGui.QFont('Decorative', 7))
      timeT    = self.CalcImageTime()[0]
      p.setPen(QtCore.Qt.black)
      AffDuree = u"%.2f s" % float(timeT)
      p.drawText(QRectF(wpix-35, 38, 33,10), QtCore.Qt.AlignCenter | QtCore.Qt.AlignTop, AffDuree)

      # Display border around image
      p.setPen(QtCore.Qt.black)
      p.drawLine(2, 2, wpix-38+2, 2)
      p.drawLine(wpix-38+2, 2, wpix-38+2, hpix-2)
      p.drawLine(wpix-38+2, hpix-2, 2, hpix-2)
      p.drawLine(2, hpix-2, 2, 2)

      # Define the transition icon name
      if (self.typet==7):
        b=lumaList()[1]
        FNameTr="iconstr/"+b[int(self.opttransi)]
      else:
        FNameTr="iconstr/tr-0"+unicode(self.typet)+"-0"+unicode(self.opttransi)+".png"

      try: # Add transition icon
        pixTr=QImage(FNameTr)
        p.drawImage(wpix-35+1, 2, pixTr)
      except:
        None
       
      # Display image file name
      filename= basename = self.urlim.split('/')[-1]
      p.setPen(QtGui.QColor(0,0,0))
      p.drawText(QRectF(5, hpix-30-3, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)
      p.drawText(QRectF(3, hpix-30-3, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)
      p.drawText(QRectF(5, hpix-30-5, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)
      p.drawText(QRectF(3, hpix-30-5, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)
      p.setPen(QtGui.QColor(255,255,255))
      p.drawText(QRectF(4, hpix-30-4, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)

      # Display Zoom icon if zoom is define
      if self.NbrZoomPoint >= 2 :
        zico = QImage("icons/zoom.jpg")
        p.drawImage(5, 5, zico)

      if (self.StateSelected==True) :
        #define a pen for the rectangle
        pen=QPen(QtCore.Qt.blue)
        pen.setWidth(6)
        p.setPen(pen)
        #draw select rectangle
        p.drawRect(QRect(0,0,wpix,hpix))

      # Close QPainter object  
      p.end()
      self.setPixmap(dessin)

    #-------------------------------------------------------------------------------------------------------------
    # Render functions
    #-------------------------------------------------------------------------------------------------------------
    #ToRenderImageForMovie use self.ImageCacheMovie as cache image with no max
    #Cache image must be free as soon as possible !
    #-------------------------------------------------------------------------------------------------------------
    def ToRenderImageForMovie(self,NumZoomPoint,OuputWidth,OutputHeight,fx=0,fy=0,fw=0,fh=0,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=False):
      # Be sure size are float
      OuputWidth  =float(OuputWidth)
      OutputHeight=float(OutputHeight)

      # Load source image from disk and prepare it with background and correct geometry
      # and calcul xmax and ymax for pixel display mode
      if self.ImageCacheMovie==None:
        self.ImageCacheMovie,tempxmax,tempymax=LoadAndPrepareImage(self.urlim,self.VideoporamaInstance.ConfAutoRotate,self.bgfile,self.bgcolor,self.imgwide)
      SourceImage=self.ImageCacheMovie.copy()

      # Apply image text item
      if DontRenderImageText==False and self.XMLText!=None : SourceImage=ApplyTextToQImage(SourceImage,self.XMLText.getElementsByTagName(u"SaveXML")[0])

      # Scale source image using ZoomPoint if needed
      if StopAtFullImage==False and NumZoomPoint!=-1:
        #Crop image to zoompoint rectangle (if needed)
        x   =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"x",u"ZoomPointTable"))
        y   =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"y",u"ZoomPointTable"))
        zoom=float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"zoom",u"ZoomPointTable"))/100
        if (x!=0 or y!=0 or zoom!=1):
          SourceImage=SourceImage.copy(x*float(SourceImage.width()),y*float(SourceImage.height()),zoom*float(SourceImage.width()),zoom*float(SourceImage.height()))
        
      if StopAtFullImage and NumZoomPoint!=-1 :
        SourceImage = SourceImage.copy(fx, fy, fw, fh) 

      # Scale image to correct size (aspect ratio must be correct !)
      SourceImage=SourceImage.scaled(OuputWidth,OutputHeight,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)

      # Apply Zoompoint text item
      if DontRenderZoomPointText==False:
        SourceImage=ApplyTextToQImage(SourceImage,self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(NumZoomPoint))[0])

      return SourceImage
    #-------------------------------------------------------------------------------------------------------------
    #ToRenderImageForDisplay use self.ImageLoaded as cache image with a max à 720 row
    #Cache image stay valid all time
    #-------------------------------------------------------------------------------------------------------------
    def ToRenderImageForDisplay(self,NumZoomPoint,OuputWidth,OutputHeight,fx=0,fy=0,fw=0,fh=0,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=False):
      # Be sure size are float
      OuputWidth  =float(OuputWidth)
      OutputHeight=float(OutputHeight)

      # Load source image from disk and prepare it with background and correct geometry
      # and calcul xmax and ymax for pixel display mode
      if self.ImageLoaded==None:
        self.ImageLoaded,self.xmax,self.ymax=LoadAndPrepareImage(self.urlim,self.VideoporamaInstance.ConfAutoRotate,self.bgfile,self.bgcolor,self.imgwide)
        self.RealImageSizeWidth=self.xmax
        self.RealImageSizeHeight=self.ymax
        # For memory and speed, be sure cache image is not >720 pt
        if self.ymax>720:
          if self.imgwide==1 :
            self.xmax=1280
            self.ymax=720
          else :
            self.xmax=960
            self.ymax=720
          self.ImageLoaded=self.ImageLoaded.scaled(self.xmax,self.ymax,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
      SourceImage=self.ImageLoaded.copy()

      # Apply image text item
      if DontRenderImageText==False and self.XMLText!=None : SourceImage=ApplyTextToQImage(SourceImage,self.XMLText.getElementsByTagName(u"SaveXML")[0])

      # Scale source image using ZoomPoint if needed
      if StopAtFullImage==False and NumZoomPoint!=-1:
        #Crop image to zoompoint rectangle (if needed)
        x   =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"x",u"ZoomPointTable"))
        y   =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"y",u"ZoomPointTable"))
        zoom=float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"zoom",u"ZoomPointTable"))/100
        if (x!=0 or y!=0 or zoom!=1): SourceImage=SourceImage.copy(x*float(SourceImage.width()),y*float(SourceImage.height()),zoom*float(SourceImage.width()),zoom*float(SourceImage.height()))
        
      if StopAtFullImage and NumZoomPoint!=-1 :
        SourceImage = SourceImage.copy(fx, fy, fw, fh) 

      # Scale image to correct size (aspect ratio must be correct !)
      SourceImage=SourceImage.scaled(OuputWidth,OutputHeight,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)

      # Apply Zoompoint text item
      if DontRenderZoomPointText==False: SourceImage=ApplyTextToQImage(SourceImage,self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(NumZoomPoint))[0])

      return SourceImage

    #-------------------------------------------------------------------------------------------------------------
    # Function to calc time and transition time in frame and in second
    #-------------------------------------------------------------------------------------------------------------
    def CalcImageTime(self, imgpsec=25) :
      ItemNumber = self.GetSeqNumber()                          # Current item number

      if ItemNumber==-1: return 0,0,0,0,0,0                     # When empty timeline, ItemNumber is -1

      SeqTime    = float(0)                                     # SeqTime = total time in second
      dicspeed   = {"0":4,"1":2,"2":1,"3":0.8,"4":0.4,"5":0.2}  # Transition duration in second

      # Special case for NTSC
      if imgpsec==30 : ips = float(30000/1001)
      else :           ips = float(imgpsec)

      # Calc in transition time
      if ItemNumber>0:
        PrevItem  =self.VideoporamaInstance.win.timeline.cellWidget(0,ItemNumber-1)
        if PrevItem!=None:
          PrevTypeT =PrevItem.typet
          PrevSpeedT=PrevItem.speedt
          if PrevTypeT < 1 :
            InTrTime   =float(0)     # InTrTime     = IN transition time in second
            InTrFramNbr=float(0)     # InTrFramNbr  = number of IN transition frame
          else :
            InTrTime   =float(dicspeed[unicode(PrevItem.speedt)])  # InTrTime    = IN transition time in second
            InTrFramNbr=ips*InTrTime                               # InTrFramNbr = number of IN transition frame
        else :
          InTrTime   =float(0)
          InTrFramNbr=float(0)
      else:
        # Special case for first transition
        InTrTime   =float(dicspeed[unicode("1")])     # InTrFramNbr  = number of IN transition frame
        InTrFramNbr=ips*InTrTime                      # InTrTime     = IN transition time in second

      # Calc out transition time
      if self.typet < 1 :
        OutTrTime   =float(0)     # OutTrTime     = OUT transition time in second
        OutTrFramNbr=float(0)     # OutTrFramNbr  = number of OUT transition frame
      else :
        OutTrTime   =float(dicspeed[unicode(self.speedt)])  # OutTrTime    = OUT transition time in second
        OutTrFramNbr=ips*OutTrTime                          # OutTrFramNbr = number of OUT transition frame

      # Calc real sequence time
      i=0
      x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")
      while x!="":
        SeqTime=SeqTime+float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeFixe",u"ZoomPointTable"))
        if i!=0: SeqTime=SeqTime+float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeToTravel",u"ZoomPointTable"))
        i += 1
        x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")

      # Adjust sequence time for the two transitions was full
      if SeqTime<(InTrTime+OutTrTime) : SeqTime=InTrTime+OutTrTime

      SeqFramNbr=int(SeqTime*ips)    # SeqFramNbr = number of frame to show sequence
      return (SeqTime,int(SeqFramNbr),InTrTime,int(InTrFramNbr),OutTrTime,int(OutTrFramNbr))

    #-------------------------------------------------------------------------------------------------------------
    # Function to generate a specific frame base on frame number
    #    frameNbr = number of wanted frame (from 0 to number of frame with this image source)
    #    outputW = Width of output image
    #    outputH = Height of output image
    #    frImg = number of frame to show image without transition
    #    frTransi = Current transition position (from 0 to number of frame in transition periode)
    #    Return an image in PIL format"""
    #-------------------------------------------------------------------------------------------------------------
    def getFrameImage(self,imgpsec,frameNbr,outputW,outputH,IsPreview=False) :
      if IsPreview==False:
        #Be sur imageCacheMovie is ok
        if self.ImageCacheMovie==None:
          self.ImageCacheMovie,tempxmax,tempymax=LoadAndPrepareImage(self.urlim,self.VideoporamaInstance.ConfAutoRotate,self.bgfile,self.bgcolor,self.imgwide)

      time                 = 0
      CurrentZoomPoint     = 0
      SeqFrameStart        = 0
      SeqFrameDuration     = 0
      CurrentAnimationPart = 0

      # if first static shot duration is 0 : go to 2nd mobile shot
      TestTime1=int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"timeFixe",u"ZoomPointTable")))
      if TestTime1==0: TestTime2=int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint+1),u"timeFixe",u"ZoomPointTable")))
      else: TestTime2=0
      if TestTime1==0 and frameNbr<=TestTime2:
        CurrentZoomPoint    =1
        CurrentAnimationPart=1
        SeqFrameStart       =time
        SeqFrameDuration    =int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"timeToTravel",u"ZoomPointTable")))
        time                +=SeqFrameDuration
      else :
        x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"x",u"ZoomPointTable")
        while x!="" and frameNbr>time :
          # start by animated plan
          if CurrentZoomPoint!=0:
            CurrentAnimationPart=1
            SeqFrameStart    =time
            SeqFrameDuration =int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"timeToTravel",u"ZoomPointTable")))
            time            +=SeqFrameDuration
          # Check if we need to continu
          if frameNbr>time :
            # fixe plan
            CurrentAnimationPart=0
            SeqFrameStart    =time
            SeqFrameDuration =int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"timeFixe",u"ZoomPointTable")))
            time            +=SeqFrameDuration
            #Check if we need to continu
            if frameNbr>time :
              x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint+1),u"x",u"ZoomPointTable")
              #if x=="" then we have reach the last frame for this sequence 
              if x!="" :
                CurrentZoomPoint += 1
            else:
              x=""
          else:
            x=""
        
      # If nothing found
      if CurrentAnimationPart==0 : # Fixe part
        # Render zoompoint with text (if exist)
        if IsPreview==False: img = self.ToRenderImageForMovie(CurrentZoomPoint,outputW,outputH,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=False)
        else :               img = self.ToRenderImageForDisplay(CurrentZoomPoint,outputW,outputH,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=False)
      else : # Mobile part
        # Get value from prev zoompoint to this zoompoint
        if IsPreview==False:
          start   = self.GetXYWH(CurrentZoomPoint-1,self.ImageCacheMovie.width(),self.ImageCacheMovie.height())
          end     = self.GetXYWH(CurrentZoomPoint,self.ImageCacheMovie.width(),self.ImageCacheMovie.height())
        else :
          start   = self.GetXYWH(CurrentZoomPoint-1,self.ImageLoaded.width(),self.ImageLoaded.height())
          end     = self.GetXYWH(CurrentZoomPoint,self.ImageLoaded.width(),self.ImageLoaded.height())

        progImg = float(frameNbr-SeqFrameStart)/float(SeqFrameDuration)

        # Coordinate intermediaire
        Xi = (end[0]-start[0])*progImg +start[0]
        Yi = (end[1]-start[1])*progImg +start[1]
        Wi = (end[2]-start[2])*progImg +start[2]
        Hi = (end[3]-start[3])*progImg +start[3]

        # Render zoompoint without text (StopAtFullImage=True)
        if IsPreview==False: img = self.ToRenderImageForMovie(CurrentZoomPoint,outputW,outputH,Xi,Yi,Wi,Hi,StopAtFullImage=True,DontRenderImageText=False,DontRenderZoomPointText=True)
        else :               img = self.ToRenderImageForDisplay(CurrentZoomPoint,outputW,outputH,Xi,Yi,Wi,Hi,StopAtFullImage=True,DontRenderImageText=False,DontRenderZoomPointText=True)

      return QImageToPil(img)

    def GetXYWH(self,NumZoomPoint,xmax,ymax):
      x    =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"x",u"ZoomPointTable"))*xmax
      y    =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"y",u"ZoomPointTable"))*ymax
      zoom =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"zoom",u"ZoomPointTable"))/100
      w    =zoom*xmax
      h    =zoom*ymax
      return x,y,w,h
