
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_APP_CONTROLLER
#define _H_APP_CONTROLLER

#include <Foundation/NSObject.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSNotification.h>

#include "DocumentWindowController.h"
#include "ViewPDFDocument.h"


@interface AppController : NSObject
{
   NSDictionary* papersizesPlist;
   id            prefsController;
}

-(id) init;
-(void) dealloc;
+ (void) initialize;
+ (AppController*) sharedController;

- (void) applicationDidFinishLaunching: (NSNotification *) aNotification;
- (void) applicationWillFinishLaunching: (NSNotification *) aNotification;

- (DocumentWindowController*)
  createAndDisplayWindowForDocument: (ViewPDFDocument*)aDocument;

- (void) showPrefs: (id)sender;
- (void) setPrefsController: (id)controller;

- (NSDictionary*) papersizes;

@end

#endif
