
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL


#include "DocumentWindowController.h"

#include "AppController.h"
#include "DocumentWindow.h"

#include <Foundation/NSBundle.h>
#include <Foundation/NSException.h>
#include <Foundation/NSString.h>
#include <AppKit/NSNibLoading.h>
#include <AppKit/NSWindow.h>
#include <AppKit/NSTableView.h>
#include <AppKit/NSOutlineView.h>

/*
 * Non-Public methods.
 */
@interface DocumentWindowController(OutlinePrivate)
@end


/*
 * An adapter to use the document's outline as data source
 * for the outline view.
 */
@interface OutlineDataSourceAdapter : NSObject
{
   NSArray* rootItems;
}

- (id) initWithRootItems: (NSArray*)items;
- (void) dealloc;

@end


@implementation OutlineDataSourceAdapter

- (id) initWithRootItems: (NSArray*)items
{
   if ((self = [super init]))
   {
      rootItems = [items retain];
   }

   return self;
}


- (void) dealloc
{
   //NSLog(@"dealloc OutlineDataSourceAdapter");

   [rootItems release];
   [super dealloc];
}


- (int) outlineView: (NSOutlineView *)outlineView numberOfChildrenOfItem: (id)item
{
   if (!item)
   {
      return [rootItems count];
   }
   
   return [(PDFOutlineItem*)item countKids];
}


- (id) outlineView: (NSOutlineView *)outlineView child: (int)index ofItem: (id)item
{
   NSArray* items;

   if (!item)
   {
      items = rootItems;
   }
   else
   {
      items = [(PDFOutlineItem*)item kids];
   }

   return [items objectAtIndex: index];
}


- (BOOL) outlineView: (NSOutlineView *)outlineView isItemExpandable: (id)item
{
   return ([(PDFOutlineItem*)item countKids] > 0);
}


- (id) outlineView: (NSOutlineView *)outlineView 
objectValueForTableColumn: (NSTableColumn *)tableColumn
            byItem:(id)item
{
   return [(PDFOutlineItem*)item title];
}

@end


/*
 * the part of DocumentWindowController that supports
 * document outlines.
 */
@implementation DocumentWindowController(Outline)

/*
 * Display a Panel that display the document outline in
 * a tree structure.
 */
- (void) showOutlinePanel: (id)sender
{
   NSAssert([[self pdfDocument] hasOutline], @"document has no outline");

   if (!outlinePanel)
   {
      [NSBundle loadNibNamed: @"outline.gorm" owner: self];
   }

   NSAssert(outlinePanel, @"could not load find panel");

   [outlinePanel setTitle: [NSString stringWithFormat: @"%@ (%@)",
                                     [outlinePanel title],
                                     [(NSWindow*)[self window] title]]];


   NSAssert(outlineView, @"outlineView is not connected");

   outlineDataSource =
      [[OutlineDataSourceAdapter alloc] initWithRootItems:
                                           [[[self pdfDocument] outline] items]];
   [outlineView setDataSource: outlineDataSource];

   [outlineView setDoubleAction: @selector(outlineItemSelected:)];

   [outlinePanel orderFrontRegardless];
   [outlinePanel makeKeyWindow];
   [outlinePanel display];   
}


- (void) outlineItemSelected: (id)sender
{
   id  outlineItem;

   if ([outlineView selectedRow] == -1)
   {
      return;
   }

   outlineItem = [outlineView itemAtRow: [outlineView selectedRow]];
   NSAssert(outlineItem, @"selected item is nil");

   if ([outlineItem destinationPage])
   {
      [self setCurrentPage: [outlineItem destinationPage]];
   }
   else
   {
      NSRunAlertPanel(@"Invalid Destination",
                      @"The destination of the selected outline item is invalid.",
                      @"Continue",
                      nil,
                      nil);
   }
}


@end
