
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_IMAGE_WINDOW_CONTROLLER
#define _H_IMAGE_WINDOW_CONTROLLER

#include <Foundation/NSArray.h>
#include <Foundation/NSNotification.h>
#include <Foundation/NSGeometry.h>
#include <Foundation/NSLock.h>
#include <AppKit/NSWindowController.h>
#include <AppKit/NSTextField.h>
#include <AppKit/NSTableView.h>
#include <AppKit/NSButton.h>

#include <PDFKit/PDFDocument.h>

#include "ViewPDFDocument.h"
#include "DocumentWindow.h"
#include "DocumentPosition.h"


#define ZOOM_STEP                   0.1
#define PAGE_ORIENTATION_LANDSCAPE  @"Landscape"
#define PAGE_ORIENTATION_PORTRAIT   @"Portrait"
#define DEFAULT_PAPERSIZE           @"Default"
#define USER_DEFINED_PAPERSIZE      @"Userdefined"
#define SCROLL_UP                   +1
#define SCROLL_DOWN                 -1
#define SCROLL_LEFT                 -1
#define SCROLL_RIGHT                +1
#define TAG_PORTRAIT                1
#define TAG_LANDSCAPE               2


@interface DocumentWindowController : NSWindowController
{
   int                currentPage;
   double             scaleFactor;
   BOOL               documentIsDisplayed;
   NSMutableArray*    bookmarks;
   DocumentPosition*  contentSelection;
   NSString*          currentPaperSizeName;
   NSSize             currentPaperSize;
   int                currentPageOrientation;

   id               findPanel;
   NSTextField*     searchText;
   NSTextField*     searchPageLabel;
   NSTextField*     pageCurrentlySearched;
   NSTextField*     ofLabel;
   NSTextField*     totalPagesToSearch;
   NSButton*        findButton;
   NSString*        lastSearchText;
   NSTableView*     matchesTable;
   int              currentMatch;
   NSMutableArray*  matches;
   NSLock*          matchesLock;
   NSLock*          findInProgressLock;
   BOOL             findInProgress;

   id               pageLayoutPanel;
   id               paperSizesPopup;
   id               pageWidthText;
   id               pageHeightText;
   id               pageOrientationButtons;

   id               outlinePanel;
   id               outlineView;
   id               outlineDataSource;
}

- (id) initWithWindow: (NSWindow*)win;
- (void) dealloc;

- (void) setCurrentPage: (int)pageNum;
- (int)currentPage;

- (void) windowDidBecomeMain: (NSNotification*)aNotification;
- (void) windowWillClose: (NSNotification *)aNotification;

- (void) controlTextDidEndEditing: (NSNotification*)aNotification;
- (BOOL) validateMenuItem: (id)menuItem;

- (void) sizePageToMax;
- (void) setScaleFactor: (double)factor;
- (NSSize) scalePageToFitIn: (NSSize)size;
- (double) scaleFactor;

// actions
- (void) copy: (id)sender;
- (void) firstPage: (id)sender;
- (void) nextPage: (id)sender;
- (void) previousPage: (id)sender;
- (void) lastPage: (id)sender;
- (void) scrollVertical: (id)sender direction: (int)direction;
- (void) scrollHorizontal: (id)sender direction: (int)direction;
- (void) scrollPage: (id)sender direction: (int)direction;
- (void) zoomIn: (id)sender;
- (void) zoomOut: (id)sender;
- (void) zoomToRealSize: (id)sender;
- (void) sizePageToFit: (id)sender;
- (void) sizePageToFitWidth: (id)sender;
- (void) setBookmark: (id)sender;
- (void) gotoLastBookmark: (id)sender;
- (void) toggleToolbarVisible: (id)sender;
@end


@interface DocumentWindowController(PageLayout)
- (void) showPageLayoutPanel: (id)sender;
- (void) paperSizeSelected: (id)sender;
- (void) applyPageLayout: (id)sender;
@end


@interface DocumentWindowController(Find)
- (void) showFindPanel: (id)sender;
- (void) findPrevious: (id)sender;
- (void) findNext: (id)sender;
- (void) findAll: (id)sender;
- (void) cancelSearch: (id)sender;
- (void) findAllOrCancel: (id)sender;
- (void) gotoSelectedMatch: (id)sender;
@end


@interface DocumentWindowController(Outline)
- (void) showOutlinePanel: (id)sender;
@end


@interface DocumentWindowController(Internal)
- (void) updatePageImage;
- (void) outlineItemSelected: (id)sender;
- (PDFDocument*) pdfDocument;
- (PDFContentView*) pdfContentView;
- (void) setContentSelection: (DocumentPosition*)newSelection;
- (DocumentPosition*) contentSelection;
@end


#endif
