
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_EXTENDED_SCROLLVIEW
#define _H_EXTENDED_SCROLLVIEW

#include <AppKit/NSScrollView.h>

// we use forward declarations here because
// Cocoas header files seem to be not include-safe.
@class NSTextField;
@class NSView;
@class NSButton;


@interface ExtendedScrollView : NSScrollView
{
   NSView*       controlsView;
   NSTextField*  pageField;
   NSButton*     firstPageButton;
   NSButton*     nextPageButton;
   NSButton*     prevPageButton;
   NSButton*     lastPageButton;
   BOOL          displayPageControls;
}

- (id) initWithFrame: (NSRect)frame;
- (void) dealloc;

- (void) tile;

- (void) setDisplayPageControls: (BOOL)displayControls;
- (BOOL) displayPageControls;

// outlets
- (NSButton*) firstPageButton;
- (NSButton*) nextPageButton;
- (NSButton*) prevPageButton;
- (NSButton*) lastPageButton;
- (NSTextField*) pageField;

@end

#endif
