// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#include "PrefsController.h"
#include "AppController.h"
#include "ViewPDF.h"

#include <Foundation/NSDictionary.h>
#include <Foundation/NSUserDefaults.h>
#include <Foundation/NSString.h>
#include <Foundation/NSValue.h>
#include <AppKit/NSTextField.h>
#include <AppKit/NSButton.h>

/*
 * Non-Public methods.
 */
@interface PrefsController(Private)
@end


/*
 * Controller for the ViewPDF preferences.
 */
@implementation PrefsController

- (id) init
{
   if (self = [super init])
   {
      // ...
   }
   
   return self;
}



- (void) dealloc
{
   [super dealloc];
}


- (void) awakeFromNib
{
   [self setupPrefs: nil];
}


- (id) window
{
   return window;
}


- (void) windowWillClose: (NSNotification*)aNotification
{
   [self applyPrefs: nil];
}


- (void) applyPrefs: (id)sender
{
   NSUserDefaults* defs = [NSUserDefaults standardUserDefaults];

   // save preferences
}


- (void) setupPrefs: (id)sender
{
   NSUserDefaults* defs = [NSUserDefaults standardUserDefaults];

   [[AppController sharedController] setPrefsController: self];
}


@end
